/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.rac.executor;

import com.oscar.Driver;
import com.oscar.core.BaseConnection;
import com.oscar.jdbc.ExceptionUtil;
import com.oscar.jdbc.OscarJdbc2RacConnection;
import com.oscar.jdbc.OscarStatementV2;
import java.sql.SQLException;

public class RacStatementV2
extends OscarStatementV2 {
    private boolean hasConnect = false;

    public RacStatementV2(BaseConnection baseConnection) {
        super(baseConnection);
    }

    public RacStatementV2(BaseConnection baseConnection, String string) throws SQLException {
        super(baseConnection, string);
    }

    @Override
    protected boolean executeStatement() throws SQLException {
        try {
            return super.executeStatement();
        }
        catch (SQLException sQLException) {
            if (this.connection.getAutoCommit() && this.hasConnect) {
                return this.executeStatement();
            }
            throw sQLException;
        }
    }

    @Override
    protected void checkConnectionClosed(Exception exception) {
        switch (ExceptionUtil.isConnectionClosed(exception)) {
            case 1: 
            case 2: {
                try {
                    this.hasConnect = false;
                    this.reConnect();
                    this.hasConnect = true;
                    return;
                }
                catch (Exception exception2) {
                    Driver.writeLog("rac change connection fail:" + exception2.getMessage());
                    return;
                }
            }
        }
        this.hasConnect = false;
    }

    private void reConnect() throws SQLException {
        ((OscarJdbc2RacConnection)this.connection).reConnect(this.connection.getConnectionProperties());
        this.initParams();
    }
}

