/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.sql;

public class Time
extends java.sql.Time {
    private static final long serialVersionUID = 2761880807538277795L;
    private int nanos;
    private int zone = 15;
    private String nanosString = "";
    private StringBuilder zoneString = new StringBuilder(10);

    public Time(long l2) {
        super(l2);
        this.computeZoneString();
    }

    public Time(int n2, int n3, int n4) {
        super(n2, n3, n4);
        this.computeZoneString();
    }

    public static Time valueOf(String string) {
        return new Time(java.sql.Time.valueOf(string).getTime());
    }

    public void setNanos(int n2) {
        if (n2 > 999999999 || n2 < 0) {
            throw new IllegalArgumentException("nanos > 999999999 or < 0");
        }
        this.nanos = n2;
        this.computeNanosString();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        if (!"".equals(this.nanosString)) {
            stringBuffer.append(".").append(this.nanosString);
        }
        stringBuffer.append((CharSequence)this.zoneString);
        return stringBuffer.toString();
    }

    public void setZone(int n2) {
        this.zone = n2;
        this.computeZoneString();
    }

    private void computeNanosString() {
        if (this.nanos != 0) {
            Object object = "000000000";
            this.nanosString = Integer.toString(this.nanos);
            this.nanosString = ((String)object).substring(0, 9 - this.nanosString.length()) + this.nanosString;
            object = new char[this.nanosString.length()];
            this.nanosString.getChars(0, this.nanosString.length(), (char[])object, 0);
            int n2 = 8;
            while (object[n2] == 48) {
                --n2;
            }
            this.nanosString = new String((char[])object, 0, n2 + 1);
        }
    }

    private void computeZoneString() {
        if (this.zone != 15 && this.zone != 0) {
            int n2 = this.zone / 3600;
            if (-10 < n2 && n2 < 0) {
                this.zoneString.append("-0").append(-n2);
            } else if (n2 >= 0 && n2 < 10) {
                this.zoneString.append("+0").append(n2);
            } else if (n2 >= 10) {
                this.zoneString.append("+").append(n2);
            } else if (n2 <= -10) {
                this.zoneString.append(n2);
            }
            this.zoneString.append(":");
            n2 = this.zone % 3600 / 60;
            if (n2 < 0) {
                n2 = -n2;
            }
            if (n2 >= 0 && n2 < 10) {
                this.zoneString.append("0");
            }
            this.zoneString.append(n2);
            return;
        }
        if (this.zone == 0) {
            this.zoneString.append(" +00:00");
        }
    }

    public int getZone() {
        return this.zone;
    }

    public String getZoneString() {
        return this.zoneString.toString();
    }

    public int getNanos() {
        return this.nanos;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

