/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.ssl;

import com.oscar.Config;
import com.oscar.util.OSQLException;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.Provider;
import java.sql.SQLException;

public class BouncyCastlePrivateKeyFactory {
    public static Provider initBouncyCastleProvider() throws SQLException {
        String string = "org.bouncycastle.jce.provider.BouncyCastleProvider";
        try {
            Class<?> clazz = Class.forName(string);
            clazz = clazz.newInstance();
            return (Provider)((Object)clazz);
        }
        catch (Exception exception) {
            try {
                Provider provider = BouncyCastlePrivateKeyFactory.loadProvider(string);
                if (provider == null) {
                    throw new OSQLException("Could not found bouncycastle provider, please load bcprov-jdk15on jar package manually", "");
                }
                return provider;
            }
            catch (Exception exception2) {
                throw new OSQLException("Could not found bouncycastle provider, please load bcprov-jdk15on jar package manually", "");
            }
        }
    }

    private static Provider loadProvider(String string) throws Exception {
        Object object;
        Object object2;
        try {
            object2 = Config.class.getProtectionDomain().getCodeSource().getLocation();
            object = new URI(object2.getProtocol(), object2.getHost(), object2.getPath(), object2.getQuery(), null).getPath();
            object = URLDecoder.decode((String)object, "utf-8");
        }
        catch (Exception exception) {
            object = ".";
        }
        object2 = null;
        if (object != null) {
            if (((String)object).endsWith("/") || ((String)object).endsWith("\\")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if (((String)object).endsWith(".jar")) {
                int n2 = ((String)object).lastIndexOf("/");
                if (n2 != -1) {
                    object = ((String)object).substring(0, n2);
                }
                object2 = object;
            } else {
                object2 = (String)object + File.separator + "..";
            }
        }
        if (object2 != null && (object2 = new File((String)object2).listFiles()) != null) {
            object = object2;
            int n3 = ((File[])object2).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object3 = object[i2];
                if (!((File)object3).getName().startsWith("bcprov-jdk15on")) continue;
                return BouncyCastlePrivateKeyFactory.dynamicLoadJdbc(((File)object3).getAbsolutePath(), string);
            }
        }
        return null;
    }

    private static Provider dynamicLoadJdbc(String clazz, String string) throws Exception {
        clazz = new File((String)((Object)clazz)).toURI().toURL();
        clazz = new URLClassLoader(new URL[]{clazz});
        clazz = ((ClassLoader)((Object)clazz)).loadClass(string);
        clazz = clazz.newInstance();
        return (Provider)((Object)clazz);
    }
}

