/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.ssl;

import com.oscar.util.OSQLException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.Socket;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.SQLException;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import sun.misc.BASE64Decoder;

public class LazyKeyManager
implements X509KeyManager {
    private X509Certificate[] cert = null;
    private PrivateKey key = null;
    private final String certfile;
    private final String keyfile;
    private final boolean defaultfile;
    private OSQLException error = null;
    private final String password;

    public LazyKeyManager(String string, String string2, String string3, boolean bl) {
        this.certfile = string;
        this.keyfile = string2;
        this.defaultfile = bl;
        this.password = string3;
    }

    public void throwKeyManagerException() throws OSQLException {
        if (this.error != null) {
            throw this.error;
        }
    }

    @Override
    public String chooseClientAlias(String[] objectArray, Principal[] principalArray, Socket object) {
        if (this.certfile == null) {
            return null;
        }
        if (principalArray == null || principalArray.length == 0) {
            return "user";
        }
        object = this.getCertificateChain("user");
        if (object == null) {
            return null;
        }
        object = object[((X509Certificate[])object).length - 1];
        X500Principal x500Principal = ((X509Certificate)object).getIssuerX500Principal();
        object = ((Certificate)object).getPublicKey().getAlgorithm();
        boolean bl = false;
        boolean bl2 = false;
        if (objectArray != null && objectArray.length > 0) {
            for (Object object2 : objectArray) {
                if (!((String)object2).equalsIgnoreCase((String)object)) continue;
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            objectArray = principalArray;
            int n2 = principalArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object2;
                object2 = objectArray[i2];
                if (!x500Principal.equals(object2)) continue;
                bl2 = bl;
            }
        }
        if (bl2) {
            return "user";
        }
        return null;
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return null;
    }

    /*
     * Loose catch block
     */
    @Override
    public X509Certificate[] getCertificateChain(String collection) {
        if (this.cert == null && this.certfile != null) {
            block21: {
                try {
                    collection = CertificateFactory.getInstance("X.509");
                }
                catch (CertificateException certificateException) {
                    this.error = new OSQLException("Could not find a java cryptographic algorithm: X.509 CertificateFactory not available.", "", -1, certificateException);
                    return null;
                }
                FileInputStream fileInputStream = null;
                fileInputStream = new FileInputStream(this.certfile);
                collection = ((CertificateFactory)((Object)collection)).generateCertificates(fileInputStream);
                fileInputStream.close();
                catch (IOException iOException) {
                    if (!this.defaultfile) {
                        this.error = new OSQLException("Could not close SSL certificate file " + this.certfile, "", -1, iOException);
                    }
                    break block21;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!this.defaultfile) {
                        this.error = new OSQLException("Could not open SSL certificate file " + this.certfile, "", -1, fileNotFoundException);
                    }
                    return null;
                }
                catch (CertificateException certificateException) {
                    this.error = new OSQLException("Loading the SSL certificate " + this.certfile + " into a KeyManager failed.", "", -1, certificateException);
                    return null;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    block22: {
                        if (fileInputStream != null) {
                            try {
                                fileInputStream.close();
                            }
                            catch (IOException iOException) {
                                if (this.defaultfile) break block22;
                                this.error = new OSQLException("Could not close SSL certificate file " + this.certfile, "", -1, iOException);
                            }
                        }
                    }
                }
            }
            this.cert = collection.toArray(new X509Certificate[0]);
        }
        return this.cert;
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        if ((string = this.chooseClientAlias(new String[]{string}, principalArray, null)) == null) {
            return new String[0];
        }
        return new String[]{string};
    }

    private static byte[] readFileFully(String object) throws IOException {
        object = new RandomAccessFile((String)object, "r");
        try {
            byte[] byArray = new byte[(int)((RandomAccessFile)object).length()];
            ((RandomAccessFile)object).readFully(byArray);
            return byArray;
        }
        finally {
            ((RandomAccessFile)object).close();
        }
    }

    @Override
    public PrivateKey getPrivateKey(String object) {
        block11: {
            try {
                Object object2;
                if (this.key != null || this.keyfile == null) break block11;
                object = this.getCertificateChain("user");
                if (object == null || ((X509Certificate[])object).length == 0) {
                    return null;
                }
                try {
                    object2 = LazyKeyManager.readFileFully(this.keyfile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (!this.defaultfile) {
                        throw fileNotFoundException;
                    }
                    return null;
                }
                String string = new String((byte[])object2);
                object2 = string;
                object2 = string.replaceFirst("-----BEGIN.*-----", "").replaceFirst("-----END.*-----", "").replaceAll("\\s", "");
                object2 = new BASE64Decoder().decodeBuffer((String)object2);
                object = KeyFactory.getInstance(object[0].getPublicKey().getAlgorithm());
                try {
                    PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec((byte[])object2);
                    this.key = ((KeyFactory)object).generatePrivate(pKCS8EncodedKeySpec);
                }
                catch (InvalidKeySpecException invalidKeySpecException) {
                    object2 = new EncryptedPrivateKeyInfo((byte[])object2);
                    try {
                        Object object3 = this.loadAlgName((EncryptedPrivateKeyInfo)object2);
                        Object object4 = SecretKeyFactory.getInstance((String)object3);
                        object4 = ((SecretKeyFactory)object4).generateSecret(new PBEKeySpec(this.password.toCharArray()));
                        object3 = Cipher.getInstance((String)object3);
                        ((Cipher)object3).init(2, (Key)object4, ((EncryptedPrivateKeyInfo)object2).getAlgParameters());
                        this.key = ((KeyFactory)object).generatePrivate(((EncryptedPrivateKeyInfo)object2).getKeySpec((Cipher)object3));
                    }
                    catch (Exception exception) {
                        this.error = new OSQLException("Could not read SSL key file " + this.keyfile + ". Cause: " + exception.toString(), "", -1, exception);
                    }
                }
            }
            catch (IOException iOException) {
                this.error = new OSQLException("Could not read SSL key file " + this.keyfile, "", -1, iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.error = new OSQLException("Could not find a java cryptographic algorithm: " + noSuchAlgorithmException.getMessage(), "", -1, noSuchAlgorithmException);
            }
        }
        return this.key;
    }

    private String loadAlgName(EncryptedPrivateKeyInfo object) throws Exception {
        if (((EncryptedPrivateKeyInfo)object).getAlgName().equals("PBEWithHmacSHA1AndAES_256")) {
            return ((EncryptedPrivateKeyInfo)object).getAlgName();
        }
        if (!((EncryptedPrivateKeyInfo)object).getAlgName().equals("1.2.840.113549.1.5.13") && !((EncryptedPrivateKeyInfo)object).getAlgName().equals("PBES2")) {
            throw new SQLException("not PBES2 , algName is " + ((EncryptedPrivateKeyInfo)object).getAlgName(), "");
        }
        object = ((EncryptedPrivateKeyInfo)object).getAlgParameters();
        Class<?> clazz = object.getClass();
        object = LazyKeyManager.access(clazz, "paramSpi").get(object);
        clazz = Class.forName("com.sun.crypto.provider.PBES2Parameters", true, ClassLoader.getSystemClassLoader());
        object = (String)LazyKeyManager.access(clazz, "pbes2AlgorithmName").get(object);
        return object;
    }

    static Field access(Class<?> annotatedElement, String string) throws Exception {
        annotatedElement = annotatedElement.getDeclaredField(string);
        ((Field)annotatedElement).setAccessible(true);
        return annotatedElement;
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return new String[0];
    }
}

