/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.ssl;

import com.oscar.ssl.LazyKeyManager;
import com.oscar.ssl.WrappedFactory;
import com.oscar.util.OSQLException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class OscarSSLSocketFactory
extends WrappedFactory {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OscarSSLSocketFactory(String string, String string2, String string3, String string4) throws OSQLException {
        Object object;
        FileInputStream fileInputStream;
        TrustManagerFactory trustManagerFactory;
        SSLContext sSLContext;
        try {
            KeyStore keyStore;
            sSLContext = SSLContext.getInstance("TLS");
            trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
            try {
                keyStore = KeyStore.getInstance("jks");
            }
            catch (KeyStoreException keyStoreException) {
                throw new NoSuchAlgorithmException("jks KeyStore not available");
            }
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new OSQLException("Could not open SSL root certificate file " + string, "");
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            object = certificateFactory.generateCertificates(fileInputStream).toArray(new Certificate[0]);
            keyStore.load(null, null);
            for (int i2 = 0; i2 < ((Certificate[])object).length; ++i2) {
                keyStore.setCertificateEntry("cert" + i2, object[i2]);
            }
            trustManagerFactory.init(keyStore);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new OSQLException("No such algorithm exception ", "", -1, noSuchAlgorithmException);
        }
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        try {
            object = new LazyKeyManager(string2, string3, string4, false);
            sSLContext.init(new KeyManager[]{object}, trustManagerArray, null);
        }
        catch (KeyManagementException keyManagementException) {
            throw new OSQLException("Could not initialize SSL context.", "");
        }
        catch (IOException iOException) {
            try {
                throw new OSQLException("Could not read SSL root certificate file " + string, "");
                catch (GeneralSecurityException generalSecurityException) {
                    throw new OSQLException("Loading the SSL root certificate " + string + " into a TrustManager failed.", "");
                }
            }
            catch (Throwable throwable) {
                try {
                    fileInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
        }
        this.factory = sSLContext.getSocketFactory();
    }
}

