/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.util.ColumnData;
import com.oscar.util.ImportStream;
import com.oscar.util.OSQLException;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class CharacterData
extends ColumnData {
    private static final int defaultBufferSize = 16384;
    private long length = 0L;
    private Reader in;
    private String charsetName;

    @Override
    public void preWrite(ImportStream importStream) throws SQLException {
        importStream.writeInteger(-2, 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void endWrite(ImportStream importStream) throws SQLException {
        if (this.in == null) throw new OSQLException("Reader handle is invalid", "00804");
        if (importStream == null) {
            throw new OSQLException("Reader handle is invalid", "00804");
        }
        try {
            if (this.length <= 0L) {
                int n2;
                char[] cArray = new char[16384];
                while ((n2 = this.in.read(cArray, 0, 16384)) != -1) {
                    this.writeBuffer(importStream, cArray, n2);
                }
            } else {
                int n3;
                char[] cArray;
                long l2 = this.length;
                int n4 = 16384;
                if (l2 < 16384L) {
                    n4 = (int)l2;
                    cArray = new char[n4];
                } else {
                    cArray = new char[16384];
                }
                while ((n3 = this.in.read(cArray, 0, n4)) != -1 && l2 > 0L) {
                    this.writeBuffer(importStream, cArray, n3);
                    l2 -= (long)n3;
                }
            }
            importStream.writeInteger(-2, 2);
            if (this.in == null) return;
        }
        catch (IOException iOException) {
            try {
                throw new OSQLException("OSCAR-00804", "88888", 804, iOException);
            }
            catch (Throwable throwable) {
                if (this.in == null) throw throwable;
                try {
                    this.in.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    IOException iOException4 = iOException2;
                    iOException2.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            this.in.close();
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    @Override
    public void clear() throws SQLException {
        this.length = 0L;
        this.in = null;
    }

    @Override
    public void preWriteBlock(ImportStream importStream) throws SQLException {
    }

    public void read(Reader reader, long l2, String string) throws SQLException {
        this.checkExpection(reader, l2);
        this.in = reader;
        this.length = l2;
        this.charsetName = string;
    }

    public void read(Reader reader, String string) throws SQLException {
        this.read(reader, 0L, string);
    }

    private void writeBuffer(ImportStream importStream, char[] object, int n2) throws SQLException, UnsupportedEncodingException {
        Object[] objectArray;
        if (((char[])object).length == n2) {
            object = new String((char[])object);
        } else {
            objectArray = new char[n2];
            System.arraycopy(object, 0, objectArray, 0, n2);
            object = new String((char[])objectArray);
        }
        byte[] byArray = ((String)object).getBytes(this.charsetName);
        objectArray = byArray;
        int n3 = byArray.length;
        n2 = 0;
        do {
            if (n3 > 16384) {
                importStream.writeInteger(16386, 2);
                importStream.write((byte[])objectArray, n2, 16384);
                n3 -= 16384;
                n2 += 16384;
                continue;
            }
            importStream.writeInteger(n3 + 2, 2);
            importStream.write((byte[])objectArray, n2, n3);
            int n4 = n3;
            n3 = n4 - n4;
            n2 += n3;
        } while (n3 > 0);
    }

    private void checkExpection(Reader reader, long l2) throws SQLException {
        if (reader == null) {
            throw new NullPointerException();
        }
        if (l2 < 0L) {
            throw new IndexOutOfBoundsException();
        }
    }
}

