/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Set;

public class Convert {
    public static String toStr(Object object, String string) {
        if (object == null) {
            return string;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public static String toStr(Object object) {
        return Convert.toStr(object, null);
    }

    public static Character toChar(Object object, Character c2) {
        if (object == null) {
            return c2;
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        return Character.valueOf(Convert.isEmpty((String)(object = Convert.toStr(object, null))) ? c2.charValue() : ((String)object).charAt(0));
    }

    private static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static Character toChar(Object object) {
        return Convert.toChar(object, null);
    }

    public static Byte toByte(Object object, Byte by) {
        if (object == null) {
            return by;
        }
        if (object instanceof Byte) {
            return (Byte)object;
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (Convert.isEmpty((String)(object = Convert.toStr(object, null)))) {
            return by;
        }
        try {
            return Byte.parseByte((String)object);
        }
        catch (Exception exception) {
            return by;
        }
    }

    public static Byte toByte(Object object) {
        return Convert.toByte(object, null);
    }

    public static Short toShort(Object object, Short s2) {
        if (object == null) {
            return s2;
        }
        if (object instanceof Short) {
            return (Short)object;
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        if (Convert.isEmpty((String)(object = Convert.toStr(object, null)))) {
            return s2;
        }
        try {
            return Short.parseShort(((String)object).trim());
        }
        catch (Exception exception) {
            return s2;
        }
    }

    public static Short toShort(Object object) {
        return Convert.toShort(object, null);
    }

    public static Number toNumber(Object object, Number number) {
        if (object == null) {
            return number;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        if (Convert.isEmpty((String)(object = Convert.toStr(object, null)))) {
            return number;
        }
        try {
            return NumberFormat.getInstance().parse((String)object);
        }
        catch (Exception exception) {
            return number;
        }
    }

    public static Number toNumber(Object object) {
        return Convert.toNumber(object, null);
    }

    public static Integer toInt(Object object, Integer n2) {
        if (object == null) {
            return n2;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (Convert.isEmpty((String)(object = Convert.toStr(object, null)))) {
            return n2;
        }
        try {
            return new BigDecimal(((String)object).trim()).intValue();
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public static Integer toInt(Object object) {
        return Convert.toInt(object, null);
    }

    public static Integer[] toIntArray(String string) {
        return Convert.toIntArray(",", string);
    }

    public static Long[] toLongArray(String string) {
        return Convert.toLongArray(",", string);
    }

    public static Integer[] toIntArray(String stringArray, String integerArray) {
        if (Convert.isEmpty((String)integerArray)) {
            return new Integer[0];
        }
        stringArray = integerArray.split((String)stringArray);
        integerArray = new Integer[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Integer n2;
            integerArray[i2] = n2 = Convert.toInt(stringArray[i2], 0);
        }
        return integerArray;
    }

    public static Long[] toLongArray(String stringArray, String longArray) {
        if (Convert.isEmpty((String)longArray)) {
            return new Long[0];
        }
        stringArray = longArray.split((String)stringArray);
        longArray = new Long[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Long l2;
            longArray[i2] = l2 = Convert.toLong(stringArray[i2], null);
        }
        return longArray;
    }

    public static String[] toStrArray(String string) {
        return Convert.toStrArray(",", string);
    }

    public static String[] toStrArray(String string, String string2) {
        return string2.split(string);
    }

    public static Long toLong(Object object, Long l2) {
        if (object == null) {
            return l2;
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (Convert.isEmpty((String)(object = Convert.toStr(object, null)))) {
            return l2;
        }
        try {
            return new BigDecimal(((String)object).trim()).longValue();
        }
        catch (Exception exception) {
            return l2;
        }
    }

    public static Long toLong(Object object) {
        return Convert.toLong(object, null);
    }

    public static Double toDouble(Object object, Double d2) {
        if (object == null) {
            return d2;
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (Convert.isEmpty((String)(object = Convert.toStr(object, null)))) {
            return d2;
        }
        try {
            return new BigDecimal(((String)object).trim()).doubleValue();
        }
        catch (Exception exception) {
            return d2;
        }
    }

    public static Double toDouble(Object object) {
        return Convert.toDouble(object, null);
    }

    public static Float toFloat(Object object, Float f2) {
        if (object == null) {
            return f2;
        }
        if (object instanceof Float) {
            return (Float)object;
        }
        if (object instanceof Number) {
            return Float.valueOf(((Number)object).floatValue());
        }
        if (Convert.isEmpty((String)(object = Convert.toStr(object, null)))) {
            return f2;
        }
        try {
            return Float.valueOf(Float.parseFloat(((String)object).trim()));
        }
        catch (Exception exception) {
            return f2;
        }
    }

    public static Float toFloat(Object object) {
        return Convert.toFloat(object, null);
    }

    public static Boolean toBool(Object object, Boolean bl) {
        if (object == null) {
            return bl;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (Convert.isEmpty((String)(object = Convert.toStr(object, null)))) {
            return bl;
        }
        object = ((String)object).trim().toLowerCase();
        if (Arrays.asList("true", "yes", "ok", "1").contains(object)) {
            return Boolean.TRUE;
        }
        if (Arrays.asList("false", "no", "0").contains(object)) {
            return Boolean.FALSE;
        }
        return bl;
    }

    public static Boolean toBool(Object object) {
        return Convert.toBool(object, null);
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object object, E e2) {
        if (object == null) {
            return e2;
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            object = (Enum)object;
            return (E)object;
        }
        if (Convert.isEmpty((String)(object = Convert.toStr(object, null)))) {
            return e2;
        }
        try {
            return Enum.valueOf(clazz, (String)object);
        }
        catch (Exception exception) {
            return e2;
        }
    }

    public static <E extends Enum<E>> E toEnum(Class<E> clazz, Object object) {
        return Convert.toEnum(clazz, object, null);
    }

    public static BigInteger toBigInteger(Object object, BigInteger bigInteger) {
        if (object == null) {
            return bigInteger;
        }
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        if (object instanceof Long) {
            return BigInteger.valueOf((Long)object);
        }
        if (Convert.isEmpty((String)(object = Convert.toStr(object, null)))) {
            return bigInteger;
        }
        try {
            return new BigInteger((String)object);
        }
        catch (Exception exception) {
            return bigInteger;
        }
    }

    public static BigInteger toBigInteger(Object object) {
        return Convert.toBigInteger(object, null);
    }

    public static BigDecimal toBigDecimal(Object object, BigDecimal bigDecimal) {
        if (object == null) {
            return bigDecimal;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Long) {
            return new BigDecimal((Long)object);
        }
        if (object instanceof Double) {
            return BigDecimal.valueOf((Double)object);
        }
        if (object instanceof Integer) {
            return new BigDecimal((Integer)object);
        }
        if (Convert.isEmpty((String)(object = Convert.toStr(object, null)))) {
            return bigDecimal;
        }
        try {
            return new BigDecimal((String)object);
        }
        catch (Exception exception) {
            return bigDecimal;
        }
    }

    public static BigDecimal toBigDecimal(Object object) {
        return Convert.toBigDecimal(object, null);
    }

    public static String utf8Str(Object object) {
        return Convert.str(object, Charset.forName("UTF-8"));
    }

    public static String str(Object object, String string) {
        return Convert.str(object, Charset.forName(string));
    }

    public static String str(Object object, Charset charset) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof byte[]) {
            return Convert.str((byte[])object, charset);
        }
        if (object instanceof Byte[]) {
            byte[] byArray = Convert.toPrimitive((Byte[])object);
            object = byArray;
            return Convert.str(byArray, charset);
        }
        if (object instanceof ByteBuffer) {
            return Convert.str((ByteBuffer)object, charset);
        }
        return object.toString();
    }

    static byte[] toPrimitive(Byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        if (byteArray.length == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[byteArray.length];
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            byArray[i2] = byteArray[i2];
        }
        return byArray;
    }

    public static String str(byte[] byArray, String string) {
        return Convert.str(byArray, Convert.isEmpty(string) ? Charset.defaultCharset() : Charset.forName(string));
    }

    public static String str(byte[] byArray, Charset charset) {
        if (byArray == null) {
            return null;
        }
        if (charset == null) {
            return new String(byArray);
        }
        return new String(byArray, charset);
    }

    public static String str(ByteBuffer byteBuffer, String string) {
        if (byteBuffer == null) {
            return null;
        }
        return Convert.str(byteBuffer, Charset.forName(string));
    }

    public static String str(ByteBuffer byteBuffer, Charset charset) {
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(byteBuffer).toString();
    }

    public static String toSBC(String string) {
        return Convert.toSBC(string, null);
    }

    public static String toSBC(String object, Set<Character> set) {
        object = ((String)object).toCharArray();
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            if (set != null && set.contains(Character.valueOf((char)object[i2]))) continue;
            if (object[i2] == 32) {
                object[i2] = 12288;
                continue;
            }
            if (object[i2] >= 127) continue;
            object[i2] = (char)(object[i2] + 65248);
        }
        return new String((char[])object);
    }

    public static String toDBC(String string) {
        return Convert.toDBC(string, null);
    }

    public static String toDBC(String object, Set<Character> set) {
        object = ((String)object).toCharArray();
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            if (set != null && set.contains(Character.valueOf((char)object[i2]))) continue;
            if (object[i2] == 12288) {
                object[i2] = 32;
                continue;
            }
            if (object[i2] <= 65280 || object[i2] >= 65375) continue;
            object[i2] = (char)(object[i2] - 65248);
        }
        String string = new String((char[])object);
        return string;
    }

    public static String digitUppercase(double d2) {
        int n2;
        String[] stringArray = new String[]{"\u89d2", "\u5206"};
        String[] stringArray2 = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[][] stringArrayArray = new String[][]{{"\u5143", "\u4e07", "\u4ebf"}, {"", "\u62fe", "\u4f70", "\u4edf"}};
        String string = d2 < 0.0 ? "\u8d1f" : "";
        d2 = Math.abs(d2);
        String string2 = "";
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            string2 = string2 + (stringArray2[(int)(Math.floor(d2 * 10.0 * Math.pow(10.0, n2)) % 10.0)] + stringArray[n2]).replaceAll("(\u96f6.)+", "");
        }
        if (string2.length() <= 0) {
            string2 = "\u6574";
        }
        n2 = (int)Math.floor(d2);
        for (int i2 = 0; i2 < stringArrayArray[0].length && n2 > 0; ++i2) {
            String string3 = "";
            for (int i3 = 0; i3 < stringArrayArray[1].length && d2 > 0.0; ++i3) {
                string3 = stringArray2[n2 % 10] + stringArrayArray[1][i3] + string3;
                n2 /= 10;
            }
            string2 = string3.replaceAll("(\u96f6.)*\u96f6$", "").replaceAll("^$", "\u96f6") + stringArrayArray[0][i2] + string2;
        }
        return string + string2.replaceAll("(\u96f6.)*\u96f6\u5143", "\u5143").replaceFirst("(\u96f6.)+", "").replaceAll("(\u96f6.)+", "\u96f6").replaceAll("^\u6574$", "\u96f6\u5143\u6574");
    }
}

