/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.jdbc.MetaData;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class HashPartitionMap
implements Serializable {
    private static final long serialVersionUID = -5952477578322320409L;
    public static final int XDB_DEFAULT_BUCKETSIZE = 8;
    private int HASH_SIZE = -1;
    private transient HashSet<Integer> partitions;
    private transient ArrayList[] mappingTable;
    private transient long[] weightMap = null;

    public HashPartitionMap() {
    }

    public HashPartitionMap(int n2) {
        this.HASH_SIZE = n2;
    }

    public void initBucketCount(MetaData object, int n2) throws SQLException {
        String string = "SELECT COUNT(HASHVALUE) FROM CSYS_TABPARTHASH WHERE tableid = " + n2;
        int n3 = 0;
        if ((object = ((MetaData)object).executeQuery(string)).next()) {
            n3 = object.getInt(1);
        }
        this.HASH_SIZE = n3;
    }

    public Collection findPartitions(String string) {
        int n2 = this.getBucketId(string);
        return this.mappingTable[n2];
    }

    public void generateDistribution(Collection<Integer> collection) {
        this.partitions = new HashSet<Integer>(collection);
        Iterator<Integer> iterator = collection.iterator();
        boolean bl = false;
        boolean bl2 = false;
        if (-1 == this.HASH_SIZE) {
            this.HASH_SIZE = 8;
        }
        this.mappingTable = new ArrayList[this.HASH_SIZE];
        while (!bl2 && iterator.hasNext()) {
            int n2 = 0;
            for (int i2 = 0; i2 < this.HASH_SIZE; ++i2) {
                if (!iterator.hasNext()) {
                    bl2 = true;
                    if (bl) break;
                    iterator = collection.iterator();
                }
                if (this.mappingTable[n2] != null && this.mappingTable[n2].size() != 0) {
                    this.mappingTable[n2].add(iterator.next());
                } else {
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    arrayList.add(iterator.next());
                    this.mappingTable[n2] = arrayList;
                }
                ++n2;
            }
            bl = true;
        }
    }

    public Collection getPartitions(String string) {
        int n2 = this.getBucketId(string);
        int n3 = 0;
        ArrayList arrayList = this.mappingTable[n2];
        if (this.weightMap != null && this.weightMap[n2] > 0L) {
            n3 = 0;
            this.weightMap[n2] = this.weightMap[n2] > 1L ? this.weightMap[n2] - 1L : -1L;
        } else {
            ++n3;
            if (1 == arrayList.size()) {
                n3 = 0;
            }
        }
        return Collections.singleton((Integer)arrayList.get(n3));
    }

    public Collection joinPartitions() {
        return this.allPartitions();
    }

    public Collection allPartitions() {
        if (this.partitions == null) {
            this.partitions = new HashSet();
            int n2 = this.mappingTable.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.partitions.addAll(this.mappingTable[i2]);
            }
        }
        return this.partitions;
    }

    public int getRedundancyLevel() {
        return 1;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object instanceof HashPartitionMap && this.allPartitions().size() <= this.HASH_SIZE) {
            int n2 = this.mappingTable.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.mappingTable[i2].size() <= 1) continue;
                return false;
            }
            return this.mappingTable == ((HashPartitionMap)object).mappingTable;
        }
        return false;
    }

    private int getBucketId(String string) {
        HashPartitionMap hashPartitionMap = this;
        return hashPartitionMap.getBucketFromHash(hashPartitionMap.hash(string));
    }

    private int getBucketFromHash(int n2) {
        if (null == this.mappingTable[n2] || 0 == this.mappingTable[n2].size()) {
            String string = "The Node Information Is Lost : (Node ID) ( " + n2 + " )";
            throw new RuntimeException(string);
        }
        return n2;
    }

    public final int hash(String string) {
        return this.hash(string == null ? null : string.getBytes());
    }

    private final int hash(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n2 = 596579247 * byArray.length;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            n2 = n2 + (byArray[i2] << i2 * 5 % 24) & Integer.MAX_VALUE;
        }
        return (n2 * 1103515243 + 12345 & Integer.MAX_VALUE) % this.HASH_SIZE;
    }

    public int getColumnCount(MetaData object, int n2) throws SQLException {
        String string = "SELECT COUNT(colname) FROM CSYS_ATTRIBUTE WHERE tableid = " + n2;
        int n3 = 0;
        if ((object = ((MetaData)object).executeQuery(string)).next()) {
            n3 = object.getInt(1);
        }
        return n3;
    }

    public int getColumnPosition(MetaData object, int n2) throws SQLException {
        String string = "select COLSEQ from CSYS_ATTRIBUTE c inner join CSYS_CLASS t on c.colname = t.partcol and c.tableid = " + n2 + " and t.tableid = " + n2;
        int n3 = 0;
        if ((object = ((MetaData)object).executeQuery(string)).next()) {
            n3 = object.getInt(1);
        }
        return n3;
    }

    public int getTableId(MetaData metaData, String string) throws SQLException {
        int n2 = string.indexOf(".");
        try (ResultSet resultSet = null;){
            if (n2 > 0) {
                String string2 = "select tableid from CSYS_CLASS t, CSYS_DATABASE d where t.tablename = ? and d.DBNAME = ? and d.DBID = t.DBID";
                resultSet = metaData.executeQuery(string2, string.substring(n2 + 1, string.length()), string.substring(0, n2));
            } else {
                String string3 = "select tableid from CSYS_CLASS where tablename = ?";
                resultSet = metaData.executeQuery(string3, string);
            }
            if (resultSet.next()) {
                int n3 = resultSet.getInt(1);
                return n3;
            }
        }
        throw new SQLException("can not find " + string);
    }

    public void readMapFromMetadataDB(MetaData object, int n2) throws SQLException {
        Object object2 = "SELECT COUNT(DISTINCT hashValue) FROM CSYS_TABPARTHASH WHERE tableid = " + n2;
        object2 = ((MetaData)object).executeQuery((String)object2);
        object2.next();
        this.HASH_SIZE = object2.getInt(1);
        object2.close();
        this.mappingTable = new ArrayList[this.HASH_SIZE];
        this.weightMap = new long[this.HASH_SIZE];
        object2 = "SELECT hashValue, nodeid, weight FROM CSYS_TABPARTHASH WHERE tableid = " + n2;
        object2 = ((MetaData)object).executeQuery((String)object2);
        try {
            while (object2.next()) {
                if (this.mappingTable[object2.getInt(1)] != null && this.mappingTable[object2.getInt(1)].size() != 0) {
                    if (this.weightMap[object2.getInt(1)] < object2.getLong(3)) {
                        this.weightMap[object2.getInt((int)1)] = object2.getLong(3);
                        this.mappingTable[object2.getInt(1)].add(0, object2.getInt(2));
                        continue;
                    }
                    this.mappingTable[object2.getInt(1)].add(object2.getInt(2));
                    continue;
                }
                object = new ArrayList<Integer>();
                ((ArrayList)object).add(object2.getInt(2));
                this.mappingTable[object2.getInt((int)1)] = object;
                this.weightMap[object2.getInt((int)1)] = object2.getLong(3);
            }
            return;
        }
        finally {
            object2.close();
        }
    }

    public void storeMapToMetadataDB(MetaData metaData, int n2, int n3) throws SQLException {
        int n4;
        String string = "SELECT max(parthashid) FROM CSYS_TABPARTHASH";
        try (ResultSet resultSet = metaData.executeQuery(string);){
            resultSet.next();
            n4 = resultSet.getInt(1) + 1;
        }
        for (int i2 = 0; i2 < this.mappingTable.length; ++i2) {
            int n5 = this.mappingTable[i2].size();
            for (int i3 = 0; i3 < n5; ++i3) {
                String string2 = "INSERT INTO CSYS_TABPARTHASH (parthashid, tableid, dbid, hashValue, nodeid, weight) VALUES (" + n4++ + ", " + n3 + ", " + n2 + ", " + i2 + ", " + this.mappingTable[i2].get(i3) + ", 0)";
                metaData.executeUpdate(string2);
            }
        }
    }

    public void removeMapFromMetadataDB(MetaData metaData, int n2) throws SQLException {
        String string = "DELETE FROM CSYS_TABPARTHASH WHERE tableid = " + n2;
        metaData.executeUpdate(string);
        string = "DELETE FROM CSYS_TABPART WHERE tableid = " + n2;
        metaData.executeUpdate(string);
    }

    public void addNodeToMap(MetaData metaData, int n2, int n3, int n4, Integer n5, long l2) throws SQLException {
        int n6;
        String string = "SELECT max(parthashid) FROM CSYS_TABPARTHASH";
        try (ResultSet resultSet = metaData.executeQuery(string);){
            resultSet.next();
            n6 = resultSet.getInt(1) + 1;
        }
        String string2 = "INSERT INTO CSYS_TABPARTHASH (parthashid, tableid, dbid, hashValue, nodeid, weight) VALUES (" + n6 + ", " + n2 + ", " + n3 + ", " + n4 + ", " + n5 + ", " + l2 + ")";
        metaData.executeUpdate(string2);
    }

    public void updateWeight(MetaData metaData, int n2) throws SQLException {
        for (int i2 = 0; i2 < this.weightMap.length; ++i2) {
            if (-1L != this.weightMap[i2] && this.weightMap[i2] <= 0L) continue;
            long l2 = -1L == this.weightMap[i2] ? 0L : this.weightMap[i2];
            String string = "Update CSYS_TABPARTHASH set weight = " + l2 + " where tableid = " + n2 + " and hashValue = " + i2 + " and nodeid = " + this.mappingTable[i2].get(0);
            metaData.executeUpdate(string);
        }
    }

    public int getBucketSize() {
        return this.HASH_SIZE;
    }

    public ArrayList[] getMappingTable() {
        return this.mappingTable;
    }
}

