/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.Driver;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;

public abstract class ImportBufferManager {
    private static volatile long maxUsingBufferSize = Runtime.getRuntime().maxMemory();
    private static volatile long usingBufferSize = 0L;
    private static final int waitTime = 180000;
    private static final int perWaitTime = 10000;
    private static final Object lock = new Object();
    private static Hashtable<Integer, SoftReference<Stack<byte[]>>> cacheBuffer = new Hashtable();
    private static final boolean printLog = Driver.getLogLevel() == -1 || Driver.getLogLevel() > 0;

    public static void setMaxUsingBufferSize(int n2) {
        long l2 = n2;
        maxUsingBufferSize = l2 << 10 << 10;
    }

    public static byte[] getBufferAllways(int n2) {
        int n3 = 0;
        Object object = null;
        while (true) {
            Serializable serializable;
            if (n3 > 300) {
                throw new RuntimeException("getBufferAllways timeout", (Throwable)object);
            }
            ++n3;
            object = lock;
            synchronized (object) {
                if (cacheBuffer.containsKey(n2)) {
                    serializable = cacheBuffer.get(n2);
                    if ((serializable = ((SoftReference)((Object)serializable)).get()) != null && serializable.size() > 0) {
                        return serializable.pop();
                    }
                }
            }
            try {
                object = new byte[n2];
            }
            catch (Error error) {
                serializable = error;
                object = error;
                Driver.writeLog("ImportBufferManager.getBufferAllways--", serializable);
                System.gc();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    serializable = interruptedException;
                    interruptedException.printStackTrace();
                }
                continue;
            }
            break;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getBuffer(int n2) throws InterruptedException {
        Throwable throwable = null;
        long l2 = System.currentTimeMillis();
        while (true) {
            Object object = lock;
            synchronized (object) {
                long l3 = System.currentTimeMillis();
                if (l3 - l2 > 180000L) {
                    String string = throwable != null ? throwable.toString() : "get buffer timeout, current using :" + usingBufferSize + " maxUsingBufferSize:" + maxUsingBufferSize;
                    throw new RuntimeException(string);
                }
                if (usingBufferSize + (long)n2 <= maxUsingBufferSize) {
                    Object object2;
                    Object object3;
                    if (printLog) {
                        Driver.writeLog(Thread.currentThread().getId() + " success get buffer " + n2 + ", current using :" + usingBufferSize + " maxUsingBufferSize:" + maxUsingBufferSize);
                    }
                    if ((object3 = cacheBuffer.get(n2)) != null) {
                        Stack<byte[]> stack = ((SoftReference)object3).get();
                        object2 = stack;
                        if (stack != null && ((Vector)object2).size() > 0) {
                            usingBufferSize += (long)n2;
                            return (byte[])((Stack)object2).pop();
                        }
                    }
                    try {
                        object2 = new byte[n2];
                        usingBufferSize += (long)n2;
                    }
                    catch (Error error) {
                        Driver.writeLog(String.format("totalMemory::%s, maxMemory::%s, freeMemory::%s", "" + Runtime.getRuntime().totalMemory(), "" + Runtime.getRuntime().maxMemory(), "" + Runtime.getRuntime().freeMemory()));
                        Driver.writeLog(error);
                        throwable = error;
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            object3 = interruptedException;
                            interruptedException.printStackTrace();
                        }
                        continue;
                    }
                    return object2;
                }
                if (printLog) {
                    Driver.writeLog("wait buffer " + n2 + ", current using :" + usingBufferSize + " maxUsingBufferSize:" + maxUsingBufferSize);
                }
                int n3 = ImportBufferManager.computeUsingBufferSize();
                System.gc();
                int n4 = ImportBufferManager.computeUsingBufferSize();
                usingBufferSize = -(n3 - n4);
                if (usingBufferSize + (long)n2 <= maxUsingBufferSize) {
                    continue;
                }
                lock.wait(10000L);
            }
        }
    }

    private static int computeUsingBufferSize() {
        int n2 = 0;
        for (Map.Entry<Integer, SoftReference<Stack<byte[]>>> entry : cacheBuffer.entrySet()) {
            SoftReference<Stack<byte[]>> softReference = entry.getValue();
            if (softReference == null || (softReference = softReference.get()) == null) continue;
            n2 += entry.getKey() * ((Vector)((Object)softReference)).size();
        }
        return n2;
    }

    public static void releaseCache(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            Object object2 = cacheBuffer.get(byArray.length);
            if (object2 != null) {
                if ((object2 = ((SoftReference)object2).get()) == null) {
                    cacheBuffer.put(byArray.length, ImportBufferManager.newSoftReference(byArray));
                } else {
                    ((Stack)object2).push(byArray);
                }
            } else {
                cacheBuffer.put(byArray.length, ImportBufferManager.newSoftReference(byArray));
            }
            lock.notify();
            return;
        }
    }

    public static void releaseBuffer(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            Object object2;
            usingBufferSize -= (long)byArray.length;
            if (printLog) {
                Driver.writeLog(" release buffer " + byArray.length + ", current using :" + usingBufferSize);
            }
            if ((object2 = cacheBuffer.get(byArray.length)) != null) {
                if ((object2 = ((SoftReference)object2).get()) == null) {
                    cacheBuffer.put(byArray.length, ImportBufferManager.newSoftReference(byArray));
                } else {
                    ((Stack)object2).push(byArray);
                }
            } else {
                cacheBuffer.put(byArray.length, ImportBufferManager.newSoftReference(byArray));
            }
            lock.notifyAll();
            return;
        }
    }

    public static void releaseIncludeSelf() {
        cacheBuffer.clear();
    }

    private static SoftReference<Stack<byte[]>> newSoftReference(byte[] object) {
        Stack<byte[]> stack = new Stack<byte[]>();
        stack.push((byte[])object);
        SoftReference<Stack<byte[]>> softReference = new SoftReference<Stack<byte[]>>(stack);
        object = softReference;
        return softReference;
    }
}

