/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.jdbc.OscarImportHandler;
import com.oscar.util.OSQLException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class ImportFileInputStream {
    private static final int dataLength = 8192;
    private InputStream input = null;
    private String fileName = null;
    private byte[] dataBuffer = new byte[8192];
    private int position = 0;
    private byte[] columnBuffer = new byte[0x500000];
    private int colPosition = 0;
    private boolean closed = false;
    private int byteLength = 0;
    private boolean nullMarked = false;
    private OscarImportHandler handler = null;
    private Separator separator = new Separator();

    public ImportFileInputStream(OscarImportHandler oscarImportHandler, String string, String string2, String string3, char c2) throws SQLException {
        try {
            this.input = new BufferedInputStream(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new OSQLException("OSCAR-00808", "88888", 808, fileNotFoundException);
        }
        this.init(oscarImportHandler, string, string2, string3, c2);
    }

    public ImportFileInputStream(OscarImportHandler oscarImportHandler, String string, String string2, String string3) throws SQLException {
        try {
            this.input = new BufferedInputStream(new FileInputStream(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new OSQLException("OSCAR-00808", "88888", 808, fileNotFoundException);
        }
        this.init(oscarImportHandler, string, string2, string3);
    }

    public ImportFileInputStream(OscarImportHandler oscarImportHandler, InputStream inputStream, String string, String string2, char c2) {
        this.input = inputStream;
        this.init(oscarImportHandler, null, string, string2, c2);
    }

    public ImportFileInputStream(OscarImportHandler oscarImportHandler, InputStream inputStream, String string, String string2) {
        this.input = inputStream;
        this.init(oscarImportHandler, null, string, string2);
    }

    public void init(OscarImportHandler oscarImportHandler, String string, String string2, String string3, char c2) {
        this.handler = oscarImportHandler;
        this.fileName = string;
        this.separator.colSepStr = string2;
        this.separator.rowSepStr = string3;
        this.separator.escapeChar = c2;
    }

    public void init(OscarImportHandler oscarImportHandler, String string, String string2, String string3) {
        this.handler = oscarImportHandler;
        this.fileName = string;
        this.separator.colSepStr = string2;
        this.separator.rowSepStr = string3;
        this.separator.containsSep = false;
    }

    public void read() throws SQLException {
        if (this.checkClosed()) {
            throw new OSQLException("OSCAR-00809", "88888", 107);
        }
        this.readStandardCSV();
    }

    public void readStandardCSV() throws SQLException {
        byte[] byArray;
        byte[] byArray2;
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        byte[] cfr_ignored_0 = new byte[0];
        try {
            byArray2 = this.separator.colSepStr.getBytes("GBK");
            byArray = this.separator.rowSepStr.getBytes("GBK");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OSQLException("OSCAR-00808", "88888", 808, unsupportedEncodingException);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n5 = byArray2.length > byArray.length ? byArray2.length : byArray.length;
        int n6 = this.separator.rowSepStr.indexOf(this.separator.colSepStr) < 0 ? 0 : 1;
        try {
            int n7;
            block8: while (n3 != -1) {
                int n8;
                n3 = this.input.read(this.dataBuffer, this.position, this.dataBuffer.length - this.position);
                if (n3 == -1) {
                    n8 = this.position;
                    n4 = this.position;
                    if (bl3) {
                        bl3 = false;
                    }
                } else {
                    n8 = n3 + this.position;
                    this.position = 0;
                }
                block9: for (n7 = 0; n7 < n8; ++n7) {
                    if (n3 != -1 && n7 > n8 - n5) {
                        System.arraycopy(this.dataBuffer, this.position, this.dataBuffer, 0, n8 - this.position);
                        this.position = n8 - this.position;
                        this.colPosition = 0;
                        bl3 = false;
                        continue block8;
                    }
                    int n9 = n7;
                    if (bl3) {
                        if (this.dataBuffer[n7] == this.separator.escapeChar) {
                            if (this.dataBuffer[++n7] == this.separator.escapeChar) {
                                this.columnBuffer[this.colPosition++] = (byte)this.separator.escapeChar;
                                if (n7 != n8 - 1) continue;
                                --n7;
                                continue;
                            }
                            --n7;
                            bl3 = false;
                            continue;
                        }
                        this.columnBuffer[this.colPosition++] = this.dataBuffer[n7];
                        continue;
                    }
                    if (this.separator.containsSep && this.dataBuffer[n7] == this.separator.escapeChar) {
                        bl3 = true;
                        continue;
                    }
                    switch (n6) {
                        case 0: {
                            int n10;
                            for (n10 = 0; n10 < byArray2.length; ++n10) {
                                if (this.dataBuffer[n7] == byArray2[n10]) {
                                    ++n7;
                                } else {
                                    bl = false;
                                    break;
                                }
                                bl = true;
                            }
                            if (bl) {
                                this.byteLength += n7 - this.position - byArray2.length;
                                byte[] byArray3 = new byte[this.colPosition];
                                System.arraycopy(this.columnBuffer, 0, byArray3, 0, this.colPosition);
                                this.setColumn(n2++, byArray3);
                                byte[] cfr_ignored_1 = new byte[0];
                                this.position = n7--;
                                this.colPosition = 0;
                                bl4 = true;
                            } else {
                                n7 = n9;
                                for (n10 = 0; n10 < byArray.length; ++n10) {
                                    if (this.dataBuffer[n7] == byArray[n10]) {
                                        ++n7;
                                    } else {
                                        bl2 = false;
                                        break;
                                    }
                                    bl2 = true;
                                }
                                if (bl2) {
                                    this.byteLength += n7 - this.position - byArray.length;
                                    byte[] byArray4 = new byte[this.colPosition];
                                    System.arraycopy(this.columnBuffer, 0, byArray4, 0, this.colPosition);
                                    this.setColumn(n2, byArray4);
                                    byte[] cfr_ignored_2 = new byte[0];
                                    this.position = n7--;
                                    this.colPosition = 0;
                                    this.handler.endRow();
                                    bl4 = false;
                                    n2 = 1;
                                } else {
                                    this.columnBuffer[this.colPosition++] = this.dataBuffer[n7];
                                }
                            }
                            bl = false;
                            bl2 = false;
                            if (this.position != n8) continue block9;
                            this.position = 0;
                            continue block9;
                        }
                        case 1: {
                            int n10;
                            for (n10 = 0; n10 < byArray.length; ++n10) {
                                if (this.dataBuffer[n7] == byArray[n10]) {
                                    ++n7;
                                } else {
                                    bl2 = false;
                                    break;
                                }
                                bl2 = true;
                            }
                            if (bl2) {
                                this.byteLength += n7 - this.position - byArray.length;
                                byte[] byArray5 = new byte[this.colPosition];
                                System.arraycopy(this.columnBuffer, 0, byArray5, 0, this.colPosition);
                                this.setColumn(n2, byArray5);
                                byte[] cfr_ignored_3 = new byte[0];
                                this.position = n7--;
                                this.colPosition = 0;
                                this.handler.endRow();
                                bl4 = false;
                                n2 = 1;
                            } else {
                                n7 = n9;
                                for (n10 = 0; n10 < byArray2.length; ++n10) {
                                    if (this.dataBuffer[n7] == byArray2[n10]) {
                                        ++n7;
                                    } else {
                                        bl = false;
                                        break;
                                    }
                                    bl = true;
                                }
                                if (bl) {
                                    this.byteLength += n7 - this.position - byArray2.length;
                                    byte[] byArray6 = new byte[this.colPosition];
                                    System.arraycopy(this.columnBuffer, 0, byArray6, 0, this.colPosition);
                                    this.setColumn(n2++, byArray6);
                                    byte[] cfr_ignored_4 = new byte[0];
                                    this.position = n7--;
                                    this.colPosition = 0;
                                    bl4 = true;
                                } else {
                                    this.columnBuffer[this.colPosition++] = this.dataBuffer[n7];
                                }
                            }
                            bl = false;
                            bl2 = false;
                            if (this.position != n8) continue block9;
                            this.position = 0;
                        }
                    }
                }
            }
            if (bl4) {
                byte[] byArray7;
                this.colPosition = 0;
                bl3 = this.separator.containsSep && n4 >= 2 && this.dataBuffer[0] == this.separator.escapeChar;
                if (bl3) {
                    for (n7 = 1; n7 < n4; ++n7) {
                        if (this.dataBuffer[n7] == this.separator.escapeChar) {
                            if (n7 == n4 - 1 || this.dataBuffer[++n7] != this.separator.escapeChar) break;
                            this.columnBuffer[this.colPosition++] = (byte)this.separator.escapeChar;
                            continue;
                        }
                        this.columnBuffer[this.colPosition++] = this.dataBuffer[n7];
                    }
                    byArray7 = new byte[this.colPosition];
                    System.arraycopy(this.columnBuffer, 0, byArray7, 0, this.colPosition);
                } else {
                    byArray7 = new byte[n4];
                    System.arraycopy(this.dataBuffer, 0, byArray7, 0, n4);
                }
                this.setColumn(n2, byArray7);
                this.handler.endRow();
            }
            this.handler.execute();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception instanceof SQLException) {
                throw (SQLException)exception2;
            }
            throw new OSQLException("OSCAR-00808", "88888", 808, exception2);
        }
    }

    private void setColumn(int n2, byte[] byArray) throws SQLException {
        if (!this.nullMarked && byArray.length != 0) {
            this.handler.setBytes(n2, byArray);
        }
    }

    public boolean checkClosed() {
        return this.closed;
    }

    public void close() throws SQLException {
        if (this.fileName != null && this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                throw new OSQLException("OSCAR-00808", "88888", 808, iOException);
            }
        }
        this.handler = null;
        this.fileName = null;
        this.input = null;
        this.dataBuffer = null;
        this.columnBuffer = null;
        this.closed = true;
    }

    public boolean isNullMarked() {
        return this.nullMarked;
    }

    public void setNullMarked(boolean bl) {
        this.nullMarked = bl;
    }

    private static class Separator {
        private static final char c = '\"';
        public String rowSepStr = "\r\n";
        public String colSepStr = "\t";
        public char escapeChar = (char)34;
        public boolean containsSep = true;

        public Separator() {
            String string = System.getProperty("os.name");
            if (string.toUpperCase().startsWith("WIN")) {
                this.rowSepStr = "\r\n";
                this.colSepStr = "\t";
                return;
            }
            if (string.toUpperCase().startsWith("LIN")) {
                this.rowSepStr = "\n";
                this.colSepStr = "\t";
            }
        }
    }
}

