/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.jdbc.OscarImportHandler;
import com.oscar.util.OSQLException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class ImportFileReader {
    private static final int dataLength = 8192;
    private Reader reader = null;
    private String fileName = null;
    private char[] dataBuffer = new char[8192];
    private int position = 0;
    private char[] columnBuffer = new char[0x500000];
    private int colPosition = 0;
    private boolean closed = false;
    private int byteLength = 0;
    private boolean nullMarked = false;
    private Charset charset = Charset.forName("GBK");
    private OscarImportHandler handler = null;
    private Separator separator = new Separator();

    public ImportFileReader(OscarImportHandler oscarImportHandler, String string, String string2, String string3, char c2, Charset charset) throws SQLException {
        try {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), charset));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new OSQLException("OSCAR-00808", "88888", 808, fileNotFoundException);
        }
        this.init(oscarImportHandler, string, string2, string3, c2, charset);
    }

    public ImportFileReader(OscarImportHandler oscarImportHandler, String string, String string2, String string3, Charset charset) throws SQLException {
        try {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), charset));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new OSQLException("OSCAR-00808", "88888", 808, fileNotFoundException);
        }
        this.init(oscarImportHandler, string, string2, string3, charset);
    }

    public ImportFileReader(OscarImportHandler oscarImportHandler, String string, String string2, String string3, char c2) throws SQLException {
        this(oscarImportHandler, string, string2, string3, c2, Charset.forName("GBK"));
    }

    public ImportFileReader(OscarImportHandler oscarImportHandler, String string, String string2, String string3) throws SQLException {
        this(oscarImportHandler, string, string2, string3, Charset.forName("GBK"));
    }

    public ImportFileReader(OscarImportHandler oscarImportHandler, Reader reader, String string, String string2, char c2) {
        this.reader = reader;
        this.init(oscarImportHandler, null, string, string2, c2, null);
    }

    public ImportFileReader(OscarImportHandler oscarImportHandler, Reader reader, String string, String string2) {
        this.reader = reader;
        this.init(oscarImportHandler, null, string, string2, null);
    }

    public void init(OscarImportHandler oscarImportHandler, String string, String string2, String string3, char c2, Charset charset) {
        this.handler = oscarImportHandler;
        this.fileName = string;
        this.separator.colSepStr = string2;
        this.separator.rowSepStr = string3;
        this.separator.escapeChar = c2;
        if (charset != null) {
            this.charset = charset;
        }
    }

    public void init(OscarImportHandler oscarImportHandler, String string, String string2, String string3, Charset charset) {
        this.handler = oscarImportHandler;
        this.fileName = string;
        this.separator.colSepStr = string2;
        this.separator.rowSepStr = string3;
        this.separator.containsSep = false;
        if (charset != null) {
            this.charset = charset;
        }
    }

    public void read() throws SQLException {
        if (this.checkClosed()) {
            throw new OSQLException("OSCAR-00809", "88888", 107);
        }
        this.readStandardCSV();
    }

    public void readStandardCSV() throws SQLException {
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        char[] cfr_ignored_0 = new char[0];
        char[] cArray = this.separator.colSepStr.toCharArray();
        char[] cArray2 = this.separator.rowSepStr.toCharArray();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n5 = cArray.length > cArray2.length ? cArray.length : cArray2.length;
        int n6 = this.separator.rowSepStr.indexOf(this.separator.colSepStr) < 0 ? 0 : 1;
        try {
            int n7;
            block6: while (n3 != -1) {
                int n8;
                n3 = this.reader.read(this.dataBuffer, this.position, this.dataBuffer.length - this.position);
                if (n3 == -1) {
                    n8 = this.position;
                    n4 = this.position;
                    if (bl3) {
                        bl3 = false;
                    }
                } else {
                    n8 = n3 + this.position;
                    this.position = 0;
                }
                block7: for (n7 = 0; n7 < n8; ++n7) {
                    if (n3 != -1 && n7 > n8 - n5) {
                        System.arraycopy(this.dataBuffer, this.position, this.dataBuffer, 0, n8 - this.position);
                        this.position = n8 - this.position;
                        this.colPosition = 0;
                        bl3 = false;
                        continue block6;
                    }
                    int n9 = n7;
                    if (bl3) {
                        if (this.dataBuffer[n7] == this.separator.escapeChar) {
                            if (this.dataBuffer[++n7] == this.separator.escapeChar) {
                                this.columnBuffer[this.colPosition++] = this.separator.escapeChar;
                                if (n7 != n8 - 1) continue;
                                --n7;
                                continue;
                            }
                            --n7;
                            bl3 = false;
                            continue;
                        }
                        this.columnBuffer[this.colPosition++] = this.dataBuffer[n7];
                        continue;
                    }
                    if (this.separator.containsSep && this.dataBuffer[n7] == this.separator.escapeChar) {
                        bl3 = true;
                        continue;
                    }
                    switch (n6) {
                        case 0: {
                            int n10;
                            for (n10 = 0; n10 < cArray.length; ++n10) {
                                if (this.dataBuffer[n7] == cArray[n10]) {
                                    ++n7;
                                } else {
                                    bl = false;
                                    break;
                                }
                                bl = true;
                            }
                            if (bl) {
                                this.byteLength += n7 - this.position - cArray.length;
                                char[] cArray3 = new char[this.colPosition];
                                System.arraycopy(this.columnBuffer, 0, cArray3, 0, this.colPosition);
                                this.setColumn(n2++, cArray3);
                                char[] cfr_ignored_1 = new char[0];
                                this.position = n7--;
                                this.colPosition = 0;
                                bl4 = true;
                            } else {
                                n7 = n9;
                                for (n10 = 0; n10 < cArray2.length; ++n10) {
                                    if (this.dataBuffer[n7] == cArray2[n10]) {
                                        ++n7;
                                    } else {
                                        bl2 = false;
                                        break;
                                    }
                                    bl2 = true;
                                }
                                if (bl2) {
                                    this.byteLength += n7 - this.position - cArray2.length;
                                    char[] cArray4 = new char[this.colPosition];
                                    System.arraycopy(this.columnBuffer, 0, cArray4, 0, this.colPosition);
                                    this.setColumn(n2, cArray4);
                                    char[] cfr_ignored_2 = new char[0];
                                    this.position = n7--;
                                    this.colPosition = 0;
                                    this.handler.endRow();
                                    bl4 = false;
                                    n2 = 1;
                                } else {
                                    this.columnBuffer[this.colPosition++] = this.dataBuffer[n7];
                                }
                            }
                            bl = false;
                            bl2 = false;
                            if (this.position != n8) continue block7;
                            this.position = 0;
                            continue block7;
                        }
                        case 1: {
                            int n10;
                            for (n10 = 0; n10 < cArray2.length; ++n10) {
                                if (this.dataBuffer[n7] == cArray2[n10]) {
                                    ++n7;
                                } else {
                                    bl2 = false;
                                    break;
                                }
                                bl2 = true;
                            }
                            if (bl2) {
                                this.byteLength += n7 - this.position - cArray2.length;
                                char[] cArray5 = new char[this.colPosition];
                                System.arraycopy(this.columnBuffer, 0, cArray5, 0, this.colPosition);
                                this.setColumn(n2, cArray5);
                                char[] cfr_ignored_3 = new char[0];
                                this.position = n7--;
                                this.colPosition = 0;
                                this.handler.endRow();
                                bl4 = false;
                                n2 = 1;
                            } else {
                                n7 = n9;
                                for (n10 = 0; n10 < cArray.length; ++n10) {
                                    if (this.dataBuffer[n7] == cArray[n10]) {
                                        ++n7;
                                    } else {
                                        bl = false;
                                        break;
                                    }
                                    bl = true;
                                }
                                if (bl) {
                                    this.byteLength += n7 - this.position - cArray.length;
                                    char[] cArray6 = new char[this.colPosition];
                                    System.arraycopy(this.columnBuffer, 0, cArray6, 0, this.colPosition);
                                    this.setColumn(n2++, cArray6);
                                    char[] cfr_ignored_4 = new char[0];
                                    this.position = n7--;
                                    this.colPosition = 0;
                                    bl4 = true;
                                } else {
                                    this.columnBuffer[this.colPosition++] = this.dataBuffer[n7];
                                }
                            }
                            bl = false;
                            bl2 = false;
                            if (this.position != n8) continue block7;
                            this.position = 0;
                        }
                    }
                }
            }
            if (bl4) {
                char[] cArray7;
                this.colPosition = 0;
                bl3 = this.separator.containsSep && n4 >= 2 && this.dataBuffer[0] == this.separator.escapeChar;
                if (bl3) {
                    for (n7 = 1; n7 < n4; ++n7) {
                        if (this.dataBuffer[n7] == this.separator.escapeChar) {
                            if (n7 == n4 - 1 || this.dataBuffer[++n7] != this.separator.escapeChar) break;
                            this.columnBuffer[this.colPosition++] = this.separator.escapeChar;
                            continue;
                        }
                        this.columnBuffer[this.colPosition++] = this.dataBuffer[n7];
                    }
                    cArray7 = new char[this.colPosition];
                    System.arraycopy(this.columnBuffer, 0, cArray7, 0, this.colPosition);
                } else {
                    cArray7 = new char[n4];
                    System.arraycopy(this.dataBuffer, 0, cArray7, 0, n4);
                }
                this.setColumn(n2, cArray7);
                this.handler.endRow();
            }
            this.handler.execute();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            if (exception instanceof SQLException) {
                throw (SQLException)exception2;
            }
            throw new OSQLException("OSCAR-00808", "88888", 808, exception2);
        }
    }

    private void setColumn(int n2, char[] object) throws SQLException {
        if (!this.nullMarked && ((char[])object).length != 0) {
            object = CharBuffer.wrap(object);
            object = this.charset.encode((CharBuffer)object).array();
            this.handler.setBytes(n2, (byte[])object);
        }
    }

    public boolean checkClosed() {
        return this.closed;
    }

    public void close() throws SQLException {
        if (this.fileName != null && this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                throw new OSQLException("OSCAR-00808", "88888", 808, iOException);
            }
        }
        this.handler = null;
        this.fileName = null;
        this.reader = null;
        this.dataBuffer = null;
        this.columnBuffer = null;
        this.closed = true;
    }

    public boolean isNullMarked() {
        return this.nullMarked;
    }

    public void setNullMarked(boolean bl) {
        this.nullMarked = bl;
    }

    private static class Separator {
        private static final char c = '\"';
        public String rowSepStr = "\r\n";
        public String colSepStr = "\t";
        public char escapeChar = (char)34;
        public boolean containsSep = true;

        public Separator() {
            String string = System.getProperty("os.name");
            if (string.toUpperCase().startsWith("WIN")) {
                this.rowSepStr = "\r\n";
                this.colSepStr = "\t";
                return;
            }
            if (string.toUpperCase().startsWith("LIN")) {
                this.rowSepStr = "\n";
                this.colSepStr = "\t";
            }
        }
    }
}

