/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class ImportFileWriter {
    private static final int bufferLength = 0x500000;
    private String fileName = null;
    private Writer writer = null;
    private Separator separator = new Separator();
    private char[] columnBuffer = new char[0x500000];
    private char[] columnData = null;
    private int colPosition = 0;
    private int i = 0;
    private boolean containsSep = false;

    public ImportFileWriter(String object, String string, String string2, char c2, boolean bl) throws IOException {
        this.fileName = object;
        object = new File((String)object);
        if (!((File)object).exists()) {
            ((File)object).createNewFile();
        }
        this.writer = new BufferedWriter(new FileWriter((File)object, bl));
        this.init(string, string2, c2);
    }

    public ImportFileWriter(String object, String string, String string2, boolean bl) throws IOException {
        this.fileName = object;
        object = new File((String)object);
        if (!((File)object).exists()) {
            ((File)object).createNewFile();
        }
        this.writer = new BufferedWriter(new FileWriter((File)object, bl));
        this.init(string, string2);
    }

    public ImportFileWriter(Writer writer, String string, String string2, char c2) throws IOException {
        this.writer = writer;
        this.init(string, string2, c2);
    }

    public ImportFileWriter(Writer writer, String string, String string2) throws IOException {
        this.writer = writer;
        this.init(string, string2);
    }

    public void init(String string, String string2, char c2) {
        this.separator.colSep = string;
        this.separator.rowSep = string2;
        this.separator.escapeChar = c2;
    }

    public void init(String string, String string2) {
        this.separator.colSep = string;
        this.separator.rowSep = string2;
        this.separator.containsSep = false;
    }

    public void writeColumn(String string) throws IOException {
        if (!this.separator.containsSep) {
            this.writeColumn1(string);
            return;
        }
        if (string != null) {
            if (string.indexOf(this.separator.colSep) >= 0 || string.indexOf(this.separator.rowSep) >= 0) {
                this.containsSep = true;
            }
            this.columnData = string.toCharArray();
            this.i = 0;
            while (this.i < this.columnData.length) {
                if (this.columnData[this.i] == this.separator.escapeChar) {
                    this.columnBuffer[this.colPosition++] = this.columnData[this.i];
                    this.columnBuffer[this.colPosition++] = this.columnData[this.i];
                    this.containsSep = true;
                } else {
                    this.columnBuffer[this.colPosition++] = this.columnData[this.i];
                }
                ++this.i;
            }
            if (this.containsSep) {
                this.writer.write(new char[]{this.separator.escapeChar});
                this.writer.write(this.columnBuffer, 0, this.colPosition);
                this.writer.write(new char[]{this.separator.escapeChar});
            } else {
                this.writer.write(this.columnData, 0, this.colPosition);
            }
            this.colPosition = 0;
            this.containsSep = false;
        }
    }

    public void writeColumn1(String string) throws IOException {
        if (string != null) {
            this.columnData = string.toCharArray();
            this.writer.write(this.columnData);
        }
    }

    public void nextColumn() throws IOException {
        this.writer.write(this.separator.colSep);
    }

    public void nextRow() throws IOException {
        this.writer.write(this.separator.rowSep);
    }

    public void close() throws IOException {
        if (this.fileName != null && this.writer != null) {
            this.writer.flush();
            this.writer.close();
        }
        this.fileName = null;
        this.writer = null;
        this.separator = null;
        this.columnData = null;
        this.columnBuffer = null;
    }

    private static class Separator {
        public static final char c = '\"';
        public String rowSep = "\r\n";
        public String colSep = "\t";
        public char escapeChar = (char)34;
        public boolean containsSep = true;

        public Separator() {
            String string = System.getProperty("os.name");
            if (string.toUpperCase().startsWith("WIN")) {
                this.rowSep = "\r\n";
                this.colSep = "\t";
                return;
            }
            if (string.toUpperCase().startsWith("LIN")) {
                this.rowSep = "\n";
                this.colSep = "\t";
            }
        }
    }
}

