/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.core.ImportHandler;
import com.oscar.jdbc.OscarImportHandler;
import com.oscar.protocol.a.N;
import com.oscar.util.ImportStream;
import java.sql.SQLException;

public class ImportStream1
extends ImportStream {
    private byte[] buffer;
    private byte[] cache;
    private int bufferOffset = 1;
    private int batchRowCounts = 0;
    private int batchRowsOffset = 1;
    private int batchRowsEnd = 0;
    private ImportDataThread thread;
    private boolean cacheDataFilled = false;
    private boolean ended = false;
    N qp = null;

    public ImportStream1(OscarImportHandler oscarImportHandler) {
        this.handler = oscarImportHandler;
        this.defaultBufferSize = oscarImportHandler.getBufferSize();
        this.buffer = new byte[this.defaultBufferSize];
        this.cache = new byte[this.defaultBufferSize];
        ((ImportStream)this).reInit();
    }

    @Override
    public void reInit() {
        this.cacheSize = 0;
        this.position = 0;
        this.rowPosition = 0;
        this.cacheDataFilled = false;
        this.ended = false;
        this.finished = false;
        this.exFinished = false;
        this.thread = new ImportDataThread();
        this.thread.start();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n3 > byArray.length) {
            throw new NullPointerException();
        }
        if (n3 + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position + n3 < this.defaultBufferSize) {
            System.arraycopy(byArray, n2, this.buffer, this.position, n3);
            this.position += n3;
            return;
        }
        ((ImportStream)this).flush();
        System.arraycopy(byArray, n2, this.buffer, this.position, n3);
        this.position += n3;
    }

    @Override
    public void sendMessage(byte[] byArray) throws SQLException {
        Object object;
        this.currentSql = this.handler.getInsertBulkStr().toString();
        if (this.handler.getHintParam() != null) {
            this.currentSql = this.currentSql + " WITH " + this.handler.getHintParam();
        }
        try {
            this.qp = new N(this.handler.getConnection().getEncoding().encode(this.currentSql), 0);
        }
        catch (SQLException sQLException) {
            object = sQLException;
            sQLException.printStackTrace();
        }
        object = this.handler.getConnection().getProtocol().a;
        synchronized (object) {
            this.handler.getConnection().getProtocol().a(this.handler);
            this.handler.getConnection().getProtocol().a(this.qp);
            if (this.handler.getImportBlockParam() == 1) {
                byte[] byArray2 = new byte[4];
                byte[] byArray3 = byArray2;
                byArray2[0] = (byte)(byArray.length >>> 24);
                byArray3[1] = (byte)(byArray.length >> 16);
                byArray3[2] = (byte)(byArray.length >> 8);
                byArray3[3] = (byte)byArray.length;
                this.handler.getConnection().getProtocol().a(byArray3);
            }
            this.handler.getConnection().getProtocol().a(byArray);
            this.handler.getConnection().getProtocol().d();
        }
        this.updateCount += this.handler.getUpdateCount();
        this.handler.setUpdateCount(this.updateCount);
    }

    public synchronized byte[] getMessage() {
        byte[] byArray = null;
        while (true) {
            if (this.cacheDataFilled) {
                byArray = new byte[this.cacheSize];
                System.arraycopy(this.cache, 0, byArray, 0, this.cacheSize);
                this.cacheDataFilled = false;
                this.notify();
                break;
            }
            if (this.finished) break;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return byArray;
    }

    public synchronized void setMessage() {
        while (!this.ended) {
            if (!this.cacheDataFilled) {
                System.arraycopy(this.buffer, 0, this.cache, 0, this.rowPosition);
                this.cacheSize = this.rowPosition;
                ImportStream1 importStream1 = this;
                importStream1.moveData(importStream1.buffer, 0, this.rowPosition);
                this.cacheDataFilled = true;
                this.batchRowsOffset = this.bufferOffset;
                this.batchRowsEnd = this.batchRowCounts;
                this.bufferOffset = this.batchRowCounts + 1;
                this.notify();
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void finished() {
        this.finished = true;
        while (!this.ended && !this.exFinished) {
            ImportStream1 importStream1 = this;
            synchronized (importStream1) {
                this.notify();
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void flush() {
        this.setMessage();
    }

    public void moveData(byte[] byArray, int n2, int n3) {
        System.arraycopy(this.buffer, n3, this.buffer, 0, this.position - n3);
        this.position -= n3;
        this.rowPosition = 0;
    }

    public void moveData(byte[] byArray) throws SQLException {
        this.moveData(byArray, 0, byArray.length);
    }

    @Override
    public void setRowPosition() {
        this.rowPosition = this.position;
    }

    @Override
    public ImportHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setDefaultBufferSize(int n2) {
        this.defaultBufferSize = n2;
    }

    @Override
    public void close() {
        this.buffer = null;
        this.cache = null;
        this.thread = null;
    }

    @Override
    public void batchRowsIncrease() {
        ++this.batchRowCounts;
    }

    @Override
    public int getBatchRowsOffset() {
        return this.batchRowsOffset;
    }

    @Override
    public int getBatchRowsEnd() {
        return this.batchRowsEnd;
    }

    class ImportDataThread
    extends Thread {
        @Override
        public void run() {
            while (true) {
                Object object;
                if (ImportStream1.this.finished && !ImportStream1.this.cacheDataFilled) {
                    ImportStream1.this.ended = true;
                    return;
                }
                if (ImportStream1.this.exFinished) {
                    ImportStream1.this.ended = true;
                    ImportStream1 importStream1 = ImportStream1.this;
                    object = importStream1;
                    synchronized (importStream1) {
                        ImportStream1.this.notify();
                        // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
                        break;
                    }
                }
                try {
                    object = ImportStream1.this.getMessage();
                    if (object == null) {
                        ImportStream1.this.ended = true;
                        return;
                    }
                    ((ImportStream)ImportStream1.this).sendMessage((byte[])object);
                }
                catch (SQLException sQLException) {
                    ImportStream1.this.threadException = sQLException;
                    ImportStream1.this.exFinished = true;
                }
                catch (Throwable throwable) {
                    ImportStream1.this.threadException = throwable;
                    ImportStream1.this.exFinished = true;
                }
            }
        }
    }
}

