/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.core.ImportHandler;
import com.oscar.jdbc.OscarImportHandler;
import com.oscar.protocol.a.N;
import com.oscar.util.ImportStream;
import java.sql.SQLException;

public class ImportStream2
extends ImportStream {
    private DataBuffer tmpBuffer;
    private DataBuffer currentBuffer = null;
    private DataBuffer backBuffer = null;
    private ImportDataThread thread;
    private boolean ended = false;
    private volatile boolean flushed = false;
    N qp = null;
    Object lock = null;
    Object endLock = null;

    public ImportStream2(OscarImportHandler oscarImportHandler) {
        this.handler = oscarImportHandler;
        this.defaultBufferSize = oscarImportHandler.getBufferSize();
        ImportStream2 importStream2 = this;
        this.currentBuffer = importStream2.new DataBuffer(importStream2.defaultBufferSize);
        ImportStream2 importStream22 = this;
        this.backBuffer = importStream22.new DataBuffer(importStream22.defaultBufferSize);
        this.lock = new Object();
        this.endLock = new Object();
        ((ImportStream)this).reInit();
    }

    @Override
    public void reInit() {
        this.cacheSize = 0;
        this.position = 0;
        this.rowPosition = 0;
        this.ended = false;
        this.flushed = false;
        this.exFinished = false;
        this.thread = new ImportDataThread();
        this.thread.start();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n3 > byArray.length) {
            throw new NullPointerException();
        }
        if (n3 + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position + n3 < this.defaultBufferSize) {
            System.arraycopy(byArray, n2, this.currentBuffer.getBuffer(), this.position, n3);
            this.position += n3;
            this.currentBuffer.setLength(this.position);
            return;
        }
        if (!this.backBuffer.isPreparedForFill()) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.position >= this.rowPosition) {
            System.arraycopy(this.currentBuffer.getBuffer(), this.rowPosition, this.backBuffer.getBuffer(), 0, this.position - this.rowPosition);
        }
        this.currentBuffer.reachFull();
        System.arraycopy(byArray, n2, this.currentBuffer.getBuffer(), this.position, n3);
        this.position += n3;
    }

    public void switchBuffer() {
        Object object = this.lock;
        synchronized (object) {
            this.tmpBuffer = this.currentBuffer;
            this.currentBuffer = this.backBuffer;
            this.backBuffer = this.tmpBuffer;
            return;
        }
    }

    @Override
    public void sendMessage(byte[] byArray) throws SQLException {
        Object object;
        this.currentSql = this.handler.getInsertBulkStr().toString();
        if (this.handler.getHintParam() != null) {
            this.currentSql = this.currentSql + " WITH " + this.handler.getHintParam();
        }
        try {
            this.qp = new N(this.handler.getConnection().getEncoding().encode(this.currentSql), 0);
            this.handler.getConnection().getProtocol().a(this.qp);
        }
        catch (SQLException sQLException) {
            object = sQLException;
            sQLException.printStackTrace();
        }
        object = this.handler.getConnection().getProtocol().a;
        synchronized (object) {
            this.handler.getConnection().getProtocol().a(this.handler);
            this.handler.getConnection().getProtocol().a(this.qp);
            this.handler.getConnection().getProtocol().a(byArray);
            this.handler.getConnection().getProtocol().d();
        }
        this.updateCount += this.handler.getUpdateCount();
        this.handler.setUpdateCount(this.updateCount);
    }

    public void sendMessage(DataBuffer dataBuffer) throws SQLException {
        this.handler.getConnection().getProtocol().a(dataBuffer.getBuffer(), 0, dataBuffer.getLength());
        dataBuffer.setLength(0);
    }

    @Override
    public boolean isFinished() {
        return this.flushed;
    }

    @Override
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            this.flushed = true;
            this.lock.notify();
        }
        object = this.endLock;
        synchronized (object) {
            try {
                if (!this.ended && !this.exFinished) {
                    this.endLock.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
            return;
        }
    }

    @Override
    public void finished() {
        try {
            if (this.currentBuffer.getLength() != 0) {
                ImportStream2 importStream2 = this;
                importStream2.sendMessage(importStream2.currentBuffer);
                this.handler.getConnection().getProtocol().d();
                this.updateCount += this.handler.getUpdateCount();
                this.handler.setUpdateCount(this.updateCount);
                this.currentBuffer.setBatchRowsOffset(this.currentBuffer.getBatchRowsEnd() + 1);
            }
            return;
        }
        catch (SQLException sQLException) {
            this.threadException = sQLException;
            sQLException.printStackTrace();
            return;
        }
    }

    @Override
    public int write() throws SQLException {
        return 0;
    }

    @Override
    public void write(int n2) throws SQLException {
    }

    @Override
    public void setRowPosition() {
        this.rowPosition = this.position;
    }

    @Override
    public ImportHandler getHandler() {
        return this.handler;
    }

    @Override
    public void close() {
        this.currentBuffer = null;
        this.backBuffer = null;
        this.thread = null;
    }

    @Override
    public void batchRowsIncrease() {
        this.currentBuffer.batchRowsIncrease();
    }

    @Override
    public int getBatchRowsOffset() {
        if (this.ended) {
            return this.currentBuffer.getBatchRowsOffset();
        }
        return this.backBuffer.getBatchRowsOffset();
    }

    @Override
    public int getBatchRowsEnd() {
        if (this.ended) {
            return this.currentBuffer.getBatchRowsEnd();
        }
        return this.backBuffer.getBatchRowsEnd();
    }

    class DataBuffer {
        boolean filled = false;
        boolean preparedForFill = true;
        int length = 0;
        int bufferOffset = 1;
        int bufferEnd = 0;
        byte[] buffer;

        public void init() {
            this.setFilled(false);
            this.setPreparedForFill(true);
            this.setLength(0);
        }

        public void reachFull() {
            ImportStream2.this.currentBuffer.setLength(ImportStream2.this.rowPosition);
            this.setPreparedForFill(false);
            this.setFilled(true);
            ImportStream2.this.position -= ImportStream2.this.rowPosition;
            ImportStream2.this.rowPosition = 0;
            Object object = ImportStream2.this.lock;
            synchronized (object) {
                ImportStream2.this.switchBuffer();
                ImportStream2.this.currentBuffer.setBatchRowsEnd(ImportStream2.this.backBuffer.getBatchRowsEnd());
                ImportStream2.this.lock.notify();
                return;
            }
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int n2) {
            this.length = n2;
        }

        public boolean isPreparedForFill() {
            return this.preparedForFill;
        }

        public void setPreparedForFill(boolean bl) {
            this.preparedForFill = bl;
        }

        public boolean isFilled() {
            return this.filled;
        }

        public void setFilled(boolean bl) {
            this.filled = bl;
        }

        public DataBuffer() {
        }

        public DataBuffer(int n2) {
            this.buffer = new byte[n2];
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public int getBatchRowsOffset() {
            return this.bufferOffset;
        }

        public void setBatchRowsOffset(int n2) {
            this.bufferOffset = n2;
        }

        public int getBatchRowsEnd() {
            return this.bufferEnd;
        }

        public void setBatchRowsEnd(int n2) {
            this.bufferEnd = n2;
        }

        public void batchRowsIncrease() {
            ++this.bufferEnd;
        }
    }

    class ImportDataThread
    extends Thread {
        @Override
        public void run() {
            Object object;
            while (!ImportStream2.this.flushed) {
                if (ImportStream2.this.backBuffer.isFilled()) {
                    try {
                        ImportStream2.this.sendMessage(ImportStream2.this.backBuffer);
                    }
                    catch (SQLException sQLException) {
                        ImportStream2.this.exFinished = true;
                    }
                    object = ImportStream2.this.lock;
                    synchronized (object) {
                        ImportStream2.this.backBuffer.init();
                        ImportStream2.this.lock.notify();
                        continue;
                    }
                }
                object = ImportStream2.this.lock;
                synchronized (object) {
                    try {
                        if (!ImportStream2.this.backBuffer.isFilled()) {
                            ImportStream2.this.lock.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        ImportStream2.this.exFinished = true;
                    }
                }
            }
            object = ImportStream2.this.endLock;
            synchronized (object) {
                ImportStream2.this.ended = true;
                ImportStream2.this.endLock.notify();
                return;
            }
        }
    }
}

