/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.jdbc.OscarPreparedStatement;
import com.oscar.jdbc.OscarPreparedStatementV2;
import com.oscar.jdbc.OscarStatement;
import com.oscar.util.OSQLException;
import com.oscar.util.OscarStatementCacheEntry;
import java.sql.SQLException;

public class LRUStatementCache {
    protected int cacheSize;
    protected int numElements;
    protected boolean implicitCacheEnabled;
    protected OscarStatementCacheEntry implicitCacheStart;
    protected OscarStatementCacheEntry implicitCacheEnd;

    public LRUStatementCache(int n2) throws SQLException {
        if (n2 < 0) {
            throw new OSQLException("The initial cache size should not be less than 0.", "");
        }
        this.cacheSize = n2;
        this.numElements = 0;
        this.implicitCacheStart = null;
        this.implicitCacheEnd = null;
        this.implicitCacheEnabled = false;
    }

    public void resize(int n2) throws SQLException {
        if (n2 < 0) {
            throw new OSQLException("The reset cache size value should not be less than 0.", "");
        }
        if (n2 >= this.cacheSize || n2 >= this.numElements) {
            this.cacheSize = n2;
            return;
        }
        OscarStatementCacheEntry oscarStatementCacheEntry = this.implicitCacheEnd;
        while (this.numElements > n2) {
            this.purgeCacheEntry(oscarStatementCacheEntry);
            oscarStatementCacheEntry = oscarStatementCacheEntry.implicitPrev;
        }
        this.cacheSize = n2;
    }

    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        if (!bl) {
            this.purgeImplicitCache();
        }
        this.implicitCacheEnabled = bl;
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        boolean bl = this.cacheSize == 0 ? false : this.implicitCacheEnabled;
        return bl;
    }

    public void addToImplicitCache(OscarPreparedStatement oscarPreparedStatement, String string, int n2, int n3) throws SQLException {
        if (!this.implicitCacheEnabled || this.cacheSize == 0 || oscarPreparedStatement.cacheState == 2 || oscarPreparedStatement.cacheState == 4) {
            return;
        }
        if (this.numElements == this.cacheSize) {
            LRUStatementCache lRUStatementCache = this;
            lRUStatementCache.purgeCacheEntry(lRUStatementCache.implicitCacheEnd);
        }
        OscarStatementCacheEntry oscarStatementCacheEntry = new OscarStatementCacheEntry();
        new OscarStatementCacheEntry().statement = oscarPreparedStatement;
        oscarStatementCacheEntry.onImplicit = true;
        oscarStatementCacheEntry.sql = string;
        oscarStatementCacheEntry.statementType = n2;
        oscarStatementCacheEntry.scrollType = n3;
        oscarStatementCacheEntry.implicitNext = this.implicitCacheStart;
        oscarStatementCacheEntry.implicitPrev = null;
        if (this.implicitCacheStart != null) {
            this.implicitCacheStart.implicitPrev = oscarStatementCacheEntry;
        }
        this.implicitCacheStart = oscarStatementCacheEntry;
        if (this.implicitCacheEnd == null) {
            this.implicitCacheEnd = oscarStatementCacheEntry;
        }
        ++this.numElements;
    }

    public OscarStatement searchImplicitCache(String string, int n2, int n3) throws SQLException {
        if (!this.implicitCacheEnabled) {
            return null;
        }
        OscarStatementCacheEntry oscarStatementCacheEntry = this.implicitCacheStart;
        while (!(oscarStatementCacheEntry == null || oscarStatementCacheEntry.statementType == n2 && oscarStatementCacheEntry.scrollType == n3 && oscarStatementCacheEntry.sql.equals(string))) {
            oscarStatementCacheEntry = oscarStatementCacheEntry.implicitNext;
        }
        if (oscarStatementCacheEntry != null) {
            if (oscarStatementCacheEntry.implicitPrev != null) {
                oscarStatementCacheEntry.implicitPrev.implicitNext = oscarStatementCacheEntry.implicitNext;
            }
            if (oscarStatementCacheEntry.implicitNext != null) {
                oscarStatementCacheEntry.implicitNext.implicitPrev = oscarStatementCacheEntry.implicitPrev;
            }
            if (this.implicitCacheStart == oscarStatementCacheEntry) {
                this.implicitCacheStart = oscarStatementCacheEntry.implicitNext;
            }
            if (this.implicitCacheEnd == oscarStatementCacheEntry) {
                this.implicitCacheEnd = oscarStatementCacheEntry.implicitPrev;
            }
            --this.numElements;
            oscarStatementCacheEntry.statement.exitImplicitCacheToActive();
            return oscarStatementCacheEntry.statement;
        }
        return null;
    }

    public void purgeImplicitCache() throws SQLException {
        OscarStatementCacheEntry oscarStatementCacheEntry = this.implicitCacheStart;
        while (oscarStatementCacheEntry != null) {
            this.purgeCacheEntry(oscarStatementCacheEntry);
            oscarStatementCacheEntry = oscarStatementCacheEntry.implicitNext;
        }
        this.implicitCacheStart = null;
    }

    private void purgeCacheEntry(OscarStatementCacheEntry oscarStatementCacheEntry) throws SQLException {
        if (oscarStatementCacheEntry.onImplicit) {
            if (oscarStatementCacheEntry.implicitNext != null) {
                oscarStatementCacheEntry.implicitNext.implicitPrev = oscarStatementCacheEntry.implicitPrev;
            }
            if (oscarStatementCacheEntry.implicitPrev != null) {
                oscarStatementCacheEntry.implicitPrev.implicitNext = oscarStatementCacheEntry.implicitNext;
            }
            if (this.implicitCacheStart == oscarStatementCacheEntry) {
                this.implicitCacheStart = oscarStatementCacheEntry.implicitNext;
            }
            if (this.implicitCacheEnd == oscarStatementCacheEntry) {
                this.implicitCacheEnd = oscarStatementCacheEntry.implicitPrev;
            }
        }
        --this.numElements;
        if (oscarStatementCacheEntry.onImplicit) {
            oscarStatementCacheEntry.statement.exitImplicitCacheToClose();
        }
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void printCache(String string) throws SQLException {
        System.out.println("*** Start of Statement Cache Dump (" + string + ") ***");
        System.out.println("cache size: " + this.cacheSize + " num elements: " + this.numElements + " implicit enabled: " + this.implicitCacheEnabled);
        System.out.println("implicitStart: " + this.implicitCacheStart);
        OscarStatementCacheEntry oscarStatementCacheEntry = this.implicitCacheStart;
        while (oscarStatementCacheEntry != null) {
            oscarStatementCacheEntry.print();
            oscarStatementCacheEntry = oscarStatementCacheEntry.implicitNext;
        }
        System.out.println("*** End of Statement Cache Dump (" + string + ") ***");
    }

    public void close() throws SQLException {
        OscarStatementCacheEntry oscarStatementCacheEntry = this.implicitCacheStart;
        while (oscarStatementCacheEntry != null) {
            if (oscarStatementCacheEntry.onImplicit) {
                oscarStatementCacheEntry.statement.exitImplicitCacheToClose();
            }
            oscarStatementCacheEntry = oscarStatementCacheEntry.implicitNext;
        }
        this.implicitCacheStart = null;
        this.implicitCacheEnd = null;
        this.numElements = 0;
    }

    public void addToImplicitCache(OscarPreparedStatementV2 oscarPreparedStatementV2, String string, int n2, int n3) throws SQLException {
    }
}

