/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.jdbc.OscarPreparedStatementV2;
import com.oscar.jdbc.OscarStatement;
import com.oscar.util.LRUStatementCache;
import com.oscar.util.OscarStatementCacheEntry;
import java.sql.SQLException;

public class LRUStatementCacheV2
extends LRUStatementCache {
    public LRUStatementCacheV2(int n2) throws SQLException {
        super(n2);
    }

    @Override
    public void addToImplicitCache(OscarPreparedStatementV2 oscarPreparedStatementV2, String string, int n2, int n3) throws SQLException {
        if (!this.implicitCacheEnabled || this.cacheSize == 0 || oscarPreparedStatementV2.cacheState == 2 || oscarPreparedStatementV2.cacheState == 4) {
            return;
        }
        if (this.numElements == this.cacheSize) {
            LRUStatementCacheV2 lRUStatementCacheV2 = this;
            lRUStatementCacheV2.purgeCacheEntry(lRUStatementCacheV2.implicitCacheEnd);
        }
        OscarStatementCacheEntry oscarStatementCacheEntry = new OscarStatementCacheEntry();
        new OscarStatementCacheEntry().statementV2 = oscarPreparedStatementV2;
        oscarStatementCacheEntry.onImplicit = true;
        oscarStatementCacheEntry.sql = string;
        oscarStatementCacheEntry.statementType = n2;
        oscarStatementCacheEntry.scrollType = n3;
        oscarStatementCacheEntry.implicitNext = this.implicitCacheStart;
        oscarStatementCacheEntry.implicitPrev = null;
        if (this.implicitCacheStart != null) {
            this.implicitCacheStart.implicitPrev = oscarStatementCacheEntry;
        }
        this.implicitCacheStart = oscarStatementCacheEntry;
        if (this.implicitCacheEnd == null) {
            this.implicitCacheEnd = oscarStatementCacheEntry;
        }
        ++this.numElements;
    }

    @Override
    public void close() throws SQLException {
        OscarStatementCacheEntry oscarStatementCacheEntry = this.implicitCacheStart;
        while (oscarStatementCacheEntry != null) {
            if (oscarStatementCacheEntry.onImplicit) {
                oscarStatementCacheEntry.statementV2.exitImplicitCacheToClose();
            }
            oscarStatementCacheEntry = oscarStatementCacheEntry.implicitNext;
        }
        this.implicitCacheStart = null;
        this.implicitCacheEnd = null;
        this.numElements = 0;
    }

    @Override
    public OscarStatement searchImplicitCache(String string, int n2, int n3) throws SQLException {
        if (!this.implicitCacheEnabled) {
            return null;
        }
        OscarStatementCacheEntry oscarStatementCacheEntry = this.implicitCacheStart;
        while (!(oscarStatementCacheEntry == null || oscarStatementCacheEntry.statementType == n2 && oscarStatementCacheEntry.scrollType == n3 && oscarStatementCacheEntry.sql.equals(string))) {
            oscarStatementCacheEntry = oscarStatementCacheEntry.implicitNext;
        }
        if (oscarStatementCacheEntry != null) {
            if (oscarStatementCacheEntry.implicitPrev != null) {
                oscarStatementCacheEntry.implicitPrev.implicitNext = oscarStatementCacheEntry.implicitNext;
            }
            if (oscarStatementCacheEntry.implicitNext != null) {
                oscarStatementCacheEntry.implicitNext.implicitPrev = oscarStatementCacheEntry.implicitPrev;
            }
            if (this.implicitCacheStart == oscarStatementCacheEntry) {
                this.implicitCacheStart = oscarStatementCacheEntry.implicitNext;
            }
            if (this.implicitCacheEnd == oscarStatementCacheEntry) {
                this.implicitCacheEnd = oscarStatementCacheEntry.implicitPrev;
            }
            --this.numElements;
            oscarStatementCacheEntry.statementV2.exitImplicitCacheToActive();
            return oscarStatementCacheEntry.statementV2;
        }
        return null;
    }

    protected void purgeCacheEntry(OscarStatementCacheEntry oscarStatementCacheEntry) throws SQLException {
        if (oscarStatementCacheEntry.onImplicit) {
            if (oscarStatementCacheEntry.implicitNext != null) {
                oscarStatementCacheEntry.implicitNext.implicitPrev = oscarStatementCacheEntry.implicitPrev;
            }
            if (oscarStatementCacheEntry.implicitPrev != null) {
                oscarStatementCacheEntry.implicitPrev.implicitNext = oscarStatementCacheEntry.implicitNext;
            }
            if (this.implicitCacheStart == oscarStatementCacheEntry) {
                this.implicitCacheStart = oscarStatementCacheEntry.implicitNext;
            }
            if (this.implicitCacheEnd == oscarStatementCacheEntry) {
                this.implicitCacheEnd = oscarStatementCacheEntry.implicitPrev;
            }
        }
        --this.numElements;
        if (oscarStatementCacheEntry.onImplicit) {
            oscarStatementCacheEntry.statementV2.exitImplicitCacheToClose();
        }
    }
}

