/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class MessageTranslator {
    private static MessageTranslator translator = null;
    private ResourceBundle bundle;
    private static Locale lc;
    private static final String PROP_FILE = "com.oscar.errors";

    private MessageTranslator() {
        lc = Locale.getDefault();
        if (!lc.equals(Locale.SIMPLIFIED_CHINESE)) {
            lc = Locale.ENGLISH;
        }
        this.bundle = PropertyResourceBundle.getBundle(PROP_FILE, lc);
    }

    public static final String translate(String string) {
        if (translator == null) {
            translator = new MessageTranslator();
        }
        return translator._translate(string);
    }

    private final String _translate(String string) {
        return this.bundle.getString(string);
    }

    public static String bind(String string, Object object) {
        return MessageTranslator.internalBind(string, null, String.valueOf(object), null);
    }

    public static String bind(String string, Object object, Object object2) {
        return MessageTranslator.internalBind(string, null, String.valueOf(object), String.valueOf(object2));
    }

    public static String bind(String string, Object[] objectArray) {
        return MessageTranslator.internalBind(string, objectArray, null, null);
    }

    private static String internalBind(String string, Object[] objectArray, String string2, String string3) {
        if (string == null) {
            return "No message available.";
        }
        if (objectArray == null || objectArray.length == 0) {
            objectArray = new Object[]{};
        }
        int n2 = string.length();
        int n3 = n2 + objectArray.length * 5;
        if (string2 != null) {
            n3 += string2.length() - 3;
        }
        if (string3 != null) {
            n3 += string3.length() - 3;
        }
        StringBuffer stringBuffer = new StringBuffer(n3 < 0 ? 0 : n3);
        block6: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '{': {
                    int n4 = string.indexOf(125, i2);
                    if (n4 == -1) {
                        stringBuffer.append(c2);
                        continue block6;
                    }
                    if (++i2 >= n2) {
                        stringBuffer.append(c2);
                        continue block6;
                    }
                    try {
                        i2 = Integer.parseInt(string.substring(i2, n4));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw (IllegalArgumentException)new IllegalArgumentException().initCause(numberFormatException);
                    }
                    if (i2 == 0 && string2 != null) {
                        stringBuffer.append(string2);
                    } else if (i2 == 1 && string3 != null) {
                        stringBuffer.append(string3);
                    } else {
                        if (i2 >= objectArray.length || i2 < 0) {
                            stringBuffer.append("<missing argument>");
                            i2 = n4;
                            continue block6;
                        }
                        stringBuffer.append(objectArray[i2]);
                    }
                    i2 = n4;
                    continue block6;
                }
                case '\'': {
                    int n5 = i2 + 1;
                    if (n5 >= n2) {
                        stringBuffer.append(c2);
                        continue block6;
                    }
                    char c3 = string.charAt(n5);
                    int n4 = c3;
                    if (c3 == '\'') {
                        ++i2;
                        stringBuffer.append(c2);
                        continue block6;
                    }
                    n4 = string.indexOf(39, n5);
                    if (n4 == -1) {
                        stringBuffer.append(c2);
                        continue block6;
                    }
                    stringBuffer.append(string.substring(n5, n4));
                    i2 = n4;
                    continue block6;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }
}

