/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.util.OSQLException;
import java.sql.SQLException;

public class OSCARbyte {
    private OSCARbyte() {
    }

    public static byte[] toBytes(byte[] byArray) throws SQLException {
        if (byArray == null) {
            return null;
        }
        if (byArray.length <= 1) {
            throw new OSQLException("OSCAR-00104", "88888", 104);
        }
        if (byArray[0] != 48 || byArray[1] != 120) {
            throw new OSQLException("OSCAR-00104", "88888", 104);
        }
        int n2 = (byArray.length - 2) / 2;
        byte[] byArray2 = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byArray[(i2 << 1) + 2];
            by = by >= 48 && by <= 57 ? (byte)(by - 48) : (by >= 97 ? (byte)(by - 87) : (byte)(by - 55));
            byte by2 = byArray[(i2 << 1) + 3];
            by2 = by2 >= 48 && by2 <= 57 ? (byte)(by2 - 48) : (by2 >= 97 ? (byte)(by2 - 87) : (byte)(by2 - 55));
            byArray2[i2] = (byte)(by << 4 | by2);
        }
        return byArray2;
    }

    public static String toOSCARString(byte[] byArray) {
        return OSCARbyte.toOscarHexString(byArray, true);
    }

    public static String toOscarHexString(byte[] byArray, boolean n2) {
        if (byArray == null) {
            return null;
        }
        int n3 = byArray.length;
        StringBuilder stringBuilder = new StringBuilder((byArray.length << 1) + 2);
        if (n2 != 0) {
            stringBuilder.append('0');
            stringBuilder.append('x');
        }
        for (n2 = 0; n2 < n3; ++n2) {
            byte by = (byte)(byArray[n2] >>> 4 & 0xF);
            byte by2 = (byte)(byArray[n2] & 0xF);
            if (by <= 9) {
                stringBuilder.append(by);
            } else {
                stringBuilder.append((char)(by + 65 - 10));
            }
            if (by2 <= 9) {
                stringBuilder.append(by2);
                continue;
            }
            stringBuilder.append((char)(by2 + 65 - 10));
        }
        return stringBuilder.toString();
    }

    public static byte[] getOscarHexBytes(byte[] object) {
        String string = OSCARbyte.toOSCARString(object);
        object = string;
        return string.getBytes();
    }

    public static byte[] getOscarHexBytes(byte[] object, boolean bl) {
        String string = OSCARbyte.toOscarHexString(object, bl);
        object = string;
        return string.getBytes();
    }
}

