/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;

public class Oscar42Helper {
    public static Object convertLocalTo(Object object) {
        if (object instanceof LocalDate) {
            return Date.valueOf((LocalDate)object);
        }
        if (object instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)object);
        }
        if (object instanceof LocalTime) {
            return Time.valueOf((LocalTime)object);
        }
        if (object instanceof OffsetTime) {
            return object.toString();
        }
        if (object instanceof OffsetDateTime) {
            return object.toString();
        }
        if (object instanceof Period) {
            return ((Period)object).getYears() + "-" + ((Period)object).getMonths();
        }
        if (object instanceof Duration) {
            object = (Duration)object;
            return Oscar42Helper.formatDuration((Duration)object);
        }
        return object;
    }

    public static String formatPeriod(Period period) {
        long l2 = period.getYears();
        long l3 = period.getMonths();
        return String.format("%d-%02d", l2, l3);
    }

    public static String formatDuration(Duration duration) {
        long l2 = duration.toDays();
        long l3 = duration.toHours() % 24L;
        long l4 = duration.toMinutes() % 60L;
        long l5 = duration.getSeconds() % 60L;
        return String.format("%d %02d:%02d:%02d", l2, l3, l4, l5);
    }

    public static void main(String[] stringArray) {
        System.out.println(Oscar42Helper.formatPeriod(Period.ofDays(1000)));
    }
}

