/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.core.BaseConnection;
import com.oscar.jdbc.entity.ParamInfo;
import com.oscar.util.OSQLException;
import com.oscar.util.TableNameParser;
import com.oscar.util.Word;
import com.oscar.util.Yylex;
import java.io.CharArrayReader;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OscarSqlProcessor {
    protected static final short IN_SQLCODE = 0;
    protected static final short IN_STRING = 1;
    protected static final short BACKSLASH = 2;
    protected static final short ESC_TIMEDATE = 3;
    protected static final short ESC_FN = 4;
    protected static final short ESC_OJ = 5;
    protected static final short ESC_ESC = 6;

    public static ParseResult parsing(String string) throws OSQLException {
        return OscarSqlProcessor.parsing(string, false);
    }

    public static ParseResult parsingWithCheck(String string) throws OSQLException {
        return OscarSqlProcessor.parsingWithCheck(string, false);
    }

    public static ParseResult parsingWithCheck(String object, boolean bl) throws OSQLException {
        if (object == null || ((String)object).trim().length() == 0) {
            throw new OSQLException("OSCAR-00433", "88888", 433);
        }
        if (((ParseResult)(object = OscarSqlProcessor.parsing((String)object, bl))).hasInsertBulk) {
            throw new OSQLException("OSCAR-00436", "88888", 436);
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ParseResult parsing(String string, boolean bl) throws OSQLException {
        boolean bl7;
        ParseResult parseResult;
        boolean bl2;
        String string2;
        ArrayList<Word> arrayList;
        ArrayList<Word> arrayList2;
        int n4;
        int n5;
        int n6;
        block48: {
            Word word;
            int n3;
            block46: {
                block55: {
                    block54: {
                        block52: {
                            boolean bl3;
                            boolean bl4;
                            block53: {
                                int n7;
                                block51: {
                                    block50: {
                                        block49: {
                                            int n2;
                                            block47: {
                                                n7 = 0;
                                                n6 = 0;
                                                n5 = 0;
                                                n4 = 0;
                                                boolean bl5 = false;
                                                n3 = -1;
                                                arrayList2 = new ArrayList<Word>();
                                                arrayList = new ArrayList<Word>();
                                                string2 = null;
                                                bl4 = false;
                                                bl3 = false;
                                                n2 = -1;
                                                Yylex yylex = null;
                                                bl2 = false;
                                                try {
                                                    Word word2;
                                                    yylex = new Yylex(new CharArrayReader(string.toCharArray()), string.length());
                                                    boolean bl6 = false;
                                                    block22: while ((word2 = yylex.yylex()).getType() != 0 && !bl6) {
                                                        arrayList2.add(word2);
                                                        switch (word2.getType()) {
                                                            case 159: {
                                                                n2 = arrayList2.size() - 1;
                                                                continue block22;
                                                            }
                                                            case 0: 
                                                            case 112: {
                                                                continue block22;
                                                            }
                                                            case 102: 
                                                            case 121: {
                                                                if (n3 != -1) continue block22;
                                                                n3 = arrayList2.size() - 1;
                                                                bl5 = true;
                                                                continue block22;
                                                            }
                                                            case 100: 
                                                            case 101: 
                                                            case 104: 
                                                            case 105: 
                                                            case 106: 
                                                            case 109: 
                                                            case 110: 
                                                            case 111: 
                                                            case 113: 
                                                            case 114: 
                                                            case 115: 
                                                            case 116: 
                                                            case 117: 
                                                            case 118: 
                                                            case 119: 
                                                            case 120: 
                                                            case 122: 
                                                            case 123: 
                                                            case 158: 
                                                            case 161: 
                                                            case 162: {
                                                                if (n3 != -1) continue block22;
                                                                n3 = arrayList2.size() - 1;
                                                                continue block22;
                                                            }
                                                            case 103: {
                                                                ++n7;
                                                                continue block22;
                                                            }
                                                            case 150: 
                                                            case 151: 
                                                            case 152: 
                                                            case 153: 
                                                            case 154: 
                                                            case 155: 
                                                            case 156: {
                                                                ++n5;
                                                                continue block22;
                                                            }
                                                            case 300: {
                                                                ++n4;
                                                                continue block22;
                                                            }
                                                            case 10: {
                                                                ++n6;
                                                                continue block22;
                                                            }
                                                            case 14: {
                                                                arrayList.add(word2);
                                                                continue block22;
                                                            }
                                                            case 16: {
                                                                String string3;
                                                                if (n3 >= 0 && 101 == ((Word)arrayList2.get(n3)).getType()) continue block22;
                                                                int n8 = word2.getTokenBegin();
                                                                arrayList.add(word2);
                                                                if (n8 == 0) {
                                                                    String string4 = word2.getTokentext();
                                                                    if (string2 == null) {
                                                                        string2 = string.substring(0, string.length() - string4.length()) + "?";
                                                                        continue block22;
                                                                    }
                                                                    string2 = string2.substring(0, string2.length() - string4.length()) + "?";
                                                                    continue block22;
                                                                }
                                                                if (string2 == null) {
                                                                    string3 = string.substring(0, n8);
                                                                } else {
                                                                    int n9 = string.length() - string2.length();
                                                                    if (n9 >= n8) {
                                                                        bl6 = true;
                                                                        continue block22;
                                                                    }
                                                                    string3 = string2.substring(0, n8 - n9);
                                                                }
                                                                String string5 = string.substring(word2.getTokenEnd());
                                                                string2 = string3 + "?" + string5;
                                                                continue block22;
                                                            }
                                                            case 124: {
                                                                if (!bl5) continue block22;
                                                                bl3 = true;
                                                                continue block22;
                                                            }
                                                            case 160: {
                                                                int n10;
                                                                Word word22;
                                                                if (n3 < 0 || arrayList2.size() < 2 || (word22 = (Word)arrayList2.get(n10 = arrayList2.size() - 2)).getType() != 104 || n10 - 1 >= 0 && 114 == ((Word)arrayList2.get(n10 - 1)).getType()) continue block22;
                                                                bl2 = true;
                                                                continue block22;
                                                            }
                                                        }
                                                        if (!word2.getTokentext().equalsIgnoreCase("currval") && !word2.getTokentext().equalsIgnoreCase("nextval") || !bl5) continue;
                                                        bl4 = true;
                                                    }
                                                }
                                                catch (IOException iOException) {
                                                    try {
                                                        throw new OSQLException(iOException.getMessage(), "88888");
                                                    }
                                                    catch (Throwable throwable) {
                                                        if (yylex == null) throw throwable;
                                                        try {
                                                            yylex.yyclose();
                                                            throw throwable;
                                                        }
                                                        catch (IOException iOException2) {
                                                            IOException iOException4 = iOException2;
                                                            iOException2.printStackTrace();
                                                        }
                                                        throw throwable;
                                                    }
                                                }
                                                try {
                                                    yylex.yyclose();
                                                }
                                                catch (IOException iOException) {
                                                    IOException iOException2 = iOException;
                                                    iOException.printStackTrace();
                                                }
                                                parseResult = new ParseResult();
                                                bl7 = false;
                                                if (n3 != -1) break block47;
                                                parseResult.selectSql = false;
                                                parseResult.ddlSql = false;
                                                break block48;
                                            }
                                            word = (Word)arrayList2.get(n3);
                                            if (word.getType() == 109) break block48;
                                            if (word.getType() != 104) break block49;
                                            parseResult.insertSql = true;
                                            parseResult.valuesWordIndex = n2;
                                            parseResult.dmlSql = true;
                                            break block46;
                                        }
                                        if (word.getType() != 105 && word.getType() != 106 && word.getType() != 114 && word.getType() != 122) break block50;
                                        parseResult.dmlSql = true;
                                        break block46;
                                    }
                                    if (word.getType() != 115 && word.getType() != 101 && word.getType() != 113 && word.getType() != 110 && word.getType() != 119 && word.getType() != 118) break block51;
                                    parseResult.ddlSql = true;
                                    break block46;
                                }
                                if (word.getType() != 102) break block52;
                                if (n7 <= 0) break block53;
                                parseResult.dmlSql = true;
                                break block46;
                            }
                            if (bl4) {
                                parseResult.fenormalSelect = true;
                                break block46;
                            } else if (bl3) {
                                parseResult.selectForUpdate = true;
                                parseResult.selectSql = true;
                                break block46;
                            } else {
                                parseResult.selectSql = true;
                            }
                            break block46;
                        }
                        if (word.getType() != 100 && word.getType() != 120 && word.getType() != 121) break block54;
                        parseResult.fenormalSelect = true;
                        break block46;
                    }
                    if (word.getType() != 111) break block55;
                    if (arrayList2.size() > 1) {
                        for (int i2 = 1; i2 < arrayList2.size(); ++i2) {
                            if (((Word)arrayList2.get(i2)).getType() != 116) continue;
                            parseResult.isAnonymous = true;
                            break block46;
                        }
                    }
                    break block46;
                }
                if (word.getType() == 116 && arrayList2.size() > 1) {
                    for (int i3 = 1; i3 < arrayList2.size(); ++i3) {
                        if (((Word)arrayList2.get(i3)).getType() != 157) continue;
                        parseResult.isAnonymous = true;
                        break;
                    }
                }
            }
            if (word.getType() == 121) {
                if (((Word)arrayList2.get(n3 + 1)).getTokentext().equalsIgnoreCase("function")) {
                    bl7 = true;
                    parseResult.selectSql = false;
                } else {
                    parseResult.selectSql = true;
                }
            }
        }
        if (n5 > 0 || n4 > 0) {
            parseResult.hasAggFunctionInSelect = true;
        }
        parseResult.questionMarks = arrayList;
        if (string2 != null) {
            parseResult.transSql = string2;
        } else {
            parseResult.transSql = string;
        }
        if (bl7) {
            parseResult.sqlCounts = 1;
        } else {
            int n11 = n6 + 1;
            for (int i4 = arrayList2.size() - 1; i4 >= 0 && ((Word)arrayList2.get(i4)).getType() == 10; --n11, --i4) {
            }
            parseResult.sqlCounts = n11;
        }
        if (bl) {
            parseResult.words = arrayList2;
        }
        parseResult.hasInsertBulk = bl2;
        if (!bl2) return parseResult;
        parseResult.insertSql = false;
        return parseResult;
    }

    public static boolean isSelectStatement(String string) throws OSQLException {
        return OscarSqlProcessor.parsing(string).isSelectSql();
    }

    /*
     * Loose catch block
     */
    public static boolean whetherToUseCursor(String object) {
        boolean bl;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        block31: {
            if (object == null || ((String)object).trim().length() == 0) {
                return false;
            }
            n17 = 0;
            n16 = 0;
            n15 = 0;
            n14 = 0;
            n13 = 0;
            n12 = 0;
            n11 = 0;
            n10 = 0;
            n9 = 0;
            n8 = 0;
            n7 = 0;
            n6 = 0;
            n5 = 0;
            n4 = 0;
            n3 = 0;
            n2 = 0;
            bl = false;
            Yylex yylex = null;
            yylex = new Yylex(new CharArrayReader(((String)object).toCharArray()), ((String)object).length());
            while (((Word)(object = yylex.yylex())).getType() != 0) {
                if (((Word)object).getType() == 102) {
                    ++n17;
                    continue;
                }
                if (((Word)object).getType() == 101) {
                    ++n16;
                    break;
                }
                if (((Word)object).getType() == 100) {
                    ++n14;
                    break;
                }
                if (((Word)object).getType() == 103) {
                    ++n15;
                    break;
                }
                if (((Word)object).getType() == 105) {
                    ++n13;
                    break;
                }
                if (((Word)object).getType() == 106) {
                    ++n9;
                    break;
                }
                if (((Word)object).getType() == 112) {
                    ++n8;
                    break;
                }
                if (((Word)object).getType() == 109) {
                    ++n12;
                    break;
                }
                if (((Word)object).getType() == 110) {
                    ++n11;
                    break;
                }
                if (((Word)object).getType() == 113) {
                    ++n7;
                    break;
                }
                if (((Word)object).getType() == 111) {
                    ++n10;
                    break;
                }
                if (((Word)object).getType() == 115) {
                    ++n5;
                    break;
                }
                if (((Word)object).getType() == 114) {
                    ++n6;
                    break;
                }
                if (((Word)object).getType() == 150 || ((Word)object).getType() == 151 || ((Word)object).getType() == 152 || ((Word)object).getType() == 153 || ((Word)object).getType() == 154 || ((Word)object).getType() == 155 || ((Word)object).getType() == 156) {
                    ++n2;
                    continue;
                }
                if (((Word)object).getType() == 300) {
                    ++n3;
                    break;
                }
                if (((Word)object).getType() == 116 || ((Word)object).getType() == 117) {
                    ++n4;
                    break;
                }
                if (!((Word)object).getTokentext().equalsIgnoreCase("currval") && !((Word)object).getTokentext().equalsIgnoreCase("nextval") || n17 <= 0) break;
                bl = true;
                break;
            }
            yylex.yyclose();
            try {
                yylex.yyclose();
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
            }
            break block31;
            catch (Exception exception) {
                block30: {
                    try {
                        object = exception;
                        exception.printStackTrace();
                        if (yylex == null) break block30;
                    }
                    catch (Throwable throwable) {
                        if (yylex != null) {
                            try {
                                yylex.yyclose();
                            }
                            catch (IOException iOException) {
                                IOException iOException2 = iOException;
                                iOException.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                    try {
                        yylex.yyclose();
                    }
                    catch (IOException iOException) {
                        object = iOException;
                        iOException.printStackTrace();
                    }
                }
                return false;
            }
        }
        if (n17 > 0 && n14 == 0 && n16 == 0 && n13 == 0 && n12 == 0 && n11 == 0 && n10 == 0 && n2 == 0 && n15 == 0 && n8 == 0 && n9 == 0 && n7 == 0 && n6 == 0 && n5 == 0 && n4 == 0 && !bl) {
            return true;
        }
        return n2 != 0 && n3 != 0;
    }

    public static String replaceProcessing(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        int n3 = -1;
        int n4 = string.length();
        while (++n3 < n4) {
            char c2 = string.charAt(n3);
            switch (n2) {
                case 0: {
                    if (c2 == '\'') {
                        n2 = 1;
                    } else if (c2 == '{' && n3 + 1 < n4) {
                        char c3 = string.charAt(n3 + 1);
                        char c4 = string.charAt(n3 + 2);
                        if (c3 == 'd' || c3 == 'D') {
                            n2 = 3;
                            ++n3;
                            break;
                        }
                        if (c3 == 't' || c3 == 'T') {
                            n2 = 3;
                            int n5 = n3;
                            n3 = n5 + (n5 + 2 < n4 && (string.charAt(n3 + 2) == 's' || string.charAt(n3 + 2) == 'S') ? 2 : 1);
                            break;
                        }
                        if (c3 == 'f' && c4 == 'n' || c3 == 'F' && c4 == 'N') {
                            n2 = 4;
                            n4 = string.indexOf("}", (n3 += 2) + 1);
                            string = string.substring(0, n3 + 1).concat(OscarSqlProcessor.funcNameReplace(string.substring(n3 + 1, n4))).concat(string.substring(n4));
                            n4 = string.length();
                            break;
                        }
                        if (c3 == 'o' && c4 == 'j' || c3 == 'O' && c4 == 'J') {
                            n2 = 5;
                            n3 += 2;
                            break;
                        }
                        if (c3 == 'E' && c4 == 'S' || c3 == 'e' && c4 == 's') {
                            n2 = 6;
                            break;
                        }
                    }
                    stringBuffer.append(c2);
                    break;
                }
                case 1: {
                    if (c2 == '\'') {
                        n2 = 0;
                    } else if (c2 == '\\') {
                        n2 = 2;
                    }
                    stringBuffer.append(c2);
                    break;
                }
                case 2: {
                    n2 = 1;
                    stringBuffer.append(c2);
                    break;
                }
                case 3: {
                    if (c2 == '}') {
                        n2 = 0;
                        break;
                    }
                    stringBuffer.append(c2);
                    break;
                }
                case 4: {
                    if (c2 == '}') {
                        n2 = 0;
                        break;
                    }
                    stringBuffer.append(c2);
                    break;
                }
                case 5: {
                    if (c2 == '}') {
                        n2 = 0;
                        break;
                    }
                    stringBuffer.append(c2);
                    break;
                }
                case 6: {
                    if (c2 == '}') {
                        n2 = 0;
                        break;
                    }
                    if (c2 == '\\') {
                        stringBuffer.append(c2);
                        stringBuffer.append('\\');
                        break;
                    }
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String funcNameReplace(String string) {
        String string2 = string.toUpperCase();
        if (string2.indexOf("CONVERT") >= 0) {
            int n2 = string.lastIndexOf(",");
            if (string.lastIndexOf("DOUBLE") > n2) {
                return string.substring(0, n2 + 1).concat("DOUBLE PRECISION)");
            }
            if (string.lastIndexOf("VARCHAR") > n2) {
                return string.substring(0, n2 + 1).concat("VARCHAR(8000))");
            }
            if (string.lastIndexOf("CHAR") > n2) {
                return string.substring(0, n2 + 1).concat("CHAR(8000))");
            }
            if (string2.lastIndexOf("VARBINARY") > n2) {
                return string.substring(0, n2 + 1).concat("VARBINARY(8000))");
            }
            if (string2.lastIndexOf("BINARY") > n2) {
                return string.substring(0, n2 + 1).concat("BINARY(8000))");
            }
            if (string2.lastIndexOf("LONGVARBINARY") > n2) {
                return string.substring(0, n2 + 1).concat("BLOB)");
            }
            if (string2.lastIndexOf("LONGVARCHAR") > n2) {
                return string.substring(0, n2 + 1).concat("CLOB)");
            }
            return string;
        }
        if (string2.indexOf("CHAR") >= 0) {
            return string2.replaceAll("CHAR", "CHR");
        }
        if (string2.indexOf("TIMESTAMPADD") >= 0 || string2.indexOf("TIMESTAMPDIFF") >= 0) {
            String string3 = string2.substring(string.indexOf("(") + 1, string.indexOf(",")).trim();
            if (string3.compareTo("SQL_TSI_FRAC_SECOND") == 0) {
                return string2.replaceAll("SQL_TSI_FRAC_SECOND", "0");
            }
            if (string3.compareTo("SQL_TSI_SECOND") == 0) {
                return string2.replaceAll("SQL_TSI_SECOND", "1");
            }
            if (string3.compareTo("SQL_TSI_MINUTE") == 0) {
                return string2.replaceAll("SQL_TSI_MINUTE", "2");
            }
            if (string3.compareTo("SQL_TSI_HOUR") == 0) {
                return string2.replaceAll("SQL_TSI_HOUR", "3");
            }
            if (string3.compareTo("SQL_TSI_DAY") == 0) {
                return string2.replaceAll("SQL_TSI_DAY", "4");
            }
            if (string3.compareTo("SQL_TSI_WEEK") == 0) {
                return string2.replaceAll("SQL_TSI_WEEK", "5");
            }
            if (string3.compareTo("SQL_TSI_MONTH") == 0) {
                return string2.replaceAll("SQL_TSI_MONTH", "6");
            }
            if (string3.compareTo("SQL_TSI_QUARTER") == 0) {
                return string2.replaceAll("SQL_TSI_QUARTER", "7");
            }
            if (string3.compareTo("SQL_TSI_YEAR") == 0) {
                return string2.replaceAll("SQL_TSI_YEAR", "8");
            }
            return string;
        }
        if (string2.indexOf("HOUR") >= 0) {
            return string2.replaceAll("HOUR", "\"HOUR\"");
        }
        if (string2.indexOf("MINUTE") >= 0) {
            return string2.replaceAll("MINUTE", "\"MINUTE\"");
        }
        if (string2.indexOf("MONTH") >= 0 && string2.indexOf("DAYOFMONTH") == -1 && string2.indexOf("MONTHNAME") == -1) {
            return string2.replaceAll("MONTH", "\"MONTH\"");
        }
        if (string2.indexOf("SECOND") >= 0) {
            return string2.replaceAll("SECOND", "\"SECOND\"");
        }
        if (string2.indexOf("YEAR") >= 0 && string2.indexOf("DAYOFYEAR") == -1) {
            return string2.replaceAll("YEAR", "\"YEAR\"");
        }
        if (string2.indexOf("USER") >= 0) {
            return string2.replaceAll("USER", "\"CURRENT_USER\"");
        }
        if (string2.indexOf("INSERT") >= 0) {
            String string4 = string;
            return "INSERT_TEXT".concat(string4.substring(string4.indexOf(40)));
        }
        if (string2.indexOf("NOW") >= 0) {
            return "NOW()::TIMESTAMP";
        }
        return string;
    }

    public static ParseFunctionResult modifyJdbcCall(String object, BaseConnection baseConnection) throws SQLException {
        if (object == null || ((String)object).trim().length() == 0) {
            throw new OSQLException("OSCAR-00433", "88888", 433);
        }
        ParseFunctionResult parseFunctionResult = new ParseFunctionResult();
        object = ((String)object).trim();
        int n2 = OscarSqlProcessor.isRealCallable((String)object);
        parseFunctionResult.isCallable = n2 != 0;
        if (n2 == 0) {
            parseFunctionResult.afterSql = (String)object;
            object = OscarSqlProcessor.parseToAllWords((String)object);
            if (object.size() > 0) {
                Object object2 = (Word)object.get(0);
                if (((Word)object2).getType() == 111) {
                    object2 = object.iterator();
                    while (object2.hasNext()) {
                        Word word = (Word)object2.next();
                        if (word.getType() != 116) continue;
                        parseFunctionResult.isAnonymous = true;
                        break;
                    }
                } else if (((Word)object2).getType() == 116) {
                    object2 = object.iterator();
                    while (object2.hasNext()) {
                        Word word = (Word)object2.next();
                        if (word.getType() != 157) continue;
                        parseFunctionResult.isAnonymous = true;
                        break;
                    }
                }
            }
            return parseFunctionResult;
        }
        if (((String)object).indexOf("=") >= 0) {
            parseFunctionResult.isResultNeeded = true;
            if (((String)object).indexOf("?") >= ((String)object).indexOf("=")) {
                throw new OSQLException("OSCAR-00414", "88888", 414);
            }
        }
        if (((String)object).startsWith("{") && ((String)object).endsWith("}")) {
            object = ((String)object).substring(1, ((String)object).length() - 1);
        }
        if ((n2 = ((String)object).toLowerCase().indexOf("call")) == -1) {
            throw new OSQLException("OSCAR-00414", "88888", 414);
        }
        object = ((String)object).replace('{', ' ');
        object = ((String)object).replace('}', ' ');
        object = ((String)object).replace(';', ' ');
        object = ((String)object).substring(n2 + 4);
        String string = ((String)object).trim();
        List<Word> list = OscarSqlProcessor.parseToAllWords(string);
        ArrayList<Word> arrayList = new ArrayList<Word>();
        for (Word word : list) {
            if (word.getTokentext().equals("(")) break;
            arrayList.add(word);
        }
        int n3 = arrayList.size();
        if (n3 > 0) {
            switch (arrayList.size()) {
                case 1: {
                    parseFunctionResult.objectName = TableNameParser.dbStringToOrgString(((Word)arrayList.get(0)).getTokentext());
                    break;
                }
                case 3: {
                    if (list.get(1).getType() != 13) {
                        throw new SQLException("\u975e\u6cd5\u7684\u5bf9\u8c61\u540d\u683c\u5f0f\uff1a" + string);
                    }
                    parseFunctionResult.objectName = TableNameParser.dbStringToOrgString(((Word)arrayList.get(2)).getTokentext());
                    parseFunctionResult.schemaName = TableNameParser.dbStringToOrgString(((Word)arrayList.get(0)).getTokentext());
                    break;
                }
                case 5: {
                    if (list.get(1).getType() != 13 || list.get(3).getType() != 13) {
                        throw new SQLException("\u975e\u6cd5\u7684\u5bf9\u8c61\u540d\u683c\u5f0f\uff1a" + string);
                    }
                    parseFunctionResult.schemaName = TableNameParser.dbStringToOrgString(((Word)arrayList.get(0)).getTokentext());
                    parseFunctionResult.objectName = TableNameParser.dbStringToOrgString(((Word)arrayList.get(4)).getTokentext());
                    parseFunctionResult.packageName = TableNameParser.dbStringToOrgString(((Word)arrayList.get(2)).getTokentext());
                    break;
                }
                default: {
                    throw new SQLException("\u975e\u6cd5\u7684\u5bf9\u8c61\u540d\u683c\u5f0f\uff1a" + string);
                }
            }
        }
        if (parseFunctionResult.isResultNeeded) {
            object = "EXEC OUT " + (String)object;
            parseFunctionResult.haveFuncReturn = true;
            parseFunctionResult.isFunc = true;
        } else {
            try {
                OscarSqlProcessor.initObjectInfo(parseFunctionResult, baseConnection);
                object = parseFunctionResult.isFunc ? "EXEC OUT" + (String)object : "EXEC IN" + (String)object;
            }
            catch (SQLException sQLException) {
                throw new OSQLException("OSCAR-00414", "88888", 414, sQLException);
            }
        }
        if (((String)object).indexOf(40) < 0) {
            object = (String)object + "()";
        }
        parseFunctionResult.afterSql = (String)object;
        return parseFunctionResult;
    }

    public static List<Word> parseToAllWords(String object) throws SQLException {
        if (object == null) {
            return null;
        }
        try {
            ArrayList<Word> arrayList = new ArrayList<Word>();
            object = new Yylex(new CharArrayReader(((String)object).toCharArray()), ((String)object).length());
            Word word = ((Yylex)object).yylex();
            while (word.getType() != 0) {
                arrayList.add(word);
                word = ((Yylex)object).yylex();
            }
            return arrayList;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initObjectInfo(ParseFunctionResult parseFunctionResult, BaseConnection baseConnection) throws SQLException {
        if (parseFunctionResult.packageName != null) {
            OscarSqlProcessor.initPackageObjectInfo(parseFunctionResult, baseConnection);
            return;
        }
        ResultSet resultSet = null;
        try {
            String string = parseFunctionResult.getObjectName();
            String string2 = parseFunctionResult.getSchemaName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("select proc.PROISFUNC ,params.PROCOID, params.PARAMNAME,params.POSITION,params.PARAMTYP,params.PARAMINOUT ");
            stringBuffer.append("from INFO_SCHEM.v_sys_proc proc left join INFO_SCHEM.v_sys_proc_params params on(params.PROCOID=proc.oid and params.POSITION>0) ");
            stringBuffer.append("where proc.proname='");
            stringBuffer.append(string + "'");
            if (string2 != null) {
                stringBuffer.append(" and proc.PRONAMESPACE=(select oid from INFO_SCHEM.v_sys_namespace where NSPNAME='");
                stringBuffer.append(string2 + "')");
            }
            resultSet = baseConnection.execSQL(stringBuffer.toString());
            while (resultSet.next()) {
                parseFunctionResult.isFunc = resultSet.getBoolean(1);
                parseFunctionResult.haveFuncReturn = false;
                parseFunctionResult.addParam(new ParamInfo(resultSet.getInt(2), resultSet.getString(3), resultSet.getInt(4), resultSet.getInt(5), resultSet.getInt(6)));
            }
            if (resultSet == null) return;
        }
        catch (Throwable throwable) {
            if (resultSet == null) throw throwable;
            resultSet.close();
            throw throwable;
        }
        resultSet.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initPackageObjectInfo(ParseFunctionResult parseFunctionResult, BaseConnection baseConnection) throws SQLException {
        String string = parseFunctionResult.getPackageName();
        Object object = parseFunctionResult.getObjectName();
        Object object2 = parseFunctionResult.getSchemaName();
        string = "select PROISFUNC,OID from INFO_SCHEM.v_sys_package_subprogram  where obj_name='" + string + "' and PRONAME ='" + (String)object + "' and PRONAMESPACE = (select oid from INFO_SCHEM.v_sys_namespace where NSPNAME='" + (String)object2 + "')";
        object = null;
        object2 = null;
        try {
            try {
                object = baseConnection.execSQL(string);
            }
            catch (SQLException sQLException) {
                SQLException sQLException2 = sQLException;
                if (!sQLException.getMessage().contains("does not exist")) throw sQLException2;
                string = string.replace("v_sys_package_subprogram", "sys_package_subprogram");
                object = baseConnection.execSQL(string);
            }
        }
        catch (SQLException sQLException) {
            try {
                SQLException sQLException3 = sQLException;
                throw sQLException;
            }
            catch (Throwable throwable) {
                try {
                    if (object != null) {
                        object.close();
                    }
                    if (object2 == null) throw throwable;
                    object2.close();
                    throw throwable;
                }
                catch (SQLException sQLException2) {}
                throw throwable;
            }
        }
        while (object.next()) {
            parseFunctionResult.isFunc = object.getInt(1) == 1;
            parseFunctionResult.haveFuncReturn = false;
            long l2 = object.getLong(2);
            object2 = baseConnection.execSQL("select PARAMNAME,POSITION,PARAMTYP,PARAMINOUT from INFO_SCHEM.v_sys_proc_params where PROCOID = " + l2 + " and POSITION > 0 ");
            while (object2.next()) {
                parseFunctionResult.addParam(new ParamInfo(l2, object2.getString(1), object2.getInt(2), object2.getInt(3), object2.getInt(4)));
            }
        }
        try {
            if (object != null) {
                object.close();
            }
            if (object2 == null) return;
            object2.close();
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    private static boolean isRealCallable(String string) {
        if (string.startsWith("{")) {
            return true;
        }
        return string.toLowerCase().startsWith("call");
    }

    public static String removeEndSemicolons(String string) {
        char[] cArray = string.toCharArray();
        int n2 = -1;
        for (int i2 = cArray.length - 1; i2 > 0; --i2) {
            if (cArray[i2] == ';') {
                n2 = i2;
                continue;
            }
            if (!Character.isWhitespace(cArray[i2])) break;
        }
        if (n2 != -1) {
            return string.substring(0, n2);
        }
        return string;
    }

    public static String makeSqlEndWithReturnGeneratedKeys(String string) {
        return OscarSqlProcessor.removeEndSemicolons(string).concat(" return_generated_keys");
    }

    public static void main(String[] object) throws OSQLException {
        object = "/*select * from dual where x=?*/SELECT CREATED FROM E9.HRMRESOURCE where a=?;";
        object = OscarSqlProcessor.parsing("/*select * from dual where x=?*/SELECT CREATED FROM E9.HRMRESOURCE where a=?;");
        System.out.println(((ParseResult)object).ddlSql);
        System.out.println(((ParseResult)object).selectSql);
        System.out.println(((ParseResult)object).questionMarks.size());
        System.out.println(((ParseResult)object).sqlCounts);
    }

    public static class ParseFunctionResult {
        private boolean isFunc;
        private boolean haveFuncReturn;
        private boolean isCallable;
        private boolean isResultNeeded;
        private String afterSql;
        private Map<String, ParamInfo> params;
        private String objectName;
        private String schemaName;
        private boolean isAnonymous;
        private String packageName;

        public boolean isFunc() {
            return this.isFunc;
        }

        public boolean haveFuncReturn() {
            return this.haveFuncReturn;
        }

        public boolean isCallable() {
            return this.isCallable;
        }

        public boolean isResultNeeded() {
            return this.isResultNeeded;
        }

        public String getAfterSql() {
            return this.afterSql;
        }

        private void addParam(ParamInfo paramInfo) {
            if (this.params == null) {
                this.params = new LinkedHashMap<String, ParamInfo>();
            }
            this.params.put(paramInfo.getSequence() + "_" + paramInfo.getOid(), paramInfo);
        }

        public Map<String, ParamInfo> getParams() {
            return this.params;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public boolean isAnonymous() {
            return this.isAnonymous;
        }

        public String getPackageName() {
            return this.packageName;
        }
    }

    public static class ParseResult {
        private boolean selectSql;
        private boolean ddlSql;
        private boolean dmlSql;
        private int sqlCounts;
        private List<Word> questionMarks;
        private boolean fenormalSelect;
        private boolean insertSql;
        private String transSql;
        private boolean hasAggFunctionInSelect;
        private boolean selectForUpdate;
        private List<Word> words;
        private int valuesWordIndex = -1;
        private boolean isAnonymous;
        private boolean hasInsertBulk;

        public List<Word> getAllWords() {
            return this.words;
        }

        public boolean hasInsertBulk() {
            return this.hasInsertBulk;
        }

        public boolean isAnonymous() {
            return this.isAnonymous;
        }

        public boolean isInsertSql() {
            return this.insertSql;
        }

        public boolean isFenormalSelect() {
            return this.fenormalSelect;
        }

        public boolean isSelectSql() {
            return this.selectSql;
        }

        public boolean isDdlSql() {
            return this.ddlSql;
        }

        public int getSqlCounts() {
            return this.sqlCounts;
        }

        public List<Word> getQuestionMarks() {
            return this.questionMarks;
        }

        public boolean isDmlSql() {
            return this.dmlSql;
        }

        public String getTransSql() {
            return this.transSql;
        }

        public boolean hasAggFunctionInSelect() {
            return this.hasAggFunctionInSelect;
        }

        public boolean isSelectForUpdate() {
            return this.selectForUpdate;
        }

        public int getValuesWordIndex() {
            return this.valuesWordIndex;
        }
    }
}

