/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.Driver;
import com.oscar.core.ImportHandler;
import com.oscar.jdbc.OscarImportHandler;
import com.oscar.protocol.a;
import com.oscar.protocol.a.N;
import com.oscar.protocol.b.e;
import com.oscar.util.ImportBufferManager;
import com.oscar.util.ImportStream;
import com.oscar.util.OSQLException;
import java.sql.SQLException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ShareImportStream
extends ImportStream {
    private static final AtomicInteger CONSUME_THREAD_ID = new AtomicInteger(0);
    private static final int MAX_QUEUE_SIZE = 2;
    private BlockingQueue<Cache> queue;
    private byte[] buffer;
    private volatile boolean ended = false;
    private ImportDataThread thread;
    private boolean bulkflow = false;
    private boolean inited = false;
    private boolean lastCacheHalfRow = false;
    private int bufferOffset = 1;
    private int batchRowCounts = 0;
    private int batchRowsOffset = 1;
    private int batchRowsEnd = 0;
    private final int offerWaitSecond;
    private static final int OFFER_WAIT_INTERVAL_SECOND = 10;
    private final int count;
    protected boolean logFlag = Driver.getLogLevel() >= 2;

    public ShareImportStream(OscarImportHandler oscarImportHandler) {
        this.handler = oscarImportHandler;
        this.defaultBufferSize = oscarImportHandler.getBufferSize();
        if (oscarImportHandler.getBulkKind() == 0) {
            this.bulkflow = true;
        }
        int n2 = ShareImportStream.getQueueSize(this.defaultBufferSize);
        this.queue = new ArrayBlockingQueue<Cache>(n2);
        ((ImportStream)this).reInit();
        this.offerWaitSecond = oscarImportHandler.getWaitTimeout() > 0 ? oscarImportHandler.getWaitTimeout() : 300;
        this.count = this.offerWaitSecond / 10;
    }

    private static int getQueueSize(int n2) {
        long l2 = (Runtime.getRuntime().maxMemory() << 1) / 3L;
        if (l2 < (long)n2) {
            throw new RuntimeException("JVM's max memory is not enough, set -Xmx or reduce buffer");
        }
        if ((n2 = (int)(l2 / (long)n2)) == 0) {
            return 1;
        }
        n2 = n2 > 2 ? 2 : n2;
        return n2;
    }

    @Override
    public void reInit() {
        if (this.thread != null && !((ImportStream)this).isFinished() && this.thread.isAlive()) {
            ((ImportStream)this).finished();
        }
        this.cacheSize = 0;
        this.position = 0;
        this.rowPosition = 0;
        this.ended = false;
        this.finished = false;
        this.exFinished = false;
        this.inited = false;
        this.thread = new ImportDataThread();
        this.thread.start();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws SQLException {
        this.checkException();
        if (n2 < 0 || n3 > byArray.length) {
            throw new SQLException("\u504f\u79fb\u5c0f\u4e8e0\u6216\u8005\u6570\u636e\u957f\u5ea6\u5927\u4e8ebuffer");
        }
        if (n3 + n2 > byArray.length) {
            throw new SQLException("\u504f\u79fb\u91cf\u518d\u52a0\u4e0a\u6570\u636e\u957f\u5ea6\u5927\u4e8ebuffer");
        }
        do {
            if (this.isBufferNotFull(n3)) {
                this.copyToBuffer(byArray, n2, n3);
                return;
            }
            if (!this.bulkflow && this.rowPosition > 0) {
                ShareImportStream shareImportStream = this;
                shareImportStream.flushToQueue(shareImportStream.rowPosition, false);
                continue;
            }
            int n4 = this.defaultBufferSize - this.position;
            this.copyToBuffer(byArray, n2, n4);
            this.flushToQueue(true);
            n2 += n4;
            n3 -= n4;
        } while (!this.ended);
    }

    private boolean isBufferNotFull(int n2) {
        return this.position + n2 <= this.defaultBufferSize;
    }

    private void copyToBuffer(byte[] byArray, int n2, int n3) {
        System.arraycopy(byArray, n2, this.getBuffer(), this.position, n3);
        this.position += n3;
    }

    void flushToQueue(int n2, boolean bl) throws SQLException {
        byte[] byArray;
        if (this.buffer == null) {
            return;
        }
        if (this.position < n2 || n2 <= 0) {
            return;
        }
        if (n2 == this.defaultBufferSize) {
            byArray = this.buffer;
            this.buffer = null;
            this.position = 0;
            this.rowPosition = 0;
        } else {
            try {
                byArray = ImportBufferManager.getBuffer(n2);
            }
            catch (InterruptedException interruptedException) {
                byArray = new byte[n2];
            }
            System.arraycopy(this.buffer, 0, byArray, 0, n2);
            if (n2 < this.position) {
                System.arraycopy(this.buffer, n2, this.buffer, 0, this.position - n2);
            }
            this.position -= n2;
            this.rowPosition = 0;
        }
        try {
            n2 = 0;
            int n3 = 0;
            while (n2 == 0 && n3 < this.count) {
                this.checkException();
                n2 = this.queue.offer(new Cache(byArray, this.lastCacheHalfRow, bl), 10L, TimeUnit.SECONDS) ? 1 : 0;
                if (!this.logFlag || ++n3 * 10 < 30) continue;
                Driver.writeLog("WARNING: \u6570\u636e\u5e93\u6267\u884c\u65f6\u95f4\u4e3a(s): " + n3 * 10);
            }
            if (n2 == 0) {
                String string = "importer is " + (this.thread.isAlive() ? "alive" : "not alive") + ", The waiting time for network or database reasons exceeds " + this.offerWaitSecond + " seconds";
                if (this.threadException != null) {
                    Driver.writeLog(string, this.threadException);
                    throw new OSQLException("OSCAR-00804", "88888", 804, this.threadException.getMessage() + " " + string, this.threadException);
                }
                throw new OSQLException("OSCAR-00804", "88888", 804, string);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new SQLException("Interrupted when offer buffer to queue, " + interruptedException.getMessage());
        }
        this.lastCacheHalfRow = bl;
        this.batchRowsOffset = this.bufferOffset;
        this.batchRowsEnd = this.batchRowCounts;
        this.bufferOffset = this.batchRowCounts + 1;
    }

    private void flushToQueue(boolean bl) throws SQLException {
        ShareImportStream shareImportStream = this;
        shareImportStream.flushToQueue(shareImportStream.position, bl);
    }

    public void sendMessage(Cache cache) throws SQLException {
        Object object;
        if (cache == null || cache.cacheData == null) {
            throw new OSQLException("cache is null when send data to db", "88888");
        }
        byte[] byArray = cache.cacheData;
        Object object2 = null;
        if (!this.inited || !cache.lastHalfRow && !this.bulkflow) {
            this.currentSql = this.handler.getInsertBulkStr().toString();
            if (this.handler.getHintParam() != null) {
                this.currentSql = this.currentSql + " WITH " + this.handler.getHintParam();
            }
            try {
                object2 = new N(this.handler.getConnection().getEncoding().encode(this.currentSql), 0);
            }
            catch (SQLException sQLException) {
                object = sQLException;
                sQLException.printStackTrace();
            }
        }
        object = this.handler.getConnection().getProtocol().a;
        synchronized (object) {
            a a2 = this.handler.getConnection().getProtocol();
            a2.a(this.handler);
            if (!this.inited || !cache.lastHalfRow && !this.bulkflow) {
                a2.a((N)object2);
            }
            if (this.handler.getImportBlockParam() == 1) {
                byte[] byArray2 = new byte[4];
                object2 = byArray2;
                byArray2[0] = (byte)(byArray.length >>> 24);
                object2[1] = (byte)(byArray.length >> 16);
                object2[2] = (byte)(byArray.length >> 8);
                object2[3] = (byte)byArray.length;
                a2.a((byte[])object2);
            }
            a2.a(byArray);
            if (!this.bulkflow && !cache.thisHalfRow) {
                a2.d();
                this.updateCount += this.handler.getUpdateCount();
                this.handler.setUpdateCount(this.updateCount);
            }
        }
        this.inited = true;
    }

    public void importEnd() throws SQLException {
        if (!this.bulkflow) {
            return;
        }
        e e2 = this.handler.getConnection().getProtocol().a;
        synchronized (e2) {
            a a2 = this.handler.getConnection().getProtocol();
            a2.a(this.handler);
            a2.d();
            this.updateCount += this.handler.getUpdateCount();
            this.handler.setUpdateCount(this.updateCount);
        }
        this.inited = false;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void finished() {
        this.finished = true;
        this.releaseBuffer();
        while (!this.ended && !this.exFinished) {
            if (this.thread == null || !this.thread.isAlive()) {
                this.ended = true;
                return;
            }
            try {
                this.thread.join(this.offerWaitSecond * 1000);
                if (!this.thread.isAlive() && this.ended || !this.logFlag) continue;
                Driver.writeLog("\u7ebf\u7a0b\u6267\u884c\u8d85\u8fc7" + this.offerWaitSecond + "\u79d2\u8fd8\u672a\u9000\u51fa");
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void flush() throws SQLException {
        ShareImportStream shareImportStream = this;
        shareImportStream.flushToQueue(shareImportStream.position, false);
    }

    public void checkException() throws SQLException {
        if (this.threadException != null) {
            if (this.threadException instanceof SQLException) {
                throw (SQLException)this.threadException;
            }
            if (this.threadException.getCause() != null) {
                throw new SQLException(this.threadException.getMessage() + " Cause: " + this.threadException.getCause().getMessage());
            }
            throw new SQLException(this.threadException.getMessage());
        }
    }

    @Override
    public void setRowPosition() {
        this.rowPosition = this.position;
    }

    @Override
    public ImportHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setDefaultBufferSize(int n2) {
        this.defaultBufferSize = n2;
    }

    @Override
    public void close() {
        this.releaseBuffer();
        this.releaseQueue();
        if (!this.ended) {
            this.ended = true;
            ((ImportStream)this).finished();
        }
        this.thread = null;
    }

    @Override
    public void batchRowsIncrease() {
        ++this.batchRowCounts;
    }

    @Override
    public int getBatchRowsOffset() {
        return this.batchRowsOffset;
    }

    @Override
    public int getBatchRowsEnd() {
        return this.batchRowsEnd;
    }

    public byte[] getBuffer() {
        if (this.buffer == null) {
            try {
                this.buffer = ImportBufferManager.getBuffer(this.defaultBufferSize);
            }
            catch (InterruptedException interruptedException) {
                InterruptedException interruptedException2 = interruptedException;
                interruptedException.printStackTrace();
            }
        }
        return this.buffer;
    }

    public void releaseBuffer() {
        if (this.buffer != null) {
            ImportBufferManager.releaseBuffer(this.buffer);
            this.buffer = null;
        }
    }

    public void releaseQueue() {
        this.queue.clear();
        this.queue = null;
    }

    public void releaseCache(Cache cache) {
        if (cache != null) {
            cache.release();
        }
    }

    public static class Cache {
        public final boolean lastHalfRow;
        public final boolean thisHalfRow;
        private byte[] cacheData;

        public Cache(byte[] byArray, boolean bl, boolean bl2) {
            this.cacheData = byArray;
            this.lastHalfRow = bl;
            this.thisHalfRow = bl2;
        }

        public byte[] getCacheData() {
            return this.cacheData;
        }

        void release() {
            ImportBufferManager.releaseBuffer(this.cacheData);
            this.cacheData = null;
        }
    }

    class ImportDataThread
    extends Thread {
        public ImportDataThread() {
            super("OscarImportDataThread-" + CONSUME_THREAD_ID.getAndIncrement());
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            try {
                while (!(ShareImportStream.this.ended || ShareImportStream.this.handler.getConnection().isClosed() || ShareImportStream.this.finished && ShareImportStream.this.queue.size() <= 0)) {
                    Cache cache;
                    try {
                        cache = (Cache)ShareImportStream.this.queue.poll(10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        ShareImportStream.this.threadException = interruptedException;
                        ShareImportStream.this.exFinished = true;
                        break;
                    }
                    if (cache != null && cache.cacheData != null) {
                        try {
                            long l2 = System.currentTimeMillis();
                            ShareImportStream.this.sendMessage(cache);
                            if (!ShareImportStream.this.logFlag) continue;
                            Driver.writeLog("after send cache,\u8017\u65f6(ms): " + (System.currentTimeMillis() - l2));
                            continue;
                        }
                        finally {
                            ShareImportStream.this.releaseCache(cache);
                            continue;
                        }
                    }
                    if (!ShareImportStream.this.finished) continue;
                    ShareImportStream.this.ended = true;
                    break;
                }
            }
            catch (SQLException sQLException) {
                Driver.writeLog("\u5bfc\u5165\u53d1\u751f\u5f02\u5e381\uff1a", sQLException);
                ShareImportStream.this.threadException = sQLException;
                ShareImportStream.this.exFinished = true;
                ShareImportStream.this.ended = true;
                if (!ShareImportStream.this.exFinished) {
                    try {
                        ShareImportStream.this.importEnd();
                        return;
                    }
                    catch (Throwable throwable) {
                        if (ShareImportStream.this.threadException == null) {
                            ShareImportStream.this.threadException = throwable;
                        }
                        ShareImportStream.this.exFinished = true;
                        return;
                    }
                }
            }
            catch (Exception exception) {
                Driver.writeLog("\u5bfc\u5165\u53d1\u751f\u5f02\u5e382\uff1a", exception);
                ShareImportStream.this.threadException = exception;
                ShareImportStream.this.exFinished = true;
                {
                    catch (Throwable throwable) {
                        ShareImportStream.this.ended = true;
                        if (!ShareImportStream.this.exFinished) {
                            try {
                                ShareImportStream.this.importEnd();
                            }
                            catch (Throwable throwable2) {
                                if (ShareImportStream.this.threadException == null) {
                                    ShareImportStream.this.threadException = throwable2;
                                }
                                ShareImportStream.this.exFinished = true;
                            }
                        }
                        throw throwable;
                    }
                }
                ShareImportStream.this.ended = true;
                if (!ShareImportStream.this.exFinished) {
                    try {
                        ShareImportStream.this.importEnd();
                        return;
                    }
                    catch (Throwable throwable) {
                        if (ShareImportStream.this.threadException == null) {
                            ShareImportStream.this.threadException = throwable;
                        }
                        ShareImportStream.this.exFinished = true;
                        return;
                    }
                }
            }
            ShareImportStream.this.ended = true;
            if (!ShareImportStream.this.exFinished) {
                try {
                    ShareImportStream.this.importEnd();
                    return;
                }
                catch (Throwable throwable) {
                    if (ShareImportStream.this.threadException == null) {
                        ShareImportStream.this.threadException = throwable;
                    }
                    ShareImportStream.this.exFinished = true;
                    return;
                }
            }
        }
    }
}

