/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.core.ImportHandler;
import com.oscar.jdbc.OscarImportHandler;
import com.oscar.protocol.a;
import com.oscar.protocol.a.N;
import com.oscar.protocol.b.e;
import com.oscar.util.ImportBufferManager;
import com.oscar.util.ImportStream;
import java.sql.SQLException;

public class ShareImportStream1
extends ImportStream {
    private byte[] buffer;
    private byte[] cache;
    private int bufferOffset = 1;
    private int batchRowCounts = 0;
    private int batchRowsOffset = 1;
    private int batchRowsEnd = 0;
    private ImportDataThread thread;
    private boolean cacheDataFilled = false;
    private boolean ended = false;
    private boolean bulkflow = false;
    private boolean inited = false;

    public ShareImportStream1(OscarImportHandler oscarImportHandler) {
        this.handler = oscarImportHandler;
        this.defaultBufferSize = oscarImportHandler.getBufferSize();
        if (oscarImportHandler.getBulkKind() == 0) {
            this.bulkflow = true;
        }
        ((ImportStream)this).reInit();
    }

    @Override
    public void reInit() {
        this.cacheSize = 0;
        this.position = 0;
        this.rowPosition = 0;
        this.cacheDataFilled = false;
        this.ended = false;
        this.finished = false;
        this.exFinished = false;
        this.inited = false;
        this.thread = new ImportDataThread();
        this.thread.start();
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws SQLException {
        if (n2 < 0 || n3 > byArray.length) {
            throw new NullPointerException();
        }
        if (n3 + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position + n3 >= this.defaultBufferSize) {
            ((ImportStream)this).flush();
            if (this.position + n3 > this.defaultBufferSize) {
                ((ImportStream)this).flush();
                if (this.position + n3 > this.defaultBufferSize) {
                    throw new SQLException("The buffer does not have enough space, so increase the buffer");
                }
            }
        }
        System.arraycopy(byArray, n2, this.getBuffer(), this.position, n3);
        this.position += n3;
    }

    @Override
    public void sendMessage(byte[] byArray) throws SQLException {
        Object object = null;
        if (!this.bulkflow || !this.inited) {
            this.currentSql = this.handler.getInsertBulkStr().toString();
            if (this.handler.getHintParam() != null) {
                this.currentSql = this.currentSql + " WITH " + this.handler.getHintParam();
            }
            try {
                object = new N(this.handler.getConnection().getEncoding().encode(this.currentSql), 0);
            }
            catch (SQLException sQLException) {
                SQLException sQLException2 = sQLException;
                throw sQLException;
            }
        }
        e e2 = this.handler.getConnection().getProtocol().a;
        synchronized (e2) {
            a a2 = this.handler.getConnection().getProtocol();
            a2.a(this.handler);
            if (!this.bulkflow || !this.inited) {
                a2.a((N)object);
            }
            if (this.handler.getImportBlockParam() == 1) {
                byte[] byArray2 = new byte[4];
                object = byArray2;
                byArray2[0] = (byte)(byArray.length >>> 24);
                object[1] = (byte)(byArray.length >> 16);
                object[2] = (byte)(byArray.length >> 8);
                object[3] = (byte)byArray.length;
                a2.a((byte[])object);
            }
            a2.a(byArray);
            if (!this.bulkflow) {
                a2.d();
                this.updateCount += this.handler.getUpdateCount();
                this.handler.setUpdateCount(this.updateCount);
            }
        }
        this.inited = true;
    }

    public void importEnd() throws SQLException {
        if (!this.bulkflow) {
            return;
        }
        e e2 = this.handler.getConnection().getProtocol().a;
        synchronized (e2) {
            a a2 = this.handler.getConnection().getProtocol();
            a2.a(this.handler);
            a2.d();
            this.updateCount += this.handler.getUpdateCount();
            this.handler.setUpdateCount(this.updateCount);
        }
        this.inited = false;
    }

    public synchronized byte[] getMessage() {
        byte[] byArray = null;
        while (true) {
            if (this.cacheDataFilled) {
                byArray = new byte[this.cacheSize];
                System.arraycopy(this.getCache(), 0, byArray, 0, this.cacheSize);
                this.releaseCache();
                this.cacheDataFilled = false;
                this.notify();
                break;
            }
            if (this.finished) break;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return byArray;
    }

    public synchronized void setMessage() {
        while (!this.ended) {
            if (!this.cacheDataFilled) {
                if (this.rowPosition == 0) {
                    System.arraycopy(this.getBuffer(), 0, this.getCache(), 0, this.position);
                    this.cacheSize = this.position;
                    this.position = 0;
                    this.releaseBuffer();
                } else {
                    System.arraycopy(this.getBuffer(), 0, this.getCache(), 0, this.rowPosition);
                    this.cacheSize = this.rowPosition;
                    if (this.position > this.rowPosition) {
                        ShareImportStream1 shareImportStream1 = this;
                        shareImportStream1.moveData(shareImportStream1.getBuffer(), 0, this.rowPosition);
                    }
                    this.position -= this.rowPosition;
                    this.rowPosition = 0;
                }
                this.cacheDataFilled = true;
                this.batchRowsOffset = this.bufferOffset;
                this.batchRowsEnd = this.batchRowCounts;
                this.bufferOffset = this.batchRowCounts + 1;
                this.notify();
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void finished() {
        this.finished = true;
        this.releaseBuffer();
        while (!this.ended && !this.exFinished) {
            ShareImportStream1 shareImportStream1 = this;
            synchronized (shareImportStream1) {
                this.notify();
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void flush() {
        this.setMessage();
    }

    public void moveData(byte[] byArray, int n2, int n3) {
        System.arraycopy(this.getBuffer(), n3, this.getBuffer(), 0, this.position - n3);
    }

    public void moveData(byte[] byArray) throws SQLException {
        this.moveData(byArray, 0, byArray.length);
    }

    @Override
    public void setRowPosition() {
        this.rowPosition = this.position;
    }

    @Override
    public ImportHandler getHandler() {
        return this.handler;
    }

    @Override
    public void setDefaultBufferSize(int n2) {
        this.defaultBufferSize = n2;
    }

    @Override
    public void close() {
        this.releaseBuffer();
        this.releaseCache();
        this.thread = null;
    }

    @Override
    public void batchRowsIncrease() {
        ++this.batchRowCounts;
    }

    @Override
    public int getBatchRowsOffset() {
        return this.batchRowsOffset;
    }

    @Override
    public int getBatchRowsEnd() {
        return this.batchRowsEnd;
    }

    public byte[] getBuffer() {
        if (this.buffer == null) {
            try {
                this.buffer = ImportBufferManager.getBuffer(this.defaultBufferSize);
            }
            catch (InterruptedException interruptedException) {
                InterruptedException interruptedException2 = interruptedException;
                interruptedException.printStackTrace();
            }
        }
        return this.buffer;
    }

    public byte[] getCache() {
        if (this.cache == null) {
            this.cache = ImportBufferManager.getBufferAllways(this.defaultBufferSize);
        }
        return this.cache;
    }

    public void releaseBuffer() {
        ImportBufferManager.releaseBuffer(this.buffer);
        this.buffer = null;
    }

    public void releaseCache() {
        ImportBufferManager.releaseCache(this.cache);
        this.cache = null;
    }

    class ImportDataThread
    extends Thread {
        @Override
        public void run() {
            Object object;
            block28: {
                try {
                    while (!ShareImportStream1.this.finished || ShareImportStream1.this.cacheDataFilled) {
                        if (ShareImportStream1.this.exFinished) {
                            object = ShareImportStream1.this;
                            synchronized (object) {
                                ShareImportStream1.this.notify();
                                break;
                            }
                        }
                        try {
                            byte[] byArray = ShareImportStream1.this.getMessage();
                            object = byArray;
                            if (byArray == null) break;
                            ((ImportStream)ShareImportStream1.this).sendMessage((byte[])object);
                        }
                        catch (SQLException sQLException) {
                            ShareImportStream1.this.threadException = sQLException;
                            ShareImportStream1.this.exFinished = true;
                        }
                        catch (Exception exception) {
                            object = exception;
                            exception.printStackTrace();
                            ShareImportStream1.this.threadException = object;
                            ShareImportStream1.this.exFinished = true;
                        }
                        catch (Throwable throwable) {
                            ShareImportStream1.this.threadException = throwable;
                            ShareImportStream1.this.exFinished = true;
                        }
                    }
                    if (ShareImportStream1.this.exFinished) break block28;
                }
                catch (Throwable throwable) {
                    Object object2;
                    if (!ShareImportStream1.this.exFinished) {
                        try {
                            ShareImportStream1.this.importEnd();
                            ShareImportStream1.this.ended = true;
                        }
                        catch (SQLException sQLException) {
                            ShareImportStream1.this.threadException = sQLException;
                            ShareImportStream1.this.exFinished = true;
                        }
                        catch (Exception exception) {
                            object2 = exception;
                            exception.printStackTrace();
                            ShareImportStream1.this.threadException = object2;
                            ShareImportStream1.this.exFinished = true;
                        }
                        catch (Throwable throwable2) {
                            ShareImportStream1.this.threadException = throwable2;
                            ShareImportStream1.this.exFinished = true;
                        }
                    }
                    if (ShareImportStream1.this.exFinished) {
                        ShareImportStream1.this.ended = true;
                        object2 = ShareImportStream1.this;
                        synchronized (object2) {
                            ShareImportStream1.this.notify();
                        }
                    }
                    throw throwable;
                }
                try {
                    ShareImportStream1.this.importEnd();
                    ShareImportStream1.this.ended = true;
                }
                catch (SQLException sQLException) {
                    ShareImportStream1.this.threadException = sQLException;
                    ShareImportStream1.this.exFinished = true;
                }
                catch (Exception exception) {
                    object = exception;
                    exception.printStackTrace();
                    ShareImportStream1.this.threadException = object;
                    ShareImportStream1.this.exFinished = true;
                }
                catch (Throwable throwable) {
                    ShareImportStream1.this.threadException = throwable;
                    ShareImportStream1.this.exFinished = true;
                }
            }
            if (ShareImportStream1.this.exFinished) {
                ShareImportStream1.this.ended = true;
                object = ShareImportStream1.this;
                synchronized (object) {
                    ShareImportStream1.this.notify();
                }
            }
        }
    }
}

