/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.util.ColumnData;
import com.oscar.util.ImportStream;
import com.oscar.util.OSCARbyte;
import com.oscar.util.OSQLException;
import com.oscar.util.ReaderInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.SQLException;

public class StreamData
extends ColumnData {
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    public static final int MAX_BYTE_SIZE = 32765;
    private int length = 0;
    private InputStream in;
    private boolean toOscarString;

    public void read(InputStream inputStream, int n2) throws SQLException {
        this.read(inputStream, n2, false);
    }

    public void read(InputStream inputStream, int n2, boolean bl) throws SQLException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.in = inputStream;
        this.length = n2;
        this.toOscarString = bl;
    }

    public void read(Reader reader, int n2, String string) throws SQLException {
        if (reader == null) {
            throw new NullPointerException();
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.in = new ReaderInputStream(reader, Charset.forName(string));
        this.length = n2;
    }

    public void read(Reader reader, String string) throws SQLException {
        if (reader == null) {
            throw new NullPointerException();
        }
        this.in = new ReaderInputStream(reader, Charset.forName(string));
    }

    public void read(InputStream inputStream) throws SQLException {
        this.read(inputStream, false);
    }

    public void read(InputStream inputStream, boolean bl) throws SQLException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.toOscarString = bl;
    }

    @Override
    public void preWrite(ImportStream importStream) throws SQLException {
        importStream.writeInteger(-2, 2);
    }

    @Override
    public void endWrite(ImportStream object) throws SQLException {
        try {
            this.doWrite((ImportStream)object);
        }
        catch (IOException iOException) {
            try {
                throw new OSQLException("OSCAR-00804", "88888", 804, iOException);
            }
            catch (Throwable throwable) {
                ((ImportStream)object).writeInteger(-2, 2);
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException2) {
                        object = iOException2;
                        iOException2.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        ((ImportStream)object).writeInteger(-2, 2);
        if (this.in != null) {
            try {
                this.in.close();
                return;
            }
            catch (IOException iOException) {
                IOException iOException3 = iOException;
                iOException.printStackTrace();
                return;
            }
        }
    }

    public void doWrite(ImportStream importStream) throws IOException, SQLException {
        int n2;
        byte[] byArray;
        int n3;
        if (this.in == null || importStream == null) {
            throw new OSQLException("InputStream handle is invalid", "00804");
        }
        int n4 = n3 = this.toOscarString ? 16381 : 16384;
        if (this.length <= 0) {
            int n5;
            boolean bl = true;
            byte[] byArray2 = new byte[n3];
            while ((n5 = this.in.read(byArray2, 0, n3)) != -1) {
                this.writeBuffer(importStream, byArray2, n5, bl);
                if (!bl) continue;
                bl = false;
            }
            return;
        }
        int n6 = this.length;
        if (n6 < n3) {
            n3 = n6;
            byArray = new byte[n6];
        } else {
            byArray = new byte[n3];
        }
        boolean bl = true;
        while ((n2 = this.in.read(byArray, 0, n3)) != -1 && n6 > 0) {
            this.writeBuffer(importStream, byArray, n2, bl);
            if (bl) {
                bl = false;
            }
            n6 -= n2;
        }
    }

    private void writeBuffer(ImportStream importStream, byte[] byArray, int n2, boolean bl) throws SQLException {
        if (this.toOscarString) {
            byte[] byArray2 = byArray;
            if (byArray.length != n2) {
                byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
            }
            byArray = OSCARbyte.getOscarHexBytes(byArray2, bl);
            assert (byArray.length < 32765);
            importStream.writeInteger(byArray.length + 2, 2);
            importStream.write(byArray);
            return;
        }
        importStream.writeInteger(n2 + 2, 2);
        importStream.write(byArray, 0, n2);
    }

    @Override
    public void clear() throws SQLException {
        this.length = 0;
        this.in = null;
        this.toOscarString = false;
    }

    @Override
    public void preWriteBlock(ImportStream importStream) throws SQLException {
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n2) {
        this.length = n2;
    }
}

