/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.Driver;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemInformation {
    public static final String DEFAULT_MAC = "00-00-00-00-00-00";
    private static final int GROUP_COUNT = 20;
    private String user;
    private String userDomain;
    private String[] groups = new String[20];
    private int groupCount;
    private String hostName;
    private String mac;
    private int netProtocal = 0;
    private String application;
    private byte[] fingerPrintInfo = null;
    protected boolean logFlag = Driver.getLogLevel() >= 3;
    private static SystemInformation instance = null;

    private SystemInformation() throws SQLException {
        for (int i2 = 0; i2 < 20; ++i2) {
            this.groups[i2] = "";
        }
        String string = System.getProperty("user.dir", "") + File.separator;
        Object object = System.getProperty("os.name", "window").toLowerCase();
        string = ((String)object).indexOf("window") != -1 ? string + "systemwin.dll" : string + "libsystemlinux.so";
        this.application = this.application == null ? "java" : this.application.toUpperCase();
        object = new File(string);
        try {
            block8: {
                block7: {
                    block6: {
                        if (!((File)object).exists() || !((File)object).isFile()) break block6;
                        System.load(string);
                        this.user = this.getSystemUser();
                        this.userDomain = this.getSystemUserDomain();
                        SystemInformation systemInformation = this;
                        systemInformation.getSystemGroups(systemInformation.groups);
                        this.groupCount = this.getSystemGroupCount();
                        this.hostName = this.getSystemHostName();
                        this.mac = this.getSystemMac();
                        this.application = this.getSystemApplication();
                        this.user = this.user == null ? "NULL" : this.user.toUpperCase();
                        this.userDomain = this.userDomain == null ? "NULL" : this.userDomain.toUpperCase();
                        if (this.hostName == null) {
                            this.hostName = "NULL";
                        }
                        if (this.mac != null) break block7;
                        break block8;
                    }
                    if (this.logFlag) {
                        Driver.writeLog("SystemInformation: dllName: " + string + " not exists");
                    }
                    this.user = "";
                    this.userDomain = "";
                    this.hostName = "";
                    this.mac = this.getLocalMac();
                }
                return;
            }
            this.mac = this.getLocalMac();
        }
        catch (Throwable throwable) {
            if (this.logFlag) {
                Driver.writeLog("SystemInformation: initialize error: " + throwable.getMessage());
            }
            this.user = "";
            this.userDomain = "";
            this.hostName = "";
            this.mac = this.getLocalMac();
        }
    }

    public String getLocalMac() {
        String string = DEFAULT_MAC;
        try {
            string = SystemInformation.getMACAddress();
            if (DEFAULT_MAC.equals(string)) {
                if (SystemInformation.isWindowsOS()) {
                    string = SystemInformation.getWindowsMAC();
                } else {
                    String string2 = SystemInformation.getNonloopNetworkInterfaceName();
                    string = SystemInformation.getUnixMACAddress(string2);
                }
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return string;
    }

    public static String getUnixMACAddress(String object) throws Exception {
        String string;
        object = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "ifconfig " + (String)(object != null ? object : "") + "|grep -o ..:..:..:..:..:..|awk -F: '{print $1\"-\"$2\"-\"$3\"-\"$4\"-\"$5\"-\"$6}'"});
        InputStream inputStream = ((Process)object).getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(string);
        }
        bufferedReader.close();
        inputStream.close();
        ((Process)object).destroy();
        return SystemInformation.getMacFromList(arrayList);
    }

    public static boolean isWindowsOS() {
        boolean bl = false;
        String string = System.getProperty("os.name");
        if (string.toLowerCase().indexOf("windows") >= 0) {
            bl = true;
        }
        return bl;
    }

    public static String getWindowsMAC() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Object object;
            Process process = Runtime.getRuntime().exec("cmd.exe /c ipconfig/all");
            InputStream inputStream = process.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer stringBuffer = new StringBuffer();
            while ((object = bufferedReader.readLine()) != null) {
                stringBuffer.append((String)object);
            }
            object = Pattern.compile("..-..-..-..-..-..");
            if (((Matcher)(object = ((Pattern)object).matcher(stringBuffer.toString()))).find()) {
                arrayList.add(((Matcher)object).group(0));
            }
            bufferedReader.close();
            inputStream.close();
            process.destroy();
        }
        catch (IOException iOException) {
            System.out.println("Can't get mac address!");
            return DEFAULT_MAC;
        }
        return SystemInformation.getMacFromList(arrayList);
    }

    private static String getMacFromList(List<String> list) {
        if (list.size() <= 0) {
            return DEFAULT_MAC;
        }
        return list.get(0);
    }

    public static String getNonloopNetworkInterfaceName() throws SocketException {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            Object object2 = ((NetworkInterface)object).getInetAddresses();
            if (!((String)(object = ((NetworkInterface)object).getName())).startsWith("en") && !((String)object).startsWith("eth") || !object2.hasMoreElements() || ((InetAddress)(object2 = object2.nextElement())).isLoopbackAddress()) continue;
            return object;
        }
        return null;
    }

    public static String getMACAddress() throws Exception {
        Object object;
        Object object2 = null;
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            Object object3 = ((NetworkInterface)object).getInetAddresses();
            String string = ((NetworkInterface)object).getName();
            if (!string.startsWith("en") && !string.startsWith("eth") || !object3.hasMoreElements() || ((InetAddress)(object3 = object3.nextElement())).isLoopbackAddress()) continue;
            object2 = object;
            break;
        }
        if (object2 != null) {
            byte[] byArray = ((NetworkInterface)object2).getHardwareAddress();
            object = byArray;
            if (byArray != null) {
                return SystemInformation.toString((byte[])object);
            }
        }
        return DEFAULT_MAC;
    }

    public static String toString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string;
            if (i2 != 0) {
                stringBuffer.append("-");
            }
            stringBuffer.append((string = Integer.toHexString(byArray[i2] & 0xFF)).length() == 1 ? "0" + string : string);
        }
        return stringBuffer.toString();
    }

    public static SystemInformation getInstance(boolean bl) throws SQLException {
        return SystemInformation.getInstance();
    }

    public static SystemInformation getInstance() throws SQLException {
        if (instance == null) {
            instance = new SystemInformation();
        }
        return instance;
    }

    public static SystemInformation getMBInitial() throws SQLException {
        return new SystemInformation();
    }

    private native String getSystemUser();

    private native String getSystemUserDomain();

    private native void getSystemGroups(String[] var1);

    private native int getSystemGroupCount();

    private native String getSystemHostName();

    private native String getSystemMac();

    private native String getSystemApplication();

    private native byte[] getSystemFingerPrintInfo();

    private native byte[] getSystemFingerPrintEnroll(byte[] var1, byte[] var2, byte[] var3);

    private native byte[] getSystemFingerPrintEnroll();

    private native int cancelFingerPrintEnroll();

    public String getUser() {
        return this.user;
    }

    public String getUserDomain() {
        return this.userDomain;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getNetProtocal() {
        return this.netProtocal;
    }

    public String getMac() {
        return this.mac;
    }

    public String getApplication() {
        return this.application;
    }

    public byte[] getFingerPrintInfo() {
        if (this.fingerPrintInfo == null) {
            try {
                this.fingerPrintInfo = this.getSystemFingerPrintInfo();
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
            catch (Error error) {
                Error error2 = error;
                error.printStackTrace();
            }
        }
        return this.fingerPrintInfo;
    }

    public byte[] getFingerPrintInfoForEnroll() {
        byte[] byArray = null;
        try {
            byArray = this.getSystemFingerPrintInfo();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        catch (Error error) {
            Error error2 = error;
            error.printStackTrace();
        }
        return byArray;
    }

    public byte[] getFingerPrintMB(byte[] object, byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        try {
            byArray3 = this.getSystemFingerPrintEnroll((byte[])object, byArray, byArray2);
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
        }
        return byArray3;
    }

    public byte[] getFingerPrintMB() {
        byte[] byArray = null;
        try {
            byArray = this.getSystemFingerPrintEnroll();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray;
    }

    public int cancelFingerPrint() {
        int n2 = -1;
        try {
            n2 = this.cancelFingerPrintEnroll();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return n2;
    }
}

