/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.util.OscarSqlProcessor;
import com.oscar.util.Word;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TableNameParser {
    public static final String notAscii = "[\\u007f-\\uffff]";
    public static final String baseRegex = "((\\\"([[[\\u007f-\\uffff]\\p{Print}]&&[^\\\"]]+|\\\"\\\")+\\\")|[[\\p{Alnum}][\\u007f-\\uffff][_]]{1,})";
    public static final String tableNameRegex = "((\\\"([[[\\u007f-\\uffff]\\p{Print}]&&[^\\\"]]+|\\\"\\\")+\\\")|[[\\p{Alnum}][\\u007f-\\uffff][_]]{1,})[\\.]{1}((\\\"([[[\\u007f-\\uffff]\\p{Print}]&&[^\\\"]]+|\\\"\\\")+\\\")|[[\\p{Alnum}][\\u007f-\\uffff][_]]{1,})";
    public static final Pattern basePattern = Pattern.compile("((\\\"([[[\\u007f-\\uffff]\\p{Print}]&&[^\\\"]]+|\\\"\\\")+\\\")|[[\\p{Alnum}][\\u007f-\\uffff][_]]{1,})");
    public static final Pattern tableNamePattern = Pattern.compile("((\\\"([[[\\u007f-\\uffff]\\p{Print}]&&[^\\\"]]+|\\\"\\\")+\\\")|[[\\p{Alnum}][\\u007f-\\uffff][_]]{1,})[\\.]{1}((\\\"([[[\\u007f-\\uffff]\\p{Print}]&&[^\\\"]]+|\\\"\\\")+\\\")|[[\\p{Alnum}][\\u007f-\\uffff][_]]{1,})");

    public static String[] parserToDbString(String string) throws SQLException {
        String[] stringArray = new String[2];
        if (TableNameParser.isValidateTableName(string)) {
            Matcher matcher = basePattern.matcher(string);
            int n2 = 0;
            while (matcher.find()) {
                stringArray[n2] = string.substring(matcher.start(), matcher.end());
                if (!stringArray[n2].startsWith("\"")) {
                    stringArray[n2] = "\"" + stringArray[n2].toUpperCase() + "\"";
                }
                ++n2;
            }
        } else {
            throw new SQLException("\u975e\u6cd5\u7684\u8868\u540d\u683c\u5f0f\uff01");
        }
        return stringArray;
    }

    public static String[] parserToDbNames(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        List<Word> list = OscarSqlProcessor.parseToAllWords(string);
        switch (list.size()) {
            case 1: {
                return new String[]{null, list.get(0).getTokentext()};
            }
            case 3: {
                if (list.get(1).getType() != 13) {
                    throw new SQLException("\u975e\u6cd5\u7684\u5bf9\u8c61\u540d\u683c\u5f0f\uff1a" + string);
                }
                return new String[]{list.get(0).getTokentext(), list.get(2).getTokentext()};
            }
        }
        throw new SQLException("\u975e\u6cd5\u7684\u5bf9\u8c61\u540d\u683c\u5f0f\uff1a" + string);
    }

    public static String[] parserToOrgString(String stringArray) throws SQLException {
        String[] stringArray2 = new String[2];
        stringArray = TableNameParser.parserToDbString((String)stringArray);
        stringArray2[0] = TableNameParser.dbStringToOrgString(stringArray[0]);
        stringArray2[1] = TableNameParser.dbStringToOrgString(stringArray[1]);
        return stringArray2;
    }

    public static String[] parserToQueryString(String stringArray) throws SQLException {
        String[] stringArray2 = new String[2];
        stringArray = TableNameParser.parserToOrgString((String)stringArray);
        stringArray2[0] = TableNameParser.orgStringToQueryString(stringArray[0]);
        stringArray2[1] = TableNameParser.orgStringToQueryString(stringArray[1]);
        return stringArray2;
    }

    public static String orgStringToQueryString(String string) {
        if (string == null) {
            return string;
        }
        string = string.replaceAll("'", "''");
        return "'" + string + '\'';
    }

    public static String dbStringToOrgString(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
            string = string.substring(1, string.length() - 1);
            string = string.replaceAll("[\\\"]{2}", "\"");
        } else {
            string = string.toUpperCase();
        }
        return string;
    }

    public static boolean isValidateTableName(String object) {
        object = tableNamePattern.matcher((CharSequence)object);
        return ((Matcher)object).matches();
    }

    public static boolean parse(String string, String[] stringArray, String[] stringArray2) {
        int n2 = string.indexOf(".");
        int n3 = string.lastIndexOf(46);
        if (n2 < 0) {
            stringArray2[0] = string;
            return false;
        }
        stringArray2[0] = string.substring(n3 + 1);
        stringArray[0] = n2 != n3 ? string.substring(n2 + 1, n3) : string.substring(0, n2);
        return true;
    }
}

