/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public class TimeUtil {
    public static SimpleDateFormat getSimpleDateFormat(SimpleDateFormat simpleDateFormat, String string, TimeZone timeZone) {
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat = simpleDateFormat != null && simpleDateFormat.toPattern().equals(string) ? simpleDateFormat : new SimpleDateFormat(string, Locale.US);
        if (timeZone != null) {
            simpleDateFormat.setTimeZone(timeZone);
        }
        return simpleDateFormat;
    }

    public static Timestamp adjustNanosPrecision(Timestamp timestamp, int n2, boolean bl) {
        if (n2 < 0 || n2 > 6) {
            throw new RuntimeException("fsp value must be in 0 to 6 range.");
        }
        timestamp = (Timestamp)timestamp.clone();
        double d2 = Math.pow(10.0, 9 - n2);
        n2 = bl ? (int)Math.round((double)timestamp.getNanos() / d2) * (int)d2 : (int)((double)timestamp.getNanos() / d2) * (int)d2;
        if (n2 > 999999999) {
            n2 %= 1000000000;
            Timestamp timestamp2 = timestamp;
            timestamp2.setTime(timestamp2.getTime() + 1000L);
        }
        timestamp.setNanos(n2);
        return timestamp;
    }

    public static String formatNanos(int n2, int n3) {
        return TimeUtil.formatNanos(n2, n3, true);
    }

    public static String formatNanos(int n2, int n3, boolean bl) {
        if (n2 < 0 || n2 > 999999999) {
            throw new RuntimeException("nanos value must be in 0 to 999999999 range but was " + n2);
        }
        if (n3 < 0 || n3 > 6) {
            throw new RuntimeException("fsp value must be in 0 to 6 range but was " + n3);
        }
        if (n3 == 0 || n2 == 0) {
            return "0";
        }
        if ((n2 = (int)((double)n2 / Math.pow(10.0, 9 - n3))) == 0) {
            return "0";
        }
        String string = Integer.toString(n2);
        string = "000000000".substring(0, n3 - string.length()) + string;
        if (bl) {
            --n3;
            while (string.charAt(n3) == '0') {
                --n3;
            }
            string = string.substring(0, n3 + 1);
        }
        return string;
    }
}

