/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class TrackLog {
    public static final int NONLOG_LEVEL = 0;
    public static final int SQL_LEVEL = 1;
    public static final int INTERFACE_LEVEL = 2;
    public static final int PROTOCOL_LEVEL = 3;
    public static final int PROTOCOLDETAIL_LEVEL = 4;
    private static TrackLog trackLog;
    private PrintStream ps = null;
    private FileInputStream inputStream = null;
    private int logLevel = 0;
    private int maxFileSize = 0x6400000;
    private String logPath;
    private final String defaultConfigFilePath = System.getProperty("user.dir");
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmssSSS");

    private TrackLog(int n2, String string, Object object) {
        this.logLevel = n2;
        this.initLogPath(string);
        if (object != null) {
            this.maxFileSize = Integer.parseInt(object.toString()) << 10 << 10;
        }
    }

    public static synchronized TrackLog getInstance(int n2, String string, Object object) {
        if (trackLog == null) {
            trackLog = new TrackLog(n2, string, object);
        }
        return trackLog;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public String getDefaultConfigFilePath() {
        return this.defaultConfigFilePath;
    }

    public synchronized void initLogPath(String string) {
        Serializable serializable;
        try {
            if (this.ps != null) {
                this.ps.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception exception) {
            serializable = exception;
            exception.printStackTrace();
        }
        if (this.logLevel > 0 || this.logLevel == -1) {
            this.logPath = string == null ? this.getDefaultConfigFilePath() : string;
            try {
                Object object;
                serializable = new File(this.logPath);
                if (!((File)serializable).exists() || !((File)serializable).isDirectory()) {
                    ((File)serializable).mkdirs();
                }
                if (((File)serializable).isDirectory()) {
                    object = new StringBuffer(50);
                    ((StringBuffer)object).append(((File)serializable).getAbsolutePath()).append(File.separatorChar).append("OscarJDBC").append(this.dateFormat.format(new Date())).append(".log");
                    string = ((StringBuffer)object).toString();
                } else {
                    string = ((File)serializable).getAbsolutePath() + this.dateFormat.format(new Date()) + ".log";
                }
                object = new FileOutputStream(string, false);
                this.inputStream = new FileInputStream(string);
                this.ps = new PrintStream((OutputStream)object);
                return;
            }
            catch (Exception exception) {
                serializable = exception;
                exception.printStackTrace();
            }
        }
    }

    public void initLogPath() {
        this.initLogPath(null);
    }

    public static void main(String[] stringArray) {
    }

    public StackTraceElement getFrame() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        return stackTraceElementArray[1];
    }

    public synchronized void writeLog(String string) {
        if (this.getFileSize() >= this.maxFileSize) {
            if (this.logPath == null) {
                this.initLogPath();
            } else {
                TrackLog trackLog = this;
                trackLog.initLogPath(trackLog.logPath);
            }
        }
        if ((this.logLevel > 0 || this.logLevel == -1) && this.ps != null) {
            StringBuilder stringBuilder = new StringBuilder(200);
            this.appendDateString(stringBuilder);
            stringBuilder.append(", TN: ").append(Thread.currentThread().getName()).append(", ").append(string);
            this.ps.println(stringBuilder);
        }
    }

    private int getFileSize() {
        if (this.inputStream != null) {
            try {
                int n2 = this.inputStream.available();
                return n2;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return 0;
    }

    private void appendDateString(StringBuilder stringBuilder) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        stringBuilder.append(gregorianCalendar.get(1)).append("-").append(gregorianCalendar.get(2) + 1).append("-").append(gregorianCalendar.get(5)).append(" ").append(gregorianCalendar.get(11)).append(":").append(gregorianCalendar.get(12)).append(":").append(gregorianCalendar.get(13)).append(".").append(gregorianCalendar.get(14));
    }
}

