/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import com.oscar.core.BaseConnection;
import com.oscar.jdbc.OscarLob;
import com.oscar.sql.Time;
import com.oscar.util.OSCARbyte;
import com.oscar.util.OSQLException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class TypeConverter {
    public static final int SPLIT_LEN = 240;
    protected static final int HOUR_MILLISECOND = 3600000;
    protected static final int MINUTE_MILLISECOND = 60000;
    public static final int HOUR_SECOND = 3600;
    public static final int MINUTE_SECOND = 60;
    protected static final int POSITIVE_INT_MASK = 192;
    protected static final boolean DEBUG = false;
    protected static final boolean SLOW_CONVERSIONS = true;
    protected static final int LNXSGNBT = 128;
    protected static final byte LNXDIGS = 20;
    protected static final byte LNXEXPBS = 64;
    protected static final int LNXEXPMX = 127;
    protected static final double[] factorTable = new double[]{1.0E254, 1.0E252, 1.0E250, 1.0E248, 1.0E246, 1.0E244, 1.0E242, 1.0E240, 1.0E238, 1.0E236, 1.0E234, 1.0E232, 1.0E230, 1.0E228, 1.0E226, 1.0E224, 1.0E222, 1.0E220, 1.0E218, 1.0E216, 1.0E214, 1.0E212, 1.0E210, 1.0E208, 1.0E206, 1.0E204, 1.0E202, 1.0E200, 1.0E198, 1.0E196, 1.0E194, 1.0E192, 1.0E190, 1.0E188, 1.0E186, 1.0E184, 1.0E182, 1.0E180, 1.0E178, 1.0E176, 1.0E174, 1.0E172, 1.0E170, 1.0E168, 1.0E166, 1.0E164, 1.0E162, 1.0E160, 1.0E158, 1.0E156, 1.0E154, 1.0E152, 1.0E150, 1.0E148, 1.0E146, 1.0E144, 1.0E142, 1.0E140, 1.0E138, 1.0E136, 1.0E134, 1.0E132, 1.0E130, 1.0E128, 1.0E126, 1.0E124, 1.0E122, 1.0E120, 1.0E118, 1.0E116, 1.0E114, 1.0E112, 1.0E110, 1.0E108, 1.0E106, 1.0E104, 1.0E102, 1.0E100, 1.0E98, 1.0E96, 1.0E94, 1.0E92, 1.0E90, 1.0E88, 1.0E86, 1.0E84, 1.0E82, 1.0E80, 1.0E78, 1.0E76, 1.0E74, 1.0E72, 1.0E70, 1.0E68, 1.0E66, 1.0E64, 1.0E62, 1.0E60, 1.0E58, 1.0E56, 1.0E54, 1.0E52, 1.0E50, 1.0E48, 1.0E46, 1.0E44, 1.0E42, 1.0E40, 1.0E38, 1.0E36, 1.0E34, 1.0E32, 1.0E30, 1.0E28, 1.0E26, 1.0E24, 1.0E22, 1.0E20, 1.0E18, 1.0E16, 1.0E14, 1.0E12, 1.0E10, 1.0E8, 1000000.0, 10000.0, 100.0, 1.0, 0.01, 1.0E-4, 1.0E-6, 1.0E-8, 1.0E-10, 1.0E-12, 1.0E-14, 1.0E-16, 1.0E-18, 1.0E-20, 1.0E-22, 1.0E-24, 1.0E-26, 1.0E-28, 1.0E-30, 1.0E-32, 1.0E-34, 1.0E-36, 1.0E-38, 1.0E-40, 1.0E-42, 1.0E-44, 1.0E-46, 1.0E-48, 1.0E-50, 1.0E-52, 1.0E-54, 1.0E-56, 1.0E-58, 1.0E-60, 1.0E-62, 1.0E-64, 1.0E-66, 1.0E-68, 1.0E-70, 1.0E-72, 1.0E-74, 1.0E-76, 1.0E-78, 1.0E-80, 1.0E-82, 1.0E-84, 1.0E-86, 1.0E-88, 1.0E-90, 1.0E-92, 1.0E-94, 1.0E-96, 1.0E-98, 1.0E-100, 1.0E-102, 1.0E-104, 1.0E-106, 1.0E-108, 1.0E-110, 1.0E-112, 1.0E-114, 1.0E-116, 1.0E-118, 1.0E-120, 1.0E-122, 1.0E-124, 1.0E-126, 1.0E-128, 1.0E-130, 1.0E-132, 1.0E-134, 1.0E-136, 1.0E-138, 1.0E-140, 1.0E-142, 1.0E-144, 1.0E-146, 1.0E-148, 1.0E-150, 1.0E-152, 1.0E-154, 1.0E-156, 1.0E-158, 1.0E-160, 1.0E-162, 1.0E-164, 1.0E-166, 1.0E-168, 1.0E-170, 1.0E-172, 1.0E-174, 1.0E-176, 1.0E-178, 1.0E-180, 1.0E-182, 1.0E-184, 1.0E-186, 1.0E-188, 1.0E-190, 1.0E-192, 1.0E-194, 1.0E-196, 1.0E-198, 1.0E-200, 1.0E-202, 1.0E-204, 1.0E-206, 1.0E-208, 1.0E-210, 1.0E-212, 1.0E-214, 1.0E-216, 1.0E-218, 1.0E-220, 1.0E-222, 1.0E-224, 1.0E-226, 1.0E-228, 1.0E-230, 1.0E-232, 1.0E-234, 1.0E-236, 1.0E-238, 1.0E-240, 1.0E-242, 1.0E-244, 1.0E-246, 1.0E-248, 1.0E-250, 1.0E-252, 1.0E-254};
    protected static final int MANTISSA_SIZE = 53;
    protected static final int expShift = 52;
    protected static final long fractHOB = 0x10000000000000L;
    protected static final long fractMask = 0xFFFFFFFFFFFFFL;
    protected static final int expBias = 1023;
    protected static final int maxSmallBinExp = 62;
    protected static final int minSmallBinExp = -21;
    protected static final long expOne = 0x3FF0000000000000L;
    protected static final long highbyte = -72057594037927936L;
    protected static final long highbit = Long.MIN_VALUE;
    protected static final long lowbytes = 0xFFFFFFFFFFFFFFL;
    private static final int[] small5pow = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
    private static final long[] long5pow = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
    private static final int[] n5bits = new int[]{0, 3, 5, 7, 10, 12, 14, 17, 19, 21, 24, 26, 28, 31, 33, 35, 38, 40, 42, 45, 47, 49, 52, 54, 56, 59, 61};
    public static final long DATE_POSITIVE_INFINITY = Long.MAX_VALUE;
    public static final long DATE_NEGATIVE_INFINITY = Long.MIN_VALUE;
    public static final String DATE_POSITIVE_INFINITY_TAG = "infinity";
    public static final String DATE_NEGATIVE_INFINITY_TAG = "-infinity";

    public static byte toByte(String object, int n2) throws SQLException {
        if (object == null) {
            return 0;
        }
        switch (n2) {
            case -6: {
                return TypeConverter.convertToByte((String)object);
            }
            case 5: {
                short s2 = TypeConverter.convertToShort((String)object);
                if (s2 > 127 || s2 < -128) {
                    throw new OSQLException("OSCAR-00701", "88888", 701);
                }
                return (byte)s2;
            }
            case 4: {
                int n3 = TypeConverter.convertToInt((String)object);
                if (n3 > 127 || n3 < -128) {
                    throw new OSQLException("OSCAR-00701", "88888", 701);
                }
                return (byte)n3;
            }
            case -5: {
                long l2 = TypeConverter.convertToLong((String)object);
                if (l2 > 127L || l2 < -128L) {
                    throw new OSQLException("OSCAR-00701", "88888", 701);
                }
                return (byte)l2;
            }
            case 7: {
                float f2 = TypeConverter.convertToFloat((String)object);
                if (f2 > 127.0f || f2 < -128.0f) {
                    throw new OSQLException("OSCAR-00701", "88888", 701);
                }
                return (byte)f2;
            }
            case 6: 
            case 8: {
                double d2 = TypeConverter.convertToDouble((String)object);
                if (d2 > 127.0 || d2 < -128.0) {
                    throw new OSQLException("OSCAR-00701", "88888", 701);
                }
                return (byte)d2;
            }
            case 2: 
            case 3: {
                object = TypeConverter.convertToDecimal((String)object);
                double d3 = ((BigDecimal)object).doubleValue();
                if (d3 > 127.0 || d3 < -128.0) {
                    throw new OSQLException("OSCAR-00701", "88888", 701);
                }
                return (byte)d3;
            }
            case 16: {
                boolean bl = TypeConverter.convertToBoolean((String)object);
                if (bl) {
                    return 1;
                }
                return 0;
            }
            case 1: {
                for (n2 = ((String)object).length() - 1; n2 >= 0; --n2) {
                    if (((String)object).charAt(n2) == ' ') continue;
                    object = ((String)object).substring(0, n2 + 1);
                    break;
                }
            }
            case -7: 
            case -1: 
            case 12: {
                return TypeConverter.convertToByte((String)object);
            }
        }
        throw new OSQLException("OSCAR-00701", "88888", 701);
    }

    public static short toShort(String object, int n2) throws SQLException {
        if (object == null) {
            return 0;
        }
        switch (n2) {
            case -6: {
                return TypeConverter.convertToByte((String)object);
            }
            case 5: {
                return TypeConverter.convertToShort((String)object);
            }
            case 4: {
                int n3 = TypeConverter.convertToInt((String)object);
                if (n3 > Short.MAX_VALUE || n3 < Short.MIN_VALUE) {
                    throw new OSQLException("OSCAR-00702", "88888", 702);
                }
                return (short)n3;
            }
            case -5: {
                long l2 = TypeConverter.convertToLong((String)object);
                if (l2 > 32767L || l2 < -32768L) {
                    throw new OSQLException("OSCAR-00702", "88888", 702);
                }
                return (short)l2;
            }
            case 7: {
                float f2 = TypeConverter.convertToFloat((String)object);
                if (f2 > 32767.0f || f2 < -32768.0f) {
                    throw new OSQLException("OSCAR-00702", "88888", 702);
                }
                return (short)f2;
            }
            case 6: 
            case 8: {
                double d2 = TypeConverter.convertToDouble((String)object);
                if (d2 > 32767.0 || d2 < -32768.0) {
                    throw new OSQLException("OSCAR-00702", "88888", 702);
                }
                return (short)d2;
            }
            case 2: 
            case 3: {
                object = TypeConverter.convertToDecimal((String)object);
                double d3 = ((BigDecimal)object).doubleValue();
                if (d3 > 32767.0 || d3 < -32768.0) {
                    throw new OSQLException("OSCAR-00702", "88888", 702);
                }
                return (short)d3;
            }
            case -7: 
            case 16: {
                boolean bl = TypeConverter.convertToBoolean((String)object);
                if (bl) {
                    return 1;
                }
                return 0;
            }
            case 1: {
                for (n2 = ((String)object).length() - 1; n2 >= 0; --n2) {
                    if (((String)object).charAt(n2) == ' ') continue;
                    object = ((String)object).substring(0, n2 + 1);
                    break;
                }
            }
            case -1: 
            case 12: {
                return TypeConverter.convertToShort((String)object);
            }
        }
        throw new OSQLException("OSCAR-00702", "88888", 702);
    }

    public static int toInt(String object, int n2) throws SQLException {
        if (object == null) {
            return 0;
        }
        switch (n2) {
            case -6: {
                return TypeConverter.convertToByte((String)object);
            }
            case 5: {
                return TypeConverter.convertToShort((String)object);
            }
            case 4: {
                return TypeConverter.convertToInt((String)object);
            }
            case -5: {
                long l2 = TypeConverter.convertToLong((String)object);
                if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
                    throw new OSQLException("OSCAR-00703", "88888", 703);
                }
                return (int)l2;
            }
            case 7: {
                float f2 = TypeConverter.convertToFloat((String)object);
                if (f2 > 2.1474836E9f || f2 < -2.1474836E9f) {
                    throw new OSQLException("OSCAR-00703", "88888", 703);
                }
                return (int)f2;
            }
            case 6: 
            case 8: {
                double d2 = TypeConverter.convertToDouble((String)object);
                if (d2 > 2.147483647E9 || d2 < -2.147483648E9) {
                    throw new OSQLException("OSCAR-00703", "88888", 703);
                }
                return (int)d2;
            }
            case 2: 
            case 3: {
                object = TypeConverter.convertToDecimal((String)object);
                double d3 = ((BigDecimal)object).doubleValue();
                if (d3 > 2.147483647E9 || d3 < -2.147483648E9) {
                    throw new OSQLException("OSCAR-00703", "88888", 703);
                }
                return (int)d3;
            }
            case -7: 
            case 16: {
                boolean bl = TypeConverter.convertToBoolean((String)object);
                if (bl) {
                    return 1;
                }
                return 0;
            }
            case 1: {
                for (n2 = ((String)object).length() - 1; n2 >= 0; --n2) {
                    if (((String)object).charAt(n2) == ' ') continue;
                    object = ((String)object).substring(0, n2 + 1);
                    break;
                }
            }
            case -1: 
            case 12: {
                return TypeConverter.convertToInt((String)object);
            }
        }
        throw new OSQLException("OSCAR-00703", "88888", 703);
    }

    public static long toLong(String object, int n2) throws SQLException {
        if (object == null) {
            return 0L;
        }
        switch (n2) {
            case -6: {
                return TypeConverter.convertToByte((String)object);
            }
            case 5: {
                return TypeConverter.convertToShort((String)object);
            }
            case 4: {
                return TypeConverter.convertToInt((String)object);
            }
            case -5: {
                return TypeConverter.convertToLong((String)object);
            }
            case 7: {
                float f2 = TypeConverter.convertToFloat((String)object);
                if (f2 > 9.223372E18f || f2 < -9.223372E18f) {
                    throw new OSQLException("OSCAR-00704", "88888", 704);
                }
                return (long)f2;
            }
            case 6: 
            case 8: {
                double d2 = TypeConverter.convertToDouble((String)object);
                if (d2 > 9.223372036854776E18 || d2 < -9.223372036854776E18) {
                    throw new OSQLException("OSCAR-00704", "88888", 704);
                }
                return (long)d2;
            }
            case 2: 
            case 3: {
                object = TypeConverter.convertToDecimal((String)object);
                if (((BigDecimal)object).compareTo(new BigDecimal(Long.toString(Long.MAX_VALUE))) > 0 || ((BigDecimal)object).compareTo(new BigDecimal(Long.toString(Long.MIN_VALUE))) < 0) {
                    throw new OSQLException("OSCAR-00704", "88888", 704);
                }
                return ((BigDecimal)object).longValue();
            }
            case -7: 
            case 16: {
                boolean bl = TypeConverter.convertToBoolean((String)object);
                if (bl) {
                    return 1L;
                }
                return 0L;
            }
            case 1: {
                for (n2 = ((String)object).length() - 1; n2 >= 0; --n2) {
                    if (((String)object).charAt(n2) == ' ') continue;
                    object = ((String)object).substring(0, n2 + 1);
                    break;
                }
            }
            case -1: 
            case 12: {
                return TypeConverter.convertToLong((String)object);
            }
        }
        throw new OSQLException("OSCAR-00704", "88888", 704);
    }

    public static float toFloat(String object, int n2) throws SQLException {
        if (object == null) {
            return 0.0f;
        }
        switch (n2) {
            case -6: {
                return TypeConverter.convertToByte((String)object);
            }
            case 5: {
                return TypeConverter.convertToShort((String)object);
            }
            case 4: {
                return TypeConverter.convertToInt((String)object);
            }
            case -5: {
                return TypeConverter.convertToLong((String)object);
            }
            case 7: {
                return TypeConverter.convertToFloat((String)object);
            }
            case 6: 
            case 8: {
                double d2 = TypeConverter.convertToDouble((String)object);
                if (d2 > 3.4028234663852886E38 || d2 < -3.4028234663852886E38) {
                    throw new OSQLException("OSCAR-00705", "88888", 705);
                }
                return (float)d2;
            }
            case 2: 
            case 3: {
                object = TypeConverter.convertToDecimal((String)object);
                double d3 = ((BigDecimal)object).doubleValue();
                if (d3 > 3.4028234663852886E38 || d3 < -3.4028234663852886E38) {
                    throw new OSQLException("OSCAR-00705", "88888", 705);
                }
                return (float)d3;
            }
            case -7: 
            case 16: {
                boolean bl = TypeConverter.convertToBoolean((String)object);
                if (bl) {
                    return 1.0f;
                }
                return 0.0f;
            }
            case 1: {
                for (n2 = ((String)object).length() - 1; n2 >= 0; --n2) {
                    if (((String)object).charAt(n2) == ' ') continue;
                    object = ((String)object).substring(0, n2 + 1);
                    break;
                }
                return TypeConverter.convertToFloat((String)object);
            }
            case -1: 
            case 12: {
                return TypeConverter.convertToFloat((String)object);
            }
        }
        throw new OSQLException("OSCAR-00705", "88888", 705);
    }

    public static double toDouble(String object, int n2) throws SQLException {
        if (object == null) {
            return 0.0;
        }
        switch (n2) {
            case -6: {
                return TypeConverter.convertToByte((String)object);
            }
            case 5: {
                return TypeConverter.convertToShort((String)object);
            }
            case 4: {
                return TypeConverter.convertToInt((String)object);
            }
            case -5: {
                return TypeConverter.convertToLong((String)object);
            }
            case 7: {
                return TypeConverter.convertToFloat((String)object);
            }
            case 6: 
            case 8: {
                return TypeConverter.convertToDouble((String)object);
            }
            case 2: 
            case 3: {
                double d2;
                if (((String)object).equals("NaN")) {
                    d2 = Double.parseDouble((String)object);
                } else {
                    d2 = ((BigDecimal)(object = TypeConverter.convertToDecimal((String)object))).doubleValue();
                    if (d2 > Double.MAX_VALUE || d2 < -1.7976931348623157E308) {
                        throw new OSQLException("OSCAR-00706", "88888", 706);
                    }
                }
                return d2;
            }
            case -7: 
            case 16: {
                boolean bl = TypeConverter.convertToBoolean((String)object);
                if (bl) {
                    return 1.0;
                }
                return 0.0;
            }
            case 1: {
                for (n2 = ((String)object).length() - 1; n2 >= 0; --n2) {
                    if (((String)object).charAt(n2) == ' ') continue;
                    object = ((String)object).substring(0, n2 + 1);
                    break;
                }
            }
            case -1: 
            case 12: {
                return TypeConverter.convertToDouble((String)object);
            }
        }
        throw new OSQLException("OSCAR-00706", "88888", 706);
    }

    public static BigDecimal toBigDecimal(String string, int n2) throws SQLException {
        if (string == null) {
            return null;
        }
        switch (n2) {
            case -6: {
                return BigDecimal.valueOf(TypeConverter.convertToByte(string));
            }
            case 5: {
                return BigDecimal.valueOf(TypeConverter.convertToShort(string));
            }
            case 4: {
                return BigDecimal.valueOf(TypeConverter.convertToInt(string));
            }
            case -5: {
                return BigDecimal.valueOf(TypeConverter.convertToLong(string));
            }
            case 7: {
                return new BigDecimal(TypeConverter.convertToFloat(string));
            }
            case 6: 
            case 8: {
                return TypeConverter.convertToDecimal(string);
            }
            case 2: 
            case 3: {
                return TypeConverter.convertToDecimal(string);
            }
            case -7: 
            case 16: {
                boolean bl = TypeConverter.convertToBoolean(string);
                if (bl) {
                    return BigDecimal.valueOf(1L);
                }
                return BigDecimal.valueOf(0L);
            }
            case 1: {
                n2 = string.indexOf(32);
                if (n2 != -1) {
                    for (int i2 = n2 + 1; i2 < string.length(); ++i2) {
                        if (string.charAt(i2) == ' ') continue;
                        throw new OSQLException("OSCAR-00707", "88888", 707);
                    }
                    string = string.substring(0, n2);
                }
                return TypeConverter.convertToDecimal(string);
            }
            case -1: 
            case 12: {
                return TypeConverter.convertToDecimal(string);
            }
        }
        throw new OSQLException("OSCAR-00707", "88888", 707);
    }

    public static BigDecimal toBigDecimal(String string, int n2, int n3) throws SQLException {
        if (string == null) {
            return null;
        }
        switch (n2) {
            case -6: {
                return BigDecimal.valueOf(TypeConverter.convertToByte(string)).setScale(n3);
            }
            case 5: {
                return BigDecimal.valueOf(TypeConverter.convertToShort(string)).setScale(n3);
            }
            case 4: {
                return BigDecimal.valueOf(TypeConverter.convertToInt(string)).setScale(n3);
            }
            case -5: {
                return BigDecimal.valueOf(TypeConverter.convertToLong(string)).setScale(n3);
            }
            case 7: {
                return new BigDecimal(TypeConverter.convertToFloat(string)).setScale(n3);
            }
            case 6: 
            case 8: {
                return new BigDecimal(TypeConverter.convertToDouble(string)).setScale(n3);
            }
            case 2: 
            case 3: {
                return TypeConverter.convertToDecimal(string, n3);
            }
            case -7: 
            case 16: {
                boolean bl = TypeConverter.convertToBoolean(string);
                if (bl) {
                    return BigDecimal.valueOf(1L).setScale(n3);
                }
                return BigDecimal.valueOf(0L).setScale(n3);
            }
            case 1: {
                n2 = string.indexOf(32);
                if (n2 != -1) {
                    for (int i2 = n2 + 1; i2 < string.length(); ++i2) {
                        if (string.charAt(i2) == ' ') continue;
                        throw new OSQLException("OSCAR-00707", "88888", 707);
                    }
                    string = string.substring(0, n2);
                }
                return TypeConverter.convertToDecimal(string, n3);
            }
            case -1: 
            case 12: {
                return TypeConverter.convertToDecimal(string, n3);
            }
        }
        throw new OSQLException("OSCAR-00707", "88888", 707);
    }

    public static boolean toBoolean(String object, int n2) throws SQLException {
        if (object == null) {
            return false;
        }
        switch (n2) {
            case -6: {
                return TypeConverter.convertToByte((String)object) != 0;
            }
            case 5: {
                return TypeConverter.convertToShort((String)object) != 0;
            }
            case 4: {
                return TypeConverter.convertToInt((String)object) != 0;
            }
            case -5: {
                return TypeConverter.convertToLong((String)object) != 0L;
            }
            case 7: {
                float f2 = TypeConverter.convertToFloat((String)object);
                return f2 >= 1.0E-10f || f2 <= -1.0E-10f;
            }
            case 6: 
            case 8: {
                double d2 = TypeConverter.convertToDouble((String)object);
                return d2 >= 1.0E-10 || d2 <= -1.0E-10;
            }
            case 2: 
            case 3: {
                object = TypeConverter.convertToDecimal((String)object, 15);
                double d3 = ((BigDecimal)object).doubleValue();
                return d3 >= 1.0E-10 || d3 <= -1.0E-10;
            }
            case -7: 
            case 16: {
                return TypeConverter.convertToBoolean((String)object);
            }
            case 1: {
                n2 = ((String)object).indexOf(32);
                if (n2 != -1) {
                    for (int i2 = n2 + 1; i2 < ((String)object).length(); ++i2) {
                        if (((String)object).charAt(i2) == ' ') continue;
                        throw new OSQLException("OSCAR-00708", "88888", 708);
                    }
                    object = ((String)object).substring(0, n2);
                }
                return TypeConverter.convertToBoolean((String)object);
            }
            case -1: 
            case 12: {
                return TypeConverter.convertToBoolean((String)object);
            }
        }
        throw new OSQLException("OSCAR-00708", "88888", 708);
    }

    public static byte[] toBytes(BaseConnection object, byte[] byArray, int n2) throws SQLException {
        if (byArray == null) {
            return null;
        }
        switch (n2) {
            case -4: 
            case -3: 
            case -2: {
                return OSCARbyte.toBytes(byArray);
            }
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: 
            case 92: 
            case 93: {
                return byArray;
            }
            case 2004: {
                object = object.getBlobInstance(new String(byArray));
                return ((OscarLob)object).getBytes(1L, (int)((OscarLob)object).length());
            }
        }
        throw new OSQLException("OSCAR-00709", "88888", 709);
    }

    public static Date toDate(String string, int n2) throws SQLException {
        if (string == null) {
            return null;
        }
        Date date = TypeConverter.toInfinityDate(string);
        if (date != null) {
            return date;
        }
        switch (n2) {
            case 1: {
                for (n2 = string.length() - 1; n2 >= 0; --n2) {
                    if (string.charAt(n2) == ' ') continue;
                    string = string.substring(0, n2 + 1);
                    break;
                }
            }
            case -1: 
            case 12: {
                if (string.indexOf("-") != -1) {
                    if (string.indexOf(":") != -1) {
                        return new Date(TypeConverter.convertToTimestamp(string).getTime());
                    }
                    return TypeConverter.convertToDate(string);
                }
                throw new OSQLException("OSCAR-00710", "88888", 710);
            }
            case 91: {
                return TypeConverter.convertToDate(string);
            }
            case 93: {
                return new Date(TypeConverter.convertToTimestamp(string).getTime());
            }
        }
        throw new OSQLException("OSCAR-00710", "88888", 710);
    }

    private static Date toInfinityDate(String string) {
        if (DATE_POSITIVE_INFINITY_TAG.equalsIgnoreCase(string)) {
            return new com.oscar.sql.Date(Long.MAX_VALUE);
        }
        if (DATE_NEGATIVE_INFINITY_TAG.equalsIgnoreCase(string)) {
            return new com.oscar.sql.Date(Long.MIN_VALUE);
        }
        return null;
    }

    public static Date toDate(String string, int n2, Calendar calendar, Calendar calendar2) throws SQLException {
        if (string == null) {
            return null;
        }
        Date date = TypeConverter.toInfinityDate(string);
        if (date != null) {
            return date;
        }
        switch (n2) {
            case 1: {
                for (n2 = string.length() - 1; n2 >= 0; --n2) {
                    if (string.charAt(n2) == ' ') continue;
                    string = string.substring(0, n2 + 1);
                    break;
                }
            }
            case -1: 
            case 12: {
                if (string.indexOf("-") != -1) {
                    if (string.indexOf(":") != -1) {
                        return new Date(TypeConverter.convertToTimestamp(string, calendar, calendar2).getTime());
                    }
                    return TypeConverter.convertToDate(string, calendar, calendar2);
                }
                throw new OSQLException("OSCAR-00710", "88888", 710);
            }
            case 91: {
                return TypeConverter.convertToDate(string, calendar, calendar2);
            }
            case 93: {
                return new Date(TypeConverter.convertToTimestamp(string, calendar, calendar2).getTime());
            }
        }
        throw new OSQLException("OSCAR-00710", "88888", 710);
    }

    public static java.sql.Time toTime(String string, int n2, Calendar calendar) throws SQLException {
        if (string == null) {
            return null;
        }
        switch (n2) {
            case 1: {
                for (n2 = string.length() - 1; n2 >= 0; --n2) {
                    if (string.charAt(n2) == ' ') continue;
                    string = string.substring(0, n2 + 1);
                    break;
                }
            }
            case -1: 
            case 12: 
            case 91: {
                if (string.indexOf(":") != -1) {
                    try {
                        if (string.indexOf("-") != -1) {
                            return new java.sql.Time(TypeConverter.convertToTimestamp(string).getTime());
                        }
                        return new java.sql.Time(TypeConverter.convertToTime(string, calendar.getTimeZone()).getTime());
                    }
                    catch (SQLException sQLException) {
                        throw new OSQLException("OSCAR-00711", "88888", 711);
                    }
                }
                throw new OSQLException("OSCAR-00711", "88888", 711);
            }
            case 92: {
                return new java.sql.Time(TypeConverter.convertToTime(string, calendar.getTimeZone()).getTime());
            }
            case 93: {
                return new java.sql.Time(TypeConverter.convertToTimestamp(string).getTime());
            }
        }
        throw new OSQLException("OSCAR-00711", "88888", 711);
    }

    public static java.sql.Time toTime(String string, int n2, Calendar calendar, Calendar calendar2) throws SQLException {
        if (string == null) {
            return null;
        }
        switch (n2) {
            case 1: {
                for (n2 = string.length() - 1; n2 >= 0; --n2) {
                    if (string.charAt(n2) == ' ') continue;
                    string = string.substring(0, n2 + 1);
                    break;
                }
            }
            case -1: 
            case 12: {
                if (string.indexOf(":") != -1) {
                    if (string.indexOf("-") != -1) {
                        return new java.sql.Time(TypeConverter.convertToTimestamp(string, calendar, calendar2).getTime());
                    }
                    return TypeConverter.convertToTime(string, calendar, calendar2);
                }
                throw new OSQLException("OSCAR-00711", "88888", 711);
            }
            case 92: {
                return TypeConverter.convertToTime(string, calendar, calendar2);
            }
            case 93: {
                return new java.sql.Time(TypeConverter.convertToTimestamp(string, calendar, calendar2).getTime());
            }
        }
        throw new OSQLException("OSCAR-00711", "88888", 711);
    }

    public static Timestamp toTimestamp(String object, int n2, Calendar calendar) throws SQLException {
        if (object == null) {
            return null;
        }
        Timestamp timestamp = TypeConverter.toInfinityTimestamp((String)object);
        if (timestamp != null) {
            return timestamp;
        }
        switch (n2) {
            case 1: {
                for (n2 = ((String)object).length() - 1; n2 >= 0; --n2) {
                    if (((String)object).charAt(n2) == ' ') continue;
                    object = ((String)object).substring(0, n2 + 1);
                    break;
                }
            }
            case -1: 
            case 12: {
                if (((String)object).indexOf(":") != -1) {
                    if (((String)object).indexOf("-") != -1) {
                        return TypeConverter.convertToTimestamp((String)object);
                    }
                    return new Timestamp(TypeConverter.convertToTime((String)object, calendar.getTimeZone()).getTime());
                }
                if (((String)object).indexOf("-") != -1) {
                    return new Timestamp(TypeConverter.convertToDate((String)object).getTime());
                }
                throw new OSQLException("OSCAR-00712", "88888", 712);
            }
            case 91: {
                return new Timestamp(TypeConverter.convertToDate((String)object).getTime());
            }
            case 92: {
                return new Timestamp(TypeConverter.convertToTime((String)object, calendar.getTimeZone()).getTime());
            }
            case 29: 
            case 93: {
                Timestamp timestamp2 = TypeConverter.convertToTimestamp((String)object);
                object = new Timestamp(timestamp2.getTime());
                ((Timestamp)object).setNanos(timestamp2.getNanos());
                return object;
            }
        }
        throw new OSQLException("OSCAR-00712", "88888", 712);
    }

    private static Timestamp toInfinityTimestamp(String string) {
        if (DATE_POSITIVE_INFINITY_TAG.equalsIgnoreCase(string)) {
            return new com.oscar.sql.Timestamp(Long.MAX_VALUE);
        }
        if (DATE_NEGATIVE_INFINITY_TAG.equalsIgnoreCase(string)) {
            return new com.oscar.sql.Timestamp(Long.MIN_VALUE);
        }
        return null;
    }

    public static Timestamp toTimestamp(String string, int n2, Calendar calendar, Calendar calendar2) throws SQLException {
        if (string == null) {
            return null;
        }
        Timestamp timestamp = TypeConverter.toInfinityTimestamp(string);
        if (timestamp != null) {
            return timestamp;
        }
        switch (n2) {
            case 1: {
                for (n2 = string.length() - 1; n2 >= 0; --n2) {
                    if (string.charAt(n2) == ' ') continue;
                    string = string.substring(0, n2 + 1);
                    break;
                }
            }
            case -1: 
            case 12: {
                if (string.indexOf(":") != -1) {
                    if (string.indexOf("-") != -1) {
                        return TypeConverter.convertToTimestamp(string, calendar, calendar2);
                    }
                    return new Timestamp(TypeConverter.convertToTime(string, calendar, calendar2).getTime());
                }
                if (string.indexOf("-") != -1) {
                    return new Timestamp(TypeConverter.convertToDate(string, calendar, calendar2).getTime());
                }
                throw new OSQLException("OSCAR-00712", "88888", 712);
            }
            case 91: {
                return new Timestamp(TypeConverter.convertToDate(string, calendar, calendar2).getTime());
            }
            case 92: {
                return new Timestamp(TypeConverter.convertToTime(string, calendar, calendar2).getTime());
            }
            case 93: {
                return TypeConverter.convertToTimestamp(string, calendar, calendar2);
            }
        }
        throw new OSQLException("OSCAR-00712", "88888", 712);
    }

    public static boolean convertToBoolean(String string) throws SQLException {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).length() == 1) {
            return string.charAt(0) == '1' || string.charAt(0) == 't' || string.charAt(0) == 'y' || string.charAt(0) == 'T' || string.charAt(0) == 'Y';
        }
        if (string.length() > 1) {
            if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) {
                return true;
            }
            if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no")) {
                return false;
            }
            for (int i2 = 0; i2 < string.length(); ++i2) {
                if (!(i2 == 0 ? string.charAt(0) != '-' && !Character.isDigit(string.charAt(i2)) : !Character.isDigit(string.charAt(i2)))) continue;
                return false;
            }
            return Double.parseDouble(string) >= 1.0E-10 || Double.parseDouble(string) <= -1.0E-10;
        }
        return false;
    }

    public static byte convertToByte(String string) throws SQLException {
        if (string == null) {
            return 0;
        }
        try {
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OSQLException("OSCAR-00701", "88888", 701);
        }
    }

    public static short convertToShort(String string) throws SQLException {
        if (string == null) {
            return 0;
        }
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OSQLException("OSCAR-00702", "88888", 702);
        }
    }

    public static int convertToInt(String string) throws SQLException {
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OSQLException("OSCAR-00703", "88888", 703);
        }
    }

    public static long convertToLong(String string) throws SQLException {
        if (string == null) {
            return 0L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OSQLException("OSCAR-00704", "88888", 704);
        }
    }

    public static float convertToFloat(String string) throws SQLException {
        if (string == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OSQLException("OSCAR-00705", "88888", 705);
        }
    }

    public static double convertToDouble(String string) throws SQLException {
        if (string == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OSQLException("OSCAR-00706", "88888", 706);
        }
    }

    public static BigDecimal convertToDecimal(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OSQLException("OSCAR-00707", "88888", 707);
        }
    }

    public static BigDecimal convertToDecimal(String object, int n2) throws SQLException {
        if (object == null) {
            return null;
        }
        try {
            object = new BigDecimal((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OSQLException("OSCAR-00707", "88888", 707);
        }
        if (n2 < 0) {
            return object;
        }
        try {
            return ((BigDecimal)object).setScale(n2, 4);
        }
        catch (ArithmeticException arithmeticException) {
            throw new OSQLException("OSCAR-00707", "88888", 707);
        }
    }

    public static Date convertToDate(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            Date date = com.oscar.sql.Date.valueOf(string);
            if (date instanceof com.oscar.sql.Date) {
                date = new Date(date.getTime());
            }
            return date;
        }
        catch (Exception exception) {
            try {
                return new Date(Long.parseLong(string));
            }
            catch (Exception exception2) {
                throw new OSQLException("OSCAR-00710", "88888", 710, exception2);
            }
        }
    }

    public static Date convertToDate(String object, Calendar calendar, Calendar calendar2) throws SQLException {
        if (object == null) {
            return null;
        }
        int n2 = calendar.get(15) + calendar.get(16);
        int n3 = calendar2.get(15) + calendar2.get(16);
        n2 = n3 - n2;
        object = TypeConverter.convertToDate((String)object);
        object = new Timestamp(((java.util.Date)object).getTime() + (long)n2);
        return new Date(((Timestamp)object).getTime());
    }

    public static synchronized java.sql.Time convertToTime(String string, TimeZone timeZone) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            string = string.trim();
            if (string.length() == 8) {
                return java.sql.Time.valueOf(string);
            }
            String string2 = "0";
            int n2 = string.indexOf(43);
            int n3 = string.indexOf(45);
            if (n2 >= 0) {
                string2 = string.substring(n2 + 1, n2 + 3);
                string = string.substring(0, n2);
            }
            if (n3 >= 0) {
                string2 = string.substring(n3 + 1, n3 + 3);
                string = string.substring(0, n3);
            }
            Time time = Time.valueOf(string.substring(0, 8));
            int n4 = string.indexOf(46);
            String string3 = "0";
            if (n4 > 0) {
                if (n3 < 0 && n2 < 0) {
                    string3 = string.substring(n4 + 1);
                } else {
                    if (n2 >= 0) {
                        string3 = string.substring(n4 + 1, n2);
                    }
                    if (n3 >= 0) {
                        string3 = string.substring(n4 + 1, n3);
                    }
                }
            }
            if (string3.trim().length() > 0) {
                string3 = string3.trim();
                int n5 = Integer.parseInt(string3);
                for (int i2 = 0; i2 < 6 - string3.length(); ++i2) {
                    n5 *= 10;
                }
                if (n5 / 100000000 <= 0) {
                    n5 *= 1000;
                }
                time.setNanos(n5);
            }
            Calendar calendar = Calendar.getInstance(timeZone);
            if (n2 >= 0 || n3 >= 0) {
                long l2 = time.getTime();
                calendar.setTimeInMillis(l2);
                int n6 = n2 >= 0 ? Integer.parseInt("-" + string2) : Integer.parseInt(string2);
                calendar.add(10, n6);
                long l3 = (l2 - calendar.getTimeInMillis()) / 1000L;
                time.setZone((int)l3);
            }
            return time;
        }
        catch (Exception exception) {
            throw new OSQLException("OSCAR-00711", "88888", 711, exception);
        }
    }

    public static java.sql.Time convertToTime(String string, Calendar calendar, Calendar calendar2) throws SQLException {
        if (string == null) {
            return null;
        }
        int n2 = calendar.get(15) + calendar.get(16);
        int n3 = calendar2.get(15) + calendar2.get(16);
        n2 -= n3;
        try {
            int n4;
            string = string.trim();
            if (string.length() == 8) {
                java.sql.Time time = java.sql.Time.valueOf(string);
                return new java.sql.Time(time.getTime() + (long)n2);
            }
            java.sql.Time time = java.sql.Time.valueOf(string.substring(0, 8));
            if ((string = string.substring(9)).length() > 3) {
                string = string.substring(0, 3);
            }
            if ((n4 = Integer.parseInt(string)) < 10) {
                n4 *= 100;
            } else if (n4 < 100) {
                n4 *= 10;
            }
            return new java.sql.Time(time.getTime() + (long)n2 + (long)n4);
        }
        catch (Exception exception) {
            throw new OSQLException("OSCAR-00711", "88888", 711, exception);
        }
    }

    public static Timestamp convertToTimestamp(String string) throws SQLException {
        if (string == null) {
            return null;
        }
        try {
            return com.oscar.sql.Timestamp.valueOf(string);
        }
        catch (Exception exception) {
            try {
                return new Timestamp(Long.parseLong(string));
            }
            catch (Exception exception2) {
                throw new OSQLException("OSCAR-00712", "88888", 712, exception2);
            }
        }
    }

    public static Timestamp convertToTimestamp(String object, Calendar calendar, Calendar calendar2) throws SQLException {
        if (object == null) {
            return null;
        }
        int n2 = calendar.get(15) + calendar.get(16);
        int n3 = calendar2.get(15) + calendar2.get(16);
        n2 = n3 - n2;
        n3 = ((String)object).indexOf(46);
        if (n3 != -1 && ((String)object).substring(n3 + 1).length() >= 9) {
            object = ((String)object).substring(0, n3 + 1) + ((String)object).substring(n3 + 1, n3 + 10);
        }
        try {
            object = Timestamp.valueOf((String)object);
            Timestamp timestamp = new Timestamp(((Timestamp)object).getTime() + (long)n2);
            timestamp.setNanos(((Timestamp)object).getNanos());
            return timestamp;
        }
        catch (Exception exception) {
            throw new OSQLException("OSCAR-00712", "88888", 712, exception);
        }
    }

    protected static int calculateRemainderLength(double d2, int n2) {
        double d3 = d2 % 100.0;
        double d4 = d2 / 100.0;
        if (d3 > -1.0 && d3 < 1.0) {
            n2 -= 2;
            d3 = d4 % 100.0;
            d4 /= 100.0;
            if (d3 > -1.0 && d3 < 1.0) {
                double d5;
                n2 -= 2;
                d3 = d4 % 100.0;
                if (d5 > -1.0 && d3 < 1.0) {
                    n2 -= 2;
                }
            }
        }
        return n2;
    }

    public static int getByteLength(long l2) {
        int n2 = 10;
        if (l2 / 1000000000000000000L == 0L) {
            --n2;
            if (l2 / 10000000000000000L == 0L) {
                --n2;
                if (l2 / 100000000000000L == 0L) {
                    --n2;
                    if (l2 / 1000000000000L == 0L) {
                        --n2;
                        if (l2 / 10000000000L == 0L) {
                            --n2;
                            if (l2 / 100000000L == 0L) {
                                --n2;
                                if (l2 / 1000000L == 0L) {
                                    --n2;
                                    if (l2 / 10000L == 0L) {
                                        --n2;
                                        if (l2 / 100L == 0L) {
                                            --n2;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return n2;
    }

    public static int getByteLength(long l2, int n2) {
        long l3;
        int n3 = 0;
        while ((l3 = l2 / Double.valueOf(Math.pow(100.0, n3)).longValue() % 100L) == 0L) {
            --n2;
            ++n3;
        }
        return n2;
    }

    public static long getLongInternal(byte[] byArray) {
        if (byArray.length == 1) {
            return 0L;
        }
        int n2 = byArray.length;
        int n3 = 1;
        long l2 = 0L;
        byte by = byArray[0];
        do {
            l2 = l2 * 100L + (long)(byArray[n3] - 1);
        } while (++n3 != n2);
        if (by == 1) {
            return -l2;
        }
        return l2;
    }

    protected static int getMonth(byte[] byArray) {
        return byArray[2] - 1;
    }

    protected static int getDay(byte[] byArray) {
        return byArray[3];
    }

    protected static int getHour(byte[] byArray) {
        return byArray[4] - 1;
    }

    protected static int getMin(byte[] byArray) {
        return byArray[5] - 1;
    }

    protected static int getSec(byte[] byArray) {
        return byArray[6] - 1;
    }

    protected static int getNanos(byte[] byArray) {
        int n2 = (byArray[7] & 0xFF) << 24;
        n2 |= (byArray[8] & 0xFF) << 16;
        n2 |= (byArray[9] & 0xFF) << 8;
        if ((n2 |= byArray[10] & 0xFF) / 100000000 <= 0) {
            n2 *= 1000;
        }
        return n2;
    }

    protected static int getTimeNanos(byte[] byArray) {
        int n2 = (byArray[3] & 0xFF) << 24;
        n2 |= (byArray[4] & 0xFF) << 16;
        n2 |= (byArray[5] & 0xFF) << 8;
        if ((n2 |= byArray[6] & 0xFF) / 100000000 <= 0) {
            n2 *= 1000;
        }
        return n2;
    }

    protected static int getTimeHour(byte[] byArray) {
        return byArray[0] - 1;
    }

    protected static int getTimeMin(byte[] byArray) {
        return byArray[1] - 1;
    }

    protected static int getTimeSec(byte[] byArray) {
        return byArray[2] - 1;
    }

    static int countBits(long l2) {
        if (l2 == 0L) {
            return 0;
        }
        while ((l2 & 0xFFFFFFFL) == 0L) {
            l2 <<= 8;
        }
        while (l2 > 0L) {
            l2 <<= 1;
        }
        int n2 = 0;
        long l3 = 0L;
        while ((l2 & 0xFFFFFFFFF0000000L) != 0L) {
            l3 = l2;
            l2 <<= 8;
            n2 += 8;
        }
        if (n2 >= 8 && l2 == 0L) {
            n2 -= 8;
        }
        while (l3 != 0L) {
            l3 <<= 1;
            ++n2;
        }
        return n2;
    }

    public static boolean roundup(char[] cArray, int n2) {
        char c2;
        if ((c2 = cArray[--n2]) == '9') {
            while (c2 == '9' && n2 > 0) {
                cArray[n2] = 48;
                c2 = cArray[--n2];
            }
            if (c2 == '9') {
                cArray[0] = 49;
                return true;
            }
        }
        cArray[n2] = (char)(c2 + '\u0001');
        return false;
    }

    public static int getZone(byte[] byArray, int n2) {
        int n3 = byArray[n2] - 20;
        int n4 = byArray[++n2] - 60;
        n4 = n3 * 3600 + n4 * 60;
        return n4;
    }

    public static void main(String[] stringArray) {
    }
}

