/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util;

import java.io.IOException;
import java.util.Properties;

public class VersionConfig {
    private static volatile VersionConfig instance = null;
    public static final int VERSION_69 = 1;
    public static final int VERSION_56 = 2;
    public static final int VERSION_56_SEC = 3;
    public static final int VERSION_57 = 4;
    public static final int OldTransferType = 1;
    public static final int NewTransferType = 2;
    private int mainVersion = 0;
    private int childVersion = 0;
    private int transferType = 0;
    private boolean wuziVersion = false;
    private boolean convertLobLocatorByFunc = true;
    private boolean sendQueryNumForNotRealPrepare = true;
    private boolean haveEmptyXlobWithOid = true;
    private boolean newParamInfoPacket = false;
    private boolean receiveErrorCode = false;
    private int DBMajorVersion = 0;
    private int DBMinorVersion = 0;
    private int DriverMajorVersion = 0;
    private int DriverMinorVersion = 0;
    private Properties prop = new Properties();

    private VersionConfig() {
        this.loadFromFile();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VersionConfig getInstance() {
        if (instance != null) return instance;
        Class<VersionConfig> clazz = VersionConfig.class;
        synchronized (VersionConfig.class) {
            if (instance != null) return instance;
            instance = new VersionConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void loadFromFile() {
        var1_1 = null;
        try {
            var1_1 = this.getClass().getResourceAsStream("/com/oscar/util/versionConfig.properties");
            this.prop.load(var1_1);
            ** if (var1_1 == null) goto lbl-1000
        }
        catch (IOException v1) {
            try {
                var2_2 = v1;
                v1.printStackTrace();
                ** if (var1_1 == null) goto lbl-1000
            }
            catch (Throwable var2_3) {
                if (var1_1 != null) {
                    try {
                        var1_1.close();
                    }
                    catch (IOException v3) {}
                }
                throw var2_3;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var1_1.close();
                }
                catch (IOException v2) {}
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                var1_1.close();
            }
            catch (IOException v0) {}
        }
lbl-1000:
        // 2 sources

        {
        }
        this.explainProperties();
    }

    protected void explainProperties() {
        this.mainVersion = Integer.parseInt(this.getConfigValue("MainVersion", true));
        this.childVersion = Integer.parseInt(this.getConfigValue("ChildVersion", true));
        this.DBMajorVersion = Integer.parseInt(this.getConfigValue("DBMajorVersion"));
        this.DBMinorVersion = Integer.parseInt(this.getConfigValue("DBMinorVersion"));
        this.DriverMajorVersion = Integer.parseInt(this.getConfigValue("DriverMajorVersion"));
        this.DriverMinorVersion = Integer.parseInt(this.getConfigValue("DriverMinorVersion"));
        this.setDefaultConfigWithVersion();
        String string = this.getConfigValue("WuziVersion");
        this.wuziVersion = string == null ? false : Boolean.parseBoolean(string);
        string = this.getConfigValue("TransferType");
        if (string != null) {
            this.transferType = Integer.parseInt(string);
        }
        if ((string = this.getConfigValue("ConvertLobLocatorByFunc")) != null) {
            this.convertLobLocatorByFunc = Boolean.parseBoolean(string);
        }
        if ((string = this.getConfigValue("SendQueryNumForNotRealPrepare")) != null) {
            this.sendQueryNumForNotRealPrepare = Boolean.parseBoolean(string);
        }
        if ((string = this.getConfigValue("HaveEmptyXlobWithOid")) != null) {
            this.haveEmptyXlobWithOid = Boolean.parseBoolean(string);
        }
        if ((string = this.getConfigValue("ReceiveErrorCode")) != null) {
            this.receiveErrorCode = Boolean.parseBoolean(string);
        }
    }

    private void setDefaultConfigWithVersion() throws Error {
        switch (this.mainVersion) {
            case 1: {
                this.transferType = this.childVersion < 46 ? 1 : 2;
                this.convertLobLocatorByFunc = this.childVersion >= 48;
                this.sendQueryNumForNotRealPrepare = false;
                this.haveEmptyXlobWithOid = false;
                this.newParamInfoPacket = false;
                return;
            }
            case 2: {
                this.transferType = 2;
                this.convertLobLocatorByFunc = this.childVersion >= 8;
                this.sendQueryNumForNotRealPrepare = this.childVersion >= 8;
                this.haveEmptyXlobWithOid = this.childVersion >= 8;
                this.newParamInfoPacket = false;
                return;
            }
            case 3: {
                this.transferType = 2;
                this.convertLobLocatorByFunc = this.childVersion >= 8;
                this.sendQueryNumForNotRealPrepare = this.childVersion >= 8;
                this.haveEmptyXlobWithOid = this.childVersion >= 8;
                this.newParamInfoPacket = false;
                return;
            }
            case 4: {
                this.transferType = 2;
                this.convertLobLocatorByFunc = true;
                this.sendQueryNumForNotRealPrepare = false;
                this.haveEmptyXlobWithOid = true;
                this.newParamInfoPacket = true;
                if (this.childVersion <= 4) break;
                this.receiveErrorCode = true;
                return;
            }
            default: {
                throw new Error("\u672a\u77e5\u540e\u53f0\u7248\u672c\u53f7");
            }
        }
    }

    private String getConfigValue(String string) {
        return this.getConfigValue(string, false);
    }

    private String getConfigValue(String string, boolean bl) {
        if ((string = this.prop.getProperty(string)) == null && bl) {
            throw new Error("JDBC\u7248\u672c\u914d\u7f6e\u6587\u4ef6\u51fa\u9519");
        }
        return string;
    }

    public String getVersionValue(String string, String string2) {
        return this.prop.getProperty(string, string2);
    }

    public int getMainVersion() {
        return this.mainVersion;
    }

    public int getTransferType() {
        return this.transferType;
    }

    public boolean isConvertLobLocatorByFunc() {
        return this.convertLobLocatorByFunc;
    }

    public boolean isSendQueryNumForNotRealPrepare() {
        return this.sendQueryNumForNotRealPrepare;
    }

    public boolean isHaveEmptyXlobWithOid() {
        return this.haveEmptyXlobWithOid;
    }

    public boolean isNewParamInfoPacket() {
        return this.newParamInfoPacket;
    }

    public boolean isReceiveErrorCode() {
        return this.receiveErrorCode;
    }

    public int getDBMajorVersion() {
        return this.DBMajorVersion;
    }

    public int getDBMinorVersion() {
        return this.DBMinorVersion;
    }

    public int getDriverMajorVersion() {
        return this.DriverMajorVersion;
    }

    public int getDriverMinorVersion() {
        return this.DriverMinorVersion;
    }
}

