/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util.converter;

import com.oscar.core.Encoding;

public abstract class CharacterSet
extends Encoding {
    public static final byte[] stringToUTF(String object) {
        try {
            char[] cArray = ((String)object).toCharArray();
            object = cArray;
            int n2 = cArray.length * 3;
            byte[] byArray = new byte[n2];
            int n3 = CharacterSet.convertJavaCharsToUTFBytes((char[])object, 0, byArray, 0, ((Object)object).length);
            object = new byte[n3];
            System.arraycopy(byArray, 0, object, 0, n3);
            return object;
        }
        catch (Exception exception) {
            System.out.println("stringToUTF fail");
            return null;
        }
    }

    public static final int convertJavaCharsToUTFBytes(char[] cArray, int n2, byte[] byArray, int n3, int n4) {
        int n5 = n2;
        n2 += n4;
        n4 = n3;
        while (n5 < n2) {
            char c2 = cArray[n5];
            if (c2 >= '\u0000' && c2 <= '\u007f') {
                byArray[n4++] = (byte)c2;
            } else if (c2 > '\u07ff') {
                byArray[n4++] = (byte)(0xE0 | c2 >>> 12 & 0xF);
                byArray[n4++] = (byte)(0x80 | c2 >>> 6 & 0x3F);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
            } else {
                byArray[n4++] = (byte)(0xC0 | c2 >>> 6 & 0x1F);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
            }
            ++n5;
        }
        return n4 - n3;
    }

    public static final int convertUTFBytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int n4, boolean bl) {
        return CharacterSet.convertUTFBytesToJavaChars(byArray, n2, cArray, n3, n4, bl, cArray.length - n3);
    }

    public static final int convertUTFBytesToJavaChars(byte[] byArray, int n2, char[] cArray, int n3, int n4, boolean n5, int n6) {
        n5 = n2;
        n2 += n4;
        n4 = n3;
        n6 = n3 + n6;
        block5: while (n5 < n2) {
            char c2 = byArray[n5++];
            int n7 = c2 & 0xF0;
            switch (n7 / 16) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (n4 >= n6) continue block5;
                    cArray[n4++] = c2;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if (n5 >= n2) continue block5;
                    c2 = CharacterSet.conv2ByteUTFtoUTF16((byte)c2, byArray[n5++]);
                    if (n4 >= n6) continue block5;
                    cArray[n4++] = c2;
                    continue block5;
                }
                case 14: {
                    if (n5 + 1 >= n2) continue block5;
                    char c3 = CharacterSet.conv3ByteUTFtoUTF16((byte)c2, byArray[n5++], byArray[n5++]);
                    n7 = c3;
                    if (CharacterSet.isHiSurrogate(c3)) {
                        if (n4 > n6 - 2 || n5 >= n2) continue block5;
                        c2 = byArray[n5];
                        if ((byte)(c2 & 0xF0) != -32) {
                            cArray[n4++] = 65533;
                            continue block5;
                        }
                        if (++n5 + 1 >= n2) continue block5;
                        cArray[n4++] = CharacterSet.isLoSurrogate(c2 = CharacterSet.conv3ByteUTFtoUTF16((byte)c2, byArray[n5++], byArray[n5++])) ? n7 : 65533;
                        cArray[n4++] = c2;
                        continue block5;
                    }
                    if (n4 >= n6) continue block5;
                    cArray[n4++] = n7;
                    continue block5;
                }
            }
            if (n4 >= n6) continue;
            cArray[n4++] = 65533;
        }
        return n4 - n3;
    }

    public static final char conv2ByteUTFtoUTF16(byte by, byte by2) {
        if (by < -62 || by > -33 || !CharacterSet.check80toBF(by2)) {
            return '\ufffd';
        }
        return (char)((by & 0x1F) << 6 | by2 & 0x3F);
    }

    public static final char conv3ByteUTFtoUTF16(byte by, byte by2, byte by3) {
        if (!(by == -32 && CharacterSet.checkA0toBF(by2) && CharacterSet.check80toBF(by3) || by >= -31 && by <= -17 && CharacterSet.check80toBF(by2) && CharacterSet.check80toBF(by3))) {
            return '\ufffd';
        }
        return (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | by3 & 0x3F);
    }

    public static final boolean check80toBF(byte by) {
        return (by & 0xFFFFFFC0) == -128;
    }

    public static final boolean checkA0toBF(byte by) {
        return (by & 0xFFFFFFE0) == -96;
    }

    public static final boolean isLoSurrogate(char c2) {
        return (char)(c2 & 0xFC00) == '\udc00';
    }

    public static final boolean isHiSurrogate(char c2) {
        return (char)(c2 & 0xFC00) == '\ud800';
    }
}

