/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util.converter;

import com.oscar.util.OSQLException;
import com.oscar.util.TypeConverter;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Calendar;

public class DateConverter
extends TypeConverter {
    private static final byte[] POSITIVE_INFINITY = new byte[]{-3, 2};
    private static final byte[] NEGATIVE_INFINITY = new byte[]{-3, 3};

    public static byte[] convertDateToBytes(Date date, Calendar calendar) {
        if (date == null) {
            return null;
        }
        if (date.getTime() == Long.MAX_VALUE) {
            return POSITIVE_INFINITY;
        }
        if (date.getTime() == Long.MIN_VALUE) {
            return NEGATIVE_INFINITY;
        }
        byte[] byArray = new byte[7];
        calendar.setTime(date);
        int n2 = calendar.get(1);
        if (calendar.get(0) == 0) {
            n2 = -n2;
        }
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        return byArray;
    }

    public static String convertBytesToDateString(byte[] object) throws SQLException {
        if (object == null) {
            return null;
        }
        if (((byte[])object).length == 2 && object[0] == -3) {
            if (object[1] == 2) {
                return new com.oscar.sql.Date(Long.MAX_VALUE).toString();
            }
            if (object[1] == 3) {
                return new com.oscar.sql.Date(Long.MIN_VALUE).toString();
            }
        }
        boolean bl = false;
        if (((byte[])object).length == 7) {
            int n2 = ((object[0] & 0xFF) - 100) * 100 + (object[1] & 0xFF) - 100;
            if (n2 < 0) {
                n2 = -n2;
                bl = true;
            }
            int n3 = DateConverter.getMonth(object) + 1;
            int n4 = DateConverter.getDay(object);
            object = String.format("%04d-%02d-%02d %02d:%02d:%02d", n2, n3, n4, DateConverter.getHour(object), DateConverter.getMin(object), DateConverter.getSec(object));
            if (bl) {
                return (String)object + " BC";
            }
            return object;
        }
        if (((byte[])object).length == 4) {
            int n5 = ((object[0] & 0xFF) - 100) * 100 + (object[1] & 0xFF) - 100;
            if (n5 < 0) {
                n5 = -n5;
                bl = true;
            }
            int n6 = DateConverter.getMonth(object) + 1;
            int n7 = DateConverter.getDay(object);
            object = String.format("%04d-%02d-%02d", n5, n6, n7);
            if (bl) {
                return (String)object + " BC";
            }
            return object;
        }
        throw new OSQLException("OSCAR-00710", "88888", 710);
    }
}

