/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util.converter;

import com.oscar.util.TypeConverter;

public class IntervalConverter
extends TypeConverter {
    private static long YEAR_DAY_NS_MASK = Integer.MIN_VALUE;
    private static int MONTH_HOUR_MIN_SEC_MASK = 60;
    private static long MASK = 0x100000000L;

    public static String convertToIntervalDTS(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 11) {
            int n2;
            long l2;
            int n3;
            int n4;
            int n5;
            StringBuffer stringBuffer = new StringBuffer();
            int n6 = 0;
            long l3 = IntervalConverter.converToYearOrDay(byArray, 0);
            if (l3 < 0L) {
                n6 = 1;
                l3 = -l3;
            }
            if ((n5 = IntervalConverter.converToMhms(byArray, 4)) < 0) {
                n6 = 1;
                n5 = -n5;
            }
            if ((n4 = IntervalConverter.converToMhms(byArray, 5)) < 0) {
                n6 = 1;
                n4 = -n4;
            }
            if ((n3 = IntervalConverter.converToMhms(byArray, 6)) < 0) {
                n6 = 1;
                n3 = -n3;
            }
            if ((l2 = IntervalConverter.converToYearOrDay(byArray, 7)) < 0L) {
                n6 = 1;
                l2 = -l2;
            }
            if (n6 != 0) {
                stringBuffer.append("-");
            } else {
                stringBuffer.append("+");
            }
            for (n2 = IntervalConverter.getLenth(l3); n2 < 6; ++n2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(l3).append(" ");
            for (n2 = IntervalConverter.getLenth(n5); n2 < 2; ++n2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n5).append(":");
            for (n2 = IntervalConverter.getLenth(n4); n2 < 2; ++n2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n4).append(":");
            for (n2 = IntervalConverter.getLenth(n3); n2 < 2; ++n2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n3);
            if (l2 != 0L) {
                n2 = 0;
                while (l2 % 10L == 0L) {
                    l2 /= 10L;
                    ++n2;
                }
                n6 = IntervalConverter.getLenth(l2);
                n2 = 6 - n6 - n2;
                stringBuffer.append(".");
                for (n6 = 0; n6 < n2; ++n6) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(l2);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static String convertToIntervalYTM(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 5) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            long l2 = IntervalConverter.converToYearOrDay(byArray, 0);
            if (l2 < 0L) {
                n3 = 1;
                l2 = -l2;
            }
            if ((n2 = IntervalConverter.converToMhms(byArray, 4)) < 0) {
                n3 = 1;
                n2 = -n2;
            }
            if (n3 != 0) {
                stringBuffer.append("-");
            } else {
                stringBuffer.append("+");
            }
            for (n3 = IntervalConverter.getLenth(l2); n3 < 9; ++n3) {
                stringBuffer.append("0");
            }
            stringBuffer.append(l2).append("-");
            for (n3 = IntervalConverter.getLenth(n2); n3 < 2; ++n3) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n2);
            return stringBuffer.toString();
        }
        return null;
    }

    protected static int getLenth(long l2) {
        if (l2 == 0L) {
            return 1;
        }
        int n2 = 0;
        while (l2 >= 1L) {
            l2 /= 10L;
            ++n2;
        }
        return n2;
    }

    protected static long converToYearOrDay(byte[] byArray, int n2) {
        if (byArray == null || byArray.length < n2 + 4) {
            return 0L;
        }
        long l2 = IntervalConverter.getNumber(byArray[n2]) << 24;
        l2 |= (long)(IntervalConverter.getNumber(byArray[n2 + 1]) << 16);
        l2 |= (long)(IntervalConverter.getNumber(byArray[n2 + 2]) << 8);
        if ((l2 |= (long)IntervalConverter.getNumber(byArray[n2 + 3])) < 0L) {
            l2 = MASK + l2;
        }
        return l2 + YEAR_DAY_NS_MASK;
    }

    private static int getNumber(byte n2) {
        return (n2 < 0 ? n2 + 256 : n2) & 0xFF;
    }

    protected static int converToMhms(byte[] byArray, int n2) {
        if (byArray == null || byArray.length < n2 + 1) {
            return 0;
        }
        int n3 = byArray[n2] - MONTH_HOUR_MIN_SEC_MASK;
        return n3;
    }

    public static void main(String[] stringArray) {
        int n2 = 123000;
        while (n2 % 10 == 0) {
            n2 /= 10;
        }
        System.out.println(123);
    }
}

