/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.util.converter;

import com.oscar.util.TypeConverter;
import java.sql.Timestamp;
import java.util.Calendar;

public class TimestampConverter
extends TypeConverter {
    private static final byte[] POSITIVE_INFINITY = new byte[]{-3, 2};
    private static final byte[] NEGATIVE_INFINITY = new byte[]{-3, 3};

    public static synchronized byte[] convertTimestampToBytes(Timestamp timestamp, Calendar calendar) {
        if (timestamp == null) {
            return null;
        }
        byte[] byArray = TimestampConverter.convertInfinityTimestampToBytes(timestamp);
        if (byArray != null) {
            return byArray;
        }
        byArray = new byte[11];
        calendar.setTime(timestamp);
        int n2 = calendar.get(1);
        long l2 = timestamp.getNanos();
        l2 /= 1000L;
        if (calendar.get(0) == 0) {
            n2 = -n2;
        }
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)(calendar.get(11) + 1);
        byArray[5] = (byte)(calendar.get(12) + 1);
        byArray[6] = (byte)(calendar.get(13) + 1);
        byArray[10] = (byte)(l2 & 0xFFL);
        byArray[9] = (byte)(l2 >> 8 & 0xFFL);
        byArray[8] = (byte)(l2 >> 16 & 0xFFL);
        byArray[7] = (byte)(l2 >> 24 & 0xFFL);
        return byArray;
    }

    public static com.oscar.sql.Timestamp convertBytesToTimeStamp(byte[] object) {
        com.oscar.sql.Timestamp timestamp = TimestampConverter.convertBytesToInfinityTimeStamp((byte[])object);
        if (timestamp != null) {
            return timestamp;
        }
        int n2 = ((object[0] & 0xFF) - 100) * 100 + (object[1] & 0xFF) - 100;
        boolean bl = false;
        if (n2 < 0) {
            n2 = -n2;
            bl = true;
        }
        int n3 = TimestampConverter.getMonth((byte[])object);
        int n4 = TimestampConverter.getDay((byte[])object);
        int n5 = TimestampConverter.getHour((byte[])object);
        int n6 = TimestampConverter.getMin((byte[])object);
        int n7 = TimestampConverter.getSec((byte[])object);
        int n8 = 0;
        if (((byte[])object).length >= 11) {
            n8 = TimestampConverter.getNanos((byte[])object);
        }
        int n9 = 0;
        if (((byte[])object).length >= 13) {
            n9 = TimestampConverter.getZone((byte[])object, 11);
        }
        com.oscar.sql.Timestamp timestamp2 = new com.oscar.sql.Timestamp(n2 - 1900, n3, n4, n5, n6, n7, n8);
        object = timestamp2;
        timestamp2.setZone(n9);
        ((com.oscar.sql.Timestamp)object).setBC(bl);
        return object;
    }

    private static com.oscar.sql.Timestamp convertBytesToInfinityTimeStamp(byte[] byArray) {
        if (byArray.length == 2 && byArray[0] == -3) {
            if (byArray[1] == 2) {
                return new com.oscar.sql.Timestamp(Long.MAX_VALUE);
            }
            if (byArray[1] == 3) {
                return new com.oscar.sql.Timestamp(Long.MIN_VALUE);
            }
        }
        return null;
    }

    private static byte[] convertInfinityTimestampToBytes(Timestamp timestamp) {
        if (timestamp.getTime() == Long.MAX_VALUE) {
            return POSITIVE_INFINITY;
        }
        if (timestamp.getTime() == Long.MIN_VALUE) {
            return NEGATIVE_INFINITY;
        }
        return null;
    }
}

