/*
 * Decompiled with CFR 0.152.
 */
package com.oscar.xa;

import com.oscar.jdbc.OscarXid;
import com.oscar.jdbcx.Jdbc3PooledConnection;
import com.oscar.util.StringUtils;
import com.oscar.util.XAOSQLException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class Jdbc3XAConnection
extends Jdbc3PooledConnection
implements XAConnection,
XAResource {
    private final Connection conn;
    private Xid currentXid;
    private int state;
    private static final int STATE_IDLE = 0;
    private static final int STATE_ACTIVE = 1;
    private static final int STATE_ENDED = 2;

    public Jdbc3XAConnection(Connection connection) {
        super(connection, true, true);
        this.conn = connection;
        this.state = 0;
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        return this;
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("XA COMMIT ");
        Jdbc3XAConnection.appendXid(stringBuilder, xid);
        if (bl) {
            stringBuilder.append(" ONE PHASE");
        }
        if (!this.currentXid.equals(xid)) {
            throw new XAOSQLException("prepare must be issued using the same connection that started the transaction");
        }
        if (this.state != 2) {
            throw new XAOSQLException("commit called before end");
        }
        try {
            this.executeXA(stringBuilder.toString());
            return;
        }
        catch (SQLException sQLException) {
            throw new XAOSQLException(sQLException.getMessage());
        }
    }

    @Override
    public void end(Xid xid, int n2) throws XAException {
        if (xid == null) {
            throw new XAOSQLException("xid must not be null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("XA END ");
        Jdbc3XAConnection.appendXid(stringBuilder, xid);
        switch (n2) {
            case 0x2000000: {
                stringBuilder.append(" SUSPEND");
            }
        }
        if (this.state != 1 || !this.currentXid.equals(xid)) {
            throw new XAOSQLException("tried to call end without corresponding start call");
        }
        try {
            this.executeXA(stringBuilder.toString());
        }
        catch (SQLException sQLException) {
            throw new XAOSQLException(sQLException.getMessage());
        }
        this.state = 2;
    }

    @Override
    public void forget(Xid xid) throws XAException {
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        return xAResource == this;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (!this.currentXid.equals(xid)) {
            throw new XAOSQLException("prepare must be issued using the same connection that started the transaction");
        }
        if (this.state != 2) {
            throw new XAOSQLException("Prepare called before end");
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("XA PREPARE ");
            Jdbc3XAConnection.appendXid(stringBuilder, xid);
            this.executeXA(stringBuilder.toString());
            return 0;
        }
        catch (SQLException sQLException) {
            throw new XAOSQLException(sQLException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Xid[] recover(int n2) throws XAException {
        int n3;
        ArrayList<OscarXid> arrayList;
        Statement statement;
        block18: {
            if (n2 != 0x1000000 && n2 != 0x800000 && n2 != 0 && n2 != 0x1800000) {
                throw new XAOSQLException(-5, "xa transaction recover not supported");
            }
            ResultSet resultSet = null;
            statement = null;
            arrayList = new ArrayList<OscarXid>();
            try {
                statement = this.conn.createStatement();
                statement.execute("XA RECOVER");
                resultSet = statement.getResultSet();
                while (resultSet.next()) {
                    n3 = resultSet.getInt(1);
                    int n4 = resultSet.getInt(2);
                    int n5 = resultSet.getInt(3);
                    byte[] byArray = resultSet.getBytes(4);
                    byte[] byArray2 = new byte[n4];
                    byte[] byArray3 = new byte[n5];
                    if (byArray.length != n4 + n5) {
                        throw new XAOSQLException("Error while recovering XIDs from RM. GTRID and BQUAL are wrong ");
                    }
                    System.arraycopy(byArray, 0, byArray2, 0, n4);
                    System.arraycopy(byArray, n4, byArray3, 0, n5);
                    arrayList.add(new OscarXid(byArray2, byArray3, n3));
                }
                if (resultSet == null) break block18;
            }
            catch (SQLException sQLException) {
                try {
                    SQLException sQLException2 = sQLException;
                    sQLException.printStackTrace();
                    throw new XAOSQLException(sQLException2.getMessage());
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException2) {}
                    }
                    if (statement == null) throw throwable;
                    try {
                        statement.close();
                        throw throwable;
                    }
                    catch (SQLException sQLException3) {}
                    throw throwable;
                }
            }
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {}
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
        n3 = arrayList.size();
        Xid[] xidArray = new Xid[n3];
        Object[] objectArray = arrayList.toArray();
        int i2 = 0;
        while (i2 < n3) {
            xidArray[i2] = (Xid)objectArray[i2];
            ++i2;
        }
        return xidArray;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("XA ROLLBACK ");
        Jdbc3XAConnection.appendXid(stringBuilder, xid);
        try {
            this.executeXA(stringBuilder.toString());
            return;
        }
        catch (SQLException sQLException) {
            throw new XAOSQLException(sQLException.getMessage());
        }
    }

    @Override
    public boolean setTransactionTimeout(int n2) throws XAException {
        return false;
    }

    @Override
    public void start(Xid xid, int n2) throws XAException {
        if (xid == null) {
            throw new XAOSQLException("xid must not be null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("XA START ");
        Jdbc3XAConnection.appendXid(stringBuilder, xid);
        switch (n2) {
            case 0x8000000: {
                stringBuilder.append(" RESUME");
                break;
            }
            case 0x200000: {
                stringBuilder.append(" JOIN");
            }
        }
        if (this.state == 1) {
            throw new XAOSQLException("Connection is busy with another transaction");
        }
        try {
            this.executeXA(stringBuilder.toString());
        }
        catch (SQLException sQLException) {
            throw new XAOSQLException(sQLException.getMessage());
        }
        this.state = 1;
        this.currentXid = xid;
    }

    private static void appendXid(StringBuilder stringBuilder, Xid xid) {
        byte[] byArray = xid.getGlobalTransactionId();
        byte[] byArray2 = xid.getBranchQualifier();
        if (byArray != null) {
            StringUtils.appendAsHex(stringBuilder, byArray);
        }
        stringBuilder.append(',');
        if (byArray2 != null) {
            StringUtils.appendAsHex(stringBuilder, byArray2);
        }
        stringBuilder.append(',');
        StringUtils.appendAsHex(stringBuilder, xid.getFormatId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeXA(String string) throws SQLException {
        Statement statement = null;
        try {
            statement = this.conn.createStatement();
            statement.execute(string);
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
    }
}

