package com.shinitech.djammadev.modules;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import org.apache.log4j.Logger;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

import java.lang.reflect.Constructor;
import java.util.List;

/**
 * Created by sissoko on 03/11/2017.
 */
public final class DjammaModule extends AbstractBinder {
    private static final Logger LOGGER = Logger.getLogger(DjammaModule.class);

    private static final DjammaModule instance = new DjammaModule();

    public static DjammaModule getInstance() {
        return instance;
    }

    private DjammaModule() {
    }

    @Override
    protected void configure() {
        final Config config = ConfigFactory.load();
        bind(config).to(Config.class);
        if (config.hasPath("djamma.modules.enabled")) {
            List<String> moduleClasses = config.getStringList("djamma.modules.enabled");
            moduleClasses.forEach(className -> {
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                    if (Binder.class.isAssignableFrom(clazz)) {
                        Constructor<?> constructor;
                        Constructor<?>[] constructors = clazz.getConstructors();
                        boolean hasConfig = false;
                        for (Constructor<?> constructor1 : constructors) {
                            constructor = constructor1;
                            if (constructor.getParameterCount() == 1 && Config.class.isAssignableFrom(constructor.getParameterTypes()[0])) {
                                hasConfig = true;
                                break;
                            }
                        }
                        Binder binder = (Binder) (hasConfig ? clazz.getConstructor(Config.class).newInstance(config) : clazz.getConstructor().newInstance());
                        install(binder);
                    }
                } catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
            });
        }
    }
}
