/*
 * Decompiled with CFR 0.152.
 */
package com.shinitech.djammadev.modules;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.lang.reflect.Constructor;
import java.util.List;
import org.apache.log4j.Logger;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public final class DjammaModule
extends AbstractBinder {
    private static final Logger LOGGER = Logger.getLogger(DjammaModule.class);
    private static final DjammaModule instance = new DjammaModule();

    public static DjammaModule getInstance() {
        return instance;
    }

    private DjammaModule() {
    }

    protected void configure() {
        Config config = ConfigFactory.load();
        this.bind(config).to(Config.class);
        if (config.hasPath("djamma.modules.enabled")) {
            List moduleClasses = config.getStringList("djamma.modules.enabled");
            moduleClasses.forEach(className -> {
                try {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass((String)className);
                    if (Binder.class.isAssignableFrom(clazz)) {
                        Constructor<?>[] constructors = clazz.getConstructors();
                        boolean hasConfig = false;
                        for (Constructor<?> constructor1 : constructors) {
                            Constructor<?> constructor = constructor1;
                            if (constructor.getParameterCount() != 1 || !Config.class.isAssignableFrom(constructor.getParameterTypes()[0])) continue;
                            hasConfig = true;
                            break;
                        }
                        Binder binder = (Binder)(hasConfig ? clazz.getConstructor(Config.class).newInstance(config) : clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                        this.install(new Binder[]{binder});
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getMessage());
                }
            });
        }
    }
}

