/*
 * Decompiled with CFR 0.152.
 */
package com.shocknode.utilities;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Lambdas {
    public static <E extends Exception> Runnable runWithException(RunnableWithException<E> runnable) throws E {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                Lambdas.toss(exception);
            }
        };
    }

    public static <T, R, E extends Exception> Function<T, R> applyWithException(FunctionWithException<T, R, E> function) throws E {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                Lambdas.toss(exception);
                return null;
            }
        };
    }

    public static <T, E extends Exception> Consumer<T> consumeWithException(ConsumerWithException<T, E> consumer) throws E {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception exception) {
                Lambdas.toss(exception);
            }
        };
    }

    public static <T, U, E extends Exception> BiConsumer<T, U> consumeBothWithException(BiConsumerWithException<T, U, E> consumer) throws E {
        return (t, u) -> {
            try {
                consumer.accept(t, u);
            }
            catch (Exception exception) {
                Lambdas.toss(exception);
            }
        };
    }

    public static <T, E extends Exception> Supplier<T> supplyWithException(SupplierWithException<T, E> supplier) throws E {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception exception) {
                Lambdas.toss(exception);
                return null;
            }
        };
    }

    private static <E extends Exception> void toss(Exception exception) throws E {
        throw exception;
    }

    @FunctionalInterface
    public static interface SupplierWithException<T, E extends Exception> {
        public T get() throws E;
    }

    @FunctionalInterface
    public static interface BiConsumerWithException<T, U, E extends Exception> {
        public void accept(T var1, U var2) throws E;
    }

    @FunctionalInterface
    public static interface ConsumerWithException<T, E extends Exception> {
        public void accept(T var1) throws E;
    }

    @FunctionalInterface
    public static interface FunctionWithException<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface RunnableWithException<E extends Exception> {
        public void run() throws E;
    }
}

