/*
 * Decompiled with CFR 0.152.
 */
package com.shocknode.utilities.reflection;

import com.shocknode.utilities.Lambdas;
import com.shocknode.utilities.Strings;
import com.shocknode.utilities.reflection.NullNotSupportedException;
import com.shocknode.utilities.reflection.Parameter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class Reflection {
    public static <T> T runGetter(Object object, String fieldName, Class<T> fieldClass) throws IllegalAccessException, InvocationTargetException, NullNotSupportedException, NoSuchFieldException, NoSuchMethodException {
        if (object == null) {
            throw new NullNotSupportedException();
        }
        String name = Reflection.isTypeOfAny(Reflection.getField(object, fieldName), "boolean", "java.lang.Boolean") ? String.format("is%s", Strings.capitalize(fieldName)) : String.format("get%s", Strings.capitalize(fieldName));
        Method method = Reflection.getMethod(object.getClass(), name, new Class[0]);
        Object value = method.invoke(object, new Object[0]);
        if (fieldClass.isInstance(value)) {
            return (T)value;
        }
        throw new NoSuchMethodException(fieldName);
    }

    public static <T> T instanceOf(Class<T> objectClass, Parameter ... parameters) throws InstantiationException, IllegalAccessException, InvocationTargetException, NullNotSupportedException {
        if (objectClass == null) {
            throw new NullNotSupportedException();
        }
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                if (parameter.getParameterClass() != null && parameter.getValue() != null) continue;
                throw new NullNotSupportedException();
            }
            Constructor<T> constructor = Reflection.getConstructor(objectClass, Arrays.stream(parameters).map(Parameter::getParameterClass).collect(Collectors.toList()).toArray(new Class[0]));
            return constructor.newInstance(Arrays.stream(parameters).map(Parameter::getValue).toArray());
        }
        Constructor<T> constructor = Reflection.getConstructor(objectClass, new Class[0]);
        return constructor.newInstance(new Object[0]);
    }

    public static <T> boolean isInstanceOf(T object, Class<?> ... classes) {
        return Reflection.isInstanceOf(object.getClass(), classes);
    }

    public static boolean isInstanceOf(Class<?> clazz, Class<?> ... classes) {
        for (Class<?> superclass : classes) {
            if (clazz == null && superclass == null) {
                return true;
            }
            if (superclass == null || clazz == null) {
                return false;
            }
            if (superclass.isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isInstanceOfAny(T object, Class<?> ... classes) {
        return Reflection.isInstanceOfAny(object.getClass(), classes);
    }

    public static boolean isInstanceOfAny(Class<?> clazz, Class<?> ... classes) {
        for (Class<?> superclass : classes) {
            if (clazz == null && superclass == null) {
                return true;
            }
            if (superclass == null || clazz == null) {
                return false;
            }
            if (!superclass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static Object run(Object object, String name, Parameter ... parameters) throws Exception {
        if (object == null) {
            return null;
        }
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                if (parameter.getParameterClass() != null && parameter.getValue() != null) continue;
                throw new NullNotSupportedException();
            }
            Method method = Reflection.getMethod(object.getClass(), name, Arrays.stream(parameters).map(Parameter::getParameterClass).collect(Collectors.toList()).toArray(new Class[0]));
            return method.invoke(object, Arrays.stream(parameters).map(Parameter::getValue).toArray());
        }
        Method method = Reflection.getMethod(object.getClass(), name, new Class[0]);
        return method.invoke(object, new Object[0]);
    }

    public static void runSetter(Object object, String fieldName, Parameter<?> parameter) throws NullNotSupportedException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (object == null) {
            return;
        }
        String name = String.format("set%s", Strings.capitalize(fieldName));
        Method method = Reflection.getMethod(object.getClass(), name, parameter.getParameterClass());
        method.invoke(object, parameter.getValue());
    }

    public static void runSetter(Object object, String fieldName, Object value) throws NullNotSupportedException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Reflection.runSetter(object, fieldName, Parameter.from(value.getClass(), value));
    }

    public static boolean isTypeOfAny(Field field, String ... types) {
        if (field == null) {
            return false;
        }
        for (String type : types) {
            if (!field.getType().getTypeName().equals(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isType(Field field, String ... types) {
        if (field == null) {
            return false;
        }
        for (String type : types) {
            if (field.getType().getTypeName().equals(type)) continue;
            return false;
        }
        return true;
    }

    public static String getName(Field field) {
        if (field == null) {
            return "";
        }
        return field.getName();
    }

    public static String getType(Field field) {
        if (field == null) {
            return "";
        }
        return field.getType().getTypeName();
    }

    public static String getType(Object value) {
        if (value == null) {
            return "";
        }
        return value.getClass().getTypeName();
    }

    public static Field getField(Object object, String name) throws NullNotSupportedException, NoSuchFieldException {
        if (object == null) {
            throw new NullNotSupportedException();
        }
        for (Field field : Reflection.getHierarchyFields(object.getClass(), Object.class)) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        throw new NoSuchFieldException();
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameters) throws NullNotSupportedException, NoSuchMethodException {
        if (clazz == null) {
            return null;
        }
        for (Class<?> parameter : parameters) {
            if (parameter != null) continue;
            throw new NullNotSupportedException();
        }
        try {
            return clazz.getDeclaredMethod(name, parameters);
        }
        catch (NoSuchMethodException e) {
            Class<?> parent = clazz.getSuperclass();
            if (parent == null) {
                throw e;
            }
            return Reflection.getMethod(parent, name, parameters);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameters) {
        if (clazz == null) {
            return null;
        }
        for (Class<?> parameter : parameters) {
            if (parameter != null) continue;
            return null;
        }
        try {
            return clazz.getDeclaredConstructor(parameters);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static List<Field> getHierarchyFields(Class<?> start, Class<?> end) {
        if (start == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        Class<?> parent = start.getSuperclass();
        if (parent != null && !parent.equals(Object.class) && !parent.equals(end)) {
            fields.addAll(Reflection.getHierarchyFields(parent, end));
        }
        fields.addAll(Arrays.asList(start.getDeclaredFields()));
        return fields;
    }

    public static List<Field> getHierarchyFields(Class<?> start) {
        if (start == null) {
            return Collections.emptyList();
        }
        return Reflection.getHierarchyFields(start, null);
    }

    public static List<Field> getHierarchyFields(Object start) {
        if (start == null) {
            return Collections.emptyList();
        }
        return Reflection.getHierarchyFields(start.getClass(), null);
    }

    public static List<Field> getHierarchyFields(Object start, Class<?> end) {
        if (start == null) {
            return Collections.emptyList();
        }
        return Reflection.getHierarchyFields(start.getClass(), end);
    }

    public static List<Method> getHierarchyMethods(Class<?> start, Class<?> end) {
        if (start == null) {
            return Collections.emptyList();
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        Class<?> parent = start.getSuperclass();
        if (parent != null && !parent.equals(end)) {
            methods.addAll(Reflection.getHierarchyMethods(parent, end));
        }
        methods.addAll(Arrays.asList(start.getDeclaredMethods()));
        return methods;
    }

    public static List<Method> getHierarchyMethods(Class<?> start) {
        if (start == null) {
            return Collections.emptyList();
        }
        return Reflection.getHierarchyMethods(start, null);
    }

    public static List<Method> getHierarchyMethods(Object start) {
        if (start == null) {
            return Collections.emptyList();
        }
        return Reflection.getHierarchyMethods(start.getClass(), null);
    }

    public static List<Method> getHierarchyMethods(Object start, Class<?> end) {
        if (start == null) {
            return Collections.emptyList();
        }
        return Reflection.getHierarchyMethods(start.getClass(), end);
    }

    public static List<Constructor> getHierarchyConstructors(Class<?> start, Class<?> end) {
        if (start == null) {
            return Collections.emptyList();
        }
        ArrayList<Constructor> constructors = new ArrayList<Constructor>();
        if (end != null) {
            Class<?> parent = start.getSuperclass();
            if (parent != null) {
                if (parent.equals(end)) {
                    end = null;
                }
                constructors.addAll(Reflection.getHierarchyConstructors(parent, end));
            }
        } else {
            constructors.addAll(Arrays.asList(start.getDeclaredConstructors()));
        }
        return constructors;
    }

    public static List<Constructor> getHierarchyConstructors(Class<?> start) {
        if (start == null) {
            return Collections.emptyList();
        }
        return Reflection.getHierarchyConstructors(start, null);
    }

    public static List<Constructor> getHierarchyConstructors(Object start) {
        if (start == null) {
            return Collections.emptyList();
        }
        return Reflection.getHierarchyConstructors(start.getClass(), null);
    }

    public static List<Constructor> getHierarchyConstructors(Object start, Class<?> end) {
        if (start == null) {
            return Collections.emptyList();
        }
        return Reflection.getHierarchyConstructors(start.getClass(), end);
    }

    public static Class<?> getListClass(Object object, String name) throws Exception {
        System.out.println(object.getClass());
        Field listField = Reflection.getField(object, name);
        if (!listField.getType().equals(List.class)) {
            System.out.println("1");
            throw new Exception("Not a list!");
        }
        ParameterizedType listType = (ParameterizedType)listField.getGenericType();
        Type[] classes = listType.getActualTypeArguments();
        if (classes.length > 0) {
            return (Class)classes[0];
        }
        throw new Exception("No type parameter of list!!");
    }

    public static <T> List<T> getList(Object object, String name, Class<T> listTypeClass) throws Exception {
        Reflection.getListClass(object, name);
        Field field = Reflection.getField(object, name);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        List list = (List)field.get(object);
        field.setAccessible(accessible);
        return list;
    }

    public static <T> T get(Object object, String name, Class<T> typeClass) throws Exception {
        Field field = Reflection.getField(object, name);
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        Object fieldValue = field.get(object);
        field.setAccessible(accessible);
        return (T)fieldValue;
    }

    public static <T> List<List<T>> getHierarchyFieldListsOfClassType(Object object, Class<T> typeClass) throws Exception {
        return Reflection.getHierarchyFields(object).stream().filter(field -> field.getType().equals(List.class)).map(Field::getName).map(Lambdas.applyWithException(name -> Reflection.getList(object, name, typeClass))).collect(Collectors.toList());
    }

    public static <T> List<T> getHierarchyFieldValuesOfClassType(Object object, Class<T> typeClass) throws Exception {
        return Reflection.getHierarchyFields(object).stream().filter(field -> field.getType().equals(typeClass)).map(Lambdas.applyWithException(field -> field.get(object))).collect(Collectors.toList());
    }

    private static void whileAccessible(Field field, Consumer<Field> consumer) throws Exception {
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        consumer.accept(field);
        field.setAccessible(accessible);
    }
}

