// Generated from graphql_java_gen gem

package com.shopify.buy3;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shopify.graphql.support.AbstractResponse;
import com.shopify.graphql.support.Arguments;
import com.shopify.graphql.support.Directive;
import com.shopify.graphql.support.Error;
import com.shopify.graphql.support.Query;
import com.shopify.graphql.support.SchemaViolationError;
import com.shopify.graphql.support.TopLevelResponse;
import com.shopify.graphql.support.Input;

import com.shopify.graphql.support.ID;

import java.math.BigDecimal;

import org.joda.time.DateTime;

import java.io.Serializable;
import java.util.*;

public class Storefront {
    public static final String API_VERSION = "2024-07";

    public static QueryRootQuery query(QueryRootQueryDefinition queryDef) {
        return query(Collections.emptyList(), queryDef);
    }

    public static QueryRootQuery query(List<Directive> directives, QueryRootQueryDefinition queryDef) {
        StringBuilder queryString = new StringBuilder("query");
        for (Directive directive : directives) {
            queryString.append(" " + directive.toString());
        }
        queryString.append(" {");
        QueryRootQuery query = new QueryRootQuery(queryString);
        queryDef.define(query);
        queryString.append('}');
        return query;
    }

    public static class QueryResponse {
        private TopLevelResponse response;
        private QueryRoot data;

        public QueryResponse(TopLevelResponse response) throws SchemaViolationError {
            this.response = response;
            this.data = response.getData() != null ? new QueryRoot(response.getData()) : null;
        }

        public QueryRoot getData() {
            return data;
        }

        public List<Error> getErrors() {
            return response.getErrors();
        }

        public String toJson() {
            return new Gson().toJson(response);
        }

        public String prettyPrintJson() {
            final Gson gson = new GsonBuilder().setPrettyPrinting().create();
            return gson.toJson(response);
        }

        public static QueryResponse fromJson(String json) throws SchemaViolationError {
            final TopLevelResponse response = new Gson().fromJson(json, TopLevelResponse.class);
            return new QueryResponse(response);
        }
    }

    public static MutationQuery mutation(MutationQueryDefinition queryDef) {
        return mutation(Collections.emptyList(), queryDef);
    }

    public static MutationQuery mutation(List<Directive> directives, MutationQueryDefinition queryDef) {
        StringBuilder queryString = new StringBuilder("mutation");
        for (Directive directive : directives) {
            queryString.append(" " + directive.toString());
        }
        queryString.append(" {");
        MutationQuery query = new MutationQuery(queryString);
        queryDef.define(query);
        queryString.append('}');
        return query;
    }

    public static class MutationResponse {
        private TopLevelResponse response;
        private Mutation data;

        public MutationResponse(TopLevelResponse response) throws SchemaViolationError {
            this.response = response;
            this.data = response.getData() != null ? new Mutation(response.getData()) : null;
        }

        public Mutation getData() {
            return data;
        }

        public List<Error> getErrors() {
            return response.getErrors();
        }

        public String toJson() {
            return new Gson().toJson(response);
        }

        public String prettyPrintJson() {
            final Gson gson = new GsonBuilder().setPrettyPrinting().create();
            return gson.toJson(response);
        }

        public static MutationResponse fromJson(String json) throws SchemaViolationError {
            final TopLevelResponse response = new Gson().fromJson(json, TopLevelResponse.class);
            return new MutationResponse(response);
        }
    }

    /**
    * Contextualizes data based on the additional information provided by the directive. For example, you
    * can use the `@inContext(country: CA)` directive to [query a product's
    * price](https://shopify.dev/custom-storefronts/internationalization/international-pricing) in a
    * storefront within the context of Canada.
    */
    public static class InContextDirective extends Directive {
        public CountryCode country;

        public LanguageCode language;

        public ID preferredLocationId;

        public BuyerInput buyer;

        public InContextDirective() {
            super("inContext");
        }

        @Override
        public String toString() {
            StringBuilder _queryBuilder = new StringBuilder(super.toString());
            _queryBuilder.append("(");

            if (country != null) {
                _queryBuilder.append("country:");
                _queryBuilder.append(country.toString());
            }

            if (language != null) {
                _queryBuilder.append(", ");
                _queryBuilder.append("language:");
                _queryBuilder.append(language.toString());
            }

            if (preferredLocationId != null) {
                _queryBuilder.append(", ");
                _queryBuilder.append("preferredLocationId:");
                Query.appendQuotedString(_queryBuilder, preferredLocationId.toString());
            }

            if (buyer != null) {
                _queryBuilder.append(", ");
                _queryBuilder.append("buyer:");
                buyer.appendTo(_queryBuilder);
            }

            _queryBuilder.append(")");
            return _queryBuilder.toString();
        }
    }

    public interface ApiVersionQueryDefinition {
        void define(ApiVersionQuery _queryBuilder);
    }

    /**
    * A version of the API, as defined by [Shopify API
    * versioning](https://shopify.dev/api/usage/versioning).
    * Versions are commonly referred to by their handle (for example, `2021-10`).
    */
    public static class ApiVersionQuery extends Query<ApiVersionQuery> {
        ApiVersionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The human-readable name of the version.
        */
        public ApiVersionQuery displayName() {
            startField("displayName");

            return this;
        }

        /**
        * The unique identifier of an ApiVersion. All supported API versions have a date-based (YYYY-MM) or
        * `unstable` handle.
        */
        public ApiVersionQuery handle() {
            startField("handle");

            return this;
        }

        /**
        * Whether the version is actively supported by Shopify. Supported API versions are guaranteed to be
        * stable. Unsupported API versions include unstable, release candidate, and end-of-life versions that
        * are marked as unsupported. For more information, refer to
        * [Versioning](https://shopify.dev/api/usage/versioning).
        */
        public ApiVersionQuery supported() {
            startField("supported");

            return this;
        }
    }

    /**
    * A version of the API, as defined by [Shopify API
    * versioning](https://shopify.dev/api/usage/versioning).
    * Versions are commonly referred to by their handle (for example, `2021-10`).
    */
    public static class ApiVersion extends AbstractResponse<ApiVersion> {
        public ApiVersion() {
        }

        public ApiVersion(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "displayName": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "handle": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "supported": {
                        responseData.put(key, jsonAsBoolean(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "ApiVersion";
        }

        /**
        * The human-readable name of the version.
        */

        public String getDisplayName() {
            return (String) get("displayName");
        }

        public ApiVersion setDisplayName(String arg) {
            optimisticData.put(getKey("displayName"), arg);
            return this;
        }

        /**
        * The unique identifier of an ApiVersion. All supported API versions have a date-based (YYYY-MM) or
        * `unstable` handle.
        */

        public String getHandle() {
            return (String) get("handle");
        }

        public ApiVersion setHandle(String arg) {
            optimisticData.put(getKey("handle"), arg);
            return this;
        }

        /**
        * Whether the version is actively supported by Shopify. Supported API versions are guaranteed to be
        * stable. Unsupported API versions include unstable, release candidate, and end-of-life versions that
        * are marked as unsupported. For more information, refer to
        * [Versioning](https://shopify.dev/api/usage/versioning).
        */

        public Boolean getSupported() {
            return (Boolean) get("supported");
        }

        public ApiVersion setSupported(Boolean arg) {
            optimisticData.put(getKey("supported"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "displayName": return false;

                case "handle": return false;

                case "supported": return false;

                default: return false;
            }
        }
    }

    public static class ApplePayWalletContentInput implements Serializable {
        private MailingAddressInput billingAddress;

        private String data;

        private ApplePayWalletHeaderInput header;

        private String signature;

        private String version;

        private Input<String> lastDigits = Input.undefined();

        public ApplePayWalletContentInput(MailingAddressInput billingAddress, String data, ApplePayWalletHeaderInput header, String signature, String version) {
            this.billingAddress = billingAddress;

            this.data = data;

            this.header = header;

            this.signature = signature;

            this.version = version;
        }

        public MailingAddressInput getBillingAddress() {
            return billingAddress;
        }

        public ApplePayWalletContentInput setBillingAddress(MailingAddressInput billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public String getData() {
            return data;
        }

        public ApplePayWalletContentInput setData(String data) {
            this.data = data;
            return this;
        }

        public ApplePayWalletHeaderInput getHeader() {
            return header;
        }

        public ApplePayWalletContentInput setHeader(ApplePayWalletHeaderInput header) {
            this.header = header;
            return this;
        }

        public String getSignature() {
            return signature;
        }

        public ApplePayWalletContentInput setSignature(String signature) {
            this.signature = signature;
            return this;
        }

        public String getVersion() {
            return version;
        }

        public ApplePayWalletContentInput setVersion(String version) {
            this.version = version;
            return this;
        }

        public String getLastDigits() {
            return lastDigits.getValue();
        }

        public Input<String> getLastDigitsInput() {
            return lastDigits;
        }

        public ApplePayWalletContentInput setLastDigits(String lastDigits) {
            this.lastDigits = Input.optional(lastDigits);
            return this;
        }

        public ApplePayWalletContentInput setLastDigitsInput(Input<String> lastDigits) {
            if (lastDigits == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.lastDigits = lastDigits;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("billingAddress:");
            billingAddress.appendTo(_queryBuilder);

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("data:");
            Query.appendQuotedString(_queryBuilder, data.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("header:");
            header.appendTo(_queryBuilder);

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("signature:");
            Query.appendQuotedString(_queryBuilder, signature.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("version:");
            Query.appendQuotedString(_queryBuilder, version.toString());

            if (this.lastDigits.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("lastDigits:");
                if (lastDigits.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, lastDigits.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    public static class ApplePayWalletHeaderInput implements Serializable {
        private String ephemeralPublicKey;

        private String publicKeyHash;

        private String transactionId;

        private Input<String> applicationData = Input.undefined();

        public ApplePayWalletHeaderInput(String ephemeralPublicKey, String publicKeyHash, String transactionId) {
            this.ephemeralPublicKey = ephemeralPublicKey;

            this.publicKeyHash = publicKeyHash;

            this.transactionId = transactionId;
        }

        public String getEphemeralPublicKey() {
            return ephemeralPublicKey;
        }

        public ApplePayWalletHeaderInput setEphemeralPublicKey(String ephemeralPublicKey) {
            this.ephemeralPublicKey = ephemeralPublicKey;
            return this;
        }

        public String getPublicKeyHash() {
            return publicKeyHash;
        }

        public ApplePayWalletHeaderInput setPublicKeyHash(String publicKeyHash) {
            this.publicKeyHash = publicKeyHash;
            return this;
        }

        public String getTransactionId() {
            return transactionId;
        }

        public ApplePayWalletHeaderInput setTransactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public String getApplicationData() {
            return applicationData.getValue();
        }

        public Input<String> getApplicationDataInput() {
            return applicationData;
        }

        public ApplePayWalletHeaderInput setApplicationData(String applicationData) {
            this.applicationData = Input.optional(applicationData);
            return this;
        }

        public ApplePayWalletHeaderInput setApplicationDataInput(Input<String> applicationData) {
            if (applicationData == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.applicationData = applicationData;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("ephemeralPublicKey:");
            Query.appendQuotedString(_queryBuilder, ephemeralPublicKey.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("publicKeyHash:");
            Query.appendQuotedString(_queryBuilder, publicKeyHash.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("transactionId:");
            Query.appendQuotedString(_queryBuilder, transactionId.toString());

            if (this.applicationData.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("applicationData:");
                if (applicationData.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, applicationData.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    public interface AppliedGiftCardQueryDefinition {
        void define(AppliedGiftCardQuery _queryBuilder);
    }

    /**
    * Details about the gift card used on the checkout.
    */
    public static class AppliedGiftCardQuery extends Query<AppliedGiftCardQuery> {
        AppliedGiftCardQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("id");
        }

        /**
        * The amount that was taken from the gift card by applying it.
        */
        public AppliedGiftCardQuery amountUsed(MoneyV2QueryDefinition queryDef) {
            startField("amountUsed");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The amount that was taken from the gift card by applying it.
        *
        * @deprecated Use `amountUsed` instead.
        */
        @Deprecated
        public AppliedGiftCardQuery amountUsedV2(MoneyV2QueryDefinition queryDef) {
            startField("amountUsedV2");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The amount left on the gift card.
        */
        public AppliedGiftCardQuery balance(MoneyV2QueryDefinition queryDef) {
            startField("balance");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The amount left on the gift card.
        *
        * @deprecated Use `balance` instead.
        */
        @Deprecated
        public AppliedGiftCardQuery balanceV2(MoneyV2QueryDefinition queryDef) {
            startField("balanceV2");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The last characters of the gift card.
        */
        public AppliedGiftCardQuery lastCharacters() {
            startField("lastCharacters");

            return this;
        }

        /**
        * The amount that was applied to the checkout in its currency.
        */
        public AppliedGiftCardQuery presentmentAmountUsed(MoneyV2QueryDefinition queryDef) {
            startField("presentmentAmountUsed");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Details about the gift card used on the checkout.
    */
    public static class AppliedGiftCard extends AbstractResponse<AppliedGiftCard> implements Node {
        public AppliedGiftCard() {
        }

        public AppliedGiftCard(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "amountUsed": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "amountUsedV2": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "balance": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "balanceV2": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "lastCharacters": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "presentmentAmountUsed": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public AppliedGiftCard(ID id) {
            this();
            optimisticData.put("id", id);
        }

        public String getGraphQlTypeName() {
            return "AppliedGiftCard";
        }

        /**
        * The amount that was taken from the gift card by applying it.
        */

        public MoneyV2 getAmountUsed() {
            return (MoneyV2) get("amountUsed");
        }

        public AppliedGiftCard setAmountUsed(MoneyV2 arg) {
            optimisticData.put(getKey("amountUsed"), arg);
            return this;
        }

        /**
        * The amount that was taken from the gift card by applying it.
        *
        * @deprecated Use `amountUsed` instead.
        */

        public MoneyV2 getAmountUsedV2() {
            return (MoneyV2) get("amountUsedV2");
        }

        public AppliedGiftCard setAmountUsedV2(MoneyV2 arg) {
            optimisticData.put(getKey("amountUsedV2"), arg);
            return this;
        }

        /**
        * The amount left on the gift card.
        */

        public MoneyV2 getBalance() {
            return (MoneyV2) get("balance");
        }

        public AppliedGiftCard setBalance(MoneyV2 arg) {
            optimisticData.put(getKey("balance"), arg);
            return this;
        }

        /**
        * The amount left on the gift card.
        *
        * @deprecated Use `balance` instead.
        */

        public MoneyV2 getBalanceV2() {
            return (MoneyV2) get("balanceV2");
        }

        public AppliedGiftCard setBalanceV2(MoneyV2 arg) {
            optimisticData.put(getKey("balanceV2"), arg);
            return this;
        }

        /**
        * A globally-unique ID.
        */

        public ID getId() {
            return (ID) get("id");
        }

        /**
        * The last characters of the gift card.
        */

        public String getLastCharacters() {
            return (String) get("lastCharacters");
        }

        public AppliedGiftCard setLastCharacters(String arg) {
            optimisticData.put(getKey("lastCharacters"), arg);
            return this;
        }

        /**
        * The amount that was applied to the checkout in its currency.
        */

        public MoneyV2 getPresentmentAmountUsed() {
            return (MoneyV2) get("presentmentAmountUsed");
        }

        public AppliedGiftCard setPresentmentAmountUsed(MoneyV2 arg) {
            optimisticData.put(getKey("presentmentAmountUsed"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "amountUsed": return true;

                case "amountUsedV2": return true;

                case "balance": return true;

                case "balanceV2": return true;

                case "id": return false;

                case "lastCharacters": return false;

                case "presentmentAmountUsed": return true;

                default: return false;
            }
        }
    }

    public interface ArticleQueryDefinition {
        void define(ArticleQuery _queryBuilder);
    }

    /**
    * An article in an online store blog.
    */
    public static class ArticleQuery extends Query<ArticleQuery> {
        ArticleQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("id");
        }

        /**
        * The article's author.
        *
        * @deprecated Use `authorV2` instead.
        */
        @Deprecated
        public ArticleQuery author(ArticleAuthorQueryDefinition queryDef) {
            startField("author");

            _queryBuilder.append('{');
            queryDef.define(new ArticleAuthorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The article's author.
        */
        public ArticleQuery authorV2(ArticleAuthorQueryDefinition queryDef) {
            startField("authorV2");

            _queryBuilder.append('{');
            queryDef.define(new ArticleAuthorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The blog that the article belongs to.
        */
        public ArticleQuery blog(BlogQueryDefinition queryDef) {
            startField("blog");

            _queryBuilder.append('{');
            queryDef.define(new BlogQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        public class CommentsArguments extends Arguments {
            CommentsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * Returns up to the first `n` elements from the list.
            */
            public CommentsArguments first(Integer value) {
                if (value != null) {
                    startArgument("first");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come after the specified cursor.
            */
            public CommentsArguments after(String value) {
                if (value != null) {
                    startArgument("after");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Returns up to the last `n` elements from the list.
            */
            public CommentsArguments last(Integer value) {
                if (value != null) {
                    startArgument("last");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come before the specified cursor.
            */
            public CommentsArguments before(String value) {
                if (value != null) {
                    startArgument("before");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Reverse the order of the underlying list.
            */
            public CommentsArguments reverse(Boolean value) {
                if (value != null) {
                    startArgument("reverse");
                    _queryBuilder.append(value);
                }
                return this;
            }
        }

        public interface CommentsArgumentsDefinition {
            void define(CommentsArguments args);
        }

        /**
        * List of comments posted on the article.
        */
        public ArticleQuery comments(CommentConnectionQueryDefinition queryDef) {
            return comments(args -> {}, queryDef);
        }

        /**
        * List of comments posted on the article.
        */
        public ArticleQuery comments(CommentsArgumentsDefinition argsDef, CommentConnectionQueryDefinition queryDef) {
            startField("comments");

            CommentsArguments args = new CommentsArguments(_queryBuilder);
            argsDef.define(args);
            CommentsArguments.end(args);

            _queryBuilder.append('{');
            queryDef.define(new CommentConnectionQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        public class ContentArguments extends Arguments {
            ContentArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * Truncates string after the given length.
            */
            public ContentArguments truncateAt(Integer value) {
                if (value != null) {
                    startArgument("truncateAt");
                    _queryBuilder.append(value);
                }
                return this;
            }
        }

        public interface ContentArgumentsDefinition {
            void define(ContentArguments args);
        }

        /**
        * Stripped content of the article, single line with HTML tags removed.
        */
        public ArticleQuery content() {
            return content(args -> {});
        }

        /**
        * Stripped content of the article, single line with HTML tags removed.
        */
        public ArticleQuery content(ContentArgumentsDefinition argsDef) {
            startField("content");

            ContentArguments args = new ContentArguments(_queryBuilder);
            argsDef.define(args);
            ContentArguments.end(args);

            return this;
        }

        /**
        * The content of the article, complete with HTML formatting.
        */
        public ArticleQuery contentHtml() {
            startField("contentHtml");

            return this;
        }

        public class ExcerptArguments extends Arguments {
            ExcerptArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * Truncates string after the given length.
            */
            public ExcerptArguments truncateAt(Integer value) {
                if (value != null) {
                    startArgument("truncateAt");
                    _queryBuilder.append(value);
                }
                return this;
            }
        }

        public interface ExcerptArgumentsDefinition {
            void define(ExcerptArguments args);
        }

        /**
        * Stripped excerpt of the article, single line with HTML tags removed.
        */
        public ArticleQuery excerpt() {
            return excerpt(args -> {});
        }

        /**
        * Stripped excerpt of the article, single line with HTML tags removed.
        */
        public ArticleQuery excerpt(ExcerptArgumentsDefinition argsDef) {
            startField("excerpt");

            ExcerptArguments args = new ExcerptArguments(_queryBuilder);
            argsDef.define(args);
            ExcerptArguments.end(args);

            return this;
        }

        /**
        * The excerpt of the article, complete with HTML formatting.
        */
        public ArticleQuery excerptHtml() {
            startField("excerptHtml");

            return this;
        }

        /**
        * A human-friendly unique string for the Article automatically generated from its title.
        */
        public ArticleQuery handle() {
            startField("handle");

            return this;
        }

        /**
        * The image associated with the article.
        */
        public ArticleQuery image(ImageQueryDefinition queryDef) {
            startField("image");

            _queryBuilder.append('{');
            queryDef.define(new ImageQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        public class MetafieldArguments extends Arguments {
            MetafieldArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            /**
            * The container the metafield belongs to. If omitted, the app-reserved namespace will be used.
            */
            public MetafieldArguments namespace(String value) {
                if (value != null) {
                    startArgument("namespace");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }
        }

        public interface MetafieldArgumentsDefinition {
            void define(MetafieldArguments args);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public ArticleQuery metafield(String key, MetafieldQueryDefinition queryDef) {
            return metafield(key, args -> {}, queryDef);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public ArticleQuery metafield(String key, MetafieldArgumentsDefinition argsDef, MetafieldQueryDefinition queryDef) {
            startField("metafield");

            _queryBuilder.append("(key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            argsDef.define(new MetafieldArguments(_queryBuilder));

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */
        public ArticleQuery metafields(List<HasMetafieldsIdentifier> identifiers, MetafieldQueryDefinition queryDef) {
            startField("metafields");

            _queryBuilder.append("(identifiers:");
            _queryBuilder.append('[');
            {
                String listSeperator1 = "";
                for (HasMetafieldsIdentifier item1 : identifiers) {
                    _queryBuilder.append(listSeperator1);
                    listSeperator1 = ",";
                    item1.appendTo(_queryBuilder);
                }
            }
            _queryBuilder.append(']');

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The URL used for viewing the resource on the shop's Online Store. Returns `null` if the resource is
        * currently not published to the Online Store sales channel.
        */
        public ArticleQuery onlineStoreUrl() {
            startField("onlineStoreUrl");

            return this;
        }

        /**
        * The date and time when the article was published.
        */
        public ArticleQuery publishedAt() {
            startField("publishedAt");

            return this;
        }

        /**
        * The article’s SEO information.
        */
        public ArticleQuery seo(SEOQueryDefinition queryDef) {
            startField("seo");

            _queryBuilder.append('{');
            queryDef.define(new SEOQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A categorization that a article can be tagged with.
        */
        public ArticleQuery tags() {
            startField("tags");

            return this;
        }

        /**
        * The article’s name.
        */
        public ArticleQuery title() {
            startField("title");

            return this;
        }

        /**
        * A URL parameters to be added to a page URL when it is linked from a GraphQL result. This allows for
        * tracking the origin of the traffic.
        */
        public ArticleQuery trackingParameters() {
            startField("trackingParameters");

            return this;
        }
    }

    /**
    * An article in an online store blog.
    */
    public static class Article extends AbstractResponse<Article> implements HasMetafields, MenuItemResource, MetafieldParentResource, Node, OnlineStorePublishable, SearchResultItem, Trackable {
        public Article() {
        }

        public Article(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "author": {
                        responseData.put(key, new ArticleAuthor(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "authorV2": {
                        ArticleAuthor optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new ArticleAuthor(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "blog": {
                        responseData.put(key, new Blog(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "comments": {
                        responseData.put(key, new CommentConnection(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "content": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "contentHtml": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "excerpt": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "excerptHtml": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "handle": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "image": {
                        Image optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Image(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "metafield": {
                        Metafield optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Metafield(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "metafields": {
                        List<Metafield> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            Metafield optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = new Metafield(jsonAsObject(element1, key));
                            }

                            list1.add(optional2);
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "onlineStoreUrl": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "publishedAt": {
                        responseData.put(key, Utils.parseDateTime(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "seo": {
                        SEO optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new SEO(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "tags": {
                        List<String> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(jsonAsString(element1, key));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "title": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "trackingParameters": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public Article(ID id) {
            this();
            optimisticData.put("id", id);
        }

        public String getGraphQlTypeName() {
            return "Article";
        }

        /**
        * The article's author.
        *
        * @deprecated Use `authorV2` instead.
        */

        public ArticleAuthor getAuthor() {
            return (ArticleAuthor) get("author");
        }

        public Article setAuthor(ArticleAuthor arg) {
            optimisticData.put(getKey("author"), arg);
            return this;
        }

        /**
        * The article's author.
        */

        public ArticleAuthor getAuthorV2() {
            return (ArticleAuthor) get("authorV2");
        }

        public Article setAuthorV2(ArticleAuthor arg) {
            optimisticData.put(getKey("authorV2"), arg);
            return this;
        }

        /**
        * The blog that the article belongs to.
        */

        public Blog getBlog() {
            return (Blog) get("blog");
        }

        public Article setBlog(Blog arg) {
            optimisticData.put(getKey("blog"), arg);
            return this;
        }

        /**
        * List of comments posted on the article.
        */

        public CommentConnection getComments() {
            return (CommentConnection) get("comments");
        }

        public Article setComments(CommentConnection arg) {
            optimisticData.put(getKey("comments"), arg);
            return this;
        }

        /**
        * Stripped content of the article, single line with HTML tags removed.
        */

        public String getContent() {
            return (String) get("content");
        }

        public Article setContent(String arg) {
            optimisticData.put(getKey("content"), arg);
            return this;
        }

        /**
        * The content of the article, complete with HTML formatting.
        */

        public String getContentHtml() {
            return (String) get("contentHtml");
        }

        public Article setContentHtml(String arg) {
            optimisticData.put(getKey("contentHtml"), arg);
            return this;
        }

        /**
        * Stripped excerpt of the article, single line with HTML tags removed.
        */

        public String getExcerpt() {
            return (String) get("excerpt");
        }

        public Article setExcerpt(String arg) {
            optimisticData.put(getKey("excerpt"), arg);
            return this;
        }

        /**
        * The excerpt of the article, complete with HTML formatting.
        */

        public String getExcerptHtml() {
            return (String) get("excerptHtml");
        }

        public Article setExcerptHtml(String arg) {
            optimisticData.put(getKey("excerptHtml"), arg);
            return this;
        }

        /**
        * A human-friendly unique string for the Article automatically generated from its title.
        */

        public String getHandle() {
            return (String) get("handle");
        }

        public Article setHandle(String arg) {
            optimisticData.put(getKey("handle"), arg);
            return this;
        }

        /**
        * A globally-unique ID.
        */

        public ID getId() {
            return (ID) get("id");
        }

        /**
        * The image associated with the article.
        */

        public Image getImage() {
            return (Image) get("image");
        }

        public Article setImage(Image arg) {
            optimisticData.put(getKey("image"), arg);
            return this;
        }

        /**
        * Returns a metafield found by namespace and key.
        */

        public Metafield getMetafield() {
            return (Metafield) get("metafield");
        }

        public Article setMetafield(Metafield arg) {
            optimisticData.put(getKey("metafield"), arg);
            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */

        public List<Metafield> getMetafields() {
            return (List<Metafield>) get("metafields");
        }

        public Article setMetafields(List<Metafield> arg) {
            optimisticData.put(getKey("metafields"), arg);
            return this;
        }

        /**
        * The URL used for viewing the resource on the shop's Online Store. Returns `null` if the resource is
        * currently not published to the Online Store sales channel.
        */

        public String getOnlineStoreUrl() {
            return (String) get("onlineStoreUrl");
        }

        public Article setOnlineStoreUrl(String arg) {
            optimisticData.put(getKey("onlineStoreUrl"), arg);
            return this;
        }

        /**
        * The date and time when the article was published.
        */

        public DateTime getPublishedAt() {
            return (DateTime) get("publishedAt");
        }

        public Article setPublishedAt(DateTime arg) {
            optimisticData.put(getKey("publishedAt"), arg);
            return this;
        }

        /**
        * The article’s SEO information.
        */

        public SEO getSeo() {
            return (SEO) get("seo");
        }

        public Article setSeo(SEO arg) {
            optimisticData.put(getKey("seo"), arg);
            return this;
        }

        /**
        * A categorization that a article can be tagged with.
        */

        public List<String> getTags() {
            return (List<String>) get("tags");
        }

        public Article setTags(List<String> arg) {
            optimisticData.put(getKey("tags"), arg);
            return this;
        }

        /**
        * The article’s name.
        */

        public String getTitle() {
            return (String) get("title");
        }

        public Article setTitle(String arg) {
            optimisticData.put(getKey("title"), arg);
            return this;
        }

        /**
        * A URL parameters to be added to a page URL when it is linked from a GraphQL result. This allows for
        * tracking the origin of the traffic.
        */

        public String getTrackingParameters() {
            return (String) get("trackingParameters");
        }

        public Article setTrackingParameters(String arg) {
            optimisticData.put(getKey("trackingParameters"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "author": return true;

                case "authorV2": return true;

                case "blog": return true;

                case "comments": return true;

                case "content": return false;

                case "contentHtml": return false;

                case "excerpt": return false;

                case "excerptHtml": return false;

                case "handle": return false;

                case "id": return false;

                case "image": return true;

                case "metafield": return true;

                case "metafields": return true;

                case "onlineStoreUrl": return false;

                case "publishedAt": return false;

                case "seo": return true;

                case "tags": return false;

                case "title": return false;

                case "trackingParameters": return false;

                default: return false;
            }
        }
    }

    public interface ArticleAuthorQueryDefinition {
        void define(ArticleAuthorQuery _queryBuilder);
    }

    /**
    * The author of an article.
    */
    public static class ArticleAuthorQuery extends Query<ArticleAuthorQuery> {
        ArticleAuthorQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The author's bio.
        */
        public ArticleAuthorQuery bio() {
            startField("bio");

            return this;
        }

        /**
        * The author’s email.
        */
        public ArticleAuthorQuery email() {
            startField("email");

            return this;
        }

        /**
        * The author's first name.
        */
        public ArticleAuthorQuery firstName() {
            startField("firstName");

            return this;
        }

        /**
        * The author's last name.
        */
        public ArticleAuthorQuery lastName() {
            startField("lastName");

            return this;
        }

        /**
        * The author's full name.
        */
        public ArticleAuthorQuery name() {
            startField("name");

            return this;
        }
    }

    /**
    * The author of an article.
    */
    public static class ArticleAuthor extends AbstractResponse<ArticleAuthor> {
        public ArticleAuthor() {
        }

        public ArticleAuthor(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "bio": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "email": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "firstName": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "lastName": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "name": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "ArticleAuthor";
        }

        /**
        * The author's bio.
        */

        public String getBio() {
            return (String) get("bio");
        }

        public ArticleAuthor setBio(String arg) {
            optimisticData.put(getKey("bio"), arg);
            return this;
        }

        /**
        * The author’s email.
        */

        public String getEmail() {
            return (String) get("email");
        }

        public ArticleAuthor setEmail(String arg) {
            optimisticData.put(getKey("email"), arg);
            return this;
        }

        /**
        * The author's first name.
        */

        public String getFirstName() {
            return (String) get("firstName");
        }

        public ArticleAuthor setFirstName(String arg) {
            optimisticData.put(getKey("firstName"), arg);
            return this;
        }

        /**
        * The author's last name.
        */

        public String getLastName() {
            return (String) get("lastName");
        }

        public ArticleAuthor setLastName(String arg) {
            optimisticData.put(getKey("lastName"), arg);
            return this;
        }

        /**
        * The author's full name.
        */

        public String getName() {
            return (String) get("name");
        }

        public ArticleAuthor setName(String arg) {
            optimisticData.put(getKey("name"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "bio": return false;

                case "email": return false;

                case "firstName": return false;

                case "lastName": return false;

                case "name": return false;

                default: return false;
            }
        }
    }

    public interface ArticleConnectionQueryDefinition {
        void define(ArticleConnectionQuery _queryBuilder);
    }

    /**
    * An auto-generated type for paginating through multiple Articles.
    */
    public static class ArticleConnectionQuery extends Query<ArticleConnectionQuery> {
        ArticleConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A list of edges.
        */
        public ArticleConnectionQuery edges(ArticleEdgeQueryDefinition queryDef) {
            startField("edges");

            _queryBuilder.append('{');
            queryDef.define(new ArticleEdgeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A list of the nodes contained in ArticleEdge.
        */
        public ArticleConnectionQuery nodes(ArticleQueryDefinition queryDef) {
            startField("nodes");

            _queryBuilder.append('{');
            queryDef.define(new ArticleQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * Information to aid in pagination.
        */
        public ArticleConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            startField("pageInfo");

            _queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type for paginating through multiple Articles.
    */
    public static class ArticleConnection extends AbstractResponse<ArticleConnection> {
        public ArticleConnection() {
        }

        public ArticleConnection(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "edges": {
                        List<ArticleEdge> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new ArticleEdge(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "nodes": {
                        List<Article> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new Article(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "pageInfo": {
                        responseData.put(key, new PageInfo(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "ArticleConnection";
        }

        /**
        * A list of edges.
        */

        public List<ArticleEdge> getEdges() {
            return (List<ArticleEdge>) get("edges");
        }

        public ArticleConnection setEdges(List<ArticleEdge> arg) {
            optimisticData.put(getKey("edges"), arg);
            return this;
        }

        /**
        * A list of the nodes contained in ArticleEdge.
        */

        public List<Article> getNodes() {
            return (List<Article>) get("nodes");
        }

        public ArticleConnection setNodes(List<Article> arg) {
            optimisticData.put(getKey("nodes"), arg);
            return this;
        }

        /**
        * Information to aid in pagination.
        */

        public PageInfo getPageInfo() {
            return (PageInfo) get("pageInfo");
        }

        public ArticleConnection setPageInfo(PageInfo arg) {
            optimisticData.put(getKey("pageInfo"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "edges": return true;

                case "nodes": return true;

                case "pageInfo": return true;

                default: return false;
            }
        }
    }

    public interface ArticleEdgeQueryDefinition {
        void define(ArticleEdgeQuery _queryBuilder);
    }

    /**
    * An auto-generated type which holds one Article and a cursor during pagination.
    */
    public static class ArticleEdgeQuery extends Query<ArticleEdgeQuery> {
        ArticleEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A cursor for use in pagination.
        */
        public ArticleEdgeQuery cursor() {
            startField("cursor");

            return this;
        }

        /**
        * The item at the end of ArticleEdge.
        */
        public ArticleEdgeQuery node(ArticleQueryDefinition queryDef) {
            startField("node");

            _queryBuilder.append('{');
            queryDef.define(new ArticleQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type which holds one Article and a cursor during pagination.
    */
    public static class ArticleEdge extends AbstractResponse<ArticleEdge> {
        public ArticleEdge() {
        }

        public ArticleEdge(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cursor": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "node": {
                        responseData.put(key, new Article(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "ArticleEdge";
        }

        /**
        * A cursor for use in pagination.
        */

        public String getCursor() {
            return (String) get("cursor");
        }

        public ArticleEdge setCursor(String arg) {
            optimisticData.put(getKey("cursor"), arg);
            return this;
        }

        /**
        * The item at the end of ArticleEdge.
        */

        public Article getNode() {
            return (Article) get("node");
        }

        public ArticleEdge setNode(Article arg) {
            optimisticData.put(getKey("node"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cursor": return false;

                case "node": return true;

                default: return false;
            }
        }
    }

    /**
    * The set of valid sort keys for the Article query.
    */
    public enum ArticleSortKeys {
        /**
        * Sort by the `author` value.
        */
        AUTHOR,

        /**
        * Sort by the `blog_title` value.
        */
        BLOG_TITLE,

        /**
        * Sort by the `id` value.
        */
        ID,

        /**
        * Sort by the `published_at` value.
        */
        PUBLISHED_AT,

        /**
        * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
        * Don't use this sort key when no search query is specified.
        */
        RELEVANCE,

        /**
        * Sort by the `title` value.
        */
        TITLE,

        /**
        * Sort by the `updated_at` value.
        */
        UPDATED_AT,

        UNKNOWN_VALUE;

        public static ArticleSortKeys fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "AUTHOR": {
                    return AUTHOR;
                }

                case "BLOG_TITLE": {
                    return BLOG_TITLE;
                }

                case "ID": {
                    return ID;
                }

                case "PUBLISHED_AT": {
                    return PUBLISHED_AT;
                }

                case "RELEVANCE": {
                    return RELEVANCE;
                }

                case "TITLE": {
                    return TITLE;
                }

                case "UPDATED_AT": {
                    return UPDATED_AT;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case AUTHOR: {
                    return "AUTHOR";
                }

                case BLOG_TITLE: {
                    return "BLOG_TITLE";
                }

                case ID: {
                    return "ID";
                }

                case PUBLISHED_AT: {
                    return "PUBLISHED_AT";
                }

                case RELEVANCE: {
                    return "RELEVANCE";
                }

                case TITLE: {
                    return "TITLE";
                }

                case UPDATED_AT: {
                    return "UPDATED_AT";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface AttributeQueryDefinition {
        void define(AttributeQuery _queryBuilder);
    }

    /**
    * Represents a generic custom attribute.
    */
    public static class AttributeQuery extends Query<AttributeQuery> {
        AttributeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * Key or name of the attribute.
        */
        public AttributeQuery key() {
            startField("key");

            return this;
        }

        /**
        * Value of the attribute.
        */
        public AttributeQuery value() {
            startField("value");

            return this;
        }
    }

    /**
    * Represents a generic custom attribute.
    */
    public static class Attribute extends AbstractResponse<Attribute> {
        public Attribute() {
        }

        public Attribute(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "key": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "value": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "Attribute";
        }

        /**
        * Key or name of the attribute.
        */

        public String getKey() {
            return (String) get("key");
        }

        public Attribute setKey(String arg) {
            optimisticData.put(getKey("key"), arg);
            return this;
        }

        /**
        * Value of the attribute.
        */

        public String getValue() {
            return (String) get("value");
        }

        public Attribute setValue(String arg) {
            optimisticData.put(getKey("value"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "key": return false;

                case "value": return false;

                default: return false;
            }
        }
    }

    public static class AttributeInput implements Serializable {
        private String key;

        private String value;

        public AttributeInput(String key, String value) {
            this.key = key;

            this.value = value;
        }

        public String getKey() {
            return key;
        }

        public AttributeInput setKey(String key) {
            this.key = key;
            return this;
        }

        public String getValue() {
            return value;
        }

        public AttributeInput setValue(String value) {
            this.value = value;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("value:");
            Query.appendQuotedString(_queryBuilder, value.toString());

            _queryBuilder.append('}');
        }
    }

    public interface AutomaticDiscountApplicationQueryDefinition {
        void define(AutomaticDiscountApplicationQuery _queryBuilder);
    }

    /**
    * Automatic discount applications capture the intentions of a discount that was automatically applied.
    */
    public static class AutomaticDiscountApplicationQuery extends Query<AutomaticDiscountApplicationQuery> {
        AutomaticDiscountApplicationQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The method by which the discount's value is allocated to its entitled items.
        */
        public AutomaticDiscountApplicationQuery allocationMethod() {
            startField("allocationMethod");

            return this;
        }

        /**
        * Which lines of targetType that the discount is allocated over.
        */
        public AutomaticDiscountApplicationQuery targetSelection() {
            startField("targetSelection");

            return this;
        }

        /**
        * The type of line that the discount is applicable towards.
        */
        public AutomaticDiscountApplicationQuery targetType() {
            startField("targetType");

            return this;
        }

        /**
        * The title of the application.
        */
        public AutomaticDiscountApplicationQuery title() {
            startField("title");

            return this;
        }

        /**
        * The value of the discount application.
        */
        public AutomaticDiscountApplicationQuery value(PricingValueQueryDefinition queryDef) {
            startField("value");

            _queryBuilder.append('{');
            queryDef.define(new PricingValueQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Automatic discount applications capture the intentions of a discount that was automatically applied.
    */
    public static class AutomaticDiscountApplication extends AbstractResponse<AutomaticDiscountApplication> implements DiscountApplication {
        public AutomaticDiscountApplication() {
        }

        public AutomaticDiscountApplication(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "allocationMethod": {
                        responseData.put(key, DiscountApplicationAllocationMethod.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "targetSelection": {
                        responseData.put(key, DiscountApplicationTargetSelection.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "targetType": {
                        responseData.put(key, DiscountApplicationTargetType.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "title": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "value": {
                        responseData.put(key, UnknownPricingValue.create(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "AutomaticDiscountApplication";
        }

        /**
        * The method by which the discount's value is allocated to its entitled items.
        */

        public DiscountApplicationAllocationMethod getAllocationMethod() {
            return (DiscountApplicationAllocationMethod) get("allocationMethod");
        }

        public AutomaticDiscountApplication setAllocationMethod(DiscountApplicationAllocationMethod arg) {
            optimisticData.put(getKey("allocationMethod"), arg);
            return this;
        }

        /**
        * Which lines of targetType that the discount is allocated over.
        */

        public DiscountApplicationTargetSelection getTargetSelection() {
            return (DiscountApplicationTargetSelection) get("targetSelection");
        }

        public AutomaticDiscountApplication setTargetSelection(DiscountApplicationTargetSelection arg) {
            optimisticData.put(getKey("targetSelection"), arg);
            return this;
        }

        /**
        * The type of line that the discount is applicable towards.
        */

        public DiscountApplicationTargetType getTargetType() {
            return (DiscountApplicationTargetType) get("targetType");
        }

        public AutomaticDiscountApplication setTargetType(DiscountApplicationTargetType arg) {
            optimisticData.put(getKey("targetType"), arg);
            return this;
        }

        /**
        * The title of the application.
        */

        public String getTitle() {
            return (String) get("title");
        }

        public AutomaticDiscountApplication setTitle(String arg) {
            optimisticData.put(getKey("title"), arg);
            return this;
        }

        /**
        * The value of the discount application.
        */

        public PricingValue getValue() {
            return (PricingValue) get("value");
        }

        public AutomaticDiscountApplication setValue(PricingValue arg) {
            optimisticData.put(getKey("value"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "allocationMethod": return false;

                case "targetSelection": return false;

                case "targetType": return false;

                case "title": return false;

                case "value": return false;

                default: return false;
            }
        }
    }

    public interface BaseCartLineQueryDefinition {
        void define(BaseCartLineQuery _queryBuilder);
    }

    /**
    * Represents a cart line common fields.
    */
    public static class BaseCartLineQuery extends Query<BaseCartLineQuery> {
        BaseCartLineQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("__typename");
        }

        /**
        * An attribute associated with the cart line.
        */
        public BaseCartLineQuery attribute(String key, AttributeQueryDefinition queryDef) {
            startField("attribute");

            _queryBuilder.append("(key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new AttributeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The attributes associated with the cart line. Attributes are represented as key-value pairs.
        */
        public BaseCartLineQuery attributes(AttributeQueryDefinition queryDef) {
            startField("attributes");

            _queryBuilder.append('{');
            queryDef.define(new AttributeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The cost of the merchandise that the buyer will pay for at checkout. The costs are subject to change
        * and changes will be reflected at checkout.
        */
        public BaseCartLineQuery cost(CartLineCostQueryDefinition queryDef) {
            startField("cost");

            _queryBuilder.append('{');
            queryDef.define(new CartLineCostQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The discounts that have been applied to the cart line.
        */
        public BaseCartLineQuery discountAllocations(CartDiscountAllocationQueryDefinition queryDef) {
            startField("discountAllocations");

            _queryBuilder.append('{');
            queryDef.define(new CartDiscountAllocationQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The estimated cost of the merchandise that the buyer will pay for at checkout. The estimated costs
        * are subject to change and changes will be reflected at checkout.
        *
        * @deprecated Use `cost` instead.
        */
        @Deprecated
        public BaseCartLineQuery estimatedCost(CartLineEstimatedCostQueryDefinition queryDef) {
            startField("estimatedCost");

            _queryBuilder.append('{');
            queryDef.define(new CartLineEstimatedCostQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A globally-unique ID.
        */
        public BaseCartLineQuery id() {
            startField("id");

            return this;
        }

        /**
        * The merchandise that the buyer intends to purchase.
        */
        public BaseCartLineQuery merchandise(MerchandiseQueryDefinition queryDef) {
            startField("merchandise");

            _queryBuilder.append('{');
            queryDef.define(new MerchandiseQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The quantity of the merchandise that the customer intends to purchase.
        */
        public BaseCartLineQuery quantity() {
            startField("quantity");

            return this;
        }

        /**
        * The selling plan associated with the cart line and the effect that each selling plan has on variants
        * when they're purchased.
        */
        public BaseCartLineQuery sellingPlanAllocation(SellingPlanAllocationQueryDefinition queryDef) {
            startField("sellingPlanAllocation");

            _queryBuilder.append('{');
            queryDef.define(new SellingPlanAllocationQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        public BaseCartLineQuery onCartLine(CartLineQueryDefinition queryDef) {
            startInlineFragment("CartLine");
            queryDef.define(new CartLineQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public BaseCartLineQuery onComponentizableCartLine(ComponentizableCartLineQueryDefinition queryDef) {
            startInlineFragment("ComponentizableCartLine");
            queryDef.define(new ComponentizableCartLineQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }
    }

    public interface BaseCartLine {
        String getGraphQlTypeName();

        Attribute getAttribute();

        List<Attribute> getAttributes();

        CartLineCost getCost();

        List<CartDiscountAllocation> getDiscountAllocations();

        CartLineEstimatedCost getEstimatedCost();

        ID getId();

        Merchandise getMerchandise();

        Integer getQuantity();

        SellingPlanAllocation getSellingPlanAllocation();
    }

    /**
    * Represents a cart line common fields.
    */
    public static class UnknownBaseCartLine extends AbstractResponse<UnknownBaseCartLine> implements BaseCartLine {
        public UnknownBaseCartLine() {
        }

        public UnknownBaseCartLine(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "attribute": {
                        Attribute optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Attribute(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "attributes": {
                        List<Attribute> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new Attribute(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "cost": {
                        responseData.put(key, new CartLineCost(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "discountAllocations": {
                        List<CartDiscountAllocation> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(UnknownCartDiscountAllocation.create(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "estimatedCost": {
                        responseData.put(key, new CartLineEstimatedCost(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "merchandise": {
                        responseData.put(key, UnknownMerchandise.create(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "quantity": {
                        responseData.put(key, jsonAsInteger(field.getValue(), key));

                        break;
                    }

                    case "sellingPlanAllocation": {
                        SellingPlanAllocation optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new SellingPlanAllocation(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public static BaseCartLine create(JsonObject fields) throws SchemaViolationError {
            String typeName = fields.getAsJsonPrimitive("__typename").getAsString();
            switch (typeName) {
                case "CartLine": {
                    return new CartLine(fields);
                }

                case "ComponentizableCartLine": {
                    return new ComponentizableCartLine(fields);
                }

                default: {
                    return new UnknownBaseCartLine(fields);
                }
            }
        }

        public String getGraphQlTypeName() {
            return (String) get("__typename");
        }

        /**
        * An attribute associated with the cart line.
        */

        public Attribute getAttribute() {
            return (Attribute) get("attribute");
        }

        public UnknownBaseCartLine setAttribute(Attribute arg) {
            optimisticData.put(getKey("attribute"), arg);
            return this;
        }

        /**
        * The attributes associated with the cart line. Attributes are represented as key-value pairs.
        */

        public List<Attribute> getAttributes() {
            return (List<Attribute>) get("attributes");
        }

        public UnknownBaseCartLine setAttributes(List<Attribute> arg) {
            optimisticData.put(getKey("attributes"), arg);
            return this;
        }

        /**
        * The cost of the merchandise that the buyer will pay for at checkout. The costs are subject to change
        * and changes will be reflected at checkout.
        */

        public CartLineCost getCost() {
            return (CartLineCost) get("cost");
        }

        public UnknownBaseCartLine setCost(CartLineCost arg) {
            optimisticData.put(getKey("cost"), arg);
            return this;
        }

        /**
        * The discounts that have been applied to the cart line.
        */

        public List<CartDiscountAllocation> getDiscountAllocations() {
            return (List<CartDiscountAllocation>) get("discountAllocations");
        }

        public UnknownBaseCartLine setDiscountAllocations(List<CartDiscountAllocation> arg) {
            optimisticData.put(getKey("discountAllocations"), arg);
            return this;
        }

        /**
        * The estimated cost of the merchandise that the buyer will pay for at checkout. The estimated costs
        * are subject to change and changes will be reflected at checkout.
        *
        * @deprecated Use `cost` instead.
        */

        public CartLineEstimatedCost getEstimatedCost() {
            return (CartLineEstimatedCost) get("estimatedCost");
        }

        public UnknownBaseCartLine setEstimatedCost(CartLineEstimatedCost arg) {
            optimisticData.put(getKey("estimatedCost"), arg);
            return this;
        }

        /**
        * A globally-unique ID.
        */

        public ID getId() {
            return (ID) get("id");
        }

        public UnknownBaseCartLine setId(ID arg) {
            optimisticData.put(getKey("id"), arg);
            return this;
        }

        /**
        * The merchandise that the buyer intends to purchase.
        */

        public Merchandise getMerchandise() {
            return (Merchandise) get("merchandise");
        }

        public UnknownBaseCartLine setMerchandise(Merchandise arg) {
            optimisticData.put(getKey("merchandise"), arg);
            return this;
        }

        /**
        * The quantity of the merchandise that the customer intends to purchase.
        */

        public Integer getQuantity() {
            return (Integer) get("quantity");
        }

        public UnknownBaseCartLine setQuantity(Integer arg) {
            optimisticData.put(getKey("quantity"), arg);
            return this;
        }

        /**
        * The selling plan associated with the cart line and the effect that each selling plan has on variants
        * when they're purchased.
        */

        public SellingPlanAllocation getSellingPlanAllocation() {
            return (SellingPlanAllocation) get("sellingPlanAllocation");
        }

        public UnknownBaseCartLine setSellingPlanAllocation(SellingPlanAllocation arg) {
            optimisticData.put(getKey("sellingPlanAllocation"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "attribute": return true;

                case "attributes": return true;

                case "cost": return true;

                case "discountAllocations": return false;

                case "estimatedCost": return true;

                case "id": return false;

                case "merchandise": return false;

                case "quantity": return false;

                case "sellingPlanAllocation": return true;

                default: return false;
            }
        }
    }

    public interface BaseCartLineConnectionQueryDefinition {
        void define(BaseCartLineConnectionQuery _queryBuilder);
    }

    /**
    * An auto-generated type for paginating through multiple BaseCartLines.
    */
    public static class BaseCartLineConnectionQuery extends Query<BaseCartLineConnectionQuery> {
        BaseCartLineConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A list of edges.
        */
        public BaseCartLineConnectionQuery edges(BaseCartLineEdgeQueryDefinition queryDef) {
            startField("edges");

            _queryBuilder.append('{');
            queryDef.define(new BaseCartLineEdgeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A list of the nodes contained in BaseCartLineEdge.
        */
        public BaseCartLineConnectionQuery nodes(BaseCartLineQueryDefinition queryDef) {
            startField("nodes");

            _queryBuilder.append('{');
            queryDef.define(new BaseCartLineQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * Information to aid in pagination.
        */
        public BaseCartLineConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            startField("pageInfo");

            _queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type for paginating through multiple BaseCartLines.
    */
    public static class BaseCartLineConnection extends AbstractResponse<BaseCartLineConnection> {
        public BaseCartLineConnection() {
        }

        public BaseCartLineConnection(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "edges": {
                        List<BaseCartLineEdge> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new BaseCartLineEdge(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "nodes": {
                        List<BaseCartLine> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(UnknownBaseCartLine.create(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "pageInfo": {
                        responseData.put(key, new PageInfo(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "BaseCartLineConnection";
        }

        /**
        * A list of edges.
        */

        public List<BaseCartLineEdge> getEdges() {
            return (List<BaseCartLineEdge>) get("edges");
        }

        public BaseCartLineConnection setEdges(List<BaseCartLineEdge> arg) {
            optimisticData.put(getKey("edges"), arg);
            return this;
        }

        /**
        * A list of the nodes contained in BaseCartLineEdge.
        */

        public List<BaseCartLine> getNodes() {
            return (List<BaseCartLine>) get("nodes");
        }

        public BaseCartLineConnection setNodes(List<BaseCartLine> arg) {
            optimisticData.put(getKey("nodes"), arg);
            return this;
        }

        /**
        * Information to aid in pagination.
        */

        public PageInfo getPageInfo() {
            return (PageInfo) get("pageInfo");
        }

        public BaseCartLineConnection setPageInfo(PageInfo arg) {
            optimisticData.put(getKey("pageInfo"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "edges": return true;

                case "nodes": return false;

                case "pageInfo": return true;

                default: return false;
            }
        }
    }

    public interface BaseCartLineEdgeQueryDefinition {
        void define(BaseCartLineEdgeQuery _queryBuilder);
    }

    /**
    * An auto-generated type which holds one BaseCartLine and a cursor during pagination.
    */
    public static class BaseCartLineEdgeQuery extends Query<BaseCartLineEdgeQuery> {
        BaseCartLineEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A cursor for use in pagination.
        */
        public BaseCartLineEdgeQuery cursor() {
            startField("cursor");

            return this;
        }

        /**
        * The item at the end of BaseCartLineEdge.
        */
        public BaseCartLineEdgeQuery node(BaseCartLineQueryDefinition queryDef) {
            startField("node");

            _queryBuilder.append('{');
            queryDef.define(new BaseCartLineQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type which holds one BaseCartLine and a cursor during pagination.
    */
    public static class BaseCartLineEdge extends AbstractResponse<BaseCartLineEdge> {
        public BaseCartLineEdge() {
        }

        public BaseCartLineEdge(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cursor": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "node": {
                        responseData.put(key, UnknownBaseCartLine.create(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "BaseCartLineEdge";
        }

        /**
        * A cursor for use in pagination.
        */

        public String getCursor() {
            return (String) get("cursor");
        }

        public BaseCartLineEdge setCursor(String arg) {
            optimisticData.put(getKey("cursor"), arg);
            return this;
        }

        /**
        * The item at the end of BaseCartLineEdge.
        */

        public BaseCartLine getNode() {
            return (BaseCartLine) get("node");
        }

        public BaseCartLineEdge setNode(BaseCartLine arg) {
            optimisticData.put(getKey("node"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cursor": return false;

                case "node": return false;

                default: return false;
            }
        }
    }

    public interface BlogQueryDefinition {
        void define(BlogQuery _queryBuilder);
    }

    /**
    * An online store blog.
    */
    public static class BlogQuery extends Query<BlogQuery> {
        BlogQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("id");
        }

        /**
        * Find an article by its handle.
        */
        public BlogQuery articleByHandle(String handle, ArticleQueryDefinition queryDef) {
            startField("articleByHandle");

            _queryBuilder.append("(handle:");
            Query.appendQuotedString(_queryBuilder, handle.toString());

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new ArticleQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        public class ArticlesArguments extends Arguments {
            ArticlesArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * Returns up to the first `n` elements from the list.
            */
            public ArticlesArguments first(Integer value) {
                if (value != null) {
                    startArgument("first");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come after the specified cursor.
            */
            public ArticlesArguments after(String value) {
                if (value != null) {
                    startArgument("after");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Returns up to the last `n` elements from the list.
            */
            public ArticlesArguments last(Integer value) {
                if (value != null) {
                    startArgument("last");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come before the specified cursor.
            */
            public ArticlesArguments before(String value) {
                if (value != null) {
                    startArgument("before");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Reverse the order of the underlying list.
            */
            public ArticlesArguments reverse(Boolean value) {
                if (value != null) {
                    startArgument("reverse");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Sort the underlying list by the given key.
            */
            public ArticlesArguments sortKey(ArticleSortKeys value) {
                if (value != null) {
                    startArgument("sortKey");
                    _queryBuilder.append(value.toString());
                }
                return this;
            }

            /**
            * Apply one or multiple filters to the query.
            * | name | description | acceptable_values | default_value | example_use |
            * | ---- | ---- | ---- | ---- | ---- |
            * | author |
            * | blog_title |
            * | created_at |
            * | tag |
            * | tag_not |
            * | updated_at |
            * Refer to the detailed [search syntax](https://shopify.dev/api/usage/search-syntax) for more
            * information about using filters.
            */
            public ArticlesArguments query(String value) {
                if (value != null) {
                    startArgument("query");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }
        }

        public interface ArticlesArgumentsDefinition {
            void define(ArticlesArguments args);
        }

        /**
        * List of the blog's articles.
        */
        public BlogQuery articles(ArticleConnectionQueryDefinition queryDef) {
            return articles(args -> {}, queryDef);
        }

        /**
        * List of the blog's articles.
        */
        public BlogQuery articles(ArticlesArgumentsDefinition argsDef, ArticleConnectionQueryDefinition queryDef) {
            startField("articles");

            ArticlesArguments args = new ArticlesArguments(_queryBuilder);
            argsDef.define(args);
            ArticlesArguments.end(args);

            _queryBuilder.append('{');
            queryDef.define(new ArticleConnectionQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The authors who have contributed to the blog.
        */
        public BlogQuery authors(ArticleAuthorQueryDefinition queryDef) {
            startField("authors");

            _queryBuilder.append('{');
            queryDef.define(new ArticleAuthorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A human-friendly unique string for the Blog automatically generated from its title.
        */
        public BlogQuery handle() {
            startField("handle");

            return this;
        }

        public class MetafieldArguments extends Arguments {
            MetafieldArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            /**
            * The container the metafield belongs to. If omitted, the app-reserved namespace will be used.
            */
            public MetafieldArguments namespace(String value) {
                if (value != null) {
                    startArgument("namespace");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }
        }

        public interface MetafieldArgumentsDefinition {
            void define(MetafieldArguments args);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public BlogQuery metafield(String key, MetafieldQueryDefinition queryDef) {
            return metafield(key, args -> {}, queryDef);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public BlogQuery metafield(String key, MetafieldArgumentsDefinition argsDef, MetafieldQueryDefinition queryDef) {
            startField("metafield");

            _queryBuilder.append("(key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            argsDef.define(new MetafieldArguments(_queryBuilder));

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */
        public BlogQuery metafields(List<HasMetafieldsIdentifier> identifiers, MetafieldQueryDefinition queryDef) {
            startField("metafields");

            _queryBuilder.append("(identifiers:");
            _queryBuilder.append('[');
            {
                String listSeperator1 = "";
                for (HasMetafieldsIdentifier item1 : identifiers) {
                    _queryBuilder.append(listSeperator1);
                    listSeperator1 = ",";
                    item1.appendTo(_queryBuilder);
                }
            }
            _queryBuilder.append(']');

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The URL used for viewing the resource on the shop's Online Store. Returns `null` if the resource is
        * currently not published to the Online Store sales channel.
        */
        public BlogQuery onlineStoreUrl() {
            startField("onlineStoreUrl");

            return this;
        }

        /**
        * The blog's SEO information.
        */
        public BlogQuery seo(SEOQueryDefinition queryDef) {
            startField("seo");

            _queryBuilder.append('{');
            queryDef.define(new SEOQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The blogs’s title.
        */
        public BlogQuery title() {
            startField("title");

            return this;
        }
    }

    /**
    * An online store blog.
    */
    public static class Blog extends AbstractResponse<Blog> implements HasMetafields, MenuItemResource, MetafieldParentResource, Node, OnlineStorePublishable {
        public Blog() {
        }

        public Blog(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "articleByHandle": {
                        Article optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Article(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "articles": {
                        responseData.put(key, new ArticleConnection(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "authors": {
                        List<ArticleAuthor> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new ArticleAuthor(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "handle": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "metafield": {
                        Metafield optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Metafield(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "metafields": {
                        List<Metafield> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            Metafield optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = new Metafield(jsonAsObject(element1, key));
                            }

                            list1.add(optional2);
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "onlineStoreUrl": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "seo": {
                        SEO optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new SEO(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "title": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public Blog(ID id) {
            this();
            optimisticData.put("id", id);
        }

        public String getGraphQlTypeName() {
            return "Blog";
        }

        /**
        * Find an article by its handle.
        */

        public Article getArticleByHandle() {
            return (Article) get("articleByHandle");
        }

        public Blog setArticleByHandle(Article arg) {
            optimisticData.put(getKey("articleByHandle"), arg);
            return this;
        }

        /**
        * List of the blog's articles.
        */

        public ArticleConnection getArticles() {
            return (ArticleConnection) get("articles");
        }

        public Blog setArticles(ArticleConnection arg) {
            optimisticData.put(getKey("articles"), arg);
            return this;
        }

        /**
        * The authors who have contributed to the blog.
        */

        public List<ArticleAuthor> getAuthors() {
            return (List<ArticleAuthor>) get("authors");
        }

        public Blog setAuthors(List<ArticleAuthor> arg) {
            optimisticData.put(getKey("authors"), arg);
            return this;
        }

        /**
        * A human-friendly unique string for the Blog automatically generated from its title.
        */

        public String getHandle() {
            return (String) get("handle");
        }

        public Blog setHandle(String arg) {
            optimisticData.put(getKey("handle"), arg);
            return this;
        }

        /**
        * A globally-unique ID.
        */

        public ID getId() {
            return (ID) get("id");
        }

        /**
        * Returns a metafield found by namespace and key.
        */

        public Metafield getMetafield() {
            return (Metafield) get("metafield");
        }

        public Blog setMetafield(Metafield arg) {
            optimisticData.put(getKey("metafield"), arg);
            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */

        public List<Metafield> getMetafields() {
            return (List<Metafield>) get("metafields");
        }

        public Blog setMetafields(List<Metafield> arg) {
            optimisticData.put(getKey("metafields"), arg);
            return this;
        }

        /**
        * The URL used for viewing the resource on the shop's Online Store. Returns `null` if the resource is
        * currently not published to the Online Store sales channel.
        */

        public String getOnlineStoreUrl() {
            return (String) get("onlineStoreUrl");
        }

        public Blog setOnlineStoreUrl(String arg) {
            optimisticData.put(getKey("onlineStoreUrl"), arg);
            return this;
        }

        /**
        * The blog's SEO information.
        */

        public SEO getSeo() {
            return (SEO) get("seo");
        }

        public Blog setSeo(SEO arg) {
            optimisticData.put(getKey("seo"), arg);
            return this;
        }

        /**
        * The blogs’s title.
        */

        public String getTitle() {
            return (String) get("title");
        }

        public Blog setTitle(String arg) {
            optimisticData.put(getKey("title"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "articleByHandle": return true;

                case "articles": return true;

                case "authors": return true;

                case "handle": return false;

                case "id": return false;

                case "metafield": return true;

                case "metafields": return true;

                case "onlineStoreUrl": return false;

                case "seo": return true;

                case "title": return false;

                default: return false;
            }
        }
    }

    public interface BlogConnectionQueryDefinition {
        void define(BlogConnectionQuery _queryBuilder);
    }

    /**
    * An auto-generated type for paginating through multiple Blogs.
    */
    public static class BlogConnectionQuery extends Query<BlogConnectionQuery> {
        BlogConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A list of edges.
        */
        public BlogConnectionQuery edges(BlogEdgeQueryDefinition queryDef) {
            startField("edges");

            _queryBuilder.append('{');
            queryDef.define(new BlogEdgeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A list of the nodes contained in BlogEdge.
        */
        public BlogConnectionQuery nodes(BlogQueryDefinition queryDef) {
            startField("nodes");

            _queryBuilder.append('{');
            queryDef.define(new BlogQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * Information to aid in pagination.
        */
        public BlogConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            startField("pageInfo");

            _queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type for paginating through multiple Blogs.
    */
    public static class BlogConnection extends AbstractResponse<BlogConnection> {
        public BlogConnection() {
        }

        public BlogConnection(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "edges": {
                        List<BlogEdge> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new BlogEdge(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "nodes": {
                        List<Blog> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new Blog(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "pageInfo": {
                        responseData.put(key, new PageInfo(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "BlogConnection";
        }

        /**
        * A list of edges.
        */

        public List<BlogEdge> getEdges() {
            return (List<BlogEdge>) get("edges");
        }

        public BlogConnection setEdges(List<BlogEdge> arg) {
            optimisticData.put(getKey("edges"), arg);
            return this;
        }

        /**
        * A list of the nodes contained in BlogEdge.
        */

        public List<Blog> getNodes() {
            return (List<Blog>) get("nodes");
        }

        public BlogConnection setNodes(List<Blog> arg) {
            optimisticData.put(getKey("nodes"), arg);
            return this;
        }

        /**
        * Information to aid in pagination.
        */

        public PageInfo getPageInfo() {
            return (PageInfo) get("pageInfo");
        }

        public BlogConnection setPageInfo(PageInfo arg) {
            optimisticData.put(getKey("pageInfo"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "edges": return true;

                case "nodes": return true;

                case "pageInfo": return true;

                default: return false;
            }
        }
    }

    public interface BlogEdgeQueryDefinition {
        void define(BlogEdgeQuery _queryBuilder);
    }

    /**
    * An auto-generated type which holds one Blog and a cursor during pagination.
    */
    public static class BlogEdgeQuery extends Query<BlogEdgeQuery> {
        BlogEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A cursor for use in pagination.
        */
        public BlogEdgeQuery cursor() {
            startField("cursor");

            return this;
        }

        /**
        * The item at the end of BlogEdge.
        */
        public BlogEdgeQuery node(BlogQueryDefinition queryDef) {
            startField("node");

            _queryBuilder.append('{');
            queryDef.define(new BlogQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type which holds one Blog and a cursor during pagination.
    */
    public static class BlogEdge extends AbstractResponse<BlogEdge> {
        public BlogEdge() {
        }

        public BlogEdge(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cursor": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "node": {
                        responseData.put(key, new Blog(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "BlogEdge";
        }

        /**
        * A cursor for use in pagination.
        */

        public String getCursor() {
            return (String) get("cursor");
        }

        public BlogEdge setCursor(String arg) {
            optimisticData.put(getKey("cursor"), arg);
            return this;
        }

        /**
        * The item at the end of BlogEdge.
        */

        public Blog getNode() {
            return (Blog) get("node");
        }

        public BlogEdge setNode(Blog arg) {
            optimisticData.put(getKey("node"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cursor": return false;

                case "node": return true;

                default: return false;
            }
        }
    }

    /**
    * The set of valid sort keys for the Blog query.
    */
    public enum BlogSortKeys {
        /**
        * Sort by the `handle` value.
        */
        HANDLE,

        /**
        * Sort by the `id` value.
        */
        ID,

        /**
        * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
        * Don't use this sort key when no search query is specified.
        */
        RELEVANCE,

        /**
        * Sort by the `title` value.
        */
        TITLE,

        UNKNOWN_VALUE;

        public static BlogSortKeys fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "HANDLE": {
                    return HANDLE;
                }

                case "ID": {
                    return ID;
                }

                case "RELEVANCE": {
                    return RELEVANCE;
                }

                case "TITLE": {
                    return TITLE;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case HANDLE: {
                    return "HANDLE";
                }

                case ID: {
                    return "ID";
                }

                case RELEVANCE: {
                    return "RELEVANCE";
                }

                case TITLE: {
                    return "TITLE";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface BrandQueryDefinition {
        void define(BrandQuery _queryBuilder);
    }

    /**
    * The store's [branding
    * configuration](https://help.shopify.com/en/manual/promoting-marketing/managing-brand-assets).
    */
    public static class BrandQuery extends Query<BrandQuery> {
        BrandQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The colors of the store's brand.
        */
        public BrandQuery colors(BrandColorsQueryDefinition queryDef) {
            startField("colors");

            _queryBuilder.append('{');
            queryDef.define(new BrandColorsQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The store's cover image.
        */
        public BrandQuery coverImage(MediaImageQueryDefinition queryDef) {
            startField("coverImage");

            _queryBuilder.append('{');
            queryDef.define(new MediaImageQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The store's default logo.
        */
        public BrandQuery logo(MediaImageQueryDefinition queryDef) {
            startField("logo");

            _queryBuilder.append('{');
            queryDef.define(new MediaImageQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The store's short description.
        */
        public BrandQuery shortDescription() {
            startField("shortDescription");

            return this;
        }

        /**
        * The store's slogan.
        */
        public BrandQuery slogan() {
            startField("slogan");

            return this;
        }

        /**
        * The store's preferred logo for square UI elements.
        */
        public BrandQuery squareLogo(MediaImageQueryDefinition queryDef) {
            startField("squareLogo");

            _queryBuilder.append('{');
            queryDef.define(new MediaImageQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * The store's [branding
    * configuration](https://help.shopify.com/en/manual/promoting-marketing/managing-brand-assets).
    */
    public static class Brand extends AbstractResponse<Brand> {
        public Brand() {
        }

        public Brand(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "colors": {
                        responseData.put(key, new BrandColors(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "coverImage": {
                        MediaImage optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new MediaImage(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "logo": {
                        MediaImage optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new MediaImage(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "shortDescription": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "slogan": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "squareLogo": {
                        MediaImage optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new MediaImage(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "Brand";
        }

        /**
        * The colors of the store's brand.
        */

        public BrandColors getColors() {
            return (BrandColors) get("colors");
        }

        public Brand setColors(BrandColors arg) {
            optimisticData.put(getKey("colors"), arg);
            return this;
        }

        /**
        * The store's cover image.
        */

        public MediaImage getCoverImage() {
            return (MediaImage) get("coverImage");
        }

        public Brand setCoverImage(MediaImage arg) {
            optimisticData.put(getKey("coverImage"), arg);
            return this;
        }

        /**
        * The store's default logo.
        */

        public MediaImage getLogo() {
            return (MediaImage) get("logo");
        }

        public Brand setLogo(MediaImage arg) {
            optimisticData.put(getKey("logo"), arg);
            return this;
        }

        /**
        * The store's short description.
        */

        public String getShortDescription() {
            return (String) get("shortDescription");
        }

        public Brand setShortDescription(String arg) {
            optimisticData.put(getKey("shortDescription"), arg);
            return this;
        }

        /**
        * The store's slogan.
        */

        public String getSlogan() {
            return (String) get("slogan");
        }

        public Brand setSlogan(String arg) {
            optimisticData.put(getKey("slogan"), arg);
            return this;
        }

        /**
        * The store's preferred logo for square UI elements.
        */

        public MediaImage getSquareLogo() {
            return (MediaImage) get("squareLogo");
        }

        public Brand setSquareLogo(MediaImage arg) {
            optimisticData.put(getKey("squareLogo"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "colors": return true;

                case "coverImage": return true;

                case "logo": return true;

                case "shortDescription": return false;

                case "slogan": return false;

                case "squareLogo": return true;

                default: return false;
            }
        }
    }

    public interface BrandColorGroupQueryDefinition {
        void define(BrandColorGroupQuery _queryBuilder);
    }

    /**
    * A group of related colors for the shop's brand.
    */
    public static class BrandColorGroupQuery extends Query<BrandColorGroupQuery> {
        BrandColorGroupQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The background color.
        */
        public BrandColorGroupQuery background() {
            startField("background");

            return this;
        }

        /**
        * The foreground color.
        */
        public BrandColorGroupQuery foreground() {
            startField("foreground");

            return this;
        }
    }

    /**
    * A group of related colors for the shop's brand.
    */
    public static class BrandColorGroup extends AbstractResponse<BrandColorGroup> {
        public BrandColorGroup() {
        }

        public BrandColorGroup(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "background": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "foreground": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "BrandColorGroup";
        }

        /**
        * The background color.
        */

        public String getBackground() {
            return (String) get("background");
        }

        public BrandColorGroup setBackground(String arg) {
            optimisticData.put(getKey("background"), arg);
            return this;
        }

        /**
        * The foreground color.
        */

        public String getForeground() {
            return (String) get("foreground");
        }

        public BrandColorGroup setForeground(String arg) {
            optimisticData.put(getKey("foreground"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "background": return false;

                case "foreground": return false;

                default: return false;
            }
        }
    }

    public interface BrandColorsQueryDefinition {
        void define(BrandColorsQuery _queryBuilder);
    }

    /**
    * The colors of the shop's brand.
    */
    public static class BrandColorsQuery extends Query<BrandColorsQuery> {
        BrandColorsQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The shop's primary brand colors.
        */
        public BrandColorsQuery primary(BrandColorGroupQueryDefinition queryDef) {
            startField("primary");

            _queryBuilder.append('{');
            queryDef.define(new BrandColorGroupQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The shop's secondary brand colors.
        */
        public BrandColorsQuery secondary(BrandColorGroupQueryDefinition queryDef) {
            startField("secondary");

            _queryBuilder.append('{');
            queryDef.define(new BrandColorGroupQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * The colors of the shop's brand.
    */
    public static class BrandColors extends AbstractResponse<BrandColors> {
        public BrandColors() {
        }

        public BrandColors(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "primary": {
                        List<BrandColorGroup> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new BrandColorGroup(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "secondary": {
                        List<BrandColorGroup> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new BrandColorGroup(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "BrandColors";
        }

        /**
        * The shop's primary brand colors.
        */

        public List<BrandColorGroup> getPrimary() {
            return (List<BrandColorGroup>) get("primary");
        }

        public BrandColors setPrimary(List<BrandColorGroup> arg) {
            optimisticData.put(getKey("primary"), arg);
            return this;
        }

        /**
        * The shop's secondary brand colors.
        */

        public List<BrandColorGroup> getSecondary() {
            return (List<BrandColorGroup>) get("secondary");
        }

        public BrandColors setSecondary(List<BrandColorGroup> arg) {
            optimisticData.put(getKey("secondary"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "primary": return true;

                case "secondary": return true;

                default: return false;
            }
        }
    }

    public static class BuyerInput implements Serializable {
        private String customerAccessToken;

        private Input<ID> companyLocationId = Input.undefined();

        public BuyerInput(String customerAccessToken) {
            this.customerAccessToken = customerAccessToken;
        }

        public String getCustomerAccessToken() {
            return customerAccessToken;
        }

        public BuyerInput setCustomerAccessToken(String customerAccessToken) {
            this.customerAccessToken = customerAccessToken;
            return this;
        }

        public ID getCompanyLocationId() {
            return companyLocationId.getValue();
        }

        public Input<ID> getCompanyLocationIdInput() {
            return companyLocationId;
        }

        public BuyerInput setCompanyLocationId(ID companyLocationId) {
            this.companyLocationId = Input.optional(companyLocationId);
            return this;
        }

        public BuyerInput setCompanyLocationIdInput(Input<ID> companyLocationId) {
            if (companyLocationId == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.companyLocationId = companyLocationId;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("customerAccessToken:");
            Query.appendQuotedString(_queryBuilder, customerAccessToken.toString());

            if (this.companyLocationId.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("companyLocationId:");
                if (companyLocationId.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, companyLocationId.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    /**
    * Card brand, such as Visa or Mastercard, which can be used for payments.
    */
    public enum CardBrand {
        /**
        * American Express.
        */
        AMERICAN_EXPRESS,

        /**
        * Diners Club.
        */
        DINERS_CLUB,

        /**
        * Discover.
        */
        DISCOVER,

        /**
        * JCB.
        */
        JCB,

        /**
        * Mastercard.
        */
        MASTERCARD,

        /**
        * Visa.
        */
        VISA,

        UNKNOWN_VALUE;

        public static CardBrand fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "AMERICAN_EXPRESS": {
                    return AMERICAN_EXPRESS;
                }

                case "DINERS_CLUB": {
                    return DINERS_CLUB;
                }

                case "DISCOVER": {
                    return DISCOVER;
                }

                case "JCB": {
                    return JCB;
                }

                case "MASTERCARD": {
                    return MASTERCARD;
                }

                case "VISA": {
                    return VISA;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case AMERICAN_EXPRESS: {
                    return "AMERICAN_EXPRESS";
                }

                case DINERS_CLUB: {
                    return "DINERS_CLUB";
                }

                case DISCOVER: {
                    return "DISCOVER";
                }

                case JCB: {
                    return "JCB";
                }

                case MASTERCARD: {
                    return "MASTERCARD";
                }

                case VISA: {
                    return "VISA";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface CartQueryDefinition {
        void define(CartQuery _queryBuilder);
    }

    /**
    * A cart represents the merchandise that a buyer intends to purchase,
    * and the estimated cost associated with the cart. Learn how to
    * [interact with a
    * cart](https://shopify.dev/custom-storefronts/internationalization/international-pricing)
    * during a customer's session.
    */
    public static class CartQuery extends Query<CartQuery> {
        CartQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("id");
        }

        /**
        * The gift cards that have been applied to the cart.
        */
        public CartQuery appliedGiftCards(AppliedGiftCardQueryDefinition queryDef) {
            startField("appliedGiftCards");

            _queryBuilder.append('{');
            queryDef.define(new AppliedGiftCardQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * An attribute associated with the cart.
        */
        public CartQuery attribute(String key, AttributeQueryDefinition queryDef) {
            startField("attribute");

            _queryBuilder.append("(key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new AttributeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The attributes associated with the cart. Attributes are represented as key-value pairs.
        */
        public CartQuery attributes(AttributeQueryDefinition queryDef) {
            startField("attributes");

            _queryBuilder.append('{');
            queryDef.define(new AttributeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * Information about the buyer that's interacting with the cart.
        */
        public CartQuery buyerIdentity(CartBuyerIdentityQueryDefinition queryDef) {
            startField("buyerIdentity");

            _queryBuilder.append('{');
            queryDef.define(new CartBuyerIdentityQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The URL of the checkout for the cart.
        */
        public CartQuery checkoutUrl() {
            startField("checkoutUrl");

            return this;
        }

        /**
        * The estimated costs that the buyer will pay at checkout. The costs are subject to change and changes
        * will be reflected at checkout. The `cost` field uses the `buyerIdentity` field to determine
        * [international
        * pricing](https://shopify.dev/custom-storefronts/internationalization/international-pricing).
        */
        public CartQuery cost(CartCostQueryDefinition queryDef) {
            startField("cost");

            _queryBuilder.append('{');
            queryDef.define(new CartCostQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The date and time when the cart was created.
        */
        public CartQuery createdAt() {
            startField("createdAt");

            return this;
        }

        public class DeliveryGroupsArguments extends Arguments {
            DeliveryGroupsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * Returns up to the first `n` elements from the list.
            */
            public DeliveryGroupsArguments first(Integer value) {
                if (value != null) {
                    startArgument("first");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come after the specified cursor.
            */
            public DeliveryGroupsArguments after(String value) {
                if (value != null) {
                    startArgument("after");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Returns up to the last `n` elements from the list.
            */
            public DeliveryGroupsArguments last(Integer value) {
                if (value != null) {
                    startArgument("last");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come before the specified cursor.
            */
            public DeliveryGroupsArguments before(String value) {
                if (value != null) {
                    startArgument("before");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Reverse the order of the underlying list.
            */
            public DeliveryGroupsArguments reverse(Boolean value) {
                if (value != null) {
                    startArgument("reverse");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Whether to include [carrier-calculated delivery
            * rates](https://help.shopify.com/en/manual/shipping/setting-up-and-managing-your-shipping/enabling-sh
            * ipping-carriers) in the response.
            * By default, only static shipping rates are returned. This argument requires mandatory usage of the
            * [`@defer` directive](https://shopify.dev/docs/api/storefront#directives).
            * For more information, refer to [fetching carrier-calculated rates for the cart using
            * `@defer`](https://shopify.dev/docs/storefronts/headless/building-with-the-storefront-api/defer#fetch
            * ing-carrier-calculated-rates-for-the-cart-using-defer).
            */
            public DeliveryGroupsArguments withCarrierRates(Boolean value) {
                if (value != null) {
                    startArgument("withCarrierRates");
                    _queryBuilder.append(value);
                }
                return this;
            }
        }

        public interface DeliveryGroupsArgumentsDefinition {
            void define(DeliveryGroupsArguments args);
        }

        /**
        * The delivery groups available for the cart, based on the buyer identity default
        * delivery address preference or the default address of the logged-in customer.
        */
        public CartQuery deliveryGroups(CartDeliveryGroupConnectionQueryDefinition queryDef) {
            return deliveryGroups(args -> {}, queryDef);
        }

        /**
        * The delivery groups available for the cart, based on the buyer identity default
        * delivery address preference or the default address of the logged-in customer.
        */
        public CartQuery deliveryGroups(DeliveryGroupsArgumentsDefinition argsDef, CartDeliveryGroupConnectionQueryDefinition queryDef) {
            startField("deliveryGroups");

            DeliveryGroupsArguments args = new DeliveryGroupsArguments(_queryBuilder);
            argsDef.define(args);
            DeliveryGroupsArguments.end(args);

            _queryBuilder.append('{');
            queryDef.define(new CartDeliveryGroupConnectionQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The discounts that have been applied to the entire cart.
        */
        public CartQuery discountAllocations(CartDiscountAllocationQueryDefinition queryDef) {
            startField("discountAllocations");

            _queryBuilder.append('{');
            queryDef.define(new CartDiscountAllocationQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The case-insensitive discount codes that the customer added at checkout.
        */
        public CartQuery discountCodes(CartDiscountCodeQueryDefinition queryDef) {
            startField("discountCodes");

            _queryBuilder.append('{');
            queryDef.define(new CartDiscountCodeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The estimated costs that the buyer will pay at checkout. The estimated costs are subject to change
        * and changes will be reflected at checkout. The `estimatedCost` field uses the `buyerIdentity` field
        * to determine [international
        * pricing](https://shopify.dev/custom-storefronts/internationalization/international-pricing).
        *
        * @deprecated Use `cost` instead.
        */
        @Deprecated
        public CartQuery estimatedCost(CartEstimatedCostQueryDefinition queryDef) {
            startField("estimatedCost");

            _queryBuilder.append('{');
            queryDef.define(new CartEstimatedCostQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        public class LinesArguments extends Arguments {
            LinesArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * Returns up to the first `n` elements from the list.
            */
            public LinesArguments first(Integer value) {
                if (value != null) {
                    startArgument("first");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come after the specified cursor.
            */
            public LinesArguments after(String value) {
                if (value != null) {
                    startArgument("after");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Returns up to the last `n` elements from the list.
            */
            public LinesArguments last(Integer value) {
                if (value != null) {
                    startArgument("last");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come before the specified cursor.
            */
            public LinesArguments before(String value) {
                if (value != null) {
                    startArgument("before");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Reverse the order of the underlying list.
            */
            public LinesArguments reverse(Boolean value) {
                if (value != null) {
                    startArgument("reverse");
                    _queryBuilder.append(value);
                }
                return this;
            }
        }

        public interface LinesArgumentsDefinition {
            void define(LinesArguments args);
        }

        /**
        * A list of lines containing information about the items the customer intends to purchase.
        */
        public CartQuery lines(BaseCartLineConnectionQueryDefinition queryDef) {
            return lines(args -> {}, queryDef);
        }

        /**
        * A list of lines containing information about the items the customer intends to purchase.
        */
        public CartQuery lines(LinesArgumentsDefinition argsDef, BaseCartLineConnectionQueryDefinition queryDef) {
            startField("lines");

            LinesArguments args = new LinesArguments(_queryBuilder);
            argsDef.define(args);
            LinesArguments.end(args);

            _queryBuilder.append('{');
            queryDef.define(new BaseCartLineConnectionQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        public class MetafieldArguments extends Arguments {
            MetafieldArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            /**
            * The container the metafield belongs to. If omitted, the app-reserved namespace will be used.
            */
            public MetafieldArguments namespace(String value) {
                if (value != null) {
                    startArgument("namespace");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }
        }

        public interface MetafieldArgumentsDefinition {
            void define(MetafieldArguments args);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public CartQuery metafield(String key, MetafieldQueryDefinition queryDef) {
            return metafield(key, args -> {}, queryDef);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public CartQuery metafield(String key, MetafieldArgumentsDefinition argsDef, MetafieldQueryDefinition queryDef) {
            startField("metafield");

            _queryBuilder.append("(key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            argsDef.define(new MetafieldArguments(_queryBuilder));

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */
        public CartQuery metafields(List<HasMetafieldsIdentifier> identifiers, MetafieldQueryDefinition queryDef) {
            startField("metafields");

            _queryBuilder.append("(identifiers:");
            _queryBuilder.append('[');
            {
                String listSeperator1 = "";
                for (HasMetafieldsIdentifier item1 : identifiers) {
                    _queryBuilder.append(listSeperator1);
                    listSeperator1 = ",";
                    item1.appendTo(_queryBuilder);
                }
            }
            _queryBuilder.append(']');

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A note that's associated with the cart. For example, the note can be a personalized message to the
        * buyer.
        */
        public CartQuery note() {
            startField("note");

            return this;
        }

        /**
        * The total number of items in the cart.
        */
        public CartQuery totalQuantity() {
            startField("totalQuantity");

            return this;
        }

        /**
        * The date and time when the cart was updated.
        */
        public CartQuery updatedAt() {
            startField("updatedAt");

            return this;
        }
    }

    /**
    * A cart represents the merchandise that a buyer intends to purchase,
    * and the estimated cost associated with the cart. Learn how to
    * [interact with a
    * cart](https://shopify.dev/custom-storefronts/internationalization/international-pricing)
    * during a customer's session.
    */
    public static class Cart extends AbstractResponse<Cart> implements HasMetafields, MetafieldParentResource, Node {
        public Cart() {
        }

        public Cart(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "appliedGiftCards": {
                        List<AppliedGiftCard> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new AppliedGiftCard(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "attribute": {
                        Attribute optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Attribute(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "attributes": {
                        List<Attribute> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new Attribute(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "buyerIdentity": {
                        responseData.put(key, new CartBuyerIdentity(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "checkoutUrl": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "cost": {
                        responseData.put(key, new CartCost(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "createdAt": {
                        responseData.put(key, Utils.parseDateTime(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "deliveryGroups": {
                        responseData.put(key, new CartDeliveryGroupConnection(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "discountAllocations": {
                        List<CartDiscountAllocation> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(UnknownCartDiscountAllocation.create(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "discountCodes": {
                        List<CartDiscountCode> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartDiscountCode(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "estimatedCost": {
                        responseData.put(key, new CartEstimatedCost(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "lines": {
                        responseData.put(key, new BaseCartLineConnection(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "metafield": {
                        Metafield optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Metafield(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "metafields": {
                        List<Metafield> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            Metafield optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = new Metafield(jsonAsObject(element1, key));
                            }

                            list1.add(optional2);
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "note": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "totalQuantity": {
                        responseData.put(key, jsonAsInteger(field.getValue(), key));

                        break;
                    }

                    case "updatedAt": {
                        responseData.put(key, Utils.parseDateTime(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public Cart(ID id) {
            this();
            optimisticData.put("id", id);
        }

        public String getGraphQlTypeName() {
            return "Cart";
        }

        /**
        * The gift cards that have been applied to the cart.
        */

        public List<AppliedGiftCard> getAppliedGiftCards() {
            return (List<AppliedGiftCard>) get("appliedGiftCards");
        }

        public Cart setAppliedGiftCards(List<AppliedGiftCard> arg) {
            optimisticData.put(getKey("appliedGiftCards"), arg);
            return this;
        }

        /**
        * An attribute associated with the cart.
        */

        public Attribute getAttribute() {
            return (Attribute) get("attribute");
        }

        public Cart setAttribute(Attribute arg) {
            optimisticData.put(getKey("attribute"), arg);
            return this;
        }

        /**
        * The attributes associated with the cart. Attributes are represented as key-value pairs.
        */

        public List<Attribute> getAttributes() {
            return (List<Attribute>) get("attributes");
        }

        public Cart setAttributes(List<Attribute> arg) {
            optimisticData.put(getKey("attributes"), arg);
            return this;
        }

        /**
        * Information about the buyer that's interacting with the cart.
        */

        public CartBuyerIdentity getBuyerIdentity() {
            return (CartBuyerIdentity) get("buyerIdentity");
        }

        public Cart setBuyerIdentity(CartBuyerIdentity arg) {
            optimisticData.put(getKey("buyerIdentity"), arg);
            return this;
        }

        /**
        * The URL of the checkout for the cart.
        */

        public String getCheckoutUrl() {
            return (String) get("checkoutUrl");
        }

        public Cart setCheckoutUrl(String arg) {
            optimisticData.put(getKey("checkoutUrl"), arg);
            return this;
        }

        /**
        * The estimated costs that the buyer will pay at checkout. The costs are subject to change and changes
        * will be reflected at checkout. The `cost` field uses the `buyerIdentity` field to determine
        * [international
        * pricing](https://shopify.dev/custom-storefronts/internationalization/international-pricing).
        */

        public CartCost getCost() {
            return (CartCost) get("cost");
        }

        public Cart setCost(CartCost arg) {
            optimisticData.put(getKey("cost"), arg);
            return this;
        }

        /**
        * The date and time when the cart was created.
        */

        public DateTime getCreatedAt() {
            return (DateTime) get("createdAt");
        }

        public Cart setCreatedAt(DateTime arg) {
            optimisticData.put(getKey("createdAt"), arg);
            return this;
        }

        /**
        * The delivery groups available for the cart, based on the buyer identity default
        * delivery address preference or the default address of the logged-in customer.
        */

        public CartDeliveryGroupConnection getDeliveryGroups() {
            return (CartDeliveryGroupConnection) get("deliveryGroups");
        }

        public Cart setDeliveryGroups(CartDeliveryGroupConnection arg) {
            optimisticData.put(getKey("deliveryGroups"), arg);
            return this;
        }

        /**
        * The discounts that have been applied to the entire cart.
        */

        public List<CartDiscountAllocation> getDiscountAllocations() {
            return (List<CartDiscountAllocation>) get("discountAllocations");
        }

        public Cart setDiscountAllocations(List<CartDiscountAllocation> arg) {
            optimisticData.put(getKey("discountAllocations"), arg);
            return this;
        }

        /**
        * The case-insensitive discount codes that the customer added at checkout.
        */

        public List<CartDiscountCode> getDiscountCodes() {
            return (List<CartDiscountCode>) get("discountCodes");
        }

        public Cart setDiscountCodes(List<CartDiscountCode> arg) {
            optimisticData.put(getKey("discountCodes"), arg);
            return this;
        }

        /**
        * The estimated costs that the buyer will pay at checkout. The estimated costs are subject to change
        * and changes will be reflected at checkout. The `estimatedCost` field uses the `buyerIdentity` field
        * to determine [international
        * pricing](https://shopify.dev/custom-storefronts/internationalization/international-pricing).
        *
        * @deprecated Use `cost` instead.
        */

        public CartEstimatedCost getEstimatedCost() {
            return (CartEstimatedCost) get("estimatedCost");
        }

        public Cart setEstimatedCost(CartEstimatedCost arg) {
            optimisticData.put(getKey("estimatedCost"), arg);
            return this;
        }

        /**
        * A globally-unique ID.
        */

        public ID getId() {
            return (ID) get("id");
        }

        /**
        * A list of lines containing information about the items the customer intends to purchase.
        */

        public BaseCartLineConnection getLines() {
            return (BaseCartLineConnection) get("lines");
        }

        public Cart setLines(BaseCartLineConnection arg) {
            optimisticData.put(getKey("lines"), arg);
            return this;
        }

        /**
        * Returns a metafield found by namespace and key.
        */

        public Metafield getMetafield() {
            return (Metafield) get("metafield");
        }

        public Cart setMetafield(Metafield arg) {
            optimisticData.put(getKey("metafield"), arg);
            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */

        public List<Metafield> getMetafields() {
            return (List<Metafield>) get("metafields");
        }

        public Cart setMetafields(List<Metafield> arg) {
            optimisticData.put(getKey("metafields"), arg);
            return this;
        }

        /**
        * A note that's associated with the cart. For example, the note can be a personalized message to the
        * buyer.
        */

        public String getNote() {
            return (String) get("note");
        }

        public Cart setNote(String arg) {
            optimisticData.put(getKey("note"), arg);
            return this;
        }

        /**
        * The total number of items in the cart.
        */

        public Integer getTotalQuantity() {
            return (Integer) get("totalQuantity");
        }

        public Cart setTotalQuantity(Integer arg) {
            optimisticData.put(getKey("totalQuantity"), arg);
            return this;
        }

        /**
        * The date and time when the cart was updated.
        */

        public DateTime getUpdatedAt() {
            return (DateTime) get("updatedAt");
        }

        public Cart setUpdatedAt(DateTime arg) {
            optimisticData.put(getKey("updatedAt"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "appliedGiftCards": return true;

                case "attribute": return true;

                case "attributes": return true;

                case "buyerIdentity": return true;

                case "checkoutUrl": return false;

                case "cost": return true;

                case "createdAt": return false;

                case "deliveryGroups": return true;

                case "discountAllocations": return false;

                case "discountCodes": return true;

                case "estimatedCost": return true;

                case "id": return false;

                case "lines": return true;

                case "metafield": return true;

                case "metafields": return true;

                case "note": return false;

                case "totalQuantity": return false;

                case "updatedAt": return false;

                default: return false;
            }
        }
    }

    public interface CartAttributesUpdatePayloadQueryDefinition {
        void define(CartAttributesUpdatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `cartAttributesUpdate` mutation.
    */
    public static class CartAttributesUpdatePayloadQuery extends Query<CartAttributesUpdatePayloadQuery> {
        CartAttributesUpdatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The updated cart.
        */
        public CartAttributesUpdatePayloadQuery cart(CartQueryDefinition queryDef) {
            startField("cart");

            _queryBuilder.append('{');
            queryDef.define(new CartQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CartAttributesUpdatePayloadQuery userErrors(CartUserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new CartUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `cartAttributesUpdate` mutation.
    */
    public static class CartAttributesUpdatePayload extends AbstractResponse<CartAttributesUpdatePayload> {
        public CartAttributesUpdatePayload() {
        }

        public CartAttributesUpdatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cart": {
                        Cart optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Cart(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<CartUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartAttributesUpdatePayload";
        }

        /**
        * The updated cart.
        */

        public Cart getCart() {
            return (Cart) get("cart");
        }

        public CartAttributesUpdatePayload setCart(Cart arg) {
            optimisticData.put(getKey("cart"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CartUserError> getUserErrors() {
            return (List<CartUserError>) get("userErrors");
        }

        public CartAttributesUpdatePayload setUserErrors(List<CartUserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cart": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CartAutomaticDiscountAllocationQueryDefinition {
        void define(CartAutomaticDiscountAllocationQuery _queryBuilder);
    }

    /**
    * The discounts automatically applied to the cart line based on prerequisites that have been met.
    */
    public static class CartAutomaticDiscountAllocationQuery extends Query<CartAutomaticDiscountAllocationQuery> {
        CartAutomaticDiscountAllocationQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The discounted amount that has been applied to the cart line.
        */
        public CartAutomaticDiscountAllocationQuery discountedAmount(MoneyV2QueryDefinition queryDef) {
            startField("discountedAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The type of line that the discount is applicable towards.
        */
        public CartAutomaticDiscountAllocationQuery targetType() {
            startField("targetType");

            return this;
        }

        /**
        * The title of the allocated discount.
        */
        public CartAutomaticDiscountAllocationQuery title() {
            startField("title");

            return this;
        }
    }

    /**
    * The discounts automatically applied to the cart line based on prerequisites that have been met.
    */
    public static class CartAutomaticDiscountAllocation extends AbstractResponse<CartAutomaticDiscountAllocation> implements CartDiscountAllocation {
        public CartAutomaticDiscountAllocation() {
        }

        public CartAutomaticDiscountAllocation(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "discountedAmount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "targetType": {
                        responseData.put(key, DiscountApplicationTargetType.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "title": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartAutomaticDiscountAllocation";
        }

        /**
        * The discounted amount that has been applied to the cart line.
        */

        public MoneyV2 getDiscountedAmount() {
            return (MoneyV2) get("discountedAmount");
        }

        public CartAutomaticDiscountAllocation setDiscountedAmount(MoneyV2 arg) {
            optimisticData.put(getKey("discountedAmount"), arg);
            return this;
        }

        /**
        * The type of line that the discount is applicable towards.
        */

        public DiscountApplicationTargetType getTargetType() {
            return (DiscountApplicationTargetType) get("targetType");
        }

        public CartAutomaticDiscountAllocation setTargetType(DiscountApplicationTargetType arg) {
            optimisticData.put(getKey("targetType"), arg);
            return this;
        }

        /**
        * The title of the allocated discount.
        */

        public String getTitle() {
            return (String) get("title");
        }

        public CartAutomaticDiscountAllocation setTitle(String arg) {
            optimisticData.put(getKey("title"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "discountedAmount": return true;

                case "targetType": return false;

                case "title": return false;

                default: return false;
            }
        }
    }

    public interface CartBillingAddressUpdatePayloadQueryDefinition {
        void define(CartBillingAddressUpdatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `cartBillingAddressUpdate` mutation.
    */
    public static class CartBillingAddressUpdatePayloadQuery extends Query<CartBillingAddressUpdatePayloadQuery> {
        CartBillingAddressUpdatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The updated cart.
        */
        public CartBillingAddressUpdatePayloadQuery cart(CartQueryDefinition queryDef) {
            startField("cart");

            _queryBuilder.append('{');
            queryDef.define(new CartQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CartBillingAddressUpdatePayloadQuery userErrors(CartUserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new CartUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `cartBillingAddressUpdate` mutation.
    */
    public static class CartBillingAddressUpdatePayload extends AbstractResponse<CartBillingAddressUpdatePayload> {
        public CartBillingAddressUpdatePayload() {
        }

        public CartBillingAddressUpdatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cart": {
                        Cart optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Cart(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<CartUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartBillingAddressUpdatePayload";
        }

        /**
        * The updated cart.
        */

        public Cart getCart() {
            return (Cart) get("cart");
        }

        public CartBillingAddressUpdatePayload setCart(Cart arg) {
            optimisticData.put(getKey("cart"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CartUserError> getUserErrors() {
            return (List<CartUserError>) get("userErrors");
        }

        public CartBillingAddressUpdatePayload setUserErrors(List<CartUserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cart": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CartBuyerIdentityQueryDefinition {
        void define(CartBuyerIdentityQuery _queryBuilder);
    }

    /**
    * Represents information about the buyer that is interacting with the cart.
    */
    public static class CartBuyerIdentityQuery extends Query<CartBuyerIdentityQuery> {
        CartBuyerIdentityQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The country where the buyer is located.
        */
        public CartBuyerIdentityQuery countryCode() {
            startField("countryCode");

            return this;
        }

        /**
        * The customer account associated with the cart.
        */
        public CartBuyerIdentityQuery customer(CustomerQueryDefinition queryDef) {
            startField("customer");

            _queryBuilder.append('{');
            queryDef.define(new CustomerQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * An ordered set of delivery addresses tied to the buyer that is interacting with the cart.
        * The rank of the preferences is determined by the order of the addresses in the array. Preferences
        * can be used to populate relevant fields in the checkout flow.
        */
        public CartBuyerIdentityQuery deliveryAddressPreferences(DeliveryAddressQueryDefinition queryDef) {
            startField("deliveryAddressPreferences");

            _queryBuilder.append('{');
            queryDef.define(new DeliveryAddressQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The email address of the buyer that's interacting with the cart.
        */
        public CartBuyerIdentityQuery email() {
            startField("email");

            return this;
        }

        /**
        * The phone number of the buyer that's interacting with the cart.
        */
        public CartBuyerIdentityQuery phone() {
            startField("phone");

            return this;
        }

        /**
        * A set of preferences tied to the buyer interacting with the cart. Preferences are used to prefill
        * fields in at checkout to streamline information collection. 
        * Preferences are not synced back to the cart if they are overwritten.
        */
        public CartBuyerIdentityQuery preferences(CartPreferencesQueryDefinition queryDef) {
            startField("preferences");

            _queryBuilder.append('{');
            queryDef.define(new CartPreferencesQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The purchasing company associated with the cart.
        */
        public CartBuyerIdentityQuery purchasingCompany(PurchasingCompanyQueryDefinition queryDef) {
            startField("purchasingCompany");

            _queryBuilder.append('{');
            queryDef.define(new PurchasingCompanyQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Represents information about the buyer that is interacting with the cart.
    */
    public static class CartBuyerIdentity extends AbstractResponse<CartBuyerIdentity> {
        public CartBuyerIdentity() {
        }

        public CartBuyerIdentity(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "countryCode": {
                        CountryCode optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = CountryCode.fromGraphQl(jsonAsString(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customer": {
                        Customer optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Customer(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "deliveryAddressPreferences": {
                        List<DeliveryAddress> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(UnknownDeliveryAddress.create(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "email": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "phone": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "preferences": {
                        CartPreferences optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new CartPreferences(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "purchasingCompany": {
                        PurchasingCompany optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new PurchasingCompany(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartBuyerIdentity";
        }

        /**
        * The country where the buyer is located.
        */

        public CountryCode getCountryCode() {
            return (CountryCode) get("countryCode");
        }

        public CartBuyerIdentity setCountryCode(CountryCode arg) {
            optimisticData.put(getKey("countryCode"), arg);
            return this;
        }

        /**
        * The customer account associated with the cart.
        */

        public Customer getCustomer() {
            return (Customer) get("customer");
        }

        public CartBuyerIdentity setCustomer(Customer arg) {
            optimisticData.put(getKey("customer"), arg);
            return this;
        }

        /**
        * An ordered set of delivery addresses tied to the buyer that is interacting with the cart.
        * The rank of the preferences is determined by the order of the addresses in the array. Preferences
        * can be used to populate relevant fields in the checkout flow.
        */

        public List<DeliveryAddress> getDeliveryAddressPreferences() {
            return (List<DeliveryAddress>) get("deliveryAddressPreferences");
        }

        public CartBuyerIdentity setDeliveryAddressPreferences(List<DeliveryAddress> arg) {
            optimisticData.put(getKey("deliveryAddressPreferences"), arg);
            return this;
        }

        /**
        * The email address of the buyer that's interacting with the cart.
        */

        public String getEmail() {
            return (String) get("email");
        }

        public CartBuyerIdentity setEmail(String arg) {
            optimisticData.put(getKey("email"), arg);
            return this;
        }

        /**
        * The phone number of the buyer that's interacting with the cart.
        */

        public String getPhone() {
            return (String) get("phone");
        }

        public CartBuyerIdentity setPhone(String arg) {
            optimisticData.put(getKey("phone"), arg);
            return this;
        }

        /**
        * A set of preferences tied to the buyer interacting with the cart. Preferences are used to prefill
        * fields in at checkout to streamline information collection. 
        * Preferences are not synced back to the cart if they are overwritten.
        */

        public CartPreferences getPreferences() {
            return (CartPreferences) get("preferences");
        }

        public CartBuyerIdentity setPreferences(CartPreferences arg) {
            optimisticData.put(getKey("preferences"), arg);
            return this;
        }

        /**
        * The purchasing company associated with the cart.
        */

        public PurchasingCompany getPurchasingCompany() {
            return (PurchasingCompany) get("purchasingCompany");
        }

        public CartBuyerIdentity setPurchasingCompany(PurchasingCompany arg) {
            optimisticData.put(getKey("purchasingCompany"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "countryCode": return false;

                case "customer": return true;

                case "deliveryAddressPreferences": return false;

                case "email": return false;

                case "phone": return false;

                case "preferences": return true;

                case "purchasingCompany": return true;

                default: return false;
            }
        }
    }

    public static class CartBuyerIdentityInput implements Serializable {
        private Input<String> email = Input.undefined();

        private Input<String> phone = Input.undefined();

        private Input<ID> companyLocationId = Input.undefined();

        private Input<CountryCode> countryCode = Input.undefined();

        private Input<String> customerAccessToken = Input.undefined();

        private Input<List<DeliveryAddressInput>> deliveryAddressPreferences = Input.undefined();

        private Input<CartPreferencesInput> preferences = Input.undefined();

        public String getEmail() {
            return email.getValue();
        }

        public Input<String> getEmailInput() {
            return email;
        }

        public CartBuyerIdentityInput setEmail(String email) {
            this.email = Input.optional(email);
            return this;
        }

        public CartBuyerIdentityInput setEmailInput(Input<String> email) {
            if (email == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.email = email;
            return this;
        }

        public String getPhone() {
            return phone.getValue();
        }

        public Input<String> getPhoneInput() {
            return phone;
        }

        public CartBuyerIdentityInput setPhone(String phone) {
            this.phone = Input.optional(phone);
            return this;
        }

        public CartBuyerIdentityInput setPhoneInput(Input<String> phone) {
            if (phone == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.phone = phone;
            return this;
        }

        public ID getCompanyLocationId() {
            return companyLocationId.getValue();
        }

        public Input<ID> getCompanyLocationIdInput() {
            return companyLocationId;
        }

        public CartBuyerIdentityInput setCompanyLocationId(ID companyLocationId) {
            this.companyLocationId = Input.optional(companyLocationId);
            return this;
        }

        public CartBuyerIdentityInput setCompanyLocationIdInput(Input<ID> companyLocationId) {
            if (companyLocationId == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.companyLocationId = companyLocationId;
            return this;
        }

        public CountryCode getCountryCode() {
            return countryCode.getValue();
        }

        public Input<CountryCode> getCountryCodeInput() {
            return countryCode;
        }

        public CartBuyerIdentityInput setCountryCode(CountryCode countryCode) {
            this.countryCode = Input.optional(countryCode);
            return this;
        }

        public CartBuyerIdentityInput setCountryCodeInput(Input<CountryCode> countryCode) {
            if (countryCode == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.countryCode = countryCode;
            return this;
        }

        public String getCustomerAccessToken() {
            return customerAccessToken.getValue();
        }

        public Input<String> getCustomerAccessTokenInput() {
            return customerAccessToken;
        }

        public CartBuyerIdentityInput setCustomerAccessToken(String customerAccessToken) {
            this.customerAccessToken = Input.optional(customerAccessToken);
            return this;
        }

        public CartBuyerIdentityInput setCustomerAccessTokenInput(Input<String> customerAccessToken) {
            if (customerAccessToken == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.customerAccessToken = customerAccessToken;
            return this;
        }

        public List<DeliveryAddressInput> getDeliveryAddressPreferences() {
            return deliveryAddressPreferences.getValue();
        }

        public Input<List<DeliveryAddressInput>> getDeliveryAddressPreferencesInput() {
            return deliveryAddressPreferences;
        }

        public CartBuyerIdentityInput setDeliveryAddressPreferences(List<DeliveryAddressInput> deliveryAddressPreferences) {
            this.deliveryAddressPreferences = Input.optional(deliveryAddressPreferences);
            return this;
        }

        public CartBuyerIdentityInput setDeliveryAddressPreferencesInput(Input<List<DeliveryAddressInput>> deliveryAddressPreferences) {
            if (deliveryAddressPreferences == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.deliveryAddressPreferences = deliveryAddressPreferences;
            return this;
        }

        public CartPreferencesInput getPreferences() {
            return preferences.getValue();
        }

        public Input<CartPreferencesInput> getPreferencesInput() {
            return preferences;
        }

        public CartBuyerIdentityInput setPreferences(CartPreferencesInput preferences) {
            this.preferences = Input.optional(preferences);
            return this;
        }

        public CartBuyerIdentityInput setPreferencesInput(Input<CartPreferencesInput> preferences) {
            if (preferences == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.preferences = preferences;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            if (this.email.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("email:");
                if (email.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, email.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.phone.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("phone:");
                if (phone.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, phone.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.companyLocationId.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("companyLocationId:");
                if (companyLocationId.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, companyLocationId.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.countryCode.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("countryCode:");
                if (countryCode.getValue() != null) {
                    _queryBuilder.append(countryCode.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.customerAccessToken.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("customerAccessToken:");
                if (customerAccessToken.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, customerAccessToken.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.deliveryAddressPreferences.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("deliveryAddressPreferences:");
                if (deliveryAddressPreferences.getValue() != null) {
                    _queryBuilder.append('[');
                    {
                        String listSeperator1 = "";
                        for (DeliveryAddressInput item1 : deliveryAddressPreferences.getValue()) {
                            _queryBuilder.append(listSeperator1);
                            listSeperator1 = ",";
                            item1.appendTo(_queryBuilder);
                        }
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.preferences.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("preferences:");
                if (preferences.getValue() != null) {
                    preferences.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    public interface CartBuyerIdentityUpdatePayloadQueryDefinition {
        void define(CartBuyerIdentityUpdatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `cartBuyerIdentityUpdate` mutation.
    */
    public static class CartBuyerIdentityUpdatePayloadQuery extends Query<CartBuyerIdentityUpdatePayloadQuery> {
        CartBuyerIdentityUpdatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The updated cart.
        */
        public CartBuyerIdentityUpdatePayloadQuery cart(CartQueryDefinition queryDef) {
            startField("cart");

            _queryBuilder.append('{');
            queryDef.define(new CartQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CartBuyerIdentityUpdatePayloadQuery userErrors(CartUserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new CartUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `cartBuyerIdentityUpdate` mutation.
    */
    public static class CartBuyerIdentityUpdatePayload extends AbstractResponse<CartBuyerIdentityUpdatePayload> {
        public CartBuyerIdentityUpdatePayload() {
        }

        public CartBuyerIdentityUpdatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cart": {
                        Cart optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Cart(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<CartUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartBuyerIdentityUpdatePayload";
        }

        /**
        * The updated cart.
        */

        public Cart getCart() {
            return (Cart) get("cart");
        }

        public CartBuyerIdentityUpdatePayload setCart(Cart arg) {
            optimisticData.put(getKey("cart"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CartUserError> getUserErrors() {
            return (List<CartUserError>) get("userErrors");
        }

        public CartBuyerIdentityUpdatePayload setUserErrors(List<CartUserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cart": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    /**
    * Represents how credit card details are provided for a direct payment.
    */
    public enum CartCardSource {
        /**
        * The credit card was provided by a third party and vaulted on their system.
        * Using this value requires a separate permission from Shopify.
        */
        SAVED_CREDIT_CARD,

        UNKNOWN_VALUE;

        public static CartCardSource fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "SAVED_CREDIT_CARD": {
                    return SAVED_CREDIT_CARD;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case SAVED_CREDIT_CARD: {
                    return "SAVED_CREDIT_CARD";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface CartCodeDiscountAllocationQueryDefinition {
        void define(CartCodeDiscountAllocationQuery _queryBuilder);
    }

    /**
    * The discount that has been applied to the cart line using a discount code.
    */
    public static class CartCodeDiscountAllocationQuery extends Query<CartCodeDiscountAllocationQuery> {
        CartCodeDiscountAllocationQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The code used to apply the discount.
        */
        public CartCodeDiscountAllocationQuery code() {
            startField("code");

            return this;
        }

        /**
        * The discounted amount that has been applied to the cart line.
        */
        public CartCodeDiscountAllocationQuery discountedAmount(MoneyV2QueryDefinition queryDef) {
            startField("discountedAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The type of line that the discount is applicable towards.
        */
        public CartCodeDiscountAllocationQuery targetType() {
            startField("targetType");

            return this;
        }
    }

    /**
    * The discount that has been applied to the cart line using a discount code.
    */
    public static class CartCodeDiscountAllocation extends AbstractResponse<CartCodeDiscountAllocation> implements CartDiscountAllocation {
        public CartCodeDiscountAllocation() {
        }

        public CartCodeDiscountAllocation(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "code": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "discountedAmount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "targetType": {
                        responseData.put(key, DiscountApplicationTargetType.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartCodeDiscountAllocation";
        }

        /**
        * The code used to apply the discount.
        */

        public String getCode() {
            return (String) get("code");
        }

        public CartCodeDiscountAllocation setCode(String arg) {
            optimisticData.put(getKey("code"), arg);
            return this;
        }

        /**
        * The discounted amount that has been applied to the cart line.
        */

        public MoneyV2 getDiscountedAmount() {
            return (MoneyV2) get("discountedAmount");
        }

        public CartCodeDiscountAllocation setDiscountedAmount(MoneyV2 arg) {
            optimisticData.put(getKey("discountedAmount"), arg);
            return this;
        }

        /**
        * The type of line that the discount is applicable towards.
        */

        public DiscountApplicationTargetType getTargetType() {
            return (DiscountApplicationTargetType) get("targetType");
        }

        public CartCodeDiscountAllocation setTargetType(DiscountApplicationTargetType arg) {
            optimisticData.put(getKey("targetType"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "code": return false;

                case "discountedAmount": return true;

                case "targetType": return false;

                default: return false;
            }
        }
    }

    public interface CartCompletionActionQueryDefinition {
        void define(CartCompletionActionQuery _queryBuilder);
    }

    /**
    * The completion action to checkout a cart.
    */
    public static class CartCompletionActionQuery extends Query<CartCompletionActionQuery> {
        CartCompletionActionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("__typename");
        }

        public CartCompletionActionQuery onCompletePaymentChallenge(CompletePaymentChallengeQueryDefinition queryDef) {
            startInlineFragment("CompletePaymentChallenge");
            queryDef.define(new CompletePaymentChallengeQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }
    }

    public interface CartCompletionAction {
        String getGraphQlTypeName();
    }

    /**
    * The completion action to checkout a cart.
    */
    public static class UnknownCartCompletionAction extends AbstractResponse<UnknownCartCompletionAction> implements CartCompletionAction {
        public UnknownCartCompletionAction() {
        }

        public UnknownCartCompletionAction(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public static CartCompletionAction create(JsonObject fields) throws SchemaViolationError {
            String typeName = fields.getAsJsonPrimitive("__typename").getAsString();
            switch (typeName) {
                case "CompletePaymentChallenge": {
                    return new CompletePaymentChallenge(fields);
                }

                default: {
                    return new UnknownCartCompletionAction(fields);
                }
            }
        }

        public String getGraphQlTypeName() {
            return (String) get("__typename");
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                default: return false;
            }
        }
    }

    public interface CartCompletionActionRequiredQueryDefinition {
        void define(CartCompletionActionRequiredQuery _queryBuilder);
    }

    /**
    * The required completion action to checkout a cart.
    */
    public static class CartCompletionActionRequiredQuery extends Query<CartCompletionActionRequiredQuery> {
        CartCompletionActionRequiredQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The action required to complete the cart completion attempt.
        */
        public CartCompletionActionRequiredQuery action(CartCompletionActionQueryDefinition queryDef) {
            startField("action");

            _queryBuilder.append('{');
            queryDef.define(new CartCompletionActionQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The ID of the cart completion attempt.
        */
        public CartCompletionActionRequiredQuery id() {
            startField("id");

            return this;
        }
    }

    /**
    * The required completion action to checkout a cart.
    */
    public static class CartCompletionActionRequired extends AbstractResponse<CartCompletionActionRequired> implements CartCompletionAttemptResult {
        public CartCompletionActionRequired() {
        }

        public CartCompletionActionRequired(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "action": {
                        CartCompletionAction optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = UnknownCartCompletionAction.create(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "id": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartCompletionActionRequired";
        }

        /**
        * The action required to complete the cart completion attempt.
        */

        public CartCompletionAction getAction() {
            return (CartCompletionAction) get("action");
        }

        public CartCompletionActionRequired setAction(CartCompletionAction arg) {
            optimisticData.put(getKey("action"), arg);
            return this;
        }

        /**
        * The ID of the cart completion attempt.
        */

        public String getId() {
            return (String) get("id");
        }

        public CartCompletionActionRequired setId(String arg) {
            optimisticData.put(getKey("id"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "action": return false;

                case "id": return false;

                default: return false;
            }
        }
    }

    public interface CartCompletionAttemptResultQueryDefinition {
        void define(CartCompletionAttemptResultQuery _queryBuilder);
    }

    /**
    * The result of a cart completion attempt.
    */
    public static class CartCompletionAttemptResultQuery extends Query<CartCompletionAttemptResultQuery> {
        CartCompletionAttemptResultQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("__typename");
        }

        public CartCompletionAttemptResultQuery onCartCompletionActionRequired(CartCompletionActionRequiredQueryDefinition queryDef) {
            startInlineFragment("CartCompletionActionRequired");
            queryDef.define(new CartCompletionActionRequiredQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public CartCompletionAttemptResultQuery onCartCompletionFailed(CartCompletionFailedQueryDefinition queryDef) {
            startInlineFragment("CartCompletionFailed");
            queryDef.define(new CartCompletionFailedQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public CartCompletionAttemptResultQuery onCartCompletionProcessing(CartCompletionProcessingQueryDefinition queryDef) {
            startInlineFragment("CartCompletionProcessing");
            queryDef.define(new CartCompletionProcessingQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public CartCompletionAttemptResultQuery onCartCompletionSuccess(CartCompletionSuccessQueryDefinition queryDef) {
            startInlineFragment("CartCompletionSuccess");
            queryDef.define(new CartCompletionSuccessQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }
    }

    public interface CartCompletionAttemptResult {
        String getGraphQlTypeName();
    }

    /**
    * The result of a cart completion attempt.
    */
    public static class UnknownCartCompletionAttemptResult extends AbstractResponse<UnknownCartCompletionAttemptResult> implements CartCompletionAttemptResult {
        public UnknownCartCompletionAttemptResult() {
        }

        public UnknownCartCompletionAttemptResult(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public static CartCompletionAttemptResult create(JsonObject fields) throws SchemaViolationError {
            String typeName = fields.getAsJsonPrimitive("__typename").getAsString();
            switch (typeName) {
                case "CartCompletionActionRequired": {
                    return new CartCompletionActionRequired(fields);
                }

                case "CartCompletionFailed": {
                    return new CartCompletionFailed(fields);
                }

                case "CartCompletionProcessing": {
                    return new CartCompletionProcessing(fields);
                }

                case "CartCompletionSuccess": {
                    return new CartCompletionSuccess(fields);
                }

                default: {
                    return new UnknownCartCompletionAttemptResult(fields);
                }
            }
        }

        public String getGraphQlTypeName() {
            return (String) get("__typename");
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                default: return false;
            }
        }
    }

    public interface CartCompletionFailedQueryDefinition {
        void define(CartCompletionFailedQuery _queryBuilder);
    }

    /**
    * A failed completion to checkout a cart.
    */
    public static class CartCompletionFailedQuery extends Query<CartCompletionFailedQuery> {
        CartCompletionFailedQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The errors that caused the checkout to fail.
        */
        public CartCompletionFailedQuery errors(CompletionErrorQueryDefinition queryDef) {
            startField("errors");

            _queryBuilder.append('{');
            queryDef.define(new CompletionErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The ID of the cart completion attempt.
        */
        public CartCompletionFailedQuery id() {
            startField("id");

            return this;
        }
    }

    /**
    * A failed completion to checkout a cart.
    */
    public static class CartCompletionFailed extends AbstractResponse<CartCompletionFailed> implements CartCompletionAttemptResult {
        public CartCompletionFailed() {
        }

        public CartCompletionFailed(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "errors": {
                        List<CompletionError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CompletionError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "id": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartCompletionFailed";
        }

        /**
        * The errors that caused the checkout to fail.
        */

        public List<CompletionError> getErrors() {
            return (List<CompletionError>) get("errors");
        }

        public CartCompletionFailed setErrors(List<CompletionError> arg) {
            optimisticData.put(getKey("errors"), arg);
            return this;
        }

        /**
        * The ID of the cart completion attempt.
        */

        public String getId() {
            return (String) get("id");
        }

        public CartCompletionFailed setId(String arg) {
            optimisticData.put(getKey("id"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "errors": return true;

                case "id": return false;

                default: return false;
            }
        }
    }

    public interface CartCompletionProcessingQueryDefinition {
        void define(CartCompletionProcessingQuery _queryBuilder);
    }

    /**
    * A cart checkout completion that's still processing.
    */
    public static class CartCompletionProcessingQuery extends Query<CartCompletionProcessingQuery> {
        CartCompletionProcessingQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The ID of the cart completion attempt.
        */
        public CartCompletionProcessingQuery id() {
            startField("id");

            return this;
        }

        /**
        * The number of milliseconds to wait before polling again.
        */
        public CartCompletionProcessingQuery pollDelay() {
            startField("pollDelay");

            return this;
        }
    }

    /**
    * A cart checkout completion that's still processing.
    */
    public static class CartCompletionProcessing extends AbstractResponse<CartCompletionProcessing> implements CartCompletionAttemptResult {
        public CartCompletionProcessing() {
        }

        public CartCompletionProcessing(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "id": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "pollDelay": {
                        responseData.put(key, jsonAsInteger(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartCompletionProcessing";
        }

        /**
        * The ID of the cart completion attempt.
        */

        public String getId() {
            return (String) get("id");
        }

        public CartCompletionProcessing setId(String arg) {
            optimisticData.put(getKey("id"), arg);
            return this;
        }

        /**
        * The number of milliseconds to wait before polling again.
        */

        public Integer getPollDelay() {
            return (Integer) get("pollDelay");
        }

        public CartCompletionProcessing setPollDelay(Integer arg) {
            optimisticData.put(getKey("pollDelay"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "id": return false;

                case "pollDelay": return false;

                default: return false;
            }
        }
    }

    public interface CartCompletionSuccessQueryDefinition {
        void define(CartCompletionSuccessQuery _queryBuilder);
    }

    /**
    * A successful completion to checkout a cart and a created order.
    */
    public static class CartCompletionSuccessQuery extends Query<CartCompletionSuccessQuery> {
        CartCompletionSuccessQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The date and time when the job completed.
        */
        public CartCompletionSuccessQuery completedAt() {
            startField("completedAt");

            return this;
        }

        /**
        * The ID of the cart completion attempt.
        */
        public CartCompletionSuccessQuery id() {
            startField("id");

            return this;
        }

        /**
        * The ID of the order that's created in Shopify.
        */
        public CartCompletionSuccessQuery orderId() {
            startField("orderId");

            return this;
        }

        /**
        * The URL of the order confirmation in Shopify.
        */
        public CartCompletionSuccessQuery orderUrl() {
            startField("orderUrl");

            return this;
        }
    }

    /**
    * A successful completion to checkout a cart and a created order.
    */
    public static class CartCompletionSuccess extends AbstractResponse<CartCompletionSuccess> implements CartCompletionAttemptResult {
        public CartCompletionSuccess() {
        }

        public CartCompletionSuccess(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "completedAt": {
                        DateTime optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = Utils.parseDateTime(jsonAsString(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "id": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "orderId": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "orderUrl": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartCompletionSuccess";
        }

        /**
        * The date and time when the job completed.
        */

        public DateTime getCompletedAt() {
            return (DateTime) get("completedAt");
        }

        public CartCompletionSuccess setCompletedAt(DateTime arg) {
            optimisticData.put(getKey("completedAt"), arg);
            return this;
        }

        /**
        * The ID of the cart completion attempt.
        */

        public String getId() {
            return (String) get("id");
        }

        public CartCompletionSuccess setId(String arg) {
            optimisticData.put(getKey("id"), arg);
            return this;
        }

        /**
        * The ID of the order that's created in Shopify.
        */

        public ID getOrderId() {
            return (ID) get("orderId");
        }

        public CartCompletionSuccess setOrderId(ID arg) {
            optimisticData.put(getKey("orderId"), arg);
            return this;
        }

        /**
        * The URL of the order confirmation in Shopify.
        */

        public String getOrderUrl() {
            return (String) get("orderUrl");
        }

        public CartCompletionSuccess setOrderUrl(String arg) {
            optimisticData.put(getKey("orderUrl"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "completedAt": return false;

                case "id": return false;

                case "orderId": return false;

                case "orderUrl": return false;

                default: return false;
            }
        }
    }

    public interface CartCostQueryDefinition {
        void define(CartCostQuery _queryBuilder);
    }

    /**
    * The costs that the buyer will pay at checkout.
    * The cart cost uses
    * [`CartBuyerIdentity`](https://shopify.dev/api/storefront/reference/cart/cartbuyeridentity) to
    * determine
    * [international
    * pricing](https://shopify.dev/custom-storefronts/internationalization/international-pricing).
    */
    public static class CartCostQuery extends Query<CartCostQuery> {
        CartCostQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The estimated amount, before taxes and discounts, for the customer to pay at checkout. The checkout
        * charge amount doesn't include any deferred payments that'll be paid at a later date. If the cart has
        * no deferred payments, then the checkout charge amount is equivalent to `subtotalAmount`.
        */
        public CartCostQuery checkoutChargeAmount(MoneyV2QueryDefinition queryDef) {
            startField("checkoutChargeAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The amount, before taxes and cart-level discounts, for the customer to pay.
        */
        public CartCostQuery subtotalAmount(MoneyV2QueryDefinition queryDef) {
            startField("subtotalAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * Whether the subtotal amount is estimated.
        */
        public CartCostQuery subtotalAmountEstimated() {
            startField("subtotalAmountEstimated");

            return this;
        }

        /**
        * The total amount for the customer to pay.
        */
        public CartCostQuery totalAmount(MoneyV2QueryDefinition queryDef) {
            startField("totalAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * Whether the total amount is estimated.
        */
        public CartCostQuery totalAmountEstimated() {
            startField("totalAmountEstimated");

            return this;
        }

        /**
        * The duty amount for the customer to pay at checkout.
        */
        public CartCostQuery totalDutyAmount(MoneyV2QueryDefinition queryDef) {
            startField("totalDutyAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * Whether the total duty amount is estimated.
        */
        public CartCostQuery totalDutyAmountEstimated() {
            startField("totalDutyAmountEstimated");

            return this;
        }

        /**
        * The tax amount for the customer to pay at checkout.
        */
        public CartCostQuery totalTaxAmount(MoneyV2QueryDefinition queryDef) {
            startField("totalTaxAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * Whether the total tax amount is estimated.
        */
        public CartCostQuery totalTaxAmountEstimated() {
            startField("totalTaxAmountEstimated");

            return this;
        }
    }

    /**
    * The costs that the buyer will pay at checkout.
    * The cart cost uses
    * [`CartBuyerIdentity`](https://shopify.dev/api/storefront/reference/cart/cartbuyeridentity) to
    * determine
    * [international
    * pricing](https://shopify.dev/custom-storefronts/internationalization/international-pricing).
    */
    public static class CartCost extends AbstractResponse<CartCost> {
        public CartCost() {
        }

        public CartCost(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "checkoutChargeAmount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "subtotalAmount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "subtotalAmountEstimated": {
                        responseData.put(key, jsonAsBoolean(field.getValue(), key));

                        break;
                    }

                    case "totalAmount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "totalAmountEstimated": {
                        responseData.put(key, jsonAsBoolean(field.getValue(), key));

                        break;
                    }

                    case "totalDutyAmount": {
                        MoneyV2 optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new MoneyV2(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "totalDutyAmountEstimated": {
                        responseData.put(key, jsonAsBoolean(field.getValue(), key));

                        break;
                    }

                    case "totalTaxAmount": {
                        MoneyV2 optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new MoneyV2(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "totalTaxAmountEstimated": {
                        responseData.put(key, jsonAsBoolean(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartCost";
        }

        /**
        * The estimated amount, before taxes and discounts, for the customer to pay at checkout. The checkout
        * charge amount doesn't include any deferred payments that'll be paid at a later date. If the cart has
        * no deferred payments, then the checkout charge amount is equivalent to `subtotalAmount`.
        */

        public MoneyV2 getCheckoutChargeAmount() {
            return (MoneyV2) get("checkoutChargeAmount");
        }

        public CartCost setCheckoutChargeAmount(MoneyV2 arg) {
            optimisticData.put(getKey("checkoutChargeAmount"), arg);
            return this;
        }

        /**
        * The amount, before taxes and cart-level discounts, for the customer to pay.
        */

        public MoneyV2 getSubtotalAmount() {
            return (MoneyV2) get("subtotalAmount");
        }

        public CartCost setSubtotalAmount(MoneyV2 arg) {
            optimisticData.put(getKey("subtotalAmount"), arg);
            return this;
        }

        /**
        * Whether the subtotal amount is estimated.
        */

        public Boolean getSubtotalAmountEstimated() {
            return (Boolean) get("subtotalAmountEstimated");
        }

        public CartCost setSubtotalAmountEstimated(Boolean arg) {
            optimisticData.put(getKey("subtotalAmountEstimated"), arg);
            return this;
        }

        /**
        * The total amount for the customer to pay.
        */

        public MoneyV2 getTotalAmount() {
            return (MoneyV2) get("totalAmount");
        }

        public CartCost setTotalAmount(MoneyV2 arg) {
            optimisticData.put(getKey("totalAmount"), arg);
            return this;
        }

        /**
        * Whether the total amount is estimated.
        */

        public Boolean getTotalAmountEstimated() {
            return (Boolean) get("totalAmountEstimated");
        }

        public CartCost setTotalAmountEstimated(Boolean arg) {
            optimisticData.put(getKey("totalAmountEstimated"), arg);
            return this;
        }

        /**
        * The duty amount for the customer to pay at checkout.
        */

        public MoneyV2 getTotalDutyAmount() {
            return (MoneyV2) get("totalDutyAmount");
        }

        public CartCost setTotalDutyAmount(MoneyV2 arg) {
            optimisticData.put(getKey("totalDutyAmount"), arg);
            return this;
        }

        /**
        * Whether the total duty amount is estimated.
        */

        public Boolean getTotalDutyAmountEstimated() {
            return (Boolean) get("totalDutyAmountEstimated");
        }

        public CartCost setTotalDutyAmountEstimated(Boolean arg) {
            optimisticData.put(getKey("totalDutyAmountEstimated"), arg);
            return this;
        }

        /**
        * The tax amount for the customer to pay at checkout.
        */

        public MoneyV2 getTotalTaxAmount() {
            return (MoneyV2) get("totalTaxAmount");
        }

        public CartCost setTotalTaxAmount(MoneyV2 arg) {
            optimisticData.put(getKey("totalTaxAmount"), arg);
            return this;
        }

        /**
        * Whether the total tax amount is estimated.
        */

        public Boolean getTotalTaxAmountEstimated() {
            return (Boolean) get("totalTaxAmountEstimated");
        }

        public CartCost setTotalTaxAmountEstimated(Boolean arg) {
            optimisticData.put(getKey("totalTaxAmountEstimated"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "checkoutChargeAmount": return true;

                case "subtotalAmount": return true;

                case "subtotalAmountEstimated": return false;

                case "totalAmount": return true;

                case "totalAmountEstimated": return false;

                case "totalDutyAmount": return true;

                case "totalDutyAmountEstimated": return false;

                case "totalTaxAmount": return true;

                case "totalTaxAmountEstimated": return false;

                default: return false;
            }
        }
    }

    public interface CartCreatePayloadQueryDefinition {
        void define(CartCreatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `cartCreate` mutation.
    */
    public static class CartCreatePayloadQuery extends Query<CartCreatePayloadQuery> {
        CartCreatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The new cart.
        */
        public CartCreatePayloadQuery cart(CartQueryDefinition queryDef) {
            startField("cart");

            _queryBuilder.append('{');
            queryDef.define(new CartQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CartCreatePayloadQuery userErrors(CartUserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new CartUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `cartCreate` mutation.
    */
    public static class CartCreatePayload extends AbstractResponse<CartCreatePayload> {
        public CartCreatePayload() {
        }

        public CartCreatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cart": {
                        Cart optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Cart(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<CartUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartCreatePayload";
        }

        /**
        * The new cart.
        */

        public Cart getCart() {
            return (Cart) get("cart");
        }

        public CartCreatePayload setCart(Cart arg) {
            optimisticData.put(getKey("cart"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CartUserError> getUserErrors() {
            return (List<CartUserError>) get("userErrors");
        }

        public CartCreatePayload setUserErrors(List<CartUserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cart": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CartCustomDiscountAllocationQueryDefinition {
        void define(CartCustomDiscountAllocationQuery _queryBuilder);
    }

    /**
    * The discounts automatically applied to the cart line based on prerequisites that have been met.
    */
    public static class CartCustomDiscountAllocationQuery extends Query<CartCustomDiscountAllocationQuery> {
        CartCustomDiscountAllocationQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The discounted amount that has been applied to the cart line.
        */
        public CartCustomDiscountAllocationQuery discountedAmount(MoneyV2QueryDefinition queryDef) {
            startField("discountedAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The type of line that the discount is applicable towards.
        */
        public CartCustomDiscountAllocationQuery targetType() {
            startField("targetType");

            return this;
        }

        /**
        * The title of the allocated discount.
        */
        public CartCustomDiscountAllocationQuery title() {
            startField("title");

            return this;
        }
    }

    /**
    * The discounts automatically applied to the cart line based on prerequisites that have been met.
    */
    public static class CartCustomDiscountAllocation extends AbstractResponse<CartCustomDiscountAllocation> implements CartDiscountAllocation {
        public CartCustomDiscountAllocation() {
        }

        public CartCustomDiscountAllocation(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "discountedAmount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "targetType": {
                        responseData.put(key, DiscountApplicationTargetType.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "title": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartCustomDiscountAllocation";
        }

        /**
        * The discounted amount that has been applied to the cart line.
        */

        public MoneyV2 getDiscountedAmount() {
            return (MoneyV2) get("discountedAmount");
        }

        public CartCustomDiscountAllocation setDiscountedAmount(MoneyV2 arg) {
            optimisticData.put(getKey("discountedAmount"), arg);
            return this;
        }

        /**
        * The type of line that the discount is applicable towards.
        */

        public DiscountApplicationTargetType getTargetType() {
            return (DiscountApplicationTargetType) get("targetType");
        }

        public CartCustomDiscountAllocation setTargetType(DiscountApplicationTargetType arg) {
            optimisticData.put(getKey("targetType"), arg);
            return this;
        }

        /**
        * The title of the allocated discount.
        */

        public String getTitle() {
            return (String) get("title");
        }

        public CartCustomDiscountAllocation setTitle(String arg) {
            optimisticData.put(getKey("title"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "discountedAmount": return true;

                case "targetType": return false;

                case "title": return false;

                default: return false;
            }
        }
    }

    public interface CartDeliveryCoordinatesPreferenceQueryDefinition {
        void define(CartDeliveryCoordinatesPreferenceQuery _queryBuilder);
    }

    /**
    * Preferred location used to find the closest pick up point based on coordinates.
    */
    public static class CartDeliveryCoordinatesPreferenceQuery extends Query<CartDeliveryCoordinatesPreferenceQuery> {
        CartDeliveryCoordinatesPreferenceQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The two-letter code for the country of the preferred location.
        * For example, US.
        */
        public CartDeliveryCoordinatesPreferenceQuery countryCode() {
            startField("countryCode");

            return this;
        }

        /**
        * The geographic latitude for a given location. Coordinates are required in order to set pickUpHandle
        * for pickup points.
        */
        public CartDeliveryCoordinatesPreferenceQuery latitude() {
            startField("latitude");

            return this;
        }

        /**
        * The geographic longitude for a given location. Coordinates are required in order to set pickUpHandle
        * for pickup points.
        */
        public CartDeliveryCoordinatesPreferenceQuery longitude() {
            startField("longitude");

            return this;
        }
    }

    /**
    * Preferred location used to find the closest pick up point based on coordinates.
    */
    public static class CartDeliveryCoordinatesPreference extends AbstractResponse<CartDeliveryCoordinatesPreference> {
        public CartDeliveryCoordinatesPreference() {
        }

        public CartDeliveryCoordinatesPreference(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "countryCode": {
                        responseData.put(key, CountryCode.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "latitude": {
                        responseData.put(key, jsonAsDouble(field.getValue(), key));

                        break;
                    }

                    case "longitude": {
                        responseData.put(key, jsonAsDouble(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartDeliveryCoordinatesPreference";
        }

        /**
        * The two-letter code for the country of the preferred location.
        * For example, US.
        */

        public CountryCode getCountryCode() {
            return (CountryCode) get("countryCode");
        }

        public CartDeliveryCoordinatesPreference setCountryCode(CountryCode arg) {
            optimisticData.put(getKey("countryCode"), arg);
            return this;
        }

        /**
        * The geographic latitude for a given location. Coordinates are required in order to set pickUpHandle
        * for pickup points.
        */

        public Double getLatitude() {
            return (Double) get("latitude");
        }

        public CartDeliveryCoordinatesPreference setLatitude(Double arg) {
            optimisticData.put(getKey("latitude"), arg);
            return this;
        }

        /**
        * The geographic longitude for a given location. Coordinates are required in order to set pickUpHandle
        * for pickup points.
        */

        public Double getLongitude() {
            return (Double) get("longitude");
        }

        public CartDeliveryCoordinatesPreference setLongitude(Double arg) {
            optimisticData.put(getKey("longitude"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "countryCode": return false;

                case "latitude": return false;

                case "longitude": return false;

                default: return false;
            }
        }
    }

    public static class CartDeliveryCoordinatesPreferenceInput implements Serializable {
        private double latitude;

        private double longitude;

        private CountryCode countryCode;

        public CartDeliveryCoordinatesPreferenceInput(double latitude, double longitude, CountryCode countryCode) {
            this.latitude = latitude;

            this.longitude = longitude;

            this.countryCode = countryCode;
        }

        public double getLatitude() {
            return latitude;
        }

        public CartDeliveryCoordinatesPreferenceInput setLatitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public double getLongitude() {
            return longitude;
        }

        public CartDeliveryCoordinatesPreferenceInput setLongitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public CountryCode getCountryCode() {
            return countryCode;
        }

        public CartDeliveryCoordinatesPreferenceInput setCountryCode(CountryCode countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("latitude:");
            _queryBuilder.append(latitude);

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("longitude:");
            _queryBuilder.append(longitude);

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("countryCode:");
            _queryBuilder.append(countryCode.toString());

            _queryBuilder.append('}');
        }
    }

    public interface CartDeliveryGroupQueryDefinition {
        void define(CartDeliveryGroupQuery _queryBuilder);
    }

    /**
    * Information about the options available for one or more line items to be delivered to a specific
    * address.
    */
    public static class CartDeliveryGroupQuery extends Query<CartDeliveryGroupQuery> {
        CartDeliveryGroupQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public class CartLinesArguments extends Arguments {
            CartLinesArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * Returns up to the first `n` elements from the list.
            */
            public CartLinesArguments first(Integer value) {
                if (value != null) {
                    startArgument("first");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come after the specified cursor.
            */
            public CartLinesArguments after(String value) {
                if (value != null) {
                    startArgument("after");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Returns up to the last `n` elements from the list.
            */
            public CartLinesArguments last(Integer value) {
                if (value != null) {
                    startArgument("last");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come before the specified cursor.
            */
            public CartLinesArguments before(String value) {
                if (value != null) {
                    startArgument("before");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Reverse the order of the underlying list.
            */
            public CartLinesArguments reverse(Boolean value) {
                if (value != null) {
                    startArgument("reverse");
                    _queryBuilder.append(value);
                }
                return this;
            }
        }

        public interface CartLinesArgumentsDefinition {
            void define(CartLinesArguments args);
        }

        /**
        * A list of cart lines for the delivery group.
        */
        public CartDeliveryGroupQuery cartLines(BaseCartLineConnectionQueryDefinition queryDef) {
            return cartLines(args -> {}, queryDef);
        }

        /**
        * A list of cart lines for the delivery group.
        */
        public CartDeliveryGroupQuery cartLines(CartLinesArgumentsDefinition argsDef, BaseCartLineConnectionQueryDefinition queryDef) {
            startField("cartLines");

            CartLinesArguments args = new CartLinesArguments(_queryBuilder);
            argsDef.define(args);
            CartLinesArguments.end(args);

            _queryBuilder.append('{');
            queryDef.define(new BaseCartLineConnectionQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The destination address for the delivery group.
        */
        public CartDeliveryGroupQuery deliveryAddress(MailingAddressQueryDefinition queryDef) {
            startField("deliveryAddress");

            _queryBuilder.append('{');
            queryDef.define(new MailingAddressQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The delivery options available for the delivery group.
        */
        public CartDeliveryGroupQuery deliveryOptions(CartDeliveryOptionQueryDefinition queryDef) {
            startField("deliveryOptions");

            _queryBuilder.append('{');
            queryDef.define(new CartDeliveryOptionQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The type of merchandise in the delivery group.
        */
        public CartDeliveryGroupQuery groupType() {
            startField("groupType");

            return this;
        }

        /**
        * The ID for the delivery group.
        */
        public CartDeliveryGroupQuery id() {
            startField("id");

            return this;
        }

        /**
        * The selected delivery option for the delivery group.
        */
        public CartDeliveryGroupQuery selectedDeliveryOption(CartDeliveryOptionQueryDefinition queryDef) {
            startField("selectedDeliveryOption");

            _queryBuilder.append('{');
            queryDef.define(new CartDeliveryOptionQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Information about the options available for one or more line items to be delivered to a specific
    * address.
    */
    public static class CartDeliveryGroup extends AbstractResponse<CartDeliveryGroup> {
        public CartDeliveryGroup() {
        }

        public CartDeliveryGroup(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cartLines": {
                        responseData.put(key, new BaseCartLineConnection(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "deliveryAddress": {
                        responseData.put(key, new MailingAddress(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "deliveryOptions": {
                        List<CartDeliveryOption> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartDeliveryOption(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "groupType": {
                        responseData.put(key, CartDeliveryGroupType.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "selectedDeliveryOption": {
                        CartDeliveryOption optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new CartDeliveryOption(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartDeliveryGroup";
        }

        /**
        * A list of cart lines for the delivery group.
        */

        public BaseCartLineConnection getCartLines() {
            return (BaseCartLineConnection) get("cartLines");
        }

        public CartDeliveryGroup setCartLines(BaseCartLineConnection arg) {
            optimisticData.put(getKey("cartLines"), arg);
            return this;
        }

        /**
        * The destination address for the delivery group.
        */

        public MailingAddress getDeliveryAddress() {
            return (MailingAddress) get("deliveryAddress");
        }

        public CartDeliveryGroup setDeliveryAddress(MailingAddress arg) {
            optimisticData.put(getKey("deliveryAddress"), arg);
            return this;
        }

        /**
        * The delivery options available for the delivery group.
        */

        public List<CartDeliveryOption> getDeliveryOptions() {
            return (List<CartDeliveryOption>) get("deliveryOptions");
        }

        public CartDeliveryGroup setDeliveryOptions(List<CartDeliveryOption> arg) {
            optimisticData.put(getKey("deliveryOptions"), arg);
            return this;
        }

        /**
        * The type of merchandise in the delivery group.
        */

        public CartDeliveryGroupType getGroupType() {
            return (CartDeliveryGroupType) get("groupType");
        }

        public CartDeliveryGroup setGroupType(CartDeliveryGroupType arg) {
            optimisticData.put(getKey("groupType"), arg);
            return this;
        }

        /**
        * The ID for the delivery group.
        */

        public ID getId() {
            return (ID) get("id");
        }

        public CartDeliveryGroup setId(ID arg) {
            optimisticData.put(getKey("id"), arg);
            return this;
        }

        /**
        * The selected delivery option for the delivery group.
        */

        public CartDeliveryOption getSelectedDeliveryOption() {
            return (CartDeliveryOption) get("selectedDeliveryOption");
        }

        public CartDeliveryGroup setSelectedDeliveryOption(CartDeliveryOption arg) {
            optimisticData.put(getKey("selectedDeliveryOption"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cartLines": return true;

                case "deliveryAddress": return true;

                case "deliveryOptions": return true;

                case "groupType": return false;

                case "id": return false;

                case "selectedDeliveryOption": return true;

                default: return false;
            }
        }
    }

    public interface CartDeliveryGroupConnectionQueryDefinition {
        void define(CartDeliveryGroupConnectionQuery _queryBuilder);
    }

    /**
    * An auto-generated type for paginating through multiple CartDeliveryGroups.
    */
    public static class CartDeliveryGroupConnectionQuery extends Query<CartDeliveryGroupConnectionQuery> {
        CartDeliveryGroupConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A list of edges.
        */
        public CartDeliveryGroupConnectionQuery edges(CartDeliveryGroupEdgeQueryDefinition queryDef) {
            startField("edges");

            _queryBuilder.append('{');
            queryDef.define(new CartDeliveryGroupEdgeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A list of the nodes contained in CartDeliveryGroupEdge.
        */
        public CartDeliveryGroupConnectionQuery nodes(CartDeliveryGroupQueryDefinition queryDef) {
            startField("nodes");

            _queryBuilder.append('{');
            queryDef.define(new CartDeliveryGroupQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * Information to aid in pagination.
        */
        public CartDeliveryGroupConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            startField("pageInfo");

            _queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type for paginating through multiple CartDeliveryGroups.
    */
    public static class CartDeliveryGroupConnection extends AbstractResponse<CartDeliveryGroupConnection> {
        public CartDeliveryGroupConnection() {
        }

        public CartDeliveryGroupConnection(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "edges": {
                        List<CartDeliveryGroupEdge> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartDeliveryGroupEdge(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "nodes": {
                        List<CartDeliveryGroup> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartDeliveryGroup(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "pageInfo": {
                        responseData.put(key, new PageInfo(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartDeliveryGroupConnection";
        }

        /**
        * A list of edges.
        */

        public List<CartDeliveryGroupEdge> getEdges() {
            return (List<CartDeliveryGroupEdge>) get("edges");
        }

        public CartDeliveryGroupConnection setEdges(List<CartDeliveryGroupEdge> arg) {
            optimisticData.put(getKey("edges"), arg);
            return this;
        }

        /**
        * A list of the nodes contained in CartDeliveryGroupEdge.
        */

        public List<CartDeliveryGroup> getNodes() {
            return (List<CartDeliveryGroup>) get("nodes");
        }

        public CartDeliveryGroupConnection setNodes(List<CartDeliveryGroup> arg) {
            optimisticData.put(getKey("nodes"), arg);
            return this;
        }

        /**
        * Information to aid in pagination.
        */

        public PageInfo getPageInfo() {
            return (PageInfo) get("pageInfo");
        }

        public CartDeliveryGroupConnection setPageInfo(PageInfo arg) {
            optimisticData.put(getKey("pageInfo"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "edges": return true;

                case "nodes": return true;

                case "pageInfo": return true;

                default: return false;
            }
        }
    }

    public interface CartDeliveryGroupEdgeQueryDefinition {
        void define(CartDeliveryGroupEdgeQuery _queryBuilder);
    }

    /**
    * An auto-generated type which holds one CartDeliveryGroup and a cursor during pagination.
    */
    public static class CartDeliveryGroupEdgeQuery extends Query<CartDeliveryGroupEdgeQuery> {
        CartDeliveryGroupEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A cursor for use in pagination.
        */
        public CartDeliveryGroupEdgeQuery cursor() {
            startField("cursor");

            return this;
        }

        /**
        * The item at the end of CartDeliveryGroupEdge.
        */
        public CartDeliveryGroupEdgeQuery node(CartDeliveryGroupQueryDefinition queryDef) {
            startField("node");

            _queryBuilder.append('{');
            queryDef.define(new CartDeliveryGroupQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type which holds one CartDeliveryGroup and a cursor during pagination.
    */
    public static class CartDeliveryGroupEdge extends AbstractResponse<CartDeliveryGroupEdge> {
        public CartDeliveryGroupEdge() {
        }

        public CartDeliveryGroupEdge(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cursor": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "node": {
                        responseData.put(key, new CartDeliveryGroup(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartDeliveryGroupEdge";
        }

        /**
        * A cursor for use in pagination.
        */

        public String getCursor() {
            return (String) get("cursor");
        }

        public CartDeliveryGroupEdge setCursor(String arg) {
            optimisticData.put(getKey("cursor"), arg);
            return this;
        }

        /**
        * The item at the end of CartDeliveryGroupEdge.
        */

        public CartDeliveryGroup getNode() {
            return (CartDeliveryGroup) get("node");
        }

        public CartDeliveryGroupEdge setNode(CartDeliveryGroup arg) {
            optimisticData.put(getKey("node"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cursor": return false;

                case "node": return true;

                default: return false;
            }
        }
    }

    /**
    * Defines what type of merchandise is in the delivery group.
    */
    public enum CartDeliveryGroupType {
        /**
        * The delivery group only contains merchandise that is either a one time purchase or a first delivery
        * of
        * subscription merchandise.
        */
        ONE_TIME_PURCHASE,

        /**
        * The delivery group only contains subscription merchandise.
        */
        SUBSCRIPTION,

        UNKNOWN_VALUE;

        public static CartDeliveryGroupType fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "ONE_TIME_PURCHASE": {
                    return ONE_TIME_PURCHASE;
                }

                case "SUBSCRIPTION": {
                    return SUBSCRIPTION;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case ONE_TIME_PURCHASE: {
                    return "ONE_TIME_PURCHASE";
                }

                case SUBSCRIPTION: {
                    return "SUBSCRIPTION";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface CartDeliveryOptionQueryDefinition {
        void define(CartDeliveryOptionQuery _queryBuilder);
    }

    /**
    * Information about a delivery option.
    */
    public static class CartDeliveryOptionQuery extends Query<CartDeliveryOptionQuery> {
        CartDeliveryOptionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The code of the delivery option.
        */
        public CartDeliveryOptionQuery code() {
            startField("code");

            return this;
        }

        /**
        * The method for the delivery option.
        */
        public CartDeliveryOptionQuery deliveryMethodType() {
            startField("deliveryMethodType");

            return this;
        }

        /**
        * The description of the delivery option.
        */
        public CartDeliveryOptionQuery description() {
            startField("description");

            return this;
        }

        /**
        * The estimated cost for the delivery option.
        */
        public CartDeliveryOptionQuery estimatedCost(MoneyV2QueryDefinition queryDef) {
            startField("estimatedCost");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The unique identifier of the delivery option.
        */
        public CartDeliveryOptionQuery handle() {
            startField("handle");

            return this;
        }

        /**
        * The title of the delivery option.
        */
        public CartDeliveryOptionQuery title() {
            startField("title");

            return this;
        }
    }

    /**
    * Information about a delivery option.
    */
    public static class CartDeliveryOption extends AbstractResponse<CartDeliveryOption> {
        public CartDeliveryOption() {
        }

        public CartDeliveryOption(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "code": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "deliveryMethodType": {
                        responseData.put(key, DeliveryMethodType.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "description": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "estimatedCost": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "handle": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "title": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartDeliveryOption";
        }

        /**
        * The code of the delivery option.
        */

        public String getCode() {
            return (String) get("code");
        }

        public CartDeliveryOption setCode(String arg) {
            optimisticData.put(getKey("code"), arg);
            return this;
        }

        /**
        * The method for the delivery option.
        */

        public DeliveryMethodType getDeliveryMethodType() {
            return (DeliveryMethodType) get("deliveryMethodType");
        }

        public CartDeliveryOption setDeliveryMethodType(DeliveryMethodType arg) {
            optimisticData.put(getKey("deliveryMethodType"), arg);
            return this;
        }

        /**
        * The description of the delivery option.
        */

        public String getDescription() {
            return (String) get("description");
        }

        public CartDeliveryOption setDescription(String arg) {
            optimisticData.put(getKey("description"), arg);
            return this;
        }

        /**
        * The estimated cost for the delivery option.
        */

        public MoneyV2 getEstimatedCost() {
            return (MoneyV2) get("estimatedCost");
        }

        public CartDeliveryOption setEstimatedCost(MoneyV2 arg) {
            optimisticData.put(getKey("estimatedCost"), arg);
            return this;
        }

        /**
        * The unique identifier of the delivery option.
        */

        public String getHandle() {
            return (String) get("handle");
        }

        public CartDeliveryOption setHandle(String arg) {
            optimisticData.put(getKey("handle"), arg);
            return this;
        }

        /**
        * The title of the delivery option.
        */

        public String getTitle() {
            return (String) get("title");
        }

        public CartDeliveryOption setTitle(String arg) {
            optimisticData.put(getKey("title"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "code": return false;

                case "deliveryMethodType": return false;

                case "description": return false;

                case "estimatedCost": return true;

                case "handle": return false;

                case "title": return false;

                default: return false;
            }
        }
    }

    public interface CartDeliveryPreferenceQueryDefinition {
        void define(CartDeliveryPreferenceQuery _queryBuilder);
    }

    /**
    * A set of preferences tied to the buyer interacting with the cart. Preferences are used to prefill
    * fields in at checkout to streamline information collection. 
    * Preferences are not synced back to the cart if they are overwritten.
    */
    public static class CartDeliveryPreferenceQuery extends Query<CartDeliveryPreferenceQuery> {
        CartDeliveryPreferenceQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * Preferred location used to find the closest pick up point based on coordinates.
        */
        public CartDeliveryPreferenceQuery coordinates(CartDeliveryCoordinatesPreferenceQueryDefinition queryDef) {
            startField("coordinates");

            _queryBuilder.append('{');
            queryDef.define(new CartDeliveryCoordinatesPreferenceQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The preferred delivery methods such as shipping, local pickup or through pickup points.
        */
        public CartDeliveryPreferenceQuery deliveryMethod() {
            startField("deliveryMethod");

            return this;
        }

        /**
        * The pickup handle prefills checkout fields with the location for either local pickup or pickup
        * points delivery methods.
        * It accepts both location ID for local pickup and external IDs for pickup points.
        */
        public CartDeliveryPreferenceQuery pickupHandle() {
            startField("pickupHandle");

            return this;
        }
    }

    /**
    * A set of preferences tied to the buyer interacting with the cart. Preferences are used to prefill
    * fields in at checkout to streamline information collection. 
    * Preferences are not synced back to the cart if they are overwritten.
    */
    public static class CartDeliveryPreference extends AbstractResponse<CartDeliveryPreference> {
        public CartDeliveryPreference() {
        }

        public CartDeliveryPreference(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "coordinates": {
                        CartDeliveryCoordinatesPreference optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new CartDeliveryCoordinatesPreference(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "deliveryMethod": {
                        List<PreferenceDeliveryMethodType> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(PreferenceDeliveryMethodType.fromGraphQl(jsonAsString(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "pickupHandle": {
                        List<String> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(jsonAsString(element1, key));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartDeliveryPreference";
        }

        /**
        * Preferred location used to find the closest pick up point based on coordinates.
        */

        public CartDeliveryCoordinatesPreference getCoordinates() {
            return (CartDeliveryCoordinatesPreference) get("coordinates");
        }

        public CartDeliveryPreference setCoordinates(CartDeliveryCoordinatesPreference arg) {
            optimisticData.put(getKey("coordinates"), arg);
            return this;
        }

        /**
        * The preferred delivery methods such as shipping, local pickup or through pickup points.
        */

        public List<PreferenceDeliveryMethodType> getDeliveryMethod() {
            return (List<PreferenceDeliveryMethodType>) get("deliveryMethod");
        }

        public CartDeliveryPreference setDeliveryMethod(List<PreferenceDeliveryMethodType> arg) {
            optimisticData.put(getKey("deliveryMethod"), arg);
            return this;
        }

        /**
        * The pickup handle prefills checkout fields with the location for either local pickup or pickup
        * points delivery methods.
        * It accepts both location ID for local pickup and external IDs for pickup points.
        */

        public List<String> getPickupHandle() {
            return (List<String>) get("pickupHandle");
        }

        public CartDeliveryPreference setPickupHandle(List<String> arg) {
            optimisticData.put(getKey("pickupHandle"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "coordinates": return true;

                case "deliveryMethod": return false;

                case "pickupHandle": return false;

                default: return false;
            }
        }
    }

    public static class CartDeliveryPreferenceInput implements Serializable {
        private Input<List<PreferenceDeliveryMethodType>> deliveryMethod = Input.undefined();

        private Input<List<String>> pickupHandle = Input.undefined();

        private Input<List<CartDeliveryCoordinatesPreferenceInput>> coordinates = Input.undefined();

        public List<PreferenceDeliveryMethodType> getDeliveryMethod() {
            return deliveryMethod.getValue();
        }

        public Input<List<PreferenceDeliveryMethodType>> getDeliveryMethodInput() {
            return deliveryMethod;
        }

        public CartDeliveryPreferenceInput setDeliveryMethod(List<PreferenceDeliveryMethodType> deliveryMethod) {
            this.deliveryMethod = Input.optional(deliveryMethod);
            return this;
        }

        public CartDeliveryPreferenceInput setDeliveryMethodInput(Input<List<PreferenceDeliveryMethodType>> deliveryMethod) {
            if (deliveryMethod == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.deliveryMethod = deliveryMethod;
            return this;
        }

        public List<String> getPickupHandle() {
            return pickupHandle.getValue();
        }

        public Input<List<String>> getPickupHandleInput() {
            return pickupHandle;
        }

        public CartDeliveryPreferenceInput setPickupHandle(List<String> pickupHandle) {
            this.pickupHandle = Input.optional(pickupHandle);
            return this;
        }

        public CartDeliveryPreferenceInput setPickupHandleInput(Input<List<String>> pickupHandle) {
            if (pickupHandle == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.pickupHandle = pickupHandle;
            return this;
        }

        public List<CartDeliveryCoordinatesPreferenceInput> getCoordinates() {
            return coordinates.getValue();
        }

        public Input<List<CartDeliveryCoordinatesPreferenceInput>> getCoordinatesInput() {
            return coordinates;
        }

        public CartDeliveryPreferenceInput setCoordinates(List<CartDeliveryCoordinatesPreferenceInput> coordinates) {
            this.coordinates = Input.optional(coordinates);
            return this;
        }

        public CartDeliveryPreferenceInput setCoordinatesInput(Input<List<CartDeliveryCoordinatesPreferenceInput>> coordinates) {
            if (coordinates == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.coordinates = coordinates;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            if (this.deliveryMethod.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("deliveryMethod:");
                if (deliveryMethod.getValue() != null) {
                    _queryBuilder.append('[');
                    {
                        String listSeperator1 = "";
                        for (PreferenceDeliveryMethodType item1 : deliveryMethod.getValue()) {
                            _queryBuilder.append(listSeperator1);
                            listSeperator1 = ",";
                            _queryBuilder.append(item1.toString());
                        }
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.pickupHandle.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("pickupHandle:");
                if (pickupHandle.getValue() != null) {
                    _queryBuilder.append('[');
                    {
                        String listSeperator1 = "";
                        for (String item1 : pickupHandle.getValue()) {
                            _queryBuilder.append(listSeperator1);
                            listSeperator1 = ",";
                            Query.appendQuotedString(_queryBuilder, item1.toString());
                        }
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.coordinates.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("coordinates:");
                if (coordinates.getValue() != null) {
                    _queryBuilder.append('[');
                    {
                        String listSeperator1 = "";
                        for (CartDeliveryCoordinatesPreferenceInput item1 : coordinates.getValue()) {
                            _queryBuilder.append(listSeperator1);
                            listSeperator1 = ",";
                            item1.appendTo(_queryBuilder);
                        }
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    public static class CartDirectPaymentMethodInput implements Serializable {
        private MailingAddressInput billingAddress;

        private String sessionId;

        private Input<CartCardSource> cardSource = Input.undefined();

        public CartDirectPaymentMethodInput(MailingAddressInput billingAddress, String sessionId) {
            this.billingAddress = billingAddress;

            this.sessionId = sessionId;
        }

        public MailingAddressInput getBillingAddress() {
            return billingAddress;
        }

        public CartDirectPaymentMethodInput setBillingAddress(MailingAddressInput billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public String getSessionId() {
            return sessionId;
        }

        public CartDirectPaymentMethodInput setSessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public CartCardSource getCardSource() {
            return cardSource.getValue();
        }

        public Input<CartCardSource> getCardSourceInput() {
            return cardSource;
        }

        public CartDirectPaymentMethodInput setCardSource(CartCardSource cardSource) {
            this.cardSource = Input.optional(cardSource);
            return this;
        }

        public CartDirectPaymentMethodInput setCardSourceInput(Input<CartCardSource> cardSource) {
            if (cardSource == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.cardSource = cardSource;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("billingAddress:");
            billingAddress.appendTo(_queryBuilder);

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("sessionId:");
            Query.appendQuotedString(_queryBuilder, sessionId.toString());

            if (this.cardSource.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("cardSource:");
                if (cardSource.getValue() != null) {
                    _queryBuilder.append(cardSource.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    public interface CartDiscountAllocationQueryDefinition {
        void define(CartDiscountAllocationQuery _queryBuilder);
    }

    /**
    * The discounts that have been applied to the cart line.
    */
    public static class CartDiscountAllocationQuery extends Query<CartDiscountAllocationQuery> {
        CartDiscountAllocationQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("__typename");
        }

        /**
        * The discounted amount that has been applied to the cart line.
        */
        public CartDiscountAllocationQuery discountedAmount(MoneyV2QueryDefinition queryDef) {
            startField("discountedAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The type of line that the discount is applicable towards.
        */
        public CartDiscountAllocationQuery targetType() {
            startField("targetType");

            return this;
        }

        public CartDiscountAllocationQuery onCartAutomaticDiscountAllocation(CartAutomaticDiscountAllocationQueryDefinition queryDef) {
            startInlineFragment("CartAutomaticDiscountAllocation");
            queryDef.define(new CartAutomaticDiscountAllocationQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public CartDiscountAllocationQuery onCartCodeDiscountAllocation(CartCodeDiscountAllocationQueryDefinition queryDef) {
            startInlineFragment("CartCodeDiscountAllocation");
            queryDef.define(new CartCodeDiscountAllocationQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public CartDiscountAllocationQuery onCartCustomDiscountAllocation(CartCustomDiscountAllocationQueryDefinition queryDef) {
            startInlineFragment("CartCustomDiscountAllocation");
            queryDef.define(new CartCustomDiscountAllocationQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }
    }

    public interface CartDiscountAllocation {
        String getGraphQlTypeName();

        MoneyV2 getDiscountedAmount();

        DiscountApplicationTargetType getTargetType();
    }

    /**
    * The discounts that have been applied to the cart line.
    */
    public static class UnknownCartDiscountAllocation extends AbstractResponse<UnknownCartDiscountAllocation> implements CartDiscountAllocation {
        public UnknownCartDiscountAllocation() {
        }

        public UnknownCartDiscountAllocation(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "discountedAmount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "targetType": {
                        responseData.put(key, DiscountApplicationTargetType.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public static CartDiscountAllocation create(JsonObject fields) throws SchemaViolationError {
            String typeName = fields.getAsJsonPrimitive("__typename").getAsString();
            switch (typeName) {
                case "CartAutomaticDiscountAllocation": {
                    return new CartAutomaticDiscountAllocation(fields);
                }

                case "CartCodeDiscountAllocation": {
                    return new CartCodeDiscountAllocation(fields);
                }

                case "CartCustomDiscountAllocation": {
                    return new CartCustomDiscountAllocation(fields);
                }

                default: {
                    return new UnknownCartDiscountAllocation(fields);
                }
            }
        }

        public String getGraphQlTypeName() {
            return (String) get("__typename");
        }

        /**
        * The discounted amount that has been applied to the cart line.
        */

        public MoneyV2 getDiscountedAmount() {
            return (MoneyV2) get("discountedAmount");
        }

        public UnknownCartDiscountAllocation setDiscountedAmount(MoneyV2 arg) {
            optimisticData.put(getKey("discountedAmount"), arg);
            return this;
        }

        /**
        * The type of line that the discount is applicable towards.
        */

        public DiscountApplicationTargetType getTargetType() {
            return (DiscountApplicationTargetType) get("targetType");
        }

        public UnknownCartDiscountAllocation setTargetType(DiscountApplicationTargetType arg) {
            optimisticData.put(getKey("targetType"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "discountedAmount": return true;

                case "targetType": return false;

                default: return false;
            }
        }
    }

    public interface CartDiscountCodeQueryDefinition {
        void define(CartDiscountCodeQuery _queryBuilder);
    }

    /**
    * The discount codes applied to the cart.
    */
    public static class CartDiscountCodeQuery extends Query<CartDiscountCodeQuery> {
        CartDiscountCodeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * Whether the discount code is applicable to the cart's current contents.
        */
        public CartDiscountCodeQuery applicable() {
            startField("applicable");

            return this;
        }

        /**
        * The code for the discount.
        */
        public CartDiscountCodeQuery code() {
            startField("code");

            return this;
        }
    }

    /**
    * The discount codes applied to the cart.
    */
    public static class CartDiscountCode extends AbstractResponse<CartDiscountCode> {
        public CartDiscountCode() {
        }

        public CartDiscountCode(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "applicable": {
                        responseData.put(key, jsonAsBoolean(field.getValue(), key));

                        break;
                    }

                    case "code": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartDiscountCode";
        }

        /**
        * Whether the discount code is applicable to the cart's current contents.
        */

        public Boolean getApplicable() {
            return (Boolean) get("applicable");
        }

        public CartDiscountCode setApplicable(Boolean arg) {
            optimisticData.put(getKey("applicable"), arg);
            return this;
        }

        /**
        * The code for the discount.
        */

        public String getCode() {
            return (String) get("code");
        }

        public CartDiscountCode setCode(String arg) {
            optimisticData.put(getKey("code"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "applicable": return false;

                case "code": return false;

                default: return false;
            }
        }
    }

    public interface CartDiscountCodesUpdatePayloadQueryDefinition {
        void define(CartDiscountCodesUpdatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `cartDiscountCodesUpdate` mutation.
    */
    public static class CartDiscountCodesUpdatePayloadQuery extends Query<CartDiscountCodesUpdatePayloadQuery> {
        CartDiscountCodesUpdatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The updated cart.
        */
        public CartDiscountCodesUpdatePayloadQuery cart(CartQueryDefinition queryDef) {
            startField("cart");

            _queryBuilder.append('{');
            queryDef.define(new CartQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CartDiscountCodesUpdatePayloadQuery userErrors(CartUserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new CartUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `cartDiscountCodesUpdate` mutation.
    */
    public static class CartDiscountCodesUpdatePayload extends AbstractResponse<CartDiscountCodesUpdatePayload> {
        public CartDiscountCodesUpdatePayload() {
        }

        public CartDiscountCodesUpdatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cart": {
                        Cart optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Cart(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<CartUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartDiscountCodesUpdatePayload";
        }

        /**
        * The updated cart.
        */

        public Cart getCart() {
            return (Cart) get("cart");
        }

        public CartDiscountCodesUpdatePayload setCart(Cart arg) {
            optimisticData.put(getKey("cart"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CartUserError> getUserErrors() {
            return (List<CartUserError>) get("userErrors");
        }

        public CartDiscountCodesUpdatePayload setUserErrors(List<CartUserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cart": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    /**
    * Possible error codes that can be returned by `CartUserError`.
    */
    public enum CartErrorCode {
        /**
        * The specified address field contains emojis.
        */
        ADDRESS_FIELD_CONTAINS_EMOJIS,

        /**
        * The specified address field contains HTML tags.
        */
        ADDRESS_FIELD_CONTAINS_HTML_TAGS,

        /**
        * The specified address field contains a URL.
        */
        ADDRESS_FIELD_CONTAINS_URL,

        /**
        * The specified address field does not match the expected pattern.
        */
        ADDRESS_FIELD_DOES_NOT_MATCH_EXPECTED_PATTERN,

        /**
        * The specified address field is required.
        */
        ADDRESS_FIELD_IS_REQUIRED,

        /**
        * The specified address field is too long.
        */
        ADDRESS_FIELD_IS_TOO_LONG,

        /**
        * The input value is invalid.
        */
        INVALID,

        /**
        * Company location not found or not allowed.
        */
        INVALID_COMPANY_LOCATION,

        /**
        * Delivery group was not found in cart.
        */
        INVALID_DELIVERY_GROUP,

        /**
        * Delivery option was not valid.
        */
        INVALID_DELIVERY_OPTION,

        /**
        * The quantity must be a multiple of the specified increment.
        */
        INVALID_INCREMENT,

        /**
        * Merchandise line was not found in cart.
        */
        INVALID_MERCHANDISE_LINE,

        /**
        * The metafields were not valid.
        */
        INVALID_METAFIELDS,

        /**
        * The payment wasn't valid.
        */
        INVALID_PAYMENT,

        /**
        * Cannot update payment on an empty cart
        */
        INVALID_PAYMENT_EMPTY_CART,

        /**
        * The given zip code is invalid for the provided country.
        */
        INVALID_ZIP_CODE_FOR_COUNTRY,

        /**
        * The given zip code is invalid for the provided province.
        */
        INVALID_ZIP_CODE_FOR_PROVINCE,

        /**
        * The input value should be less than the maximum value allowed.
        */
        LESS_THAN,

        /**
        * The quantity must be below the specified maximum for the item.
        */
        MAXIMUM_EXCEEDED,

        /**
        * The quantity must be above the specified minimum for the item.
        */
        MINIMUM_NOT_MET,

        /**
        * The customer access token is required when setting a company location.
        */
        MISSING_CUSTOMER_ACCESS_TOKEN,

        /**
        * Missing discount code.
        */
        MISSING_DISCOUNT_CODE,

        /**
        * Missing note.
        */
        MISSING_NOTE,

        /**
        * The note length must be below the specified maximum.
        */
        NOTE_TOO_LONG,

        /**
        * The payment method is not supported.
        */
        PAYMENT_METHOD_NOT_SUPPORTED,

        /**
        * The given province cannot be found.
        */
        PROVINCE_NOT_FOUND,

        /**
        * A general error occurred during address validation.
        */
        UNSPECIFIED_ADDRESS_ERROR,

        /**
        * Validation failed.
        */
        VALIDATION_CUSTOM,

        /**
        * The given zip code is unsupported.
        */
        ZIP_CODE_NOT_SUPPORTED,

        UNKNOWN_VALUE;

        public static CartErrorCode fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "ADDRESS_FIELD_CONTAINS_EMOJIS": {
                    return ADDRESS_FIELD_CONTAINS_EMOJIS;
                }

                case "ADDRESS_FIELD_CONTAINS_HTML_TAGS": {
                    return ADDRESS_FIELD_CONTAINS_HTML_TAGS;
                }

                case "ADDRESS_FIELD_CONTAINS_URL": {
                    return ADDRESS_FIELD_CONTAINS_URL;
                }

                case "ADDRESS_FIELD_DOES_NOT_MATCH_EXPECTED_PATTERN": {
                    return ADDRESS_FIELD_DOES_NOT_MATCH_EXPECTED_PATTERN;
                }

                case "ADDRESS_FIELD_IS_REQUIRED": {
                    return ADDRESS_FIELD_IS_REQUIRED;
                }

                case "ADDRESS_FIELD_IS_TOO_LONG": {
                    return ADDRESS_FIELD_IS_TOO_LONG;
                }

                case "INVALID": {
                    return INVALID;
                }

                case "INVALID_COMPANY_LOCATION": {
                    return INVALID_COMPANY_LOCATION;
                }

                case "INVALID_DELIVERY_GROUP": {
                    return INVALID_DELIVERY_GROUP;
                }

                case "INVALID_DELIVERY_OPTION": {
                    return INVALID_DELIVERY_OPTION;
                }

                case "INVALID_INCREMENT": {
                    return INVALID_INCREMENT;
                }

                case "INVALID_MERCHANDISE_LINE": {
                    return INVALID_MERCHANDISE_LINE;
                }

                case "INVALID_METAFIELDS": {
                    return INVALID_METAFIELDS;
                }

                case "INVALID_PAYMENT": {
                    return INVALID_PAYMENT;
                }

                case "INVALID_PAYMENT_EMPTY_CART": {
                    return INVALID_PAYMENT_EMPTY_CART;
                }

                case "INVALID_ZIP_CODE_FOR_COUNTRY": {
                    return INVALID_ZIP_CODE_FOR_COUNTRY;
                }

                case "INVALID_ZIP_CODE_FOR_PROVINCE": {
                    return INVALID_ZIP_CODE_FOR_PROVINCE;
                }

                case "LESS_THAN": {
                    return LESS_THAN;
                }

                case "MAXIMUM_EXCEEDED": {
                    return MAXIMUM_EXCEEDED;
                }

                case "MINIMUM_NOT_MET": {
                    return MINIMUM_NOT_MET;
                }

                case "MISSING_CUSTOMER_ACCESS_TOKEN": {
                    return MISSING_CUSTOMER_ACCESS_TOKEN;
                }

                case "MISSING_DISCOUNT_CODE": {
                    return MISSING_DISCOUNT_CODE;
                }

                case "MISSING_NOTE": {
                    return MISSING_NOTE;
                }

                case "NOTE_TOO_LONG": {
                    return NOTE_TOO_LONG;
                }

                case "PAYMENT_METHOD_NOT_SUPPORTED": {
                    return PAYMENT_METHOD_NOT_SUPPORTED;
                }

                case "PROVINCE_NOT_FOUND": {
                    return PROVINCE_NOT_FOUND;
                }

                case "UNSPECIFIED_ADDRESS_ERROR": {
                    return UNSPECIFIED_ADDRESS_ERROR;
                }

                case "VALIDATION_CUSTOM": {
                    return VALIDATION_CUSTOM;
                }

                case "ZIP_CODE_NOT_SUPPORTED": {
                    return ZIP_CODE_NOT_SUPPORTED;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case ADDRESS_FIELD_CONTAINS_EMOJIS: {
                    return "ADDRESS_FIELD_CONTAINS_EMOJIS";
                }

                case ADDRESS_FIELD_CONTAINS_HTML_TAGS: {
                    return "ADDRESS_FIELD_CONTAINS_HTML_TAGS";
                }

                case ADDRESS_FIELD_CONTAINS_URL: {
                    return "ADDRESS_FIELD_CONTAINS_URL";
                }

                case ADDRESS_FIELD_DOES_NOT_MATCH_EXPECTED_PATTERN: {
                    return "ADDRESS_FIELD_DOES_NOT_MATCH_EXPECTED_PATTERN";
                }

                case ADDRESS_FIELD_IS_REQUIRED: {
                    return "ADDRESS_FIELD_IS_REQUIRED";
                }

                case ADDRESS_FIELD_IS_TOO_LONG: {
                    return "ADDRESS_FIELD_IS_TOO_LONG";
                }

                case INVALID: {
                    return "INVALID";
                }

                case INVALID_COMPANY_LOCATION: {
                    return "INVALID_COMPANY_LOCATION";
                }

                case INVALID_DELIVERY_GROUP: {
                    return "INVALID_DELIVERY_GROUP";
                }

                case INVALID_DELIVERY_OPTION: {
                    return "INVALID_DELIVERY_OPTION";
                }

                case INVALID_INCREMENT: {
                    return "INVALID_INCREMENT";
                }

                case INVALID_MERCHANDISE_LINE: {
                    return "INVALID_MERCHANDISE_LINE";
                }

                case INVALID_METAFIELDS: {
                    return "INVALID_METAFIELDS";
                }

                case INVALID_PAYMENT: {
                    return "INVALID_PAYMENT";
                }

                case INVALID_PAYMENT_EMPTY_CART: {
                    return "INVALID_PAYMENT_EMPTY_CART";
                }

                case INVALID_ZIP_CODE_FOR_COUNTRY: {
                    return "INVALID_ZIP_CODE_FOR_COUNTRY";
                }

                case INVALID_ZIP_CODE_FOR_PROVINCE: {
                    return "INVALID_ZIP_CODE_FOR_PROVINCE";
                }

                case LESS_THAN: {
                    return "LESS_THAN";
                }

                case MAXIMUM_EXCEEDED: {
                    return "MAXIMUM_EXCEEDED";
                }

                case MINIMUM_NOT_MET: {
                    return "MINIMUM_NOT_MET";
                }

                case MISSING_CUSTOMER_ACCESS_TOKEN: {
                    return "MISSING_CUSTOMER_ACCESS_TOKEN";
                }

                case MISSING_DISCOUNT_CODE: {
                    return "MISSING_DISCOUNT_CODE";
                }

                case MISSING_NOTE: {
                    return "MISSING_NOTE";
                }

                case NOTE_TOO_LONG: {
                    return "NOTE_TOO_LONG";
                }

                case PAYMENT_METHOD_NOT_SUPPORTED: {
                    return "PAYMENT_METHOD_NOT_SUPPORTED";
                }

                case PROVINCE_NOT_FOUND: {
                    return "PROVINCE_NOT_FOUND";
                }

                case UNSPECIFIED_ADDRESS_ERROR: {
                    return "UNSPECIFIED_ADDRESS_ERROR";
                }

                case VALIDATION_CUSTOM: {
                    return "VALIDATION_CUSTOM";
                }

                case ZIP_CODE_NOT_SUPPORTED: {
                    return "ZIP_CODE_NOT_SUPPORTED";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface CartEstimatedCostQueryDefinition {
        void define(CartEstimatedCostQuery _queryBuilder);
    }

    /**
    * The estimated costs that the buyer will pay at checkout. The estimated cost uses
    * [`CartBuyerIdentity`](https://shopify.dev/api/storefront/reference/cart/cartbuyeridentity) to
    * determine [international
    * pricing](https://shopify.dev/custom-storefronts/internationalization/international-pricing).
    */
    public static class CartEstimatedCostQuery extends Query<CartEstimatedCostQuery> {
        CartEstimatedCostQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The estimated amount, before taxes and discounts, for the customer to pay at checkout. The checkout
        * charge amount doesn't include any deferred payments that'll be paid at a later date. If the cart has
        * no deferred payments, then the checkout charge amount is equivalent to`subtotal_amount`.
        */
        public CartEstimatedCostQuery checkoutChargeAmount(MoneyV2QueryDefinition queryDef) {
            startField("checkoutChargeAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The estimated amount, before taxes and discounts, for the customer to pay.
        */
        public CartEstimatedCostQuery subtotalAmount(MoneyV2QueryDefinition queryDef) {
            startField("subtotalAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The estimated total amount for the customer to pay.
        */
        public CartEstimatedCostQuery totalAmount(MoneyV2QueryDefinition queryDef) {
            startField("totalAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The estimated duty amount for the customer to pay at checkout.
        */
        public CartEstimatedCostQuery totalDutyAmount(MoneyV2QueryDefinition queryDef) {
            startField("totalDutyAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The estimated tax amount for the customer to pay at checkout.
        */
        public CartEstimatedCostQuery totalTaxAmount(MoneyV2QueryDefinition queryDef) {
            startField("totalTaxAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * The estimated costs that the buyer will pay at checkout. The estimated cost uses
    * [`CartBuyerIdentity`](https://shopify.dev/api/storefront/reference/cart/cartbuyeridentity) to
    * determine [international
    * pricing](https://shopify.dev/custom-storefronts/internationalization/international-pricing).
    */
    public static class CartEstimatedCost extends AbstractResponse<CartEstimatedCost> {
        public CartEstimatedCost() {
        }

        public CartEstimatedCost(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "checkoutChargeAmount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "subtotalAmount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "totalAmount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "totalDutyAmount": {
                        MoneyV2 optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new MoneyV2(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "totalTaxAmount": {
                        MoneyV2 optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new MoneyV2(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartEstimatedCost";
        }

        /**
        * The estimated amount, before taxes and discounts, for the customer to pay at checkout. The checkout
        * charge amount doesn't include any deferred payments that'll be paid at a later date. If the cart has
        * no deferred payments, then the checkout charge amount is equivalent to`subtotal_amount`.
        */

        public MoneyV2 getCheckoutChargeAmount() {
            return (MoneyV2) get("checkoutChargeAmount");
        }

        public CartEstimatedCost setCheckoutChargeAmount(MoneyV2 arg) {
            optimisticData.put(getKey("checkoutChargeAmount"), arg);
            return this;
        }

        /**
        * The estimated amount, before taxes and discounts, for the customer to pay.
        */

        public MoneyV2 getSubtotalAmount() {
            return (MoneyV2) get("subtotalAmount");
        }

        public CartEstimatedCost setSubtotalAmount(MoneyV2 arg) {
            optimisticData.put(getKey("subtotalAmount"), arg);
            return this;
        }

        /**
        * The estimated total amount for the customer to pay.
        */

        public MoneyV2 getTotalAmount() {
            return (MoneyV2) get("totalAmount");
        }

        public CartEstimatedCost setTotalAmount(MoneyV2 arg) {
            optimisticData.put(getKey("totalAmount"), arg);
            return this;
        }

        /**
        * The estimated duty amount for the customer to pay at checkout.
        */

        public MoneyV2 getTotalDutyAmount() {
            return (MoneyV2) get("totalDutyAmount");
        }

        public CartEstimatedCost setTotalDutyAmount(MoneyV2 arg) {
            optimisticData.put(getKey("totalDutyAmount"), arg);
            return this;
        }

        /**
        * The estimated tax amount for the customer to pay at checkout.
        */

        public MoneyV2 getTotalTaxAmount() {
            return (MoneyV2) get("totalTaxAmount");
        }

        public CartEstimatedCost setTotalTaxAmount(MoneyV2 arg) {
            optimisticData.put(getKey("totalTaxAmount"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "checkoutChargeAmount": return true;

                case "subtotalAmount": return true;

                case "totalAmount": return true;

                case "totalDutyAmount": return true;

                case "totalTaxAmount": return true;

                default: return false;
            }
        }
    }

    public static class CartFreePaymentMethodInput implements Serializable {
        private MailingAddressInput billingAddress;

        public CartFreePaymentMethodInput(MailingAddressInput billingAddress) {
            this.billingAddress = billingAddress;
        }

        public MailingAddressInput getBillingAddress() {
            return billingAddress;
        }

        public CartFreePaymentMethodInput setBillingAddress(MailingAddressInput billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("billingAddress:");
            billingAddress.appendTo(_queryBuilder);

            _queryBuilder.append('}');
        }
    }

    public interface CartGiftCardCodesUpdatePayloadQueryDefinition {
        void define(CartGiftCardCodesUpdatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `cartGiftCardCodesUpdate` mutation.
    */
    public static class CartGiftCardCodesUpdatePayloadQuery extends Query<CartGiftCardCodesUpdatePayloadQuery> {
        CartGiftCardCodesUpdatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The updated cart.
        */
        public CartGiftCardCodesUpdatePayloadQuery cart(CartQueryDefinition queryDef) {
            startField("cart");

            _queryBuilder.append('{');
            queryDef.define(new CartQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CartGiftCardCodesUpdatePayloadQuery userErrors(CartUserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new CartUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `cartGiftCardCodesUpdate` mutation.
    */
    public static class CartGiftCardCodesUpdatePayload extends AbstractResponse<CartGiftCardCodesUpdatePayload> {
        public CartGiftCardCodesUpdatePayload() {
        }

        public CartGiftCardCodesUpdatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cart": {
                        Cart optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Cart(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<CartUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartGiftCardCodesUpdatePayload";
        }

        /**
        * The updated cart.
        */

        public Cart getCart() {
            return (Cart) get("cart");
        }

        public CartGiftCardCodesUpdatePayload setCart(Cart arg) {
            optimisticData.put(getKey("cart"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CartUserError> getUserErrors() {
            return (List<CartUserError>) get("userErrors");
        }

        public CartGiftCardCodesUpdatePayload setUserErrors(List<CartUserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cart": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public static class CartInput implements Serializable {
        private Input<List<AttributeInput>> attributes = Input.undefined();

        private Input<List<CartLineInput>> lines = Input.undefined();

        private Input<List<String>> discountCodes = Input.undefined();

        private Input<List<String>> giftCardCodes = Input.undefined();

        private Input<String> note = Input.undefined();

        private Input<CartBuyerIdentityInput> buyerIdentity = Input.undefined();

        private Input<List<CartInputMetafieldInput>> metafields = Input.undefined();

        public List<AttributeInput> getAttributes() {
            return attributes.getValue();
        }

        public Input<List<AttributeInput>> getAttributesInput() {
            return attributes;
        }

        public CartInput setAttributes(List<AttributeInput> attributes) {
            this.attributes = Input.optional(attributes);
            return this;
        }

        public CartInput setAttributesInput(Input<List<AttributeInput>> attributes) {
            if (attributes == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.attributes = attributes;
            return this;
        }

        public List<CartLineInput> getLines() {
            return lines.getValue();
        }

        public Input<List<CartLineInput>> getLinesInput() {
            return lines;
        }

        public CartInput setLines(List<CartLineInput> lines) {
            this.lines = Input.optional(lines);
            return this;
        }

        public CartInput setLinesInput(Input<List<CartLineInput>> lines) {
            if (lines == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.lines = lines;
            return this;
        }

        public List<String> getDiscountCodes() {
            return discountCodes.getValue();
        }

        public Input<List<String>> getDiscountCodesInput() {
            return discountCodes;
        }

        public CartInput setDiscountCodes(List<String> discountCodes) {
            this.discountCodes = Input.optional(discountCodes);
            return this;
        }

        public CartInput setDiscountCodesInput(Input<List<String>> discountCodes) {
            if (discountCodes == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.discountCodes = discountCodes;
            return this;
        }

        public List<String> getGiftCardCodes() {
            return giftCardCodes.getValue();
        }

        public Input<List<String>> getGiftCardCodesInput() {
            return giftCardCodes;
        }

        public CartInput setGiftCardCodes(List<String> giftCardCodes) {
            this.giftCardCodes = Input.optional(giftCardCodes);
            return this;
        }

        public CartInput setGiftCardCodesInput(Input<List<String>> giftCardCodes) {
            if (giftCardCodes == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.giftCardCodes = giftCardCodes;
            return this;
        }

        public String getNote() {
            return note.getValue();
        }

        public Input<String> getNoteInput() {
            return note;
        }

        public CartInput setNote(String note) {
            this.note = Input.optional(note);
            return this;
        }

        public CartInput setNoteInput(Input<String> note) {
            if (note == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.note = note;
            return this;
        }

        public CartBuyerIdentityInput getBuyerIdentity() {
            return buyerIdentity.getValue();
        }

        public Input<CartBuyerIdentityInput> getBuyerIdentityInput() {
            return buyerIdentity;
        }

        public CartInput setBuyerIdentity(CartBuyerIdentityInput buyerIdentity) {
            this.buyerIdentity = Input.optional(buyerIdentity);
            return this;
        }

        public CartInput setBuyerIdentityInput(Input<CartBuyerIdentityInput> buyerIdentity) {
            if (buyerIdentity == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.buyerIdentity = buyerIdentity;
            return this;
        }

        public List<CartInputMetafieldInput> getMetafields() {
            return metafields.getValue();
        }

        public Input<List<CartInputMetafieldInput>> getMetafieldsInput() {
            return metafields;
        }

        public CartInput setMetafields(List<CartInputMetafieldInput> metafields) {
            this.metafields = Input.optional(metafields);
            return this;
        }

        public CartInput setMetafieldsInput(Input<List<CartInputMetafieldInput>> metafields) {
            if (metafields == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.metafields = metafields;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            if (this.attributes.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("attributes:");
                if (attributes.getValue() != null) {
                    _queryBuilder.append('[');
                    {
                        String listSeperator1 = "";
                        for (AttributeInput item1 : attributes.getValue()) {
                            _queryBuilder.append(listSeperator1);
                            listSeperator1 = ",";
                            item1.appendTo(_queryBuilder);
                        }
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.lines.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("lines:");
                if (lines.getValue() != null) {
                    _queryBuilder.append('[');
                    {
                        String listSeperator1 = "";
                        for (CartLineInput item1 : lines.getValue()) {
                            _queryBuilder.append(listSeperator1);
                            listSeperator1 = ",";
                            item1.appendTo(_queryBuilder);
                        }
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.discountCodes.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("discountCodes:");
                if (discountCodes.getValue() != null) {
                    _queryBuilder.append('[');
                    {
                        String listSeperator1 = "";
                        for (String item1 : discountCodes.getValue()) {
                            _queryBuilder.append(listSeperator1);
                            listSeperator1 = ",";
                            Query.appendQuotedString(_queryBuilder, item1.toString());
                        }
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.giftCardCodes.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("giftCardCodes:");
                if (giftCardCodes.getValue() != null) {
                    _queryBuilder.append('[');
                    {
                        String listSeperator1 = "";
                        for (String item1 : giftCardCodes.getValue()) {
                            _queryBuilder.append(listSeperator1);
                            listSeperator1 = ",";
                            Query.appendQuotedString(_queryBuilder, item1.toString());
                        }
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.note.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("note:");
                if (note.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, note.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.buyerIdentity.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("buyerIdentity:");
                if (buyerIdentity.getValue() != null) {
                    buyerIdentity.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.metafields.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("metafields:");
                if (metafields.getValue() != null) {
                    _queryBuilder.append('[');
                    {
                        String listSeperator1 = "";
                        for (CartInputMetafieldInput item1 : metafields.getValue()) {
                            _queryBuilder.append(listSeperator1);
                            listSeperator1 = ",";
                            item1.appendTo(_queryBuilder);
                        }
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    public static class CartInputMetafieldInput implements Serializable {
        private String key;

        private String value;

        private String type;

        public CartInputMetafieldInput(String key, String value, String type) {
            this.key = key;

            this.value = value;

            this.type = type;
        }

        public String getKey() {
            return key;
        }

        public CartInputMetafieldInput setKey(String key) {
            this.key = key;
            return this;
        }

        public String getValue() {
            return value;
        }

        public CartInputMetafieldInput setValue(String value) {
            this.value = value;
            return this;
        }

        public String getType() {
            return type;
        }

        public CartInputMetafieldInput setType(String type) {
            this.type = type;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("value:");
            Query.appendQuotedString(_queryBuilder, value.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("type:");
            Query.appendQuotedString(_queryBuilder, type.toString());

            _queryBuilder.append('}');
        }
    }

    public interface CartLineQueryDefinition {
        void define(CartLineQuery _queryBuilder);
    }

    /**
    * Represents information about the merchandise in the cart.
    */
    public static class CartLineQuery extends Query<CartLineQuery> {
        CartLineQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("id");
        }

        /**
        * An attribute associated with the cart line.
        */
        public CartLineQuery attribute(String key, AttributeQueryDefinition queryDef) {
            startField("attribute");

            _queryBuilder.append("(key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new AttributeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The attributes associated with the cart line. Attributes are represented as key-value pairs.
        */
        public CartLineQuery attributes(AttributeQueryDefinition queryDef) {
            startField("attributes");

            _queryBuilder.append('{');
            queryDef.define(new AttributeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The cost of the merchandise that the buyer will pay for at checkout. The costs are subject to change
        * and changes will be reflected at checkout.
        */
        public CartLineQuery cost(CartLineCostQueryDefinition queryDef) {
            startField("cost");

            _queryBuilder.append('{');
            queryDef.define(new CartLineCostQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The discounts that have been applied to the cart line.
        */
        public CartLineQuery discountAllocations(CartDiscountAllocationQueryDefinition queryDef) {
            startField("discountAllocations");

            _queryBuilder.append('{');
            queryDef.define(new CartDiscountAllocationQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The estimated cost of the merchandise that the buyer will pay for at checkout. The estimated costs
        * are subject to change and changes will be reflected at checkout.
        *
        * @deprecated Use `cost` instead.
        */
        @Deprecated
        public CartLineQuery estimatedCost(CartLineEstimatedCostQueryDefinition queryDef) {
            startField("estimatedCost");

            _queryBuilder.append('{');
            queryDef.define(new CartLineEstimatedCostQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The merchandise that the buyer intends to purchase.
        */
        public CartLineQuery merchandise(MerchandiseQueryDefinition queryDef) {
            startField("merchandise");

            _queryBuilder.append('{');
            queryDef.define(new MerchandiseQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The quantity of the merchandise that the customer intends to purchase.
        */
        public CartLineQuery quantity() {
            startField("quantity");

            return this;
        }

        /**
        * The selling plan associated with the cart line and the effect that each selling plan has on variants
        * when they're purchased.
        */
        public CartLineQuery sellingPlanAllocation(SellingPlanAllocationQueryDefinition queryDef) {
            startField("sellingPlanAllocation");

            _queryBuilder.append('{');
            queryDef.define(new SellingPlanAllocationQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Represents information about the merchandise in the cart.
    */
    public static class CartLine extends AbstractResponse<CartLine> implements BaseCartLine, Node {
        public CartLine() {
        }

        public CartLine(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "attribute": {
                        Attribute optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Attribute(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "attributes": {
                        List<Attribute> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new Attribute(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "cost": {
                        responseData.put(key, new CartLineCost(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "discountAllocations": {
                        List<CartDiscountAllocation> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(UnknownCartDiscountAllocation.create(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "estimatedCost": {
                        responseData.put(key, new CartLineEstimatedCost(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "merchandise": {
                        responseData.put(key, UnknownMerchandise.create(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "quantity": {
                        responseData.put(key, jsonAsInteger(field.getValue(), key));

                        break;
                    }

                    case "sellingPlanAllocation": {
                        SellingPlanAllocation optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new SellingPlanAllocation(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public CartLine(ID id) {
            this();
            optimisticData.put("id", id);
        }

        public String getGraphQlTypeName() {
            return "CartLine";
        }

        /**
        * An attribute associated with the cart line.
        */

        public Attribute getAttribute() {
            return (Attribute) get("attribute");
        }

        public CartLine setAttribute(Attribute arg) {
            optimisticData.put(getKey("attribute"), arg);
            return this;
        }

        /**
        * The attributes associated with the cart line. Attributes are represented as key-value pairs.
        */

        public List<Attribute> getAttributes() {
            return (List<Attribute>) get("attributes");
        }

        public CartLine setAttributes(List<Attribute> arg) {
            optimisticData.put(getKey("attributes"), arg);
            return this;
        }

        /**
        * The cost of the merchandise that the buyer will pay for at checkout. The costs are subject to change
        * and changes will be reflected at checkout.
        */

        public CartLineCost getCost() {
            return (CartLineCost) get("cost");
        }

        public CartLine setCost(CartLineCost arg) {
            optimisticData.put(getKey("cost"), arg);
            return this;
        }

        /**
        * The discounts that have been applied to the cart line.
        */

        public List<CartDiscountAllocation> getDiscountAllocations() {
            return (List<CartDiscountAllocation>) get("discountAllocations");
        }

        public CartLine setDiscountAllocations(List<CartDiscountAllocation> arg) {
            optimisticData.put(getKey("discountAllocations"), arg);
            return this;
        }

        /**
        * The estimated cost of the merchandise that the buyer will pay for at checkout. The estimated costs
        * are subject to change and changes will be reflected at checkout.
        *
        * @deprecated Use `cost` instead.
        */

        public CartLineEstimatedCost getEstimatedCost() {
            return (CartLineEstimatedCost) get("estimatedCost");
        }

        public CartLine setEstimatedCost(CartLineEstimatedCost arg) {
            optimisticData.put(getKey("estimatedCost"), arg);
            return this;
        }

        /**
        * A globally-unique ID.
        */

        public ID getId() {
            return (ID) get("id");
        }

        /**
        * The merchandise that the buyer intends to purchase.
        */

        public Merchandise getMerchandise() {
            return (Merchandise) get("merchandise");
        }

        public CartLine setMerchandise(Merchandise arg) {
            optimisticData.put(getKey("merchandise"), arg);
            return this;
        }

        /**
        * The quantity of the merchandise that the customer intends to purchase.
        */

        public Integer getQuantity() {
            return (Integer) get("quantity");
        }

        public CartLine setQuantity(Integer arg) {
            optimisticData.put(getKey("quantity"), arg);
            return this;
        }

        /**
        * The selling plan associated with the cart line and the effect that each selling plan has on variants
        * when they're purchased.
        */

        public SellingPlanAllocation getSellingPlanAllocation() {
            return (SellingPlanAllocation) get("sellingPlanAllocation");
        }

        public CartLine setSellingPlanAllocation(SellingPlanAllocation arg) {
            optimisticData.put(getKey("sellingPlanAllocation"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "attribute": return true;

                case "attributes": return true;

                case "cost": return true;

                case "discountAllocations": return false;

                case "estimatedCost": return true;

                case "id": return false;

                case "merchandise": return false;

                case "quantity": return false;

                case "sellingPlanAllocation": return true;

                default: return false;
            }
        }
    }

    public interface CartLineCostQueryDefinition {
        void define(CartLineCostQuery _queryBuilder);
    }

    /**
    * The cost of the merchandise line that the buyer will pay at checkout.
    */
    public static class CartLineCostQuery extends Query<CartLineCostQuery> {
        CartLineCostQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The amount of the merchandise line.
        */
        public CartLineCostQuery amountPerQuantity(MoneyV2QueryDefinition queryDef) {
            startField("amountPerQuantity");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The compare at amount of the merchandise line.
        */
        public CartLineCostQuery compareAtAmountPerQuantity(MoneyV2QueryDefinition queryDef) {
            startField("compareAtAmountPerQuantity");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The cost of the merchandise line before line-level discounts.
        */
        public CartLineCostQuery subtotalAmount(MoneyV2QueryDefinition queryDef) {
            startField("subtotalAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The total cost of the merchandise line.
        */
        public CartLineCostQuery totalAmount(MoneyV2QueryDefinition queryDef) {
            startField("totalAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * The cost of the merchandise line that the buyer will pay at checkout.
    */
    public static class CartLineCost extends AbstractResponse<CartLineCost> {
        public CartLineCost() {
        }

        public CartLineCost(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "amountPerQuantity": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "compareAtAmountPerQuantity": {
                        MoneyV2 optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new MoneyV2(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "subtotalAmount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "totalAmount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartLineCost";
        }

        /**
        * The amount of the merchandise line.
        */

        public MoneyV2 getAmountPerQuantity() {
            return (MoneyV2) get("amountPerQuantity");
        }

        public CartLineCost setAmountPerQuantity(MoneyV2 arg) {
            optimisticData.put(getKey("amountPerQuantity"), arg);
            return this;
        }

        /**
        * The compare at amount of the merchandise line.
        */

        public MoneyV2 getCompareAtAmountPerQuantity() {
            return (MoneyV2) get("compareAtAmountPerQuantity");
        }

        public CartLineCost setCompareAtAmountPerQuantity(MoneyV2 arg) {
            optimisticData.put(getKey("compareAtAmountPerQuantity"), arg);
            return this;
        }

        /**
        * The cost of the merchandise line before line-level discounts.
        */

        public MoneyV2 getSubtotalAmount() {
            return (MoneyV2) get("subtotalAmount");
        }

        public CartLineCost setSubtotalAmount(MoneyV2 arg) {
            optimisticData.put(getKey("subtotalAmount"), arg);
            return this;
        }

        /**
        * The total cost of the merchandise line.
        */

        public MoneyV2 getTotalAmount() {
            return (MoneyV2) get("totalAmount");
        }

        public CartLineCost setTotalAmount(MoneyV2 arg) {
            optimisticData.put(getKey("totalAmount"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "amountPerQuantity": return true;

                case "compareAtAmountPerQuantity": return true;

                case "subtotalAmount": return true;

                case "totalAmount": return true;

                default: return false;
            }
        }
    }

    public interface CartLineEstimatedCostQueryDefinition {
        void define(CartLineEstimatedCostQuery _queryBuilder);
    }

    /**
    * The estimated cost of the merchandise line that the buyer will pay at checkout.
    */
    public static class CartLineEstimatedCostQuery extends Query<CartLineEstimatedCostQuery> {
        CartLineEstimatedCostQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The amount of the merchandise line.
        */
        public CartLineEstimatedCostQuery amount(MoneyV2QueryDefinition queryDef) {
            startField("amount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The compare at amount of the merchandise line.
        */
        public CartLineEstimatedCostQuery compareAtAmount(MoneyV2QueryDefinition queryDef) {
            startField("compareAtAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The estimated cost of the merchandise line before discounts.
        */
        public CartLineEstimatedCostQuery subtotalAmount(MoneyV2QueryDefinition queryDef) {
            startField("subtotalAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The estimated total cost of the merchandise line.
        */
        public CartLineEstimatedCostQuery totalAmount(MoneyV2QueryDefinition queryDef) {
            startField("totalAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * The estimated cost of the merchandise line that the buyer will pay at checkout.
    */
    public static class CartLineEstimatedCost extends AbstractResponse<CartLineEstimatedCost> {
        public CartLineEstimatedCost() {
        }

        public CartLineEstimatedCost(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "amount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "compareAtAmount": {
                        MoneyV2 optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new MoneyV2(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "subtotalAmount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "totalAmount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartLineEstimatedCost";
        }

        /**
        * The amount of the merchandise line.
        */

        public MoneyV2 getAmount() {
            return (MoneyV2) get("amount");
        }

        public CartLineEstimatedCost setAmount(MoneyV2 arg) {
            optimisticData.put(getKey("amount"), arg);
            return this;
        }

        /**
        * The compare at amount of the merchandise line.
        */

        public MoneyV2 getCompareAtAmount() {
            return (MoneyV2) get("compareAtAmount");
        }

        public CartLineEstimatedCost setCompareAtAmount(MoneyV2 arg) {
            optimisticData.put(getKey("compareAtAmount"), arg);
            return this;
        }

        /**
        * The estimated cost of the merchandise line before discounts.
        */

        public MoneyV2 getSubtotalAmount() {
            return (MoneyV2) get("subtotalAmount");
        }

        public CartLineEstimatedCost setSubtotalAmount(MoneyV2 arg) {
            optimisticData.put(getKey("subtotalAmount"), arg);
            return this;
        }

        /**
        * The estimated total cost of the merchandise line.
        */

        public MoneyV2 getTotalAmount() {
            return (MoneyV2) get("totalAmount");
        }

        public CartLineEstimatedCost setTotalAmount(MoneyV2 arg) {
            optimisticData.put(getKey("totalAmount"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "amount": return true;

                case "compareAtAmount": return true;

                case "subtotalAmount": return true;

                case "totalAmount": return true;

                default: return false;
            }
        }
    }

    public static class CartLineInput implements Serializable {
        private ID merchandiseId;

        private Input<List<AttributeInput>> attributes = Input.undefined();

        private Input<Integer> quantity = Input.undefined();

        private Input<ID> sellingPlanId = Input.undefined();

        public CartLineInput(ID merchandiseId) {
            this.merchandiseId = merchandiseId;
        }

        public ID getMerchandiseId() {
            return merchandiseId;
        }

        public CartLineInput setMerchandiseId(ID merchandiseId) {
            this.merchandiseId = merchandiseId;
            return this;
        }

        public List<AttributeInput> getAttributes() {
            return attributes.getValue();
        }

        public Input<List<AttributeInput>> getAttributesInput() {
            return attributes;
        }

        public CartLineInput setAttributes(List<AttributeInput> attributes) {
            this.attributes = Input.optional(attributes);
            return this;
        }

        public CartLineInput setAttributesInput(Input<List<AttributeInput>> attributes) {
            if (attributes == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.attributes = attributes;
            return this;
        }

        public Integer getQuantity() {
            return quantity.getValue();
        }

        public Input<Integer> getQuantityInput() {
            return quantity;
        }

        public CartLineInput setQuantity(Integer quantity) {
            this.quantity = Input.optional(quantity);
            return this;
        }

        public CartLineInput setQuantityInput(Input<Integer> quantity) {
            if (quantity == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.quantity = quantity;
            return this;
        }

        public ID getSellingPlanId() {
            return sellingPlanId.getValue();
        }

        public Input<ID> getSellingPlanIdInput() {
            return sellingPlanId;
        }

        public CartLineInput setSellingPlanId(ID sellingPlanId) {
            this.sellingPlanId = Input.optional(sellingPlanId);
            return this;
        }

        public CartLineInput setSellingPlanIdInput(Input<ID> sellingPlanId) {
            if (sellingPlanId == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.sellingPlanId = sellingPlanId;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("merchandiseId:");
            Query.appendQuotedString(_queryBuilder, merchandiseId.toString());

            if (this.attributes.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("attributes:");
                if (attributes.getValue() != null) {
                    _queryBuilder.append('[');
                    {
                        String listSeperator1 = "";
                        for (AttributeInput item1 : attributes.getValue()) {
                            _queryBuilder.append(listSeperator1);
                            listSeperator1 = ",";
                            item1.appendTo(_queryBuilder);
                        }
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.quantity.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("quantity:");
                if (quantity.getValue() != null) {
                    _queryBuilder.append(quantity.getValue());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.sellingPlanId.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("sellingPlanId:");
                if (sellingPlanId.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, sellingPlanId.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    public static class CartLineUpdateInput implements Serializable {
        private ID id;

        private Input<Integer> quantity = Input.undefined();

        private Input<ID> merchandiseId = Input.undefined();

        private Input<List<AttributeInput>> attributes = Input.undefined();

        private Input<ID> sellingPlanId = Input.undefined();

        public CartLineUpdateInput(ID id) {
            this.id = id;
        }

        public ID getId() {
            return id;
        }

        public CartLineUpdateInput setId(ID id) {
            this.id = id;
            return this;
        }

        public Integer getQuantity() {
            return quantity.getValue();
        }

        public Input<Integer> getQuantityInput() {
            return quantity;
        }

        public CartLineUpdateInput setQuantity(Integer quantity) {
            this.quantity = Input.optional(quantity);
            return this;
        }

        public CartLineUpdateInput setQuantityInput(Input<Integer> quantity) {
            if (quantity == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.quantity = quantity;
            return this;
        }

        public ID getMerchandiseId() {
            return merchandiseId.getValue();
        }

        public Input<ID> getMerchandiseIdInput() {
            return merchandiseId;
        }

        public CartLineUpdateInput setMerchandiseId(ID merchandiseId) {
            this.merchandiseId = Input.optional(merchandiseId);
            return this;
        }

        public CartLineUpdateInput setMerchandiseIdInput(Input<ID> merchandiseId) {
            if (merchandiseId == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.merchandiseId = merchandiseId;
            return this;
        }

        public List<AttributeInput> getAttributes() {
            return attributes.getValue();
        }

        public Input<List<AttributeInput>> getAttributesInput() {
            return attributes;
        }

        public CartLineUpdateInput setAttributes(List<AttributeInput> attributes) {
            this.attributes = Input.optional(attributes);
            return this;
        }

        public CartLineUpdateInput setAttributesInput(Input<List<AttributeInput>> attributes) {
            if (attributes == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.attributes = attributes;
            return this;
        }

        public ID getSellingPlanId() {
            return sellingPlanId.getValue();
        }

        public Input<ID> getSellingPlanIdInput() {
            return sellingPlanId;
        }

        public CartLineUpdateInput setSellingPlanId(ID sellingPlanId) {
            this.sellingPlanId = Input.optional(sellingPlanId);
            return this;
        }

        public CartLineUpdateInput setSellingPlanIdInput(Input<ID> sellingPlanId) {
            if (sellingPlanId == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.sellingPlanId = sellingPlanId;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("id:");
            Query.appendQuotedString(_queryBuilder, id.toString());

            if (this.quantity.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("quantity:");
                if (quantity.getValue() != null) {
                    _queryBuilder.append(quantity.getValue());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.merchandiseId.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("merchandiseId:");
                if (merchandiseId.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, merchandiseId.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.attributes.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("attributes:");
                if (attributes.getValue() != null) {
                    _queryBuilder.append('[');
                    {
                        String listSeperator1 = "";
                        for (AttributeInput item1 : attributes.getValue()) {
                            _queryBuilder.append(listSeperator1);
                            listSeperator1 = ",";
                            item1.appendTo(_queryBuilder);
                        }
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.sellingPlanId.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("sellingPlanId:");
                if (sellingPlanId.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, sellingPlanId.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    public interface CartLinesAddPayloadQueryDefinition {
        void define(CartLinesAddPayloadQuery _queryBuilder);
    }

    /**
    * Return type for `cartLinesAdd` mutation.
    */
    public static class CartLinesAddPayloadQuery extends Query<CartLinesAddPayloadQuery> {
        CartLinesAddPayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The updated cart.
        */
        public CartLinesAddPayloadQuery cart(CartQueryDefinition queryDef) {
            startField("cart");

            _queryBuilder.append('{');
            queryDef.define(new CartQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CartLinesAddPayloadQuery userErrors(CartUserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new CartUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `cartLinesAdd` mutation.
    */
    public static class CartLinesAddPayload extends AbstractResponse<CartLinesAddPayload> {
        public CartLinesAddPayload() {
        }

        public CartLinesAddPayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cart": {
                        Cart optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Cart(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<CartUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartLinesAddPayload";
        }

        /**
        * The updated cart.
        */

        public Cart getCart() {
            return (Cart) get("cart");
        }

        public CartLinesAddPayload setCart(Cart arg) {
            optimisticData.put(getKey("cart"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CartUserError> getUserErrors() {
            return (List<CartUserError>) get("userErrors");
        }

        public CartLinesAddPayload setUserErrors(List<CartUserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cart": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CartLinesRemovePayloadQueryDefinition {
        void define(CartLinesRemovePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `cartLinesRemove` mutation.
    */
    public static class CartLinesRemovePayloadQuery extends Query<CartLinesRemovePayloadQuery> {
        CartLinesRemovePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The updated cart.
        */
        public CartLinesRemovePayloadQuery cart(CartQueryDefinition queryDef) {
            startField("cart");

            _queryBuilder.append('{');
            queryDef.define(new CartQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CartLinesRemovePayloadQuery userErrors(CartUserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new CartUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `cartLinesRemove` mutation.
    */
    public static class CartLinesRemovePayload extends AbstractResponse<CartLinesRemovePayload> {
        public CartLinesRemovePayload() {
        }

        public CartLinesRemovePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cart": {
                        Cart optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Cart(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<CartUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartLinesRemovePayload";
        }

        /**
        * The updated cart.
        */

        public Cart getCart() {
            return (Cart) get("cart");
        }

        public CartLinesRemovePayload setCart(Cart arg) {
            optimisticData.put(getKey("cart"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CartUserError> getUserErrors() {
            return (List<CartUserError>) get("userErrors");
        }

        public CartLinesRemovePayload setUserErrors(List<CartUserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cart": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CartLinesUpdatePayloadQueryDefinition {
        void define(CartLinesUpdatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `cartLinesUpdate` mutation.
    */
    public static class CartLinesUpdatePayloadQuery extends Query<CartLinesUpdatePayloadQuery> {
        CartLinesUpdatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The updated cart.
        */
        public CartLinesUpdatePayloadQuery cart(CartQueryDefinition queryDef) {
            startField("cart");

            _queryBuilder.append('{');
            queryDef.define(new CartQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CartLinesUpdatePayloadQuery userErrors(CartUserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new CartUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `cartLinesUpdate` mutation.
    */
    public static class CartLinesUpdatePayload extends AbstractResponse<CartLinesUpdatePayload> {
        public CartLinesUpdatePayload() {
        }

        public CartLinesUpdatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cart": {
                        Cart optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Cart(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<CartUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartLinesUpdatePayload";
        }

        /**
        * The updated cart.
        */

        public Cart getCart() {
            return (Cart) get("cart");
        }

        public CartLinesUpdatePayload setCart(Cart arg) {
            optimisticData.put(getKey("cart"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CartUserError> getUserErrors() {
            return (List<CartUserError>) get("userErrors");
        }

        public CartLinesUpdatePayload setUserErrors(List<CartUserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cart": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public static class CartMetafieldDeleteInput implements Serializable {
        private ID ownerId;

        private String key;

        public CartMetafieldDeleteInput(ID ownerId, String key) {
            this.ownerId = ownerId;

            this.key = key;
        }

        public ID getOwnerId() {
            return ownerId;
        }

        public CartMetafieldDeleteInput setOwnerId(ID ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public String getKey() {
            return key;
        }

        public CartMetafieldDeleteInput setKey(String key) {
            this.key = key;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("ownerId:");
            Query.appendQuotedString(_queryBuilder, ownerId.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            _queryBuilder.append('}');
        }
    }

    public interface CartMetafieldDeletePayloadQueryDefinition {
        void define(CartMetafieldDeletePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `cartMetafieldDelete` mutation.
    */
    public static class CartMetafieldDeletePayloadQuery extends Query<CartMetafieldDeletePayloadQuery> {
        CartMetafieldDeletePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The ID of the deleted cart metafield.
        */
        public CartMetafieldDeletePayloadQuery deletedId() {
            startField("deletedId");

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CartMetafieldDeletePayloadQuery userErrors(MetafieldDeleteUserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new MetafieldDeleteUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `cartMetafieldDelete` mutation.
    */
    public static class CartMetafieldDeletePayload extends AbstractResponse<CartMetafieldDeletePayload> {
        public CartMetafieldDeletePayload() {
        }

        public CartMetafieldDeletePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "deletedId": {
                        ID optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new ID(jsonAsString(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<MetafieldDeleteUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new MetafieldDeleteUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartMetafieldDeletePayload";
        }

        /**
        * The ID of the deleted cart metafield.
        */

        public ID getDeletedId() {
            return (ID) get("deletedId");
        }

        public CartMetafieldDeletePayload setDeletedId(ID arg) {
            optimisticData.put(getKey("deletedId"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<MetafieldDeleteUserError> getUserErrors() {
            return (List<MetafieldDeleteUserError>) get("userErrors");
        }

        public CartMetafieldDeletePayload setUserErrors(List<MetafieldDeleteUserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "deletedId": return false;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public static class CartMetafieldsSetInput implements Serializable {
        private ID ownerId;

        private String key;

        private String value;

        private String type;

        public CartMetafieldsSetInput(ID ownerId, String key, String value, String type) {
            this.ownerId = ownerId;

            this.key = key;

            this.value = value;

            this.type = type;
        }

        public ID getOwnerId() {
            return ownerId;
        }

        public CartMetafieldsSetInput setOwnerId(ID ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public String getKey() {
            return key;
        }

        public CartMetafieldsSetInput setKey(String key) {
            this.key = key;
            return this;
        }

        public String getValue() {
            return value;
        }

        public CartMetafieldsSetInput setValue(String value) {
            this.value = value;
            return this;
        }

        public String getType() {
            return type;
        }

        public CartMetafieldsSetInput setType(String type) {
            this.type = type;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("ownerId:");
            Query.appendQuotedString(_queryBuilder, ownerId.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("value:");
            Query.appendQuotedString(_queryBuilder, value.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("type:");
            Query.appendQuotedString(_queryBuilder, type.toString());

            _queryBuilder.append('}');
        }
    }

    public interface CartMetafieldsSetPayloadQueryDefinition {
        void define(CartMetafieldsSetPayloadQuery _queryBuilder);
    }

    /**
    * Return type for `cartMetafieldsSet` mutation.
    */
    public static class CartMetafieldsSetPayloadQuery extends Query<CartMetafieldsSetPayloadQuery> {
        CartMetafieldsSetPayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The list of cart metafields that were set.
        */
        public CartMetafieldsSetPayloadQuery metafields(MetafieldQueryDefinition queryDef) {
            startField("metafields");

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CartMetafieldsSetPayloadQuery userErrors(MetafieldsSetUserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new MetafieldsSetUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `cartMetafieldsSet` mutation.
    */
    public static class CartMetafieldsSetPayload extends AbstractResponse<CartMetafieldsSetPayload> {
        public CartMetafieldsSetPayload() {
        }

        public CartMetafieldsSetPayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "metafields": {
                        List<Metafield> optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            List<Metafield> list1 = new ArrayList<>();
                            for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                                list1.add(new Metafield(jsonAsObject(element1, key)));
                            }

                            optional1 = list1;
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<MetafieldsSetUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new MetafieldsSetUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartMetafieldsSetPayload";
        }

        /**
        * The list of cart metafields that were set.
        */

        public List<Metafield> getMetafields() {
            return (List<Metafield>) get("metafields");
        }

        public CartMetafieldsSetPayload setMetafields(List<Metafield> arg) {
            optimisticData.put(getKey("metafields"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<MetafieldsSetUserError> getUserErrors() {
            return (List<MetafieldsSetUserError>) get("userErrors");
        }

        public CartMetafieldsSetPayload setUserErrors(List<MetafieldsSetUserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "metafields": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CartNoteUpdatePayloadQueryDefinition {
        void define(CartNoteUpdatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `cartNoteUpdate` mutation.
    */
    public static class CartNoteUpdatePayloadQuery extends Query<CartNoteUpdatePayloadQuery> {
        CartNoteUpdatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The updated cart.
        */
        public CartNoteUpdatePayloadQuery cart(CartQueryDefinition queryDef) {
            startField("cart");

            _queryBuilder.append('{');
            queryDef.define(new CartQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CartNoteUpdatePayloadQuery userErrors(CartUserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new CartUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `cartNoteUpdate` mutation.
    */
    public static class CartNoteUpdatePayload extends AbstractResponse<CartNoteUpdatePayload> {
        public CartNoteUpdatePayload() {
        }

        public CartNoteUpdatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cart": {
                        Cart optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Cart(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<CartUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartNoteUpdatePayload";
        }

        /**
        * The updated cart.
        */

        public Cart getCart() {
            return (Cart) get("cart");
        }

        public CartNoteUpdatePayload setCart(Cart arg) {
            optimisticData.put(getKey("cart"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CartUserError> getUserErrors() {
            return (List<CartUserError>) get("userErrors");
        }

        public CartNoteUpdatePayload setUserErrors(List<CartUserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cart": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public static class CartPaymentInput implements Serializable {
        private MoneyInput amount;

        private Input<String> sourceIdentifier = Input.undefined();

        private Input<CartFreePaymentMethodInput> freePaymentMethod = Input.undefined();

        private Input<CartDirectPaymentMethodInput> directPaymentMethod = Input.undefined();

        private Input<CartWalletPaymentMethodInput> walletPaymentMethod = Input.undefined();

        public CartPaymentInput(MoneyInput amount) {
            this.amount = amount;
        }

        public MoneyInput getAmount() {
            return amount;
        }

        public CartPaymentInput setAmount(MoneyInput amount) {
            this.amount = amount;
            return this;
        }

        public String getSourceIdentifier() {
            return sourceIdentifier.getValue();
        }

        public Input<String> getSourceIdentifierInput() {
            return sourceIdentifier;
        }

        public CartPaymentInput setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = Input.optional(sourceIdentifier);
            return this;
        }

        public CartPaymentInput setSourceIdentifierInput(Input<String> sourceIdentifier) {
            if (sourceIdentifier == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public CartFreePaymentMethodInput getFreePaymentMethod() {
            return freePaymentMethod.getValue();
        }

        public Input<CartFreePaymentMethodInput> getFreePaymentMethodInput() {
            return freePaymentMethod;
        }

        public CartPaymentInput setFreePaymentMethod(CartFreePaymentMethodInput freePaymentMethod) {
            this.freePaymentMethod = Input.optional(freePaymentMethod);
            return this;
        }

        public CartPaymentInput setFreePaymentMethodInput(Input<CartFreePaymentMethodInput> freePaymentMethod) {
            if (freePaymentMethod == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.freePaymentMethod = freePaymentMethod;
            return this;
        }

        public CartDirectPaymentMethodInput getDirectPaymentMethod() {
            return directPaymentMethod.getValue();
        }

        public Input<CartDirectPaymentMethodInput> getDirectPaymentMethodInput() {
            return directPaymentMethod;
        }

        public CartPaymentInput setDirectPaymentMethod(CartDirectPaymentMethodInput directPaymentMethod) {
            this.directPaymentMethod = Input.optional(directPaymentMethod);
            return this;
        }

        public CartPaymentInput setDirectPaymentMethodInput(Input<CartDirectPaymentMethodInput> directPaymentMethod) {
            if (directPaymentMethod == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.directPaymentMethod = directPaymentMethod;
            return this;
        }

        public CartWalletPaymentMethodInput getWalletPaymentMethod() {
            return walletPaymentMethod.getValue();
        }

        public Input<CartWalletPaymentMethodInput> getWalletPaymentMethodInput() {
            return walletPaymentMethod;
        }

        public CartPaymentInput setWalletPaymentMethod(CartWalletPaymentMethodInput walletPaymentMethod) {
            this.walletPaymentMethod = Input.optional(walletPaymentMethod);
            return this;
        }

        public CartPaymentInput setWalletPaymentMethodInput(Input<CartWalletPaymentMethodInput> walletPaymentMethod) {
            if (walletPaymentMethod == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.walletPaymentMethod = walletPaymentMethod;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("amount:");
            amount.appendTo(_queryBuilder);

            if (this.sourceIdentifier.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("sourceIdentifier:");
                if (sourceIdentifier.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, sourceIdentifier.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.freePaymentMethod.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("freePaymentMethod:");
                if (freePaymentMethod.getValue() != null) {
                    freePaymentMethod.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.directPaymentMethod.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("directPaymentMethod:");
                if (directPaymentMethod.getValue() != null) {
                    directPaymentMethod.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.walletPaymentMethod.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("walletPaymentMethod:");
                if (walletPaymentMethod.getValue() != null) {
                    walletPaymentMethod.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    public interface CartPaymentUpdatePayloadQueryDefinition {
        void define(CartPaymentUpdatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `cartPaymentUpdate` mutation.
    */
    public static class CartPaymentUpdatePayloadQuery extends Query<CartPaymentUpdatePayloadQuery> {
        CartPaymentUpdatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The updated cart.
        */
        public CartPaymentUpdatePayloadQuery cart(CartQueryDefinition queryDef) {
            startField("cart");

            _queryBuilder.append('{');
            queryDef.define(new CartQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CartPaymentUpdatePayloadQuery userErrors(CartUserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new CartUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `cartPaymentUpdate` mutation.
    */
    public static class CartPaymentUpdatePayload extends AbstractResponse<CartPaymentUpdatePayload> {
        public CartPaymentUpdatePayload() {
        }

        public CartPaymentUpdatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cart": {
                        Cart optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Cart(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<CartUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartPaymentUpdatePayload";
        }

        /**
        * The updated cart.
        */

        public Cart getCart() {
            return (Cart) get("cart");
        }

        public CartPaymentUpdatePayload setCart(Cart arg) {
            optimisticData.put(getKey("cart"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CartUserError> getUserErrors() {
            return (List<CartUserError>) get("userErrors");
        }

        public CartPaymentUpdatePayload setUserErrors(List<CartUserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cart": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CartPreferencesQueryDefinition {
        void define(CartPreferencesQuery _queryBuilder);
    }

    /**
    * A set of preferences tied to the buyer interacting with the cart. Preferences are used to prefill
    * fields in at checkout to streamline information collection. 
    * Preferences are not synced back to the cart if they are overwritten.
    */
    public static class CartPreferencesQuery extends Query<CartPreferencesQuery> {
        CartPreferencesQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * Delivery preferences can be used to prefill the delivery section in at checkout.
        */
        public CartPreferencesQuery delivery(CartDeliveryPreferenceQueryDefinition queryDef) {
            startField("delivery");

            _queryBuilder.append('{');
            queryDef.define(new CartDeliveryPreferenceQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * Wallet preferences are used to populate relevant payment fields in the checkout flow.
        * Accepted value: `["shop_pay"]`.
        */
        public CartPreferencesQuery wallet() {
            startField("wallet");

            return this;
        }
    }

    /**
    * A set of preferences tied to the buyer interacting with the cart. Preferences are used to prefill
    * fields in at checkout to streamline information collection. 
    * Preferences are not synced back to the cart if they are overwritten.
    */
    public static class CartPreferences extends AbstractResponse<CartPreferences> {
        public CartPreferences() {
        }

        public CartPreferences(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "delivery": {
                        CartDeliveryPreference optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new CartDeliveryPreference(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "wallet": {
                        List<String> optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            List<String> list1 = new ArrayList<>();
                            for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                                list1.add(jsonAsString(element1, key));
                            }

                            optional1 = list1;
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartPreferences";
        }

        /**
        * Delivery preferences can be used to prefill the delivery section in at checkout.
        */

        public CartDeliveryPreference getDelivery() {
            return (CartDeliveryPreference) get("delivery");
        }

        public CartPreferences setDelivery(CartDeliveryPreference arg) {
            optimisticData.put(getKey("delivery"), arg);
            return this;
        }

        /**
        * Wallet preferences are used to populate relevant payment fields in the checkout flow.
        * Accepted value: `["shop_pay"]`.
        */

        public List<String> getWallet() {
            return (List<String>) get("wallet");
        }

        public CartPreferences setWallet(List<String> arg) {
            optimisticData.put(getKey("wallet"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "delivery": return true;

                case "wallet": return false;

                default: return false;
            }
        }
    }

    public static class CartPreferencesInput implements Serializable {
        private Input<List<CartDeliveryPreferenceInput>> delivery = Input.undefined();

        private Input<List<String>> wallet = Input.undefined();

        public List<CartDeliveryPreferenceInput> getDelivery() {
            return delivery.getValue();
        }

        public Input<List<CartDeliveryPreferenceInput>> getDeliveryInput() {
            return delivery;
        }

        public CartPreferencesInput setDelivery(List<CartDeliveryPreferenceInput> delivery) {
            this.delivery = Input.optional(delivery);
            return this;
        }

        public CartPreferencesInput setDeliveryInput(Input<List<CartDeliveryPreferenceInput>> delivery) {
            if (delivery == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.delivery = delivery;
            return this;
        }

        public List<String> getWallet() {
            return wallet.getValue();
        }

        public Input<List<String>> getWalletInput() {
            return wallet;
        }

        public CartPreferencesInput setWallet(List<String> wallet) {
            this.wallet = Input.optional(wallet);
            return this;
        }

        public CartPreferencesInput setWalletInput(Input<List<String>> wallet) {
            if (wallet == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.wallet = wallet;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            if (this.delivery.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("delivery:");
                if (delivery.getValue() != null) {
                    _queryBuilder.append('[');
                    {
                        String listSeperator1 = "";
                        for (CartDeliveryPreferenceInput item1 : delivery.getValue()) {
                            _queryBuilder.append(listSeperator1);
                            listSeperator1 = ",";
                            item1.appendTo(_queryBuilder);
                        }
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.wallet.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("wallet:");
                if (wallet.getValue() != null) {
                    _queryBuilder.append('[');
                    {
                        String listSeperator1 = "";
                        for (String item1 : wallet.getValue()) {
                            _queryBuilder.append(listSeperator1);
                            listSeperator1 = ",";
                            Query.appendQuotedString(_queryBuilder, item1.toString());
                        }
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    public static class CartSelectedDeliveryOptionInput implements Serializable {
        private ID deliveryGroupId;

        private String deliveryOptionHandle;

        public CartSelectedDeliveryOptionInput(ID deliveryGroupId, String deliveryOptionHandle) {
            this.deliveryGroupId = deliveryGroupId;

            this.deliveryOptionHandle = deliveryOptionHandle;
        }

        public ID getDeliveryGroupId() {
            return deliveryGroupId;
        }

        public CartSelectedDeliveryOptionInput setDeliveryGroupId(ID deliveryGroupId) {
            this.deliveryGroupId = deliveryGroupId;
            return this;
        }

        public String getDeliveryOptionHandle() {
            return deliveryOptionHandle;
        }

        public CartSelectedDeliveryOptionInput setDeliveryOptionHandle(String deliveryOptionHandle) {
            this.deliveryOptionHandle = deliveryOptionHandle;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("deliveryGroupId:");
            Query.appendQuotedString(_queryBuilder, deliveryGroupId.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("deliveryOptionHandle:");
            Query.appendQuotedString(_queryBuilder, deliveryOptionHandle.toString());

            _queryBuilder.append('}');
        }
    }

    public interface CartSelectedDeliveryOptionsUpdatePayloadQueryDefinition {
        void define(CartSelectedDeliveryOptionsUpdatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `cartSelectedDeliveryOptionsUpdate` mutation.
    */
    public static class CartSelectedDeliveryOptionsUpdatePayloadQuery extends Query<CartSelectedDeliveryOptionsUpdatePayloadQuery> {
        CartSelectedDeliveryOptionsUpdatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The updated cart.
        */
        public CartSelectedDeliveryOptionsUpdatePayloadQuery cart(CartQueryDefinition queryDef) {
            startField("cart");

            _queryBuilder.append('{');
            queryDef.define(new CartQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CartSelectedDeliveryOptionsUpdatePayloadQuery userErrors(CartUserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new CartUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `cartSelectedDeliveryOptionsUpdate` mutation.
    */
    public static class CartSelectedDeliveryOptionsUpdatePayload extends AbstractResponse<CartSelectedDeliveryOptionsUpdatePayload> {
        public CartSelectedDeliveryOptionsUpdatePayload() {
        }

        public CartSelectedDeliveryOptionsUpdatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cart": {
                        Cart optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Cart(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<CartUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartSelectedDeliveryOptionsUpdatePayload";
        }

        /**
        * The updated cart.
        */

        public Cart getCart() {
            return (Cart) get("cart");
        }

        public CartSelectedDeliveryOptionsUpdatePayload setCart(Cart arg) {
            optimisticData.put(getKey("cart"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CartUserError> getUserErrors() {
            return (List<CartUserError>) get("userErrors");
        }

        public CartSelectedDeliveryOptionsUpdatePayload setUserErrors(List<CartUserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cart": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CartSubmitForCompletionPayloadQueryDefinition {
        void define(CartSubmitForCompletionPayloadQuery _queryBuilder);
    }

    /**
    * Return type for `cartSubmitForCompletion` mutation.
    */
    public static class CartSubmitForCompletionPayloadQuery extends Query<CartSubmitForCompletionPayloadQuery> {
        CartSubmitForCompletionPayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The result of cart submission for completion.
        */
        public CartSubmitForCompletionPayloadQuery result(CartSubmitForCompletionResultQueryDefinition queryDef) {
            startField("result");

            _queryBuilder.append('{');
            queryDef.define(new CartSubmitForCompletionResultQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CartSubmitForCompletionPayloadQuery userErrors(CartUserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new CartUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `cartSubmitForCompletion` mutation.
    */
    public static class CartSubmitForCompletionPayload extends AbstractResponse<CartSubmitForCompletionPayload> {
        public CartSubmitForCompletionPayload() {
        }

        public CartSubmitForCompletionPayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "result": {
                        CartSubmitForCompletionResult optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = UnknownCartSubmitForCompletionResult.create(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<CartUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartSubmitForCompletionPayload";
        }

        /**
        * The result of cart submission for completion.
        */

        public CartSubmitForCompletionResult getResult() {
            return (CartSubmitForCompletionResult) get("result");
        }

        public CartSubmitForCompletionPayload setResult(CartSubmitForCompletionResult arg) {
            optimisticData.put(getKey("result"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CartUserError> getUserErrors() {
            return (List<CartUserError>) get("userErrors");
        }

        public CartSubmitForCompletionPayload setUserErrors(List<CartUserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "result": return false;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CartSubmitForCompletionResultQueryDefinition {
        void define(CartSubmitForCompletionResultQuery _queryBuilder);
    }

    /**
    * The result of cart submit completion.
    */
    public static class CartSubmitForCompletionResultQuery extends Query<CartSubmitForCompletionResultQuery> {
        CartSubmitForCompletionResultQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("__typename");
        }

        public CartSubmitForCompletionResultQuery onSubmitAlreadyAccepted(SubmitAlreadyAcceptedQueryDefinition queryDef) {
            startInlineFragment("SubmitAlreadyAccepted");
            queryDef.define(new SubmitAlreadyAcceptedQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public CartSubmitForCompletionResultQuery onSubmitFailed(SubmitFailedQueryDefinition queryDef) {
            startInlineFragment("SubmitFailed");
            queryDef.define(new SubmitFailedQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public CartSubmitForCompletionResultQuery onSubmitSuccess(SubmitSuccessQueryDefinition queryDef) {
            startInlineFragment("SubmitSuccess");
            queryDef.define(new SubmitSuccessQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public CartSubmitForCompletionResultQuery onSubmitThrottled(SubmitThrottledQueryDefinition queryDef) {
            startInlineFragment("SubmitThrottled");
            queryDef.define(new SubmitThrottledQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }
    }

    public interface CartSubmitForCompletionResult {
        String getGraphQlTypeName();
    }

    /**
    * The result of cart submit completion.
    */
    public static class UnknownCartSubmitForCompletionResult extends AbstractResponse<UnknownCartSubmitForCompletionResult> implements CartSubmitForCompletionResult {
        public UnknownCartSubmitForCompletionResult() {
        }

        public UnknownCartSubmitForCompletionResult(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public static CartSubmitForCompletionResult create(JsonObject fields) throws SchemaViolationError {
            String typeName = fields.getAsJsonPrimitive("__typename").getAsString();
            switch (typeName) {
                case "SubmitAlreadyAccepted": {
                    return new SubmitAlreadyAccepted(fields);
                }

                case "SubmitFailed": {
                    return new SubmitFailed(fields);
                }

                case "SubmitSuccess": {
                    return new SubmitSuccess(fields);
                }

                case "SubmitThrottled": {
                    return new SubmitThrottled(fields);
                }

                default: {
                    return new UnknownCartSubmitForCompletionResult(fields);
                }
            }
        }

        public String getGraphQlTypeName() {
            return (String) get("__typename");
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                default: return false;
            }
        }
    }

    public interface CartUserErrorQueryDefinition {
        void define(CartUserErrorQuery _queryBuilder);
    }

    /**
    * Represents an error that happens during execution of a cart mutation.
    */
    public static class CartUserErrorQuery extends Query<CartUserErrorQuery> {
        CartUserErrorQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The error code.
        */
        public CartUserErrorQuery code() {
            startField("code");

            return this;
        }

        /**
        * The path to the input field that caused the error.
        */
        public CartUserErrorQuery field() {
            startField("field");

            return this;
        }

        /**
        * The error message.
        */
        public CartUserErrorQuery message() {
            startField("message");

            return this;
        }
    }

    /**
    * Represents an error that happens during execution of a cart mutation.
    */
    public static class CartUserError extends AbstractResponse<CartUserError> implements DisplayableError {
        public CartUserError() {
        }

        public CartUserError(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "code": {
                        CartErrorCode optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = CartErrorCode.fromGraphQl(jsonAsString(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "field": {
                        List<String> optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            List<String> list1 = new ArrayList<>();
                            for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                                list1.add(jsonAsString(element1, key));
                            }

                            optional1 = list1;
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "message": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CartUserError";
        }

        /**
        * The error code.
        */

        public CartErrorCode getCode() {
            return (CartErrorCode) get("code");
        }

        public CartUserError setCode(CartErrorCode arg) {
            optimisticData.put(getKey("code"), arg);
            return this;
        }

        /**
        * The path to the input field that caused the error.
        */

        public List<String> getField() {
            return (List<String>) get("field");
        }

        public CartUserError setField(List<String> arg) {
            optimisticData.put(getKey("field"), arg);
            return this;
        }

        /**
        * The error message.
        */

        public String getMessage() {
            return (String) get("message");
        }

        public CartUserError setMessage(String arg) {
            optimisticData.put(getKey("message"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "code": return false;

                case "field": return false;

                case "message": return false;

                default: return false;
            }
        }
    }

    public static class CartWalletPaymentMethodInput implements Serializable {
        private Input<ApplePayWalletContentInput> applePayWalletContent = Input.undefined();

        private Input<ShopPayWalletContentInput> shopPayWalletContent = Input.undefined();

        public ApplePayWalletContentInput getApplePayWalletContent() {
            return applePayWalletContent.getValue();
        }

        public Input<ApplePayWalletContentInput> getApplePayWalletContentInput() {
            return applePayWalletContent;
        }

        public CartWalletPaymentMethodInput setApplePayWalletContent(ApplePayWalletContentInput applePayWalletContent) {
            this.applePayWalletContent = Input.optional(applePayWalletContent);
            return this;
        }

        public CartWalletPaymentMethodInput setApplePayWalletContentInput(Input<ApplePayWalletContentInput> applePayWalletContent) {
            if (applePayWalletContent == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.applePayWalletContent = applePayWalletContent;
            return this;
        }

        public ShopPayWalletContentInput getShopPayWalletContent() {
            return shopPayWalletContent.getValue();
        }

        public Input<ShopPayWalletContentInput> getShopPayWalletContentInput() {
            return shopPayWalletContent;
        }

        public CartWalletPaymentMethodInput setShopPayWalletContent(ShopPayWalletContentInput shopPayWalletContent) {
            this.shopPayWalletContent = Input.optional(shopPayWalletContent);
            return this;
        }

        public CartWalletPaymentMethodInput setShopPayWalletContentInput(Input<ShopPayWalletContentInput> shopPayWalletContent) {
            if (shopPayWalletContent == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.shopPayWalletContent = shopPayWalletContent;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            if (this.applePayWalletContent.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("applePayWalletContent:");
                if (applePayWalletContent.getValue() != null) {
                    applePayWalletContent.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.shopPayWalletContent.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("shopPayWalletContent:");
                if (shopPayWalletContent.getValue() != null) {
                    shopPayWalletContent.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    public interface CollectionQueryDefinition {
        void define(CollectionQuery _queryBuilder);
    }

    /**
    * A collection represents a grouping of products that a shop owner can create to
    * organize them or make their shops easier to browse.
    */
    public static class CollectionQuery extends Query<CollectionQuery> {
        CollectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("id");
        }

        public class DescriptionArguments extends Arguments {
            DescriptionArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * Truncates string after the given length.
            */
            public DescriptionArguments truncateAt(Integer value) {
                if (value != null) {
                    startArgument("truncateAt");
                    _queryBuilder.append(value);
                }
                return this;
            }
        }

        public interface DescriptionArgumentsDefinition {
            void define(DescriptionArguments args);
        }

        /**
        * Stripped description of the collection, single line with HTML tags removed.
        */
        public CollectionQuery description() {
            return description(args -> {});
        }

        /**
        * Stripped description of the collection, single line with HTML tags removed.
        */
        public CollectionQuery description(DescriptionArgumentsDefinition argsDef) {
            startField("description");

            DescriptionArguments args = new DescriptionArguments(_queryBuilder);
            argsDef.define(args);
            DescriptionArguments.end(args);

            return this;
        }

        /**
        * The description of the collection, complete with HTML formatting.
        */
        public CollectionQuery descriptionHtml() {
            startField("descriptionHtml");

            return this;
        }

        /**
        * A human-friendly unique string for the collection automatically generated from its title.
        * Limit of 255 characters.
        */
        public CollectionQuery handle() {
            startField("handle");

            return this;
        }

        /**
        * Image associated with the collection.
        */
        public CollectionQuery image(ImageQueryDefinition queryDef) {
            startField("image");

            _queryBuilder.append('{');
            queryDef.define(new ImageQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        public class MetafieldArguments extends Arguments {
            MetafieldArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            /**
            * The container the metafield belongs to. If omitted, the app-reserved namespace will be used.
            */
            public MetafieldArguments namespace(String value) {
                if (value != null) {
                    startArgument("namespace");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }
        }

        public interface MetafieldArgumentsDefinition {
            void define(MetafieldArguments args);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public CollectionQuery metafield(String key, MetafieldQueryDefinition queryDef) {
            return metafield(key, args -> {}, queryDef);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public CollectionQuery metafield(String key, MetafieldArgumentsDefinition argsDef, MetafieldQueryDefinition queryDef) {
            startField("metafield");

            _queryBuilder.append("(key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            argsDef.define(new MetafieldArguments(_queryBuilder));

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */
        public CollectionQuery metafields(List<HasMetafieldsIdentifier> identifiers, MetafieldQueryDefinition queryDef) {
            startField("metafields");

            _queryBuilder.append("(identifiers:");
            _queryBuilder.append('[');
            {
                String listSeperator1 = "";
                for (HasMetafieldsIdentifier item1 : identifiers) {
                    _queryBuilder.append(listSeperator1);
                    listSeperator1 = ",";
                    item1.appendTo(_queryBuilder);
                }
            }
            _queryBuilder.append(']');

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The URL used for viewing the resource on the shop's Online Store. Returns `null` if the resource is
        * currently not published to the Online Store sales channel.
        */
        public CollectionQuery onlineStoreUrl() {
            startField("onlineStoreUrl");

            return this;
        }

        public class ProductsArguments extends Arguments {
            ProductsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * Returns up to the first `n` elements from the list.
            */
            public ProductsArguments first(Integer value) {
                if (value != null) {
                    startArgument("first");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come after the specified cursor.
            */
            public ProductsArguments after(String value) {
                if (value != null) {
                    startArgument("after");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Returns up to the last `n` elements from the list.
            */
            public ProductsArguments last(Integer value) {
                if (value != null) {
                    startArgument("last");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come before the specified cursor.
            */
            public ProductsArguments before(String value) {
                if (value != null) {
                    startArgument("before");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Reverse the order of the underlying list.
            */
            public ProductsArguments reverse(Boolean value) {
                if (value != null) {
                    startArgument("reverse");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Sort the underlying list by the given key.
            */
            public ProductsArguments sortKey(ProductCollectionSortKeys value) {
                if (value != null) {
                    startArgument("sortKey");
                    _queryBuilder.append(value.toString());
                }
                return this;
            }

            /**
            * Returns a subset of products matching all product filters.
            * The input must not contain more than `250` values.
            */
            public ProductsArguments filters(List<ProductFilter> value) {
                if (value != null) {
                    startArgument("filters");
                    _queryBuilder.append('[');
                    {
                        String listSeperator1 = "";
                        for (ProductFilter item1 : value) {
                            _queryBuilder.append(listSeperator1);
                            listSeperator1 = ",";
                            item1.appendTo(_queryBuilder);
                        }
                    }
                    _queryBuilder.append(']');
                }
                return this;
            }
        }

        public interface ProductsArgumentsDefinition {
            void define(ProductsArguments args);
        }

        /**
        * List of products in the collection.
        */
        public CollectionQuery products(ProductConnectionQueryDefinition queryDef) {
            return products(args -> {}, queryDef);
        }

        /**
        * List of products in the collection.
        */
        public CollectionQuery products(ProductsArgumentsDefinition argsDef, ProductConnectionQueryDefinition queryDef) {
            startField("products");

            ProductsArguments args = new ProductsArguments(_queryBuilder);
            argsDef.define(args);
            ProductsArguments.end(args);

            _queryBuilder.append('{');
            queryDef.define(new ProductConnectionQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The collection's SEO information.
        */
        public CollectionQuery seo(SEOQueryDefinition queryDef) {
            startField("seo");

            _queryBuilder.append('{');
            queryDef.define(new SEOQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The collection’s name. Limit of 255 characters.
        */
        public CollectionQuery title() {
            startField("title");

            return this;
        }

        /**
        * A URL parameters to be added to a page URL when it is linked from a GraphQL result. This allows for
        * tracking the origin of the traffic.
        */
        public CollectionQuery trackingParameters() {
            startField("trackingParameters");

            return this;
        }

        /**
        * The date and time when the collection was last modified.
        */
        public CollectionQuery updatedAt() {
            startField("updatedAt");

            return this;
        }
    }

    /**
    * A collection represents a grouping of products that a shop owner can create to
    * organize them or make their shops easier to browse.
    */
    public static class Collection extends AbstractResponse<Collection> implements HasMetafields, MenuItemResource, MetafieldParentResource, MetafieldReference, Node, OnlineStorePublishable, Trackable {
        public Collection() {
        }

        public Collection(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "description": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "descriptionHtml": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "handle": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "image": {
                        Image optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Image(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "metafield": {
                        Metafield optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Metafield(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "metafields": {
                        List<Metafield> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            Metafield optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = new Metafield(jsonAsObject(element1, key));
                            }

                            list1.add(optional2);
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "onlineStoreUrl": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "products": {
                        responseData.put(key, new ProductConnection(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "seo": {
                        responseData.put(key, new SEO(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "title": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "trackingParameters": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "updatedAt": {
                        responseData.put(key, Utils.parseDateTime(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public Collection(ID id) {
            this();
            optimisticData.put("id", id);
        }

        public String getGraphQlTypeName() {
            return "Collection";
        }

        /**
        * Stripped description of the collection, single line with HTML tags removed.
        */

        public String getDescription() {
            return (String) get("description");
        }

        public Collection setDescription(String arg) {
            optimisticData.put(getKey("description"), arg);
            return this;
        }

        /**
        * The description of the collection, complete with HTML formatting.
        */

        public String getDescriptionHtml() {
            return (String) get("descriptionHtml");
        }

        public Collection setDescriptionHtml(String arg) {
            optimisticData.put(getKey("descriptionHtml"), arg);
            return this;
        }

        /**
        * A human-friendly unique string for the collection automatically generated from its title.
        * Limit of 255 characters.
        */

        public String getHandle() {
            return (String) get("handle");
        }

        public Collection setHandle(String arg) {
            optimisticData.put(getKey("handle"), arg);
            return this;
        }

        /**
        * A globally-unique ID.
        */

        public ID getId() {
            return (ID) get("id");
        }

        /**
        * Image associated with the collection.
        */

        public Image getImage() {
            return (Image) get("image");
        }

        public Collection setImage(Image arg) {
            optimisticData.put(getKey("image"), arg);
            return this;
        }

        /**
        * Returns a metafield found by namespace and key.
        */

        public Metafield getMetafield() {
            return (Metafield) get("metafield");
        }

        public Collection setMetafield(Metafield arg) {
            optimisticData.put(getKey("metafield"), arg);
            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */

        public List<Metafield> getMetafields() {
            return (List<Metafield>) get("metafields");
        }

        public Collection setMetafields(List<Metafield> arg) {
            optimisticData.put(getKey("metafields"), arg);
            return this;
        }

        /**
        * The URL used for viewing the resource on the shop's Online Store. Returns `null` if the resource is
        * currently not published to the Online Store sales channel.
        */

        public String getOnlineStoreUrl() {
            return (String) get("onlineStoreUrl");
        }

        public Collection setOnlineStoreUrl(String arg) {
            optimisticData.put(getKey("onlineStoreUrl"), arg);
            return this;
        }

        /**
        * List of products in the collection.
        */

        public ProductConnection getProducts() {
            return (ProductConnection) get("products");
        }

        public Collection setProducts(ProductConnection arg) {
            optimisticData.put(getKey("products"), arg);
            return this;
        }

        /**
        * The collection's SEO information.
        */

        public SEO getSeo() {
            return (SEO) get("seo");
        }

        public Collection setSeo(SEO arg) {
            optimisticData.put(getKey("seo"), arg);
            return this;
        }

        /**
        * The collection’s name. Limit of 255 characters.
        */

        public String getTitle() {
            return (String) get("title");
        }

        public Collection setTitle(String arg) {
            optimisticData.put(getKey("title"), arg);
            return this;
        }

        /**
        * A URL parameters to be added to a page URL when it is linked from a GraphQL result. This allows for
        * tracking the origin of the traffic.
        */

        public String getTrackingParameters() {
            return (String) get("trackingParameters");
        }

        public Collection setTrackingParameters(String arg) {
            optimisticData.put(getKey("trackingParameters"), arg);
            return this;
        }

        /**
        * The date and time when the collection was last modified.
        */

        public DateTime getUpdatedAt() {
            return (DateTime) get("updatedAt");
        }

        public Collection setUpdatedAt(DateTime arg) {
            optimisticData.put(getKey("updatedAt"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "description": return false;

                case "descriptionHtml": return false;

                case "handle": return false;

                case "id": return false;

                case "image": return true;

                case "metafield": return true;

                case "metafields": return true;

                case "onlineStoreUrl": return false;

                case "products": return true;

                case "seo": return true;

                case "title": return false;

                case "trackingParameters": return false;

                case "updatedAt": return false;

                default: return false;
            }
        }
    }

    public interface CollectionConnectionQueryDefinition {
        void define(CollectionConnectionQuery _queryBuilder);
    }

    /**
    * An auto-generated type for paginating through multiple Collections.
    */
    public static class CollectionConnectionQuery extends Query<CollectionConnectionQuery> {
        CollectionConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A list of edges.
        */
        public CollectionConnectionQuery edges(CollectionEdgeQueryDefinition queryDef) {
            startField("edges");

            _queryBuilder.append('{');
            queryDef.define(new CollectionEdgeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A list of the nodes contained in CollectionEdge.
        */
        public CollectionConnectionQuery nodes(CollectionQueryDefinition queryDef) {
            startField("nodes");

            _queryBuilder.append('{');
            queryDef.define(new CollectionQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * Information to aid in pagination.
        */
        public CollectionConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            startField("pageInfo");

            _queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The total count of Collections.
        */
        public CollectionConnectionQuery totalCount() {
            startField("totalCount");

            return this;
        }
    }

    /**
    * An auto-generated type for paginating through multiple Collections.
    */
    public static class CollectionConnection extends AbstractResponse<CollectionConnection> {
        public CollectionConnection() {
        }

        public CollectionConnection(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "edges": {
                        List<CollectionEdge> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CollectionEdge(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "nodes": {
                        List<Collection> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new Collection(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "pageInfo": {
                        responseData.put(key, new PageInfo(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "totalCount": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CollectionConnection";
        }

        /**
        * A list of edges.
        */

        public List<CollectionEdge> getEdges() {
            return (List<CollectionEdge>) get("edges");
        }

        public CollectionConnection setEdges(List<CollectionEdge> arg) {
            optimisticData.put(getKey("edges"), arg);
            return this;
        }

        /**
        * A list of the nodes contained in CollectionEdge.
        */

        public List<Collection> getNodes() {
            return (List<Collection>) get("nodes");
        }

        public CollectionConnection setNodes(List<Collection> arg) {
            optimisticData.put(getKey("nodes"), arg);
            return this;
        }

        /**
        * Information to aid in pagination.
        */

        public PageInfo getPageInfo() {
            return (PageInfo) get("pageInfo");
        }

        public CollectionConnection setPageInfo(PageInfo arg) {
            optimisticData.put(getKey("pageInfo"), arg);
            return this;
        }

        /**
        * The total count of Collections.
        */

        public String getTotalCount() {
            return (String) get("totalCount");
        }

        public CollectionConnection setTotalCount(String arg) {
            optimisticData.put(getKey("totalCount"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "edges": return true;

                case "nodes": return true;

                case "pageInfo": return true;

                case "totalCount": return false;

                default: return false;
            }
        }
    }

    public interface CollectionEdgeQueryDefinition {
        void define(CollectionEdgeQuery _queryBuilder);
    }

    /**
    * An auto-generated type which holds one Collection and a cursor during pagination.
    */
    public static class CollectionEdgeQuery extends Query<CollectionEdgeQuery> {
        CollectionEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A cursor for use in pagination.
        */
        public CollectionEdgeQuery cursor() {
            startField("cursor");

            return this;
        }

        /**
        * The item at the end of CollectionEdge.
        */
        public CollectionEdgeQuery node(CollectionQueryDefinition queryDef) {
            startField("node");

            _queryBuilder.append('{');
            queryDef.define(new CollectionQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type which holds one Collection and a cursor during pagination.
    */
    public static class CollectionEdge extends AbstractResponse<CollectionEdge> {
        public CollectionEdge() {
        }

        public CollectionEdge(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cursor": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "node": {
                        responseData.put(key, new Collection(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CollectionEdge";
        }

        /**
        * A cursor for use in pagination.
        */

        public String getCursor() {
            return (String) get("cursor");
        }

        public CollectionEdge setCursor(String arg) {
            optimisticData.put(getKey("cursor"), arg);
            return this;
        }

        /**
        * The item at the end of CollectionEdge.
        */

        public Collection getNode() {
            return (Collection) get("node");
        }

        public CollectionEdge setNode(Collection arg) {
            optimisticData.put(getKey("node"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cursor": return false;

                case "node": return true;

                default: return false;
            }
        }
    }

    /**
    * The set of valid sort keys for the Collection query.
    */
    public enum CollectionSortKeys {
        /**
        * Sort by the `id` value.
        */
        ID,

        /**
        * Sort by relevance to the search terms when the `query` parameter is specified on the connection.
        * Don't use this sort key when no search query is specified.
        */
        RELEVANCE,

        /**
        * Sort by the `title` value.
        */
        TITLE,

        /**
        * Sort by the `updated_at` value.
        */
        UPDATED_AT,

        UNKNOWN_VALUE;

        public static CollectionSortKeys fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "ID": {
                    return ID;
                }

                case "RELEVANCE": {
                    return RELEVANCE;
                }

                case "TITLE": {
                    return TITLE;
                }

                case "UPDATED_AT": {
                    return UPDATED_AT;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case ID: {
                    return "ID";
                }

                case RELEVANCE: {
                    return "RELEVANCE";
                }

                case TITLE: {
                    return "TITLE";
                }

                case UPDATED_AT: {
                    return "UPDATED_AT";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface CommentQueryDefinition {
        void define(CommentQuery _queryBuilder);
    }

    /**
    * A comment on an article.
    */
    public static class CommentQuery extends Query<CommentQuery> {
        CommentQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("id");
        }

        /**
        * The comment’s author.
        */
        public CommentQuery author(CommentAuthorQueryDefinition queryDef) {
            startField("author");

            _queryBuilder.append('{');
            queryDef.define(new CommentAuthorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        public class ContentArguments extends Arguments {
            ContentArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * Truncates string after the given length.
            */
            public ContentArguments truncateAt(Integer value) {
                if (value != null) {
                    startArgument("truncateAt");
                    _queryBuilder.append(value);
                }
                return this;
            }
        }

        public interface ContentArgumentsDefinition {
            void define(ContentArguments args);
        }

        /**
        * Stripped content of the comment, single line with HTML tags removed.
        */
        public CommentQuery content() {
            return content(args -> {});
        }

        /**
        * Stripped content of the comment, single line with HTML tags removed.
        */
        public CommentQuery content(ContentArgumentsDefinition argsDef) {
            startField("content");

            ContentArguments args = new ContentArguments(_queryBuilder);
            argsDef.define(args);
            ContentArguments.end(args);

            return this;
        }

        /**
        * The content of the comment, complete with HTML formatting.
        */
        public CommentQuery contentHtml() {
            startField("contentHtml");

            return this;
        }
    }

    /**
    * A comment on an article.
    */
    public static class Comment extends AbstractResponse<Comment> implements Node {
        public Comment() {
        }

        public Comment(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "author": {
                        responseData.put(key, new CommentAuthor(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "content": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "contentHtml": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public Comment(ID id) {
            this();
            optimisticData.put("id", id);
        }

        public String getGraphQlTypeName() {
            return "Comment";
        }

        /**
        * The comment’s author.
        */

        public CommentAuthor getAuthor() {
            return (CommentAuthor) get("author");
        }

        public Comment setAuthor(CommentAuthor arg) {
            optimisticData.put(getKey("author"), arg);
            return this;
        }

        /**
        * Stripped content of the comment, single line with HTML tags removed.
        */

        public String getContent() {
            return (String) get("content");
        }

        public Comment setContent(String arg) {
            optimisticData.put(getKey("content"), arg);
            return this;
        }

        /**
        * The content of the comment, complete with HTML formatting.
        */

        public String getContentHtml() {
            return (String) get("contentHtml");
        }

        public Comment setContentHtml(String arg) {
            optimisticData.put(getKey("contentHtml"), arg);
            return this;
        }

        /**
        * A globally-unique ID.
        */

        public ID getId() {
            return (ID) get("id");
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "author": return true;

                case "content": return false;

                case "contentHtml": return false;

                case "id": return false;

                default: return false;
            }
        }
    }

    public interface CommentAuthorQueryDefinition {
        void define(CommentAuthorQuery _queryBuilder);
    }

    /**
    * The author of a comment.
    */
    public static class CommentAuthorQuery extends Query<CommentAuthorQuery> {
        CommentAuthorQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The author's email.
        */
        public CommentAuthorQuery email() {
            startField("email");

            return this;
        }

        /**
        * The author’s name.
        */
        public CommentAuthorQuery name() {
            startField("name");

            return this;
        }
    }

    /**
    * The author of a comment.
    */
    public static class CommentAuthor extends AbstractResponse<CommentAuthor> {
        public CommentAuthor() {
        }

        public CommentAuthor(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "email": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "name": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CommentAuthor";
        }

        /**
        * The author's email.
        */

        public String getEmail() {
            return (String) get("email");
        }

        public CommentAuthor setEmail(String arg) {
            optimisticData.put(getKey("email"), arg);
            return this;
        }

        /**
        * The author’s name.
        */

        public String getName() {
            return (String) get("name");
        }

        public CommentAuthor setName(String arg) {
            optimisticData.put(getKey("name"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "email": return false;

                case "name": return false;

                default: return false;
            }
        }
    }

    public interface CommentConnectionQueryDefinition {
        void define(CommentConnectionQuery _queryBuilder);
    }

    /**
    * An auto-generated type for paginating through multiple Comments.
    */
    public static class CommentConnectionQuery extends Query<CommentConnectionQuery> {
        CommentConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A list of edges.
        */
        public CommentConnectionQuery edges(CommentEdgeQueryDefinition queryDef) {
            startField("edges");

            _queryBuilder.append('{');
            queryDef.define(new CommentEdgeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A list of the nodes contained in CommentEdge.
        */
        public CommentConnectionQuery nodes(CommentQueryDefinition queryDef) {
            startField("nodes");

            _queryBuilder.append('{');
            queryDef.define(new CommentQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * Information to aid in pagination.
        */
        public CommentConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            startField("pageInfo");

            _queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type for paginating through multiple Comments.
    */
    public static class CommentConnection extends AbstractResponse<CommentConnection> {
        public CommentConnection() {
        }

        public CommentConnection(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "edges": {
                        List<CommentEdge> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CommentEdge(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "nodes": {
                        List<Comment> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new Comment(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "pageInfo": {
                        responseData.put(key, new PageInfo(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CommentConnection";
        }

        /**
        * A list of edges.
        */

        public List<CommentEdge> getEdges() {
            return (List<CommentEdge>) get("edges");
        }

        public CommentConnection setEdges(List<CommentEdge> arg) {
            optimisticData.put(getKey("edges"), arg);
            return this;
        }

        /**
        * A list of the nodes contained in CommentEdge.
        */

        public List<Comment> getNodes() {
            return (List<Comment>) get("nodes");
        }

        public CommentConnection setNodes(List<Comment> arg) {
            optimisticData.put(getKey("nodes"), arg);
            return this;
        }

        /**
        * Information to aid in pagination.
        */

        public PageInfo getPageInfo() {
            return (PageInfo) get("pageInfo");
        }

        public CommentConnection setPageInfo(PageInfo arg) {
            optimisticData.put(getKey("pageInfo"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "edges": return true;

                case "nodes": return true;

                case "pageInfo": return true;

                default: return false;
            }
        }
    }

    public interface CommentEdgeQueryDefinition {
        void define(CommentEdgeQuery _queryBuilder);
    }

    /**
    * An auto-generated type which holds one Comment and a cursor during pagination.
    */
    public static class CommentEdgeQuery extends Query<CommentEdgeQuery> {
        CommentEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A cursor for use in pagination.
        */
        public CommentEdgeQuery cursor() {
            startField("cursor");

            return this;
        }

        /**
        * The item at the end of CommentEdge.
        */
        public CommentEdgeQuery node(CommentQueryDefinition queryDef) {
            startField("node");

            _queryBuilder.append('{');
            queryDef.define(new CommentQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type which holds one Comment and a cursor during pagination.
    */
    public static class CommentEdge extends AbstractResponse<CommentEdge> {
        public CommentEdge() {
        }

        public CommentEdge(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cursor": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "node": {
                        responseData.put(key, new Comment(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CommentEdge";
        }

        /**
        * A cursor for use in pagination.
        */

        public String getCursor() {
            return (String) get("cursor");
        }

        public CommentEdge setCursor(String arg) {
            optimisticData.put(getKey("cursor"), arg);
            return this;
        }

        /**
        * The item at the end of CommentEdge.
        */

        public Comment getNode() {
            return (Comment) get("node");
        }

        public CommentEdge setNode(Comment arg) {
            optimisticData.put(getKey("node"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cursor": return false;

                case "node": return true;

                default: return false;
            }
        }
    }

    public interface CompanyQueryDefinition {
        void define(CompanyQuery _queryBuilder);
    }

    /**
    * Represents information about a company which is also a customer of the shop.
    */
    public static class CompanyQuery extends Query<CompanyQuery> {
        CompanyQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("id");
        }

        /**
        * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company
        * was created in Shopify.
        */
        public CompanyQuery createdAt() {
            startField("createdAt");

            return this;
        }

        /**
        * A unique externally-supplied ID for the company.
        */
        public CompanyQuery externalId() {
            startField("externalId");

            return this;
        }

        public class MetafieldArguments extends Arguments {
            MetafieldArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            /**
            * The container the metafield belongs to. If omitted, the app-reserved namespace will be used.
            */
            public MetafieldArguments namespace(String value) {
                if (value != null) {
                    startArgument("namespace");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }
        }

        public interface MetafieldArgumentsDefinition {
            void define(MetafieldArguments args);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public CompanyQuery metafield(String key, MetafieldQueryDefinition queryDef) {
            return metafield(key, args -> {}, queryDef);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public CompanyQuery metafield(String key, MetafieldArgumentsDefinition argsDef, MetafieldQueryDefinition queryDef) {
            startField("metafield");

            _queryBuilder.append("(key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            argsDef.define(new MetafieldArguments(_queryBuilder));

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */
        public CompanyQuery metafields(List<HasMetafieldsIdentifier> identifiers, MetafieldQueryDefinition queryDef) {
            startField("metafields");

            _queryBuilder.append("(identifiers:");
            _queryBuilder.append('[');
            {
                String listSeperator1 = "";
                for (HasMetafieldsIdentifier item1 : identifiers) {
                    _queryBuilder.append(listSeperator1);
                    listSeperator1 = ",";
                    item1.appendTo(_queryBuilder);
                }
            }
            _queryBuilder.append(']');

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The name of the company.
        */
        public CompanyQuery name() {
            startField("name");

            return this;
        }

        /**
        * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company
        * was last modified.
        */
        public CompanyQuery updatedAt() {
            startField("updatedAt");

            return this;
        }
    }

    /**
    * Represents information about a company which is also a customer of the shop.
    */
    public static class Company extends AbstractResponse<Company> implements HasMetafields, MetafieldParentResource, Node {
        public Company() {
        }

        public Company(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "createdAt": {
                        responseData.put(key, Utils.parseDateTime(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "externalId": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "metafield": {
                        Metafield optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Metafield(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "metafields": {
                        List<Metafield> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            Metafield optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = new Metafield(jsonAsObject(element1, key));
                            }

                            list1.add(optional2);
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "name": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "updatedAt": {
                        responseData.put(key, Utils.parseDateTime(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public Company(ID id) {
            this();
            optimisticData.put("id", id);
        }

        public String getGraphQlTypeName() {
            return "Company";
        }

        /**
        * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company
        * was created in Shopify.
        */

        public DateTime getCreatedAt() {
            return (DateTime) get("createdAt");
        }

        public Company setCreatedAt(DateTime arg) {
            optimisticData.put(getKey("createdAt"), arg);
            return this;
        }

        /**
        * A unique externally-supplied ID for the company.
        */

        public String getExternalId() {
            return (String) get("externalId");
        }

        public Company setExternalId(String arg) {
            optimisticData.put(getKey("externalId"), arg);
            return this;
        }

        /**
        * A globally-unique ID.
        */

        public ID getId() {
            return (ID) get("id");
        }

        /**
        * Returns a metafield found by namespace and key.
        */

        public Metafield getMetafield() {
            return (Metafield) get("metafield");
        }

        public Company setMetafield(Metafield arg) {
            optimisticData.put(getKey("metafield"), arg);
            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */

        public List<Metafield> getMetafields() {
            return (List<Metafield>) get("metafields");
        }

        public Company setMetafields(List<Metafield> arg) {
            optimisticData.put(getKey("metafields"), arg);
            return this;
        }

        /**
        * The name of the company.
        */

        public String getName() {
            return (String) get("name");
        }

        public Company setName(String arg) {
            optimisticData.put(getKey("name"), arg);
            return this;
        }

        /**
        * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company
        * was last modified.
        */

        public DateTime getUpdatedAt() {
            return (DateTime) get("updatedAt");
        }

        public Company setUpdatedAt(DateTime arg) {
            optimisticData.put(getKey("updatedAt"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "createdAt": return false;

                case "externalId": return false;

                case "id": return false;

                case "metafield": return true;

                case "metafields": return true;

                case "name": return false;

                case "updatedAt": return false;

                default: return false;
            }
        }
    }

    public interface CompanyContactQueryDefinition {
        void define(CompanyContactQuery _queryBuilder);
    }

    /**
    * A company's main point of contact.
    */
    public static class CompanyContactQuery extends Query<CompanyContactQuery> {
        CompanyContactQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("id");
        }

        /**
        * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company
        * contact was created in Shopify.
        */
        public CompanyContactQuery createdAt() {
            startField("createdAt");

            return this;
        }

        /**
        * The company contact's locale (language).
        */
        public CompanyContactQuery locale() {
            startField("locale");

            return this;
        }

        /**
        * The company contact's job title.
        */
        public CompanyContactQuery title() {
            startField("title");

            return this;
        }

        /**
        * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company
        * contact was last modified.
        */
        public CompanyContactQuery updatedAt() {
            startField("updatedAt");

            return this;
        }
    }

    /**
    * A company's main point of contact.
    */
    public static class CompanyContact extends AbstractResponse<CompanyContact> implements Node {
        public CompanyContact() {
        }

        public CompanyContact(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "createdAt": {
                        responseData.put(key, Utils.parseDateTime(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "locale": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "title": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "updatedAt": {
                        responseData.put(key, Utils.parseDateTime(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public CompanyContact(ID id) {
            this();
            optimisticData.put("id", id);
        }

        public String getGraphQlTypeName() {
            return "CompanyContact";
        }

        /**
        * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company
        * contact was created in Shopify.
        */

        public DateTime getCreatedAt() {
            return (DateTime) get("createdAt");
        }

        public CompanyContact setCreatedAt(DateTime arg) {
            optimisticData.put(getKey("createdAt"), arg);
            return this;
        }

        /**
        * A globally-unique ID.
        */

        public ID getId() {
            return (ID) get("id");
        }

        /**
        * The company contact's locale (language).
        */

        public String getLocale() {
            return (String) get("locale");
        }

        public CompanyContact setLocale(String arg) {
            optimisticData.put(getKey("locale"), arg);
            return this;
        }

        /**
        * The company contact's job title.
        */

        public String getTitle() {
            return (String) get("title");
        }

        public CompanyContact setTitle(String arg) {
            optimisticData.put(getKey("title"), arg);
            return this;
        }

        /**
        * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company
        * contact was last modified.
        */

        public DateTime getUpdatedAt() {
            return (DateTime) get("updatedAt");
        }

        public CompanyContact setUpdatedAt(DateTime arg) {
            optimisticData.put(getKey("updatedAt"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "createdAt": return false;

                case "id": return false;

                case "locale": return false;

                case "title": return false;

                case "updatedAt": return false;

                default: return false;
            }
        }
    }

    public interface CompanyLocationQueryDefinition {
        void define(CompanyLocationQuery _queryBuilder);
    }

    /**
    * A company's location.
    */
    public static class CompanyLocationQuery extends Query<CompanyLocationQuery> {
        CompanyLocationQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("id");
        }

        /**
        * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company
        * location was created in Shopify.
        */
        public CompanyLocationQuery createdAt() {
            startField("createdAt");

            return this;
        }

        /**
        * A unique externally-supplied ID for the company.
        */
        public CompanyLocationQuery externalId() {
            startField("externalId");

            return this;
        }

        /**
        * The preferred locale of the company location.
        */
        public CompanyLocationQuery locale() {
            startField("locale");

            return this;
        }

        public class MetafieldArguments extends Arguments {
            MetafieldArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            /**
            * The container the metafield belongs to. If omitted, the app-reserved namespace will be used.
            */
            public MetafieldArguments namespace(String value) {
                if (value != null) {
                    startArgument("namespace");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }
        }

        public interface MetafieldArgumentsDefinition {
            void define(MetafieldArguments args);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public CompanyLocationQuery metafield(String key, MetafieldQueryDefinition queryDef) {
            return metafield(key, args -> {}, queryDef);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public CompanyLocationQuery metafield(String key, MetafieldArgumentsDefinition argsDef, MetafieldQueryDefinition queryDef) {
            startField("metafield");

            _queryBuilder.append("(key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            argsDef.define(new MetafieldArguments(_queryBuilder));

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */
        public CompanyLocationQuery metafields(List<HasMetafieldsIdentifier> identifiers, MetafieldQueryDefinition queryDef) {
            startField("metafields");

            _queryBuilder.append("(identifiers:");
            _queryBuilder.append('[');
            {
                String listSeperator1 = "";
                for (HasMetafieldsIdentifier item1 : identifiers) {
                    _queryBuilder.append(listSeperator1);
                    listSeperator1 = ",";
                    item1.appendTo(_queryBuilder);
                }
            }
            _queryBuilder.append(']');

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The name of the company location.
        */
        public CompanyLocationQuery name() {
            startField("name");

            return this;
        }

        /**
        * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company
        * location was last modified.
        */
        public CompanyLocationQuery updatedAt() {
            startField("updatedAt");

            return this;
        }
    }

    /**
    * A company's location.
    */
    public static class CompanyLocation extends AbstractResponse<CompanyLocation> implements HasMetafields, MetafieldParentResource, Node {
        public CompanyLocation() {
        }

        public CompanyLocation(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "createdAt": {
                        responseData.put(key, Utils.parseDateTime(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "externalId": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "locale": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "metafield": {
                        Metafield optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Metafield(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "metafields": {
                        List<Metafield> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            Metafield optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = new Metafield(jsonAsObject(element1, key));
                            }

                            list1.add(optional2);
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "name": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "updatedAt": {
                        responseData.put(key, Utils.parseDateTime(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public CompanyLocation(ID id) {
            this();
            optimisticData.put("id", id);
        }

        public String getGraphQlTypeName() {
            return "CompanyLocation";
        }

        /**
        * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company
        * location was created in Shopify.
        */

        public DateTime getCreatedAt() {
            return (DateTime) get("createdAt");
        }

        public CompanyLocation setCreatedAt(DateTime arg) {
            optimisticData.put(getKey("createdAt"), arg);
            return this;
        }

        /**
        * A unique externally-supplied ID for the company.
        */

        public String getExternalId() {
            return (String) get("externalId");
        }

        public CompanyLocation setExternalId(String arg) {
            optimisticData.put(getKey("externalId"), arg);
            return this;
        }

        /**
        * A globally-unique ID.
        */

        public ID getId() {
            return (ID) get("id");
        }

        /**
        * The preferred locale of the company location.
        */

        public String getLocale() {
            return (String) get("locale");
        }

        public CompanyLocation setLocale(String arg) {
            optimisticData.put(getKey("locale"), arg);
            return this;
        }

        /**
        * Returns a metafield found by namespace and key.
        */

        public Metafield getMetafield() {
            return (Metafield) get("metafield");
        }

        public CompanyLocation setMetafield(Metafield arg) {
            optimisticData.put(getKey("metafield"), arg);
            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */

        public List<Metafield> getMetafields() {
            return (List<Metafield>) get("metafields");
        }

        public CompanyLocation setMetafields(List<Metafield> arg) {
            optimisticData.put(getKey("metafields"), arg);
            return this;
        }

        /**
        * The name of the company location.
        */

        public String getName() {
            return (String) get("name");
        }

        public CompanyLocation setName(String arg) {
            optimisticData.put(getKey("name"), arg);
            return this;
        }

        /**
        * The date and time ([ISO 8601 format](http://en.wikipedia.org/wiki/ISO_8601)) at which the company
        * location was last modified.
        */

        public DateTime getUpdatedAt() {
            return (DateTime) get("updatedAt");
        }

        public CompanyLocation setUpdatedAt(DateTime arg) {
            optimisticData.put(getKey("updatedAt"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "createdAt": return false;

                case "externalId": return false;

                case "id": return false;

                case "locale": return false;

                case "metafield": return true;

                case "metafields": return true;

                case "name": return false;

                case "updatedAt": return false;

                default: return false;
            }
        }
    }

    public interface CompletePaymentChallengeQueryDefinition {
        void define(CompletePaymentChallengeQuery _queryBuilder);
    }

    /**
    * The action for the 3DS payment redirect.
    */
    public static class CompletePaymentChallengeQuery extends Query<CompletePaymentChallengeQuery> {
        CompletePaymentChallengeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The URL for the 3DS payment redirect.
        */
        public CompletePaymentChallengeQuery redirectUrl() {
            startField("redirectUrl");

            return this;
        }
    }

    /**
    * The action for the 3DS payment redirect.
    */
    public static class CompletePaymentChallenge extends AbstractResponse<CompletePaymentChallenge> implements CartCompletionAction {
        public CompletePaymentChallenge() {
        }

        public CompletePaymentChallenge(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "redirectUrl": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CompletePaymentChallenge";
        }

        /**
        * The URL for the 3DS payment redirect.
        */

        public String getRedirectUrl() {
            return (String) get("redirectUrl");
        }

        public CompletePaymentChallenge setRedirectUrl(String arg) {
            optimisticData.put(getKey("redirectUrl"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "redirectUrl": return false;

                default: return false;
            }
        }
    }

    public interface CompletionErrorQueryDefinition {
        void define(CompletionErrorQuery _queryBuilder);
    }

    /**
    * An error that occurred during a cart completion attempt.
    */
    public static class CompletionErrorQuery extends Query<CompletionErrorQuery> {
        CompletionErrorQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The error code.
        */
        public CompletionErrorQuery code() {
            startField("code");

            return this;
        }

        /**
        * The error message.
        */
        public CompletionErrorQuery message() {
            startField("message");

            return this;
        }
    }

    /**
    * An error that occurred during a cart completion attempt.
    */
    public static class CompletionError extends AbstractResponse<CompletionError> {
        public CompletionError() {
        }

        public CompletionError(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "code": {
                        responseData.put(key, CompletionErrorCode.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "message": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CompletionError";
        }

        /**
        * The error code.
        */

        public CompletionErrorCode getCode() {
            return (CompletionErrorCode) get("code");
        }

        public CompletionError setCode(CompletionErrorCode arg) {
            optimisticData.put(getKey("code"), arg);
            return this;
        }

        /**
        * The error message.
        */

        public String getMessage() {
            return (String) get("message");
        }

        public CompletionError setMessage(String arg) {
            optimisticData.put(getKey("message"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "code": return false;

                case "message": return false;

                default: return false;
            }
        }
    }

    /**
    * The code of the error that occurred during a cart completion attempt.
    */
    public enum CompletionErrorCode {
        ERROR,

        INVENTORY_RESERVATION_ERROR,

        PAYMENT_AMOUNT_TOO_SMALL,

        PAYMENT_CALL_ISSUER,

        PAYMENT_CARD_DECLINED,

        PAYMENT_ERROR,

        PAYMENT_GATEWAY_NOT_ENABLED_ERROR,

        PAYMENT_INSUFFICIENT_FUNDS,

        PAYMENT_INVALID_BILLING_ADDRESS,

        PAYMENT_INVALID_CREDIT_CARD,

        PAYMENT_INVALID_CURRENCY,

        PAYMENT_INVALID_PAYMENT_METHOD,

        PAYMENT_TRANSIENT_ERROR,

        UNKNOWN_VALUE;

        public static CompletionErrorCode fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "ERROR": {
                    return ERROR;
                }

                case "INVENTORY_RESERVATION_ERROR": {
                    return INVENTORY_RESERVATION_ERROR;
                }

                case "PAYMENT_AMOUNT_TOO_SMALL": {
                    return PAYMENT_AMOUNT_TOO_SMALL;
                }

                case "PAYMENT_CALL_ISSUER": {
                    return PAYMENT_CALL_ISSUER;
                }

                case "PAYMENT_CARD_DECLINED": {
                    return PAYMENT_CARD_DECLINED;
                }

                case "PAYMENT_ERROR": {
                    return PAYMENT_ERROR;
                }

                case "PAYMENT_GATEWAY_NOT_ENABLED_ERROR": {
                    return PAYMENT_GATEWAY_NOT_ENABLED_ERROR;
                }

                case "PAYMENT_INSUFFICIENT_FUNDS": {
                    return PAYMENT_INSUFFICIENT_FUNDS;
                }

                case "PAYMENT_INVALID_BILLING_ADDRESS": {
                    return PAYMENT_INVALID_BILLING_ADDRESS;
                }

                case "PAYMENT_INVALID_CREDIT_CARD": {
                    return PAYMENT_INVALID_CREDIT_CARD;
                }

                case "PAYMENT_INVALID_CURRENCY": {
                    return PAYMENT_INVALID_CURRENCY;
                }

                case "PAYMENT_INVALID_PAYMENT_METHOD": {
                    return PAYMENT_INVALID_PAYMENT_METHOD;
                }

                case "PAYMENT_TRANSIENT_ERROR": {
                    return PAYMENT_TRANSIENT_ERROR;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case ERROR: {
                    return "ERROR";
                }

                case INVENTORY_RESERVATION_ERROR: {
                    return "INVENTORY_RESERVATION_ERROR";
                }

                case PAYMENT_AMOUNT_TOO_SMALL: {
                    return "PAYMENT_AMOUNT_TOO_SMALL";
                }

                case PAYMENT_CALL_ISSUER: {
                    return "PAYMENT_CALL_ISSUER";
                }

                case PAYMENT_CARD_DECLINED: {
                    return "PAYMENT_CARD_DECLINED";
                }

                case PAYMENT_ERROR: {
                    return "PAYMENT_ERROR";
                }

                case PAYMENT_GATEWAY_NOT_ENABLED_ERROR: {
                    return "PAYMENT_GATEWAY_NOT_ENABLED_ERROR";
                }

                case PAYMENT_INSUFFICIENT_FUNDS: {
                    return "PAYMENT_INSUFFICIENT_FUNDS";
                }

                case PAYMENT_INVALID_BILLING_ADDRESS: {
                    return "PAYMENT_INVALID_BILLING_ADDRESS";
                }

                case PAYMENT_INVALID_CREDIT_CARD: {
                    return "PAYMENT_INVALID_CREDIT_CARD";
                }

                case PAYMENT_INVALID_CURRENCY: {
                    return "PAYMENT_INVALID_CURRENCY";
                }

                case PAYMENT_INVALID_PAYMENT_METHOD: {
                    return "PAYMENT_INVALID_PAYMENT_METHOD";
                }

                case PAYMENT_TRANSIENT_ERROR: {
                    return "PAYMENT_TRANSIENT_ERROR";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface ComponentizableCartLineQueryDefinition {
        void define(ComponentizableCartLineQuery _queryBuilder);
    }

    /**
    * Represents information about the grouped merchandise in the cart.
    */
    public static class ComponentizableCartLineQuery extends Query<ComponentizableCartLineQuery> {
        ComponentizableCartLineQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("id");
        }

        /**
        * An attribute associated with the cart line.
        */
        public ComponentizableCartLineQuery attribute(String key, AttributeQueryDefinition queryDef) {
            startField("attribute");

            _queryBuilder.append("(key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new AttributeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The attributes associated with the cart line. Attributes are represented as key-value pairs.
        */
        public ComponentizableCartLineQuery attributes(AttributeQueryDefinition queryDef) {
            startField("attributes");

            _queryBuilder.append('{');
            queryDef.define(new AttributeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The cost of the merchandise that the buyer will pay for at checkout. The costs are subject to change
        * and changes will be reflected at checkout.
        */
        public ComponentizableCartLineQuery cost(CartLineCostQueryDefinition queryDef) {
            startField("cost");

            _queryBuilder.append('{');
            queryDef.define(new CartLineCostQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The discounts that have been applied to the cart line.
        */
        public ComponentizableCartLineQuery discountAllocations(CartDiscountAllocationQueryDefinition queryDef) {
            startField("discountAllocations");

            _queryBuilder.append('{');
            queryDef.define(new CartDiscountAllocationQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The estimated cost of the merchandise that the buyer will pay for at checkout. The estimated costs
        * are subject to change and changes will be reflected at checkout.
        *
        * @deprecated Use `cost` instead.
        */
        @Deprecated
        public ComponentizableCartLineQuery estimatedCost(CartLineEstimatedCostQueryDefinition queryDef) {
            startField("estimatedCost");

            _queryBuilder.append('{');
            queryDef.define(new CartLineEstimatedCostQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The components of the line item.
        */
        public ComponentizableCartLineQuery lineComponents(CartLineQueryDefinition queryDef) {
            startField("lineComponents");

            _queryBuilder.append('{');
            queryDef.define(new CartLineQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The merchandise that the buyer intends to purchase.
        */
        public ComponentizableCartLineQuery merchandise(MerchandiseQueryDefinition queryDef) {
            startField("merchandise");

            _queryBuilder.append('{');
            queryDef.define(new MerchandiseQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The quantity of the merchandise that the customer intends to purchase.
        */
        public ComponentizableCartLineQuery quantity() {
            startField("quantity");

            return this;
        }

        /**
        * The selling plan associated with the cart line and the effect that each selling plan has on variants
        * when they're purchased.
        */
        public ComponentizableCartLineQuery sellingPlanAllocation(SellingPlanAllocationQueryDefinition queryDef) {
            startField("sellingPlanAllocation");

            _queryBuilder.append('{');
            queryDef.define(new SellingPlanAllocationQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Represents information about the grouped merchandise in the cart.
    */
    public static class ComponentizableCartLine extends AbstractResponse<ComponentizableCartLine> implements BaseCartLine, Node {
        public ComponentizableCartLine() {
        }

        public ComponentizableCartLine(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "attribute": {
                        Attribute optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Attribute(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "attributes": {
                        List<Attribute> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new Attribute(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "cost": {
                        responseData.put(key, new CartLineCost(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "discountAllocations": {
                        List<CartDiscountAllocation> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(UnknownCartDiscountAllocation.create(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "estimatedCost": {
                        responseData.put(key, new CartLineEstimatedCost(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "lineComponents": {
                        List<CartLine> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CartLine(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "merchandise": {
                        responseData.put(key, UnknownMerchandise.create(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "quantity": {
                        responseData.put(key, jsonAsInteger(field.getValue(), key));

                        break;
                    }

                    case "sellingPlanAllocation": {
                        SellingPlanAllocation optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new SellingPlanAllocation(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public ComponentizableCartLine(ID id) {
            this();
            optimisticData.put("id", id);
        }

        public String getGraphQlTypeName() {
            return "ComponentizableCartLine";
        }

        /**
        * An attribute associated with the cart line.
        */

        public Attribute getAttribute() {
            return (Attribute) get("attribute");
        }

        public ComponentizableCartLine setAttribute(Attribute arg) {
            optimisticData.put(getKey("attribute"), arg);
            return this;
        }

        /**
        * The attributes associated with the cart line. Attributes are represented as key-value pairs.
        */

        public List<Attribute> getAttributes() {
            return (List<Attribute>) get("attributes");
        }

        public ComponentizableCartLine setAttributes(List<Attribute> arg) {
            optimisticData.put(getKey("attributes"), arg);
            return this;
        }

        /**
        * The cost of the merchandise that the buyer will pay for at checkout. The costs are subject to change
        * and changes will be reflected at checkout.
        */

        public CartLineCost getCost() {
            return (CartLineCost) get("cost");
        }

        public ComponentizableCartLine setCost(CartLineCost arg) {
            optimisticData.put(getKey("cost"), arg);
            return this;
        }

        /**
        * The discounts that have been applied to the cart line.
        */

        public List<CartDiscountAllocation> getDiscountAllocations() {
            return (List<CartDiscountAllocation>) get("discountAllocations");
        }

        public ComponentizableCartLine setDiscountAllocations(List<CartDiscountAllocation> arg) {
            optimisticData.put(getKey("discountAllocations"), arg);
            return this;
        }

        /**
        * The estimated cost of the merchandise that the buyer will pay for at checkout. The estimated costs
        * are subject to change and changes will be reflected at checkout.
        *
        * @deprecated Use `cost` instead.
        */

        public CartLineEstimatedCost getEstimatedCost() {
            return (CartLineEstimatedCost) get("estimatedCost");
        }

        public ComponentizableCartLine setEstimatedCost(CartLineEstimatedCost arg) {
            optimisticData.put(getKey("estimatedCost"), arg);
            return this;
        }

        /**
        * A globally-unique ID.
        */

        public ID getId() {
            return (ID) get("id");
        }

        /**
        * The components of the line item.
        */

        public List<CartLine> getLineComponents() {
            return (List<CartLine>) get("lineComponents");
        }

        public ComponentizableCartLine setLineComponents(List<CartLine> arg) {
            optimisticData.put(getKey("lineComponents"), arg);
            return this;
        }

        /**
        * The merchandise that the buyer intends to purchase.
        */

        public Merchandise getMerchandise() {
            return (Merchandise) get("merchandise");
        }

        public ComponentizableCartLine setMerchandise(Merchandise arg) {
            optimisticData.put(getKey("merchandise"), arg);
            return this;
        }

        /**
        * The quantity of the merchandise that the customer intends to purchase.
        */

        public Integer getQuantity() {
            return (Integer) get("quantity");
        }

        public ComponentizableCartLine setQuantity(Integer arg) {
            optimisticData.put(getKey("quantity"), arg);
            return this;
        }

        /**
        * The selling plan associated with the cart line and the effect that each selling plan has on variants
        * when they're purchased.
        */

        public SellingPlanAllocation getSellingPlanAllocation() {
            return (SellingPlanAllocation) get("sellingPlanAllocation");
        }

        public ComponentizableCartLine setSellingPlanAllocation(SellingPlanAllocation arg) {
            optimisticData.put(getKey("sellingPlanAllocation"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "attribute": return true;

                case "attributes": return true;

                case "cost": return true;

                case "discountAllocations": return false;

                case "estimatedCost": return true;

                case "id": return false;

                case "lineComponents": return true;

                case "merchandise": return false;

                case "quantity": return false;

                case "sellingPlanAllocation": return true;

                default: return false;
            }
        }
    }

    public interface CountryQueryDefinition {
        void define(CountryQuery _queryBuilder);
    }

    /**
    * A country.
    */
    public static class CountryQuery extends Query<CountryQuery> {
        CountryQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The languages available for the country.
        */
        public CountryQuery availableLanguages(LanguageQueryDefinition queryDef) {
            startField("availableLanguages");

            _queryBuilder.append('{');
            queryDef.define(new LanguageQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The currency of the country.
        */
        public CountryQuery currency(CurrencyQueryDefinition queryDef) {
            startField("currency");

            _queryBuilder.append('{');
            queryDef.define(new CurrencyQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The ISO code of the country.
        */
        public CountryQuery isoCode() {
            startField("isoCode");

            return this;
        }

        /**
        * The market that includes this country.
        */
        public CountryQuery market(MarketQueryDefinition queryDef) {
            startField("market");

            _queryBuilder.append('{');
            queryDef.define(new MarketQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The name of the country.
        */
        public CountryQuery name() {
            startField("name");

            return this;
        }

        /**
        * The unit system used in the country.
        */
        public CountryQuery unitSystem() {
            startField("unitSystem");

            return this;
        }
    }

    /**
    * A country.
    */
    public static class Country extends AbstractResponse<Country> {
        public Country() {
        }

        public Country(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "availableLanguages": {
                        List<Language> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new Language(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "currency": {
                        responseData.put(key, new Currency(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "isoCode": {
                        responseData.put(key, CountryCode.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "market": {
                        Market optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Market(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "name": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "unitSystem": {
                        responseData.put(key, UnitSystem.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "Country";
        }

        /**
        * The languages available for the country.
        */

        public List<Language> getAvailableLanguages() {
            return (List<Language>) get("availableLanguages");
        }

        public Country setAvailableLanguages(List<Language> arg) {
            optimisticData.put(getKey("availableLanguages"), arg);
            return this;
        }

        /**
        * The currency of the country.
        */

        public Currency getCurrency() {
            return (Currency) get("currency");
        }

        public Country setCurrency(Currency arg) {
            optimisticData.put(getKey("currency"), arg);
            return this;
        }

        /**
        * The ISO code of the country.
        */

        public CountryCode getIsoCode() {
            return (CountryCode) get("isoCode");
        }

        public Country setIsoCode(CountryCode arg) {
            optimisticData.put(getKey("isoCode"), arg);
            return this;
        }

        /**
        * The market that includes this country.
        */

        public Market getMarket() {
            return (Market) get("market");
        }

        public Country setMarket(Market arg) {
            optimisticData.put(getKey("market"), arg);
            return this;
        }

        /**
        * The name of the country.
        */

        public String getName() {
            return (String) get("name");
        }

        public Country setName(String arg) {
            optimisticData.put(getKey("name"), arg);
            return this;
        }

        /**
        * The unit system used in the country.
        */

        public UnitSystem getUnitSystem() {
            return (UnitSystem) get("unitSystem");
        }

        public Country setUnitSystem(UnitSystem arg) {
            optimisticData.put(getKey("unitSystem"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "availableLanguages": return true;

                case "currency": return true;

                case "isoCode": return false;

                case "market": return true;

                case "name": return false;

                case "unitSystem": return false;

                default: return false;
            }
        }
    }

    /**
    * The code designating a country/region, which generally follows ISO 3166-1 alpha-2 guidelines.
    * If a territory doesn't have a country code value in the `CountryCode` enum, then it might be
    * considered a subdivision
    * of another country. For example, the territories associated with Spain are represented by the
    * country code `ES`,
    * and the territories associated with the United States of America are represented by the country code
    * `US`.
    */
    public enum CountryCode {
        /**
        * Ascension Island.
        */
        AC,

        /**
        * Andorra.
        */
        AD,

        /**
        * United Arab Emirates.
        */
        AE,

        /**
        * Afghanistan.
        */
        AF,

        /**
        * Antigua & Barbuda.
        */
        AG,

        /**
        * Anguilla.
        */
        AI,

        /**
        * Albania.
        */
        AL,

        /**
        * Armenia.
        */
        AM,

        /**
        * Netherlands Antilles.
        */
        AN,

        /**
        * Angola.
        */
        AO,

        /**
        * Argentina.
        */
        AR,

        /**
        * Austria.
        */
        AT,

        /**
        * Australia.
        */
        AU,

        /**
        * Aruba.
        */
        AW,

        /**
        * Åland Islands.
        */
        AX,

        /**
        * Azerbaijan.
        */
        AZ,

        /**
        * Bosnia & Herzegovina.
        */
        BA,

        /**
        * Barbados.
        */
        BB,

        /**
        * Bangladesh.
        */
        BD,

        /**
        * Belgium.
        */
        BE,

        /**
        * Burkina Faso.
        */
        BF,

        /**
        * Bulgaria.
        */
        BG,

        /**
        * Bahrain.
        */
        BH,

        /**
        * Burundi.
        */
        BI,

        /**
        * Benin.
        */
        BJ,

        /**
        * St. Barthélemy.
        */
        BL,

        /**
        * Bermuda.
        */
        BM,

        /**
        * Brunei.
        */
        BN,

        /**
        * Bolivia.
        */
        BO,

        /**
        * Caribbean Netherlands.
        */
        BQ,

        /**
        * Brazil.
        */
        BR,

        /**
        * Bahamas.
        */
        BS,

        /**
        * Bhutan.
        */
        BT,

        /**
        * Bouvet Island.
        */
        BV,

        /**
        * Botswana.
        */
        BW,

        /**
        * Belarus.
        */
        BY,

        /**
        * Belize.
        */
        BZ,

        /**
        * Canada.
        */
        CA,

        /**
        * Cocos (Keeling) Islands.
        */
        CC,

        /**
        * Congo - Kinshasa.
        */
        CD,

        /**
        * Central African Republic.
        */
        CF,

        /**
        * Congo - Brazzaville.
        */
        CG,

        /**
        * Switzerland.
        */
        CH,

        /**
        * Côte d’Ivoire.
        */
        CI,

        /**
        * Cook Islands.
        */
        CK,

        /**
        * Chile.
        */
        CL,

        /**
        * Cameroon.
        */
        CM,

        /**
        * China.
        */
        CN,

        /**
        * Colombia.
        */
        CO,

        /**
        * Costa Rica.
        */
        CR,

        /**
        * Cuba.
        */
        CU,

        /**
        * Cape Verde.
        */
        CV,

        /**
        * Curaçao.
        */
        CW,

        /**
        * Christmas Island.
        */
        CX,

        /**
        * Cyprus.
        */
        CY,

        /**
        * Czechia.
        */
        CZ,

        /**
        * Germany.
        */
        DE,

        /**
        * Djibouti.
        */
        DJ,

        /**
        * Denmark.
        */
        DK,

        /**
        * Dominica.
        */
        DM,

        /**
        * Dominican Republic.
        */
        DO,

        /**
        * Algeria.
        */
        DZ,

        /**
        * Ecuador.
        */
        EC,

        /**
        * Estonia.
        */
        EE,

        /**
        * Egypt.
        */
        EG,

        /**
        * Western Sahara.
        */
        EH,

        /**
        * Eritrea.
        */
        ER,

        /**
        * Spain.
        */
        ES,

        /**
        * Ethiopia.
        */
        ET,

        /**
        * Finland.
        */
        FI,

        /**
        * Fiji.
        */
        FJ,

        /**
        * Falkland Islands.
        */
        FK,

        /**
        * Faroe Islands.
        */
        FO,

        /**
        * France.
        */
        FR,

        /**
        * Gabon.
        */
        GA,

        /**
        * United Kingdom.
        */
        GB,

        /**
        * Grenada.
        */
        GD,

        /**
        * Georgia.
        */
        GE,

        /**
        * French Guiana.
        */
        GF,

        /**
        * Guernsey.
        */
        GG,

        /**
        * Ghana.
        */
        GH,

        /**
        * Gibraltar.
        */
        GI,

        /**
        * Greenland.
        */
        GL,

        /**
        * Gambia.
        */
        GM,

        /**
        * Guinea.
        */
        GN,

        /**
        * Guadeloupe.
        */
        GP,

        /**
        * Equatorial Guinea.
        */
        GQ,

        /**
        * Greece.
        */
        GR,

        /**
        * South Georgia & South Sandwich Islands.
        */
        GS,

        /**
        * Guatemala.
        */
        GT,

        /**
        * Guinea-Bissau.
        */
        GW,

        /**
        * Guyana.
        */
        GY,

        /**
        * Hong Kong SAR.
        */
        HK,

        /**
        * Heard & McDonald Islands.
        */
        HM,

        /**
        * Honduras.
        */
        HN,

        /**
        * Croatia.
        */
        HR,

        /**
        * Haiti.
        */
        HT,

        /**
        * Hungary.
        */
        HU,

        /**
        * Indonesia.
        */
        ID,

        /**
        * Ireland.
        */
        IE,

        /**
        * Israel.
        */
        IL,

        /**
        * Isle of Man.
        */
        IM,

        /**
        * India.
        */
        IN,

        /**
        * British Indian Ocean Territory.
        */
        IO,

        /**
        * Iraq.
        */
        IQ,

        /**
        * Iran.
        */
        IR,

        /**
        * Iceland.
        */
        IS,

        /**
        * Italy.
        */
        IT,

        /**
        * Jersey.
        */
        JE,

        /**
        * Jamaica.
        */
        JM,

        /**
        * Jordan.
        */
        JO,

        /**
        * Japan.
        */
        JP,

        /**
        * Kenya.
        */
        KE,

        /**
        * Kyrgyzstan.
        */
        KG,

        /**
        * Cambodia.
        */
        KH,

        /**
        * Kiribati.
        */
        KI,

        /**
        * Comoros.
        */
        KM,

        /**
        * St. Kitts & Nevis.
        */
        KN,

        /**
        * North Korea.
        */
        KP,

        /**
        * South Korea.
        */
        KR,

        /**
        * Kuwait.
        */
        KW,

        /**
        * Cayman Islands.
        */
        KY,

        /**
        * Kazakhstan.
        */
        KZ,

        /**
        * Laos.
        */
        LA,

        /**
        * Lebanon.
        */
        LB,

        /**
        * St. Lucia.
        */
        LC,

        /**
        * Liechtenstein.
        */
        LI,

        /**
        * Sri Lanka.
        */
        LK,

        /**
        * Liberia.
        */
        LR,

        /**
        * Lesotho.
        */
        LS,

        /**
        * Lithuania.
        */
        LT,

        /**
        * Luxembourg.
        */
        LU,

        /**
        * Latvia.
        */
        LV,

        /**
        * Libya.
        */
        LY,

        /**
        * Morocco.
        */
        MA,

        /**
        * Monaco.
        */
        MC,

        /**
        * Moldova.
        */
        MD,

        /**
        * Montenegro.
        */
        ME,

        /**
        * St. Martin.
        */
        MF,

        /**
        * Madagascar.
        */
        MG,

        /**
        * North Macedonia.
        */
        MK,

        /**
        * Mali.
        */
        ML,

        /**
        * Myanmar (Burma).
        */
        MM,

        /**
        * Mongolia.
        */
        MN,

        /**
        * Macao SAR.
        */
        MO,

        /**
        * Martinique.
        */
        MQ,

        /**
        * Mauritania.
        */
        MR,

        /**
        * Montserrat.
        */
        MS,

        /**
        * Malta.
        */
        MT,

        /**
        * Mauritius.
        */
        MU,

        /**
        * Maldives.
        */
        MV,

        /**
        * Malawi.
        */
        MW,

        /**
        * Mexico.
        */
        MX,

        /**
        * Malaysia.
        */
        MY,

        /**
        * Mozambique.
        */
        MZ,

        /**
        * Namibia.
        */
        NA,

        /**
        * New Caledonia.
        */
        NC,

        /**
        * Niger.
        */
        NE,

        /**
        * Norfolk Island.
        */
        NF,

        /**
        * Nigeria.
        */
        NG,

        /**
        * Nicaragua.
        */
        NI,

        /**
        * Netherlands.
        */
        NL,

        /**
        * Norway.
        */
        NO,

        /**
        * Nepal.
        */
        NP,

        /**
        * Nauru.
        */
        NR,

        /**
        * Niue.
        */
        NU,

        /**
        * New Zealand.
        */
        NZ,

        /**
        * Oman.
        */
        OM,

        /**
        * Panama.
        */
        PA,

        /**
        * Peru.
        */
        PE,

        /**
        * French Polynesia.
        */
        PF,

        /**
        * Papua New Guinea.
        */
        PG,

        /**
        * Philippines.
        */
        PH,

        /**
        * Pakistan.
        */
        PK,

        /**
        * Poland.
        */
        PL,

        /**
        * St. Pierre & Miquelon.
        */
        PM,

        /**
        * Pitcairn Islands.
        */
        PN,

        /**
        * Palestinian Territories.
        */
        PS,

        /**
        * Portugal.
        */
        PT,

        /**
        * Paraguay.
        */
        PY,

        /**
        * Qatar.
        */
        QA,

        /**
        * Réunion.
        */
        RE,

        /**
        * Romania.
        */
        RO,

        /**
        * Serbia.
        */
        RS,

        /**
        * Russia.
        */
        RU,

        /**
        * Rwanda.
        */
        RW,

        /**
        * Saudi Arabia.
        */
        SA,

        /**
        * Solomon Islands.
        */
        SB,

        /**
        * Seychelles.
        */
        SC,

        /**
        * Sudan.
        */
        SD,

        /**
        * Sweden.
        */
        SE,

        /**
        * Singapore.
        */
        SG,

        /**
        * St. Helena.
        */
        SH,

        /**
        * Slovenia.
        */
        SI,

        /**
        * Svalbard & Jan Mayen.
        */
        SJ,

        /**
        * Slovakia.
        */
        SK,

        /**
        * Sierra Leone.
        */
        SL,

        /**
        * San Marino.
        */
        SM,

        /**
        * Senegal.
        */
        SN,

        /**
        * Somalia.
        */
        SO,

        /**
        * Suriname.
        */
        SR,

        /**
        * South Sudan.
        */
        SS,

        /**
        * São Tomé & Príncipe.
        */
        ST,

        /**
        * El Salvador.
        */
        SV,

        /**
        * Sint Maarten.
        */
        SX,

        /**
        * Syria.
        */
        SY,

        /**
        * Eswatini.
        */
        SZ,

        /**
        * Tristan da Cunha.
        */
        TA,

        /**
        * Turks & Caicos Islands.
        */
        TC,

        /**
        * Chad.
        */
        TD,

        /**
        * French Southern Territories.
        */
        TF,

        /**
        * Togo.
        */
        TG,

        /**
        * Thailand.
        */
        TH,

        /**
        * Tajikistan.
        */
        TJ,

        /**
        * Tokelau.
        */
        TK,

        /**
        * Timor-Leste.
        */
        TL,

        /**
        * Turkmenistan.
        */
        TM,

        /**
        * Tunisia.
        */
        TN,

        /**
        * Tonga.
        */
        TO,

        /**
        * Türkiye.
        */
        TR,

        /**
        * Trinidad & Tobago.
        */
        TT,

        /**
        * Tuvalu.
        */
        TV,

        /**
        * Taiwan.
        */
        TW,

        /**
        * Tanzania.
        */
        TZ,

        /**
        * Ukraine.
        */
        UA,

        /**
        * Uganda.
        */
        UG,

        /**
        * U.S. Outlying Islands.
        */
        UM,

        /**
        * United States.
        */
        US,

        /**
        * Uruguay.
        */
        UY,

        /**
        * Uzbekistan.
        */
        UZ,

        /**
        * Vatican City.
        */
        VA,

        /**
        * St. Vincent & Grenadines.
        */
        VC,

        /**
        * Venezuela.
        */
        VE,

        /**
        * British Virgin Islands.
        */
        VG,

        /**
        * Vietnam.
        */
        VN,

        /**
        * Vanuatu.
        */
        VU,

        /**
        * Wallis & Futuna.
        */
        WF,

        /**
        * Samoa.
        */
        WS,

        /**
        * Kosovo.
        */
        XK,

        /**
        * Yemen.
        */
        YE,

        /**
        * Mayotte.
        */
        YT,

        /**
        * South Africa.
        */
        ZA,

        /**
        * Zambia.
        */
        ZM,

        /**
        * Zimbabwe.
        */
        ZW,

        /**
        * Unknown Region.
        */
        ZZ,

        UNKNOWN_VALUE;

        public static CountryCode fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "AC": {
                    return AC;
                }

                case "AD": {
                    return AD;
                }

                case "AE": {
                    return AE;
                }

                case "AF": {
                    return AF;
                }

                case "AG": {
                    return AG;
                }

                case "AI": {
                    return AI;
                }

                case "AL": {
                    return AL;
                }

                case "AM": {
                    return AM;
                }

                case "AN": {
                    return AN;
                }

                case "AO": {
                    return AO;
                }

                case "AR": {
                    return AR;
                }

                case "AT": {
                    return AT;
                }

                case "AU": {
                    return AU;
                }

                case "AW": {
                    return AW;
                }

                case "AX": {
                    return AX;
                }

                case "AZ": {
                    return AZ;
                }

                case "BA": {
                    return BA;
                }

                case "BB": {
                    return BB;
                }

                case "BD": {
                    return BD;
                }

                case "BE": {
                    return BE;
                }

                case "BF": {
                    return BF;
                }

                case "BG": {
                    return BG;
                }

                case "BH": {
                    return BH;
                }

                case "BI": {
                    return BI;
                }

                case "BJ": {
                    return BJ;
                }

                case "BL": {
                    return BL;
                }

                case "BM": {
                    return BM;
                }

                case "BN": {
                    return BN;
                }

                case "BO": {
                    return BO;
                }

                case "BQ": {
                    return BQ;
                }

                case "BR": {
                    return BR;
                }

                case "BS": {
                    return BS;
                }

                case "BT": {
                    return BT;
                }

                case "BV": {
                    return BV;
                }

                case "BW": {
                    return BW;
                }

                case "BY": {
                    return BY;
                }

                case "BZ": {
                    return BZ;
                }

                case "CA": {
                    return CA;
                }

                case "CC": {
                    return CC;
                }

                case "CD": {
                    return CD;
                }

                case "CF": {
                    return CF;
                }

                case "CG": {
                    return CG;
                }

                case "CH": {
                    return CH;
                }

                case "CI": {
                    return CI;
                }

                case "CK": {
                    return CK;
                }

                case "CL": {
                    return CL;
                }

                case "CM": {
                    return CM;
                }

                case "CN": {
                    return CN;
                }

                case "CO": {
                    return CO;
                }

                case "CR": {
                    return CR;
                }

                case "CU": {
                    return CU;
                }

                case "CV": {
                    return CV;
                }

                case "CW": {
                    return CW;
                }

                case "CX": {
                    return CX;
                }

                case "CY": {
                    return CY;
                }

                case "CZ": {
                    return CZ;
                }

                case "DE": {
                    return DE;
                }

                case "DJ": {
                    return DJ;
                }

                case "DK": {
                    return DK;
                }

                case "DM": {
                    return DM;
                }

                case "DO": {
                    return DO;
                }

                case "DZ": {
                    return DZ;
                }

                case "EC": {
                    return EC;
                }

                case "EE": {
                    return EE;
                }

                case "EG": {
                    return EG;
                }

                case "EH": {
                    return EH;
                }

                case "ER": {
                    return ER;
                }

                case "ES": {
                    return ES;
                }

                case "ET": {
                    return ET;
                }

                case "FI": {
                    return FI;
                }

                case "FJ": {
                    return FJ;
                }

                case "FK": {
                    return FK;
                }

                case "FO": {
                    return FO;
                }

                case "FR": {
                    return FR;
                }

                case "GA": {
                    return GA;
                }

                case "GB": {
                    return GB;
                }

                case "GD": {
                    return GD;
                }

                case "GE": {
                    return GE;
                }

                case "GF": {
                    return GF;
                }

                case "GG": {
                    return GG;
                }

                case "GH": {
                    return GH;
                }

                case "GI": {
                    return GI;
                }

                case "GL": {
                    return GL;
                }

                case "GM": {
                    return GM;
                }

                case "GN": {
                    return GN;
                }

                case "GP": {
                    return GP;
                }

                case "GQ": {
                    return GQ;
                }

                case "GR": {
                    return GR;
                }

                case "GS": {
                    return GS;
                }

                case "GT": {
                    return GT;
                }

                case "GW": {
                    return GW;
                }

                case "GY": {
                    return GY;
                }

                case "HK": {
                    return HK;
                }

                case "HM": {
                    return HM;
                }

                case "HN": {
                    return HN;
                }

                case "HR": {
                    return HR;
                }

                case "HT": {
                    return HT;
                }

                case "HU": {
                    return HU;
                }

                case "ID": {
                    return ID;
                }

                case "IE": {
                    return IE;
                }

                case "IL": {
                    return IL;
                }

                case "IM": {
                    return IM;
                }

                case "IN": {
                    return IN;
                }

                case "IO": {
                    return IO;
                }

                case "IQ": {
                    return IQ;
                }

                case "IR": {
                    return IR;
                }

                case "IS": {
                    return IS;
                }

                case "IT": {
                    return IT;
                }

                case "JE": {
                    return JE;
                }

                case "JM": {
                    return JM;
                }

                case "JO": {
                    return JO;
                }

                case "JP": {
                    return JP;
                }

                case "KE": {
                    return KE;
                }

                case "KG": {
                    return KG;
                }

                case "KH": {
                    return KH;
                }

                case "KI": {
                    return KI;
                }

                case "KM": {
                    return KM;
                }

                case "KN": {
                    return KN;
                }

                case "KP": {
                    return KP;
                }

                case "KR": {
                    return KR;
                }

                case "KW": {
                    return KW;
                }

                case "KY": {
                    return KY;
                }

                case "KZ": {
                    return KZ;
                }

                case "LA": {
                    return LA;
                }

                case "LB": {
                    return LB;
                }

                case "LC": {
                    return LC;
                }

                case "LI": {
                    return LI;
                }

                case "LK": {
                    return LK;
                }

                case "LR": {
                    return LR;
                }

                case "LS": {
                    return LS;
                }

                case "LT": {
                    return LT;
                }

                case "LU": {
                    return LU;
                }

                case "LV": {
                    return LV;
                }

                case "LY": {
                    return LY;
                }

                case "MA": {
                    return MA;
                }

                case "MC": {
                    return MC;
                }

                case "MD": {
                    return MD;
                }

                case "ME": {
                    return ME;
                }

                case "MF": {
                    return MF;
                }

                case "MG": {
                    return MG;
                }

                case "MK": {
                    return MK;
                }

                case "ML": {
                    return ML;
                }

                case "MM": {
                    return MM;
                }

                case "MN": {
                    return MN;
                }

                case "MO": {
                    return MO;
                }

                case "MQ": {
                    return MQ;
                }

                case "MR": {
                    return MR;
                }

                case "MS": {
                    return MS;
                }

                case "MT": {
                    return MT;
                }

                case "MU": {
                    return MU;
                }

                case "MV": {
                    return MV;
                }

                case "MW": {
                    return MW;
                }

                case "MX": {
                    return MX;
                }

                case "MY": {
                    return MY;
                }

                case "MZ": {
                    return MZ;
                }

                case "NA": {
                    return NA;
                }

                case "NC": {
                    return NC;
                }

                case "NE": {
                    return NE;
                }

                case "NF": {
                    return NF;
                }

                case "NG": {
                    return NG;
                }

                case "NI": {
                    return NI;
                }

                case "NL": {
                    return NL;
                }

                case "NO": {
                    return NO;
                }

                case "NP": {
                    return NP;
                }

                case "NR": {
                    return NR;
                }

                case "NU": {
                    return NU;
                }

                case "NZ": {
                    return NZ;
                }

                case "OM": {
                    return OM;
                }

                case "PA": {
                    return PA;
                }

                case "PE": {
                    return PE;
                }

                case "PF": {
                    return PF;
                }

                case "PG": {
                    return PG;
                }

                case "PH": {
                    return PH;
                }

                case "PK": {
                    return PK;
                }

                case "PL": {
                    return PL;
                }

                case "PM": {
                    return PM;
                }

                case "PN": {
                    return PN;
                }

                case "PS": {
                    return PS;
                }

                case "PT": {
                    return PT;
                }

                case "PY": {
                    return PY;
                }

                case "QA": {
                    return QA;
                }

                case "RE": {
                    return RE;
                }

                case "RO": {
                    return RO;
                }

                case "RS": {
                    return RS;
                }

                case "RU": {
                    return RU;
                }

                case "RW": {
                    return RW;
                }

                case "SA": {
                    return SA;
                }

                case "SB": {
                    return SB;
                }

                case "SC": {
                    return SC;
                }

                case "SD": {
                    return SD;
                }

                case "SE": {
                    return SE;
                }

                case "SG": {
                    return SG;
                }

                case "SH": {
                    return SH;
                }

                case "SI": {
                    return SI;
                }

                case "SJ": {
                    return SJ;
                }

                case "SK": {
                    return SK;
                }

                case "SL": {
                    return SL;
                }

                case "SM": {
                    return SM;
                }

                case "SN": {
                    return SN;
                }

                case "SO": {
                    return SO;
                }

                case "SR": {
                    return SR;
                }

                case "SS": {
                    return SS;
                }

                case "ST": {
                    return ST;
                }

                case "SV": {
                    return SV;
                }

                case "SX": {
                    return SX;
                }

                case "SY": {
                    return SY;
                }

                case "SZ": {
                    return SZ;
                }

                case "TA": {
                    return TA;
                }

                case "TC": {
                    return TC;
                }

                case "TD": {
                    return TD;
                }

                case "TF": {
                    return TF;
                }

                case "TG": {
                    return TG;
                }

                case "TH": {
                    return TH;
                }

                case "TJ": {
                    return TJ;
                }

                case "TK": {
                    return TK;
                }

                case "TL": {
                    return TL;
                }

                case "TM": {
                    return TM;
                }

                case "TN": {
                    return TN;
                }

                case "TO": {
                    return TO;
                }

                case "TR": {
                    return TR;
                }

                case "TT": {
                    return TT;
                }

                case "TV": {
                    return TV;
                }

                case "TW": {
                    return TW;
                }

                case "TZ": {
                    return TZ;
                }

                case "UA": {
                    return UA;
                }

                case "UG": {
                    return UG;
                }

                case "UM": {
                    return UM;
                }

                case "US": {
                    return US;
                }

                case "UY": {
                    return UY;
                }

                case "UZ": {
                    return UZ;
                }

                case "VA": {
                    return VA;
                }

                case "VC": {
                    return VC;
                }

                case "VE": {
                    return VE;
                }

                case "VG": {
                    return VG;
                }

                case "VN": {
                    return VN;
                }

                case "VU": {
                    return VU;
                }

                case "WF": {
                    return WF;
                }

                case "WS": {
                    return WS;
                }

                case "XK": {
                    return XK;
                }

                case "YE": {
                    return YE;
                }

                case "YT": {
                    return YT;
                }

                case "ZA": {
                    return ZA;
                }

                case "ZM": {
                    return ZM;
                }

                case "ZW": {
                    return ZW;
                }

                case "ZZ": {
                    return ZZ;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case AC: {
                    return "AC";
                }

                case AD: {
                    return "AD";
                }

                case AE: {
                    return "AE";
                }

                case AF: {
                    return "AF";
                }

                case AG: {
                    return "AG";
                }

                case AI: {
                    return "AI";
                }

                case AL: {
                    return "AL";
                }

                case AM: {
                    return "AM";
                }

                case AN: {
                    return "AN";
                }

                case AO: {
                    return "AO";
                }

                case AR: {
                    return "AR";
                }

                case AT: {
                    return "AT";
                }

                case AU: {
                    return "AU";
                }

                case AW: {
                    return "AW";
                }

                case AX: {
                    return "AX";
                }

                case AZ: {
                    return "AZ";
                }

                case BA: {
                    return "BA";
                }

                case BB: {
                    return "BB";
                }

                case BD: {
                    return "BD";
                }

                case BE: {
                    return "BE";
                }

                case BF: {
                    return "BF";
                }

                case BG: {
                    return "BG";
                }

                case BH: {
                    return "BH";
                }

                case BI: {
                    return "BI";
                }

                case BJ: {
                    return "BJ";
                }

                case BL: {
                    return "BL";
                }

                case BM: {
                    return "BM";
                }

                case BN: {
                    return "BN";
                }

                case BO: {
                    return "BO";
                }

                case BQ: {
                    return "BQ";
                }

                case BR: {
                    return "BR";
                }

                case BS: {
                    return "BS";
                }

                case BT: {
                    return "BT";
                }

                case BV: {
                    return "BV";
                }

                case BW: {
                    return "BW";
                }

                case BY: {
                    return "BY";
                }

                case BZ: {
                    return "BZ";
                }

                case CA: {
                    return "CA";
                }

                case CC: {
                    return "CC";
                }

                case CD: {
                    return "CD";
                }

                case CF: {
                    return "CF";
                }

                case CG: {
                    return "CG";
                }

                case CH: {
                    return "CH";
                }

                case CI: {
                    return "CI";
                }

                case CK: {
                    return "CK";
                }

                case CL: {
                    return "CL";
                }

                case CM: {
                    return "CM";
                }

                case CN: {
                    return "CN";
                }

                case CO: {
                    return "CO";
                }

                case CR: {
                    return "CR";
                }

                case CU: {
                    return "CU";
                }

                case CV: {
                    return "CV";
                }

                case CW: {
                    return "CW";
                }

                case CX: {
                    return "CX";
                }

                case CY: {
                    return "CY";
                }

                case CZ: {
                    return "CZ";
                }

                case DE: {
                    return "DE";
                }

                case DJ: {
                    return "DJ";
                }

                case DK: {
                    return "DK";
                }

                case DM: {
                    return "DM";
                }

                case DO: {
                    return "DO";
                }

                case DZ: {
                    return "DZ";
                }

                case EC: {
                    return "EC";
                }

                case EE: {
                    return "EE";
                }

                case EG: {
                    return "EG";
                }

                case EH: {
                    return "EH";
                }

                case ER: {
                    return "ER";
                }

                case ES: {
                    return "ES";
                }

                case ET: {
                    return "ET";
                }

                case FI: {
                    return "FI";
                }

                case FJ: {
                    return "FJ";
                }

                case FK: {
                    return "FK";
                }

                case FO: {
                    return "FO";
                }

                case FR: {
                    return "FR";
                }

                case GA: {
                    return "GA";
                }

                case GB: {
                    return "GB";
                }

                case GD: {
                    return "GD";
                }

                case GE: {
                    return "GE";
                }

                case GF: {
                    return "GF";
                }

                case GG: {
                    return "GG";
                }

                case GH: {
                    return "GH";
                }

                case GI: {
                    return "GI";
                }

                case GL: {
                    return "GL";
                }

                case GM: {
                    return "GM";
                }

                case GN: {
                    return "GN";
                }

                case GP: {
                    return "GP";
                }

                case GQ: {
                    return "GQ";
                }

                case GR: {
                    return "GR";
                }

                case GS: {
                    return "GS";
                }

                case GT: {
                    return "GT";
                }

                case GW: {
                    return "GW";
                }

                case GY: {
                    return "GY";
                }

                case HK: {
                    return "HK";
                }

                case HM: {
                    return "HM";
                }

                case HN: {
                    return "HN";
                }

                case HR: {
                    return "HR";
                }

                case HT: {
                    return "HT";
                }

                case HU: {
                    return "HU";
                }

                case ID: {
                    return "ID";
                }

                case IE: {
                    return "IE";
                }

                case IL: {
                    return "IL";
                }

                case IM: {
                    return "IM";
                }

                case IN: {
                    return "IN";
                }

                case IO: {
                    return "IO";
                }

                case IQ: {
                    return "IQ";
                }

                case IR: {
                    return "IR";
                }

                case IS: {
                    return "IS";
                }

                case IT: {
                    return "IT";
                }

                case JE: {
                    return "JE";
                }

                case JM: {
                    return "JM";
                }

                case JO: {
                    return "JO";
                }

                case JP: {
                    return "JP";
                }

                case KE: {
                    return "KE";
                }

                case KG: {
                    return "KG";
                }

                case KH: {
                    return "KH";
                }

                case KI: {
                    return "KI";
                }

                case KM: {
                    return "KM";
                }

                case KN: {
                    return "KN";
                }

                case KP: {
                    return "KP";
                }

                case KR: {
                    return "KR";
                }

                case KW: {
                    return "KW";
                }

                case KY: {
                    return "KY";
                }

                case KZ: {
                    return "KZ";
                }

                case LA: {
                    return "LA";
                }

                case LB: {
                    return "LB";
                }

                case LC: {
                    return "LC";
                }

                case LI: {
                    return "LI";
                }

                case LK: {
                    return "LK";
                }

                case LR: {
                    return "LR";
                }

                case LS: {
                    return "LS";
                }

                case LT: {
                    return "LT";
                }

                case LU: {
                    return "LU";
                }

                case LV: {
                    return "LV";
                }

                case LY: {
                    return "LY";
                }

                case MA: {
                    return "MA";
                }

                case MC: {
                    return "MC";
                }

                case MD: {
                    return "MD";
                }

                case ME: {
                    return "ME";
                }

                case MF: {
                    return "MF";
                }

                case MG: {
                    return "MG";
                }

                case MK: {
                    return "MK";
                }

                case ML: {
                    return "ML";
                }

                case MM: {
                    return "MM";
                }

                case MN: {
                    return "MN";
                }

                case MO: {
                    return "MO";
                }

                case MQ: {
                    return "MQ";
                }

                case MR: {
                    return "MR";
                }

                case MS: {
                    return "MS";
                }

                case MT: {
                    return "MT";
                }

                case MU: {
                    return "MU";
                }

                case MV: {
                    return "MV";
                }

                case MW: {
                    return "MW";
                }

                case MX: {
                    return "MX";
                }

                case MY: {
                    return "MY";
                }

                case MZ: {
                    return "MZ";
                }

                case NA: {
                    return "NA";
                }

                case NC: {
                    return "NC";
                }

                case NE: {
                    return "NE";
                }

                case NF: {
                    return "NF";
                }

                case NG: {
                    return "NG";
                }

                case NI: {
                    return "NI";
                }

                case NL: {
                    return "NL";
                }

                case NO: {
                    return "NO";
                }

                case NP: {
                    return "NP";
                }

                case NR: {
                    return "NR";
                }

                case NU: {
                    return "NU";
                }

                case NZ: {
                    return "NZ";
                }

                case OM: {
                    return "OM";
                }

                case PA: {
                    return "PA";
                }

                case PE: {
                    return "PE";
                }

                case PF: {
                    return "PF";
                }

                case PG: {
                    return "PG";
                }

                case PH: {
                    return "PH";
                }

                case PK: {
                    return "PK";
                }

                case PL: {
                    return "PL";
                }

                case PM: {
                    return "PM";
                }

                case PN: {
                    return "PN";
                }

                case PS: {
                    return "PS";
                }

                case PT: {
                    return "PT";
                }

                case PY: {
                    return "PY";
                }

                case QA: {
                    return "QA";
                }

                case RE: {
                    return "RE";
                }

                case RO: {
                    return "RO";
                }

                case RS: {
                    return "RS";
                }

                case RU: {
                    return "RU";
                }

                case RW: {
                    return "RW";
                }

                case SA: {
                    return "SA";
                }

                case SB: {
                    return "SB";
                }

                case SC: {
                    return "SC";
                }

                case SD: {
                    return "SD";
                }

                case SE: {
                    return "SE";
                }

                case SG: {
                    return "SG";
                }

                case SH: {
                    return "SH";
                }

                case SI: {
                    return "SI";
                }

                case SJ: {
                    return "SJ";
                }

                case SK: {
                    return "SK";
                }

                case SL: {
                    return "SL";
                }

                case SM: {
                    return "SM";
                }

                case SN: {
                    return "SN";
                }

                case SO: {
                    return "SO";
                }

                case SR: {
                    return "SR";
                }

                case SS: {
                    return "SS";
                }

                case ST: {
                    return "ST";
                }

                case SV: {
                    return "SV";
                }

                case SX: {
                    return "SX";
                }

                case SY: {
                    return "SY";
                }

                case SZ: {
                    return "SZ";
                }

                case TA: {
                    return "TA";
                }

                case TC: {
                    return "TC";
                }

                case TD: {
                    return "TD";
                }

                case TF: {
                    return "TF";
                }

                case TG: {
                    return "TG";
                }

                case TH: {
                    return "TH";
                }

                case TJ: {
                    return "TJ";
                }

                case TK: {
                    return "TK";
                }

                case TL: {
                    return "TL";
                }

                case TM: {
                    return "TM";
                }

                case TN: {
                    return "TN";
                }

                case TO: {
                    return "TO";
                }

                case TR: {
                    return "TR";
                }

                case TT: {
                    return "TT";
                }

                case TV: {
                    return "TV";
                }

                case TW: {
                    return "TW";
                }

                case TZ: {
                    return "TZ";
                }

                case UA: {
                    return "UA";
                }

                case UG: {
                    return "UG";
                }

                case UM: {
                    return "UM";
                }

                case US: {
                    return "US";
                }

                case UY: {
                    return "UY";
                }

                case UZ: {
                    return "UZ";
                }

                case VA: {
                    return "VA";
                }

                case VC: {
                    return "VC";
                }

                case VE: {
                    return "VE";
                }

                case VG: {
                    return "VG";
                }

                case VN: {
                    return "VN";
                }

                case VU: {
                    return "VU";
                }

                case WF: {
                    return "WF";
                }

                case WS: {
                    return "WS";
                }

                case XK: {
                    return "XK";
                }

                case YE: {
                    return "YE";
                }

                case YT: {
                    return "YT";
                }

                case ZA: {
                    return "ZA";
                }

                case ZM: {
                    return "ZM";
                }

                case ZW: {
                    return "ZW";
                }

                case ZZ: {
                    return "ZZ";
                }

                default: {
                    return "";
                }
            }
        }
    }

    /**
    * The part of the image that should remain after cropping.
    */
    public enum CropRegion {
        /**
        * Keep the bottom of the image.
        */
        BOTTOM,

        /**
        * Keep the center of the image.
        */
        CENTER,

        /**
        * Keep the left of the image.
        */
        LEFT,

        /**
        * Keep the right of the image.
        */
        RIGHT,

        /**
        * Keep the top of the image.
        */
        TOP,

        UNKNOWN_VALUE;

        public static CropRegion fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "BOTTOM": {
                    return BOTTOM;
                }

                case "CENTER": {
                    return CENTER;
                }

                case "LEFT": {
                    return LEFT;
                }

                case "RIGHT": {
                    return RIGHT;
                }

                case "TOP": {
                    return TOP;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case BOTTOM: {
                    return "BOTTOM";
                }

                case CENTER: {
                    return "CENTER";
                }

                case LEFT: {
                    return "LEFT";
                }

                case RIGHT: {
                    return "RIGHT";
                }

                case TOP: {
                    return "TOP";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface CurrencyQueryDefinition {
        void define(CurrencyQuery _queryBuilder);
    }

    /**
    * A currency.
    */
    public static class CurrencyQuery extends Query<CurrencyQuery> {
        CurrencyQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The ISO code of the currency.
        */
        public CurrencyQuery isoCode() {
            startField("isoCode");

            return this;
        }

        /**
        * The name of the currency.
        */
        public CurrencyQuery name() {
            startField("name");

            return this;
        }

        /**
        * The symbol of the currency.
        */
        public CurrencyQuery symbol() {
            startField("symbol");

            return this;
        }
    }

    /**
    * A currency.
    */
    public static class Currency extends AbstractResponse<Currency> {
        public Currency() {
        }

        public Currency(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "isoCode": {
                        responseData.put(key, CurrencyCode.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "name": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "symbol": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "Currency";
        }

        /**
        * The ISO code of the currency.
        */

        public CurrencyCode getIsoCode() {
            return (CurrencyCode) get("isoCode");
        }

        public Currency setIsoCode(CurrencyCode arg) {
            optimisticData.put(getKey("isoCode"), arg);
            return this;
        }

        /**
        * The name of the currency.
        */

        public String getName() {
            return (String) get("name");
        }

        public Currency setName(String arg) {
            optimisticData.put(getKey("name"), arg);
            return this;
        }

        /**
        * The symbol of the currency.
        */

        public String getSymbol() {
            return (String) get("symbol");
        }

        public Currency setSymbol(String arg) {
            optimisticData.put(getKey("symbol"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "isoCode": return false;

                case "name": return false;

                case "symbol": return false;

                default: return false;
            }
        }
    }

    /**
    * The three-letter currency codes that represent the world currencies used in
    * stores. These include standard ISO 4217 codes, legacy codes,
    * and non-standard codes.
    */
    public enum CurrencyCode {
        /**
        * United Arab Emirates Dirham (AED).
        */
        AED,

        /**
        * Afghan Afghani (AFN).
        */
        AFN,

        /**
        * Albanian Lek (ALL).
        */
        ALL,

        /**
        * Armenian Dram (AMD).
        */
        AMD,

        /**
        * Netherlands Antillean Guilder.
        */
        ANG,

        /**
        * Angolan Kwanza (AOA).
        */
        AOA,

        /**
        * Argentine Pesos (ARS).
        */
        ARS,

        /**
        * Australian Dollars (AUD).
        */
        AUD,

        /**
        * Aruban Florin (AWG).
        */
        AWG,

        /**
        * Azerbaijani Manat (AZN).
        */
        AZN,

        /**
        * Bosnia and Herzegovina Convertible Mark (BAM).
        */
        BAM,

        /**
        * Barbadian Dollar (BBD).
        */
        BBD,

        /**
        * Bangladesh Taka (BDT).
        */
        BDT,

        /**
        * Bulgarian Lev (BGN).
        */
        BGN,

        /**
        * Bahraini Dinar (BHD).
        */
        BHD,

        /**
        * Burundian Franc (BIF).
        */
        BIF,

        /**
        * Bermudian Dollar (BMD).
        */
        BMD,

        /**
        * Brunei Dollar (BND).
        */
        BND,

        /**
        * Bolivian Boliviano (BOB).
        */
        BOB,

        /**
        * Brazilian Real (BRL).
        */
        BRL,

        /**
        * Bahamian Dollar (BSD).
        */
        BSD,

        /**
        * Bhutanese Ngultrum (BTN).
        */
        BTN,

        /**
        * Botswana Pula (BWP).
        */
        BWP,

        /**
        * Belarusian Ruble (BYN).
        */
        BYN,

        /**
        * Belarusian Ruble (BYR).
        *
        * @deprecated `BYR` is deprecated. Use `BYN` available from version `2021-01` onwards instead.
        */
        @Deprecated
        BYR,

        /**
        * Belize Dollar (BZD).
        */
        BZD,

        /**
        * Canadian Dollars (CAD).
        */
        CAD,

        /**
        * Congolese franc (CDF).
        */
        CDF,

        /**
        * Swiss Francs (CHF).
        */
        CHF,

        /**
        * Chilean Peso (CLP).
        */
        CLP,

        /**
        * Chinese Yuan Renminbi (CNY).
        */
        CNY,

        /**
        * Colombian Peso (COP).
        */
        COP,

        /**
        * Costa Rican Colones (CRC).
        */
        CRC,

        /**
        * Cape Verdean escudo (CVE).
        */
        CVE,

        /**
        * Czech Koruny (CZK).
        */
        CZK,

        /**
        * Djiboutian Franc (DJF).
        */
        DJF,

        /**
        * Danish Kroner (DKK).
        */
        DKK,

        /**
        * Dominican Peso (DOP).
        */
        DOP,

        /**
        * Algerian Dinar (DZD).
        */
        DZD,

        /**
        * Egyptian Pound (EGP).
        */
        EGP,

        /**
        * Eritrean Nakfa (ERN).
        */
        ERN,

        /**
        * Ethiopian Birr (ETB).
        */
        ETB,

        /**
        * Euro (EUR).
        */
        EUR,

        /**
        * Fijian Dollars (FJD).
        */
        FJD,

        /**
        * Falkland Islands Pounds (FKP).
        */
        FKP,

        /**
        * United Kingdom Pounds (GBP).
        */
        GBP,

        /**
        * Georgian Lari (GEL).
        */
        GEL,

        /**
        * Ghanaian Cedi (GHS).
        */
        GHS,

        /**
        * Gibraltar Pounds (GIP).
        */
        GIP,

        /**
        * Gambian Dalasi (GMD).
        */
        GMD,

        /**
        * Guinean Franc (GNF).
        */
        GNF,

        /**
        * Guatemalan Quetzal (GTQ).
        */
        GTQ,

        /**
        * Guyanese Dollar (GYD).
        */
        GYD,

        /**
        * Hong Kong Dollars (HKD).
        */
        HKD,

        /**
        * Honduran Lempira (HNL).
        */
        HNL,

        /**
        * Croatian Kuna (HRK).
        */
        HRK,

        /**
        * Haitian Gourde (HTG).
        */
        HTG,

        /**
        * Hungarian Forint (HUF).
        */
        HUF,

        /**
        * Indonesian Rupiah (IDR).
        */
        IDR,

        /**
        * Israeli New Shekel (NIS).
        */
        ILS,

        /**
        * Indian Rupees (INR).
        */
        INR,

        /**
        * Iraqi Dinar (IQD).
        */
        IQD,

        /**
        * Iranian Rial (IRR).
        */
        IRR,

        /**
        * Icelandic Kronur (ISK).
        */
        ISK,

        /**
        * Jersey Pound.
        */
        JEP,

        /**
        * Jamaican Dollars (JMD).
        */
        JMD,

        /**
        * Jordanian Dinar (JOD).
        */
        JOD,

        /**
        * Japanese Yen (JPY).
        */
        JPY,

        /**
        * Kenyan Shilling (KES).
        */
        KES,

        /**
        * Kyrgyzstani Som (KGS).
        */
        KGS,

        /**
        * Cambodian Riel.
        */
        KHR,

        /**
        * Kiribati Dollar (KID).
        */
        KID,

        /**
        * Comorian Franc (KMF).
        */
        KMF,

        /**
        * South Korean Won (KRW).
        */
        KRW,

        /**
        * Kuwaiti Dinar (KWD).
        */
        KWD,

        /**
        * Cayman Dollars (KYD).
        */
        KYD,

        /**
        * Kazakhstani Tenge (KZT).
        */
        KZT,

        /**
        * Laotian Kip (LAK).
        */
        LAK,

        /**
        * Lebanese Pounds (LBP).
        */
        LBP,

        /**
        * Sri Lankan Rupees (LKR).
        */
        LKR,

        /**
        * Liberian Dollar (LRD).
        */
        LRD,

        /**
        * Lesotho Loti (LSL).
        */
        LSL,

        /**
        * Lithuanian Litai (LTL).
        */
        LTL,

        /**
        * Latvian Lati (LVL).
        */
        LVL,

        /**
        * Libyan Dinar (LYD).
        */
        LYD,

        /**
        * Moroccan Dirham.
        */
        MAD,

        /**
        * Moldovan Leu (MDL).
        */
        MDL,

        /**
        * Malagasy Ariary (MGA).
        */
        MGA,

        /**
        * Macedonia Denar (MKD).
        */
        MKD,

        /**
        * Burmese Kyat (MMK).
        */
        MMK,

        /**
        * Mongolian Tugrik.
        */
        MNT,

        /**
        * Macanese Pataca (MOP).
        */
        MOP,

        /**
        * Mauritanian Ouguiya (MRU).
        */
        MRU,

        /**
        * Mauritian Rupee (MUR).
        */
        MUR,

        /**
        * Maldivian Rufiyaa (MVR).
        */
        MVR,

        /**
        * Malawian Kwacha (MWK).
        */
        MWK,

        /**
        * Mexican Pesos (MXN).
        */
        MXN,

        /**
        * Malaysian Ringgits (MYR).
        */
        MYR,

        /**
        * Mozambican Metical.
        */
        MZN,

        /**
        * Namibian Dollar.
        */
        NAD,

        /**
        * Nigerian Naira (NGN).
        */
        NGN,

        /**
        * Nicaraguan Córdoba (NIO).
        */
        NIO,

        /**
        * Norwegian Kroner (NOK).
        */
        NOK,

        /**
        * Nepalese Rupee (NPR).
        */
        NPR,

        /**
        * New Zealand Dollars (NZD).
        */
        NZD,

        /**
        * Omani Rial (OMR).
        */
        OMR,

        /**
        * Panamian Balboa (PAB).
        */
        PAB,

        /**
        * Peruvian Nuevo Sol (PEN).
        */
        PEN,

        /**
        * Papua New Guinean Kina (PGK).
        */
        PGK,

        /**
        * Philippine Peso (PHP).
        */
        PHP,

        /**
        * Pakistani Rupee (PKR).
        */
        PKR,

        /**
        * Polish Zlotych (PLN).
        */
        PLN,

        /**
        * Paraguayan Guarani (PYG).
        */
        PYG,

        /**
        * Qatari Rial (QAR).
        */
        QAR,

        /**
        * Romanian Lei (RON).
        */
        RON,

        /**
        * Serbian dinar (RSD).
        */
        RSD,

        /**
        * Russian Rubles (RUB).
        */
        RUB,

        /**
        * Rwandan Franc (RWF).
        */
        RWF,

        /**
        * Saudi Riyal (SAR).
        */
        SAR,

        /**
        * Solomon Islands Dollar (SBD).
        */
        SBD,

        /**
        * Seychellois Rupee (SCR).
        */
        SCR,

        /**
        * Sudanese Pound (SDG).
        */
        SDG,

        /**
        * Swedish Kronor (SEK).
        */
        SEK,

        /**
        * Singapore Dollars (SGD).
        */
        SGD,

        /**
        * Saint Helena Pounds (SHP).
        */
        SHP,

        /**
        * Sierra Leonean Leone (SLL).
        */
        SLL,

        /**
        * Somali Shilling (SOS).
        */
        SOS,

        /**
        * Surinamese Dollar (SRD).
        */
        SRD,

        /**
        * South Sudanese Pound (SSP).
        */
        SSP,

        /**
        * Sao Tome And Principe Dobra (STD).
        *
        * @deprecated `STD` is deprecated. Use `STN` available from version `2022-07` onwards instead.
        */
        @Deprecated
        STD,

        /**
        * Sao Tome And Principe Dobra (STN).
        */
        STN,

        /**
        * Syrian Pound (SYP).
        */
        SYP,

        /**
        * Swazi Lilangeni (SZL).
        */
        SZL,

        /**
        * Thai baht (THB).
        */
        THB,

        /**
        * Tajikistani Somoni (TJS).
        */
        TJS,

        /**
        * Turkmenistani Manat (TMT).
        */
        TMT,

        /**
        * Tunisian Dinar (TND).
        */
        TND,

        /**
        * Tongan Pa'anga (TOP).
        */
        TOP,

        /**
        * Turkish Lira (TRY).
        */
        TRY,

        /**
        * Trinidad and Tobago Dollars (TTD).
        */
        TTD,

        /**
        * Taiwan Dollars (TWD).
        */
        TWD,

        /**
        * Tanzanian Shilling (TZS).
        */
        TZS,

        /**
        * Ukrainian Hryvnia (UAH).
        */
        UAH,

        /**
        * Ugandan Shilling (UGX).
        */
        UGX,

        /**
        * United States Dollars (USD).
        */
        USD,

        /**
        * Uruguayan Pesos (UYU).
        */
        UYU,

        /**
        * Uzbekistan som (UZS).
        */
        UZS,

        /**
        * Venezuelan Bolivares (VED).
        */
        VED,

        /**
        * Venezuelan Bolivares (VEF).
        *
        * @deprecated `VEF` is deprecated. Use `VES` available from version `2020-10` onwards instead.
        */
        @Deprecated
        VEF,

        /**
        * Venezuelan Bolivares Soberanos (VES).
        */
        VES,

        /**
        * Vietnamese đồng (VND).
        */
        VND,

        /**
        * Vanuatu Vatu (VUV).
        */
        VUV,

        /**
        * Samoan Tala (WST).
        */
        WST,

        /**
        * Central African CFA Franc (XAF).
        */
        XAF,

        /**
        * East Caribbean Dollar (XCD).
        */
        XCD,

        /**
        * West African CFA franc (XOF).
        */
        XOF,

        /**
        * CFP Franc (XPF).
        */
        XPF,

        /**
        * Unrecognized currency.
        */
        XXX,

        /**
        * Yemeni Rial (YER).
        */
        YER,

        /**
        * South African Rand (ZAR).
        */
        ZAR,

        /**
        * Zambian Kwacha (ZMW).
        */
        ZMW,

        UNKNOWN_VALUE;

        public static CurrencyCode fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "AED": {
                    return AED;
                }

                case "AFN": {
                    return AFN;
                }

                case "ALL": {
                    return ALL;
                }

                case "AMD": {
                    return AMD;
                }

                case "ANG": {
                    return ANG;
                }

                case "AOA": {
                    return AOA;
                }

                case "ARS": {
                    return ARS;
                }

                case "AUD": {
                    return AUD;
                }

                case "AWG": {
                    return AWG;
                }

                case "AZN": {
                    return AZN;
                }

                case "BAM": {
                    return BAM;
                }

                case "BBD": {
                    return BBD;
                }

                case "BDT": {
                    return BDT;
                }

                case "BGN": {
                    return BGN;
                }

                case "BHD": {
                    return BHD;
                }

                case "BIF": {
                    return BIF;
                }

                case "BMD": {
                    return BMD;
                }

                case "BND": {
                    return BND;
                }

                case "BOB": {
                    return BOB;
                }

                case "BRL": {
                    return BRL;
                }

                case "BSD": {
                    return BSD;
                }

                case "BTN": {
                    return BTN;
                }

                case "BWP": {
                    return BWP;
                }

                case "BYN": {
                    return BYN;
                }

                case "BZD": {
                    return BZD;
                }

                case "CAD": {
                    return CAD;
                }

                case "CDF": {
                    return CDF;
                }

                case "CHF": {
                    return CHF;
                }

                case "CLP": {
                    return CLP;
                }

                case "CNY": {
                    return CNY;
                }

                case "COP": {
                    return COP;
                }

                case "CRC": {
                    return CRC;
                }

                case "CVE": {
                    return CVE;
                }

                case "CZK": {
                    return CZK;
                }

                case "DJF": {
                    return DJF;
                }

                case "DKK": {
                    return DKK;
                }

                case "DOP": {
                    return DOP;
                }

                case "DZD": {
                    return DZD;
                }

                case "EGP": {
                    return EGP;
                }

                case "ERN": {
                    return ERN;
                }

                case "ETB": {
                    return ETB;
                }

                case "EUR": {
                    return EUR;
                }

                case "FJD": {
                    return FJD;
                }

                case "FKP": {
                    return FKP;
                }

                case "GBP": {
                    return GBP;
                }

                case "GEL": {
                    return GEL;
                }

                case "GHS": {
                    return GHS;
                }

                case "GIP": {
                    return GIP;
                }

                case "GMD": {
                    return GMD;
                }

                case "GNF": {
                    return GNF;
                }

                case "GTQ": {
                    return GTQ;
                }

                case "GYD": {
                    return GYD;
                }

                case "HKD": {
                    return HKD;
                }

                case "HNL": {
                    return HNL;
                }

                case "HRK": {
                    return HRK;
                }

                case "HTG": {
                    return HTG;
                }

                case "HUF": {
                    return HUF;
                }

                case "IDR": {
                    return IDR;
                }

                case "ILS": {
                    return ILS;
                }

                case "INR": {
                    return INR;
                }

                case "IQD": {
                    return IQD;
                }

                case "IRR": {
                    return IRR;
                }

                case "ISK": {
                    return ISK;
                }

                case "JEP": {
                    return JEP;
                }

                case "JMD": {
                    return JMD;
                }

                case "JOD": {
                    return JOD;
                }

                case "JPY": {
                    return JPY;
                }

                case "KES": {
                    return KES;
                }

                case "KGS": {
                    return KGS;
                }

                case "KHR": {
                    return KHR;
                }

                case "KID": {
                    return KID;
                }

                case "KMF": {
                    return KMF;
                }

                case "KRW": {
                    return KRW;
                }

                case "KWD": {
                    return KWD;
                }

                case "KYD": {
                    return KYD;
                }

                case "KZT": {
                    return KZT;
                }

                case "LAK": {
                    return LAK;
                }

                case "LBP": {
                    return LBP;
                }

                case "LKR": {
                    return LKR;
                }

                case "LRD": {
                    return LRD;
                }

                case "LSL": {
                    return LSL;
                }

                case "LTL": {
                    return LTL;
                }

                case "LVL": {
                    return LVL;
                }

                case "LYD": {
                    return LYD;
                }

                case "MAD": {
                    return MAD;
                }

                case "MDL": {
                    return MDL;
                }

                case "MGA": {
                    return MGA;
                }

                case "MKD": {
                    return MKD;
                }

                case "MMK": {
                    return MMK;
                }

                case "MNT": {
                    return MNT;
                }

                case "MOP": {
                    return MOP;
                }

                case "MRU": {
                    return MRU;
                }

                case "MUR": {
                    return MUR;
                }

                case "MVR": {
                    return MVR;
                }

                case "MWK": {
                    return MWK;
                }

                case "MXN": {
                    return MXN;
                }

                case "MYR": {
                    return MYR;
                }

                case "MZN": {
                    return MZN;
                }

                case "NAD": {
                    return NAD;
                }

                case "NGN": {
                    return NGN;
                }

                case "NIO": {
                    return NIO;
                }

                case "NOK": {
                    return NOK;
                }

                case "NPR": {
                    return NPR;
                }

                case "NZD": {
                    return NZD;
                }

                case "OMR": {
                    return OMR;
                }

                case "PAB": {
                    return PAB;
                }

                case "PEN": {
                    return PEN;
                }

                case "PGK": {
                    return PGK;
                }

                case "PHP": {
                    return PHP;
                }

                case "PKR": {
                    return PKR;
                }

                case "PLN": {
                    return PLN;
                }

                case "PYG": {
                    return PYG;
                }

                case "QAR": {
                    return QAR;
                }

                case "RON": {
                    return RON;
                }

                case "RSD": {
                    return RSD;
                }

                case "RUB": {
                    return RUB;
                }

                case "RWF": {
                    return RWF;
                }

                case "SAR": {
                    return SAR;
                }

                case "SBD": {
                    return SBD;
                }

                case "SCR": {
                    return SCR;
                }

                case "SDG": {
                    return SDG;
                }

                case "SEK": {
                    return SEK;
                }

                case "SGD": {
                    return SGD;
                }

                case "SHP": {
                    return SHP;
                }

                case "SLL": {
                    return SLL;
                }

                case "SOS": {
                    return SOS;
                }

                case "SRD": {
                    return SRD;
                }

                case "SSP": {
                    return SSP;
                }

                case "STN": {
                    return STN;
                }

                case "SYP": {
                    return SYP;
                }

                case "SZL": {
                    return SZL;
                }

                case "THB": {
                    return THB;
                }

                case "TJS": {
                    return TJS;
                }

                case "TMT": {
                    return TMT;
                }

                case "TND": {
                    return TND;
                }

                case "TOP": {
                    return TOP;
                }

                case "TRY": {
                    return TRY;
                }

                case "TTD": {
                    return TTD;
                }

                case "TWD": {
                    return TWD;
                }

                case "TZS": {
                    return TZS;
                }

                case "UAH": {
                    return UAH;
                }

                case "UGX": {
                    return UGX;
                }

                case "USD": {
                    return USD;
                }

                case "UYU": {
                    return UYU;
                }

                case "UZS": {
                    return UZS;
                }

                case "VED": {
                    return VED;
                }

                case "VES": {
                    return VES;
                }

                case "VND": {
                    return VND;
                }

                case "VUV": {
                    return VUV;
                }

                case "WST": {
                    return WST;
                }

                case "XAF": {
                    return XAF;
                }

                case "XCD": {
                    return XCD;
                }

                case "XOF": {
                    return XOF;
                }

                case "XPF": {
                    return XPF;
                }

                case "XXX": {
                    return XXX;
                }

                case "YER": {
                    return YER;
                }

                case "ZAR": {
                    return ZAR;
                }

                case "ZMW": {
                    return ZMW;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case AED: {
                    return "AED";
                }

                case AFN: {
                    return "AFN";
                }

                case ALL: {
                    return "ALL";
                }

                case AMD: {
                    return "AMD";
                }

                case ANG: {
                    return "ANG";
                }

                case AOA: {
                    return "AOA";
                }

                case ARS: {
                    return "ARS";
                }

                case AUD: {
                    return "AUD";
                }

                case AWG: {
                    return "AWG";
                }

                case AZN: {
                    return "AZN";
                }

                case BAM: {
                    return "BAM";
                }

                case BBD: {
                    return "BBD";
                }

                case BDT: {
                    return "BDT";
                }

                case BGN: {
                    return "BGN";
                }

                case BHD: {
                    return "BHD";
                }

                case BIF: {
                    return "BIF";
                }

                case BMD: {
                    return "BMD";
                }

                case BND: {
                    return "BND";
                }

                case BOB: {
                    return "BOB";
                }

                case BRL: {
                    return "BRL";
                }

                case BSD: {
                    return "BSD";
                }

                case BTN: {
                    return "BTN";
                }

                case BWP: {
                    return "BWP";
                }

                case BYN: {
                    return "BYN";
                }

                case BZD: {
                    return "BZD";
                }

                case CAD: {
                    return "CAD";
                }

                case CDF: {
                    return "CDF";
                }

                case CHF: {
                    return "CHF";
                }

                case CLP: {
                    return "CLP";
                }

                case CNY: {
                    return "CNY";
                }

                case COP: {
                    return "COP";
                }

                case CRC: {
                    return "CRC";
                }

                case CVE: {
                    return "CVE";
                }

                case CZK: {
                    return "CZK";
                }

                case DJF: {
                    return "DJF";
                }

                case DKK: {
                    return "DKK";
                }

                case DOP: {
                    return "DOP";
                }

                case DZD: {
                    return "DZD";
                }

                case EGP: {
                    return "EGP";
                }

                case ERN: {
                    return "ERN";
                }

                case ETB: {
                    return "ETB";
                }

                case EUR: {
                    return "EUR";
                }

                case FJD: {
                    return "FJD";
                }

                case FKP: {
                    return "FKP";
                }

                case GBP: {
                    return "GBP";
                }

                case GEL: {
                    return "GEL";
                }

                case GHS: {
                    return "GHS";
                }

                case GIP: {
                    return "GIP";
                }

                case GMD: {
                    return "GMD";
                }

                case GNF: {
                    return "GNF";
                }

                case GTQ: {
                    return "GTQ";
                }

                case GYD: {
                    return "GYD";
                }

                case HKD: {
                    return "HKD";
                }

                case HNL: {
                    return "HNL";
                }

                case HRK: {
                    return "HRK";
                }

                case HTG: {
                    return "HTG";
                }

                case HUF: {
                    return "HUF";
                }

                case IDR: {
                    return "IDR";
                }

                case ILS: {
                    return "ILS";
                }

                case INR: {
                    return "INR";
                }

                case IQD: {
                    return "IQD";
                }

                case IRR: {
                    return "IRR";
                }

                case ISK: {
                    return "ISK";
                }

                case JEP: {
                    return "JEP";
                }

                case JMD: {
                    return "JMD";
                }

                case JOD: {
                    return "JOD";
                }

                case JPY: {
                    return "JPY";
                }

                case KES: {
                    return "KES";
                }

                case KGS: {
                    return "KGS";
                }

                case KHR: {
                    return "KHR";
                }

                case KID: {
                    return "KID";
                }

                case KMF: {
                    return "KMF";
                }

                case KRW: {
                    return "KRW";
                }

                case KWD: {
                    return "KWD";
                }

                case KYD: {
                    return "KYD";
                }

                case KZT: {
                    return "KZT";
                }

                case LAK: {
                    return "LAK";
                }

                case LBP: {
                    return "LBP";
                }

                case LKR: {
                    return "LKR";
                }

                case LRD: {
                    return "LRD";
                }

                case LSL: {
                    return "LSL";
                }

                case LTL: {
                    return "LTL";
                }

                case LVL: {
                    return "LVL";
                }

                case LYD: {
                    return "LYD";
                }

                case MAD: {
                    return "MAD";
                }

                case MDL: {
                    return "MDL";
                }

                case MGA: {
                    return "MGA";
                }

                case MKD: {
                    return "MKD";
                }

                case MMK: {
                    return "MMK";
                }

                case MNT: {
                    return "MNT";
                }

                case MOP: {
                    return "MOP";
                }

                case MRU: {
                    return "MRU";
                }

                case MUR: {
                    return "MUR";
                }

                case MVR: {
                    return "MVR";
                }

                case MWK: {
                    return "MWK";
                }

                case MXN: {
                    return "MXN";
                }

                case MYR: {
                    return "MYR";
                }

                case MZN: {
                    return "MZN";
                }

                case NAD: {
                    return "NAD";
                }

                case NGN: {
                    return "NGN";
                }

                case NIO: {
                    return "NIO";
                }

                case NOK: {
                    return "NOK";
                }

                case NPR: {
                    return "NPR";
                }

                case NZD: {
                    return "NZD";
                }

                case OMR: {
                    return "OMR";
                }

                case PAB: {
                    return "PAB";
                }

                case PEN: {
                    return "PEN";
                }

                case PGK: {
                    return "PGK";
                }

                case PHP: {
                    return "PHP";
                }

                case PKR: {
                    return "PKR";
                }

                case PLN: {
                    return "PLN";
                }

                case PYG: {
                    return "PYG";
                }

                case QAR: {
                    return "QAR";
                }

                case RON: {
                    return "RON";
                }

                case RSD: {
                    return "RSD";
                }

                case RUB: {
                    return "RUB";
                }

                case RWF: {
                    return "RWF";
                }

                case SAR: {
                    return "SAR";
                }

                case SBD: {
                    return "SBD";
                }

                case SCR: {
                    return "SCR";
                }

                case SDG: {
                    return "SDG";
                }

                case SEK: {
                    return "SEK";
                }

                case SGD: {
                    return "SGD";
                }

                case SHP: {
                    return "SHP";
                }

                case SLL: {
                    return "SLL";
                }

                case SOS: {
                    return "SOS";
                }

                case SRD: {
                    return "SRD";
                }

                case SSP: {
                    return "SSP";
                }

                case STN: {
                    return "STN";
                }

                case SYP: {
                    return "SYP";
                }

                case SZL: {
                    return "SZL";
                }

                case THB: {
                    return "THB";
                }

                case TJS: {
                    return "TJS";
                }

                case TMT: {
                    return "TMT";
                }

                case TND: {
                    return "TND";
                }

                case TOP: {
                    return "TOP";
                }

                case TRY: {
                    return "TRY";
                }

                case TTD: {
                    return "TTD";
                }

                case TWD: {
                    return "TWD";
                }

                case TZS: {
                    return "TZS";
                }

                case UAH: {
                    return "UAH";
                }

                case UGX: {
                    return "UGX";
                }

                case USD: {
                    return "USD";
                }

                case UYU: {
                    return "UYU";
                }

                case UZS: {
                    return "UZS";
                }

                case VED: {
                    return "VED";
                }

                case VES: {
                    return "VES";
                }

                case VND: {
                    return "VND";
                }

                case VUV: {
                    return "VUV";
                }

                case WST: {
                    return "WST";
                }

                case XAF: {
                    return "XAF";
                }

                case XCD: {
                    return "XCD";
                }

                case XOF: {
                    return "XOF";
                }

                case XPF: {
                    return "XPF";
                }

                case XXX: {
                    return "XXX";
                }

                case YER: {
                    return "YER";
                }

                case ZAR: {
                    return "ZAR";
                }

                case ZMW: {
                    return "ZMW";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface CustomerQueryDefinition {
        void define(CustomerQuery _queryBuilder);
    }

    /**
    * A customer represents a customer account with the shop. Customer accounts store contact information
    * for the customer, saving logged-in customers the trouble of having to provide it at every checkout.
    */
    public static class CustomerQuery extends Query<CustomerQuery> {
        CustomerQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * Indicates whether the customer has consented to be sent marketing material via email.
        */
        public CustomerQuery acceptsMarketing() {
            startField("acceptsMarketing");

            return this;
        }

        public class AddressesArguments extends Arguments {
            AddressesArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * Returns up to the first `n` elements from the list.
            */
            public AddressesArguments first(Integer value) {
                if (value != null) {
                    startArgument("first");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come after the specified cursor.
            */
            public AddressesArguments after(String value) {
                if (value != null) {
                    startArgument("after");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Returns up to the last `n` elements from the list.
            */
            public AddressesArguments last(Integer value) {
                if (value != null) {
                    startArgument("last");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come before the specified cursor.
            */
            public AddressesArguments before(String value) {
                if (value != null) {
                    startArgument("before");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Reverse the order of the underlying list.
            */
            public AddressesArguments reverse(Boolean value) {
                if (value != null) {
                    startArgument("reverse");
                    _queryBuilder.append(value);
                }
                return this;
            }
        }

        public interface AddressesArgumentsDefinition {
            void define(AddressesArguments args);
        }

        /**
        * A list of addresses for the customer.
        */
        public CustomerQuery addresses(MailingAddressConnectionQueryDefinition queryDef) {
            return addresses(args -> {}, queryDef);
        }

        /**
        * A list of addresses for the customer.
        */
        public CustomerQuery addresses(AddressesArgumentsDefinition argsDef, MailingAddressConnectionQueryDefinition queryDef) {
            startField("addresses");

            AddressesArguments args = new AddressesArguments(_queryBuilder);
            argsDef.define(args);
            AddressesArguments.end(args);

            _queryBuilder.append('{');
            queryDef.define(new MailingAddressConnectionQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The date and time when the customer was created.
        */
        public CustomerQuery createdAt() {
            startField("createdAt");

            return this;
        }

        /**
        * The customer’s default address.
        */
        public CustomerQuery defaultAddress(MailingAddressQueryDefinition queryDef) {
            startField("defaultAddress");

            _queryBuilder.append('{');
            queryDef.define(new MailingAddressQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The customer’s name, email or phone number.
        */
        public CustomerQuery displayName() {
            startField("displayName");

            return this;
        }

        /**
        * The customer’s email address.
        */
        public CustomerQuery email() {
            startField("email");

            return this;
        }

        /**
        * The customer’s first name.
        */
        public CustomerQuery firstName() {
            startField("firstName");

            return this;
        }

        /**
        * A unique ID for the customer.
        */
        public CustomerQuery id() {
            startField("id");

            return this;
        }

        /**
        * The customer’s last name.
        */
        public CustomerQuery lastName() {
            startField("lastName");

            return this;
        }

        public class MetafieldArguments extends Arguments {
            MetafieldArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            /**
            * The container the metafield belongs to. If omitted, the app-reserved namespace will be used.
            */
            public MetafieldArguments namespace(String value) {
                if (value != null) {
                    startArgument("namespace");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }
        }

        public interface MetafieldArgumentsDefinition {
            void define(MetafieldArguments args);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public CustomerQuery metafield(String key, MetafieldQueryDefinition queryDef) {
            return metafield(key, args -> {}, queryDef);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public CustomerQuery metafield(String key, MetafieldArgumentsDefinition argsDef, MetafieldQueryDefinition queryDef) {
            startField("metafield");

            _queryBuilder.append("(key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            argsDef.define(new MetafieldArguments(_queryBuilder));

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */
        public CustomerQuery metafields(List<HasMetafieldsIdentifier> identifiers, MetafieldQueryDefinition queryDef) {
            startField("metafields");

            _queryBuilder.append("(identifiers:");
            _queryBuilder.append('[');
            {
                String listSeperator1 = "";
                for (HasMetafieldsIdentifier item1 : identifiers) {
                    _queryBuilder.append(listSeperator1);
                    listSeperator1 = ",";
                    item1.appendTo(_queryBuilder);
                }
            }
            _queryBuilder.append(']');

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The number of orders that the customer has made at the store in their lifetime.
        */
        public CustomerQuery numberOfOrders() {
            startField("numberOfOrders");

            return this;
        }

        public class OrdersArguments extends Arguments {
            OrdersArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * Returns up to the first `n` elements from the list.
            */
            public OrdersArguments first(Integer value) {
                if (value != null) {
                    startArgument("first");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come after the specified cursor.
            */
            public OrdersArguments after(String value) {
                if (value != null) {
                    startArgument("after");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Returns up to the last `n` elements from the list.
            */
            public OrdersArguments last(Integer value) {
                if (value != null) {
                    startArgument("last");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come before the specified cursor.
            */
            public OrdersArguments before(String value) {
                if (value != null) {
                    startArgument("before");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Reverse the order of the underlying list.
            */
            public OrdersArguments reverse(Boolean value) {
                if (value != null) {
                    startArgument("reverse");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Sort the underlying list by the given key.
            */
            public OrdersArguments sortKey(OrderSortKeys value) {
                if (value != null) {
                    startArgument("sortKey");
                    _queryBuilder.append(value.toString());
                }
                return this;
            }

            /**
            * Apply one or multiple filters to the query.
            * | name | description | acceptable_values | default_value | example_use |
            * | ---- | ---- | ---- | ---- | ---- |
            * | processed_at |
            * Refer to the detailed [search syntax](https://shopify.dev/api/usage/search-syntax) for more
            * information about using filters.
            */
            public OrdersArguments query(String value) {
                if (value != null) {
                    startArgument("query");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }
        }

        public interface OrdersArgumentsDefinition {
            void define(OrdersArguments args);
        }

        /**
        * The orders associated with the customer.
        */
        public CustomerQuery orders(OrderConnectionQueryDefinition queryDef) {
            return orders(args -> {}, queryDef);
        }

        /**
        * The orders associated with the customer.
        */
        public CustomerQuery orders(OrdersArgumentsDefinition argsDef, OrderConnectionQueryDefinition queryDef) {
            startField("orders");

            OrdersArguments args = new OrdersArguments(_queryBuilder);
            argsDef.define(args);
            OrdersArguments.end(args);

            _queryBuilder.append('{');
            queryDef.define(new OrderConnectionQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The customer’s phone number.
        */
        public CustomerQuery phone() {
            startField("phone");

            return this;
        }

        /**
        * A comma separated list of tags that have been added to the customer.
        * Additional access scope required: unauthenticated_read_customer_tags.
        */
        public CustomerQuery tags() {
            startField("tags");

            return this;
        }

        /**
        * The date and time when the customer information was updated.
        */
        public CustomerQuery updatedAt() {
            startField("updatedAt");

            return this;
        }
    }

    /**
    * A customer represents a customer account with the shop. Customer accounts store contact information
    * for the customer, saving logged-in customers the trouble of having to provide it at every checkout.
    */
    public static class Customer extends AbstractResponse<Customer> implements HasMetafields, MetafieldParentResource {
        public Customer() {
        }

        public Customer(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "acceptsMarketing": {
                        responseData.put(key, jsonAsBoolean(field.getValue(), key));

                        break;
                    }

                    case "addresses": {
                        responseData.put(key, new MailingAddressConnection(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "createdAt": {
                        responseData.put(key, Utils.parseDateTime(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "defaultAddress": {
                        MailingAddress optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new MailingAddress(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "displayName": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "email": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "firstName": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "lastName": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "metafield": {
                        Metafield optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Metafield(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "metafields": {
                        List<Metafield> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            Metafield optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = new Metafield(jsonAsObject(element1, key));
                            }

                            list1.add(optional2);
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "numberOfOrders": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "orders": {
                        responseData.put(key, new OrderConnection(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "phone": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "tags": {
                        List<String> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(jsonAsString(element1, key));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "updatedAt": {
                        responseData.put(key, Utils.parseDateTime(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "Customer";
        }

        /**
        * Indicates whether the customer has consented to be sent marketing material via email.
        */

        public Boolean getAcceptsMarketing() {
            return (Boolean) get("acceptsMarketing");
        }

        public Customer setAcceptsMarketing(Boolean arg) {
            optimisticData.put(getKey("acceptsMarketing"), arg);
            return this;
        }

        /**
        * A list of addresses for the customer.
        */

        public MailingAddressConnection getAddresses() {
            return (MailingAddressConnection) get("addresses");
        }

        public Customer setAddresses(MailingAddressConnection arg) {
            optimisticData.put(getKey("addresses"), arg);
            return this;
        }

        /**
        * The date and time when the customer was created.
        */

        public DateTime getCreatedAt() {
            return (DateTime) get("createdAt");
        }

        public Customer setCreatedAt(DateTime arg) {
            optimisticData.put(getKey("createdAt"), arg);
            return this;
        }

        /**
        * The customer’s default address.
        */

        public MailingAddress getDefaultAddress() {
            return (MailingAddress) get("defaultAddress");
        }

        public Customer setDefaultAddress(MailingAddress arg) {
            optimisticData.put(getKey("defaultAddress"), arg);
            return this;
        }

        /**
        * The customer’s name, email or phone number.
        */

        public String getDisplayName() {
            return (String) get("displayName");
        }

        public Customer setDisplayName(String arg) {
            optimisticData.put(getKey("displayName"), arg);
            return this;
        }

        /**
        * The customer’s email address.
        */

        public String getEmail() {
            return (String) get("email");
        }

        public Customer setEmail(String arg) {
            optimisticData.put(getKey("email"), arg);
            return this;
        }

        /**
        * The customer’s first name.
        */

        public String getFirstName() {
            return (String) get("firstName");
        }

        public Customer setFirstName(String arg) {
            optimisticData.put(getKey("firstName"), arg);
            return this;
        }

        /**
        * A unique ID for the customer.
        */

        public ID getId() {
            return (ID) get("id");
        }

        public Customer setId(ID arg) {
            optimisticData.put(getKey("id"), arg);
            return this;
        }

        /**
        * The customer’s last name.
        */

        public String getLastName() {
            return (String) get("lastName");
        }

        public Customer setLastName(String arg) {
            optimisticData.put(getKey("lastName"), arg);
            return this;
        }

        /**
        * Returns a metafield found by namespace and key.
        */

        public Metafield getMetafield() {
            return (Metafield) get("metafield");
        }

        public Customer setMetafield(Metafield arg) {
            optimisticData.put(getKey("metafield"), arg);
            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */

        public List<Metafield> getMetafields() {
            return (List<Metafield>) get("metafields");
        }

        public Customer setMetafields(List<Metafield> arg) {
            optimisticData.put(getKey("metafields"), arg);
            return this;
        }

        /**
        * The number of orders that the customer has made at the store in their lifetime.
        */

        public String getNumberOfOrders() {
            return (String) get("numberOfOrders");
        }

        public Customer setNumberOfOrders(String arg) {
            optimisticData.put(getKey("numberOfOrders"), arg);
            return this;
        }

        /**
        * The orders associated with the customer.
        */

        public OrderConnection getOrders() {
            return (OrderConnection) get("orders");
        }

        public Customer setOrders(OrderConnection arg) {
            optimisticData.put(getKey("orders"), arg);
            return this;
        }

        /**
        * The customer’s phone number.
        */

        public String getPhone() {
            return (String) get("phone");
        }

        public Customer setPhone(String arg) {
            optimisticData.put(getKey("phone"), arg);
            return this;
        }

        /**
        * A comma separated list of tags that have been added to the customer.
        * Additional access scope required: unauthenticated_read_customer_tags.
        */

        public List<String> getTags() {
            return (List<String>) get("tags");
        }

        public Customer setTags(List<String> arg) {
            optimisticData.put(getKey("tags"), arg);
            return this;
        }

        /**
        * The date and time when the customer information was updated.
        */

        public DateTime getUpdatedAt() {
            return (DateTime) get("updatedAt");
        }

        public Customer setUpdatedAt(DateTime arg) {
            optimisticData.put(getKey("updatedAt"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "acceptsMarketing": return false;

                case "addresses": return true;

                case "createdAt": return false;

                case "defaultAddress": return true;

                case "displayName": return false;

                case "email": return false;

                case "firstName": return false;

                case "id": return false;

                case "lastName": return false;

                case "metafield": return true;

                case "metafields": return true;

                case "numberOfOrders": return false;

                case "orders": return true;

                case "phone": return false;

                case "tags": return false;

                case "updatedAt": return false;

                default: return false;
            }
        }
    }

    public interface CustomerAccessTokenQueryDefinition {
        void define(CustomerAccessTokenQuery _queryBuilder);
    }

    /**
    * A CustomerAccessToken represents the unique token required to make modifications to the customer
    * object.
    */
    public static class CustomerAccessTokenQuery extends Query<CustomerAccessTokenQuery> {
        CustomerAccessTokenQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The customer’s access token.
        */
        public CustomerAccessTokenQuery accessToken() {
            startField("accessToken");

            return this;
        }

        /**
        * The date and time when the customer access token expires.
        */
        public CustomerAccessTokenQuery expiresAt() {
            startField("expiresAt");

            return this;
        }
    }

    /**
    * A CustomerAccessToken represents the unique token required to make modifications to the customer
    * object.
    */
    public static class CustomerAccessToken extends AbstractResponse<CustomerAccessToken> {
        public CustomerAccessToken() {
        }

        public CustomerAccessToken(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "accessToken": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "expiresAt": {
                        responseData.put(key, Utils.parseDateTime(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerAccessToken";
        }

        /**
        * The customer’s access token.
        */

        public String getAccessToken() {
            return (String) get("accessToken");
        }

        public CustomerAccessToken setAccessToken(String arg) {
            optimisticData.put(getKey("accessToken"), arg);
            return this;
        }

        /**
        * The date and time when the customer access token expires.
        */

        public DateTime getExpiresAt() {
            return (DateTime) get("expiresAt");
        }

        public CustomerAccessToken setExpiresAt(DateTime arg) {
            optimisticData.put(getKey("expiresAt"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "accessToken": return false;

                case "expiresAt": return false;

                default: return false;
            }
        }
    }

    public static class CustomerAccessTokenCreateInput implements Serializable {
        private String email;

        private String password;

        public CustomerAccessTokenCreateInput(String email, String password) {
            this.email = email;

            this.password = password;
        }

        public String getEmail() {
            return email;
        }

        public CustomerAccessTokenCreateInput setEmail(String email) {
            this.email = email;
            return this;
        }

        public String getPassword() {
            return password;
        }

        public CustomerAccessTokenCreateInput setPassword(String password) {
            this.password = password;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("email:");
            Query.appendQuotedString(_queryBuilder, email.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("password:");
            Query.appendQuotedString(_queryBuilder, password.toString());

            _queryBuilder.append('}');
        }
    }

    public interface CustomerAccessTokenCreatePayloadQueryDefinition {
        void define(CustomerAccessTokenCreatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `customerAccessTokenCreate` mutation.
    */
    public static class CustomerAccessTokenCreatePayloadQuery extends Query<CustomerAccessTokenCreatePayloadQuery> {
        CustomerAccessTokenCreatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The newly created customer access token object.
        */
        public CustomerAccessTokenCreatePayloadQuery customerAccessToken(CustomerAccessTokenQueryDefinition queryDef) {
            startField("customerAccessToken");

            _queryBuilder.append('{');
            queryDef.define(new CustomerAccessTokenQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CustomerAccessTokenCreatePayloadQuery customerUserErrors(CustomerUserErrorQueryDefinition queryDef) {
            startField("customerUserErrors");

            _queryBuilder.append('{');
            queryDef.define(new CustomerUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */
        @Deprecated
        public CustomerAccessTokenCreatePayloadQuery userErrors(UserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new UserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `customerAccessTokenCreate` mutation.
    */
    public static class CustomerAccessTokenCreatePayload extends AbstractResponse<CustomerAccessTokenCreatePayload> {
        public CustomerAccessTokenCreatePayload() {
        }

        public CustomerAccessTokenCreatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "customerAccessToken": {
                        CustomerAccessToken optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new CustomerAccessToken(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerUserErrors": {
                        List<CustomerUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CustomerUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "userErrors": {
                        List<UserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new UserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerAccessTokenCreatePayload";
        }

        /**
        * The newly created customer access token object.
        */

        public CustomerAccessToken getCustomerAccessToken() {
            return (CustomerAccessToken) get("customerAccessToken");
        }

        public CustomerAccessTokenCreatePayload setCustomerAccessToken(CustomerAccessToken arg) {
            optimisticData.put(getKey("customerAccessToken"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CustomerUserError> getCustomerUserErrors() {
            return (List<CustomerUserError>) get("customerUserErrors");
        }

        public CustomerAccessTokenCreatePayload setCustomerUserErrors(List<CustomerUserError> arg) {
            optimisticData.put(getKey("customerUserErrors"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */

        public List<UserError> getUserErrors() {
            return (List<UserError>) get("userErrors");
        }

        public CustomerAccessTokenCreatePayload setUserErrors(List<UserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "customerAccessToken": return true;

                case "customerUserErrors": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CustomerAccessTokenCreateWithMultipassPayloadQueryDefinition {
        void define(CustomerAccessTokenCreateWithMultipassPayloadQuery _queryBuilder);
    }

    /**
    * Return type for `customerAccessTokenCreateWithMultipass` mutation.
    */
    public static class CustomerAccessTokenCreateWithMultipassPayloadQuery extends Query<CustomerAccessTokenCreateWithMultipassPayloadQuery> {
        CustomerAccessTokenCreateWithMultipassPayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * An access token object associated with the customer.
        */
        public CustomerAccessTokenCreateWithMultipassPayloadQuery customerAccessToken(CustomerAccessTokenQueryDefinition queryDef) {
            startField("customerAccessToken");

            _queryBuilder.append('{');
            queryDef.define(new CustomerAccessTokenQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CustomerAccessTokenCreateWithMultipassPayloadQuery customerUserErrors(CustomerUserErrorQueryDefinition queryDef) {
            startField("customerUserErrors");

            _queryBuilder.append('{');
            queryDef.define(new CustomerUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `customerAccessTokenCreateWithMultipass` mutation.
    */
    public static class CustomerAccessTokenCreateWithMultipassPayload extends AbstractResponse<CustomerAccessTokenCreateWithMultipassPayload> {
        public CustomerAccessTokenCreateWithMultipassPayload() {
        }

        public CustomerAccessTokenCreateWithMultipassPayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "customerAccessToken": {
                        CustomerAccessToken optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new CustomerAccessToken(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerUserErrors": {
                        List<CustomerUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CustomerUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerAccessTokenCreateWithMultipassPayload";
        }

        /**
        * An access token object associated with the customer.
        */

        public CustomerAccessToken getCustomerAccessToken() {
            return (CustomerAccessToken) get("customerAccessToken");
        }

        public CustomerAccessTokenCreateWithMultipassPayload setCustomerAccessToken(CustomerAccessToken arg) {
            optimisticData.put(getKey("customerAccessToken"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CustomerUserError> getCustomerUserErrors() {
            return (List<CustomerUserError>) get("customerUserErrors");
        }

        public CustomerAccessTokenCreateWithMultipassPayload setCustomerUserErrors(List<CustomerUserError> arg) {
            optimisticData.put(getKey("customerUserErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "customerAccessToken": return true;

                case "customerUserErrors": return true;

                default: return false;
            }
        }
    }

    public interface CustomerAccessTokenDeletePayloadQueryDefinition {
        void define(CustomerAccessTokenDeletePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `customerAccessTokenDelete` mutation.
    */
    public static class CustomerAccessTokenDeletePayloadQuery extends Query<CustomerAccessTokenDeletePayloadQuery> {
        CustomerAccessTokenDeletePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The destroyed access token.
        */
        public CustomerAccessTokenDeletePayloadQuery deletedAccessToken() {
            startField("deletedAccessToken");

            return this;
        }

        /**
        * ID of the destroyed customer access token.
        */
        public CustomerAccessTokenDeletePayloadQuery deletedCustomerAccessTokenId() {
            startField("deletedCustomerAccessTokenId");

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CustomerAccessTokenDeletePayloadQuery userErrors(UserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new UserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `customerAccessTokenDelete` mutation.
    */
    public static class CustomerAccessTokenDeletePayload extends AbstractResponse<CustomerAccessTokenDeletePayload> {
        public CustomerAccessTokenDeletePayload() {
        }

        public CustomerAccessTokenDeletePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "deletedAccessToken": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "deletedCustomerAccessTokenId": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<UserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new UserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerAccessTokenDeletePayload";
        }

        /**
        * The destroyed access token.
        */

        public String getDeletedAccessToken() {
            return (String) get("deletedAccessToken");
        }

        public CustomerAccessTokenDeletePayload setDeletedAccessToken(String arg) {
            optimisticData.put(getKey("deletedAccessToken"), arg);
            return this;
        }

        /**
        * ID of the destroyed customer access token.
        */

        public String getDeletedCustomerAccessTokenId() {
            return (String) get("deletedCustomerAccessTokenId");
        }

        public CustomerAccessTokenDeletePayload setDeletedCustomerAccessTokenId(String arg) {
            optimisticData.put(getKey("deletedCustomerAccessTokenId"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<UserError> getUserErrors() {
            return (List<UserError>) get("userErrors");
        }

        public CustomerAccessTokenDeletePayload setUserErrors(List<UserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "deletedAccessToken": return false;

                case "deletedCustomerAccessTokenId": return false;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CustomerAccessTokenRenewPayloadQueryDefinition {
        void define(CustomerAccessTokenRenewPayloadQuery _queryBuilder);
    }

    /**
    * Return type for `customerAccessTokenRenew` mutation.
    */
    public static class CustomerAccessTokenRenewPayloadQuery extends Query<CustomerAccessTokenRenewPayloadQuery> {
        CustomerAccessTokenRenewPayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The renewed customer access token object.
        */
        public CustomerAccessTokenRenewPayloadQuery customerAccessToken(CustomerAccessTokenQueryDefinition queryDef) {
            startField("customerAccessToken");

            _queryBuilder.append('{');
            queryDef.define(new CustomerAccessTokenQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CustomerAccessTokenRenewPayloadQuery userErrors(UserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new UserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `customerAccessTokenRenew` mutation.
    */
    public static class CustomerAccessTokenRenewPayload extends AbstractResponse<CustomerAccessTokenRenewPayload> {
        public CustomerAccessTokenRenewPayload() {
        }

        public CustomerAccessTokenRenewPayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "customerAccessToken": {
                        CustomerAccessToken optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new CustomerAccessToken(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<UserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new UserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerAccessTokenRenewPayload";
        }

        /**
        * The renewed customer access token object.
        */

        public CustomerAccessToken getCustomerAccessToken() {
            return (CustomerAccessToken) get("customerAccessToken");
        }

        public CustomerAccessTokenRenewPayload setCustomerAccessToken(CustomerAccessToken arg) {
            optimisticData.put(getKey("customerAccessToken"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<UserError> getUserErrors() {
            return (List<UserError>) get("userErrors");
        }

        public CustomerAccessTokenRenewPayload setUserErrors(List<UserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "customerAccessToken": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CustomerActivateByUrlPayloadQueryDefinition {
        void define(CustomerActivateByUrlPayloadQuery _queryBuilder);
    }

    /**
    * Return type for `customerActivateByUrl` mutation.
    */
    public static class CustomerActivateByUrlPayloadQuery extends Query<CustomerActivateByUrlPayloadQuery> {
        CustomerActivateByUrlPayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The customer that was activated.
        */
        public CustomerActivateByUrlPayloadQuery customer(CustomerQueryDefinition queryDef) {
            startField("customer");

            _queryBuilder.append('{');
            queryDef.define(new CustomerQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A new customer access token for the customer.
        */
        public CustomerActivateByUrlPayloadQuery customerAccessToken(CustomerAccessTokenQueryDefinition queryDef) {
            startField("customerAccessToken");

            _queryBuilder.append('{');
            queryDef.define(new CustomerAccessTokenQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CustomerActivateByUrlPayloadQuery customerUserErrors(CustomerUserErrorQueryDefinition queryDef) {
            startField("customerUserErrors");

            _queryBuilder.append('{');
            queryDef.define(new CustomerUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `customerActivateByUrl` mutation.
    */
    public static class CustomerActivateByUrlPayload extends AbstractResponse<CustomerActivateByUrlPayload> {
        public CustomerActivateByUrlPayload() {
        }

        public CustomerActivateByUrlPayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "customer": {
                        Customer optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Customer(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerAccessToken": {
                        CustomerAccessToken optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new CustomerAccessToken(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerUserErrors": {
                        List<CustomerUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CustomerUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerActivateByUrlPayload";
        }

        /**
        * The customer that was activated.
        */

        public Customer getCustomer() {
            return (Customer) get("customer");
        }

        public CustomerActivateByUrlPayload setCustomer(Customer arg) {
            optimisticData.put(getKey("customer"), arg);
            return this;
        }

        /**
        * A new customer access token for the customer.
        */

        public CustomerAccessToken getCustomerAccessToken() {
            return (CustomerAccessToken) get("customerAccessToken");
        }

        public CustomerActivateByUrlPayload setCustomerAccessToken(CustomerAccessToken arg) {
            optimisticData.put(getKey("customerAccessToken"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CustomerUserError> getCustomerUserErrors() {
            return (List<CustomerUserError>) get("customerUserErrors");
        }

        public CustomerActivateByUrlPayload setCustomerUserErrors(List<CustomerUserError> arg) {
            optimisticData.put(getKey("customerUserErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "customer": return true;

                case "customerAccessToken": return true;

                case "customerUserErrors": return true;

                default: return false;
            }
        }
    }

    public static class CustomerActivateInput implements Serializable {
        private String activationToken;

        private String password;

        public CustomerActivateInput(String activationToken, String password) {
            this.activationToken = activationToken;

            this.password = password;
        }

        public String getActivationToken() {
            return activationToken;
        }

        public CustomerActivateInput setActivationToken(String activationToken) {
            this.activationToken = activationToken;
            return this;
        }

        public String getPassword() {
            return password;
        }

        public CustomerActivateInput setPassword(String password) {
            this.password = password;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("activationToken:");
            Query.appendQuotedString(_queryBuilder, activationToken.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("password:");
            Query.appendQuotedString(_queryBuilder, password.toString());

            _queryBuilder.append('}');
        }
    }

    public interface CustomerActivatePayloadQueryDefinition {
        void define(CustomerActivatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `customerActivate` mutation.
    */
    public static class CustomerActivatePayloadQuery extends Query<CustomerActivatePayloadQuery> {
        CustomerActivatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The customer object.
        */
        public CustomerActivatePayloadQuery customer(CustomerQueryDefinition queryDef) {
            startField("customer");

            _queryBuilder.append('{');
            queryDef.define(new CustomerQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A newly created customer access token object for the customer.
        */
        public CustomerActivatePayloadQuery customerAccessToken(CustomerAccessTokenQueryDefinition queryDef) {
            startField("customerAccessToken");

            _queryBuilder.append('{');
            queryDef.define(new CustomerAccessTokenQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CustomerActivatePayloadQuery customerUserErrors(CustomerUserErrorQueryDefinition queryDef) {
            startField("customerUserErrors");

            _queryBuilder.append('{');
            queryDef.define(new CustomerUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */
        @Deprecated
        public CustomerActivatePayloadQuery userErrors(UserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new UserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `customerActivate` mutation.
    */
    public static class CustomerActivatePayload extends AbstractResponse<CustomerActivatePayload> {
        public CustomerActivatePayload() {
        }

        public CustomerActivatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "customer": {
                        Customer optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Customer(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerAccessToken": {
                        CustomerAccessToken optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new CustomerAccessToken(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerUserErrors": {
                        List<CustomerUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CustomerUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "userErrors": {
                        List<UserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new UserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerActivatePayload";
        }

        /**
        * The customer object.
        */

        public Customer getCustomer() {
            return (Customer) get("customer");
        }

        public CustomerActivatePayload setCustomer(Customer arg) {
            optimisticData.put(getKey("customer"), arg);
            return this;
        }

        /**
        * A newly created customer access token object for the customer.
        */

        public CustomerAccessToken getCustomerAccessToken() {
            return (CustomerAccessToken) get("customerAccessToken");
        }

        public CustomerActivatePayload setCustomerAccessToken(CustomerAccessToken arg) {
            optimisticData.put(getKey("customerAccessToken"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CustomerUserError> getCustomerUserErrors() {
            return (List<CustomerUserError>) get("customerUserErrors");
        }

        public CustomerActivatePayload setCustomerUserErrors(List<CustomerUserError> arg) {
            optimisticData.put(getKey("customerUserErrors"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */

        public List<UserError> getUserErrors() {
            return (List<UserError>) get("userErrors");
        }

        public CustomerActivatePayload setUserErrors(List<UserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "customer": return true;

                case "customerAccessToken": return true;

                case "customerUserErrors": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CustomerAddressCreatePayloadQueryDefinition {
        void define(CustomerAddressCreatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `customerAddressCreate` mutation.
    */
    public static class CustomerAddressCreatePayloadQuery extends Query<CustomerAddressCreatePayloadQuery> {
        CustomerAddressCreatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The new customer address object.
        */
        public CustomerAddressCreatePayloadQuery customerAddress(MailingAddressQueryDefinition queryDef) {
            startField("customerAddress");

            _queryBuilder.append('{');
            queryDef.define(new MailingAddressQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CustomerAddressCreatePayloadQuery customerUserErrors(CustomerUserErrorQueryDefinition queryDef) {
            startField("customerUserErrors");

            _queryBuilder.append('{');
            queryDef.define(new CustomerUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */
        @Deprecated
        public CustomerAddressCreatePayloadQuery userErrors(UserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new UserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `customerAddressCreate` mutation.
    */
    public static class CustomerAddressCreatePayload extends AbstractResponse<CustomerAddressCreatePayload> {
        public CustomerAddressCreatePayload() {
        }

        public CustomerAddressCreatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "customerAddress": {
                        MailingAddress optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new MailingAddress(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerUserErrors": {
                        List<CustomerUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CustomerUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "userErrors": {
                        List<UserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new UserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerAddressCreatePayload";
        }

        /**
        * The new customer address object.
        */

        public MailingAddress getCustomerAddress() {
            return (MailingAddress) get("customerAddress");
        }

        public CustomerAddressCreatePayload setCustomerAddress(MailingAddress arg) {
            optimisticData.put(getKey("customerAddress"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CustomerUserError> getCustomerUserErrors() {
            return (List<CustomerUserError>) get("customerUserErrors");
        }

        public CustomerAddressCreatePayload setCustomerUserErrors(List<CustomerUserError> arg) {
            optimisticData.put(getKey("customerUserErrors"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */

        public List<UserError> getUserErrors() {
            return (List<UserError>) get("userErrors");
        }

        public CustomerAddressCreatePayload setUserErrors(List<UserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "customerAddress": return true;

                case "customerUserErrors": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CustomerAddressDeletePayloadQueryDefinition {
        void define(CustomerAddressDeletePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `customerAddressDelete` mutation.
    */
    public static class CustomerAddressDeletePayloadQuery extends Query<CustomerAddressDeletePayloadQuery> {
        CustomerAddressDeletePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CustomerAddressDeletePayloadQuery customerUserErrors(CustomerUserErrorQueryDefinition queryDef) {
            startField("customerUserErrors");

            _queryBuilder.append('{');
            queryDef.define(new CustomerUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * ID of the deleted customer address.
        */
        public CustomerAddressDeletePayloadQuery deletedCustomerAddressId() {
            startField("deletedCustomerAddressId");

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */
        @Deprecated
        public CustomerAddressDeletePayloadQuery userErrors(UserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new UserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `customerAddressDelete` mutation.
    */
    public static class CustomerAddressDeletePayload extends AbstractResponse<CustomerAddressDeletePayload> {
        public CustomerAddressDeletePayload() {
        }

        public CustomerAddressDeletePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "customerUserErrors": {
                        List<CustomerUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CustomerUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "deletedCustomerAddressId": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "userErrors": {
                        List<UserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new UserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerAddressDeletePayload";
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CustomerUserError> getCustomerUserErrors() {
            return (List<CustomerUserError>) get("customerUserErrors");
        }

        public CustomerAddressDeletePayload setCustomerUserErrors(List<CustomerUserError> arg) {
            optimisticData.put(getKey("customerUserErrors"), arg);
            return this;
        }

        /**
        * ID of the deleted customer address.
        */

        public String getDeletedCustomerAddressId() {
            return (String) get("deletedCustomerAddressId");
        }

        public CustomerAddressDeletePayload setDeletedCustomerAddressId(String arg) {
            optimisticData.put(getKey("deletedCustomerAddressId"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */

        public List<UserError> getUserErrors() {
            return (List<UserError>) get("userErrors");
        }

        public CustomerAddressDeletePayload setUserErrors(List<UserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "customerUserErrors": return true;

                case "deletedCustomerAddressId": return false;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CustomerAddressUpdatePayloadQueryDefinition {
        void define(CustomerAddressUpdatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `customerAddressUpdate` mutation.
    */
    public static class CustomerAddressUpdatePayloadQuery extends Query<CustomerAddressUpdatePayloadQuery> {
        CustomerAddressUpdatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The customer’s updated mailing address.
        */
        public CustomerAddressUpdatePayloadQuery customerAddress(MailingAddressQueryDefinition queryDef) {
            startField("customerAddress");

            _queryBuilder.append('{');
            queryDef.define(new MailingAddressQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CustomerAddressUpdatePayloadQuery customerUserErrors(CustomerUserErrorQueryDefinition queryDef) {
            startField("customerUserErrors");

            _queryBuilder.append('{');
            queryDef.define(new CustomerUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */
        @Deprecated
        public CustomerAddressUpdatePayloadQuery userErrors(UserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new UserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `customerAddressUpdate` mutation.
    */
    public static class CustomerAddressUpdatePayload extends AbstractResponse<CustomerAddressUpdatePayload> {
        public CustomerAddressUpdatePayload() {
        }

        public CustomerAddressUpdatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "customerAddress": {
                        MailingAddress optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new MailingAddress(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerUserErrors": {
                        List<CustomerUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CustomerUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "userErrors": {
                        List<UserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new UserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerAddressUpdatePayload";
        }

        /**
        * The customer’s updated mailing address.
        */

        public MailingAddress getCustomerAddress() {
            return (MailingAddress) get("customerAddress");
        }

        public CustomerAddressUpdatePayload setCustomerAddress(MailingAddress arg) {
            optimisticData.put(getKey("customerAddress"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CustomerUserError> getCustomerUserErrors() {
            return (List<CustomerUserError>) get("customerUserErrors");
        }

        public CustomerAddressUpdatePayload setCustomerUserErrors(List<CustomerUserError> arg) {
            optimisticData.put(getKey("customerUserErrors"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */

        public List<UserError> getUserErrors() {
            return (List<UserError>) get("userErrors");
        }

        public CustomerAddressUpdatePayload setUserErrors(List<UserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "customerAddress": return true;

                case "customerUserErrors": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public static class CustomerCreateInput implements Serializable {
        private String email;

        private String password;

        private Input<String> firstName = Input.undefined();

        private Input<String> lastName = Input.undefined();

        private Input<String> phone = Input.undefined();

        private Input<Boolean> acceptsMarketing = Input.undefined();

        public CustomerCreateInput(String email, String password) {
            this.email = email;

            this.password = password;
        }

        public String getEmail() {
            return email;
        }

        public CustomerCreateInput setEmail(String email) {
            this.email = email;
            return this;
        }

        public String getPassword() {
            return password;
        }

        public CustomerCreateInput setPassword(String password) {
            this.password = password;
            return this;
        }

        public String getFirstName() {
            return firstName.getValue();
        }

        public Input<String> getFirstNameInput() {
            return firstName;
        }

        public CustomerCreateInput setFirstName(String firstName) {
            this.firstName = Input.optional(firstName);
            return this;
        }

        public CustomerCreateInput setFirstNameInput(Input<String> firstName) {
            if (firstName == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.firstName = firstName;
            return this;
        }

        public String getLastName() {
            return lastName.getValue();
        }

        public Input<String> getLastNameInput() {
            return lastName;
        }

        public CustomerCreateInput setLastName(String lastName) {
            this.lastName = Input.optional(lastName);
            return this;
        }

        public CustomerCreateInput setLastNameInput(Input<String> lastName) {
            if (lastName == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.lastName = lastName;
            return this;
        }

        public String getPhone() {
            return phone.getValue();
        }

        public Input<String> getPhoneInput() {
            return phone;
        }

        public CustomerCreateInput setPhone(String phone) {
            this.phone = Input.optional(phone);
            return this;
        }

        public CustomerCreateInput setPhoneInput(Input<String> phone) {
            if (phone == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.phone = phone;
            return this;
        }

        public Boolean getAcceptsMarketing() {
            return acceptsMarketing.getValue();
        }

        public Input<Boolean> getAcceptsMarketingInput() {
            return acceptsMarketing;
        }

        public CustomerCreateInput setAcceptsMarketing(Boolean acceptsMarketing) {
            this.acceptsMarketing = Input.optional(acceptsMarketing);
            return this;
        }

        public CustomerCreateInput setAcceptsMarketingInput(Input<Boolean> acceptsMarketing) {
            if (acceptsMarketing == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.acceptsMarketing = acceptsMarketing;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("email:");
            Query.appendQuotedString(_queryBuilder, email.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("password:");
            Query.appendQuotedString(_queryBuilder, password.toString());

            if (this.firstName.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("firstName:");
                if (firstName.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, firstName.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.lastName.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("lastName:");
                if (lastName.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, lastName.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.phone.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("phone:");
                if (phone.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, phone.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.acceptsMarketing.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("acceptsMarketing:");
                if (acceptsMarketing.getValue() != null) {
                    _queryBuilder.append(acceptsMarketing.getValue());
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    public interface CustomerCreatePayloadQueryDefinition {
        void define(CustomerCreatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `customerCreate` mutation.
    */
    public static class CustomerCreatePayloadQuery extends Query<CustomerCreatePayloadQuery> {
        CustomerCreatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The created customer object.
        */
        public CustomerCreatePayloadQuery customer(CustomerQueryDefinition queryDef) {
            startField("customer");

            _queryBuilder.append('{');
            queryDef.define(new CustomerQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CustomerCreatePayloadQuery customerUserErrors(CustomerUserErrorQueryDefinition queryDef) {
            startField("customerUserErrors");

            _queryBuilder.append('{');
            queryDef.define(new CustomerUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */
        @Deprecated
        public CustomerCreatePayloadQuery userErrors(UserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new UserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `customerCreate` mutation.
    */
    public static class CustomerCreatePayload extends AbstractResponse<CustomerCreatePayload> {
        public CustomerCreatePayload() {
        }

        public CustomerCreatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "customer": {
                        Customer optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Customer(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerUserErrors": {
                        List<CustomerUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CustomerUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "userErrors": {
                        List<UserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new UserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerCreatePayload";
        }

        /**
        * The created customer object.
        */

        public Customer getCustomer() {
            return (Customer) get("customer");
        }

        public CustomerCreatePayload setCustomer(Customer arg) {
            optimisticData.put(getKey("customer"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CustomerUserError> getCustomerUserErrors() {
            return (List<CustomerUserError>) get("customerUserErrors");
        }

        public CustomerCreatePayload setCustomerUserErrors(List<CustomerUserError> arg) {
            optimisticData.put(getKey("customerUserErrors"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */

        public List<UserError> getUserErrors() {
            return (List<UserError>) get("userErrors");
        }

        public CustomerCreatePayload setUserErrors(List<UserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "customer": return true;

                case "customerUserErrors": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CustomerDefaultAddressUpdatePayloadQueryDefinition {
        void define(CustomerDefaultAddressUpdatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `customerDefaultAddressUpdate` mutation.
    */
    public static class CustomerDefaultAddressUpdatePayloadQuery extends Query<CustomerDefaultAddressUpdatePayloadQuery> {
        CustomerDefaultAddressUpdatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The updated customer object.
        */
        public CustomerDefaultAddressUpdatePayloadQuery customer(CustomerQueryDefinition queryDef) {
            startField("customer");

            _queryBuilder.append('{');
            queryDef.define(new CustomerQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CustomerDefaultAddressUpdatePayloadQuery customerUserErrors(CustomerUserErrorQueryDefinition queryDef) {
            startField("customerUserErrors");

            _queryBuilder.append('{');
            queryDef.define(new CustomerUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */
        @Deprecated
        public CustomerDefaultAddressUpdatePayloadQuery userErrors(UserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new UserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `customerDefaultAddressUpdate` mutation.
    */
    public static class CustomerDefaultAddressUpdatePayload extends AbstractResponse<CustomerDefaultAddressUpdatePayload> {
        public CustomerDefaultAddressUpdatePayload() {
        }

        public CustomerDefaultAddressUpdatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "customer": {
                        Customer optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Customer(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerUserErrors": {
                        List<CustomerUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CustomerUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "userErrors": {
                        List<UserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new UserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerDefaultAddressUpdatePayload";
        }

        /**
        * The updated customer object.
        */

        public Customer getCustomer() {
            return (Customer) get("customer");
        }

        public CustomerDefaultAddressUpdatePayload setCustomer(Customer arg) {
            optimisticData.put(getKey("customer"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CustomerUserError> getCustomerUserErrors() {
            return (List<CustomerUserError>) get("customerUserErrors");
        }

        public CustomerDefaultAddressUpdatePayload setCustomerUserErrors(List<CustomerUserError> arg) {
            optimisticData.put(getKey("customerUserErrors"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */

        public List<UserError> getUserErrors() {
            return (List<UserError>) get("userErrors");
        }

        public CustomerDefaultAddressUpdatePayload setUserErrors(List<UserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "customer": return true;

                case "customerUserErrors": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    /**
    * Possible error codes that can be returned by `CustomerUserError`.
    */
    public enum CustomerErrorCode {
        /**
        * Customer already enabled.
        */
        ALREADY_ENABLED,

        /**
        * Input email contains an invalid domain name.
        */
        BAD_DOMAIN,

        /**
        * The input value is blank.
        */
        BLANK,

        /**
        * Input contains HTML tags.
        */
        CONTAINS_HTML_TAGS,

        /**
        * Input contains URL.
        */
        CONTAINS_URL,

        /**
        * Customer is disabled.
        */
        CUSTOMER_DISABLED,

        /**
        * The input value is invalid.
        */
        INVALID,

        /**
        * Multipass token is not valid.
        */
        INVALID_MULTIPASS_REQUEST,

        /**
        * Address does not exist.
        */
        NOT_FOUND,

        /**
        * Input password starts or ends with whitespace.
        */
        PASSWORD_STARTS_OR_ENDS_WITH_WHITESPACE,

        /**
        * The input value is already taken.
        */
        TAKEN,

        /**
        * Invalid activation token.
        */
        TOKEN_INVALID,

        /**
        * The input value is too long.
        */
        TOO_LONG,

        /**
        * The input value is too short.
        */
        TOO_SHORT,

        /**
        * Unidentified customer.
        */
        UNIDENTIFIED_CUSTOMER,

        UNKNOWN_VALUE;

        public static CustomerErrorCode fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "ALREADY_ENABLED": {
                    return ALREADY_ENABLED;
                }

                case "BAD_DOMAIN": {
                    return BAD_DOMAIN;
                }

                case "BLANK": {
                    return BLANK;
                }

                case "CONTAINS_HTML_TAGS": {
                    return CONTAINS_HTML_TAGS;
                }

                case "CONTAINS_URL": {
                    return CONTAINS_URL;
                }

                case "CUSTOMER_DISABLED": {
                    return CUSTOMER_DISABLED;
                }

                case "INVALID": {
                    return INVALID;
                }

                case "INVALID_MULTIPASS_REQUEST": {
                    return INVALID_MULTIPASS_REQUEST;
                }

                case "NOT_FOUND": {
                    return NOT_FOUND;
                }

                case "PASSWORD_STARTS_OR_ENDS_WITH_WHITESPACE": {
                    return PASSWORD_STARTS_OR_ENDS_WITH_WHITESPACE;
                }

                case "TAKEN": {
                    return TAKEN;
                }

                case "TOKEN_INVALID": {
                    return TOKEN_INVALID;
                }

                case "TOO_LONG": {
                    return TOO_LONG;
                }

                case "TOO_SHORT": {
                    return TOO_SHORT;
                }

                case "UNIDENTIFIED_CUSTOMER": {
                    return UNIDENTIFIED_CUSTOMER;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case ALREADY_ENABLED: {
                    return "ALREADY_ENABLED";
                }

                case BAD_DOMAIN: {
                    return "BAD_DOMAIN";
                }

                case BLANK: {
                    return "BLANK";
                }

                case CONTAINS_HTML_TAGS: {
                    return "CONTAINS_HTML_TAGS";
                }

                case CONTAINS_URL: {
                    return "CONTAINS_URL";
                }

                case CUSTOMER_DISABLED: {
                    return "CUSTOMER_DISABLED";
                }

                case INVALID: {
                    return "INVALID";
                }

                case INVALID_MULTIPASS_REQUEST: {
                    return "INVALID_MULTIPASS_REQUEST";
                }

                case NOT_FOUND: {
                    return "NOT_FOUND";
                }

                case PASSWORD_STARTS_OR_ENDS_WITH_WHITESPACE: {
                    return "PASSWORD_STARTS_OR_ENDS_WITH_WHITESPACE";
                }

                case TAKEN: {
                    return "TAKEN";
                }

                case TOKEN_INVALID: {
                    return "TOKEN_INVALID";
                }

                case TOO_LONG: {
                    return "TOO_LONG";
                }

                case TOO_SHORT: {
                    return "TOO_SHORT";
                }

                case UNIDENTIFIED_CUSTOMER: {
                    return "UNIDENTIFIED_CUSTOMER";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface CustomerRecoverPayloadQueryDefinition {
        void define(CustomerRecoverPayloadQuery _queryBuilder);
    }

    /**
    * Return type for `customerRecover` mutation.
    */
    public static class CustomerRecoverPayloadQuery extends Query<CustomerRecoverPayloadQuery> {
        CustomerRecoverPayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CustomerRecoverPayloadQuery customerUserErrors(CustomerUserErrorQueryDefinition queryDef) {
            startField("customerUserErrors");

            _queryBuilder.append('{');
            queryDef.define(new CustomerUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */
        @Deprecated
        public CustomerRecoverPayloadQuery userErrors(UserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new UserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `customerRecover` mutation.
    */
    public static class CustomerRecoverPayload extends AbstractResponse<CustomerRecoverPayload> {
        public CustomerRecoverPayload() {
        }

        public CustomerRecoverPayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "customerUserErrors": {
                        List<CustomerUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CustomerUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "userErrors": {
                        List<UserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new UserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerRecoverPayload";
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CustomerUserError> getCustomerUserErrors() {
            return (List<CustomerUserError>) get("customerUserErrors");
        }

        public CustomerRecoverPayload setCustomerUserErrors(List<CustomerUserError> arg) {
            optimisticData.put(getKey("customerUserErrors"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */

        public List<UserError> getUserErrors() {
            return (List<UserError>) get("userErrors");
        }

        public CustomerRecoverPayload setUserErrors(List<UserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "customerUserErrors": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CustomerResetByUrlPayloadQueryDefinition {
        void define(CustomerResetByUrlPayloadQuery _queryBuilder);
    }

    /**
    * Return type for `customerResetByUrl` mutation.
    */
    public static class CustomerResetByUrlPayloadQuery extends Query<CustomerResetByUrlPayloadQuery> {
        CustomerResetByUrlPayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The customer object which was reset.
        */
        public CustomerResetByUrlPayloadQuery customer(CustomerQueryDefinition queryDef) {
            startField("customer");

            _queryBuilder.append('{');
            queryDef.define(new CustomerQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A newly created customer access token object for the customer.
        */
        public CustomerResetByUrlPayloadQuery customerAccessToken(CustomerAccessTokenQueryDefinition queryDef) {
            startField("customerAccessToken");

            _queryBuilder.append('{');
            queryDef.define(new CustomerAccessTokenQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CustomerResetByUrlPayloadQuery customerUserErrors(CustomerUserErrorQueryDefinition queryDef) {
            startField("customerUserErrors");

            _queryBuilder.append('{');
            queryDef.define(new CustomerUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */
        @Deprecated
        public CustomerResetByUrlPayloadQuery userErrors(UserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new UserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `customerResetByUrl` mutation.
    */
    public static class CustomerResetByUrlPayload extends AbstractResponse<CustomerResetByUrlPayload> {
        public CustomerResetByUrlPayload() {
        }

        public CustomerResetByUrlPayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "customer": {
                        Customer optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Customer(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerAccessToken": {
                        CustomerAccessToken optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new CustomerAccessToken(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerUserErrors": {
                        List<CustomerUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CustomerUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "userErrors": {
                        List<UserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new UserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerResetByUrlPayload";
        }

        /**
        * The customer object which was reset.
        */

        public Customer getCustomer() {
            return (Customer) get("customer");
        }

        public CustomerResetByUrlPayload setCustomer(Customer arg) {
            optimisticData.put(getKey("customer"), arg);
            return this;
        }

        /**
        * A newly created customer access token object for the customer.
        */

        public CustomerAccessToken getCustomerAccessToken() {
            return (CustomerAccessToken) get("customerAccessToken");
        }

        public CustomerResetByUrlPayload setCustomerAccessToken(CustomerAccessToken arg) {
            optimisticData.put(getKey("customerAccessToken"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CustomerUserError> getCustomerUserErrors() {
            return (List<CustomerUserError>) get("customerUserErrors");
        }

        public CustomerResetByUrlPayload setCustomerUserErrors(List<CustomerUserError> arg) {
            optimisticData.put(getKey("customerUserErrors"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */

        public List<UserError> getUserErrors() {
            return (List<UserError>) get("userErrors");
        }

        public CustomerResetByUrlPayload setUserErrors(List<UserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "customer": return true;

                case "customerAccessToken": return true;

                case "customerUserErrors": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public static class CustomerResetInput implements Serializable {
        private String resetToken;

        private String password;

        public CustomerResetInput(String resetToken, String password) {
            this.resetToken = resetToken;

            this.password = password;
        }

        public String getResetToken() {
            return resetToken;
        }

        public CustomerResetInput setResetToken(String resetToken) {
            this.resetToken = resetToken;
            return this;
        }

        public String getPassword() {
            return password;
        }

        public CustomerResetInput setPassword(String password) {
            this.password = password;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("resetToken:");
            Query.appendQuotedString(_queryBuilder, resetToken.toString());

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("password:");
            Query.appendQuotedString(_queryBuilder, password.toString());

            _queryBuilder.append('}');
        }
    }

    public interface CustomerResetPayloadQueryDefinition {
        void define(CustomerResetPayloadQuery _queryBuilder);
    }

    /**
    * Return type for `customerReset` mutation.
    */
    public static class CustomerResetPayloadQuery extends Query<CustomerResetPayloadQuery> {
        CustomerResetPayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The customer object which was reset.
        */
        public CustomerResetPayloadQuery customer(CustomerQueryDefinition queryDef) {
            startField("customer");

            _queryBuilder.append('{');
            queryDef.define(new CustomerQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A newly created customer access token object for the customer.
        */
        public CustomerResetPayloadQuery customerAccessToken(CustomerAccessTokenQueryDefinition queryDef) {
            startField("customerAccessToken");

            _queryBuilder.append('{');
            queryDef.define(new CustomerAccessTokenQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CustomerResetPayloadQuery customerUserErrors(CustomerUserErrorQueryDefinition queryDef) {
            startField("customerUserErrors");

            _queryBuilder.append('{');
            queryDef.define(new CustomerUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */
        @Deprecated
        public CustomerResetPayloadQuery userErrors(UserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new UserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `customerReset` mutation.
    */
    public static class CustomerResetPayload extends AbstractResponse<CustomerResetPayload> {
        public CustomerResetPayload() {
        }

        public CustomerResetPayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "customer": {
                        Customer optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Customer(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerAccessToken": {
                        CustomerAccessToken optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new CustomerAccessToken(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerUserErrors": {
                        List<CustomerUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CustomerUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "userErrors": {
                        List<UserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new UserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerResetPayload";
        }

        /**
        * The customer object which was reset.
        */

        public Customer getCustomer() {
            return (Customer) get("customer");
        }

        public CustomerResetPayload setCustomer(Customer arg) {
            optimisticData.put(getKey("customer"), arg);
            return this;
        }

        /**
        * A newly created customer access token object for the customer.
        */

        public CustomerAccessToken getCustomerAccessToken() {
            return (CustomerAccessToken) get("customerAccessToken");
        }

        public CustomerResetPayload setCustomerAccessToken(CustomerAccessToken arg) {
            optimisticData.put(getKey("customerAccessToken"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CustomerUserError> getCustomerUserErrors() {
            return (List<CustomerUserError>) get("customerUserErrors");
        }

        public CustomerResetPayload setCustomerUserErrors(List<CustomerUserError> arg) {
            optimisticData.put(getKey("customerUserErrors"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */

        public List<UserError> getUserErrors() {
            return (List<UserError>) get("userErrors");
        }

        public CustomerResetPayload setUserErrors(List<UserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "customer": return true;

                case "customerAccessToken": return true;

                case "customerUserErrors": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public static class CustomerUpdateInput implements Serializable {
        private Input<String> firstName = Input.undefined();

        private Input<String> lastName = Input.undefined();

        private Input<String> email = Input.undefined();

        private Input<String> phone = Input.undefined();

        private Input<String> password = Input.undefined();

        private Input<Boolean> acceptsMarketing = Input.undefined();

        public String getFirstName() {
            return firstName.getValue();
        }

        public Input<String> getFirstNameInput() {
            return firstName;
        }

        public CustomerUpdateInput setFirstName(String firstName) {
            this.firstName = Input.optional(firstName);
            return this;
        }

        public CustomerUpdateInput setFirstNameInput(Input<String> firstName) {
            if (firstName == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.firstName = firstName;
            return this;
        }

        public String getLastName() {
            return lastName.getValue();
        }

        public Input<String> getLastNameInput() {
            return lastName;
        }

        public CustomerUpdateInput setLastName(String lastName) {
            this.lastName = Input.optional(lastName);
            return this;
        }

        public CustomerUpdateInput setLastNameInput(Input<String> lastName) {
            if (lastName == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.lastName = lastName;
            return this;
        }

        public String getEmail() {
            return email.getValue();
        }

        public Input<String> getEmailInput() {
            return email;
        }

        public CustomerUpdateInput setEmail(String email) {
            this.email = Input.optional(email);
            return this;
        }

        public CustomerUpdateInput setEmailInput(Input<String> email) {
            if (email == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.email = email;
            return this;
        }

        public String getPhone() {
            return phone.getValue();
        }

        public Input<String> getPhoneInput() {
            return phone;
        }

        public CustomerUpdateInput setPhone(String phone) {
            this.phone = Input.optional(phone);
            return this;
        }

        public CustomerUpdateInput setPhoneInput(Input<String> phone) {
            if (phone == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.phone = phone;
            return this;
        }

        public String getPassword() {
            return password.getValue();
        }

        public Input<String> getPasswordInput() {
            return password;
        }

        public CustomerUpdateInput setPassword(String password) {
            this.password = Input.optional(password);
            return this;
        }

        public CustomerUpdateInput setPasswordInput(Input<String> password) {
            if (password == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.password = password;
            return this;
        }

        public Boolean getAcceptsMarketing() {
            return acceptsMarketing.getValue();
        }

        public Input<Boolean> getAcceptsMarketingInput() {
            return acceptsMarketing;
        }

        public CustomerUpdateInput setAcceptsMarketing(Boolean acceptsMarketing) {
            this.acceptsMarketing = Input.optional(acceptsMarketing);
            return this;
        }

        public CustomerUpdateInput setAcceptsMarketingInput(Input<Boolean> acceptsMarketing) {
            if (acceptsMarketing == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.acceptsMarketing = acceptsMarketing;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            if (this.firstName.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("firstName:");
                if (firstName.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, firstName.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.lastName.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("lastName:");
                if (lastName.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, lastName.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.email.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("email:");
                if (email.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, email.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.phone.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("phone:");
                if (phone.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, phone.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.password.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("password:");
                if (password.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, password.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.acceptsMarketing.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("acceptsMarketing:");
                if (acceptsMarketing.getValue() != null) {
                    _queryBuilder.append(acceptsMarketing.getValue());
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    public interface CustomerUpdatePayloadQueryDefinition {
        void define(CustomerUpdatePayloadQuery _queryBuilder);
    }

    /**
    * Return type for `customerUpdate` mutation.
    */
    public static class CustomerUpdatePayloadQuery extends Query<CustomerUpdatePayloadQuery> {
        CustomerUpdatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The updated customer object.
        */
        public CustomerUpdatePayloadQuery customer(CustomerQueryDefinition queryDef) {
            startField("customer");

            _queryBuilder.append('{');
            queryDef.define(new CustomerQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The newly created customer access token. If the customer's password is updated, all previous access
        * tokens
        * (including the one used to perform this mutation) become invalid, and a new token is generated.
        */
        public CustomerUpdatePayloadQuery customerAccessToken(CustomerAccessTokenQueryDefinition queryDef) {
            startField("customerAccessToken");

            _queryBuilder.append('{');
            queryDef.define(new CustomerAccessTokenQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */
        public CustomerUpdatePayloadQuery customerUserErrors(CustomerUserErrorQueryDefinition queryDef) {
            startField("customerUserErrors");

            _queryBuilder.append('{');
            queryDef.define(new CustomerUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */
        @Deprecated
        public CustomerUpdatePayloadQuery userErrors(UserErrorQueryDefinition queryDef) {
            startField("userErrors");

            _queryBuilder.append('{');
            queryDef.define(new UserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Return type for `customerUpdate` mutation.
    */
    public static class CustomerUpdatePayload extends AbstractResponse<CustomerUpdatePayload> {
        public CustomerUpdatePayload() {
        }

        public CustomerUpdatePayload(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "customer": {
                        Customer optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Customer(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerAccessToken": {
                        CustomerAccessToken optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new CustomerAccessToken(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "customerUserErrors": {
                        List<CustomerUserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new CustomerUserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "userErrors": {
                        List<UserError> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new UserError(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerUpdatePayload";
        }

        /**
        * The updated customer object.
        */

        public Customer getCustomer() {
            return (Customer) get("customer");
        }

        public CustomerUpdatePayload setCustomer(Customer arg) {
            optimisticData.put(getKey("customer"), arg);
            return this;
        }

        /**
        * The newly created customer access token. If the customer's password is updated, all previous access
        * tokens
        * (including the one used to perform this mutation) become invalid, and a new token is generated.
        */

        public CustomerAccessToken getCustomerAccessToken() {
            return (CustomerAccessToken) get("customerAccessToken");
        }

        public CustomerUpdatePayload setCustomerAccessToken(CustomerAccessToken arg) {
            optimisticData.put(getKey("customerAccessToken"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        */

        public List<CustomerUserError> getCustomerUserErrors() {
            return (List<CustomerUserError>) get("customerUserErrors");
        }

        public CustomerUpdatePayload setCustomerUserErrors(List<CustomerUserError> arg) {
            optimisticData.put(getKey("customerUserErrors"), arg);
            return this;
        }

        /**
        * The list of errors that occurred from executing the mutation.
        *
        * @deprecated Use `customerUserErrors` instead.
        */

        public List<UserError> getUserErrors() {
            return (List<UserError>) get("userErrors");
        }

        public CustomerUpdatePayload setUserErrors(List<UserError> arg) {
            optimisticData.put(getKey("userErrors"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "customer": return true;

                case "customerAccessToken": return true;

                case "customerUserErrors": return true;

                case "userErrors": return true;

                default: return false;
            }
        }
    }

    public interface CustomerUserErrorQueryDefinition {
        void define(CustomerUserErrorQuery _queryBuilder);
    }

    /**
    * Represents an error that happens during execution of a customer mutation.
    */
    public static class CustomerUserErrorQuery extends Query<CustomerUserErrorQuery> {
        CustomerUserErrorQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The error code.
        */
        public CustomerUserErrorQuery code() {
            startField("code");

            return this;
        }

        /**
        * The path to the input field that caused the error.
        */
        public CustomerUserErrorQuery field() {
            startField("field");

            return this;
        }

        /**
        * The error message.
        */
        public CustomerUserErrorQuery message() {
            startField("message");

            return this;
        }
    }

    /**
    * Represents an error that happens during execution of a customer mutation.
    */
    public static class CustomerUserError extends AbstractResponse<CustomerUserError> implements DisplayableError {
        public CustomerUserError() {
        }

        public CustomerUserError(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "code": {
                        CustomerErrorCode optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = CustomerErrorCode.fromGraphQl(jsonAsString(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "field": {
                        List<String> optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            List<String> list1 = new ArrayList<>();
                            for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                                list1.add(jsonAsString(element1, key));
                            }

                            optional1 = list1;
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "message": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "CustomerUserError";
        }

        /**
        * The error code.
        */

        public CustomerErrorCode getCode() {
            return (CustomerErrorCode) get("code");
        }

        public CustomerUserError setCode(CustomerErrorCode arg) {
            optimisticData.put(getKey("code"), arg);
            return this;
        }

        /**
        * The path to the input field that caused the error.
        */

        public List<String> getField() {
            return (List<String>) get("field");
        }

        public CustomerUserError setField(List<String> arg) {
            optimisticData.put(getKey("field"), arg);
            return this;
        }

        /**
        * The error message.
        */

        public String getMessage() {
            return (String) get("message");
        }

        public CustomerUserError setMessage(String arg) {
            optimisticData.put(getKey("message"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "code": return false;

                case "field": return false;

                case "message": return false;

                default: return false;
            }
        }
    }

    public interface DeliveryAddressQueryDefinition {
        void define(DeliveryAddressQuery _queryBuilder);
    }

    /**
    * A delivery address of the buyer that is interacting with the cart.
    */
    public static class DeliveryAddressQuery extends Query<DeliveryAddressQuery> {
        DeliveryAddressQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("__typename");
        }

        public DeliveryAddressQuery onMailingAddress(MailingAddressQueryDefinition queryDef) {
            startInlineFragment("MailingAddress");
            queryDef.define(new MailingAddressQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }
    }

    public interface DeliveryAddress {
        String getGraphQlTypeName();
    }

    /**
    * A delivery address of the buyer that is interacting with the cart.
    */
    public static class UnknownDeliveryAddress extends AbstractResponse<UnknownDeliveryAddress> implements DeliveryAddress {
        public UnknownDeliveryAddress() {
        }

        public UnknownDeliveryAddress(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public static DeliveryAddress create(JsonObject fields) throws SchemaViolationError {
            String typeName = fields.getAsJsonPrimitive("__typename").getAsString();
            switch (typeName) {
                case "MailingAddress": {
                    return new MailingAddress(fields);
                }

                default: {
                    return new UnknownDeliveryAddress(fields);
                }
            }
        }

        public String getGraphQlTypeName() {
            return (String) get("__typename");
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                default: return false;
            }
        }
    }

    public static class DeliveryAddressInput implements Serializable {
        private Input<MailingAddressInput> deliveryAddress = Input.undefined();

        private Input<Boolean> oneTimeUse = Input.undefined();

        private Input<DeliveryAddressValidationStrategy> deliveryAddressValidationStrategy = Input.undefined();

        private Input<ID> customerAddressId = Input.undefined();

        public MailingAddressInput getDeliveryAddress() {
            return deliveryAddress.getValue();
        }

        public Input<MailingAddressInput> getDeliveryAddressInput() {
            return deliveryAddress;
        }

        public DeliveryAddressInput setDeliveryAddress(MailingAddressInput deliveryAddress) {
            this.deliveryAddress = Input.optional(deliveryAddress);
            return this;
        }

        public DeliveryAddressInput setDeliveryAddressInput(Input<MailingAddressInput> deliveryAddress) {
            if (deliveryAddress == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.deliveryAddress = deliveryAddress;
            return this;
        }

        public Boolean getOneTimeUse() {
            return oneTimeUse.getValue();
        }

        public Input<Boolean> getOneTimeUseInput() {
            return oneTimeUse;
        }

        public DeliveryAddressInput setOneTimeUse(Boolean oneTimeUse) {
            this.oneTimeUse = Input.optional(oneTimeUse);
            return this;
        }

        public DeliveryAddressInput setOneTimeUseInput(Input<Boolean> oneTimeUse) {
            if (oneTimeUse == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.oneTimeUse = oneTimeUse;
            return this;
        }

        public DeliveryAddressValidationStrategy getDeliveryAddressValidationStrategy() {
            return deliveryAddressValidationStrategy.getValue();
        }

        public Input<DeliveryAddressValidationStrategy> getDeliveryAddressValidationStrategyInput() {
            return deliveryAddressValidationStrategy;
        }

        public DeliveryAddressInput setDeliveryAddressValidationStrategy(DeliveryAddressValidationStrategy deliveryAddressValidationStrategy) {
            this.deliveryAddressValidationStrategy = Input.optional(deliveryAddressValidationStrategy);
            return this;
        }

        public DeliveryAddressInput setDeliveryAddressValidationStrategyInput(Input<DeliveryAddressValidationStrategy> deliveryAddressValidationStrategy) {
            if (deliveryAddressValidationStrategy == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.deliveryAddressValidationStrategy = deliveryAddressValidationStrategy;
            return this;
        }

        public ID getCustomerAddressId() {
            return customerAddressId.getValue();
        }

        public Input<ID> getCustomerAddressIdInput() {
            return customerAddressId;
        }

        public DeliveryAddressInput setCustomerAddressId(ID customerAddressId) {
            this.customerAddressId = Input.optional(customerAddressId);
            return this;
        }

        public DeliveryAddressInput setCustomerAddressIdInput(Input<ID> customerAddressId) {
            if (customerAddressId == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.customerAddressId = customerAddressId;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            if (this.deliveryAddress.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("deliveryAddress:");
                if (deliveryAddress.getValue() != null) {
                    deliveryAddress.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.oneTimeUse.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("oneTimeUse:");
                if (oneTimeUse.getValue() != null) {
                    _queryBuilder.append(oneTimeUse.getValue());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.deliveryAddressValidationStrategy.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("deliveryAddressValidationStrategy:");
                if (deliveryAddressValidationStrategy.getValue() != null) {
                    _queryBuilder.append(deliveryAddressValidationStrategy.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.customerAddressId.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("customerAddressId:");
                if (customerAddressId.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, customerAddressId.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    /**
    * Defines the types of available validation strategies for delivery addresses.
    */
    public enum DeliveryAddressValidationStrategy {
        /**
        * Only the country code is validated.
        */
        COUNTRY_CODE_ONLY,

        /**
        * Strict validation is performed, i.e. all fields in the address are validated
        * according to Shopify's checkout rules. If the address fails validation, the cart will not be
        * updated.
        */
        STRICT,

        UNKNOWN_VALUE;

        public static DeliveryAddressValidationStrategy fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "COUNTRY_CODE_ONLY": {
                    return COUNTRY_CODE_ONLY;
                }

                case "STRICT": {
                    return STRICT;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case COUNTRY_CODE_ONLY: {
                    return "COUNTRY_CODE_ONLY";
                }

                case STRICT: {
                    return "STRICT";
                }

                default: {
                    return "";
                }
            }
        }
    }

    /**
    * List of different delivery method types.
    */
    public enum DeliveryMethodType {
        /**
        * Local Delivery.
        */
        LOCAL,

        /**
        * None.
        */
        NONE,

        /**
        * Shipping to a Pickup Point.
        */
        PICKUP_POINT,

        /**
        * Local Pickup.
        */
        PICK_UP,

        /**
        * Retail.
        */
        RETAIL,

        /**
        * Shipping.
        */
        SHIPPING,

        UNKNOWN_VALUE;

        public static DeliveryMethodType fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "LOCAL": {
                    return LOCAL;
                }

                case "NONE": {
                    return NONE;
                }

                case "PICKUP_POINT": {
                    return PICKUP_POINT;
                }

                case "PICK_UP": {
                    return PICK_UP;
                }

                case "RETAIL": {
                    return RETAIL;
                }

                case "SHIPPING": {
                    return SHIPPING;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case LOCAL: {
                    return "LOCAL";
                }

                case NONE: {
                    return "NONE";
                }

                case PICKUP_POINT: {
                    return "PICKUP_POINT";
                }

                case PICK_UP: {
                    return "PICK_UP";
                }

                case RETAIL: {
                    return "RETAIL";
                }

                case SHIPPING: {
                    return "SHIPPING";
                }

                default: {
                    return "";
                }
            }
        }
    }

    /**
    * Digital wallet, such as Apple Pay, which can be used for accelerated checkouts.
    */
    public enum DigitalWallet {
        /**
        * Android Pay.
        */
        ANDROID_PAY,

        /**
        * Apple Pay.
        */
        APPLE_PAY,

        /**
        * Google Pay.
        */
        GOOGLE_PAY,

        /**
        * Shopify Pay.
        */
        SHOPIFY_PAY,

        UNKNOWN_VALUE;

        public static DigitalWallet fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "ANDROID_PAY": {
                    return ANDROID_PAY;
                }

                case "APPLE_PAY": {
                    return APPLE_PAY;
                }

                case "GOOGLE_PAY": {
                    return GOOGLE_PAY;
                }

                case "SHOPIFY_PAY": {
                    return SHOPIFY_PAY;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case ANDROID_PAY: {
                    return "ANDROID_PAY";
                }

                case APPLE_PAY: {
                    return "APPLE_PAY";
                }

                case GOOGLE_PAY: {
                    return "GOOGLE_PAY";
                }

                case SHOPIFY_PAY: {
                    return "SHOPIFY_PAY";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface DiscountAllocationQueryDefinition {
        void define(DiscountAllocationQuery _queryBuilder);
    }

    /**
    * An amount discounting the line that has been allocated by a discount.
    */
    public static class DiscountAllocationQuery extends Query<DiscountAllocationQuery> {
        DiscountAllocationQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * Amount of discount allocated.
        */
        public DiscountAllocationQuery allocatedAmount(MoneyV2QueryDefinition queryDef) {
            startField("allocatedAmount");

            _queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The discount this allocated amount originated from.
        */
        public DiscountAllocationQuery discountApplication(DiscountApplicationQueryDefinition queryDef) {
            startField("discountApplication");

            _queryBuilder.append('{');
            queryDef.define(new DiscountApplicationQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An amount discounting the line that has been allocated by a discount.
    */
    public static class DiscountAllocation extends AbstractResponse<DiscountAllocation> {
        public DiscountAllocation() {
        }

        public DiscountAllocation(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "allocatedAmount": {
                        responseData.put(key, new MoneyV2(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "discountApplication": {
                        responseData.put(key, UnknownDiscountApplication.create(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "DiscountAllocation";
        }

        /**
        * Amount of discount allocated.
        */

        public MoneyV2 getAllocatedAmount() {
            return (MoneyV2) get("allocatedAmount");
        }

        public DiscountAllocation setAllocatedAmount(MoneyV2 arg) {
            optimisticData.put(getKey("allocatedAmount"), arg);
            return this;
        }

        /**
        * The discount this allocated amount originated from.
        */

        public DiscountApplication getDiscountApplication() {
            return (DiscountApplication) get("discountApplication");
        }

        public DiscountAllocation setDiscountApplication(DiscountApplication arg) {
            optimisticData.put(getKey("discountApplication"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "allocatedAmount": return true;

                case "discountApplication": return false;

                default: return false;
            }
        }
    }

    public interface DiscountApplicationQueryDefinition {
        void define(DiscountApplicationQuery _queryBuilder);
    }

    /**
    * Discount applications capture the intentions of a discount source at
    * the time of application.
    */
    public static class DiscountApplicationQuery extends Query<DiscountApplicationQuery> {
        DiscountApplicationQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("__typename");
        }

        /**
        * The method by which the discount's value is allocated to its entitled items.
        */
        public DiscountApplicationQuery allocationMethod() {
            startField("allocationMethod");

            return this;
        }

        /**
        * Which lines of targetType that the discount is allocated over.
        */
        public DiscountApplicationQuery targetSelection() {
            startField("targetSelection");

            return this;
        }

        /**
        * The type of line that the discount is applicable towards.
        */
        public DiscountApplicationQuery targetType() {
            startField("targetType");

            return this;
        }

        /**
        * The value of the discount application.
        */
        public DiscountApplicationQuery value(PricingValueQueryDefinition queryDef) {
            startField("value");

            _queryBuilder.append('{');
            queryDef.define(new PricingValueQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        public DiscountApplicationQuery onAutomaticDiscountApplication(AutomaticDiscountApplicationQueryDefinition queryDef) {
            startInlineFragment("AutomaticDiscountApplication");
            queryDef.define(new AutomaticDiscountApplicationQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public DiscountApplicationQuery onDiscountCodeApplication(DiscountCodeApplicationQueryDefinition queryDef) {
            startInlineFragment("DiscountCodeApplication");
            queryDef.define(new DiscountCodeApplicationQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public DiscountApplicationQuery onManualDiscountApplication(ManualDiscountApplicationQueryDefinition queryDef) {
            startInlineFragment("ManualDiscountApplication");
            queryDef.define(new ManualDiscountApplicationQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public DiscountApplicationQuery onScriptDiscountApplication(ScriptDiscountApplicationQueryDefinition queryDef) {
            startInlineFragment("ScriptDiscountApplication");
            queryDef.define(new ScriptDiscountApplicationQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }
    }

    public interface DiscountApplication {
        String getGraphQlTypeName();

        DiscountApplicationAllocationMethod getAllocationMethod();

        DiscountApplicationTargetSelection getTargetSelection();

        DiscountApplicationTargetType getTargetType();

        PricingValue getValue();
    }

    /**
    * Discount applications capture the intentions of a discount source at
    * the time of application.
    */
    public static class UnknownDiscountApplication extends AbstractResponse<UnknownDiscountApplication> implements DiscountApplication {
        public UnknownDiscountApplication() {
        }

        public UnknownDiscountApplication(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "allocationMethod": {
                        responseData.put(key, DiscountApplicationAllocationMethod.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "targetSelection": {
                        responseData.put(key, DiscountApplicationTargetSelection.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "targetType": {
                        responseData.put(key, DiscountApplicationTargetType.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "value": {
                        responseData.put(key, UnknownPricingValue.create(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public static DiscountApplication create(JsonObject fields) throws SchemaViolationError {
            String typeName = fields.getAsJsonPrimitive("__typename").getAsString();
            switch (typeName) {
                case "AutomaticDiscountApplication": {
                    return new AutomaticDiscountApplication(fields);
                }

                case "DiscountCodeApplication": {
                    return new DiscountCodeApplication(fields);
                }

                case "ManualDiscountApplication": {
                    return new ManualDiscountApplication(fields);
                }

                case "ScriptDiscountApplication": {
                    return new ScriptDiscountApplication(fields);
                }

                default: {
                    return new UnknownDiscountApplication(fields);
                }
            }
        }

        public String getGraphQlTypeName() {
            return (String) get("__typename");
        }

        /**
        * The method by which the discount's value is allocated to its entitled items.
        */

        public DiscountApplicationAllocationMethod getAllocationMethod() {
            return (DiscountApplicationAllocationMethod) get("allocationMethod");
        }

        public UnknownDiscountApplication setAllocationMethod(DiscountApplicationAllocationMethod arg) {
            optimisticData.put(getKey("allocationMethod"), arg);
            return this;
        }

        /**
        * Which lines of targetType that the discount is allocated over.
        */

        public DiscountApplicationTargetSelection getTargetSelection() {
            return (DiscountApplicationTargetSelection) get("targetSelection");
        }

        public UnknownDiscountApplication setTargetSelection(DiscountApplicationTargetSelection arg) {
            optimisticData.put(getKey("targetSelection"), arg);
            return this;
        }

        /**
        * The type of line that the discount is applicable towards.
        */

        public DiscountApplicationTargetType getTargetType() {
            return (DiscountApplicationTargetType) get("targetType");
        }

        public UnknownDiscountApplication setTargetType(DiscountApplicationTargetType arg) {
            optimisticData.put(getKey("targetType"), arg);
            return this;
        }

        /**
        * The value of the discount application.
        */

        public PricingValue getValue() {
            return (PricingValue) get("value");
        }

        public UnknownDiscountApplication setValue(PricingValue arg) {
            optimisticData.put(getKey("value"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "allocationMethod": return false;

                case "targetSelection": return false;

                case "targetType": return false;

                case "value": return false;

                default: return false;
            }
        }
    }

    /**
    * The method by which the discount's value is allocated onto its entitled lines.
    */
    public enum DiscountApplicationAllocationMethod {
        /**
        * The value is spread across all entitled lines.
        */
        ACROSS,

        /**
        * The value is applied onto every entitled line.
        */
        EACH,

        /**
        * The value is specifically applied onto a particular line.
        *
        * @deprecated Use ACROSS instead.
        */
        @Deprecated
        ONE,

        UNKNOWN_VALUE;

        public static DiscountApplicationAllocationMethod fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "ACROSS": {
                    return ACROSS;
                }

                case "EACH": {
                    return EACH;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case ACROSS: {
                    return "ACROSS";
                }

                case EACH: {
                    return "EACH";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface DiscountApplicationConnectionQueryDefinition {
        void define(DiscountApplicationConnectionQuery _queryBuilder);
    }

    /**
    * An auto-generated type for paginating through multiple DiscountApplications.
    */
    public static class DiscountApplicationConnectionQuery extends Query<DiscountApplicationConnectionQuery> {
        DiscountApplicationConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A list of edges.
        */
        public DiscountApplicationConnectionQuery edges(DiscountApplicationEdgeQueryDefinition queryDef) {
            startField("edges");

            _queryBuilder.append('{');
            queryDef.define(new DiscountApplicationEdgeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A list of the nodes contained in DiscountApplicationEdge.
        */
        public DiscountApplicationConnectionQuery nodes(DiscountApplicationQueryDefinition queryDef) {
            startField("nodes");

            _queryBuilder.append('{');
            queryDef.define(new DiscountApplicationQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * Information to aid in pagination.
        */
        public DiscountApplicationConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            startField("pageInfo");

            _queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type for paginating through multiple DiscountApplications.
    */
    public static class DiscountApplicationConnection extends AbstractResponse<DiscountApplicationConnection> {
        public DiscountApplicationConnection() {
        }

        public DiscountApplicationConnection(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "edges": {
                        List<DiscountApplicationEdge> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new DiscountApplicationEdge(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "nodes": {
                        List<DiscountApplication> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(UnknownDiscountApplication.create(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "pageInfo": {
                        responseData.put(key, new PageInfo(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "DiscountApplicationConnection";
        }

        /**
        * A list of edges.
        */

        public List<DiscountApplicationEdge> getEdges() {
            return (List<DiscountApplicationEdge>) get("edges");
        }

        public DiscountApplicationConnection setEdges(List<DiscountApplicationEdge> arg) {
            optimisticData.put(getKey("edges"), arg);
            return this;
        }

        /**
        * A list of the nodes contained in DiscountApplicationEdge.
        */

        public List<DiscountApplication> getNodes() {
            return (List<DiscountApplication>) get("nodes");
        }

        public DiscountApplicationConnection setNodes(List<DiscountApplication> arg) {
            optimisticData.put(getKey("nodes"), arg);
            return this;
        }

        /**
        * Information to aid in pagination.
        */

        public PageInfo getPageInfo() {
            return (PageInfo) get("pageInfo");
        }

        public DiscountApplicationConnection setPageInfo(PageInfo arg) {
            optimisticData.put(getKey("pageInfo"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "edges": return true;

                case "nodes": return false;

                case "pageInfo": return true;

                default: return false;
            }
        }
    }

    public interface DiscountApplicationEdgeQueryDefinition {
        void define(DiscountApplicationEdgeQuery _queryBuilder);
    }

    /**
    * An auto-generated type which holds one DiscountApplication and a cursor during pagination.
    */
    public static class DiscountApplicationEdgeQuery extends Query<DiscountApplicationEdgeQuery> {
        DiscountApplicationEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A cursor for use in pagination.
        */
        public DiscountApplicationEdgeQuery cursor() {
            startField("cursor");

            return this;
        }

        /**
        * The item at the end of DiscountApplicationEdge.
        */
        public DiscountApplicationEdgeQuery node(DiscountApplicationQueryDefinition queryDef) {
            startField("node");

            _queryBuilder.append('{');
            queryDef.define(new DiscountApplicationQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type which holds one DiscountApplication and a cursor during pagination.
    */
    public static class DiscountApplicationEdge extends AbstractResponse<DiscountApplicationEdge> {
        public DiscountApplicationEdge() {
        }

        public DiscountApplicationEdge(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cursor": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "node": {
                        responseData.put(key, UnknownDiscountApplication.create(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "DiscountApplicationEdge";
        }

        /**
        * A cursor for use in pagination.
        */

        public String getCursor() {
            return (String) get("cursor");
        }

        public DiscountApplicationEdge setCursor(String arg) {
            optimisticData.put(getKey("cursor"), arg);
            return this;
        }

        /**
        * The item at the end of DiscountApplicationEdge.
        */

        public DiscountApplication getNode() {
            return (DiscountApplication) get("node");
        }

        public DiscountApplicationEdge setNode(DiscountApplication arg) {
            optimisticData.put(getKey("node"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cursor": return false;

                case "node": return false;

                default: return false;
            }
        }
    }

    /**
    * The lines on the order to which the discount is applied, of the type defined by
    * the discount application's `targetType`. For example, the value `ENTITLED`, combined with a
    * `targetType` of
    * `LINE_ITEM`, applies the discount on all line items that are entitled to the discount.
    * The value `ALL`, combined with a `targetType` of `SHIPPING_LINE`, applies the discount on all
    * shipping lines.
    */
    public enum DiscountApplicationTargetSelection {
        /**
        * The discount is allocated onto all the lines.
        */
        ALL,

        /**
        * The discount is allocated onto only the lines that it's entitled for.
        */
        ENTITLED,

        /**
        * The discount is allocated onto explicitly chosen lines.
        */
        EXPLICIT,

        UNKNOWN_VALUE;

        public static DiscountApplicationTargetSelection fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "ALL": {
                    return ALL;
                }

                case "ENTITLED": {
                    return ENTITLED;
                }

                case "EXPLICIT": {
                    return EXPLICIT;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case ALL: {
                    return "ALL";
                }

                case ENTITLED: {
                    return "ENTITLED";
                }

                case EXPLICIT: {
                    return "EXPLICIT";
                }

                default: {
                    return "";
                }
            }
        }
    }

    /**
    * The type of line (i.e. line item or shipping line) on an order that the discount is applicable
    * towards.
    */
    public enum DiscountApplicationTargetType {
        /**
        * The discount applies onto line items.
        */
        LINE_ITEM,

        /**
        * The discount applies onto shipping lines.
        */
        SHIPPING_LINE,

        UNKNOWN_VALUE;

        public static DiscountApplicationTargetType fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "LINE_ITEM": {
                    return LINE_ITEM;
                }

                case "SHIPPING_LINE": {
                    return SHIPPING_LINE;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case LINE_ITEM: {
                    return "LINE_ITEM";
                }

                case SHIPPING_LINE: {
                    return "SHIPPING_LINE";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface DiscountCodeApplicationQueryDefinition {
        void define(DiscountCodeApplicationQuery _queryBuilder);
    }

    /**
    * Discount code applications capture the intentions of a discount code at
    * the time that it is applied.
    */
    public static class DiscountCodeApplicationQuery extends Query<DiscountCodeApplicationQuery> {
        DiscountCodeApplicationQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The method by which the discount's value is allocated to its entitled items.
        */
        public DiscountCodeApplicationQuery allocationMethod() {
            startField("allocationMethod");

            return this;
        }

        /**
        * Specifies whether the discount code was applied successfully.
        */
        public DiscountCodeApplicationQuery applicable() {
            startField("applicable");

            return this;
        }

        /**
        * The string identifying the discount code that was used at the time of application.
        */
        public DiscountCodeApplicationQuery code() {
            startField("code");

            return this;
        }

        /**
        * Which lines of targetType that the discount is allocated over.
        */
        public DiscountCodeApplicationQuery targetSelection() {
            startField("targetSelection");

            return this;
        }

        /**
        * The type of line that the discount is applicable towards.
        */
        public DiscountCodeApplicationQuery targetType() {
            startField("targetType");

            return this;
        }

        /**
        * The value of the discount application.
        */
        public DiscountCodeApplicationQuery value(PricingValueQueryDefinition queryDef) {
            startField("value");

            _queryBuilder.append('{');
            queryDef.define(new PricingValueQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Discount code applications capture the intentions of a discount code at
    * the time that it is applied.
    */
    public static class DiscountCodeApplication extends AbstractResponse<DiscountCodeApplication> implements DiscountApplication {
        public DiscountCodeApplication() {
        }

        public DiscountCodeApplication(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "allocationMethod": {
                        responseData.put(key, DiscountApplicationAllocationMethod.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "applicable": {
                        responseData.put(key, jsonAsBoolean(field.getValue(), key));

                        break;
                    }

                    case "code": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "targetSelection": {
                        responseData.put(key, DiscountApplicationTargetSelection.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "targetType": {
                        responseData.put(key, DiscountApplicationTargetType.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "value": {
                        responseData.put(key, UnknownPricingValue.create(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "DiscountCodeApplication";
        }

        /**
        * The method by which the discount's value is allocated to its entitled items.
        */

        public DiscountApplicationAllocationMethod getAllocationMethod() {
            return (DiscountApplicationAllocationMethod) get("allocationMethod");
        }

        public DiscountCodeApplication setAllocationMethod(DiscountApplicationAllocationMethod arg) {
            optimisticData.put(getKey("allocationMethod"), arg);
            return this;
        }

        /**
        * Specifies whether the discount code was applied successfully.
        */

        public Boolean getApplicable() {
            return (Boolean) get("applicable");
        }

        public DiscountCodeApplication setApplicable(Boolean arg) {
            optimisticData.put(getKey("applicable"), arg);
            return this;
        }

        /**
        * The string identifying the discount code that was used at the time of application.
        */

        public String getCode() {
            return (String) get("code");
        }

        public DiscountCodeApplication setCode(String arg) {
            optimisticData.put(getKey("code"), arg);
            return this;
        }

        /**
        * Which lines of targetType that the discount is allocated over.
        */

        public DiscountApplicationTargetSelection getTargetSelection() {
            return (DiscountApplicationTargetSelection) get("targetSelection");
        }

        public DiscountCodeApplication setTargetSelection(DiscountApplicationTargetSelection arg) {
            optimisticData.put(getKey("targetSelection"), arg);
            return this;
        }

        /**
        * The type of line that the discount is applicable towards.
        */

        public DiscountApplicationTargetType getTargetType() {
            return (DiscountApplicationTargetType) get("targetType");
        }

        public DiscountCodeApplication setTargetType(DiscountApplicationTargetType arg) {
            optimisticData.put(getKey("targetType"), arg);
            return this;
        }

        /**
        * The value of the discount application.
        */

        public PricingValue getValue() {
            return (PricingValue) get("value");
        }

        public DiscountCodeApplication setValue(PricingValue arg) {
            optimisticData.put(getKey("value"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "allocationMethod": return false;

                case "applicable": return false;

                case "code": return false;

                case "targetSelection": return false;

                case "targetType": return false;

                case "value": return false;

                default: return false;
            }
        }
    }

    public interface DisplayableErrorQueryDefinition {
        void define(DisplayableErrorQuery _queryBuilder);
    }

    /**
    * Represents an error in the input of a mutation.
    */
    public static class DisplayableErrorQuery extends Query<DisplayableErrorQuery> {
        DisplayableErrorQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("__typename");
        }

        /**
        * The path to the input field that caused the error.
        */
        public DisplayableErrorQuery field() {
            startField("field");

            return this;
        }

        /**
        * The error message.
        */
        public DisplayableErrorQuery message() {
            startField("message");

            return this;
        }

        public DisplayableErrorQuery onCartUserError(CartUserErrorQueryDefinition queryDef) {
            startInlineFragment("CartUserError");
            queryDef.define(new CartUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public DisplayableErrorQuery onCustomerUserError(CustomerUserErrorQueryDefinition queryDef) {
            startInlineFragment("CustomerUserError");
            queryDef.define(new CustomerUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public DisplayableErrorQuery onMetafieldDeleteUserError(MetafieldDeleteUserErrorQueryDefinition queryDef) {
            startInlineFragment("MetafieldDeleteUserError");
            queryDef.define(new MetafieldDeleteUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public DisplayableErrorQuery onMetafieldsSetUserError(MetafieldsSetUserErrorQueryDefinition queryDef) {
            startInlineFragment("MetafieldsSetUserError");
            queryDef.define(new MetafieldsSetUserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public DisplayableErrorQuery onUserError(UserErrorQueryDefinition queryDef) {
            startInlineFragment("UserError");
            queryDef.define(new UserErrorQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public DisplayableErrorQuery onUserErrorsShopPayPaymentRequestSessionUserErrors(UserErrorsShopPayPaymentRequestSessionUserErrorsQueryDefinition queryDef) {
            startInlineFragment("UserErrorsShopPayPaymentRequestSessionUserErrors");
            queryDef.define(new UserErrorsShopPayPaymentRequestSessionUserErrorsQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }
    }

    public interface DisplayableError {
        String getGraphQlTypeName();

        List<String> getField();

        String getMessage();
    }

    /**
    * Represents an error in the input of a mutation.
    */
    public static class UnknownDisplayableError extends AbstractResponse<UnknownDisplayableError> implements DisplayableError {
        public UnknownDisplayableError() {
        }

        public UnknownDisplayableError(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "field": {
                        List<String> optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            List<String> list1 = new ArrayList<>();
                            for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                                list1.add(jsonAsString(element1, key));
                            }

                            optional1 = list1;
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "message": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public static DisplayableError create(JsonObject fields) throws SchemaViolationError {
            String typeName = fields.getAsJsonPrimitive("__typename").getAsString();
            switch (typeName) {
                case "CartUserError": {
                    return new CartUserError(fields);
                }

                case "CustomerUserError": {
                    return new CustomerUserError(fields);
                }

                case "MetafieldDeleteUserError": {
                    return new MetafieldDeleteUserError(fields);
                }

                case "MetafieldsSetUserError": {
                    return new MetafieldsSetUserError(fields);
                }

                case "UserError": {
                    return new UserError(fields);
                }

                case "UserErrorsShopPayPaymentRequestSessionUserErrors": {
                    return new UserErrorsShopPayPaymentRequestSessionUserErrors(fields);
                }

                default: {
                    return new UnknownDisplayableError(fields);
                }
            }
        }

        public String getGraphQlTypeName() {
            return (String) get("__typename");
        }

        /**
        * The path to the input field that caused the error.
        */

        public List<String> getField() {
            return (List<String>) get("field");
        }

        public UnknownDisplayableError setField(List<String> arg) {
            optimisticData.put(getKey("field"), arg);
            return this;
        }

        /**
        * The error message.
        */

        public String getMessage() {
            return (String) get("message");
        }

        public UnknownDisplayableError setMessage(String arg) {
            optimisticData.put(getKey("message"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "field": return false;

                case "message": return false;

                default: return false;
            }
        }
    }

    public interface DomainQueryDefinition {
        void define(DomainQuery _queryBuilder);
    }

    /**
    * Represents a web address.
    */
    public static class DomainQuery extends Query<DomainQuery> {
        DomainQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The host name of the domain (eg: `example.com`).
        */
        public DomainQuery host() {
            startField("host");

            return this;
        }

        /**
        * Whether SSL is enabled or not.
        */
        public DomainQuery sslEnabled() {
            startField("sslEnabled");

            return this;
        }

        /**
        * The URL of the domain (eg: `https://example.com`).
        */
        public DomainQuery url() {
            startField("url");

            return this;
        }
    }

    /**
    * Represents a web address.
    */
    public static class Domain extends AbstractResponse<Domain> {
        public Domain() {
        }

        public Domain(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "host": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "sslEnabled": {
                        responseData.put(key, jsonAsBoolean(field.getValue(), key));

                        break;
                    }

                    case "url": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "Domain";
        }

        /**
        * The host name of the domain (eg: `example.com`).
        */

        public String getHost() {
            return (String) get("host");
        }

        public Domain setHost(String arg) {
            optimisticData.put(getKey("host"), arg);
            return this;
        }

        /**
        * Whether SSL is enabled or not.
        */

        public Boolean getSslEnabled() {
            return (Boolean) get("sslEnabled");
        }

        public Domain setSslEnabled(Boolean arg) {
            optimisticData.put(getKey("sslEnabled"), arg);
            return this;
        }

        /**
        * The URL of the domain (eg: `https://example.com`).
        */

        public String getUrl() {
            return (String) get("url");
        }

        public Domain setUrl(String arg) {
            optimisticData.put(getKey("url"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "host": return false;

                case "sslEnabled": return false;

                case "url": return false;

                default: return false;
            }
        }
    }

    public interface ExternalVideoQueryDefinition {
        void define(ExternalVideoQuery _queryBuilder);
    }

    /**
    * Represents a video hosted outside of Shopify.
    */
    public static class ExternalVideoQuery extends Query<ExternalVideoQuery> {
        ExternalVideoQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("id");
        }

        /**
        * A word or phrase to share the nature or contents of a media.
        */
        public ExternalVideoQuery alt() {
            startField("alt");

            return this;
        }

        /**
        * The embed URL of the video for the respective host.
        */
        public ExternalVideoQuery embedUrl() {
            startField("embedUrl");

            return this;
        }

        /**
        * The URL.
        *
        * @deprecated Use `originUrl` instead.
        */
        @Deprecated
        public ExternalVideoQuery embeddedUrl() {
            startField("embeddedUrl");

            return this;
        }

        /**
        * The host of the external video.
        */
        public ExternalVideoQuery host() {
            startField("host");

            return this;
        }

        /**
        * The media content type.
        */
        public ExternalVideoQuery mediaContentType() {
            startField("mediaContentType");

            return this;
        }

        /**
        * The origin URL of the video on the respective host.
        */
        public ExternalVideoQuery originUrl() {
            startField("originUrl");

            return this;
        }

        /**
        * The presentation for a media.
        */
        public ExternalVideoQuery presentation(MediaPresentationQueryDefinition queryDef) {
            startField("presentation");

            _queryBuilder.append('{');
            queryDef.define(new MediaPresentationQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The preview image for the media.
        */
        public ExternalVideoQuery previewImage(ImageQueryDefinition queryDef) {
            startField("previewImage");

            _queryBuilder.append('{');
            queryDef.define(new ImageQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Represents a video hosted outside of Shopify.
    */
    public static class ExternalVideo extends AbstractResponse<ExternalVideo> implements Media, Node {
        public ExternalVideo() {
        }

        public ExternalVideo(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "alt": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "embedUrl": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "embeddedUrl": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "host": {
                        responseData.put(key, MediaHost.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "mediaContentType": {
                        responseData.put(key, MediaContentType.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "originUrl": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "presentation": {
                        MediaPresentation optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new MediaPresentation(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "previewImage": {
                        Image optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Image(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public ExternalVideo(ID id) {
            this();
            optimisticData.put("id", id);
        }

        public String getGraphQlTypeName() {
            return "ExternalVideo";
        }

        /**
        * A word or phrase to share the nature or contents of a media.
        */

        public String getAlt() {
            return (String) get("alt");
        }

        public ExternalVideo setAlt(String arg) {
            optimisticData.put(getKey("alt"), arg);
            return this;
        }

        /**
        * The embed URL of the video for the respective host.
        */

        public String getEmbedUrl() {
            return (String) get("embedUrl");
        }

        public ExternalVideo setEmbedUrl(String arg) {
            optimisticData.put(getKey("embedUrl"), arg);
            return this;
        }

        /**
        * The URL.
        *
        * @deprecated Use `originUrl` instead.
        */

        public String getEmbeddedUrl() {
            return (String) get("embeddedUrl");
        }

        public ExternalVideo setEmbeddedUrl(String arg) {
            optimisticData.put(getKey("embeddedUrl"), arg);
            return this;
        }

        /**
        * The host of the external video.
        */

        public MediaHost getHost() {
            return (MediaHost) get("host");
        }

        public ExternalVideo setHost(MediaHost arg) {
            optimisticData.put(getKey("host"), arg);
            return this;
        }

        /**
        * A globally-unique ID.
        */

        public ID getId() {
            return (ID) get("id");
        }

        /**
        * The media content type.
        */

        public MediaContentType getMediaContentType() {
            return (MediaContentType) get("mediaContentType");
        }

        public ExternalVideo setMediaContentType(MediaContentType arg) {
            optimisticData.put(getKey("mediaContentType"), arg);
            return this;
        }

        /**
        * The origin URL of the video on the respective host.
        */

        public String getOriginUrl() {
            return (String) get("originUrl");
        }

        public ExternalVideo setOriginUrl(String arg) {
            optimisticData.put(getKey("originUrl"), arg);
            return this;
        }

        /**
        * The presentation for a media.
        */

        public MediaPresentation getPresentation() {
            return (MediaPresentation) get("presentation");
        }

        public ExternalVideo setPresentation(MediaPresentation arg) {
            optimisticData.put(getKey("presentation"), arg);
            return this;
        }

        /**
        * The preview image for the media.
        */

        public Image getPreviewImage() {
            return (Image) get("previewImage");
        }

        public ExternalVideo setPreviewImage(Image arg) {
            optimisticData.put(getKey("previewImage"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "alt": return false;

                case "embedUrl": return false;

                case "embeddedUrl": return false;

                case "host": return false;

                case "id": return false;

                case "mediaContentType": return false;

                case "originUrl": return false;

                case "presentation": return true;

                case "previewImage": return true;

                default: return false;
            }
        }
    }

    public interface FilterQueryDefinition {
        void define(FilterQuery _queryBuilder);
    }

    /**
    * A filter that is supported on the parent field.
    */
    public static class FilterQuery extends Query<FilterQuery> {
        FilterQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A unique identifier.
        */
        public FilterQuery id() {
            startField("id");

            return this;
        }

        /**
        * A human-friendly string for this filter.
        */
        public FilterQuery label() {
            startField("label");

            return this;
        }

        /**
        * Describes how to present the filter values.
        * Returns a value only for filters of type `LIST`. Returns null for other types.
        */
        public FilterQuery presentation() {
            startField("presentation");

            return this;
        }

        /**
        * An enumeration that denotes the type of data this filter represents.
        */
        public FilterQuery type() {
            startField("type");

            return this;
        }

        /**
        * The list of values for this filter.
        */
        public FilterQuery values(FilterValueQueryDefinition queryDef) {
            startField("values");

            _queryBuilder.append('{');
            queryDef.define(new FilterValueQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * A filter that is supported on the parent field.
    */
    public static class Filter extends AbstractResponse<Filter> {
        public Filter() {
        }

        public Filter(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "id": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "label": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "presentation": {
                        FilterPresentation optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = FilterPresentation.fromGraphQl(jsonAsString(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "type": {
                        responseData.put(key, FilterType.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "values": {
                        List<FilterValue> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new FilterValue(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "Filter";
        }

        /**
        * A unique identifier.
        */

        public String getId() {
            return (String) get("id");
        }

        public Filter setId(String arg) {
            optimisticData.put(getKey("id"), arg);
            return this;
        }

        /**
        * A human-friendly string for this filter.
        */

        public String getLabel() {
            return (String) get("label");
        }

        public Filter setLabel(String arg) {
            optimisticData.put(getKey("label"), arg);
            return this;
        }

        /**
        * Describes how to present the filter values.
        * Returns a value only for filters of type `LIST`. Returns null for other types.
        */

        public FilterPresentation getPresentation() {
            return (FilterPresentation) get("presentation");
        }

        public Filter setPresentation(FilterPresentation arg) {
            optimisticData.put(getKey("presentation"), arg);
            return this;
        }

        /**
        * An enumeration that denotes the type of data this filter represents.
        */

        public FilterType getType() {
            return (FilterType) get("type");
        }

        public Filter setType(FilterType arg) {
            optimisticData.put(getKey("type"), arg);
            return this;
        }

        /**
        * The list of values for this filter.
        */

        public List<FilterValue> getValues() {
            return (List<FilterValue>) get("values");
        }

        public Filter setValues(List<FilterValue> arg) {
            optimisticData.put(getKey("values"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "id": return false;

                case "label": return false;

                case "presentation": return false;

                case "type": return false;

                case "values": return true;

                default: return false;
            }
        }
    }

    /**
    * Defines how to present the filter values, specifies the presentation of the filter.
    */
    public enum FilterPresentation {
        /**
        * Image presentation, filter values display an image.
        */
        IMAGE,

        /**
        * Swatch presentation, filter values display color or image patterns.
        */
        SWATCH,

        /**
        * Text presentation, no additional visual display for filter values.
        */
        TEXT,

        UNKNOWN_VALUE;

        public static FilterPresentation fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "IMAGE": {
                    return IMAGE;
                }

                case "SWATCH": {
                    return SWATCH;
                }

                case "TEXT": {
                    return TEXT;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case IMAGE: {
                    return "IMAGE";
                }

                case SWATCH: {
                    return "SWATCH";
                }

                case TEXT: {
                    return "TEXT";
                }

                default: {
                    return "";
                }
            }
        }
    }

    /**
    * The type of data that the filter group represents.
    * For more information, refer to [Filter products in a collection with the Storefront API]
    * (https://shopify.dev/custom-storefronts/products-collections/filter-products).
    */
    public enum FilterType {
        /**
        * A boolean value.
        */
        BOOLEAN,

        /**
        * A list of selectable values.
        */
        LIST,

        /**
        * A range of prices.
        */
        PRICE_RANGE,

        UNKNOWN_VALUE;

        public static FilterType fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "BOOLEAN": {
                    return BOOLEAN;
                }

                case "LIST": {
                    return LIST;
                }

                case "PRICE_RANGE": {
                    return PRICE_RANGE;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case BOOLEAN: {
                    return "BOOLEAN";
                }

                case LIST: {
                    return "LIST";
                }

                case PRICE_RANGE: {
                    return "PRICE_RANGE";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface FilterValueQueryDefinition {
        void define(FilterValueQuery _queryBuilder);
    }

    /**
    * A selectable value within a filter.
    */
    public static class FilterValueQuery extends Query<FilterValueQuery> {
        FilterValueQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The number of results that match this filter value.
        */
        public FilterValueQuery count() {
            startField("count");

            return this;
        }

        /**
        * A unique identifier.
        */
        public FilterValueQuery id() {
            startField("id");

            return this;
        }

        /**
        * The visual representation when the filter's presentation is `IMAGE`.
        */
        public FilterValueQuery image(MediaImageQueryDefinition queryDef) {
            startField("image");

            _queryBuilder.append('{');
            queryDef.define(new MediaImageQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * An input object that can be used to filter by this value on the parent field.
        * The value is provided as a helper for building dynamic filtering UI. For
        * example, if you have a list of selected `FilterValue` objects, you can combine
        * their respective `input` values to use in a subsequent query.
        */
        public FilterValueQuery input() {
            startField("input");

            return this;
        }

        /**
        * A human-friendly string for this filter value.
        */
        public FilterValueQuery label() {
            startField("label");

            return this;
        }

        /**
        * The visual representation when the filter's presentation is `SWATCH`.
        */
        public FilterValueQuery swatch(SwatchQueryDefinition queryDef) {
            startField("swatch");

            _queryBuilder.append('{');
            queryDef.define(new SwatchQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * A selectable value within a filter.
    */
    public static class FilterValue extends AbstractResponse<FilterValue> {
        public FilterValue() {
        }

        public FilterValue(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "count": {
                        responseData.put(key, jsonAsInteger(field.getValue(), key));

                        break;
                    }

                    case "id": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "image": {
                        MediaImage optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new MediaImage(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "input": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "label": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "swatch": {
                        Swatch optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Swatch(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "FilterValue";
        }

        /**
        * The number of results that match this filter value.
        */

        public Integer getCount() {
            return (Integer) get("count");
        }

        public FilterValue setCount(Integer arg) {
            optimisticData.put(getKey("count"), arg);
            return this;
        }

        /**
        * A unique identifier.
        */

        public String getId() {
            return (String) get("id");
        }

        public FilterValue setId(String arg) {
            optimisticData.put(getKey("id"), arg);
            return this;
        }

        /**
        * The visual representation when the filter's presentation is `IMAGE`.
        */

        public MediaImage getImage() {
            return (MediaImage) get("image");
        }

        public FilterValue setImage(MediaImage arg) {
            optimisticData.put(getKey("image"), arg);
            return this;
        }

        /**
        * An input object that can be used to filter by this value on the parent field.
        * The value is provided as a helper for building dynamic filtering UI. For
        * example, if you have a list of selected `FilterValue` objects, you can combine
        * their respective `input` values to use in a subsequent query.
        */

        public String getInput() {
            return (String) get("input");
        }

        public FilterValue setInput(String arg) {
            optimisticData.put(getKey("input"), arg);
            return this;
        }

        /**
        * A human-friendly string for this filter value.
        */

        public String getLabel() {
            return (String) get("label");
        }

        public FilterValue setLabel(String arg) {
            optimisticData.put(getKey("label"), arg);
            return this;
        }

        /**
        * The visual representation when the filter's presentation is `SWATCH`.
        */

        public Swatch getSwatch() {
            return (Swatch) get("swatch");
        }

        public FilterValue setSwatch(Swatch arg) {
            optimisticData.put(getKey("swatch"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "count": return false;

                case "id": return false;

                case "image": return true;

                case "input": return false;

                case "label": return false;

                case "swatch": return true;

                default: return false;
            }
        }
    }

    public interface FulfillmentQueryDefinition {
        void define(FulfillmentQuery _queryBuilder);
    }

    /**
    * Represents a single fulfillment in an order.
    */
    public static class FulfillmentQuery extends Query<FulfillmentQuery> {
        FulfillmentQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public class FulfillmentLineItemsArguments extends Arguments {
            FulfillmentLineItemsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * Returns up to the first `n` elements from the list.
            */
            public FulfillmentLineItemsArguments first(Integer value) {
                if (value != null) {
                    startArgument("first");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come after the specified cursor.
            */
            public FulfillmentLineItemsArguments after(String value) {
                if (value != null) {
                    startArgument("after");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Returns up to the last `n` elements from the list.
            */
            public FulfillmentLineItemsArguments last(Integer value) {
                if (value != null) {
                    startArgument("last");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Returns the elements that come before the specified cursor.
            */
            public FulfillmentLineItemsArguments before(String value) {
                if (value != null) {
                    startArgument("before");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }

            /**
            * Reverse the order of the underlying list.
            */
            public FulfillmentLineItemsArguments reverse(Boolean value) {
                if (value != null) {
                    startArgument("reverse");
                    _queryBuilder.append(value);
                }
                return this;
            }
        }

        public interface FulfillmentLineItemsArgumentsDefinition {
            void define(FulfillmentLineItemsArguments args);
        }

        /**
        * List of the fulfillment's line items.
        */
        public FulfillmentQuery fulfillmentLineItems(FulfillmentLineItemConnectionQueryDefinition queryDef) {
            return fulfillmentLineItems(args -> {}, queryDef);
        }

        /**
        * List of the fulfillment's line items.
        */
        public FulfillmentQuery fulfillmentLineItems(FulfillmentLineItemsArgumentsDefinition argsDef, FulfillmentLineItemConnectionQueryDefinition queryDef) {
            startField("fulfillmentLineItems");

            FulfillmentLineItemsArguments args = new FulfillmentLineItemsArguments(_queryBuilder);
            argsDef.define(args);
            FulfillmentLineItemsArguments.end(args);

            _queryBuilder.append('{');
            queryDef.define(new FulfillmentLineItemConnectionQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The name of the tracking company.
        */
        public FulfillmentQuery trackingCompany() {
            startField("trackingCompany");

            return this;
        }

        public class TrackingInfoArguments extends Arguments {
            TrackingInfoArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * Truncate the array result to this size.
            */
            public TrackingInfoArguments first(Integer value) {
                if (value != null) {
                    startArgument("first");
                    _queryBuilder.append(value);
                }
                return this;
            }
        }

        public interface TrackingInfoArgumentsDefinition {
            void define(TrackingInfoArguments args);
        }

        /**
        * Tracking information associated with the fulfillment,
        * such as the tracking number and tracking URL.
        */
        public FulfillmentQuery trackingInfo(FulfillmentTrackingInfoQueryDefinition queryDef) {
            return trackingInfo(args -> {}, queryDef);
        }

        /**
        * Tracking information associated with the fulfillment,
        * such as the tracking number and tracking URL.
        */
        public FulfillmentQuery trackingInfo(TrackingInfoArgumentsDefinition argsDef, FulfillmentTrackingInfoQueryDefinition queryDef) {
            startField("trackingInfo");

            TrackingInfoArguments args = new TrackingInfoArguments(_queryBuilder);
            argsDef.define(args);
            TrackingInfoArguments.end(args);

            _queryBuilder.append('{');
            queryDef.define(new FulfillmentTrackingInfoQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Represents a single fulfillment in an order.
    */
    public static class Fulfillment extends AbstractResponse<Fulfillment> {
        public Fulfillment() {
        }

        public Fulfillment(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "fulfillmentLineItems": {
                        responseData.put(key, new FulfillmentLineItemConnection(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "trackingCompany": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "trackingInfo": {
                        List<FulfillmentTrackingInfo> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new FulfillmentTrackingInfo(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "Fulfillment";
        }

        /**
        * List of the fulfillment's line items.
        */

        public FulfillmentLineItemConnection getFulfillmentLineItems() {
            return (FulfillmentLineItemConnection) get("fulfillmentLineItems");
        }

        public Fulfillment setFulfillmentLineItems(FulfillmentLineItemConnection arg) {
            optimisticData.put(getKey("fulfillmentLineItems"), arg);
            return this;
        }

        /**
        * The name of the tracking company.
        */

        public String getTrackingCompany() {
            return (String) get("trackingCompany");
        }

        public Fulfillment setTrackingCompany(String arg) {
            optimisticData.put(getKey("trackingCompany"), arg);
            return this;
        }

        /**
        * Tracking information associated with the fulfillment,
        * such as the tracking number and tracking URL.
        */

        public List<FulfillmentTrackingInfo> getTrackingInfo() {
            return (List<FulfillmentTrackingInfo>) get("trackingInfo");
        }

        public Fulfillment setTrackingInfo(List<FulfillmentTrackingInfo> arg) {
            optimisticData.put(getKey("trackingInfo"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "fulfillmentLineItems": return true;

                case "trackingCompany": return false;

                case "trackingInfo": return true;

                default: return false;
            }
        }
    }

    public interface FulfillmentLineItemQueryDefinition {
        void define(FulfillmentLineItemQuery _queryBuilder);
    }

    /**
    * Represents a single line item in a fulfillment. There is at most one fulfillment line item for each
    * order line item.
    */
    public static class FulfillmentLineItemQuery extends Query<FulfillmentLineItemQuery> {
        FulfillmentLineItemQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The associated order's line item.
        */
        public FulfillmentLineItemQuery lineItem(OrderLineItemQueryDefinition queryDef) {
            startField("lineItem");

            _queryBuilder.append('{');
            queryDef.define(new OrderLineItemQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The amount fulfilled in this fulfillment.
        */
        public FulfillmentLineItemQuery quantity() {
            startField("quantity");

            return this;
        }
    }

    /**
    * Represents a single line item in a fulfillment. There is at most one fulfillment line item for each
    * order line item.
    */
    public static class FulfillmentLineItem extends AbstractResponse<FulfillmentLineItem> {
        public FulfillmentLineItem() {
        }

        public FulfillmentLineItem(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "lineItem": {
                        responseData.put(key, new OrderLineItem(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "quantity": {
                        responseData.put(key, jsonAsInteger(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "FulfillmentLineItem";
        }

        /**
        * The associated order's line item.
        */

        public OrderLineItem getLineItem() {
            return (OrderLineItem) get("lineItem");
        }

        public FulfillmentLineItem setLineItem(OrderLineItem arg) {
            optimisticData.put(getKey("lineItem"), arg);
            return this;
        }

        /**
        * The amount fulfilled in this fulfillment.
        */

        public Integer getQuantity() {
            return (Integer) get("quantity");
        }

        public FulfillmentLineItem setQuantity(Integer arg) {
            optimisticData.put(getKey("quantity"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "lineItem": return true;

                case "quantity": return false;

                default: return false;
            }
        }
    }

    public interface FulfillmentLineItemConnectionQueryDefinition {
        void define(FulfillmentLineItemConnectionQuery _queryBuilder);
    }

    /**
    * An auto-generated type for paginating through multiple FulfillmentLineItems.
    */
    public static class FulfillmentLineItemConnectionQuery extends Query<FulfillmentLineItemConnectionQuery> {
        FulfillmentLineItemConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A list of edges.
        */
        public FulfillmentLineItemConnectionQuery edges(FulfillmentLineItemEdgeQueryDefinition queryDef) {
            startField("edges");

            _queryBuilder.append('{');
            queryDef.define(new FulfillmentLineItemEdgeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A list of the nodes contained in FulfillmentLineItemEdge.
        */
        public FulfillmentLineItemConnectionQuery nodes(FulfillmentLineItemQueryDefinition queryDef) {
            startField("nodes");

            _queryBuilder.append('{');
            queryDef.define(new FulfillmentLineItemQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * Information to aid in pagination.
        */
        public FulfillmentLineItemConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            startField("pageInfo");

            _queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type for paginating through multiple FulfillmentLineItems.
    */
    public static class FulfillmentLineItemConnection extends AbstractResponse<FulfillmentLineItemConnection> {
        public FulfillmentLineItemConnection() {
        }

        public FulfillmentLineItemConnection(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "edges": {
                        List<FulfillmentLineItemEdge> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new FulfillmentLineItemEdge(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "nodes": {
                        List<FulfillmentLineItem> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new FulfillmentLineItem(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "pageInfo": {
                        responseData.put(key, new PageInfo(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "FulfillmentLineItemConnection";
        }

        /**
        * A list of edges.
        */

        public List<FulfillmentLineItemEdge> getEdges() {
            return (List<FulfillmentLineItemEdge>) get("edges");
        }

        public FulfillmentLineItemConnection setEdges(List<FulfillmentLineItemEdge> arg) {
            optimisticData.put(getKey("edges"), arg);
            return this;
        }

        /**
        * A list of the nodes contained in FulfillmentLineItemEdge.
        */

        public List<FulfillmentLineItem> getNodes() {
            return (List<FulfillmentLineItem>) get("nodes");
        }

        public FulfillmentLineItemConnection setNodes(List<FulfillmentLineItem> arg) {
            optimisticData.put(getKey("nodes"), arg);
            return this;
        }

        /**
        * Information to aid in pagination.
        */

        public PageInfo getPageInfo() {
            return (PageInfo) get("pageInfo");
        }

        public FulfillmentLineItemConnection setPageInfo(PageInfo arg) {
            optimisticData.put(getKey("pageInfo"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "edges": return true;

                case "nodes": return true;

                case "pageInfo": return true;

                default: return false;
            }
        }
    }

    public interface FulfillmentLineItemEdgeQueryDefinition {
        void define(FulfillmentLineItemEdgeQuery _queryBuilder);
    }

    /**
    * An auto-generated type which holds one FulfillmentLineItem and a cursor during pagination.
    */
    public static class FulfillmentLineItemEdgeQuery extends Query<FulfillmentLineItemEdgeQuery> {
        FulfillmentLineItemEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A cursor for use in pagination.
        */
        public FulfillmentLineItemEdgeQuery cursor() {
            startField("cursor");

            return this;
        }

        /**
        * The item at the end of FulfillmentLineItemEdge.
        */
        public FulfillmentLineItemEdgeQuery node(FulfillmentLineItemQueryDefinition queryDef) {
            startField("node");

            _queryBuilder.append('{');
            queryDef.define(new FulfillmentLineItemQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type which holds one FulfillmentLineItem and a cursor during pagination.
    */
    public static class FulfillmentLineItemEdge extends AbstractResponse<FulfillmentLineItemEdge> {
        public FulfillmentLineItemEdge() {
        }

        public FulfillmentLineItemEdge(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cursor": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "node": {
                        responseData.put(key, new FulfillmentLineItem(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "FulfillmentLineItemEdge";
        }

        /**
        * A cursor for use in pagination.
        */

        public String getCursor() {
            return (String) get("cursor");
        }

        public FulfillmentLineItemEdge setCursor(String arg) {
            optimisticData.put(getKey("cursor"), arg);
            return this;
        }

        /**
        * The item at the end of FulfillmentLineItemEdge.
        */

        public FulfillmentLineItem getNode() {
            return (FulfillmentLineItem) get("node");
        }

        public FulfillmentLineItemEdge setNode(FulfillmentLineItem arg) {
            optimisticData.put(getKey("node"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cursor": return false;

                case "node": return true;

                default: return false;
            }
        }
    }

    public interface FulfillmentTrackingInfoQueryDefinition {
        void define(FulfillmentTrackingInfoQuery _queryBuilder);
    }

    /**
    * Tracking information associated with the fulfillment.
    */
    public static class FulfillmentTrackingInfoQuery extends Query<FulfillmentTrackingInfoQuery> {
        FulfillmentTrackingInfoQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The tracking number of the fulfillment.
        */
        public FulfillmentTrackingInfoQuery number() {
            startField("number");

            return this;
        }

        /**
        * The URL to track the fulfillment.
        */
        public FulfillmentTrackingInfoQuery url() {
            startField("url");

            return this;
        }
    }

    /**
    * Tracking information associated with the fulfillment.
    */
    public static class FulfillmentTrackingInfo extends AbstractResponse<FulfillmentTrackingInfo> {
        public FulfillmentTrackingInfo() {
        }

        public FulfillmentTrackingInfo(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "number": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "url": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "FulfillmentTrackingInfo";
        }

        /**
        * The tracking number of the fulfillment.
        */

        public String getNumber() {
            return (String) get("number");
        }

        public FulfillmentTrackingInfo setNumber(String arg) {
            optimisticData.put(getKey("number"), arg);
            return this;
        }

        /**
        * The URL to track the fulfillment.
        */

        public String getUrl() {
            return (String) get("url");
        }

        public FulfillmentTrackingInfo setUrl(String arg) {
            optimisticData.put(getKey("url"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "number": return false;

                case "url": return false;

                default: return false;
            }
        }
    }

    public interface GenericFileQueryDefinition {
        void define(GenericFileQuery _queryBuilder);
    }

    /**
    * The generic file resource lets you manage files in a merchant’s store. Generic files include any
    * file that doesn’t fit into a designated type such as image or video. Example: PDF, JSON.
    */
    public static class GenericFileQuery extends Query<GenericFileQuery> {
        GenericFileQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("id");
        }

        /**
        * A word or phrase to indicate the contents of a file.
        */
        public GenericFileQuery alt() {
            startField("alt");

            return this;
        }

        /**
        * The MIME type of the file.
        */
        public GenericFileQuery mimeType() {
            startField("mimeType");

            return this;
        }

        /**
        * The size of the original file in bytes.
        */
        public GenericFileQuery originalFileSize() {
            startField("originalFileSize");

            return this;
        }

        /**
        * The preview image for the file.
        */
        public GenericFileQuery previewImage(ImageQueryDefinition queryDef) {
            startField("previewImage");

            _queryBuilder.append('{');
            queryDef.define(new ImageQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The URL of the file.
        */
        public GenericFileQuery url() {
            startField("url");

            return this;
        }
    }

    /**
    * The generic file resource lets you manage files in a merchant’s store. Generic files include any
    * file that doesn’t fit into a designated type such as image or video. Example: PDF, JSON.
    */
    public static class GenericFile extends AbstractResponse<GenericFile> implements MetafieldReference, Node {
        public GenericFile() {
        }

        public GenericFile(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "alt": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "mimeType": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "originalFileSize": {
                        Integer optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsInteger(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "previewImage": {
                        Image optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Image(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "url": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public GenericFile(ID id) {
            this();
            optimisticData.put("id", id);
        }

        public String getGraphQlTypeName() {
            return "GenericFile";
        }

        /**
        * A word or phrase to indicate the contents of a file.
        */

        public String getAlt() {
            return (String) get("alt");
        }

        public GenericFile setAlt(String arg) {
            optimisticData.put(getKey("alt"), arg);
            return this;
        }

        /**
        * A globally-unique ID.
        */

        public ID getId() {
            return (ID) get("id");
        }

        /**
        * The MIME type of the file.
        */

        public String getMimeType() {
            return (String) get("mimeType");
        }

        public GenericFile setMimeType(String arg) {
            optimisticData.put(getKey("mimeType"), arg);
            return this;
        }

        /**
        * The size of the original file in bytes.
        */

        public Integer getOriginalFileSize() {
            return (Integer) get("originalFileSize");
        }

        public GenericFile setOriginalFileSize(Integer arg) {
            optimisticData.put(getKey("originalFileSize"), arg);
            return this;
        }

        /**
        * The preview image for the file.
        */

        public Image getPreviewImage() {
            return (Image) get("previewImage");
        }

        public GenericFile setPreviewImage(Image arg) {
            optimisticData.put(getKey("previewImage"), arg);
            return this;
        }

        /**
        * The URL of the file.
        */

        public String getUrl() {
            return (String) get("url");
        }

        public GenericFile setUrl(String arg) {
            optimisticData.put(getKey("url"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "alt": return false;

                case "id": return false;

                case "mimeType": return false;

                case "originalFileSize": return false;

                case "previewImage": return true;

                case "url": return false;

                default: return false;
            }
        }
    }

    public static class GeoCoordinateInput implements Serializable {
        private double latitude;

        private double longitude;

        public GeoCoordinateInput(double latitude, double longitude) {
            this.latitude = latitude;

            this.longitude = longitude;
        }

        public double getLatitude() {
            return latitude;
        }

        public GeoCoordinateInput setLatitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        public double getLongitude() {
            return longitude;
        }

        public GeoCoordinateInput setLongitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("latitude:");
            _queryBuilder.append(latitude);

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("longitude:");
            _queryBuilder.append(longitude);

            _queryBuilder.append('}');
        }
    }

    public interface HasMetafieldsQueryDefinition {
        void define(HasMetafieldsQuery _queryBuilder);
    }

    /**
    * Represents information about the metafields associated to the specified resource.
    */
    public static class HasMetafieldsQuery extends Query<HasMetafieldsQuery> {
        HasMetafieldsQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("__typename");
        }

        public class MetafieldArguments extends Arguments {
            MetafieldArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            /**
            * The container the metafield belongs to. If omitted, the app-reserved namespace will be used.
            */
            public MetafieldArguments namespace(String value) {
                if (value != null) {
                    startArgument("namespace");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }
        }

        public interface MetafieldArgumentsDefinition {
            void define(MetafieldArguments args);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public HasMetafieldsQuery metafield(String key, MetafieldQueryDefinition queryDef) {
            return metafield(key, args -> {}, queryDef);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public HasMetafieldsQuery metafield(String key, MetafieldArgumentsDefinition argsDef, MetafieldQueryDefinition queryDef) {
            startField("metafield");

            _queryBuilder.append("(key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            argsDef.define(new MetafieldArguments(_queryBuilder));

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */
        public HasMetafieldsQuery metafields(List<HasMetafieldsIdentifier> identifiers, MetafieldQueryDefinition queryDef) {
            startField("metafields");

            _queryBuilder.append("(identifiers:");
            _queryBuilder.append('[');
            {
                String listSeperator1 = "";
                for (HasMetafieldsIdentifier item1 : identifiers) {
                    _queryBuilder.append(listSeperator1);
                    listSeperator1 = ",";
                    item1.appendTo(_queryBuilder);
                }
            }
            _queryBuilder.append(']');

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        public HasMetafieldsQuery onArticle(ArticleQueryDefinition queryDef) {
            startInlineFragment("Article");
            queryDef.define(new ArticleQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public HasMetafieldsQuery onBlog(BlogQueryDefinition queryDef) {
            startInlineFragment("Blog");
            queryDef.define(new BlogQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public HasMetafieldsQuery onCart(CartQueryDefinition queryDef) {
            startInlineFragment("Cart");
            queryDef.define(new CartQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public HasMetafieldsQuery onCollection(CollectionQueryDefinition queryDef) {
            startInlineFragment("Collection");
            queryDef.define(new CollectionQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public HasMetafieldsQuery onCompany(CompanyQueryDefinition queryDef) {
            startInlineFragment("Company");
            queryDef.define(new CompanyQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public HasMetafieldsQuery onCompanyLocation(CompanyLocationQueryDefinition queryDef) {
            startInlineFragment("CompanyLocation");
            queryDef.define(new CompanyLocationQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public HasMetafieldsQuery onCustomer(CustomerQueryDefinition queryDef) {
            startInlineFragment("Customer");
            queryDef.define(new CustomerQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public HasMetafieldsQuery onLocation(LocationQueryDefinition queryDef) {
            startInlineFragment("Location");
            queryDef.define(new LocationQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public HasMetafieldsQuery onMarket(MarketQueryDefinition queryDef) {
            startInlineFragment("Market");
            queryDef.define(new MarketQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public HasMetafieldsQuery onOrder(OrderQueryDefinition queryDef) {
            startInlineFragment("Order");
            queryDef.define(new OrderQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public HasMetafieldsQuery onPage(PageQueryDefinition queryDef) {
            startInlineFragment("Page");
            queryDef.define(new PageQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public HasMetafieldsQuery onProduct(ProductQueryDefinition queryDef) {
            startInlineFragment("Product");
            queryDef.define(new ProductQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public HasMetafieldsQuery onProductVariant(ProductVariantQueryDefinition queryDef) {
            startInlineFragment("ProductVariant");
            queryDef.define(new ProductVariantQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public HasMetafieldsQuery onSellingPlan(SellingPlanQueryDefinition queryDef) {
            startInlineFragment("SellingPlan");
            queryDef.define(new SellingPlanQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }

        public HasMetafieldsQuery onShop(ShopQueryDefinition queryDef) {
            startInlineFragment("Shop");
            queryDef.define(new ShopQuery(_queryBuilder));
            _queryBuilder.append('}');
            return this;
        }
    }

    public interface HasMetafields {
        String getGraphQlTypeName();

        Metafield getMetafield();

        List<Metafield> getMetafields();
    }

    /**
    * Represents information about the metafields associated to the specified resource.
    */
    public static class UnknownHasMetafields extends AbstractResponse<UnknownHasMetafields> implements HasMetafields {
        public UnknownHasMetafields() {
        }

        public UnknownHasMetafields(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "metafield": {
                        Metafield optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Metafield(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "metafields": {
                        List<Metafield> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            Metafield optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = new Metafield(jsonAsObject(element1, key));
                            }

                            list1.add(optional2);
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public static HasMetafields create(JsonObject fields) throws SchemaViolationError {
            String typeName = fields.getAsJsonPrimitive("__typename").getAsString();
            switch (typeName) {
                case "Article": {
                    return new Article(fields);
                }

                case "Blog": {
                    return new Blog(fields);
                }

                case "Cart": {
                    return new Cart(fields);
                }

                case "Collection": {
                    return new Collection(fields);
                }

                case "Company": {
                    return new Company(fields);
                }

                case "CompanyLocation": {
                    return new CompanyLocation(fields);
                }

                case "Customer": {
                    return new Customer(fields);
                }

                case "Location": {
                    return new Location(fields);
                }

                case "Market": {
                    return new Market(fields);
                }

                case "Order": {
                    return new Order(fields);
                }

                case "Page": {
                    return new Page(fields);
                }

                case "Product": {
                    return new Product(fields);
                }

                case "ProductVariant": {
                    return new ProductVariant(fields);
                }

                case "SellingPlan": {
                    return new SellingPlan(fields);
                }

                case "Shop": {
                    return new Shop(fields);
                }

                default: {
                    return new UnknownHasMetafields(fields);
                }
            }
        }

        public String getGraphQlTypeName() {
            return (String) get("__typename");
        }

        /**
        * Returns a metafield found by namespace and key.
        */

        public Metafield getMetafield() {
            return (Metafield) get("metafield");
        }

        public UnknownHasMetafields setMetafield(Metafield arg) {
            optimisticData.put(getKey("metafield"), arg);
            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */

        public List<Metafield> getMetafields() {
            return (List<Metafield>) get("metafields");
        }

        public UnknownHasMetafields setMetafields(List<Metafield> arg) {
            optimisticData.put(getKey("metafields"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "metafield": return true;

                case "metafields": return true;

                default: return false;
            }
        }
    }

    public static class HasMetafieldsIdentifier implements Serializable {
        private String key;

        private Input<String> namespace = Input.undefined();

        public HasMetafieldsIdentifier(String key) {
            this.key = key;
        }

        public String getKey() {
            return key;
        }

        public HasMetafieldsIdentifier setKey(String key) {
            this.key = key;
            return this;
        }

        public String getNamespace() {
            return namespace.getValue();
        }

        public Input<String> getNamespaceInput() {
            return namespace;
        }

        public HasMetafieldsIdentifier setNamespace(String namespace) {
            this.namespace = Input.optional(namespace);
            return this;
        }

        public HasMetafieldsIdentifier setNamespaceInput(Input<String> namespace) {
            if (namespace == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.namespace = namespace;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            if (this.namespace.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("namespace:");
                if (namespace.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, namespace.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    public interface ImageQueryDefinition {
        void define(ImageQuery _queryBuilder);
    }

    /**
    * Represents an image resource.
    */
    public static class ImageQuery extends Query<ImageQuery> {
        ImageQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A word or phrase to share the nature or contents of an image.
        */
        public ImageQuery altText() {
            startField("altText");

            return this;
        }

        /**
        * The original height of the image in pixels. Returns `null` if the image isn't hosted by Shopify.
        */
        public ImageQuery height() {
            startField("height");

            return this;
        }

        /**
        * A unique ID for the image.
        */
        public ImageQuery id() {
            startField("id");

            return this;
        }

        /**
        * The location of the original image as a URL.
        * If there are any existing transformations in the original source URL, they will remain and not be
        * stripped.
        *
        * @deprecated Use `url` instead.
        */
        @Deprecated
        public ImageQuery originalSrc() {
            startField("originalSrc");

            return this;
        }

        /**
        * The location of the image as a URL.
        *
        * @deprecated Use `url` instead.
        */
        @Deprecated
        public ImageQuery src() {
            startField("src");

            return this;
        }

        public class TransformedSrcArguments extends Arguments {
            TransformedSrcArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * Image width in pixels between 1 and 5760.
            */
            public TransformedSrcArguments maxWidth(Integer value) {
                if (value != null) {
                    startArgument("maxWidth");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Image height in pixels between 1 and 5760.
            */
            public TransformedSrcArguments maxHeight(Integer value) {
                if (value != null) {
                    startArgument("maxHeight");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Crops the image according to the specified region.
            */
            public TransformedSrcArguments crop(CropRegion value) {
                if (value != null) {
                    startArgument("crop");
                    _queryBuilder.append(value.toString());
                }
                return this;
            }

            /**
            * Image size multiplier for high-resolution retina displays. Must be between 1 and 3.
            */
            public TransformedSrcArguments scale(Integer value) {
                if (value != null) {
                    startArgument("scale");
                    _queryBuilder.append(value);
                }
                return this;
            }

            /**
            * Best effort conversion of image into content type (SVG -> PNG, Anything -> JPG, Anything -> WEBP are
            * supported).
            */
            public TransformedSrcArguments preferredContentType(ImageContentType value) {
                if (value != null) {
                    startArgument("preferredContentType");
                    _queryBuilder.append(value.toString());
                }
                return this;
            }
        }

        public interface TransformedSrcArgumentsDefinition {
            void define(TransformedSrcArguments args);
        }

        /**
        * The location of the transformed image as a URL.
        * All transformation arguments are considered "best-effort". If they can be applied to an image, they
        * will be.
        * Otherwise any transformations which an image type doesn't support will be ignored.
        *
        * @deprecated Use `url(transform:)` instead
        */
        public ImageQuery transformedSrc() {
            return transformedSrc(args -> {});
        }

        /**
        * The location of the transformed image as a URL.
        * All transformation arguments are considered "best-effort". If they can be applied to an image, they
        * will be.
        * Otherwise any transformations which an image type doesn't support will be ignored.
        *
        * @deprecated Use `url(transform:)` instead
        */
        @Deprecated
        public ImageQuery transformedSrc(TransformedSrcArgumentsDefinition argsDef) {
            startField("transformedSrc");

            TransformedSrcArguments args = new TransformedSrcArguments(_queryBuilder);
            argsDef.define(args);
            TransformedSrcArguments.end(args);

            return this;
        }

        public class UrlArguments extends Arguments {
            UrlArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            /**
            * A set of options to transform the original image.
            */
            public UrlArguments transform(ImageTransformInput value) {
                if (value != null) {
                    startArgument("transform");
                    value.appendTo(_queryBuilder);
                }
                return this;
            }
        }

        public interface UrlArgumentsDefinition {
            void define(UrlArguments args);
        }

        /**
        * The location of the image as a URL.
        * If no transform options are specified, then the original image will be preserved including any
        * pre-applied transforms.
        * All transformation options are considered "best-effort". Any transformation that the original image
        * type doesn't support will be ignored.
        * If you need multiple variations of the same image, then you can use [GraphQL
        * aliases](https://graphql.org/learn/queries/#aliases).
        */
        public ImageQuery url() {
            return url(args -> {});
        }

        /**
        * The location of the image as a URL.
        * If no transform options are specified, then the original image will be preserved including any
        * pre-applied transforms.
        * All transformation options are considered "best-effort". Any transformation that the original image
        * type doesn't support will be ignored.
        * If you need multiple variations of the same image, then you can use [GraphQL
        * aliases](https://graphql.org/learn/queries/#aliases).
        */
        public ImageQuery url(UrlArgumentsDefinition argsDef) {
            startField("url");

            UrlArguments args = new UrlArguments(_queryBuilder);
            argsDef.define(args);
            UrlArguments.end(args);

            return this;
        }

        /**
        * The original width of the image in pixels. Returns `null` if the image isn't hosted by Shopify.
        */
        public ImageQuery width() {
            startField("width");

            return this;
        }
    }

    /**
    * Represents an image resource.
    */
    public static class Image extends AbstractResponse<Image> {
        public Image() {
        }

        public Image(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "altText": {
                        String optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsString(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "height": {
                        Integer optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsInteger(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "id": {
                        ID optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new ID(jsonAsString(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "originalSrc": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "src": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "transformedSrc": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "url": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "width": {
                        Integer optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = jsonAsInteger(field.getValue(), key);
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "Image";
        }

        /**
        * A word or phrase to share the nature or contents of an image.
        */

        public String getAltText() {
            return (String) get("altText");
        }

        public Image setAltText(String arg) {
            optimisticData.put(getKey("altText"), arg);
            return this;
        }

        /**
        * The original height of the image in pixels. Returns `null` if the image isn't hosted by Shopify.
        */

        public Integer getHeight() {
            return (Integer) get("height");
        }

        public Image setHeight(Integer arg) {
            optimisticData.put(getKey("height"), arg);
            return this;
        }

        /**
        * A unique ID for the image.
        */

        public ID getId() {
            return (ID) get("id");
        }

        public Image setId(ID arg) {
            optimisticData.put(getKey("id"), arg);
            return this;
        }

        /**
        * The location of the original image as a URL.
        * If there are any existing transformations in the original source URL, they will remain and not be
        * stripped.
        *
        * @deprecated Use `url` instead.
        */

        public String getOriginalSrc() {
            return (String) get("originalSrc");
        }

        public Image setOriginalSrc(String arg) {
            optimisticData.put(getKey("originalSrc"), arg);
            return this;
        }

        /**
        * The location of the image as a URL.
        *
        * @deprecated Use `url` instead.
        */

        public String getSrc() {
            return (String) get("src");
        }

        public Image setSrc(String arg) {
            optimisticData.put(getKey("src"), arg);
            return this;
        }

        /**
        * The location of the transformed image as a URL.
        * All transformation arguments are considered "best-effort". If they can be applied to an image, they
        * will be.
        * Otherwise any transformations which an image type doesn't support will be ignored.
        *
        * @deprecated Use `url(transform:)` instead
        */

        public String getTransformedSrc() {
            return (String) get("transformedSrc");
        }

        public Image setTransformedSrc(String arg) {
            optimisticData.put(getKey("transformedSrc"), arg);
            return this;
        }

        /**
        * The location of the image as a URL.
        * If no transform options are specified, then the original image will be preserved including any
        * pre-applied transforms.
        * All transformation options are considered "best-effort". Any transformation that the original image
        * type doesn't support will be ignored.
        * If you need multiple variations of the same image, then you can use [GraphQL
        * aliases](https://graphql.org/learn/queries/#aliases).
        */

        public String getUrl() {
            return (String) get("url");
        }

        public Image setUrl(String arg) {
            optimisticData.put(getKey("url"), arg);
            return this;
        }

        /**
        * The original width of the image in pixels. Returns `null` if the image isn't hosted by Shopify.
        */

        public Integer getWidth() {
            return (Integer) get("width");
        }

        public Image setWidth(Integer arg) {
            optimisticData.put(getKey("width"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "altText": return false;

                case "height": return false;

                case "id": return false;

                case "originalSrc": return false;

                case "src": return false;

                case "transformedSrc": return false;

                case "url": return false;

                case "width": return false;

                default: return false;
            }
        }
    }

    public interface ImageConnectionQueryDefinition {
        void define(ImageConnectionQuery _queryBuilder);
    }

    /**
    * An auto-generated type for paginating through multiple Images.
    */
    public static class ImageConnectionQuery extends Query<ImageConnectionQuery> {
        ImageConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A list of edges.
        */
        public ImageConnectionQuery edges(ImageEdgeQueryDefinition queryDef) {
            startField("edges");

            _queryBuilder.append('{');
            queryDef.define(new ImageEdgeQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * A list of the nodes contained in ImageEdge.
        */
        public ImageConnectionQuery nodes(ImageQueryDefinition queryDef) {
            startField("nodes");

            _queryBuilder.append('{');
            queryDef.define(new ImageQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * Information to aid in pagination.
        */
        public ImageConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            startField("pageInfo");

            _queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type for paginating through multiple Images.
    */
    public static class ImageConnection extends AbstractResponse<ImageConnection> {
        public ImageConnection() {
        }

        public ImageConnection(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "edges": {
                        List<ImageEdge> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new ImageEdge(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "nodes": {
                        List<Image> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new Image(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "pageInfo": {
                        responseData.put(key, new PageInfo(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "ImageConnection";
        }

        /**
        * A list of edges.
        */

        public List<ImageEdge> getEdges() {
            return (List<ImageEdge>) get("edges");
        }

        public ImageConnection setEdges(List<ImageEdge> arg) {
            optimisticData.put(getKey("edges"), arg);
            return this;
        }

        /**
        * A list of the nodes contained in ImageEdge.
        */

        public List<Image> getNodes() {
            return (List<Image>) get("nodes");
        }

        public ImageConnection setNodes(List<Image> arg) {
            optimisticData.put(getKey("nodes"), arg);
            return this;
        }

        /**
        * Information to aid in pagination.
        */

        public PageInfo getPageInfo() {
            return (PageInfo) get("pageInfo");
        }

        public ImageConnection setPageInfo(PageInfo arg) {
            optimisticData.put(getKey("pageInfo"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "edges": return true;

                case "nodes": return true;

                case "pageInfo": return true;

                default: return false;
            }
        }
    }

    /**
    * List of supported image content types.
    */
    public enum ImageContentType {
        /**
        * A JPG image.
        */
        JPG,

        /**
        * A PNG image.
        */
        PNG,

        /**
        * A WEBP image.
        */
        WEBP,

        UNKNOWN_VALUE;

        public static ImageContentType fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "JPG": {
                    return JPG;
                }

                case "PNG": {
                    return PNG;
                }

                case "WEBP": {
                    return WEBP;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case JPG: {
                    return "JPG";
                }

                case PNG: {
                    return "PNG";
                }

                case WEBP: {
                    return "WEBP";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface ImageEdgeQueryDefinition {
        void define(ImageEdgeQuery _queryBuilder);
    }

    /**
    * An auto-generated type which holds one Image and a cursor during pagination.
    */
    public static class ImageEdgeQuery extends Query<ImageEdgeQuery> {
        ImageEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * A cursor for use in pagination.
        */
        public ImageEdgeQuery cursor() {
            startField("cursor");

            return this;
        }

        /**
        * The item at the end of ImageEdge.
        */
        public ImageEdgeQuery node(ImageQueryDefinition queryDef) {
            startField("node");

            _queryBuilder.append('{');
            queryDef.define(new ImageQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * An auto-generated type which holds one Image and a cursor during pagination.
    */
    public static class ImageEdge extends AbstractResponse<ImageEdge> {
        public ImageEdge() {
        }

        public ImageEdge(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "cursor": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "node": {
                        responseData.put(key, new Image(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "ImageEdge";
        }

        /**
        * A cursor for use in pagination.
        */

        public String getCursor() {
            return (String) get("cursor");
        }

        public ImageEdge setCursor(String arg) {
            optimisticData.put(getKey("cursor"), arg);
            return this;
        }

        /**
        * The item at the end of ImageEdge.
        */

        public Image getNode() {
            return (Image) get("node");
        }

        public ImageEdge setNode(Image arg) {
            optimisticData.put(getKey("node"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "cursor": return false;

                case "node": return true;

                default: return false;
            }
        }
    }

    public static class ImageTransformInput implements Serializable {
        private Input<CropRegion> crop = Input.undefined();

        private Input<Integer> maxWidth = Input.undefined();

        private Input<Integer> maxHeight = Input.undefined();

        private Input<Integer> scale = Input.undefined();

        private Input<ImageContentType> preferredContentType = Input.undefined();

        public CropRegion getCrop() {
            return crop.getValue();
        }

        public Input<CropRegion> getCropInput() {
            return crop;
        }

        public ImageTransformInput setCrop(CropRegion crop) {
            this.crop = Input.optional(crop);
            return this;
        }

        public ImageTransformInput setCropInput(Input<CropRegion> crop) {
            if (crop == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.crop = crop;
            return this;
        }

        public Integer getMaxWidth() {
            return maxWidth.getValue();
        }

        public Input<Integer> getMaxWidthInput() {
            return maxWidth;
        }

        public ImageTransformInput setMaxWidth(Integer maxWidth) {
            this.maxWidth = Input.optional(maxWidth);
            return this;
        }

        public ImageTransformInput setMaxWidthInput(Input<Integer> maxWidth) {
            if (maxWidth == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.maxWidth = maxWidth;
            return this;
        }

        public Integer getMaxHeight() {
            return maxHeight.getValue();
        }

        public Input<Integer> getMaxHeightInput() {
            return maxHeight;
        }

        public ImageTransformInput setMaxHeight(Integer maxHeight) {
            this.maxHeight = Input.optional(maxHeight);
            return this;
        }

        public ImageTransformInput setMaxHeightInput(Input<Integer> maxHeight) {
            if (maxHeight == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.maxHeight = maxHeight;
            return this;
        }

        public Integer getScale() {
            return scale.getValue();
        }

        public Input<Integer> getScaleInput() {
            return scale;
        }

        public ImageTransformInput setScale(Integer scale) {
            this.scale = Input.optional(scale);
            return this;
        }

        public ImageTransformInput setScaleInput(Input<Integer> scale) {
            if (scale == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.scale = scale;
            return this;
        }

        public ImageContentType getPreferredContentType() {
            return preferredContentType.getValue();
        }

        public Input<ImageContentType> getPreferredContentTypeInput() {
            return preferredContentType;
        }

        public ImageTransformInput setPreferredContentType(ImageContentType preferredContentType) {
            this.preferredContentType = Input.optional(preferredContentType);
            return this;
        }

        public ImageTransformInput setPreferredContentTypeInput(Input<ImageContentType> preferredContentType) {
            if (preferredContentType == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.preferredContentType = preferredContentType;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');

            if (this.crop.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("crop:");
                if (crop.getValue() != null) {
                    _queryBuilder.append(crop.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.maxWidth.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("maxWidth:");
                if (maxWidth.getValue() != null) {
                    _queryBuilder.append(maxWidth.getValue());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.maxHeight.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("maxHeight:");
                if (maxHeight.getValue() != null) {
                    _queryBuilder.append(maxHeight.getValue());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.scale.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("scale:");
                if (scale.getValue() != null) {
                    _queryBuilder.append(scale.getValue());
                } else {
                    _queryBuilder.append("null");
                }
            }

            if (this.preferredContentType.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("preferredContentType:");
                if (preferredContentType.getValue() != null) {
                    _queryBuilder.append(preferredContentType.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }

            _queryBuilder.append('}');
        }
    }

    public interface LanguageQueryDefinition {
        void define(LanguageQuery _queryBuilder);
    }

    /**
    * A language.
    */
    public static class LanguageQuery extends Query<LanguageQuery> {
        LanguageQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The name of the language in the language itself. If the language uses capitalization, it is
        * capitalized for a mid-sentence position.
        */
        public LanguageQuery endonymName() {
            startField("endonymName");

            return this;
        }

        /**
        * The ISO code.
        */
        public LanguageQuery isoCode() {
            startField("isoCode");

            return this;
        }

        /**
        * The name of the language in the current language.
        */
        public LanguageQuery name() {
            startField("name");

            return this;
        }
    }

    /**
    * A language.
    */
    public static class Language extends AbstractResponse<Language> {
        public Language() {
        }

        public Language(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "endonymName": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "isoCode": {
                        responseData.put(key, LanguageCode.fromGraphQl(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "name": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "Language";
        }

        /**
        * The name of the language in the language itself. If the language uses capitalization, it is
        * capitalized for a mid-sentence position.
        */

        public String getEndonymName() {
            return (String) get("endonymName");
        }

        public Language setEndonymName(String arg) {
            optimisticData.put(getKey("endonymName"), arg);
            return this;
        }

        /**
        * The ISO code.
        */

        public LanguageCode getIsoCode() {
            return (LanguageCode) get("isoCode");
        }

        public Language setIsoCode(LanguageCode arg) {
            optimisticData.put(getKey("isoCode"), arg);
            return this;
        }

        /**
        * The name of the language in the current language.
        */

        public String getName() {
            return (String) get("name");
        }

        public Language setName(String arg) {
            optimisticData.put(getKey("name"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "endonymName": return false;

                case "isoCode": return false;

                case "name": return false;

                default: return false;
            }
        }
    }

    /**
    * ISO 639-1 language codes supported by Shopify.
    */
    public enum LanguageCode {
        /**
        * Afrikaans.
        */
        AF,

        /**
        * Akan.
        */
        AK,

        /**
        * Amharic.
        */
        AM,

        /**
        * Arabic.
        */
        AR,

        /**
        * Assamese.
        */
        AS,

        /**
        * Azerbaijani.
        */
        AZ,

        /**
        * Belarusian.
        */
        BE,

        /**
        * Bulgarian.
        */
        BG,

        /**
        * Bambara.
        */
        BM,

        /**
        * Bangla.
        */
        BN,

        /**
        * Tibetan.
        */
        BO,

        /**
        * Breton.
        */
        BR,

        /**
        * Bosnian.
        */
        BS,

        /**
        * Catalan.
        */
        CA,

        /**
        * Chechen.
        */
        CE,

        /**
        * Central Kurdish.
        */
        CKB,

        /**
        * Czech.
        */
        CS,

        /**
        * Church Slavic.
        */
        CU,

        /**
        * Welsh.
        */
        CY,

        /**
        * Danish.
        */
        DA,

        /**
        * German.
        */
        DE,

        /**
        * Dzongkha.
        */
        DZ,

        /**
        * Ewe.
        */
        EE,

        /**
        * Greek.
        */
        EL,

        /**
        * English.
        */
        EN,

        /**
        * Esperanto.
        */
        EO,

        /**
        * Spanish.
        */
        ES,

        /**
        * Estonian.
        */
        ET,

        /**
        * Basque.
        */
        EU,

        /**
        * Persian.
        */
        FA,

        /**
        * Fulah.
        */
        FF,

        /**
        * Finnish.
        */
        FI,

        /**
        * Filipino.
        */
        FIL,

        /**
        * Faroese.
        */
        FO,

        /**
        * French.
        */
        FR,

        /**
        * Western Frisian.
        */
        FY,

        /**
        * Irish.
        */
        GA,

        /**
        * Scottish Gaelic.
        */
        GD,

        /**
        * Galician.
        */
        GL,

        /**
        * Gujarati.
        */
        GU,

        /**
        * Manx.
        */
        GV,

        /**
        * Hausa.
        */
        HA,

        /**
        * Hebrew.
        */
        HE,

        /**
        * Hindi.
        */
        HI,

        /**
        * Croatian.
        */
        HR,

        /**
        * Hungarian.
        */
        HU,

        /**
        * Armenian.
        */
        HY,

        /**
        * Interlingua.
        */
        IA,

        /**
        * Indonesian.
        */
        ID,

        /**
        * Igbo.
        */
        IG,

        /**
        * Sichuan Yi.
        */
        II,

        /**
        * Icelandic.
        */
        IS,

        /**
        * Italian.
        */
        IT,

        /**
        * Japanese.
        */
        JA,

        /**
        * Javanese.
        */
        JV,

        /**
        * Georgian.
        */
        KA,

        /**
        * Kikuyu.
        */
        KI,

        /**
        * Kazakh.
        */
        KK,

        /**
        * Kalaallisut.
        */
        KL,

        /**
        * Khmer.
        */
        KM,

        /**
        * Kannada.
        */
        KN,

        /**
        * Korean.
        */
        KO,

        /**
        * Kashmiri.
        */
        KS,

        /**
        * Kurdish.
        */
        KU,

        /**
        * Cornish.
        */
        KW,

        /**
        * Kyrgyz.
        */
        KY,

        /**
        * Latin.
        */
        LA,

        /**
        * Luxembourgish.
        */
        LB,

        /**
        * Ganda.
        */
        LG,

        /**
        * Lingala.
        */
        LN,

        /**
        * Lao.
        */
        LO,

        /**
        * Lithuanian.
        */
        LT,

        /**
        * Luba-Katanga.
        */
        LU,

        /**
        * Latvian.
        */
        LV,

        /**
        * Malagasy.
        */
        MG,

        /**
        * Māori.
        */
        MI,

        /**
        * Macedonian.
        */
        MK,

        /**
        * Malayalam.
        */
        ML,

        /**
        * Mongolian.
        */
        MN,

        /**
        * Moldavian.
        */
        MO,

        /**
        * Marathi.
        */
        MR,

        /**
        * Malay.
        */
        MS,

        /**
        * Maltese.
        */
        MT,

        /**
        * Burmese.
        */
        MY,

        /**
        * Norwegian (Bokmål).
        */
        NB,

        /**
        * North Ndebele.
        */
        ND,

        /**
        * Nepali.
        */
        NE,

        /**
        * Dutch.
        */
        NL,

        /**
        * Norwegian Nynorsk.
        */
        NN,

        /**
        * Norwegian.
        */
        NO,

        /**
        * Oromo.
        */
        OM,

        /**
        * Odia.
        */
        OR,

        /**
        * Ossetic.
        */
        OS,

        /**
        * Punjabi.
        */
        PA,

        /**
        * Polish.
        */
        PL,

        /**
        * Pashto.
        */
        PS,

        /**
        * Portuguese.
        */
        PT,

        /**
        * Portuguese (Brazil).
        */
        PT_BR,

        /**
        * Portuguese (Portugal).
        */
        PT_PT,

        /**
        * Quechua.
        */
        QU,

        /**
        * Romansh.
        */
        RM,

        /**
        * Rundi.
        */
        RN,

        /**
        * Romanian.
        */
        RO,

        /**
        * Russian.
        */
        RU,

        /**
        * Kinyarwanda.
        */
        RW,

        /**
        * Sanskrit.
        */
        SA,

        /**
        * Sardinian.
        */
        SC,

        /**
        * Sindhi.
        */
        SD,

        /**
        * Northern Sami.
        */
        SE,

        /**
        * Sango.
        */
        SG,

        /**
        * Serbo-Croatian.
        */
        SH,

        /**
        * Sinhala.
        */
        SI,

        /**
        * Slovak.
        */
        SK,

        /**
        * Slovenian.
        */
        SL,

        /**
        * Shona.
        */
        SN,

        /**
        * Somali.
        */
        SO,

        /**
        * Albanian.
        */
        SQ,

        /**
        * Serbian.
        */
        SR,

        /**
        * Sundanese.
        */
        SU,

        /**
        * Swedish.
        */
        SV,

        /**
        * Swahili.
        */
        SW,

        /**
        * Tamil.
        */
        TA,

        /**
        * Telugu.
        */
        TE,

        /**
        * Tajik.
        */
        TG,

        /**
        * Thai.
        */
        TH,

        /**
        * Tigrinya.
        */
        TI,

        /**
        * Turkmen.
        */
        TK,

        /**
        * Tongan.
        */
        TO,

        /**
        * Turkish.
        */
        TR,

        /**
        * Tatar.
        */
        TT,

        /**
        * Uyghur.
        */
        UG,

        /**
        * Ukrainian.
        */
        UK,

        /**
        * Urdu.
        */
        UR,

        /**
        * Uzbek.
        */
        UZ,

        /**
        * Vietnamese.
        */
        VI,

        /**
        * Volapük.
        */
        VO,

        /**
        * Wolof.
        */
        WO,

        /**
        * Xhosa.
        */
        XH,

        /**
        * Yiddish.
        */
        YI,

        /**
        * Yoruba.
        */
        YO,

        /**
        * Chinese.
        */
        ZH,

        /**
        * Chinese (Simplified).
        */
        ZH_CN,

        /**
        * Chinese (Traditional).
        */
        ZH_TW,

        /**
        * Zulu.
        */
        ZU,

        UNKNOWN_VALUE;

        public static LanguageCode fromGraphQl(String value) {
            if (value == null) {
                return null;
            }

            switch (value) {
                case "AF": {
                    return AF;
                }

                case "AK": {
                    return AK;
                }

                case "AM": {
                    return AM;
                }

                case "AR": {
                    return AR;
                }

                case "AS": {
                    return AS;
                }

                case "AZ": {
                    return AZ;
                }

                case "BE": {
                    return BE;
                }

                case "BG": {
                    return BG;
                }

                case "BM": {
                    return BM;
                }

                case "BN": {
                    return BN;
                }

                case "BO": {
                    return BO;
                }

                case "BR": {
                    return BR;
                }

                case "BS": {
                    return BS;
                }

                case "CA": {
                    return CA;
                }

                case "CE": {
                    return CE;
                }

                case "CKB": {
                    return CKB;
                }

                case "CS": {
                    return CS;
                }

                case "CU": {
                    return CU;
                }

                case "CY": {
                    return CY;
                }

                case "DA": {
                    return DA;
                }

                case "DE": {
                    return DE;
                }

                case "DZ": {
                    return DZ;
                }

                case "EE": {
                    return EE;
                }

                case "EL": {
                    return EL;
                }

                case "EN": {
                    return EN;
                }

                case "EO": {
                    return EO;
                }

                case "ES": {
                    return ES;
                }

                case "ET": {
                    return ET;
                }

                case "EU": {
                    return EU;
                }

                case "FA": {
                    return FA;
                }

                case "FF": {
                    return FF;
                }

                case "FI": {
                    return FI;
                }

                case "FIL": {
                    return FIL;
                }

                case "FO": {
                    return FO;
                }

                case "FR": {
                    return FR;
                }

                case "FY": {
                    return FY;
                }

                case "GA": {
                    return GA;
                }

                case "GD": {
                    return GD;
                }

                case "GL": {
                    return GL;
                }

                case "GU": {
                    return GU;
                }

                case "GV": {
                    return GV;
                }

                case "HA": {
                    return HA;
                }

                case "HE": {
                    return HE;
                }

                case "HI": {
                    return HI;
                }

                case "HR": {
                    return HR;
                }

                case "HU": {
                    return HU;
                }

                case "HY": {
                    return HY;
                }

                case "IA": {
                    return IA;
                }

                case "ID": {
                    return ID;
                }

                case "IG": {
                    return IG;
                }

                case "II": {
                    return II;
                }

                case "IS": {
                    return IS;
                }

                case "IT": {
                    return IT;
                }

                case "JA": {
                    return JA;
                }

                case "JV": {
                    return JV;
                }

                case "KA": {
                    return KA;
                }

                case "KI": {
                    return KI;
                }

                case "KK": {
                    return KK;
                }

                case "KL": {
                    return KL;
                }

                case "KM": {
                    return KM;
                }

                case "KN": {
                    return KN;
                }

                case "KO": {
                    return KO;
                }

                case "KS": {
                    return KS;
                }

                case "KU": {
                    return KU;
                }

                case "KW": {
                    return KW;
                }

                case "KY": {
                    return KY;
                }

                case "LA": {
                    return LA;
                }

                case "LB": {
                    return LB;
                }

                case "LG": {
                    return LG;
                }

                case "LN": {
                    return LN;
                }

                case "LO": {
                    return LO;
                }

                case "LT": {
                    return LT;
                }

                case "LU": {
                    return LU;
                }

                case "LV": {
                    return LV;
                }

                case "MG": {
                    return MG;
                }

                case "MI": {
                    return MI;
                }

                case "MK": {
                    return MK;
                }

                case "ML": {
                    return ML;
                }

                case "MN": {
                    return MN;
                }

                case "MO": {
                    return MO;
                }

                case "MR": {
                    return MR;
                }

                case "MS": {
                    return MS;
                }

                case "MT": {
                    return MT;
                }

                case "MY": {
                    return MY;
                }

                case "NB": {
                    return NB;
                }

                case "ND": {
                    return ND;
                }

                case "NE": {
                    return NE;
                }

                case "NL": {
                    return NL;
                }

                case "NN": {
                    return NN;
                }

                case "NO": {
                    return NO;
                }

                case "OM": {
                    return OM;
                }

                case "OR": {
                    return OR;
                }

                case "OS": {
                    return OS;
                }

                case "PA": {
                    return PA;
                }

                case "PL": {
                    return PL;
                }

                case "PS": {
                    return PS;
                }

                case "PT": {
                    return PT;
                }

                case "PT_BR": {
                    return PT_BR;
                }

                case "PT_PT": {
                    return PT_PT;
                }

                case "QU": {
                    return QU;
                }

                case "RM": {
                    return RM;
                }

                case "RN": {
                    return RN;
                }

                case "RO": {
                    return RO;
                }

                case "RU": {
                    return RU;
                }

                case "RW": {
                    return RW;
                }

                case "SA": {
                    return SA;
                }

                case "SC": {
                    return SC;
                }

                case "SD": {
                    return SD;
                }

                case "SE": {
                    return SE;
                }

                case "SG": {
                    return SG;
                }

                case "SH": {
                    return SH;
                }

                case "SI": {
                    return SI;
                }

                case "SK": {
                    return SK;
                }

                case "SL": {
                    return SL;
                }

                case "SN": {
                    return SN;
                }

                case "SO": {
                    return SO;
                }

                case "SQ": {
                    return SQ;
                }

                case "SR": {
                    return SR;
                }

                case "SU": {
                    return SU;
                }

                case "SV": {
                    return SV;
                }

                case "SW": {
                    return SW;
                }

                case "TA": {
                    return TA;
                }

                case "TE": {
                    return TE;
                }

                case "TG": {
                    return TG;
                }

                case "TH": {
                    return TH;
                }

                case "TI": {
                    return TI;
                }

                case "TK": {
                    return TK;
                }

                case "TO": {
                    return TO;
                }

                case "TR": {
                    return TR;
                }

                case "TT": {
                    return TT;
                }

                case "UG": {
                    return UG;
                }

                case "UK": {
                    return UK;
                }

                case "UR": {
                    return UR;
                }

                case "UZ": {
                    return UZ;
                }

                case "VI": {
                    return VI;
                }

                case "VO": {
                    return VO;
                }

                case "WO": {
                    return WO;
                }

                case "XH": {
                    return XH;
                }

                case "YI": {
                    return YI;
                }

                case "YO": {
                    return YO;
                }

                case "ZH": {
                    return ZH;
                }

                case "ZH_CN": {
                    return ZH_CN;
                }

                case "ZH_TW": {
                    return ZH_TW;
                }

                case "ZU": {
                    return ZU;
                }

                default: {
                    return UNKNOWN_VALUE;
                }
            }
        }
        public String toString() {
            switch (this) {
                case AF: {
                    return "AF";
                }

                case AK: {
                    return "AK";
                }

                case AM: {
                    return "AM";
                }

                case AR: {
                    return "AR";
                }

                case AS: {
                    return "AS";
                }

                case AZ: {
                    return "AZ";
                }

                case BE: {
                    return "BE";
                }

                case BG: {
                    return "BG";
                }

                case BM: {
                    return "BM";
                }

                case BN: {
                    return "BN";
                }

                case BO: {
                    return "BO";
                }

                case BR: {
                    return "BR";
                }

                case BS: {
                    return "BS";
                }

                case CA: {
                    return "CA";
                }

                case CE: {
                    return "CE";
                }

                case CKB: {
                    return "CKB";
                }

                case CS: {
                    return "CS";
                }

                case CU: {
                    return "CU";
                }

                case CY: {
                    return "CY";
                }

                case DA: {
                    return "DA";
                }

                case DE: {
                    return "DE";
                }

                case DZ: {
                    return "DZ";
                }

                case EE: {
                    return "EE";
                }

                case EL: {
                    return "EL";
                }

                case EN: {
                    return "EN";
                }

                case EO: {
                    return "EO";
                }

                case ES: {
                    return "ES";
                }

                case ET: {
                    return "ET";
                }

                case EU: {
                    return "EU";
                }

                case FA: {
                    return "FA";
                }

                case FF: {
                    return "FF";
                }

                case FI: {
                    return "FI";
                }

                case FIL: {
                    return "FIL";
                }

                case FO: {
                    return "FO";
                }

                case FR: {
                    return "FR";
                }

                case FY: {
                    return "FY";
                }

                case GA: {
                    return "GA";
                }

                case GD: {
                    return "GD";
                }

                case GL: {
                    return "GL";
                }

                case GU: {
                    return "GU";
                }

                case GV: {
                    return "GV";
                }

                case HA: {
                    return "HA";
                }

                case HE: {
                    return "HE";
                }

                case HI: {
                    return "HI";
                }

                case HR: {
                    return "HR";
                }

                case HU: {
                    return "HU";
                }

                case HY: {
                    return "HY";
                }

                case IA: {
                    return "IA";
                }

                case ID: {
                    return "ID";
                }

                case IG: {
                    return "IG";
                }

                case II: {
                    return "II";
                }

                case IS: {
                    return "IS";
                }

                case IT: {
                    return "IT";
                }

                case JA: {
                    return "JA";
                }

                case JV: {
                    return "JV";
                }

                case KA: {
                    return "KA";
                }

                case KI: {
                    return "KI";
                }

                case KK: {
                    return "KK";
                }

                case KL: {
                    return "KL";
                }

                case KM: {
                    return "KM";
                }

                case KN: {
                    return "KN";
                }

                case KO: {
                    return "KO";
                }

                case KS: {
                    return "KS";
                }

                case KU: {
                    return "KU";
                }

                case KW: {
                    return "KW";
                }

                case KY: {
                    return "KY";
                }

                case LA: {
                    return "LA";
                }

                case LB: {
                    return "LB";
                }

                case LG: {
                    return "LG";
                }

                case LN: {
                    return "LN";
                }

                case LO: {
                    return "LO";
                }

                case LT: {
                    return "LT";
                }

                case LU: {
                    return "LU";
                }

                case LV: {
                    return "LV";
                }

                case MG: {
                    return "MG";
                }

                case MI: {
                    return "MI";
                }

                case MK: {
                    return "MK";
                }

                case ML: {
                    return "ML";
                }

                case MN: {
                    return "MN";
                }

                case MO: {
                    return "MO";
                }

                case MR: {
                    return "MR";
                }

                case MS: {
                    return "MS";
                }

                case MT: {
                    return "MT";
                }

                case MY: {
                    return "MY";
                }

                case NB: {
                    return "NB";
                }

                case ND: {
                    return "ND";
                }

                case NE: {
                    return "NE";
                }

                case NL: {
                    return "NL";
                }

                case NN: {
                    return "NN";
                }

                case NO: {
                    return "NO";
                }

                case OM: {
                    return "OM";
                }

                case OR: {
                    return "OR";
                }

                case OS: {
                    return "OS";
                }

                case PA: {
                    return "PA";
                }

                case PL: {
                    return "PL";
                }

                case PS: {
                    return "PS";
                }

                case PT: {
                    return "PT";
                }

                case PT_BR: {
                    return "PT_BR";
                }

                case PT_PT: {
                    return "PT_PT";
                }

                case QU: {
                    return "QU";
                }

                case RM: {
                    return "RM";
                }

                case RN: {
                    return "RN";
                }

                case RO: {
                    return "RO";
                }

                case RU: {
                    return "RU";
                }

                case RW: {
                    return "RW";
                }

                case SA: {
                    return "SA";
                }

                case SC: {
                    return "SC";
                }

                case SD: {
                    return "SD";
                }

                case SE: {
                    return "SE";
                }

                case SG: {
                    return "SG";
                }

                case SH: {
                    return "SH";
                }

                case SI: {
                    return "SI";
                }

                case SK: {
                    return "SK";
                }

                case SL: {
                    return "SL";
                }

                case SN: {
                    return "SN";
                }

                case SO: {
                    return "SO";
                }

                case SQ: {
                    return "SQ";
                }

                case SR: {
                    return "SR";
                }

                case SU: {
                    return "SU";
                }

                case SV: {
                    return "SV";
                }

                case SW: {
                    return "SW";
                }

                case TA: {
                    return "TA";
                }

                case TE: {
                    return "TE";
                }

                case TG: {
                    return "TG";
                }

                case TH: {
                    return "TH";
                }

                case TI: {
                    return "TI";
                }

                case TK: {
                    return "TK";
                }

                case TO: {
                    return "TO";
                }

                case TR: {
                    return "TR";
                }

                case TT: {
                    return "TT";
                }

                case UG: {
                    return "UG";
                }

                case UK: {
                    return "UK";
                }

                case UR: {
                    return "UR";
                }

                case UZ: {
                    return "UZ";
                }

                case VI: {
                    return "VI";
                }

                case VO: {
                    return "VO";
                }

                case WO: {
                    return "WO";
                }

                case XH: {
                    return "XH";
                }

                case YI: {
                    return "YI";
                }

                case YO: {
                    return "YO";
                }

                case ZH: {
                    return "ZH";
                }

                case ZH_CN: {
                    return "ZH_CN";
                }

                case ZH_TW: {
                    return "ZH_TW";
                }

                case ZU: {
                    return "ZU";
                }

                default: {
                    return "";
                }
            }
        }
    }

    public interface LocalizationQueryDefinition {
        void define(LocalizationQuery _queryBuilder);
    }

    /**
    * Information about the localized experiences configured for the shop.
    */
    public static class LocalizationQuery extends Query<LocalizationQuery> {
        LocalizationQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        /**
        * The list of countries with enabled localized experiences.
        */
        public LocalizationQuery availableCountries(CountryQueryDefinition queryDef) {
            startField("availableCountries");

            _queryBuilder.append('{');
            queryDef.define(new CountryQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The list of languages available for the active country.
        */
        public LocalizationQuery availableLanguages(LanguageQueryDefinition queryDef) {
            startField("availableLanguages");

            _queryBuilder.append('{');
            queryDef.define(new LanguageQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The country of the active localized experience. Use the `@inContext` directive to change this value.
        */
        public LocalizationQuery country(CountryQueryDefinition queryDef) {
            startField("country");

            _queryBuilder.append('{');
            queryDef.define(new CountryQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The language of the active localized experience. Use the `@inContext` directive to change this
        * value.
        */
        public LocalizationQuery language(LanguageQueryDefinition queryDef) {
            startField("language");

            _queryBuilder.append('{');
            queryDef.define(new LanguageQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The market including the country of the active localized experience. Use the `@inContext` directive
        * to change this value.
        */
        public LocalizationQuery market(MarketQueryDefinition queryDef) {
            startField("market");

            _queryBuilder.append('{');
            queryDef.define(new MarketQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }
    }

    /**
    * Information about the localized experiences configured for the shop.
    */
    public static class Localization extends AbstractResponse<Localization> {
        public Localization() {
        }

        public Localization(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "availableCountries": {
                        List<Country> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new Country(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "availableLanguages": {
                        List<Language> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            list1.add(new Language(jsonAsObject(element1, key)));
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "country": {
                        responseData.put(key, new Country(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "language": {
                        responseData.put(key, new Language(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "market": {
                        responseData.put(key, new Market(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public String getGraphQlTypeName() {
            return "Localization";
        }

        /**
        * The list of countries with enabled localized experiences.
        */

        public List<Country> getAvailableCountries() {
            return (List<Country>) get("availableCountries");
        }

        public Localization setAvailableCountries(List<Country> arg) {
            optimisticData.put(getKey("availableCountries"), arg);
            return this;
        }

        /**
        * The list of languages available for the active country.
        */

        public List<Language> getAvailableLanguages() {
            return (List<Language>) get("availableLanguages");
        }

        public Localization setAvailableLanguages(List<Language> arg) {
            optimisticData.put(getKey("availableLanguages"), arg);
            return this;
        }

        /**
        * The country of the active localized experience. Use the `@inContext` directive to change this value.
        */

        public Country getCountry() {
            return (Country) get("country");
        }

        public Localization setCountry(Country arg) {
            optimisticData.put(getKey("country"), arg);
            return this;
        }

        /**
        * The language of the active localized experience. Use the `@inContext` directive to change this
        * value.
        */

        public Language getLanguage() {
            return (Language) get("language");
        }

        public Localization setLanguage(Language arg) {
            optimisticData.put(getKey("language"), arg);
            return this;
        }

        /**
        * The market including the country of the active localized experience. Use the `@inContext` directive
        * to change this value.
        */

        public Market getMarket() {
            return (Market) get("market");
        }

        public Localization setMarket(Market arg) {
            optimisticData.put(getKey("market"), arg);
            return this;
        }

        public boolean unwrapsToObject(String key) {
            switch (getFieldName(key)) {
                case "availableCountries": return true;

                case "availableLanguages": return true;

                case "country": return true;

                case "language": return true;

                case "market": return true;

                default: return false;
            }
        }
    }

    public interface LocationQueryDefinition {
        void define(LocationQuery _queryBuilder);
    }

    /**
    * Represents a location where product inventory is held.
    */
    public static class LocationQuery extends Query<LocationQuery> {
        LocationQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);

            startField("id");
        }

        /**
        * The address of the location.
        */
        public LocationQuery address(LocationAddressQueryDefinition queryDef) {
            startField("address");

            _queryBuilder.append('{');
            queryDef.define(new LocationAddressQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        public class MetafieldArguments extends Arguments {
            MetafieldArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            /**
            * The container the metafield belongs to. If omitted, the app-reserved namespace will be used.
            */
            public MetafieldArguments namespace(String value) {
                if (value != null) {
                    startArgument("namespace");
                    Query.appendQuotedString(_queryBuilder, value.toString());
                }
                return this;
            }
        }

        public interface MetafieldArgumentsDefinition {
            void define(MetafieldArguments args);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public LocationQuery metafield(String key, MetafieldQueryDefinition queryDef) {
            return metafield(key, args -> {}, queryDef);
        }

        /**
        * Returns a metafield found by namespace and key.
        */
        public LocationQuery metafield(String key, MetafieldArgumentsDefinition argsDef, MetafieldQueryDefinition queryDef) {
            startField("metafield");

            _queryBuilder.append("(key:");
            Query.appendQuotedString(_queryBuilder, key.toString());

            argsDef.define(new MetafieldArguments(_queryBuilder));

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */
        public LocationQuery metafields(List<HasMetafieldsIdentifier> identifiers, MetafieldQueryDefinition queryDef) {
            startField("metafields");

            _queryBuilder.append("(identifiers:");
            _queryBuilder.append('[');
            {
                String listSeperator1 = "";
                for (HasMetafieldsIdentifier item1 : identifiers) {
                    _queryBuilder.append(listSeperator1);
                    listSeperator1 = ",";
                    item1.appendTo(_queryBuilder);
                }
            }
            _queryBuilder.append(']');

            _queryBuilder.append(')');

            _queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(_queryBuilder));
            _queryBuilder.append('}');

            return this;
        }

        /**
        * The name of the location.
        */
        public LocationQuery name() {
            startField("name");

            return this;
        }
    }

    /**
    * Represents a location where product inventory is held.
    */
    public static class Location extends AbstractResponse<Location> implements HasMetafields, MetafieldParentResource, Node {
        public Location() {
        }

        public Location(JsonObject fields) throws SchemaViolationError {
            for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
                String key = field.getKey();
                String fieldName = getFieldName(key);
                switch (fieldName) {
                    case "address": {
                        responseData.put(key, new LocationAddress(jsonAsObject(field.getValue(), key)));

                        break;
                    }

                    case "id": {
                        responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                        break;
                    }

                    case "metafield": {
                        Metafield optional1 = null;
                        if (!field.getValue().isJsonNull()) {
                            optional1 = new Metafield(jsonAsObject(field.getValue(), key));
                        }

                        responseData.put(key, optional1);

                        break;
                    }

                    case "metafields": {
                        List<Metafield> list1 = new ArrayList<>();
                        for (JsonElement element1 : jsonAsArray(field.getValue(), key)) {
                            Metafield optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = new Metafield(jsonAsObject(element1, key));
                            }

                            list1.add(optional2);
                        }

                        responseData.put(key, list1);

                        break;
                    }

                    case "name": {
                        responseData.put(key, jsonAsString(field.getValue(), key));

                        break;
                    }

                    case "__typename": {
                        responseData.put(key, jsonAsString(field.getValue(), key));
                        break;
                    }
                    default: {
                        throw new SchemaViolationError(this, key, field.getValue());
                    }
                }
            }
        }

        public Location(ID id) {
            this();
            optimisticData.put("id", id);
        }

        public String getGraphQlTypeName() {
            return "Location";
        }

        /**
        * The address of the location.
        */

        public LocationAddress getAddress() {
            return (LocationAddress) get("address");
        }

        public Location setAddress(LocationAddress arg) {
            optimisticData.put(getKey("address"), arg);
            return this;
        }

        /**
        * A globally-unique ID.
        */

        public ID getId() {
            return (ID) get("id");
        }

        /**
        * Returns a metafield found by namespace and key.
        */

        public Metafield getMetafield() {
            return (Metafield) get("metafield");
        }

        public Location setMetafield(Metafield arg) {
            optimisticData.put(getKey("metafield"), arg);
            return this;
        }

        /**
        * The metafields associated with the resource matching the supplied list of namespaces and keys.
        */

        public List<Metafield> getMetafields() {
            return (List<Metafield>) get("metafields");
        }

        public Location setMetafields(List<Metafield> arg) {
            optimisticData.put(getKey("metafields"), arg);
            return this;
        }

        /**
    