/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy3;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shopify.buy3.Utils;
import com.shopify.graphql.support.AbstractResponse;
import com.shopify.graphql.support.Arguments;
import com.shopify.graphql.support.Directive;
import com.shopify.graphql.support.Error;
import com.shopify.graphql.support.ID;
import com.shopify.graphql.support.Input;
import com.shopify.graphql.support.Query;
import com.shopify.graphql.support.SchemaViolationError;
import com.shopify.graphql.support.TopLevelResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class Storefront {
    public static final String API_VERSION = "2024-07";

    public static QueryRootQuery query(QueryRootQueryDefinition queryDef) {
        return Storefront.query(Collections.emptyList(), queryDef);
    }

    public static QueryRootQuery query(List<Directive> directives, QueryRootQueryDefinition queryDef) {
        StringBuilder queryString = new StringBuilder("query");
        for (Directive directive : directives) {
            queryString.append(" " + directive.toString());
        }
        queryString.append(" {");
        QueryRootQuery query = new QueryRootQuery(queryString);
        queryDef.define(query);
        queryString.append('}');
        return query;
    }

    public static MutationQuery mutation(MutationQueryDefinition queryDef) {
        return Storefront.mutation(Collections.emptyList(), queryDef);
    }

    public static MutationQuery mutation(List<Directive> directives, MutationQueryDefinition queryDef) {
        StringBuilder queryString = new StringBuilder("mutation");
        for (Directive directive : directives) {
            queryString.append(" " + directive.toString());
        }
        queryString.append(" {");
        MutationQuery query = new MutationQuery(queryString);
        queryDef.define(query);
        queryString.append('}');
        return query;
    }

    public static enum WeightUnit {
        GRAMS,
        KILOGRAMS,
        OUNCES,
        POUNDS,
        UNKNOWN_VALUE;


        public static WeightUnit fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "GRAMS": {
                    return GRAMS;
                }
                case "KILOGRAMS": {
                    return KILOGRAMS;
                }
                case "OUNCES": {
                    return OUNCES;
                }
                case "POUNDS": {
                    return POUNDS;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case GRAMS: {
                    return "GRAMS";
                }
                case KILOGRAMS: {
                    return "KILOGRAMS";
                }
                case OUNCES: {
                    return "OUNCES";
                }
                case POUNDS: {
                    return "POUNDS";
                }
            }
            return "";
        }
    }

    public static class VideoSource
    extends AbstractResponse<VideoSource> {
        public VideoSource() {
        }

        public VideoSource(JsonObject fields) throws SchemaViolationError {
            block16: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "format": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "height": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "mimeType": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "url": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "width": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "VideoSource";
        }

        public String getFormat() {
            return (String)this.get("format");
        }

        public VideoSource setFormat(String arg) {
            this.optimisticData.put(this.getKey("format"), arg);
            return this;
        }

        public Integer getHeight() {
            return (Integer)this.get("height");
        }

        public VideoSource setHeight(Integer arg) {
            this.optimisticData.put(this.getKey("height"), arg);
            return this;
        }

        public String getMimeType() {
            return (String)this.get("mimeType");
        }

        public VideoSource setMimeType(String arg) {
            this.optimisticData.put(this.getKey("mimeType"), arg);
            return this;
        }

        public String getUrl() {
            return (String)this.get("url");
        }

        public VideoSource setUrl(String arg) {
            this.optimisticData.put(this.getKey("url"), arg);
            return this;
        }

        public Integer getWidth() {
            return (Integer)this.get("width");
        }

        public VideoSource setWidth(Integer arg) {
            this.optimisticData.put(this.getKey("width"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "format": {
                    return false;
                }
                case "height": {
                    return false;
                }
                case "mimeType": {
                    return false;
                }
                case "url": {
                    return false;
                }
                case "width": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class VideoSourceQuery
    extends Query<VideoSourceQuery> {
        VideoSourceQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public VideoSourceQuery format() {
            this.startField("format");
            return this;
        }

        public VideoSourceQuery height() {
            this.startField("height");
            return this;
        }

        public VideoSourceQuery mimeType() {
            this.startField("mimeType");
            return this;
        }

        public VideoSourceQuery url() {
            this.startField("url");
            return this;
        }

        public VideoSourceQuery width() {
            this.startField("width");
            return this;
        }
    }

    public static interface VideoSourceQueryDefinition {
        public void define(VideoSourceQuery var1);
    }

    public static class Video
    extends AbstractResponse<Video>
    implements Media,
    MetafieldReference,
    Node {
        public Video() {
        }

        public Video(JsonObject fields) throws SchemaViolationError {
            block18: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "alt": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block18;
                    }
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block18;
                    }
                    case "mediaContentType": {
                        this.responseData.put(key, MediaContentType.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block18;
                    }
                    case "presentation": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MediaPresentation(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block18;
                    }
                    case "previewImage": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Image(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block18;
                    }
                    case "sources": {
                        ArrayList<VideoSource> list1 = new ArrayList<VideoSource>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new VideoSource(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block18;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block18;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public Video(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "Video";
        }

        @Override
        public String getAlt() {
            return (String)this.get("alt");
        }

        public Video setAlt(String arg) {
            this.optimisticData.put(this.getKey("alt"), arg);
            return this;
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        @Override
        public MediaContentType getMediaContentType() {
            return (MediaContentType)((Object)this.get("mediaContentType"));
        }

        public Video setMediaContentType(MediaContentType arg) {
            this.optimisticData.put(this.getKey("mediaContentType"), arg);
            return this;
        }

        @Override
        public MediaPresentation getPresentation() {
            return (MediaPresentation)this.get("presentation");
        }

        public Video setPresentation(MediaPresentation arg) {
            this.optimisticData.put(this.getKey("presentation"), arg);
            return this;
        }

        @Override
        public Image getPreviewImage() {
            return (Image)this.get("previewImage");
        }

        public Video setPreviewImage(Image arg) {
            this.optimisticData.put(this.getKey("previewImage"), arg);
            return this;
        }

        public List<VideoSource> getSources() {
            return (List)this.get("sources");
        }

        public Video setSources(List<VideoSource> arg) {
            this.optimisticData.put(this.getKey("sources"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "alt": {
                    return false;
                }
                case "id": {
                    return false;
                }
                case "mediaContentType": {
                    return false;
                }
                case "presentation": {
                    return true;
                }
                case "previewImage": {
                    return true;
                }
                case "sources": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class VideoQuery
    extends Query<VideoQuery> {
        VideoQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public VideoQuery alt() {
            this.startField("alt");
            return this;
        }

        public VideoQuery mediaContentType() {
            this.startField("mediaContentType");
            return this;
        }

        public VideoQuery presentation(MediaPresentationQueryDefinition queryDef) {
            this.startField("presentation");
            this._queryBuilder.append('{');
            queryDef.define(new MediaPresentationQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public VideoQuery previewImage(ImageQueryDefinition queryDef) {
            this.startField("previewImage");
            this._queryBuilder.append('{');
            queryDef.define(new ImageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public VideoQuery sources(VideoSourceQueryDefinition queryDef) {
            this.startField("sources");
            this._queryBuilder.append('{');
            queryDef.define(new VideoSourceQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface VideoQueryDefinition {
        public void define(VideoQuery var1);
    }

    public static class VariantOptionFilter
    implements Serializable {
        private String name;
        private String value;

        public VariantOptionFilter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public VariantOptionFilter setName(String name) {
            this.name = name;
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public VariantOptionFilter setValue(String value) {
            this.value = value;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("name:");
            Query.appendQuotedString(_queryBuilder, this.name.toString());
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("value:");
            Query.appendQuotedString(_queryBuilder, this.value.toString());
            _queryBuilder.append('}');
        }
    }

    public static enum UserErrorsShopPayPaymentRequestSessionUserErrorsCode {
        IDEMPOTENCY_KEY_ALREADY_USED,
        PAYMENT_REQUEST_INVALID_INPUT,
        PAYMENT_REQUEST_NOT_FOUND,
        UNKNOWN_VALUE;


        public static UserErrorsShopPayPaymentRequestSessionUserErrorsCode fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "IDEMPOTENCY_KEY_ALREADY_USED": {
                    return IDEMPOTENCY_KEY_ALREADY_USED;
                }
                case "PAYMENT_REQUEST_INVALID_INPUT": {
                    return PAYMENT_REQUEST_INVALID_INPUT;
                }
                case "PAYMENT_REQUEST_NOT_FOUND": {
                    return PAYMENT_REQUEST_NOT_FOUND;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case IDEMPOTENCY_KEY_ALREADY_USED: {
                    return "IDEMPOTENCY_KEY_ALREADY_USED";
                }
                case PAYMENT_REQUEST_INVALID_INPUT: {
                    return "PAYMENT_REQUEST_INVALID_INPUT";
                }
                case PAYMENT_REQUEST_NOT_FOUND: {
                    return "PAYMENT_REQUEST_NOT_FOUND";
                }
            }
            return "";
        }
    }

    public static class UserErrorsShopPayPaymentRequestSessionUserErrors
    extends AbstractResponse<UserErrorsShopPayPaymentRequestSessionUserErrors>
    implements DisplayableError {
        public UserErrorsShopPayPaymentRequestSessionUserErrors() {
        }

        public UserErrorsShopPayPaymentRequestSessionUserErrors(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "code": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = UserErrorsShopPayPaymentRequestSessionUserErrorsCode.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block12;
                    }
                    case "field": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            ArrayList<String> list1 = new ArrayList<String>();
                            for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                                list1.add(this.jsonAsString(element1, key));
                            }
                            optional1 = list1;
                        }
                        this.responseData.put(key, optional1);
                        continue block12;
                    }
                    case "message": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "UserErrorsShopPayPaymentRequestSessionUserErrors";
        }

        public UserErrorsShopPayPaymentRequestSessionUserErrorsCode getCode() {
            return (UserErrorsShopPayPaymentRequestSessionUserErrorsCode)((Object)this.get("code"));
        }

        public UserErrorsShopPayPaymentRequestSessionUserErrors setCode(UserErrorsShopPayPaymentRequestSessionUserErrorsCode arg) {
            this.optimisticData.put(this.getKey("code"), arg);
            return this;
        }

        @Override
        public List<String> getField() {
            return (List)this.get("field");
        }

        public UserErrorsShopPayPaymentRequestSessionUserErrors setField(List<String> arg) {
            this.optimisticData.put(this.getKey("field"), arg);
            return this;
        }

        @Override
        public String getMessage() {
            return (String)this.get("message");
        }

        public UserErrorsShopPayPaymentRequestSessionUserErrors setMessage(String arg) {
            this.optimisticData.put(this.getKey("message"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "code": {
                    return false;
                }
                case "field": {
                    return false;
                }
                case "message": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class UserErrorsShopPayPaymentRequestSessionUserErrorsQuery
    extends Query<UserErrorsShopPayPaymentRequestSessionUserErrorsQuery> {
        UserErrorsShopPayPaymentRequestSessionUserErrorsQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public UserErrorsShopPayPaymentRequestSessionUserErrorsQuery code() {
            this.startField("code");
            return this;
        }

        public UserErrorsShopPayPaymentRequestSessionUserErrorsQuery field() {
            this.startField("field");
            return this;
        }

        public UserErrorsShopPayPaymentRequestSessionUserErrorsQuery message() {
            this.startField("message");
            return this;
        }
    }

    public static interface UserErrorsShopPayPaymentRequestSessionUserErrorsQueryDefinition {
        public void define(UserErrorsShopPayPaymentRequestSessionUserErrorsQuery var1);
    }

    public static class UserError
    extends AbstractResponse<UserError>
    implements DisplayableError {
        public UserError() {
        }

        public UserError(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "field": {
                        ArrayList<String> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            ArrayList<String> list1 = new ArrayList<String>();
                            for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                                list1.add(this.jsonAsString(element1, key));
                            }
                            optional1 = list1;
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "message": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "UserError";
        }

        @Override
        public List<String> getField() {
            return (List)this.get("field");
        }

        public UserError setField(List<String> arg) {
            this.optimisticData.put(this.getKey("field"), arg);
            return this;
        }

        @Override
        public String getMessage() {
            return (String)this.get("message");
        }

        public UserError setMessage(String arg) {
            this.optimisticData.put(this.getKey("message"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "field": {
                    return false;
                }
                case "message": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class UserErrorQuery
    extends Query<UserErrorQuery> {
        UserErrorQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public UserErrorQuery field() {
            this.startField("field");
            return this;
        }

        public UserErrorQuery message() {
            this.startField("message");
            return this;
        }
    }

    public static interface UserErrorQueryDefinition {
        public void define(UserErrorQuery var1);
    }

    public static class UrlRedirectEdge
    extends AbstractResponse<UrlRedirectEdge> {
        public UrlRedirectEdge() {
        }

        public UrlRedirectEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, new UrlRedirect(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "UrlRedirectEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public UrlRedirectEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public UrlRedirect getNode() {
            return (UrlRedirect)this.get("node");
        }

        public UrlRedirectEdge setNode(UrlRedirect arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class UrlRedirectEdgeQuery
    extends Query<UrlRedirectEdgeQuery> {
        UrlRedirectEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public UrlRedirectEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public UrlRedirectEdgeQuery node(UrlRedirectQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new UrlRedirectQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface UrlRedirectEdgeQueryDefinition {
        public void define(UrlRedirectEdgeQuery var1);
    }

    public static class UrlRedirectConnection
    extends AbstractResponse<UrlRedirectConnection> {
        public UrlRedirectConnection() {
        }

        public UrlRedirectConnection(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new UrlRedirectEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "nodes": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new UrlRedirect(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "UrlRedirectConnection";
        }

        public List<UrlRedirectEdge> getEdges() {
            return (List)this.get("edges");
        }

        public UrlRedirectConnection setEdges(List<UrlRedirectEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<UrlRedirect> getNodes() {
            return (List)this.get("nodes");
        }

        public UrlRedirectConnection setNodes(List<UrlRedirect> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public UrlRedirectConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "nodes": {
                    return true;
                }
                case "pageInfo": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class UrlRedirectConnectionQuery
    extends Query<UrlRedirectConnectionQuery> {
        UrlRedirectConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public UrlRedirectConnectionQuery edges(UrlRedirectEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new UrlRedirectEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public UrlRedirectConnectionQuery nodes(UrlRedirectQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new UrlRedirectQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public UrlRedirectConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface UrlRedirectConnectionQueryDefinition {
        public void define(UrlRedirectConnectionQuery var1);
    }

    public static class UrlRedirect
    extends AbstractResponse<UrlRedirect>
    implements Node {
        public UrlRedirect() {
        }

        public UrlRedirect(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "path": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                    case "target": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public UrlRedirect(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "UrlRedirect";
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        public String getPath() {
            return (String)this.get("path");
        }

        public UrlRedirect setPath(String arg) {
            this.optimisticData.put(this.getKey("path"), arg);
            return this;
        }

        public String getTarget() {
            return (String)this.get("target");
        }

        public UrlRedirect setTarget(String arg) {
            this.optimisticData.put(this.getKey("target"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "id": {
                    return false;
                }
                case "path": {
                    return false;
                }
                case "target": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class UrlRedirectQuery
    extends Query<UrlRedirectQuery> {
        UrlRedirectQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public UrlRedirectQuery path() {
            this.startField("path");
            return this;
        }

        public UrlRedirectQuery target() {
            this.startField("target");
            return this;
        }
    }

    public static interface UrlRedirectQueryDefinition {
        public void define(UrlRedirectQuery var1);
    }

    public static enum UnitSystem {
        IMPERIAL_SYSTEM,
        METRIC_SYSTEM,
        UNKNOWN_VALUE;


        public static UnitSystem fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "IMPERIAL_SYSTEM": {
                    return IMPERIAL_SYSTEM;
                }
                case "METRIC_SYSTEM": {
                    return METRIC_SYSTEM;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case IMPERIAL_SYSTEM: {
                    return "IMPERIAL_SYSTEM";
                }
                case METRIC_SYSTEM: {
                    return "METRIC_SYSTEM";
                }
            }
            return "";
        }
    }

    public static enum UnitPriceMeasurementMeasuredUnit {
        CL,
        CM,
        G,
        KG,
        L,
        M,
        M2,
        M3,
        MG,
        ML,
        MM,
        UNKNOWN_VALUE;


        public static UnitPriceMeasurementMeasuredUnit fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "CL": {
                    return CL;
                }
                case "CM": {
                    return CM;
                }
                case "G": {
                    return G;
                }
                case "KG": {
                    return KG;
                }
                case "L": {
                    return L;
                }
                case "M": {
                    return M;
                }
                case "M2": {
                    return M2;
                }
                case "M3": {
                    return M3;
                }
                case "MG": {
                    return MG;
                }
                case "ML": {
                    return ML;
                }
                case "MM": {
                    return MM;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case CL: {
                    return "CL";
                }
                case CM: {
                    return "CM";
                }
                case G: {
                    return "G";
                }
                case KG: {
                    return "KG";
                }
                case L: {
                    return "L";
                }
                case M: {
                    return "M";
                }
                case M2: {
                    return "M2";
                }
                case M3: {
                    return "M3";
                }
                case MG: {
                    return "MG";
                }
                case ML: {
                    return "ML";
                }
                case MM: {
                    return "MM";
                }
            }
            return "";
        }
    }

    public static enum UnitPriceMeasurementMeasuredType {
        AREA,
        LENGTH,
        VOLUME,
        WEIGHT,
        UNKNOWN_VALUE;


        public static UnitPriceMeasurementMeasuredType fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "AREA": {
                    return AREA;
                }
                case "LENGTH": {
                    return LENGTH;
                }
                case "VOLUME": {
                    return VOLUME;
                }
                case "WEIGHT": {
                    return WEIGHT;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case AREA: {
                    return "AREA";
                }
                case LENGTH: {
                    return "LENGTH";
                }
                case VOLUME: {
                    return "VOLUME";
                }
                case WEIGHT: {
                    return "WEIGHT";
                }
            }
            return "";
        }
    }

    public static class UnitPriceMeasurement
    extends AbstractResponse<UnitPriceMeasurement> {
        public UnitPriceMeasurement() {
        }

        public UnitPriceMeasurement(JsonObject fields) throws SchemaViolationError {
            block16: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "measuredType": {
                        Enum optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = UnitPriceMeasurementMeasuredType.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block16;
                    }
                    case "quantityUnit": {
                        Enum optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = UnitPriceMeasurementMeasuredUnit.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block16;
                    }
                    case "quantityValue": {
                        this.responseData.put(key, this.jsonAsDouble((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "referenceUnit": {
                        Enum optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = UnitPriceMeasurementMeasuredUnit.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block16;
                    }
                    case "referenceValue": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "UnitPriceMeasurement";
        }

        public UnitPriceMeasurementMeasuredType getMeasuredType() {
            return (UnitPriceMeasurementMeasuredType)((Object)this.get("measuredType"));
        }

        public UnitPriceMeasurement setMeasuredType(UnitPriceMeasurementMeasuredType arg) {
            this.optimisticData.put(this.getKey("measuredType"), arg);
            return this;
        }

        public UnitPriceMeasurementMeasuredUnit getQuantityUnit() {
            return (UnitPriceMeasurementMeasuredUnit)((Object)this.get("quantityUnit"));
        }

        public UnitPriceMeasurement setQuantityUnit(UnitPriceMeasurementMeasuredUnit arg) {
            this.optimisticData.put(this.getKey("quantityUnit"), arg);
            return this;
        }

        public Double getQuantityValue() {
            return (Double)this.get("quantityValue");
        }

        public UnitPriceMeasurement setQuantityValue(Double arg) {
            this.optimisticData.put(this.getKey("quantityValue"), arg);
            return this;
        }

        public UnitPriceMeasurementMeasuredUnit getReferenceUnit() {
            return (UnitPriceMeasurementMeasuredUnit)((Object)this.get("referenceUnit"));
        }

        public UnitPriceMeasurement setReferenceUnit(UnitPriceMeasurementMeasuredUnit arg) {
            this.optimisticData.put(this.getKey("referenceUnit"), arg);
            return this;
        }

        public Integer getReferenceValue() {
            return (Integer)this.get("referenceValue");
        }

        public UnitPriceMeasurement setReferenceValue(Integer arg) {
            this.optimisticData.put(this.getKey("referenceValue"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "measuredType": {
                    return false;
                }
                case "quantityUnit": {
                    return false;
                }
                case "quantityValue": {
                    return false;
                }
                case "referenceUnit": {
                    return false;
                }
                case "referenceValue": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class UnitPriceMeasurementQuery
    extends Query<UnitPriceMeasurementQuery> {
        UnitPriceMeasurementQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public UnitPriceMeasurementQuery measuredType() {
            this.startField("measuredType");
            return this;
        }

        public UnitPriceMeasurementQuery quantityUnit() {
            this.startField("quantityUnit");
            return this;
        }

        public UnitPriceMeasurementQuery quantityValue() {
            this.startField("quantityValue");
            return this;
        }

        public UnitPriceMeasurementQuery referenceUnit() {
            this.startField("referenceUnit");
            return this;
        }

        public UnitPriceMeasurementQuery referenceValue() {
            this.startField("referenceValue");
            return this;
        }
    }

    public static interface UnitPriceMeasurementQueryDefinition {
        public void define(UnitPriceMeasurementQuery var1);
    }

    public static class UnknownTrackable
    extends AbstractResponse<UnknownTrackable>
    implements Trackable {
        public UnknownTrackable() {
        }

        public UnknownTrackable(JsonObject fields) throws SchemaViolationError {
            block8: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "trackingParameters": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block8;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public static Trackable create(JsonObject fields) throws SchemaViolationError {
            String typeName;
            switch (typeName = fields.getAsJsonPrimitive("__typename").getAsString()) {
                case "Article": {
                    return new Article(fields);
                }
                case "Collection": {
                    return new Collection(fields);
                }
                case "Page": {
                    return new Page(fields);
                }
                case "Product": {
                    return new Product(fields);
                }
                case "SearchQuerySuggestion": {
                    return new SearchQuerySuggestion(fields);
                }
            }
            return new UnknownTrackable(fields);
        }

        @Override
        public String getGraphQlTypeName() {
            return (String)this.get("__typename");
        }

        @Override
        public String getTrackingParameters() {
            return (String)this.get("trackingParameters");
        }

        public UnknownTrackable setTrackingParameters(String arg) {
            this.optimisticData.put(this.getKey("trackingParameters"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "trackingParameters": {
                    return false;
                }
            }
            return false;
        }
    }

    public static interface Trackable {
        public String getGraphQlTypeName();

        public String getTrackingParameters();
    }

    public static class TrackableQuery
    extends Query<TrackableQuery> {
        TrackableQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("__typename");
        }

        public TrackableQuery trackingParameters() {
            this.startField("trackingParameters");
            return this;
        }

        public TrackableQuery onArticle(ArticleQueryDefinition queryDef) {
            this.startInlineFragment("Article");
            queryDef.define(new ArticleQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public TrackableQuery onCollection(CollectionQueryDefinition queryDef) {
            this.startInlineFragment("Collection");
            queryDef.define(new CollectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public TrackableQuery onPage(PageQueryDefinition queryDef) {
            this.startInlineFragment("Page");
            queryDef.define(new PageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public TrackableQuery onProduct(ProductQueryDefinition queryDef) {
            this.startInlineFragment("Product");
            queryDef.define(new ProductQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public TrackableQuery onSearchQuerySuggestion(SearchQuerySuggestionQueryDefinition queryDef) {
            this.startInlineFragment("SearchQuerySuggestion");
            queryDef.define(new SearchQuerySuggestionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface TrackableQueryDefinition {
        public void define(TrackableQuery var1);
    }

    public static class Swatch
    extends AbstractResponse<Swatch> {
        public Swatch() {
        }

        public Swatch(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "color": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "image": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MediaImage(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "Swatch";
        }

        public String getColor() {
            return (String)this.get("color");
        }

        public Swatch setColor(String arg) {
            this.optimisticData.put(this.getKey("color"), arg);
            return this;
        }

        public MediaImage getImage() {
            return (MediaImage)this.get("image");
        }

        public Swatch setImage(MediaImage arg) {
            this.optimisticData.put(this.getKey("image"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "color": {
                    return false;
                }
                case "image": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class SwatchQuery
    extends Query<SwatchQuery> {
        SwatchQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SwatchQuery color() {
            this.startField("color");
            return this;
        }

        public SwatchQuery image(MediaImageQueryDefinition queryDef) {
            this.startField("image");
            this._queryBuilder.append('{');
            queryDef.define(new MediaImageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SwatchQueryDefinition {
        public void define(SwatchQuery var1);
    }

    public static class SubmitThrottled
    extends AbstractResponse<SubmitThrottled>
    implements CartSubmitForCompletionResult {
        public SubmitThrottled() {
        }

        public SubmitThrottled(JsonObject fields) throws SchemaViolationError {
            block8: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "pollAfter": {
                        this.responseData.put(key, Utils.parseDateTime(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block8;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "SubmitThrottled";
        }

        public DateTime getPollAfter() {
            return (DateTime)this.get("pollAfter");
        }

        public SubmitThrottled setPollAfter(DateTime arg) {
            this.optimisticData.put(this.getKey("pollAfter"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "pollAfter": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SubmitThrottledQuery
    extends Query<SubmitThrottledQuery> {
        SubmitThrottledQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SubmitThrottledQuery pollAfter() {
            this.startField("pollAfter");
            return this;
        }
    }

    public static interface SubmitThrottledQueryDefinition {
        public void define(SubmitThrottledQuery var1);
    }

    public static class SubmitSuccess
    extends AbstractResponse<SubmitSuccess>
    implements CartSubmitForCompletionResult {
        public SubmitSuccess() {
        }

        public SubmitSuccess(JsonObject fields) throws SchemaViolationError {
            block8: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "attemptId": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "SubmitSuccess";
        }

        public String getAttemptId() {
            return (String)this.get("attemptId");
        }

        public SubmitSuccess setAttemptId(String arg) {
            this.optimisticData.put(this.getKey("attemptId"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "attemptId": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SubmitSuccessQuery
    extends Query<SubmitSuccessQuery> {
        SubmitSuccessQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SubmitSuccessQuery attemptId() {
            this.startField("attemptId");
            return this;
        }
    }

    public static interface SubmitSuccessQueryDefinition {
        public void define(SubmitSuccessQuery var1);
    }

    public static class SubmitFailed
    extends AbstractResponse<SubmitFailed>
    implements CartSubmitForCompletionResult {
        public SubmitFailed() {
        }

        public SubmitFailed(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "checkoutUrl": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "errors": {
                        ArrayList<SubmissionError> list1 = new ArrayList<SubmissionError>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new SubmissionError(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "SubmitFailed";
        }

        public String getCheckoutUrl() {
            return (String)this.get("checkoutUrl");
        }

        public SubmitFailed setCheckoutUrl(String arg) {
            this.optimisticData.put(this.getKey("checkoutUrl"), arg);
            return this;
        }

        public List<SubmissionError> getErrors() {
            return (List)this.get("errors");
        }

        public SubmitFailed setErrors(List<SubmissionError> arg) {
            this.optimisticData.put(this.getKey("errors"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "checkoutUrl": {
                    return false;
                }
                case "errors": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class SubmitFailedQuery
    extends Query<SubmitFailedQuery> {
        SubmitFailedQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SubmitFailedQuery checkoutUrl() {
            this.startField("checkoutUrl");
            return this;
        }

        public SubmitFailedQuery errors(SubmissionErrorQueryDefinition queryDef) {
            this.startField("errors");
            this._queryBuilder.append('{');
            queryDef.define(new SubmissionErrorQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SubmitFailedQueryDefinition {
        public void define(SubmitFailedQuery var1);
    }

    public static class SubmitAlreadyAccepted
    extends AbstractResponse<SubmitAlreadyAccepted>
    implements CartSubmitForCompletionResult {
        public SubmitAlreadyAccepted() {
        }

        public SubmitAlreadyAccepted(JsonObject fields) throws SchemaViolationError {
            block8: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "attemptId": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "SubmitAlreadyAccepted";
        }

        public String getAttemptId() {
            return (String)this.get("attemptId");
        }

        public SubmitAlreadyAccepted setAttemptId(String arg) {
            this.optimisticData.put(this.getKey("attemptId"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "attemptId": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SubmitAlreadyAcceptedQuery
    extends Query<SubmitAlreadyAcceptedQuery> {
        SubmitAlreadyAcceptedQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SubmitAlreadyAcceptedQuery attemptId() {
            this.startField("attemptId");
            return this;
        }
    }

    public static interface SubmitAlreadyAcceptedQueryDefinition {
        public void define(SubmitAlreadyAcceptedQuery var1);
    }

    public static enum SubmissionErrorCode {
        BUYER_IDENTITY_EMAIL_IS_INVALID,
        BUYER_IDENTITY_EMAIL_REQUIRED,
        BUYER_IDENTITY_PHONE_IS_INVALID,
        DELIVERY_ADDRESS1_INVALID,
        DELIVERY_ADDRESS1_REQUIRED,
        DELIVERY_ADDRESS1_TOO_LONG,
        DELIVERY_ADDRESS2_INVALID,
        DELIVERY_ADDRESS2_REQUIRED,
        DELIVERY_ADDRESS2_TOO_LONG,
        DELIVERY_ADDRESS_REQUIRED,
        DELIVERY_CITY_INVALID,
        DELIVERY_CITY_REQUIRED,
        DELIVERY_CITY_TOO_LONG,
        DELIVERY_COMPANY_INVALID,
        DELIVERY_COMPANY_REQUIRED,
        DELIVERY_COMPANY_TOO_LONG,
        DELIVERY_COUNTRY_REQUIRED,
        DELIVERY_FIRST_NAME_INVALID,
        DELIVERY_FIRST_NAME_REQUIRED,
        DELIVERY_FIRST_NAME_TOO_LONG,
        DELIVERY_INVALID_POSTAL_CODE_FOR_COUNTRY,
        DELIVERY_INVALID_POSTAL_CODE_FOR_ZONE,
        DELIVERY_LAST_NAME_INVALID,
        DELIVERY_LAST_NAME_REQUIRED,
        DELIVERY_LAST_NAME_TOO_LONG,
        DELIVERY_NO_DELIVERY_AVAILABLE,
        DELIVERY_NO_DELIVERY_AVAILABLE_FOR_MERCHANDISE_LINE,
        DELIVERY_OPTIONS_PHONE_NUMBER_INVALID,
        DELIVERY_OPTIONS_PHONE_NUMBER_REQUIRED,
        DELIVERY_PHONE_NUMBER_INVALID,
        DELIVERY_PHONE_NUMBER_REQUIRED,
        DELIVERY_POSTAL_CODE_INVALID,
        DELIVERY_POSTAL_CODE_REQUIRED,
        DELIVERY_ZONE_NOT_FOUND,
        DELIVERY_ZONE_REQUIRED_FOR_COUNTRY,
        ERROR,
        MERCHANDISE_LINE_LIMIT_REACHED,
        MERCHANDISE_NOT_APPLICABLE,
        MERCHANDISE_NOT_ENOUGH_STOCK_AVAILABLE,
        MERCHANDISE_OUT_OF_STOCK,
        MERCHANDISE_PRODUCT_NOT_PUBLISHED,
        NO_DELIVERY_GROUP_SELECTED,
        PAYMENTS_ADDRESS1_INVALID,
        PAYMENTS_ADDRESS1_REQUIRED,
        PAYMENTS_ADDRESS1_TOO_LONG,
        PAYMENTS_ADDRESS2_INVALID,
        PAYMENTS_ADDRESS2_REQUIRED,
        PAYMENTS_ADDRESS2_TOO_LONG,
        PAYMENTS_BILLING_ADDRESS_ZONE_NOT_FOUND,
        PAYMENTS_BILLING_ADDRESS_ZONE_REQUIRED_FOR_COUNTRY,
        PAYMENTS_CITY_INVALID,
        PAYMENTS_CITY_REQUIRED,
        PAYMENTS_CITY_TOO_LONG,
        PAYMENTS_COMPANY_INVALID,
        PAYMENTS_COMPANY_REQUIRED,
        PAYMENTS_COMPANY_TOO_LONG,
        PAYMENTS_COUNTRY_REQUIRED,
        PAYMENTS_CREDIT_CARD_BASE_EXPIRED,
        PAYMENTS_CREDIT_CARD_BASE_GATEWAY_NOT_SUPPORTED,
        PAYMENTS_CREDIT_CARD_BASE_INVALID_START_DATE_OR_ISSUE_NUMBER_FOR_DEBIT,
        PAYMENTS_CREDIT_CARD_BRAND_NOT_SUPPORTED,
        PAYMENTS_CREDIT_CARD_FIRST_NAME_BLANK,
        PAYMENTS_CREDIT_CARD_GENERIC,
        PAYMENTS_CREDIT_CARD_LAST_NAME_BLANK,
        PAYMENTS_CREDIT_CARD_MONTH_INCLUSION,
        PAYMENTS_CREDIT_CARD_NAME_INVALID,
        PAYMENTS_CREDIT_CARD_NUMBER_INVALID,
        PAYMENTS_CREDIT_CARD_NUMBER_INVALID_FORMAT,
        PAYMENTS_CREDIT_CARD_SESSION_ID,
        PAYMENTS_CREDIT_CARD_VERIFICATION_VALUE_BLANK,
        PAYMENTS_CREDIT_CARD_VERIFICATION_VALUE_INVALID_FOR_CARD_TYPE,
        PAYMENTS_CREDIT_CARD_YEAR_EXPIRED,
        PAYMENTS_CREDIT_CARD_YEAR_INVALID_EXPIRY_YEAR,
        PAYMENTS_FIRST_NAME_INVALID,
        PAYMENTS_FIRST_NAME_REQUIRED,
        PAYMENTS_FIRST_NAME_TOO_LONG,
        PAYMENTS_INVALID_POSTAL_CODE_FOR_COUNTRY,
        PAYMENTS_INVALID_POSTAL_CODE_FOR_ZONE,
        PAYMENTS_LAST_NAME_INVALID,
        PAYMENTS_LAST_NAME_REQUIRED,
        PAYMENTS_LAST_NAME_TOO_LONG,
        PAYMENTS_METHOD_REQUIRED,
        PAYMENTS_METHOD_UNAVAILABLE,
        PAYMENTS_PHONE_NUMBER_INVALID,
        PAYMENTS_PHONE_NUMBER_REQUIRED,
        PAYMENTS_POSTAL_CODE_INVALID,
        PAYMENTS_POSTAL_CODE_REQUIRED,
        PAYMENTS_SHOPIFY_PAYMENTS_REQUIRED,
        PAYMENTS_UNACCEPTABLE_PAYMENT_AMOUNT,
        PAYMENTS_WALLET_CONTENT_MISSING,
        TAXES_DELIVERY_GROUP_ID_NOT_FOUND,
        TAXES_LINE_ID_NOT_FOUND,
        TAXES_MUST_BE_DEFINED,
        UNKNOWN_VALUE;


        public static SubmissionErrorCode fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "BUYER_IDENTITY_EMAIL_IS_INVALID": {
                    return BUYER_IDENTITY_EMAIL_IS_INVALID;
                }
                case "BUYER_IDENTITY_EMAIL_REQUIRED": {
                    return BUYER_IDENTITY_EMAIL_REQUIRED;
                }
                case "BUYER_IDENTITY_PHONE_IS_INVALID": {
                    return BUYER_IDENTITY_PHONE_IS_INVALID;
                }
                case "DELIVERY_ADDRESS1_INVALID": {
                    return DELIVERY_ADDRESS1_INVALID;
                }
                case "DELIVERY_ADDRESS1_REQUIRED": {
                    return DELIVERY_ADDRESS1_REQUIRED;
                }
                case "DELIVERY_ADDRESS1_TOO_LONG": {
                    return DELIVERY_ADDRESS1_TOO_LONG;
                }
                case "DELIVERY_ADDRESS2_INVALID": {
                    return DELIVERY_ADDRESS2_INVALID;
                }
                case "DELIVERY_ADDRESS2_REQUIRED": {
                    return DELIVERY_ADDRESS2_REQUIRED;
                }
                case "DELIVERY_ADDRESS2_TOO_LONG": {
                    return DELIVERY_ADDRESS2_TOO_LONG;
                }
                case "DELIVERY_ADDRESS_REQUIRED": {
                    return DELIVERY_ADDRESS_REQUIRED;
                }
                case "DELIVERY_CITY_INVALID": {
                    return DELIVERY_CITY_INVALID;
                }
                case "DELIVERY_CITY_REQUIRED": {
                    return DELIVERY_CITY_REQUIRED;
                }
                case "DELIVERY_CITY_TOO_LONG": {
                    return DELIVERY_CITY_TOO_LONG;
                }
                case "DELIVERY_COMPANY_INVALID": {
                    return DELIVERY_COMPANY_INVALID;
                }
                case "DELIVERY_COMPANY_REQUIRED": {
                    return DELIVERY_COMPANY_REQUIRED;
                }
                case "DELIVERY_COMPANY_TOO_LONG": {
                    return DELIVERY_COMPANY_TOO_LONG;
                }
                case "DELIVERY_COUNTRY_REQUIRED": {
                    return DELIVERY_COUNTRY_REQUIRED;
                }
                case "DELIVERY_FIRST_NAME_INVALID": {
                    return DELIVERY_FIRST_NAME_INVALID;
                }
                case "DELIVERY_FIRST_NAME_REQUIRED": {
                    return DELIVERY_FIRST_NAME_REQUIRED;
                }
                case "DELIVERY_FIRST_NAME_TOO_LONG": {
                    return DELIVERY_FIRST_NAME_TOO_LONG;
                }
                case "DELIVERY_INVALID_POSTAL_CODE_FOR_COUNTRY": {
                    return DELIVERY_INVALID_POSTAL_CODE_FOR_COUNTRY;
                }
                case "DELIVERY_INVALID_POSTAL_CODE_FOR_ZONE": {
                    return DELIVERY_INVALID_POSTAL_CODE_FOR_ZONE;
                }
                case "DELIVERY_LAST_NAME_INVALID": {
                    return DELIVERY_LAST_NAME_INVALID;
                }
                case "DELIVERY_LAST_NAME_REQUIRED": {
                    return DELIVERY_LAST_NAME_REQUIRED;
                }
                case "DELIVERY_LAST_NAME_TOO_LONG": {
                    return DELIVERY_LAST_NAME_TOO_LONG;
                }
                case "DELIVERY_NO_DELIVERY_AVAILABLE": {
                    return DELIVERY_NO_DELIVERY_AVAILABLE;
                }
                case "DELIVERY_NO_DELIVERY_AVAILABLE_FOR_MERCHANDISE_LINE": {
                    return DELIVERY_NO_DELIVERY_AVAILABLE_FOR_MERCHANDISE_LINE;
                }
                case "DELIVERY_OPTIONS_PHONE_NUMBER_INVALID": {
                    return DELIVERY_OPTIONS_PHONE_NUMBER_INVALID;
                }
                case "DELIVERY_OPTIONS_PHONE_NUMBER_REQUIRED": {
                    return DELIVERY_OPTIONS_PHONE_NUMBER_REQUIRED;
                }
                case "DELIVERY_PHONE_NUMBER_INVALID": {
                    return DELIVERY_PHONE_NUMBER_INVALID;
                }
                case "DELIVERY_PHONE_NUMBER_REQUIRED": {
                    return DELIVERY_PHONE_NUMBER_REQUIRED;
                }
                case "DELIVERY_POSTAL_CODE_INVALID": {
                    return DELIVERY_POSTAL_CODE_INVALID;
                }
                case "DELIVERY_POSTAL_CODE_REQUIRED": {
                    return DELIVERY_POSTAL_CODE_REQUIRED;
                }
                case "DELIVERY_ZONE_NOT_FOUND": {
                    return DELIVERY_ZONE_NOT_FOUND;
                }
                case "DELIVERY_ZONE_REQUIRED_FOR_COUNTRY": {
                    return DELIVERY_ZONE_REQUIRED_FOR_COUNTRY;
                }
                case "ERROR": {
                    return ERROR;
                }
                case "MERCHANDISE_LINE_LIMIT_REACHED": {
                    return MERCHANDISE_LINE_LIMIT_REACHED;
                }
                case "MERCHANDISE_NOT_APPLICABLE": {
                    return MERCHANDISE_NOT_APPLICABLE;
                }
                case "MERCHANDISE_NOT_ENOUGH_STOCK_AVAILABLE": {
                    return MERCHANDISE_NOT_ENOUGH_STOCK_AVAILABLE;
                }
                case "MERCHANDISE_OUT_OF_STOCK": {
                    return MERCHANDISE_OUT_OF_STOCK;
                }
                case "MERCHANDISE_PRODUCT_NOT_PUBLISHED": {
                    return MERCHANDISE_PRODUCT_NOT_PUBLISHED;
                }
                case "NO_DELIVERY_GROUP_SELECTED": {
                    return NO_DELIVERY_GROUP_SELECTED;
                }
                case "PAYMENTS_ADDRESS1_INVALID": {
                    return PAYMENTS_ADDRESS1_INVALID;
                }
                case "PAYMENTS_ADDRESS1_REQUIRED": {
                    return PAYMENTS_ADDRESS1_REQUIRED;
                }
                case "PAYMENTS_ADDRESS1_TOO_LONG": {
                    return PAYMENTS_ADDRESS1_TOO_LONG;
                }
                case "PAYMENTS_ADDRESS2_INVALID": {
                    return PAYMENTS_ADDRESS2_INVALID;
                }
                case "PAYMENTS_ADDRESS2_REQUIRED": {
                    return PAYMENTS_ADDRESS2_REQUIRED;
                }
                case "PAYMENTS_ADDRESS2_TOO_LONG": {
                    return PAYMENTS_ADDRESS2_TOO_LONG;
                }
                case "PAYMENTS_BILLING_ADDRESS_ZONE_NOT_FOUND": {
                    return PAYMENTS_BILLING_ADDRESS_ZONE_NOT_FOUND;
                }
                case "PAYMENTS_BILLING_ADDRESS_ZONE_REQUIRED_FOR_COUNTRY": {
                    return PAYMENTS_BILLING_ADDRESS_ZONE_REQUIRED_FOR_COUNTRY;
                }
                case "PAYMENTS_CITY_INVALID": {
                    return PAYMENTS_CITY_INVALID;
                }
                case "PAYMENTS_CITY_REQUIRED": {
                    return PAYMENTS_CITY_REQUIRED;
                }
                case "PAYMENTS_CITY_TOO_LONG": {
                    return PAYMENTS_CITY_TOO_LONG;
                }
                case "PAYMENTS_COMPANY_INVALID": {
                    return PAYMENTS_COMPANY_INVALID;
                }
                case "PAYMENTS_COMPANY_REQUIRED": {
                    return PAYMENTS_COMPANY_REQUIRED;
                }
                case "PAYMENTS_COMPANY_TOO_LONG": {
                    return PAYMENTS_COMPANY_TOO_LONG;
                }
                case "PAYMENTS_COUNTRY_REQUIRED": {
                    return PAYMENTS_COUNTRY_REQUIRED;
                }
                case "PAYMENTS_CREDIT_CARD_BASE_EXPIRED": {
                    return PAYMENTS_CREDIT_CARD_BASE_EXPIRED;
                }
                case "PAYMENTS_CREDIT_CARD_BASE_GATEWAY_NOT_SUPPORTED": {
                    return PAYMENTS_CREDIT_CARD_BASE_GATEWAY_NOT_SUPPORTED;
                }
                case "PAYMENTS_CREDIT_CARD_BASE_INVALID_START_DATE_OR_ISSUE_NUMBER_FOR_DEBIT": {
                    return PAYMENTS_CREDIT_CARD_BASE_INVALID_START_DATE_OR_ISSUE_NUMBER_FOR_DEBIT;
                }
                case "PAYMENTS_CREDIT_CARD_BRAND_NOT_SUPPORTED": {
                    return PAYMENTS_CREDIT_CARD_BRAND_NOT_SUPPORTED;
                }
                case "PAYMENTS_CREDIT_CARD_FIRST_NAME_BLANK": {
                    return PAYMENTS_CREDIT_CARD_FIRST_NAME_BLANK;
                }
                case "PAYMENTS_CREDIT_CARD_GENERIC": {
                    return PAYMENTS_CREDIT_CARD_GENERIC;
                }
                case "PAYMENTS_CREDIT_CARD_LAST_NAME_BLANK": {
                    return PAYMENTS_CREDIT_CARD_LAST_NAME_BLANK;
                }
                case "PAYMENTS_CREDIT_CARD_MONTH_INCLUSION": {
                    return PAYMENTS_CREDIT_CARD_MONTH_INCLUSION;
                }
                case "PAYMENTS_CREDIT_CARD_NAME_INVALID": {
                    return PAYMENTS_CREDIT_CARD_NAME_INVALID;
                }
                case "PAYMENTS_CREDIT_CARD_NUMBER_INVALID": {
                    return PAYMENTS_CREDIT_CARD_NUMBER_INVALID;
                }
                case "PAYMENTS_CREDIT_CARD_NUMBER_INVALID_FORMAT": {
                    return PAYMENTS_CREDIT_CARD_NUMBER_INVALID_FORMAT;
                }
                case "PAYMENTS_CREDIT_CARD_SESSION_ID": {
                    return PAYMENTS_CREDIT_CARD_SESSION_ID;
                }
                case "PAYMENTS_CREDIT_CARD_VERIFICATION_VALUE_BLANK": {
                    return PAYMENTS_CREDIT_CARD_VERIFICATION_VALUE_BLANK;
                }
                case "PAYMENTS_CREDIT_CARD_VERIFICATION_VALUE_INVALID_FOR_CARD_TYPE": {
                    return PAYMENTS_CREDIT_CARD_VERIFICATION_VALUE_INVALID_FOR_CARD_TYPE;
                }
                case "PAYMENTS_CREDIT_CARD_YEAR_EXPIRED": {
                    return PAYMENTS_CREDIT_CARD_YEAR_EXPIRED;
                }
                case "PAYMENTS_CREDIT_CARD_YEAR_INVALID_EXPIRY_YEAR": {
                    return PAYMENTS_CREDIT_CARD_YEAR_INVALID_EXPIRY_YEAR;
                }
                case "PAYMENTS_FIRST_NAME_INVALID": {
                    return PAYMENTS_FIRST_NAME_INVALID;
                }
                case "PAYMENTS_FIRST_NAME_REQUIRED": {
                    return PAYMENTS_FIRST_NAME_REQUIRED;
                }
                case "PAYMENTS_FIRST_NAME_TOO_LONG": {
                    return PAYMENTS_FIRST_NAME_TOO_LONG;
                }
                case "PAYMENTS_INVALID_POSTAL_CODE_FOR_COUNTRY": {
                    return PAYMENTS_INVALID_POSTAL_CODE_FOR_COUNTRY;
                }
                case "PAYMENTS_INVALID_POSTAL_CODE_FOR_ZONE": {
                    return PAYMENTS_INVALID_POSTAL_CODE_FOR_ZONE;
                }
                case "PAYMENTS_LAST_NAME_INVALID": {
                    return PAYMENTS_LAST_NAME_INVALID;
                }
                case "PAYMENTS_LAST_NAME_REQUIRED": {
                    return PAYMENTS_LAST_NAME_REQUIRED;
                }
                case "PAYMENTS_LAST_NAME_TOO_LONG": {
                    return PAYMENTS_LAST_NAME_TOO_LONG;
                }
                case "PAYMENTS_METHOD_REQUIRED": {
                    return PAYMENTS_METHOD_REQUIRED;
                }
                case "PAYMENTS_METHOD_UNAVAILABLE": {
                    return PAYMENTS_METHOD_UNAVAILABLE;
                }
                case "PAYMENTS_PHONE_NUMBER_INVALID": {
                    return PAYMENTS_PHONE_NUMBER_INVALID;
                }
                case "PAYMENTS_PHONE_NUMBER_REQUIRED": {
                    return PAYMENTS_PHONE_NUMBER_REQUIRED;
                }
                case "PAYMENTS_POSTAL_CODE_INVALID": {
                    return PAYMENTS_POSTAL_CODE_INVALID;
                }
                case "PAYMENTS_POSTAL_CODE_REQUIRED": {
                    return PAYMENTS_POSTAL_CODE_REQUIRED;
                }
                case "PAYMENTS_SHOPIFY_PAYMENTS_REQUIRED": {
                    return PAYMENTS_SHOPIFY_PAYMENTS_REQUIRED;
                }
                case "PAYMENTS_UNACCEPTABLE_PAYMENT_AMOUNT": {
                    return PAYMENTS_UNACCEPTABLE_PAYMENT_AMOUNT;
                }
                case "PAYMENTS_WALLET_CONTENT_MISSING": {
                    return PAYMENTS_WALLET_CONTENT_MISSING;
                }
                case "TAXES_DELIVERY_GROUP_ID_NOT_FOUND": {
                    return TAXES_DELIVERY_GROUP_ID_NOT_FOUND;
                }
                case "TAXES_LINE_ID_NOT_FOUND": {
                    return TAXES_LINE_ID_NOT_FOUND;
                }
                case "TAXES_MUST_BE_DEFINED": {
                    return TAXES_MUST_BE_DEFINED;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case BUYER_IDENTITY_EMAIL_IS_INVALID: {
                    return "BUYER_IDENTITY_EMAIL_IS_INVALID";
                }
                case BUYER_IDENTITY_EMAIL_REQUIRED: {
                    return "BUYER_IDENTITY_EMAIL_REQUIRED";
                }
                case BUYER_IDENTITY_PHONE_IS_INVALID: {
                    return "BUYER_IDENTITY_PHONE_IS_INVALID";
                }
                case DELIVERY_ADDRESS1_INVALID: {
                    return "DELIVERY_ADDRESS1_INVALID";
                }
                case DELIVERY_ADDRESS1_REQUIRED: {
                    return "DELIVERY_ADDRESS1_REQUIRED";
                }
                case DELIVERY_ADDRESS1_TOO_LONG: {
                    return "DELIVERY_ADDRESS1_TOO_LONG";
                }
                case DELIVERY_ADDRESS2_INVALID: {
                    return "DELIVERY_ADDRESS2_INVALID";
                }
                case DELIVERY_ADDRESS2_REQUIRED: {
                    return "DELIVERY_ADDRESS2_REQUIRED";
                }
                case DELIVERY_ADDRESS2_TOO_LONG: {
                    return "DELIVERY_ADDRESS2_TOO_LONG";
                }
                case DELIVERY_ADDRESS_REQUIRED: {
                    return "DELIVERY_ADDRESS_REQUIRED";
                }
                case DELIVERY_CITY_INVALID: {
                    return "DELIVERY_CITY_INVALID";
                }
                case DELIVERY_CITY_REQUIRED: {
                    return "DELIVERY_CITY_REQUIRED";
                }
                case DELIVERY_CITY_TOO_LONG: {
                    return "DELIVERY_CITY_TOO_LONG";
                }
                case DELIVERY_COMPANY_INVALID: {
                    return "DELIVERY_COMPANY_INVALID";
                }
                case DELIVERY_COMPANY_REQUIRED: {
                    return "DELIVERY_COMPANY_REQUIRED";
                }
                case DELIVERY_COMPANY_TOO_LONG: {
                    return "DELIVERY_COMPANY_TOO_LONG";
                }
                case DELIVERY_COUNTRY_REQUIRED: {
                    return "DELIVERY_COUNTRY_REQUIRED";
                }
                case DELIVERY_FIRST_NAME_INVALID: {
                    return "DELIVERY_FIRST_NAME_INVALID";
                }
                case DELIVERY_FIRST_NAME_REQUIRED: {
                    return "DELIVERY_FIRST_NAME_REQUIRED";
                }
                case DELIVERY_FIRST_NAME_TOO_LONG: {
                    return "DELIVERY_FIRST_NAME_TOO_LONG";
                }
                case DELIVERY_INVALID_POSTAL_CODE_FOR_COUNTRY: {
                    return "DELIVERY_INVALID_POSTAL_CODE_FOR_COUNTRY";
                }
                case DELIVERY_INVALID_POSTAL_CODE_FOR_ZONE: {
                    return "DELIVERY_INVALID_POSTAL_CODE_FOR_ZONE";
                }
                case DELIVERY_LAST_NAME_INVALID: {
                    return "DELIVERY_LAST_NAME_INVALID";
                }
                case DELIVERY_LAST_NAME_REQUIRED: {
                    return "DELIVERY_LAST_NAME_REQUIRED";
                }
                case DELIVERY_LAST_NAME_TOO_LONG: {
                    return "DELIVERY_LAST_NAME_TOO_LONG";
                }
                case DELIVERY_NO_DELIVERY_AVAILABLE: {
                    return "DELIVERY_NO_DELIVERY_AVAILABLE";
                }
                case DELIVERY_NO_DELIVERY_AVAILABLE_FOR_MERCHANDISE_LINE: {
                    return "DELIVERY_NO_DELIVERY_AVAILABLE_FOR_MERCHANDISE_LINE";
                }
                case DELIVERY_OPTIONS_PHONE_NUMBER_INVALID: {
                    return "DELIVERY_OPTIONS_PHONE_NUMBER_INVALID";
                }
                case DELIVERY_OPTIONS_PHONE_NUMBER_REQUIRED: {
                    return "DELIVERY_OPTIONS_PHONE_NUMBER_REQUIRED";
                }
                case DELIVERY_PHONE_NUMBER_INVALID: {
                    return "DELIVERY_PHONE_NUMBER_INVALID";
                }
                case DELIVERY_PHONE_NUMBER_REQUIRED: {
                    return "DELIVERY_PHONE_NUMBER_REQUIRED";
                }
                case DELIVERY_POSTAL_CODE_INVALID: {
                    return "DELIVERY_POSTAL_CODE_INVALID";
                }
                case DELIVERY_POSTAL_CODE_REQUIRED: {
                    return "DELIVERY_POSTAL_CODE_REQUIRED";
                }
                case DELIVERY_ZONE_NOT_FOUND: {
                    return "DELIVERY_ZONE_NOT_FOUND";
                }
                case DELIVERY_ZONE_REQUIRED_FOR_COUNTRY: {
                    return "DELIVERY_ZONE_REQUIRED_FOR_COUNTRY";
                }
                case ERROR: {
                    return "ERROR";
                }
                case MERCHANDISE_LINE_LIMIT_REACHED: {
                    return "MERCHANDISE_LINE_LIMIT_REACHED";
                }
                case MERCHANDISE_NOT_APPLICABLE: {
                    return "MERCHANDISE_NOT_APPLICABLE";
                }
                case MERCHANDISE_NOT_ENOUGH_STOCK_AVAILABLE: {
                    return "MERCHANDISE_NOT_ENOUGH_STOCK_AVAILABLE";
                }
                case MERCHANDISE_OUT_OF_STOCK: {
                    return "MERCHANDISE_OUT_OF_STOCK";
                }
                case MERCHANDISE_PRODUCT_NOT_PUBLISHED: {
                    return "MERCHANDISE_PRODUCT_NOT_PUBLISHED";
                }
                case NO_DELIVERY_GROUP_SELECTED: {
                    return "NO_DELIVERY_GROUP_SELECTED";
                }
                case PAYMENTS_ADDRESS1_INVALID: {
                    return "PAYMENTS_ADDRESS1_INVALID";
                }
                case PAYMENTS_ADDRESS1_REQUIRED: {
                    return "PAYMENTS_ADDRESS1_REQUIRED";
                }
                case PAYMENTS_ADDRESS1_TOO_LONG: {
                    return "PAYMENTS_ADDRESS1_TOO_LONG";
                }
                case PAYMENTS_ADDRESS2_INVALID: {
                    return "PAYMENTS_ADDRESS2_INVALID";
                }
                case PAYMENTS_ADDRESS2_REQUIRED: {
                    return "PAYMENTS_ADDRESS2_REQUIRED";
                }
                case PAYMENTS_ADDRESS2_TOO_LONG: {
                    return "PAYMENTS_ADDRESS2_TOO_LONG";
                }
                case PAYMENTS_BILLING_ADDRESS_ZONE_NOT_FOUND: {
                    return "PAYMENTS_BILLING_ADDRESS_ZONE_NOT_FOUND";
                }
                case PAYMENTS_BILLING_ADDRESS_ZONE_REQUIRED_FOR_COUNTRY: {
                    return "PAYMENTS_BILLING_ADDRESS_ZONE_REQUIRED_FOR_COUNTRY";
                }
                case PAYMENTS_CITY_INVALID: {
                    return "PAYMENTS_CITY_INVALID";
                }
                case PAYMENTS_CITY_REQUIRED: {
                    return "PAYMENTS_CITY_REQUIRED";
                }
                case PAYMENTS_CITY_TOO_LONG: {
                    return "PAYMENTS_CITY_TOO_LONG";
                }
                case PAYMENTS_COMPANY_INVALID: {
                    return "PAYMENTS_COMPANY_INVALID";
                }
                case PAYMENTS_COMPANY_REQUIRED: {
                    return "PAYMENTS_COMPANY_REQUIRED";
                }
                case PAYMENTS_COMPANY_TOO_LONG: {
                    return "PAYMENTS_COMPANY_TOO_LONG";
                }
                case PAYMENTS_COUNTRY_REQUIRED: {
                    return "PAYMENTS_COUNTRY_REQUIRED";
                }
                case PAYMENTS_CREDIT_CARD_BASE_EXPIRED: {
                    return "PAYMENTS_CREDIT_CARD_BASE_EXPIRED";
                }
                case PAYMENTS_CREDIT_CARD_BASE_GATEWAY_NOT_SUPPORTED: {
                    return "PAYMENTS_CREDIT_CARD_BASE_GATEWAY_NOT_SUPPORTED";
                }
                case PAYMENTS_CREDIT_CARD_BASE_INVALID_START_DATE_OR_ISSUE_NUMBER_FOR_DEBIT: {
                    return "PAYMENTS_CREDIT_CARD_BASE_INVALID_START_DATE_OR_ISSUE_NUMBER_FOR_DEBIT";
                }
                case PAYMENTS_CREDIT_CARD_BRAND_NOT_SUPPORTED: {
                    return "PAYMENTS_CREDIT_CARD_BRAND_NOT_SUPPORTED";
                }
                case PAYMENTS_CREDIT_CARD_FIRST_NAME_BLANK: {
                    return "PAYMENTS_CREDIT_CARD_FIRST_NAME_BLANK";
                }
                case PAYMENTS_CREDIT_CARD_GENERIC: {
                    return "PAYMENTS_CREDIT_CARD_GENERIC";
                }
                case PAYMENTS_CREDIT_CARD_LAST_NAME_BLANK: {
                    return "PAYMENTS_CREDIT_CARD_LAST_NAME_BLANK";
                }
                case PAYMENTS_CREDIT_CARD_MONTH_INCLUSION: {
                    return "PAYMENTS_CREDIT_CARD_MONTH_INCLUSION";
                }
                case PAYMENTS_CREDIT_CARD_NAME_INVALID: {
                    return "PAYMENTS_CREDIT_CARD_NAME_INVALID";
                }
                case PAYMENTS_CREDIT_CARD_NUMBER_INVALID: {
                    return "PAYMENTS_CREDIT_CARD_NUMBER_INVALID";
                }
                case PAYMENTS_CREDIT_CARD_NUMBER_INVALID_FORMAT: {
                    return "PAYMENTS_CREDIT_CARD_NUMBER_INVALID_FORMAT";
                }
                case PAYMENTS_CREDIT_CARD_SESSION_ID: {
                    return "PAYMENTS_CREDIT_CARD_SESSION_ID";
                }
                case PAYMENTS_CREDIT_CARD_VERIFICATION_VALUE_BLANK: {
                    return "PAYMENTS_CREDIT_CARD_VERIFICATION_VALUE_BLANK";
                }
                case PAYMENTS_CREDIT_CARD_VERIFICATION_VALUE_INVALID_FOR_CARD_TYPE: {
                    return "PAYMENTS_CREDIT_CARD_VERIFICATION_VALUE_INVALID_FOR_CARD_TYPE";
                }
                case PAYMENTS_CREDIT_CARD_YEAR_EXPIRED: {
                    return "PAYMENTS_CREDIT_CARD_YEAR_EXPIRED";
                }
                case PAYMENTS_CREDIT_CARD_YEAR_INVALID_EXPIRY_YEAR: {
                    return "PAYMENTS_CREDIT_CARD_YEAR_INVALID_EXPIRY_YEAR";
                }
                case PAYMENTS_FIRST_NAME_INVALID: {
                    return "PAYMENTS_FIRST_NAME_INVALID";
                }
                case PAYMENTS_FIRST_NAME_REQUIRED: {
                    return "PAYMENTS_FIRST_NAME_REQUIRED";
                }
                case PAYMENTS_FIRST_NAME_TOO_LONG: {
                    return "PAYMENTS_FIRST_NAME_TOO_LONG";
                }
                case PAYMENTS_INVALID_POSTAL_CODE_FOR_COUNTRY: {
                    return "PAYMENTS_INVALID_POSTAL_CODE_FOR_COUNTRY";
                }
                case PAYMENTS_INVALID_POSTAL_CODE_FOR_ZONE: {
                    return "PAYMENTS_INVALID_POSTAL_CODE_FOR_ZONE";
                }
                case PAYMENTS_LAST_NAME_INVALID: {
                    return "PAYMENTS_LAST_NAME_INVALID";
                }
                case PAYMENTS_LAST_NAME_REQUIRED: {
                    return "PAYMENTS_LAST_NAME_REQUIRED";
                }
                case PAYMENTS_LAST_NAME_TOO_LONG: {
                    return "PAYMENTS_LAST_NAME_TOO_LONG";
                }
                case PAYMENTS_METHOD_REQUIRED: {
                    return "PAYMENTS_METHOD_REQUIRED";
                }
                case PAYMENTS_METHOD_UNAVAILABLE: {
                    return "PAYMENTS_METHOD_UNAVAILABLE";
                }
                case PAYMENTS_PHONE_NUMBER_INVALID: {
                    return "PAYMENTS_PHONE_NUMBER_INVALID";
                }
                case PAYMENTS_PHONE_NUMBER_REQUIRED: {
                    return "PAYMENTS_PHONE_NUMBER_REQUIRED";
                }
                case PAYMENTS_POSTAL_CODE_INVALID: {
                    return "PAYMENTS_POSTAL_CODE_INVALID";
                }
                case PAYMENTS_POSTAL_CODE_REQUIRED: {
                    return "PAYMENTS_POSTAL_CODE_REQUIRED";
                }
                case PAYMENTS_SHOPIFY_PAYMENTS_REQUIRED: {
                    return "PAYMENTS_SHOPIFY_PAYMENTS_REQUIRED";
                }
                case PAYMENTS_UNACCEPTABLE_PAYMENT_AMOUNT: {
                    return "PAYMENTS_UNACCEPTABLE_PAYMENT_AMOUNT";
                }
                case PAYMENTS_WALLET_CONTENT_MISSING: {
                    return "PAYMENTS_WALLET_CONTENT_MISSING";
                }
                case TAXES_DELIVERY_GROUP_ID_NOT_FOUND: {
                    return "TAXES_DELIVERY_GROUP_ID_NOT_FOUND";
                }
                case TAXES_LINE_ID_NOT_FOUND: {
                    return "TAXES_LINE_ID_NOT_FOUND";
                }
                case TAXES_MUST_BE_DEFINED: {
                    return "TAXES_MUST_BE_DEFINED";
                }
            }
            return "";
        }
    }

    public static class SubmissionError
    extends AbstractResponse<SubmissionError> {
        public SubmissionError() {
        }

        public SubmissionError(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "code": {
                        this.responseData.put(key, SubmissionErrorCode.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "message": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SubmissionError";
        }

        public SubmissionErrorCode getCode() {
            return (SubmissionErrorCode)((Object)this.get("code"));
        }

        public SubmissionError setCode(SubmissionErrorCode arg) {
            this.optimisticData.put(this.getKey("code"), arg);
            return this;
        }

        public String getMessage() {
            return (String)this.get("message");
        }

        public SubmissionError setMessage(String arg) {
            this.optimisticData.put(this.getKey("message"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "code": {
                    return false;
                }
                case "message": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SubmissionErrorQuery
    extends Query<SubmissionErrorQuery> {
        SubmissionErrorQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SubmissionErrorQuery code() {
            this.startField("code");
            return this;
        }

        public SubmissionErrorQuery message() {
            this.startField("message");
            return this;
        }
    }

    public static interface SubmissionErrorQueryDefinition {
        public void define(SubmissionErrorQuery var1);
    }

    public static class StringEdge
    extends AbstractResponse<StringEdge> {
        public StringEdge() {
        }

        public StringEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "StringEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public StringEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public String getNode() {
            return (String)this.get("node");
        }

        public StringEdge setNode(String arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class StringEdgeQuery
    extends Query<StringEdgeQuery> {
        StringEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public StringEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public StringEdgeQuery node() {
            this.startField("node");
            return this;
        }
    }

    public static interface StringEdgeQueryDefinition {
        public void define(StringEdgeQuery var1);
    }

    public static class StringConnection
    extends AbstractResponse<StringConnection> {
        public StringConnection() {
        }

        public StringConnection(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<StringEdge> list1 = new ArrayList<StringEdge>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new StringEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block10;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "StringConnection";
        }

        public List<StringEdge> getEdges() {
            return (List)this.get("edges");
        }

        public StringConnection setEdges(List<StringEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public StringConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "pageInfo": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class StringConnectionQuery
    extends Query<StringConnectionQuery> {
        StringConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public StringConnectionQuery edges(StringEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new StringEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public StringConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface StringConnectionQueryDefinition {
        public void define(StringConnectionQuery var1);
    }

    public static class StoreAvailabilityEdge
    extends AbstractResponse<StoreAvailabilityEdge> {
        public StoreAvailabilityEdge() {
        }

        public StoreAvailabilityEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, new StoreAvailability(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "StoreAvailabilityEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public StoreAvailabilityEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public StoreAvailability getNode() {
            return (StoreAvailability)this.get("node");
        }

        public StoreAvailabilityEdge setNode(StoreAvailability arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class StoreAvailabilityEdgeQuery
    extends Query<StoreAvailabilityEdgeQuery> {
        StoreAvailabilityEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public StoreAvailabilityEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public StoreAvailabilityEdgeQuery node(StoreAvailabilityQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new StoreAvailabilityQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface StoreAvailabilityEdgeQueryDefinition {
        public void define(StoreAvailabilityEdgeQuery var1);
    }

    public static class StoreAvailabilityConnection
    extends AbstractResponse<StoreAvailabilityConnection> {
        public StoreAvailabilityConnection() {
        }

        public StoreAvailabilityConnection(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new StoreAvailabilityEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "nodes": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new StoreAvailability(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "StoreAvailabilityConnection";
        }

        public List<StoreAvailabilityEdge> getEdges() {
            return (List)this.get("edges");
        }

        public StoreAvailabilityConnection setEdges(List<StoreAvailabilityEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<StoreAvailability> getNodes() {
            return (List)this.get("nodes");
        }

        public StoreAvailabilityConnection setNodes(List<StoreAvailability> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public StoreAvailabilityConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "nodes": {
                    return true;
                }
                case "pageInfo": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class StoreAvailabilityConnectionQuery
    extends Query<StoreAvailabilityConnectionQuery> {
        StoreAvailabilityConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public StoreAvailabilityConnectionQuery edges(StoreAvailabilityEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new StoreAvailabilityEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public StoreAvailabilityConnectionQuery nodes(StoreAvailabilityQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new StoreAvailabilityQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public StoreAvailabilityConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface StoreAvailabilityConnectionQueryDefinition {
        public void define(StoreAvailabilityConnectionQuery var1);
    }

    public static class StoreAvailability
    extends AbstractResponse<StoreAvailability> {
        public StoreAvailability() {
        }

        public StoreAvailability(JsonObject fields) throws SchemaViolationError {
            block14: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "available": {
                        this.responseData.put(key, this.jsonAsBoolean((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "location": {
                        this.responseData.put(key, new Location(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block14;
                    }
                    case "pickUpTime": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "quantityAvailable": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "StoreAvailability";
        }

        public Boolean getAvailable() {
            return (Boolean)this.get("available");
        }

        public StoreAvailability setAvailable(Boolean arg) {
            this.optimisticData.put(this.getKey("available"), arg);
            return this;
        }

        public Location getLocation() {
            return (Location)this.get("location");
        }

        public StoreAvailability setLocation(Location arg) {
            this.optimisticData.put(this.getKey("location"), arg);
            return this;
        }

        public String getPickUpTime() {
            return (String)this.get("pickUpTime");
        }

        public StoreAvailability setPickUpTime(String arg) {
            this.optimisticData.put(this.getKey("pickUpTime"), arg);
            return this;
        }

        public Integer getQuantityAvailable() {
            return (Integer)this.get("quantityAvailable");
        }

        public StoreAvailability setQuantityAvailable(Integer arg) {
            this.optimisticData.put(this.getKey("quantityAvailable"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "available": {
                    return false;
                }
                case "location": {
                    return true;
                }
                case "pickUpTime": {
                    return false;
                }
                case "quantityAvailable": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class StoreAvailabilityQuery
    extends Query<StoreAvailabilityQuery> {
        StoreAvailabilityQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public StoreAvailabilityQuery available() {
            this.startField("available");
            return this;
        }

        public StoreAvailabilityQuery location(LocationQueryDefinition queryDef) {
            this.startField("location");
            this._queryBuilder.append('{');
            queryDef.define(new LocationQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public StoreAvailabilityQuery pickUpTime() {
            this.startField("pickUpTime");
            return this;
        }

        public StoreAvailabilityQuery quantityAvailable() {
            this.startField("quantityAvailable");
            return this;
        }
    }

    public static interface StoreAvailabilityQueryDefinition {
        public void define(StoreAvailabilityQuery var1);
    }

    public static class ShopPolicyWithDefault
    extends AbstractResponse<ShopPolicyWithDefault> {
        public ShopPolicyWithDefault() {
        }

        public ShopPolicyWithDefault(JsonObject fields) throws SchemaViolationError {
            block16: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "body": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "handle": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "id": {
                        ID optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ID(this.jsonAsString((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block16;
                    }
                    case "title": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "url": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ShopPolicyWithDefault";
        }

        public String getBody() {
            return (String)this.get("body");
        }

        public ShopPolicyWithDefault setBody(String arg) {
            this.optimisticData.put(this.getKey("body"), arg);
            return this;
        }

        public String getHandle() {
            return (String)this.get("handle");
        }

        public ShopPolicyWithDefault setHandle(String arg) {
            this.optimisticData.put(this.getKey("handle"), arg);
            return this;
        }

        public ID getId() {
            return (ID)this.get("id");
        }

        public ShopPolicyWithDefault setId(ID arg) {
            this.optimisticData.put(this.getKey("id"), arg);
            return this;
        }

        public String getTitle() {
            return (String)this.get("title");
        }

        public ShopPolicyWithDefault setTitle(String arg) {
            this.optimisticData.put(this.getKey("title"), arg);
            return this;
        }

        public String getUrl() {
            return (String)this.get("url");
        }

        public ShopPolicyWithDefault setUrl(String arg) {
            this.optimisticData.put(this.getKey("url"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "body": {
                    return false;
                }
                case "handle": {
                    return false;
                }
                case "id": {
                    return false;
                }
                case "title": {
                    return false;
                }
                case "url": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ShopPolicyWithDefaultQuery
    extends Query<ShopPolicyWithDefaultQuery> {
        ShopPolicyWithDefaultQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ShopPolicyWithDefaultQuery body() {
            this.startField("body");
            return this;
        }

        public ShopPolicyWithDefaultQuery handle() {
            this.startField("handle");
            return this;
        }

        public ShopPolicyWithDefaultQuery id() {
            this.startField("id");
            return this;
        }

        public ShopPolicyWithDefaultQuery title() {
            this.startField("title");
            return this;
        }

        public ShopPolicyWithDefaultQuery url() {
            this.startField("url");
            return this;
        }
    }

    public static interface ShopPolicyWithDefaultQueryDefinition {
        public void define(ShopPolicyWithDefaultQuery var1);
    }

    public static class ShopPolicy
    extends AbstractResponse<ShopPolicy>
    implements MenuItemResource,
    Node {
        public ShopPolicy() {
        }

        public ShopPolicy(JsonObject fields) throws SchemaViolationError {
            block16: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "body": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "handle": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block16;
                    }
                    case "title": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "url": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public ShopPolicy(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "ShopPolicy";
        }

        public String getBody() {
            return (String)this.get("body");
        }

        public ShopPolicy setBody(String arg) {
            this.optimisticData.put(this.getKey("body"), arg);
            return this;
        }

        public String getHandle() {
            return (String)this.get("handle");
        }

        public ShopPolicy setHandle(String arg) {
            this.optimisticData.put(this.getKey("handle"), arg);
            return this;
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        public String getTitle() {
            return (String)this.get("title");
        }

        public ShopPolicy setTitle(String arg) {
            this.optimisticData.put(this.getKey("title"), arg);
            return this;
        }

        public String getUrl() {
            return (String)this.get("url");
        }

        public ShopPolicy setUrl(String arg) {
            this.optimisticData.put(this.getKey("url"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "body": {
                    return false;
                }
                case "handle": {
                    return false;
                }
                case "id": {
                    return false;
                }
                case "title": {
                    return false;
                }
                case "url": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ShopPolicyQuery
    extends Query<ShopPolicyQuery> {
        ShopPolicyQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public ShopPolicyQuery body() {
            this.startField("body");
            return this;
        }

        public ShopPolicyQuery handle() {
            this.startField("handle");
            return this;
        }

        public ShopPolicyQuery title() {
            this.startField("title");
            return this;
        }

        public ShopPolicyQuery url() {
            this.startField("url");
            return this;
        }
    }

    public static interface ShopPolicyQueryDefinition {
        public void define(ShopPolicyQuery var1);
    }

    public static class ShopPayWalletContentInput
    implements Serializable {
        private MailingAddressInput billingAddress;
        private String sessionToken;

        public ShopPayWalletContentInput(MailingAddressInput billingAddress, String sessionToken) {
            this.billingAddress = billingAddress;
            this.sessionToken = sessionToken;
        }

        public MailingAddressInput getBillingAddress() {
            return this.billingAddress;
        }

        public ShopPayWalletContentInput setBillingAddress(MailingAddressInput billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public ShopPayWalletContentInput setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("billingAddress:");
            this.billingAddress.appendTo(_queryBuilder);
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("sessionToken:");
            Query.appendQuotedString(_queryBuilder, this.sessionToken.toString());
            _queryBuilder.append('}');
        }
    }

    public static class ShopPayPaymentRequestTotalShippingPriceInput
    implements Serializable {
        private Input<List<ShopPayPaymentRequestDiscountInput>> discounts = Input.undefined();
        private Input<MoneyInput> originalTotal = Input.undefined();
        private Input<MoneyInput> finalTotal = Input.undefined();

        public List<ShopPayPaymentRequestDiscountInput> getDiscounts() {
            return this.discounts.getValue();
        }

        public Input<List<ShopPayPaymentRequestDiscountInput>> getDiscountsInput() {
            return this.discounts;
        }

        public ShopPayPaymentRequestTotalShippingPriceInput setDiscounts(List<ShopPayPaymentRequestDiscountInput> discounts) {
            this.discounts = Input.optional(discounts);
            return this;
        }

        public ShopPayPaymentRequestTotalShippingPriceInput setDiscountsInput(Input<List<ShopPayPaymentRequestDiscountInput>> discounts) {
            if (discounts == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.discounts = discounts;
            return this;
        }

        public MoneyInput getOriginalTotal() {
            return this.originalTotal.getValue();
        }

        public Input<MoneyInput> getOriginalTotalInput() {
            return this.originalTotal;
        }

        public ShopPayPaymentRequestTotalShippingPriceInput setOriginalTotal(MoneyInput originalTotal) {
            this.originalTotal = Input.optional(originalTotal);
            return this;
        }

        public ShopPayPaymentRequestTotalShippingPriceInput setOriginalTotalInput(Input<MoneyInput> originalTotal) {
            if (originalTotal == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.originalTotal = originalTotal;
            return this;
        }

        public MoneyInput getFinalTotal() {
            return this.finalTotal.getValue();
        }

        public Input<MoneyInput> getFinalTotalInput() {
            return this.finalTotal;
        }

        public ShopPayPaymentRequestTotalShippingPriceInput setFinalTotal(MoneyInput finalTotal) {
            this.finalTotal = Input.optional(finalTotal);
            return this;
        }

        public ShopPayPaymentRequestTotalShippingPriceInput setFinalTotalInput(Input<MoneyInput> finalTotal) {
            if (finalTotal == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.finalTotal = finalTotal;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');
            if (this.discounts.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("discounts:");
                if (this.discounts.getValue() != null) {
                    _queryBuilder.append('[');
                    String listSeperator1 = "";
                    for (ShopPayPaymentRequestDiscountInput item1 : this.discounts.getValue()) {
                        _queryBuilder.append(listSeperator1);
                        listSeperator1 = ",";
                        item1.appendTo(_queryBuilder);
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.originalTotal.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("originalTotal:");
                if (this.originalTotal.getValue() != null) {
                    this.originalTotal.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.finalTotal.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("finalTotal:");
                if (this.finalTotal.getValue() != null) {
                    this.finalTotal.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            _queryBuilder.append('}');
        }
    }

    public static class ShopPayPaymentRequestTotalShippingPrice
    extends AbstractResponse<ShopPayPaymentRequestTotalShippingPrice> {
        public ShopPayPaymentRequestTotalShippingPrice() {
        }

        public ShopPayPaymentRequestTotalShippingPrice(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "discounts": {
                        ArrayList<ShopPayPaymentRequestDiscount> list1 = new ArrayList<ShopPayPaymentRequestDiscount>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new ShopPayPaymentRequestDiscount(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "finalTotal": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "originalTotal": {
                        MoneyV2 optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ShopPayPaymentRequestTotalShippingPrice";
        }

        public List<ShopPayPaymentRequestDiscount> getDiscounts() {
            return (List)this.get("discounts");
        }

        public ShopPayPaymentRequestTotalShippingPrice setDiscounts(List<ShopPayPaymentRequestDiscount> arg) {
            this.optimisticData.put(this.getKey("discounts"), arg);
            return this;
        }

        public MoneyV2 getFinalTotal() {
            return (MoneyV2)this.get("finalTotal");
        }

        public ShopPayPaymentRequestTotalShippingPrice setFinalTotal(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("finalTotal"), arg);
            return this;
        }

        public MoneyV2 getOriginalTotal() {
            return (MoneyV2)this.get("originalTotal");
        }

        public ShopPayPaymentRequestTotalShippingPrice setOriginalTotal(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("originalTotal"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "discounts": {
                    return true;
                }
                case "finalTotal": {
                    return true;
                }
                case "originalTotal": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ShopPayPaymentRequestTotalShippingPriceQuery
    extends Query<ShopPayPaymentRequestTotalShippingPriceQuery> {
        ShopPayPaymentRequestTotalShippingPriceQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ShopPayPaymentRequestTotalShippingPriceQuery discounts(ShopPayPaymentRequestDiscountQueryDefinition queryDef) {
            this.startField("discounts");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestDiscountQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestTotalShippingPriceQuery finalTotal(MoneyV2QueryDefinition queryDef) {
            this.startField("finalTotal");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestTotalShippingPriceQuery originalTotal(MoneyV2QueryDefinition queryDef) {
            this.startField("originalTotal");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface ShopPayPaymentRequestTotalShippingPriceQueryDefinition {
        public void define(ShopPayPaymentRequestTotalShippingPriceQuery var1);
    }

    public static class ShopPayPaymentRequestShippingLineInput
    implements Serializable {
        private Input<String> code = Input.undefined();
        private Input<String> label = Input.undefined();
        private Input<MoneyInput> amount = Input.undefined();

        public String getCode() {
            return this.code.getValue();
        }

        public Input<String> getCodeInput() {
            return this.code;
        }

        public ShopPayPaymentRequestShippingLineInput setCode(String code) {
            this.code = Input.optional(code);
            return this;
        }

        public ShopPayPaymentRequestShippingLineInput setCodeInput(Input<String> code) {
            if (code == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.code = code;
            return this;
        }

        public String getLabel() {
            return this.label.getValue();
        }

        public Input<String> getLabelInput() {
            return this.label;
        }

        public ShopPayPaymentRequestShippingLineInput setLabel(String label) {
            this.label = Input.optional(label);
            return this;
        }

        public ShopPayPaymentRequestShippingLineInput setLabelInput(Input<String> label) {
            if (label == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.label = label;
            return this;
        }

        public MoneyInput getAmount() {
            return this.amount.getValue();
        }

        public Input<MoneyInput> getAmountInput() {
            return this.amount;
        }

        public ShopPayPaymentRequestShippingLineInput setAmount(MoneyInput amount) {
            this.amount = Input.optional(amount);
            return this;
        }

        public ShopPayPaymentRequestShippingLineInput setAmountInput(Input<MoneyInput> amount) {
            if (amount == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.amount = amount;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');
            if (this.code.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("code:");
                if (this.code.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.code.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.label.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("label:");
                if (this.label.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.label.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.amount.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("amount:");
                if (this.amount.getValue() != null) {
                    this.amount.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            _queryBuilder.append('}');
        }
    }

    public static class ShopPayPaymentRequestShippingLine
    extends AbstractResponse<ShopPayPaymentRequestShippingLine> {
        public ShopPayPaymentRequestShippingLine() {
        }

        public ShopPayPaymentRequestShippingLine(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "amount": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "code": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                    case "label": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ShopPayPaymentRequestShippingLine";
        }

        public MoneyV2 getAmount() {
            return (MoneyV2)this.get("amount");
        }

        public ShopPayPaymentRequestShippingLine setAmount(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("amount"), arg);
            return this;
        }

        public String getCode() {
            return (String)this.get("code");
        }

        public ShopPayPaymentRequestShippingLine setCode(String arg) {
            this.optimisticData.put(this.getKey("code"), arg);
            return this;
        }

        public String getLabel() {
            return (String)this.get("label");
        }

        public ShopPayPaymentRequestShippingLine setLabel(String arg) {
            this.optimisticData.put(this.getKey("label"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "amount": {
                    return true;
                }
                case "code": {
                    return false;
                }
                case "label": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ShopPayPaymentRequestShippingLineQuery
    extends Query<ShopPayPaymentRequestShippingLineQuery> {
        ShopPayPaymentRequestShippingLineQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ShopPayPaymentRequestShippingLineQuery amount(MoneyV2QueryDefinition queryDef) {
            this.startField("amount");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestShippingLineQuery code() {
            this.startField("code");
            return this;
        }

        public ShopPayPaymentRequestShippingLineQuery label() {
            this.startField("label");
            return this;
        }
    }

    public static interface ShopPayPaymentRequestShippingLineQueryDefinition {
        public void define(ShopPayPaymentRequestShippingLineQuery var1);
    }

    public static class ShopPayPaymentRequestSessionSubmitPayload
    extends AbstractResponse<ShopPayPaymentRequestSessionSubmitPayload> {
        public ShopPayPaymentRequestSessionSubmitPayload() {
        }

        public ShopPayPaymentRequestSessionSubmitPayload(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "paymentRequestReceipt": {
                        ShopPayPaymentRequestReceipt optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ShopPayPaymentRequestReceipt(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "userErrors": {
                        ArrayList<UserErrorsShopPayPaymentRequestSessionUserErrors> list1 = new ArrayList<UserErrorsShopPayPaymentRequestSessionUserErrors>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new UserErrorsShopPayPaymentRequestSessionUserErrors(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ShopPayPaymentRequestSessionSubmitPayload";
        }

        public ShopPayPaymentRequestReceipt getPaymentRequestReceipt() {
            return (ShopPayPaymentRequestReceipt)this.get("paymentRequestReceipt");
        }

        public ShopPayPaymentRequestSessionSubmitPayload setPaymentRequestReceipt(ShopPayPaymentRequestReceipt arg) {
            this.optimisticData.put(this.getKey("paymentRequestReceipt"), arg);
            return this;
        }

        public List<UserErrorsShopPayPaymentRequestSessionUserErrors> getUserErrors() {
            return (List)this.get("userErrors");
        }

        public ShopPayPaymentRequestSessionSubmitPayload setUserErrors(List<UserErrorsShopPayPaymentRequestSessionUserErrors> arg) {
            this.optimisticData.put(this.getKey("userErrors"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "paymentRequestReceipt": {
                    return true;
                }
                case "userErrors": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ShopPayPaymentRequestSessionSubmitPayloadQuery
    extends Query<ShopPayPaymentRequestSessionSubmitPayloadQuery> {
        ShopPayPaymentRequestSessionSubmitPayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ShopPayPaymentRequestSessionSubmitPayloadQuery paymentRequestReceipt(ShopPayPaymentRequestReceiptQueryDefinition queryDef) {
            this.startField("paymentRequestReceipt");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestReceiptQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestSessionSubmitPayloadQuery userErrors(UserErrorsShopPayPaymentRequestSessionUserErrorsQueryDefinition queryDef) {
            this.startField("userErrors");
            this._queryBuilder.append('{');
            queryDef.define(new UserErrorsShopPayPaymentRequestSessionUserErrorsQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface ShopPayPaymentRequestSessionSubmitPayloadQueryDefinition {
        public void define(ShopPayPaymentRequestSessionSubmitPayloadQuery var1);
    }

    public static class ShopPayPaymentRequestSessionCreatePayload
    extends AbstractResponse<ShopPayPaymentRequestSessionCreatePayload> {
        public ShopPayPaymentRequestSessionCreatePayload() {
        }

        public ShopPayPaymentRequestSessionCreatePayload(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "shopPayPaymentRequestSession": {
                        ShopPayPaymentRequestSession optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ShopPayPaymentRequestSession(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "userErrors": {
                        ArrayList<UserErrorsShopPayPaymentRequestSessionUserErrors> list1 = new ArrayList<UserErrorsShopPayPaymentRequestSessionUserErrors>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new UserErrorsShopPayPaymentRequestSessionUserErrors(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ShopPayPaymentRequestSessionCreatePayload";
        }

        public ShopPayPaymentRequestSession getShopPayPaymentRequestSession() {
            return (ShopPayPaymentRequestSession)this.get("shopPayPaymentRequestSession");
        }

        public ShopPayPaymentRequestSessionCreatePayload setShopPayPaymentRequestSession(ShopPayPaymentRequestSession arg) {
            this.optimisticData.put(this.getKey("shopPayPaymentRequestSession"), arg);
            return this;
        }

        public List<UserErrorsShopPayPaymentRequestSessionUserErrors> getUserErrors() {
            return (List)this.get("userErrors");
        }

        public ShopPayPaymentRequestSessionCreatePayload setUserErrors(List<UserErrorsShopPayPaymentRequestSessionUserErrors> arg) {
            this.optimisticData.put(this.getKey("userErrors"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "shopPayPaymentRequestSession": {
                    return true;
                }
                case "userErrors": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ShopPayPaymentRequestSessionCreatePayloadQuery
    extends Query<ShopPayPaymentRequestSessionCreatePayloadQuery> {
        ShopPayPaymentRequestSessionCreatePayloadQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ShopPayPaymentRequestSessionCreatePayloadQuery shopPayPaymentRequestSession(ShopPayPaymentRequestSessionQueryDefinition queryDef) {
            this.startField("shopPayPaymentRequestSession");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestSessionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestSessionCreatePayloadQuery userErrors(UserErrorsShopPayPaymentRequestSessionUserErrorsQueryDefinition queryDef) {
            this.startField("userErrors");
            this._queryBuilder.append('{');
            queryDef.define(new UserErrorsShopPayPaymentRequestSessionUserErrorsQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface ShopPayPaymentRequestSessionCreatePayloadQueryDefinition {
        public void define(ShopPayPaymentRequestSessionCreatePayloadQuery var1);
    }

    public static class ShopPayPaymentRequestSession
    extends AbstractResponse<ShopPayPaymentRequestSession> {
        public ShopPayPaymentRequestSession() {
        }

        public ShopPayPaymentRequestSession(JsonObject fields) throws SchemaViolationError {
            block14: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "checkoutUrl": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "paymentRequest": {
                        this.responseData.put(key, new ShopPayPaymentRequest(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block14;
                    }
                    case "sourceIdentifier": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "token": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ShopPayPaymentRequestSession";
        }

        public String getCheckoutUrl() {
            return (String)this.get("checkoutUrl");
        }

        public ShopPayPaymentRequestSession setCheckoutUrl(String arg) {
            this.optimisticData.put(this.getKey("checkoutUrl"), arg);
            return this;
        }

        public ShopPayPaymentRequest getPaymentRequest() {
            return (ShopPayPaymentRequest)this.get("paymentRequest");
        }

        public ShopPayPaymentRequestSession setPaymentRequest(ShopPayPaymentRequest arg) {
            this.optimisticData.put(this.getKey("paymentRequest"), arg);
            return this;
        }

        public String getSourceIdentifier() {
            return (String)this.get("sourceIdentifier");
        }

        public ShopPayPaymentRequestSession setSourceIdentifier(String arg) {
            this.optimisticData.put(this.getKey("sourceIdentifier"), arg);
            return this;
        }

        public String getToken() {
            return (String)this.get("token");
        }

        public ShopPayPaymentRequestSession setToken(String arg) {
            this.optimisticData.put(this.getKey("token"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "checkoutUrl": {
                    return false;
                }
                case "paymentRequest": {
                    return true;
                }
                case "sourceIdentifier": {
                    return false;
                }
                case "token": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ShopPayPaymentRequestSessionQuery
    extends Query<ShopPayPaymentRequestSessionQuery> {
        ShopPayPaymentRequestSessionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ShopPayPaymentRequestSessionQuery checkoutUrl() {
            this.startField("checkoutUrl");
            return this;
        }

        public ShopPayPaymentRequestSessionQuery paymentRequest(ShopPayPaymentRequestQueryDefinition queryDef) {
            this.startField("paymentRequest");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestSessionQuery sourceIdentifier() {
            this.startField("sourceIdentifier");
            return this;
        }

        public ShopPayPaymentRequestSessionQuery token() {
            this.startField("token");
            return this;
        }
    }

    public static interface ShopPayPaymentRequestSessionQueryDefinition {
        public void define(ShopPayPaymentRequestSessionQuery var1);
    }

    public static class ShopPayPaymentRequestReceipt
    extends AbstractResponse<ShopPayPaymentRequestReceipt> {
        public ShopPayPaymentRequestReceipt() {
        }

        public ShopPayPaymentRequestReceipt(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "paymentRequest": {
                        this.responseData.put(key, new ShopPayPaymentRequest(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "processingStatusType": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                    case "token": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ShopPayPaymentRequestReceipt";
        }

        public ShopPayPaymentRequest getPaymentRequest() {
            return (ShopPayPaymentRequest)this.get("paymentRequest");
        }

        public ShopPayPaymentRequestReceipt setPaymentRequest(ShopPayPaymentRequest arg) {
            this.optimisticData.put(this.getKey("paymentRequest"), arg);
            return this;
        }

        public String getProcessingStatusType() {
            return (String)this.get("processingStatusType");
        }

        public ShopPayPaymentRequestReceipt setProcessingStatusType(String arg) {
            this.optimisticData.put(this.getKey("processingStatusType"), arg);
            return this;
        }

        public String getToken() {
            return (String)this.get("token");
        }

        public ShopPayPaymentRequestReceipt setToken(String arg) {
            this.optimisticData.put(this.getKey("token"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "paymentRequest": {
                    return true;
                }
                case "processingStatusType": {
                    return false;
                }
                case "token": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ShopPayPaymentRequestReceiptQuery
    extends Query<ShopPayPaymentRequestReceiptQuery> {
        ShopPayPaymentRequestReceiptQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ShopPayPaymentRequestReceiptQuery paymentRequest(ShopPayPaymentRequestQueryDefinition queryDef) {
            this.startField("paymentRequest");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestReceiptQuery processingStatusType() {
            this.startField("processingStatusType");
            return this;
        }

        public ShopPayPaymentRequestReceiptQuery token() {
            this.startField("token");
            return this;
        }
    }

    public static interface ShopPayPaymentRequestReceiptQueryDefinition {
        public void define(ShopPayPaymentRequestReceiptQuery var1);
    }

    public static class ShopPayPaymentRequestLineItemInput
    implements Serializable {
        private int quantity;
        private Input<String> label = Input.undefined();
        private Input<String> sku = Input.undefined();
        private Input<Boolean> requiresShipping = Input.undefined();
        private Input<ShopPayPaymentRequestImageInput> image = Input.undefined();
        private Input<MoneyInput> originalLinePrice = Input.undefined();
        private Input<MoneyInput> finalLinePrice = Input.undefined();
        private Input<List<ShopPayPaymentRequestDiscountInput>> lineDiscounts = Input.undefined();
        private Input<MoneyInput> originalItemPrice = Input.undefined();
        private Input<MoneyInput> finalItemPrice = Input.undefined();
        private Input<List<ShopPayPaymentRequestDiscountInput>> itemDiscounts = Input.undefined();

        public ShopPayPaymentRequestLineItemInput(int quantity) {
            this.quantity = quantity;
        }

        public int getQuantity() {
            return this.quantity;
        }

        public ShopPayPaymentRequestLineItemInput setQuantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        public String getLabel() {
            return this.label.getValue();
        }

        public Input<String> getLabelInput() {
            return this.label;
        }

        public ShopPayPaymentRequestLineItemInput setLabel(String label) {
            this.label = Input.optional(label);
            return this;
        }

        public ShopPayPaymentRequestLineItemInput setLabelInput(Input<String> label) {
            if (label == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.label = label;
            return this;
        }

        public String getSku() {
            return this.sku.getValue();
        }

        public Input<String> getSkuInput() {
            return this.sku;
        }

        public ShopPayPaymentRequestLineItemInput setSku(String sku) {
            this.sku = Input.optional(sku);
            return this;
        }

        public ShopPayPaymentRequestLineItemInput setSkuInput(Input<String> sku) {
            if (sku == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.sku = sku;
            return this;
        }

        public Boolean getRequiresShipping() {
            return this.requiresShipping.getValue();
        }

        public Input<Boolean> getRequiresShippingInput() {
            return this.requiresShipping;
        }

        public ShopPayPaymentRequestLineItemInput setRequiresShipping(Boolean requiresShipping) {
            this.requiresShipping = Input.optional(requiresShipping);
            return this;
        }

        public ShopPayPaymentRequestLineItemInput setRequiresShippingInput(Input<Boolean> requiresShipping) {
            if (requiresShipping == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.requiresShipping = requiresShipping;
            return this;
        }

        public ShopPayPaymentRequestImageInput getImage() {
            return this.image.getValue();
        }

        public Input<ShopPayPaymentRequestImageInput> getImageInput() {
            return this.image;
        }

        public ShopPayPaymentRequestLineItemInput setImage(ShopPayPaymentRequestImageInput image) {
            this.image = Input.optional(image);
            return this;
        }

        public ShopPayPaymentRequestLineItemInput setImageInput(Input<ShopPayPaymentRequestImageInput> image) {
            if (image == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.image = image;
            return this;
        }

        public MoneyInput getOriginalLinePrice() {
            return this.originalLinePrice.getValue();
        }

        public Input<MoneyInput> getOriginalLinePriceInput() {
            return this.originalLinePrice;
        }

        public ShopPayPaymentRequestLineItemInput setOriginalLinePrice(MoneyInput originalLinePrice) {
            this.originalLinePrice = Input.optional(originalLinePrice);
            return this;
        }

        public ShopPayPaymentRequestLineItemInput setOriginalLinePriceInput(Input<MoneyInput> originalLinePrice) {
            if (originalLinePrice == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.originalLinePrice = originalLinePrice;
            return this;
        }

        public MoneyInput getFinalLinePrice() {
            return this.finalLinePrice.getValue();
        }

        public Input<MoneyInput> getFinalLinePriceInput() {
            return this.finalLinePrice;
        }

        public ShopPayPaymentRequestLineItemInput setFinalLinePrice(MoneyInput finalLinePrice) {
            this.finalLinePrice = Input.optional(finalLinePrice);
            return this;
        }

        public ShopPayPaymentRequestLineItemInput setFinalLinePriceInput(Input<MoneyInput> finalLinePrice) {
            if (finalLinePrice == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.finalLinePrice = finalLinePrice;
            return this;
        }

        public List<ShopPayPaymentRequestDiscountInput> getLineDiscounts() {
            return this.lineDiscounts.getValue();
        }

        public Input<List<ShopPayPaymentRequestDiscountInput>> getLineDiscountsInput() {
            return this.lineDiscounts;
        }

        public ShopPayPaymentRequestLineItemInput setLineDiscounts(List<ShopPayPaymentRequestDiscountInput> lineDiscounts) {
            this.lineDiscounts = Input.optional(lineDiscounts);
            return this;
        }

        public ShopPayPaymentRequestLineItemInput setLineDiscountsInput(Input<List<ShopPayPaymentRequestDiscountInput>> lineDiscounts) {
            if (lineDiscounts == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.lineDiscounts = lineDiscounts;
            return this;
        }

        public MoneyInput getOriginalItemPrice() {
            return this.originalItemPrice.getValue();
        }

        public Input<MoneyInput> getOriginalItemPriceInput() {
            return this.originalItemPrice;
        }

        public ShopPayPaymentRequestLineItemInput setOriginalItemPrice(MoneyInput originalItemPrice) {
            this.originalItemPrice = Input.optional(originalItemPrice);
            return this;
        }

        public ShopPayPaymentRequestLineItemInput setOriginalItemPriceInput(Input<MoneyInput> originalItemPrice) {
            if (originalItemPrice == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.originalItemPrice = originalItemPrice;
            return this;
        }

        public MoneyInput getFinalItemPrice() {
            return this.finalItemPrice.getValue();
        }

        public Input<MoneyInput> getFinalItemPriceInput() {
            return this.finalItemPrice;
        }

        public ShopPayPaymentRequestLineItemInput setFinalItemPrice(MoneyInput finalItemPrice) {
            this.finalItemPrice = Input.optional(finalItemPrice);
            return this;
        }

        public ShopPayPaymentRequestLineItemInput setFinalItemPriceInput(Input<MoneyInput> finalItemPrice) {
            if (finalItemPrice == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.finalItemPrice = finalItemPrice;
            return this;
        }

        public List<ShopPayPaymentRequestDiscountInput> getItemDiscounts() {
            return this.itemDiscounts.getValue();
        }

        public Input<List<ShopPayPaymentRequestDiscountInput>> getItemDiscountsInput() {
            return this.itemDiscounts;
        }

        public ShopPayPaymentRequestLineItemInput setItemDiscounts(List<ShopPayPaymentRequestDiscountInput> itemDiscounts) {
            this.itemDiscounts = Input.optional(itemDiscounts);
            return this;
        }

        public ShopPayPaymentRequestLineItemInput setItemDiscountsInput(Input<List<ShopPayPaymentRequestDiscountInput>> itemDiscounts) {
            if (itemDiscounts == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.itemDiscounts = itemDiscounts;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String listSeperator1;
            String separator = "";
            _queryBuilder.append('{');
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("quantity:");
            _queryBuilder.append(this.quantity);
            if (this.label.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("label:");
                if (this.label.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.label.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.sku.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("sku:");
                if (this.sku.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.sku.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.requiresShipping.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("requiresShipping:");
                if (this.requiresShipping.getValue() != null) {
                    _queryBuilder.append(this.requiresShipping.getValue());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.image.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("image:");
                if (this.image.getValue() != null) {
                    this.image.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.originalLinePrice.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("originalLinePrice:");
                if (this.originalLinePrice.getValue() != null) {
                    this.originalLinePrice.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.finalLinePrice.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("finalLinePrice:");
                if (this.finalLinePrice.getValue() != null) {
                    this.finalLinePrice.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.lineDiscounts.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("lineDiscounts:");
                if (this.lineDiscounts.getValue() != null) {
                    _queryBuilder.append('[');
                    listSeperator1 = "";
                    for (ShopPayPaymentRequestDiscountInput item1 : this.lineDiscounts.getValue()) {
                        _queryBuilder.append(listSeperator1);
                        listSeperator1 = ",";
                        item1.appendTo(_queryBuilder);
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.originalItemPrice.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("originalItemPrice:");
                if (this.originalItemPrice.getValue() != null) {
                    this.originalItemPrice.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.finalItemPrice.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("finalItemPrice:");
                if (this.finalItemPrice.getValue() != null) {
                    this.finalItemPrice.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.itemDiscounts.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("itemDiscounts:");
                if (this.itemDiscounts.getValue() != null) {
                    _queryBuilder.append('[');
                    listSeperator1 = "";
                    for (ShopPayPaymentRequestDiscountInput item1 : this.itemDiscounts.getValue()) {
                        _queryBuilder.append(listSeperator1);
                        listSeperator1 = ",";
                        item1.appendTo(_queryBuilder);
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }
            _queryBuilder.append('}');
        }
    }

    public static class ShopPayPaymentRequestLineItem
    extends AbstractResponse<ShopPayPaymentRequestLineItem> {
        public ShopPayPaymentRequestLineItem() {
        }

        public ShopPayPaymentRequestLineItem(JsonObject fields) throws SchemaViolationError {
            block28: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "finalItemPrice": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block28;
                    }
                    case "finalLinePrice": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block28;
                    }
                    case "image": {
                        ArrayList<ShopPayPaymentRequestDiscount> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ShopPayPaymentRequestImage(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "itemDiscounts": {
                        ArrayList<ShopPayPaymentRequestDiscount> list1;
                        ArrayList<ShopPayPaymentRequestDiscount> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            list1 = new ArrayList<ShopPayPaymentRequestDiscount>();
                            for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                                list1.add(new ShopPayPaymentRequestDiscount(this.jsonAsObject(element1, key)));
                            }
                            optional1 = list1;
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "label": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                    case "lineDiscounts": {
                        ArrayList<ShopPayPaymentRequestDiscount> list1;
                        ArrayList<ShopPayPaymentRequestDiscount> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            list1 = new ArrayList();
                            for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                                list1.add(new ShopPayPaymentRequestDiscount(this.jsonAsObject(element1, key)));
                            }
                            optional1 = list1;
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "originalItemPrice": {
                        ArrayList<ShopPayPaymentRequestDiscount> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "originalLinePrice": {
                        ArrayList<ShopPayPaymentRequestDiscount> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "quantity": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                    case "requiresShipping": {
                        ArrayList<ShopPayPaymentRequestDiscount> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsBoolean((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "sku": {
                        ArrayList<ShopPayPaymentRequestDiscount> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ShopPayPaymentRequestLineItem";
        }

        public MoneyV2 getFinalItemPrice() {
            return (MoneyV2)this.get("finalItemPrice");
        }

        public ShopPayPaymentRequestLineItem setFinalItemPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("finalItemPrice"), arg);
            return this;
        }

        public MoneyV2 getFinalLinePrice() {
            return (MoneyV2)this.get("finalLinePrice");
        }

        public ShopPayPaymentRequestLineItem setFinalLinePrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("finalLinePrice"), arg);
            return this;
        }

        public ShopPayPaymentRequestImage getImage() {
            return (ShopPayPaymentRequestImage)this.get("image");
        }

        public ShopPayPaymentRequestLineItem setImage(ShopPayPaymentRequestImage arg) {
            this.optimisticData.put(this.getKey("image"), arg);
            return this;
        }

        public List<ShopPayPaymentRequestDiscount> getItemDiscounts() {
            return (List)this.get("itemDiscounts");
        }

        public ShopPayPaymentRequestLineItem setItemDiscounts(List<ShopPayPaymentRequestDiscount> arg) {
            this.optimisticData.put(this.getKey("itemDiscounts"), arg);
            return this;
        }

        public String getLabel() {
            return (String)this.get("label");
        }

        public ShopPayPaymentRequestLineItem setLabel(String arg) {
            this.optimisticData.put(this.getKey("label"), arg);
            return this;
        }

        public List<ShopPayPaymentRequestDiscount> getLineDiscounts() {
            return (List)this.get("lineDiscounts");
        }

        public ShopPayPaymentRequestLineItem setLineDiscounts(List<ShopPayPaymentRequestDiscount> arg) {
            this.optimisticData.put(this.getKey("lineDiscounts"), arg);
            return this;
        }

        public MoneyV2 getOriginalItemPrice() {
            return (MoneyV2)this.get("originalItemPrice");
        }

        public ShopPayPaymentRequestLineItem setOriginalItemPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("originalItemPrice"), arg);
            return this;
        }

        public MoneyV2 getOriginalLinePrice() {
            return (MoneyV2)this.get("originalLinePrice");
        }

        public ShopPayPaymentRequestLineItem setOriginalLinePrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("originalLinePrice"), arg);
            return this;
        }

        public Integer getQuantity() {
            return (Integer)this.get("quantity");
        }

        public ShopPayPaymentRequestLineItem setQuantity(Integer arg) {
            this.optimisticData.put(this.getKey("quantity"), arg);
            return this;
        }

        public Boolean getRequiresShipping() {
            return (Boolean)this.get("requiresShipping");
        }

        public ShopPayPaymentRequestLineItem setRequiresShipping(Boolean arg) {
            this.optimisticData.put(this.getKey("requiresShipping"), arg);
            return this;
        }

        public String getSku() {
            return (String)this.get("sku");
        }

        public ShopPayPaymentRequestLineItem setSku(String arg) {
            this.optimisticData.put(this.getKey("sku"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "finalItemPrice": {
                    return true;
                }
                case "finalLinePrice": {
                    return true;
                }
                case "image": {
                    return true;
                }
                case "itemDiscounts": {
                    return true;
                }
                case "label": {
                    return false;
                }
                case "lineDiscounts": {
                    return true;
                }
                case "originalItemPrice": {
                    return true;
                }
                case "originalLinePrice": {
                    return true;
                }
                case "quantity": {
                    return false;
                }
                case "requiresShipping": {
                    return false;
                }
                case "sku": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ShopPayPaymentRequestLineItemQuery
    extends Query<ShopPayPaymentRequestLineItemQuery> {
        ShopPayPaymentRequestLineItemQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ShopPayPaymentRequestLineItemQuery finalItemPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("finalItemPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestLineItemQuery finalLinePrice(MoneyV2QueryDefinition queryDef) {
            this.startField("finalLinePrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestLineItemQuery image(ShopPayPaymentRequestImageQueryDefinition queryDef) {
            this.startField("image");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestImageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestLineItemQuery itemDiscounts(ShopPayPaymentRequestDiscountQueryDefinition queryDef) {
            this.startField("itemDiscounts");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestDiscountQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestLineItemQuery label() {
            this.startField("label");
            return this;
        }

        public ShopPayPaymentRequestLineItemQuery lineDiscounts(ShopPayPaymentRequestDiscountQueryDefinition queryDef) {
            this.startField("lineDiscounts");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestDiscountQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestLineItemQuery originalItemPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("originalItemPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestLineItemQuery originalLinePrice(MoneyV2QueryDefinition queryDef) {
            this.startField("originalLinePrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestLineItemQuery quantity() {
            this.startField("quantity");
            return this;
        }

        public ShopPayPaymentRequestLineItemQuery requiresShipping() {
            this.startField("requiresShipping");
            return this;
        }

        public ShopPayPaymentRequestLineItemQuery sku() {
            this.startField("sku");
            return this;
        }
    }

    public static interface ShopPayPaymentRequestLineItemQueryDefinition {
        public void define(ShopPayPaymentRequestLineItemQuery var1);
    }

    public static class ShopPayPaymentRequestInput
    implements Serializable {
        private MoneyInput total;
        private MoneyInput subtotal;
        private String locale;
        private CurrencyCode presentmentCurrency;
        private Input<List<String>> discountCodes = Input.undefined();
        private Input<List<ShopPayPaymentRequestLineItemInput>> lineItems = Input.undefined();
        private Input<List<ShopPayPaymentRequestShippingLineInput>> shippingLines = Input.undefined();
        private Input<List<ShopPayPaymentRequestDiscountInput>> discounts = Input.undefined();
        private Input<ShopPayPaymentRequestTotalShippingPriceInput> totalShippingPrice = Input.undefined();
        private Input<MoneyInput> totalTax = Input.undefined();
        private Input<List<ShopPayPaymentRequestDeliveryMethodInput>> deliveryMethods = Input.undefined();
        private Input<ShopPayPaymentRequestDeliveryMethodType> selectedDeliveryMethodType = Input.undefined();
        private Input<String> paymentMethod = Input.undefined();

        public ShopPayPaymentRequestInput(MoneyInput total, MoneyInput subtotal, String locale, CurrencyCode presentmentCurrency) {
            this.total = total;
            this.subtotal = subtotal;
            this.locale = locale;
            this.presentmentCurrency = presentmentCurrency;
        }

        public MoneyInput getTotal() {
            return this.total;
        }

        public ShopPayPaymentRequestInput setTotal(MoneyInput total) {
            this.total = total;
            return this;
        }

        public MoneyInput getSubtotal() {
            return this.subtotal;
        }

        public ShopPayPaymentRequestInput setSubtotal(MoneyInput subtotal) {
            this.subtotal = subtotal;
            return this;
        }

        public String getLocale() {
            return this.locale;
        }

        public ShopPayPaymentRequestInput setLocale(String locale) {
            this.locale = locale;
            return this;
        }

        public CurrencyCode getPresentmentCurrency() {
            return this.presentmentCurrency;
        }

        public ShopPayPaymentRequestInput setPresentmentCurrency(CurrencyCode presentmentCurrency) {
            this.presentmentCurrency = presentmentCurrency;
            return this;
        }

        public List<String> getDiscountCodes() {
            return this.discountCodes.getValue();
        }

        public Input<List<String>> getDiscountCodesInput() {
            return this.discountCodes;
        }

        public ShopPayPaymentRequestInput setDiscountCodes(List<String> discountCodes) {
            this.discountCodes = Input.optional(discountCodes);
            return this;
        }

        public ShopPayPaymentRequestInput setDiscountCodesInput(Input<List<String>> discountCodes) {
            if (discountCodes == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.discountCodes = discountCodes;
            return this;
        }

        public List<ShopPayPaymentRequestLineItemInput> getLineItems() {
            return this.lineItems.getValue();
        }

        public Input<List<ShopPayPaymentRequestLineItemInput>> getLineItemsInput() {
            return this.lineItems;
        }

        public ShopPayPaymentRequestInput setLineItems(List<ShopPayPaymentRequestLineItemInput> lineItems) {
            this.lineItems = Input.optional(lineItems);
            return this;
        }

        public ShopPayPaymentRequestInput setLineItemsInput(Input<List<ShopPayPaymentRequestLineItemInput>> lineItems) {
            if (lineItems == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.lineItems = lineItems;
            return this;
        }

        public List<ShopPayPaymentRequestShippingLineInput> getShippingLines() {
            return this.shippingLines.getValue();
        }

        public Input<List<ShopPayPaymentRequestShippingLineInput>> getShippingLinesInput() {
            return this.shippingLines;
        }

        public ShopPayPaymentRequestInput setShippingLines(List<ShopPayPaymentRequestShippingLineInput> shippingLines) {
            this.shippingLines = Input.optional(shippingLines);
            return this;
        }

        public ShopPayPaymentRequestInput setShippingLinesInput(Input<List<ShopPayPaymentRequestShippingLineInput>> shippingLines) {
            if (shippingLines == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.shippingLines = shippingLines;
            return this;
        }

        public List<ShopPayPaymentRequestDiscountInput> getDiscounts() {
            return this.discounts.getValue();
        }

        public Input<List<ShopPayPaymentRequestDiscountInput>> getDiscountsInput() {
            return this.discounts;
        }

        public ShopPayPaymentRequestInput setDiscounts(List<ShopPayPaymentRequestDiscountInput> discounts) {
            this.discounts = Input.optional(discounts);
            return this;
        }

        public ShopPayPaymentRequestInput setDiscountsInput(Input<List<ShopPayPaymentRequestDiscountInput>> discounts) {
            if (discounts == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.discounts = discounts;
            return this;
        }

        public ShopPayPaymentRequestTotalShippingPriceInput getTotalShippingPrice() {
            return this.totalShippingPrice.getValue();
        }

        public Input<ShopPayPaymentRequestTotalShippingPriceInput> getTotalShippingPriceInput() {
            return this.totalShippingPrice;
        }

        public ShopPayPaymentRequestInput setTotalShippingPrice(ShopPayPaymentRequestTotalShippingPriceInput totalShippingPrice) {
            this.totalShippingPrice = Input.optional(totalShippingPrice);
            return this;
        }

        public ShopPayPaymentRequestInput setTotalShippingPriceInput(Input<ShopPayPaymentRequestTotalShippingPriceInput> totalShippingPrice) {
            if (totalShippingPrice == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.totalShippingPrice = totalShippingPrice;
            return this;
        }

        public MoneyInput getTotalTax() {
            return this.totalTax.getValue();
        }

        public Input<MoneyInput> getTotalTaxInput() {
            return this.totalTax;
        }

        public ShopPayPaymentRequestInput setTotalTax(MoneyInput totalTax) {
            this.totalTax = Input.optional(totalTax);
            return this;
        }

        public ShopPayPaymentRequestInput setTotalTaxInput(Input<MoneyInput> totalTax) {
            if (totalTax == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.totalTax = totalTax;
            return this;
        }

        public List<ShopPayPaymentRequestDeliveryMethodInput> getDeliveryMethods() {
            return this.deliveryMethods.getValue();
        }

        public Input<List<ShopPayPaymentRequestDeliveryMethodInput>> getDeliveryMethodsInput() {
            return this.deliveryMethods;
        }

        public ShopPayPaymentRequestInput setDeliveryMethods(List<ShopPayPaymentRequestDeliveryMethodInput> deliveryMethods) {
            this.deliveryMethods = Input.optional(deliveryMethods);
            return this;
        }

        public ShopPayPaymentRequestInput setDeliveryMethodsInput(Input<List<ShopPayPaymentRequestDeliveryMethodInput>> deliveryMethods) {
            if (deliveryMethods == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.deliveryMethods = deliveryMethods;
            return this;
        }

        public ShopPayPaymentRequestDeliveryMethodType getSelectedDeliveryMethodType() {
            return this.selectedDeliveryMethodType.getValue();
        }

        public Input<ShopPayPaymentRequestDeliveryMethodType> getSelectedDeliveryMethodTypeInput() {
            return this.selectedDeliveryMethodType;
        }

        public ShopPayPaymentRequestInput setSelectedDeliveryMethodType(ShopPayPaymentRequestDeliveryMethodType selectedDeliveryMethodType) {
            this.selectedDeliveryMethodType = Input.optional(selectedDeliveryMethodType);
            return this;
        }

        public ShopPayPaymentRequestInput setSelectedDeliveryMethodTypeInput(Input<ShopPayPaymentRequestDeliveryMethodType> selectedDeliveryMethodType) {
            if (selectedDeliveryMethodType == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.selectedDeliveryMethodType = selectedDeliveryMethodType;
            return this;
        }

        public String getPaymentMethod() {
            return this.paymentMethod.getValue();
        }

        public Input<String> getPaymentMethodInput() {
            return this.paymentMethod;
        }

        public ShopPayPaymentRequestInput setPaymentMethod(String paymentMethod) {
            this.paymentMethod = Input.optional(paymentMethod);
            return this;
        }

        public ShopPayPaymentRequestInput setPaymentMethodInput(Input<String> paymentMethod) {
            if (paymentMethod == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.paymentMethod = paymentMethod;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String listSeperator1;
            String separator = "";
            _queryBuilder.append('{');
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("total:");
            this.total.appendTo(_queryBuilder);
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("subtotal:");
            this.subtotal.appendTo(_queryBuilder);
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("locale:");
            Query.appendQuotedString(_queryBuilder, this.locale.toString());
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("presentmentCurrency:");
            _queryBuilder.append(this.presentmentCurrency.toString());
            if (this.discountCodes.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("discountCodes:");
                if (this.discountCodes.getValue() != null) {
                    _queryBuilder.append('[');
                    listSeperator1 = "";
                    for (String string : this.discountCodes.getValue()) {
                        _queryBuilder.append(listSeperator1);
                        listSeperator1 = ",";
                        Query.appendQuotedString(_queryBuilder, string.toString());
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.lineItems.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("lineItems:");
                if (this.lineItems.getValue() != null) {
                    _queryBuilder.append('[');
                    listSeperator1 = "";
                    for (ShopPayPaymentRequestLineItemInput shopPayPaymentRequestLineItemInput : this.lineItems.getValue()) {
                        _queryBuilder.append(listSeperator1);
                        listSeperator1 = ",";
                        shopPayPaymentRequestLineItemInput.appendTo(_queryBuilder);
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.shippingLines.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("shippingLines:");
                if (this.shippingLines.getValue() != null) {
                    _queryBuilder.append('[');
                    listSeperator1 = "";
                    for (ShopPayPaymentRequestShippingLineInput shopPayPaymentRequestShippingLineInput : this.shippingLines.getValue()) {
                        _queryBuilder.append(listSeperator1);
                        listSeperator1 = ",";
                        shopPayPaymentRequestShippingLineInput.appendTo(_queryBuilder);
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.discounts.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("discounts:");
                if (this.discounts.getValue() != null) {
                    _queryBuilder.append('[');
                    listSeperator1 = "";
                    for (ShopPayPaymentRequestDiscountInput shopPayPaymentRequestDiscountInput : this.discounts.getValue()) {
                        _queryBuilder.append(listSeperator1);
                        listSeperator1 = ",";
                        shopPayPaymentRequestDiscountInput.appendTo(_queryBuilder);
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.totalShippingPrice.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("totalShippingPrice:");
                if (this.totalShippingPrice.getValue() != null) {
                    this.totalShippingPrice.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.totalTax.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("totalTax:");
                if (this.totalTax.getValue() != null) {
                    this.totalTax.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.deliveryMethods.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("deliveryMethods:");
                if (this.deliveryMethods.getValue() != null) {
                    _queryBuilder.append('[');
                    listSeperator1 = "";
                    for (ShopPayPaymentRequestDeliveryMethodInput shopPayPaymentRequestDeliveryMethodInput : this.deliveryMethods.getValue()) {
                        _queryBuilder.append(listSeperator1);
                        listSeperator1 = ",";
                        shopPayPaymentRequestDeliveryMethodInput.appendTo(_queryBuilder);
                    }
                    _queryBuilder.append(']');
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.selectedDeliveryMethodType.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("selectedDeliveryMethodType:");
                if (this.selectedDeliveryMethodType.getValue() != null) {
                    _queryBuilder.append(this.selectedDeliveryMethodType.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.paymentMethod.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("paymentMethod:");
                if (this.paymentMethod.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.paymentMethod.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            _queryBuilder.append('}');
        }
    }

    public static class ShopPayPaymentRequestImageInput
    implements Serializable {
        private String url;
        private Input<String> alt = Input.undefined();

        public ShopPayPaymentRequestImageInput(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public ShopPayPaymentRequestImageInput setUrl(String url) {
            this.url = url;
            return this;
        }

        public String getAlt() {
            return this.alt.getValue();
        }

        public Input<String> getAltInput() {
            return this.alt;
        }

        public ShopPayPaymentRequestImageInput setAlt(String alt) {
            this.alt = Input.optional(alt);
            return this;
        }

        public ShopPayPaymentRequestImageInput setAltInput(Input<String> alt) {
            if (alt == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.alt = alt;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("url:");
            Query.appendQuotedString(_queryBuilder, this.url.toString());
            if (this.alt.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("alt:");
                if (this.alt.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.alt.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            _queryBuilder.append('}');
        }
    }

    public static class ShopPayPaymentRequestImage
    extends AbstractResponse<ShopPayPaymentRequestImage> {
        public ShopPayPaymentRequestImage() {
        }

        public ShopPayPaymentRequestImage(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "alt": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "url": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ShopPayPaymentRequestImage";
        }

        public String getAlt() {
            return (String)this.get("alt");
        }

        public ShopPayPaymentRequestImage setAlt(String arg) {
            this.optimisticData.put(this.getKey("alt"), arg);
            return this;
        }

        public String getUrl() {
            return (String)this.get("url");
        }

        public ShopPayPaymentRequestImage setUrl(String arg) {
            this.optimisticData.put(this.getKey("url"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "alt": {
                    return false;
                }
                case "url": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ShopPayPaymentRequestImageQuery
    extends Query<ShopPayPaymentRequestImageQuery> {
        ShopPayPaymentRequestImageQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ShopPayPaymentRequestImageQuery alt() {
            this.startField("alt");
            return this;
        }

        public ShopPayPaymentRequestImageQuery url() {
            this.startField("url");
            return this;
        }
    }

    public static interface ShopPayPaymentRequestImageQueryDefinition {
        public void define(ShopPayPaymentRequestImageQuery var1);
    }

    public static class ShopPayPaymentRequestDiscountInput
    implements Serializable {
        private Input<String> label = Input.undefined();
        private Input<MoneyInput> amount = Input.undefined();

        public String getLabel() {
            return this.label.getValue();
        }

        public Input<String> getLabelInput() {
            return this.label;
        }

        public ShopPayPaymentRequestDiscountInput setLabel(String label) {
            this.label = Input.optional(label);
            return this;
        }

        public ShopPayPaymentRequestDiscountInput setLabelInput(Input<String> label) {
            if (label == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.label = label;
            return this;
        }

        public MoneyInput getAmount() {
            return this.amount.getValue();
        }

        public Input<MoneyInput> getAmountInput() {
            return this.amount;
        }

        public ShopPayPaymentRequestDiscountInput setAmount(MoneyInput amount) {
            this.amount = Input.optional(amount);
            return this;
        }

        public ShopPayPaymentRequestDiscountInput setAmountInput(Input<MoneyInput> amount) {
            if (amount == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.amount = amount;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');
            if (this.label.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("label:");
                if (this.label.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.label.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.amount.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("amount:");
                if (this.amount.getValue() != null) {
                    this.amount.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            _queryBuilder.append('}');
        }
    }

    public static class ShopPayPaymentRequestDiscount
    extends AbstractResponse<ShopPayPaymentRequestDiscount> {
        public ShopPayPaymentRequestDiscount() {
        }

        public ShopPayPaymentRequestDiscount(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "amount": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "label": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ShopPayPaymentRequestDiscount";
        }

        public MoneyV2 getAmount() {
            return (MoneyV2)this.get("amount");
        }

        public ShopPayPaymentRequestDiscount setAmount(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("amount"), arg);
            return this;
        }

        public String getLabel() {
            return (String)this.get("label");
        }

        public ShopPayPaymentRequestDiscount setLabel(String arg) {
            this.optimisticData.put(this.getKey("label"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "amount": {
                    return true;
                }
                case "label": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ShopPayPaymentRequestDiscountQuery
    extends Query<ShopPayPaymentRequestDiscountQuery> {
        ShopPayPaymentRequestDiscountQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ShopPayPaymentRequestDiscountQuery amount(MoneyV2QueryDefinition queryDef) {
            this.startField("amount");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestDiscountQuery label() {
            this.startField("label");
            return this;
        }
    }

    public static interface ShopPayPaymentRequestDiscountQueryDefinition {
        public void define(ShopPayPaymentRequestDiscountQuery var1);
    }

    public static enum ShopPayPaymentRequestDeliveryMethodType {
        PICKUP,
        SHIPPING,
        UNKNOWN_VALUE;


        public static ShopPayPaymentRequestDeliveryMethodType fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "PICKUP": {
                    return PICKUP;
                }
                case "SHIPPING": {
                    return SHIPPING;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case PICKUP: {
                    return "PICKUP";
                }
                case SHIPPING: {
                    return "SHIPPING";
                }
            }
            return "";
        }
    }

    public static class ShopPayPaymentRequestDeliveryMethodInput
    implements Serializable {
        private Input<String> code = Input.undefined();
        private Input<String> label = Input.undefined();
        private Input<String> detail = Input.undefined();
        private Input<MoneyInput> amount = Input.undefined();
        private Input<String> minDeliveryDate = Input.undefined();
        private Input<String> maxDeliveryDate = Input.undefined();
        private Input<String> deliveryExpectationLabel = Input.undefined();

        public String getCode() {
            return this.code.getValue();
        }

        public Input<String> getCodeInput() {
            return this.code;
        }

        public ShopPayPaymentRequestDeliveryMethodInput setCode(String code) {
            this.code = Input.optional(code);
            return this;
        }

        public ShopPayPaymentRequestDeliveryMethodInput setCodeInput(Input<String> code) {
            if (code == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.code = code;
            return this;
        }

        public String getLabel() {
            return this.label.getValue();
        }

        public Input<String> getLabelInput() {
            return this.label;
        }

        public ShopPayPaymentRequestDeliveryMethodInput setLabel(String label) {
            this.label = Input.optional(label);
            return this;
        }

        public ShopPayPaymentRequestDeliveryMethodInput setLabelInput(Input<String> label) {
            if (label == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.label = label;
            return this;
        }

        public String getDetail() {
            return this.detail.getValue();
        }

        public Input<String> getDetailInput() {
            return this.detail;
        }

        public ShopPayPaymentRequestDeliveryMethodInput setDetail(String detail) {
            this.detail = Input.optional(detail);
            return this;
        }

        public ShopPayPaymentRequestDeliveryMethodInput setDetailInput(Input<String> detail) {
            if (detail == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.detail = detail;
            return this;
        }

        public MoneyInput getAmount() {
            return this.amount.getValue();
        }

        public Input<MoneyInput> getAmountInput() {
            return this.amount;
        }

        public ShopPayPaymentRequestDeliveryMethodInput setAmount(MoneyInput amount) {
            this.amount = Input.optional(amount);
            return this;
        }

        public ShopPayPaymentRequestDeliveryMethodInput setAmountInput(Input<MoneyInput> amount) {
            if (amount == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.amount = amount;
            return this;
        }

        public String getMinDeliveryDate() {
            return this.minDeliveryDate.getValue();
        }

        public Input<String> getMinDeliveryDateInput() {
            return this.minDeliveryDate;
        }

        public ShopPayPaymentRequestDeliveryMethodInput setMinDeliveryDate(String minDeliveryDate) {
            this.minDeliveryDate = Input.optional(minDeliveryDate);
            return this;
        }

        public ShopPayPaymentRequestDeliveryMethodInput setMinDeliveryDateInput(Input<String> minDeliveryDate) {
            if (minDeliveryDate == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.minDeliveryDate = minDeliveryDate;
            return this;
        }

        public String getMaxDeliveryDate() {
            return this.maxDeliveryDate.getValue();
        }

        public Input<String> getMaxDeliveryDateInput() {
            return this.maxDeliveryDate;
        }

        public ShopPayPaymentRequestDeliveryMethodInput setMaxDeliveryDate(String maxDeliveryDate) {
            this.maxDeliveryDate = Input.optional(maxDeliveryDate);
            return this;
        }

        public ShopPayPaymentRequestDeliveryMethodInput setMaxDeliveryDateInput(Input<String> maxDeliveryDate) {
            if (maxDeliveryDate == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.maxDeliveryDate = maxDeliveryDate;
            return this;
        }

        public String getDeliveryExpectationLabel() {
            return this.deliveryExpectationLabel.getValue();
        }

        public Input<String> getDeliveryExpectationLabelInput() {
            return this.deliveryExpectationLabel;
        }

        public ShopPayPaymentRequestDeliveryMethodInput setDeliveryExpectationLabel(String deliveryExpectationLabel) {
            this.deliveryExpectationLabel = Input.optional(deliveryExpectationLabel);
            return this;
        }

        public ShopPayPaymentRequestDeliveryMethodInput setDeliveryExpectationLabelInput(Input<String> deliveryExpectationLabel) {
            if (deliveryExpectationLabel == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.deliveryExpectationLabel = deliveryExpectationLabel;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');
            if (this.code.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("code:");
                if (this.code.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.code.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.label.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("label:");
                if (this.label.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.label.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.detail.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("detail:");
                if (this.detail.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.detail.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.amount.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("amount:");
                if (this.amount.getValue() != null) {
                    this.amount.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.minDeliveryDate.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("minDeliveryDate:");
                if (this.minDeliveryDate.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.minDeliveryDate.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.maxDeliveryDate.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("maxDeliveryDate:");
                if (this.maxDeliveryDate.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.maxDeliveryDate.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.deliveryExpectationLabel.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("deliveryExpectationLabel:");
                if (this.deliveryExpectationLabel.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.deliveryExpectationLabel.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            _queryBuilder.append('}');
        }
    }

    public static class ShopPayPaymentRequestDeliveryMethod
    extends AbstractResponse<ShopPayPaymentRequestDeliveryMethod> {
        public ShopPayPaymentRequestDeliveryMethod() {
        }

        public ShopPayPaymentRequestDeliveryMethod(JsonObject fields) throws SchemaViolationError {
            block20: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "amount": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block20;
                    }
                    case "code": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block20;
                    }
                    case "deliveryExpectationLabel": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block20;
                    }
                    case "detail": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block20;
                    }
                    case "label": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block20;
                    }
                    case "maxDeliveryDate": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block20;
                    }
                    case "minDeliveryDate": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block20;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block20;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ShopPayPaymentRequestDeliveryMethod";
        }

        public MoneyV2 getAmount() {
            return (MoneyV2)this.get("amount");
        }

        public ShopPayPaymentRequestDeliveryMethod setAmount(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("amount"), arg);
            return this;
        }

        public String getCode() {
            return (String)this.get("code");
        }

        public ShopPayPaymentRequestDeliveryMethod setCode(String arg) {
            this.optimisticData.put(this.getKey("code"), arg);
            return this;
        }

        public String getDeliveryExpectationLabel() {
            return (String)this.get("deliveryExpectationLabel");
        }

        public ShopPayPaymentRequestDeliveryMethod setDeliveryExpectationLabel(String arg) {
            this.optimisticData.put(this.getKey("deliveryExpectationLabel"), arg);
            return this;
        }

        public String getDetail() {
            return (String)this.get("detail");
        }

        public ShopPayPaymentRequestDeliveryMethod setDetail(String arg) {
            this.optimisticData.put(this.getKey("detail"), arg);
            return this;
        }

        public String getLabel() {
            return (String)this.get("label");
        }

        public ShopPayPaymentRequestDeliveryMethod setLabel(String arg) {
            this.optimisticData.put(this.getKey("label"), arg);
            return this;
        }

        public String getMaxDeliveryDate() {
            return (String)this.get("maxDeliveryDate");
        }

        public ShopPayPaymentRequestDeliveryMethod setMaxDeliveryDate(String arg) {
            this.optimisticData.put(this.getKey("maxDeliveryDate"), arg);
            return this;
        }

        public String getMinDeliveryDate() {
            return (String)this.get("minDeliveryDate");
        }

        public ShopPayPaymentRequestDeliveryMethod setMinDeliveryDate(String arg) {
            this.optimisticData.put(this.getKey("minDeliveryDate"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "amount": {
                    return true;
                }
                case "code": {
                    return false;
                }
                case "deliveryExpectationLabel": {
                    return false;
                }
                case "detail": {
                    return false;
                }
                case "label": {
                    return false;
                }
                case "maxDeliveryDate": {
                    return false;
                }
                case "minDeliveryDate": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ShopPayPaymentRequestDeliveryMethodQuery
    extends Query<ShopPayPaymentRequestDeliveryMethodQuery> {
        ShopPayPaymentRequestDeliveryMethodQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ShopPayPaymentRequestDeliveryMethodQuery amount(MoneyV2QueryDefinition queryDef) {
            this.startField("amount");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestDeliveryMethodQuery code() {
            this.startField("code");
            return this;
        }

        public ShopPayPaymentRequestDeliveryMethodQuery deliveryExpectationLabel() {
            this.startField("deliveryExpectationLabel");
            return this;
        }

        public ShopPayPaymentRequestDeliveryMethodQuery detail() {
            this.startField("detail");
            return this;
        }

        public ShopPayPaymentRequestDeliveryMethodQuery label() {
            this.startField("label");
            return this;
        }

        public ShopPayPaymentRequestDeliveryMethodQuery maxDeliveryDate() {
            this.startField("maxDeliveryDate");
            return this;
        }

        public ShopPayPaymentRequestDeliveryMethodQuery minDeliveryDate() {
            this.startField("minDeliveryDate");
            return this;
        }
    }

    public static interface ShopPayPaymentRequestDeliveryMethodQueryDefinition {
        public void define(ShopPayPaymentRequestDeliveryMethodQuery var1);
    }

    public static class ShopPayPaymentRequestContactField
    extends AbstractResponse<ShopPayPaymentRequestContactField> {
        public ShopPayPaymentRequestContactField() {
        }

        public ShopPayPaymentRequestContactField(JsonObject fields) throws SchemaViolationError {
            block28: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "address1": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                    case "address2": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "city": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                    case "companyName": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "countryCode": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                    case "email": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "firstName": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                    case "lastName": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                    case "phone": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "postalCode": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "provinceCode": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ShopPayPaymentRequestContactField";
        }

        public String getAddress1() {
            return (String)this.get("address1");
        }

        public ShopPayPaymentRequestContactField setAddress1(String arg) {
            this.optimisticData.put(this.getKey("address1"), arg);
            return this;
        }

        public String getAddress2() {
            return (String)this.get("address2");
        }

        public ShopPayPaymentRequestContactField setAddress2(String arg) {
            this.optimisticData.put(this.getKey("address2"), arg);
            return this;
        }

        public String getCity() {
            return (String)this.get("city");
        }

        public ShopPayPaymentRequestContactField setCity(String arg) {
            this.optimisticData.put(this.getKey("city"), arg);
            return this;
        }

        public String getCompanyName() {
            return (String)this.get("companyName");
        }

        public ShopPayPaymentRequestContactField setCompanyName(String arg) {
            this.optimisticData.put(this.getKey("companyName"), arg);
            return this;
        }

        public String getCountryCode() {
            return (String)this.get("countryCode");
        }

        public ShopPayPaymentRequestContactField setCountryCode(String arg) {
            this.optimisticData.put(this.getKey("countryCode"), arg);
            return this;
        }

        public String getEmail() {
            return (String)this.get("email");
        }

        public ShopPayPaymentRequestContactField setEmail(String arg) {
            this.optimisticData.put(this.getKey("email"), arg);
            return this;
        }

        public String getFirstName() {
            return (String)this.get("firstName");
        }

        public ShopPayPaymentRequestContactField setFirstName(String arg) {
            this.optimisticData.put(this.getKey("firstName"), arg);
            return this;
        }

        public String getLastName() {
            return (String)this.get("lastName");
        }

        public ShopPayPaymentRequestContactField setLastName(String arg) {
            this.optimisticData.put(this.getKey("lastName"), arg);
            return this;
        }

        public String getPhone() {
            return (String)this.get("phone");
        }

        public ShopPayPaymentRequestContactField setPhone(String arg) {
            this.optimisticData.put(this.getKey("phone"), arg);
            return this;
        }

        public String getPostalCode() {
            return (String)this.get("postalCode");
        }

        public ShopPayPaymentRequestContactField setPostalCode(String arg) {
            this.optimisticData.put(this.getKey("postalCode"), arg);
            return this;
        }

        public String getProvinceCode() {
            return (String)this.get("provinceCode");
        }

        public ShopPayPaymentRequestContactField setProvinceCode(String arg) {
            this.optimisticData.put(this.getKey("provinceCode"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "address1": {
                    return false;
                }
                case "address2": {
                    return false;
                }
                case "city": {
                    return false;
                }
                case "companyName": {
                    return false;
                }
                case "countryCode": {
                    return false;
                }
                case "email": {
                    return false;
                }
                case "firstName": {
                    return false;
                }
                case "lastName": {
                    return false;
                }
                case "phone": {
                    return false;
                }
                case "postalCode": {
                    return false;
                }
                case "provinceCode": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ShopPayPaymentRequestContactFieldQuery
    extends Query<ShopPayPaymentRequestContactFieldQuery> {
        ShopPayPaymentRequestContactFieldQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ShopPayPaymentRequestContactFieldQuery address1() {
            this.startField("address1");
            return this;
        }

        public ShopPayPaymentRequestContactFieldQuery address2() {
            this.startField("address2");
            return this;
        }

        public ShopPayPaymentRequestContactFieldQuery city() {
            this.startField("city");
            return this;
        }

        public ShopPayPaymentRequestContactFieldQuery companyName() {
            this.startField("companyName");
            return this;
        }

        public ShopPayPaymentRequestContactFieldQuery countryCode() {
            this.startField("countryCode");
            return this;
        }

        public ShopPayPaymentRequestContactFieldQuery email() {
            this.startField("email");
            return this;
        }

        public ShopPayPaymentRequestContactFieldQuery firstName() {
            this.startField("firstName");
            return this;
        }

        public ShopPayPaymentRequestContactFieldQuery lastName() {
            this.startField("lastName");
            return this;
        }

        public ShopPayPaymentRequestContactFieldQuery phone() {
            this.startField("phone");
            return this;
        }

        public ShopPayPaymentRequestContactFieldQuery postalCode() {
            this.startField("postalCode");
            return this;
        }

        public ShopPayPaymentRequestContactFieldQuery provinceCode() {
            this.startField("provinceCode");
            return this;
        }
    }

    public static interface ShopPayPaymentRequestContactFieldQueryDefinition {
        public void define(ShopPayPaymentRequestContactFieldQuery var1);
    }

    public static class ShopPayPaymentRequest
    extends AbstractResponse<ShopPayPaymentRequest> {
        public ShopPayPaymentRequest() {
        }

        public ShopPayPaymentRequest(JsonObject fields) throws SchemaViolationError {
            block32: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "deliveryMethods": {
                        ArrayList<Object> list1 = new ArrayList<Object>();
                        for (Object element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new ShopPayPaymentRequestDeliveryMethod(this.jsonAsObject((JsonElement)element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block32;
                    }
                    case "discountCodes": {
                        ArrayList<Object> list1 = new ArrayList();
                        for (Object element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(this.jsonAsString((JsonElement)element1, key));
                        }
                        this.responseData.put(key, list1);
                        continue block32;
                    }
                    case "discounts": {
                        Serializable optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            Object element1;
                            ArrayList<ShopPayPaymentRequestDiscount> list1 = new ArrayList<ShopPayPaymentRequestDiscount>();
                            element1 = this.jsonAsArray((JsonElement)field.getValue(), key).iterator();
                            while (element1.hasNext()) {
                                JsonElement element12 = (JsonElement)element1.next();
                                list1.add(new ShopPayPaymentRequestDiscount(this.jsonAsObject(element12, key)));
                            }
                            optional1 = list1;
                        }
                        this.responseData.put(key, optional1);
                        continue block32;
                    }
                    case "lineItems": {
                        ArrayList<Object> list1 = new ArrayList();
                        for (Object element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new ShopPayPaymentRequestLineItem(this.jsonAsObject((JsonElement)element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block32;
                    }
                    case "locale": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block32;
                    }
                    case "presentmentCurrency": {
                        this.responseData.put(key, CurrencyCode.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block32;
                    }
                    case "selectedDeliveryMethodType": {
                        this.responseData.put(key, ShopPayPaymentRequestDeliveryMethodType.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block32;
                    }
                    case "shippingAddress": {
                        Serializable optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ShopPayPaymentRequestContactField(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block32;
                    }
                    case "shippingLines": {
                        ArrayList<Object> list1 = new ArrayList();
                        for (Object element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new ShopPayPaymentRequestShippingLine(this.jsonAsObject((JsonElement)element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block32;
                    }
                    case "subtotal": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block32;
                    }
                    case "total": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block32;
                    }
                    case "totalShippingPrice": {
                        Serializable optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ShopPayPaymentRequestTotalShippingPrice(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block32;
                    }
                    case "totalTax": {
                        Serializable optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block32;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block32;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ShopPayPaymentRequest";
        }

        public List<ShopPayPaymentRequestDeliveryMethod> getDeliveryMethods() {
            return (List)this.get("deliveryMethods");
        }

        public ShopPayPaymentRequest setDeliveryMethods(List<ShopPayPaymentRequestDeliveryMethod> arg) {
            this.optimisticData.put(this.getKey("deliveryMethods"), arg);
            return this;
        }

        public List<String> getDiscountCodes() {
            return (List)this.get("discountCodes");
        }

        public ShopPayPaymentRequest setDiscountCodes(List<String> arg) {
            this.optimisticData.put(this.getKey("discountCodes"), arg);
            return this;
        }

        public List<ShopPayPaymentRequestDiscount> getDiscounts() {
            return (List)this.get("discounts");
        }

        public ShopPayPaymentRequest setDiscounts(List<ShopPayPaymentRequestDiscount> arg) {
            this.optimisticData.put(this.getKey("discounts"), arg);
            return this;
        }

        public List<ShopPayPaymentRequestLineItem> getLineItems() {
            return (List)this.get("lineItems");
        }

        public ShopPayPaymentRequest setLineItems(List<ShopPayPaymentRequestLineItem> arg) {
            this.optimisticData.put(this.getKey("lineItems"), arg);
            return this;
        }

        public String getLocale() {
            return (String)this.get("locale");
        }

        public ShopPayPaymentRequest setLocale(String arg) {
            this.optimisticData.put(this.getKey("locale"), arg);
            return this;
        }

        public CurrencyCode getPresentmentCurrency() {
            return (CurrencyCode)((Object)this.get("presentmentCurrency"));
        }

        public ShopPayPaymentRequest setPresentmentCurrency(CurrencyCode arg) {
            this.optimisticData.put(this.getKey("presentmentCurrency"), arg);
            return this;
        }

        public ShopPayPaymentRequestDeliveryMethodType getSelectedDeliveryMethodType() {
            return (ShopPayPaymentRequestDeliveryMethodType)((Object)this.get("selectedDeliveryMethodType"));
        }

        public ShopPayPaymentRequest setSelectedDeliveryMethodType(ShopPayPaymentRequestDeliveryMethodType arg) {
            this.optimisticData.put(this.getKey("selectedDeliveryMethodType"), arg);
            return this;
        }

        public ShopPayPaymentRequestContactField getShippingAddress() {
            return (ShopPayPaymentRequestContactField)this.get("shippingAddress");
        }

        public ShopPayPaymentRequest setShippingAddress(ShopPayPaymentRequestContactField arg) {
            this.optimisticData.put(this.getKey("shippingAddress"), arg);
            return this;
        }

        public List<ShopPayPaymentRequestShippingLine> getShippingLines() {
            return (List)this.get("shippingLines");
        }

        public ShopPayPaymentRequest setShippingLines(List<ShopPayPaymentRequestShippingLine> arg) {
            this.optimisticData.put(this.getKey("shippingLines"), arg);
            return this;
        }

        public MoneyV2 getSubtotal() {
            return (MoneyV2)this.get("subtotal");
        }

        public ShopPayPaymentRequest setSubtotal(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("subtotal"), arg);
            return this;
        }

        public MoneyV2 getTotal() {
            return (MoneyV2)this.get("total");
        }

        public ShopPayPaymentRequest setTotal(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("total"), arg);
            return this;
        }

        public ShopPayPaymentRequestTotalShippingPrice getTotalShippingPrice() {
            return (ShopPayPaymentRequestTotalShippingPrice)this.get("totalShippingPrice");
        }

        public ShopPayPaymentRequest setTotalShippingPrice(ShopPayPaymentRequestTotalShippingPrice arg) {
            this.optimisticData.put(this.getKey("totalShippingPrice"), arg);
            return this;
        }

        public MoneyV2 getTotalTax() {
            return (MoneyV2)this.get("totalTax");
        }

        public ShopPayPaymentRequest setTotalTax(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("totalTax"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "deliveryMethods": {
                    return true;
                }
                case "discountCodes": {
                    return false;
                }
                case "discounts": {
                    return true;
                }
                case "lineItems": {
                    return true;
                }
                case "locale": {
                    return false;
                }
                case "presentmentCurrency": {
                    return false;
                }
                case "selectedDeliveryMethodType": {
                    return false;
                }
                case "shippingAddress": {
                    return true;
                }
                case "shippingLines": {
                    return true;
                }
                case "subtotal": {
                    return true;
                }
                case "total": {
                    return true;
                }
                case "totalShippingPrice": {
                    return true;
                }
                case "totalTax": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ShopPayPaymentRequestQuery
    extends Query<ShopPayPaymentRequestQuery> {
        ShopPayPaymentRequestQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ShopPayPaymentRequestQuery deliveryMethods(ShopPayPaymentRequestDeliveryMethodQueryDefinition queryDef) {
            this.startField("deliveryMethods");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestDeliveryMethodQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestQuery discountCodes() {
            this.startField("discountCodes");
            return this;
        }

        public ShopPayPaymentRequestQuery discounts(ShopPayPaymentRequestDiscountQueryDefinition queryDef) {
            this.startField("discounts");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestDiscountQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestQuery lineItems(ShopPayPaymentRequestLineItemQueryDefinition queryDef) {
            this.startField("lineItems");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestLineItemQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestQuery locale() {
            this.startField("locale");
            return this;
        }

        public ShopPayPaymentRequestQuery presentmentCurrency() {
            this.startField("presentmentCurrency");
            return this;
        }

        public ShopPayPaymentRequestQuery selectedDeliveryMethodType() {
            this.startField("selectedDeliveryMethodType");
            return this;
        }

        public ShopPayPaymentRequestQuery shippingAddress(ShopPayPaymentRequestContactFieldQueryDefinition queryDef) {
            this.startField("shippingAddress");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestContactFieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestQuery shippingLines(ShopPayPaymentRequestShippingLineQueryDefinition queryDef) {
            this.startField("shippingLines");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestShippingLineQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestQuery subtotal(MoneyV2QueryDefinition queryDef) {
            this.startField("subtotal");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestQuery total(MoneyV2QueryDefinition queryDef) {
            this.startField("total");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestQuery totalShippingPrice(ShopPayPaymentRequestTotalShippingPriceQueryDefinition queryDef) {
            this.startField("totalShippingPrice");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestTotalShippingPriceQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopPayPaymentRequestQuery totalTax(MoneyV2QueryDefinition queryDef) {
            this.startField("totalTax");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface ShopPayPaymentRequestQueryDefinition {
        public void define(ShopPayPaymentRequestQuery var1);
    }

    public static class Shop
    extends AbstractResponse<Shop>
    implements HasMetafields,
    MetafieldParentResource,
    Node {
        public Shop() {
        }

        public Shop(JsonObject fields) throws SchemaViolationError {
            block36: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "brand": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Brand(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block36;
                    }
                    case "description": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block36;
                    }
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block36;
                    }
                    case "metafield": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Metafield(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block36;
                    }
                    case "metafields": {
                        ArrayList<Object> list1 = new ArrayList<Object>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            Metafield optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = new Metafield(this.jsonAsObject(element1, key));
                            }
                            list1.add(optional2);
                        }
                        this.responseData.put(key, list1);
                        continue block36;
                    }
                    case "moneyFormat": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block36;
                    }
                    case "name": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block36;
                    }
                    case "paymentSettings": {
                        this.responseData.put(key, new PaymentSettings(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block36;
                    }
                    case "primaryDomain": {
                        this.responseData.put(key, new Domain(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block36;
                    }
                    case "privacyPolicy": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ShopPolicy(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block36;
                    }
                    case "refundPolicy": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ShopPolicy(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block36;
                    }
                    case "shippingPolicy": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ShopPolicy(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block36;
                    }
                    case "shipsToCountries": {
                        ArrayList<Object> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add((Object)CountryCode.fromGraphQl(this.jsonAsString(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block36;
                    }
                    case "subscriptionPolicy": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ShopPolicyWithDefault(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block36;
                    }
                    case "termsOfService": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ShopPolicy(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block36;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block36;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public Shop(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "Shop";
        }

        public Brand getBrand() {
            return (Brand)this.get("brand");
        }

        public Shop setBrand(Brand arg) {
            this.optimisticData.put(this.getKey("brand"), arg);
            return this;
        }

        public String getDescription() {
            return (String)this.get("description");
        }

        public Shop setDescription(String arg) {
            this.optimisticData.put(this.getKey("description"), arg);
            return this;
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        @Override
        public Metafield getMetafield() {
            return (Metafield)this.get("metafield");
        }

        public Shop setMetafield(Metafield arg) {
            this.optimisticData.put(this.getKey("metafield"), arg);
            return this;
        }

        @Override
        public List<Metafield> getMetafields() {
            return (List)this.get("metafields");
        }

        public Shop setMetafields(List<Metafield> arg) {
            this.optimisticData.put(this.getKey("metafields"), arg);
            return this;
        }

        public String getMoneyFormat() {
            return (String)this.get("moneyFormat");
        }

        public Shop setMoneyFormat(String arg) {
            this.optimisticData.put(this.getKey("moneyFormat"), arg);
            return this;
        }

        public String getName() {
            return (String)this.get("name");
        }

        public Shop setName(String arg) {
            this.optimisticData.put(this.getKey("name"), arg);
            return this;
        }

        public PaymentSettings getPaymentSettings() {
            return (PaymentSettings)this.get("paymentSettings");
        }

        public Shop setPaymentSettings(PaymentSettings arg) {
            this.optimisticData.put(this.getKey("paymentSettings"), arg);
            return this;
        }

        public Domain getPrimaryDomain() {
            return (Domain)this.get("primaryDomain");
        }

        public Shop setPrimaryDomain(Domain arg) {
            this.optimisticData.put(this.getKey("primaryDomain"), arg);
            return this;
        }

        public ShopPolicy getPrivacyPolicy() {
            return (ShopPolicy)this.get("privacyPolicy");
        }

        public Shop setPrivacyPolicy(ShopPolicy arg) {
            this.optimisticData.put(this.getKey("privacyPolicy"), arg);
            return this;
        }

        public ShopPolicy getRefundPolicy() {
            return (ShopPolicy)this.get("refundPolicy");
        }

        public Shop setRefundPolicy(ShopPolicy arg) {
            this.optimisticData.put(this.getKey("refundPolicy"), arg);
            return this;
        }

        public ShopPolicy getShippingPolicy() {
            return (ShopPolicy)this.get("shippingPolicy");
        }

        public Shop setShippingPolicy(ShopPolicy arg) {
            this.optimisticData.put(this.getKey("shippingPolicy"), arg);
            return this;
        }

        public List<CountryCode> getShipsToCountries() {
            return (List)this.get("shipsToCountries");
        }

        public Shop setShipsToCountries(List<CountryCode> arg) {
            this.optimisticData.put(this.getKey("shipsToCountries"), arg);
            return this;
        }

        public ShopPolicyWithDefault getSubscriptionPolicy() {
            return (ShopPolicyWithDefault)this.get("subscriptionPolicy");
        }

        public Shop setSubscriptionPolicy(ShopPolicyWithDefault arg) {
            this.optimisticData.put(this.getKey("subscriptionPolicy"), arg);
            return this;
        }

        public ShopPolicy getTermsOfService() {
            return (ShopPolicy)this.get("termsOfService");
        }

        public Shop setTermsOfService(ShopPolicy arg) {
            this.optimisticData.put(this.getKey("termsOfService"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "brand": {
                    return true;
                }
                case "description": {
                    return false;
                }
                case "id": {
                    return false;
                }
                case "metafield": {
                    return true;
                }
                case "metafields": {
                    return true;
                }
                case "moneyFormat": {
                    return false;
                }
                case "name": {
                    return false;
                }
                case "paymentSettings": {
                    return true;
                }
                case "primaryDomain": {
                    return true;
                }
                case "privacyPolicy": {
                    return true;
                }
                case "refundPolicy": {
                    return true;
                }
                case "shippingPolicy": {
                    return true;
                }
                case "shipsToCountries": {
                    return false;
                }
                case "subscriptionPolicy": {
                    return true;
                }
                case "termsOfService": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ShopQuery
    extends Query<ShopQuery> {
        ShopQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public ShopQuery brand(BrandQueryDefinition queryDef) {
            this.startField("brand");
            this._queryBuilder.append('{');
            queryDef.define(new BrandQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopQuery description() {
            this.startField("description");
            return this;
        }

        public ShopQuery metafield(String key, MetafieldQueryDefinition queryDef) {
            return this.metafield(key, args -> {}, queryDef);
        }

        public ShopQuery metafield(String key, MetafieldArgumentsDefinition argsDef, MetafieldQueryDefinition queryDef) {
            this.startField("metafield");
            this._queryBuilder.append("(key:");
            Query.appendQuotedString(this._queryBuilder, key.toString());
            argsDef.define(new MetafieldArguments(this._queryBuilder));
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopQuery metafields(List<HasMetafieldsIdentifier> identifiers, MetafieldQueryDefinition queryDef) {
            this.startField("metafields");
            this._queryBuilder.append("(identifiers:");
            this._queryBuilder.append('[');
            String listSeperator1 = "";
            for (HasMetafieldsIdentifier item1 : identifiers) {
                this._queryBuilder.append(listSeperator1);
                listSeperator1 = ",";
                item1.appendTo(this._queryBuilder);
            }
            this._queryBuilder.append(']');
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopQuery moneyFormat() {
            this.startField("moneyFormat");
            return this;
        }

        public ShopQuery name() {
            this.startField("name");
            return this;
        }

        public ShopQuery paymentSettings(PaymentSettingsQueryDefinition queryDef) {
            this.startField("paymentSettings");
            this._queryBuilder.append('{');
            queryDef.define(new PaymentSettingsQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopQuery primaryDomain(DomainQueryDefinition queryDef) {
            this.startField("primaryDomain");
            this._queryBuilder.append('{');
            queryDef.define(new DomainQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopQuery privacyPolicy(ShopPolicyQueryDefinition queryDef) {
            this.startField("privacyPolicy");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPolicyQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopQuery refundPolicy(ShopPolicyQueryDefinition queryDef) {
            this.startField("refundPolicy");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPolicyQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopQuery shippingPolicy(ShopPolicyQueryDefinition queryDef) {
            this.startField("shippingPolicy");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPolicyQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopQuery shipsToCountries() {
            this.startField("shipsToCountries");
            return this;
        }

        public ShopQuery subscriptionPolicy(ShopPolicyWithDefaultQueryDefinition queryDef) {
            this.startField("subscriptionPolicy");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPolicyWithDefaultQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ShopQuery termsOfService(ShopPolicyQueryDefinition queryDef) {
            this.startField("termsOfService");
            this._queryBuilder.append('{');
            queryDef.define(new ShopPolicyQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public static interface MetafieldArgumentsDefinition {
            public void define(MetafieldArguments var1);
        }

        public class MetafieldArguments
        extends Arguments {
            MetafieldArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            public MetafieldArguments namespace(String value) {
                if (value != null) {
                    this.startArgument("namespace");
                    Query.appendQuotedString(ShopQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }
    }

    public static interface ShopQueryDefinition {
        public void define(ShopQuery var1);
    }

    public static class SellingPlanRecurringDeliveryPolicy
    extends AbstractResponse<SellingPlanRecurringDeliveryPolicy>
    implements SellingPlanDeliveryPolicy {
        public SellingPlanRecurringDeliveryPolicy() {
        }

        public SellingPlanRecurringDeliveryPolicy(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "interval": {
                        this.responseData.put(key, SellingPlanInterval.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "intervalCount": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "SellingPlanRecurringDeliveryPolicy";
        }

        public SellingPlanInterval getInterval() {
            return (SellingPlanInterval)((Object)this.get("interval"));
        }

        public SellingPlanRecurringDeliveryPolicy setInterval(SellingPlanInterval arg) {
            this.optimisticData.put(this.getKey("interval"), arg);
            return this;
        }

        public Integer getIntervalCount() {
            return (Integer)this.get("intervalCount");
        }

        public SellingPlanRecurringDeliveryPolicy setIntervalCount(Integer arg) {
            this.optimisticData.put(this.getKey("intervalCount"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "interval": {
                    return false;
                }
                case "intervalCount": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SellingPlanRecurringDeliveryPolicyQuery
    extends Query<SellingPlanRecurringDeliveryPolicyQuery> {
        SellingPlanRecurringDeliveryPolicyQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanRecurringDeliveryPolicyQuery interval() {
            this.startField("interval");
            return this;
        }

        public SellingPlanRecurringDeliveryPolicyQuery intervalCount() {
            this.startField("intervalCount");
            return this;
        }
    }

    public static interface SellingPlanRecurringDeliveryPolicyQueryDefinition {
        public void define(SellingPlanRecurringDeliveryPolicyQuery var1);
    }

    public static class SellingPlanRecurringBillingPolicy
    extends AbstractResponse<SellingPlanRecurringBillingPolicy>
    implements SellingPlanBillingPolicy {
        public SellingPlanRecurringBillingPolicy() {
        }

        public SellingPlanRecurringBillingPolicy(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "interval": {
                        this.responseData.put(key, SellingPlanInterval.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "intervalCount": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "SellingPlanRecurringBillingPolicy";
        }

        public SellingPlanInterval getInterval() {
            return (SellingPlanInterval)((Object)this.get("interval"));
        }

        public SellingPlanRecurringBillingPolicy setInterval(SellingPlanInterval arg) {
            this.optimisticData.put(this.getKey("interval"), arg);
            return this;
        }

        public Integer getIntervalCount() {
            return (Integer)this.get("intervalCount");
        }

        public SellingPlanRecurringBillingPolicy setIntervalCount(Integer arg) {
            this.optimisticData.put(this.getKey("intervalCount"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "interval": {
                    return false;
                }
                case "intervalCount": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SellingPlanRecurringBillingPolicyQuery
    extends Query<SellingPlanRecurringBillingPolicyQuery> {
        SellingPlanRecurringBillingPolicyQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanRecurringBillingPolicyQuery interval() {
            this.startField("interval");
            return this;
        }

        public SellingPlanRecurringBillingPolicyQuery intervalCount() {
            this.startField("intervalCount");
            return this;
        }
    }

    public static interface SellingPlanRecurringBillingPolicyQueryDefinition {
        public void define(SellingPlanRecurringBillingPolicyQuery var1);
    }

    public static class UnknownSellingPlanPriceAdjustmentValue
    extends AbstractResponse<UnknownSellingPlanPriceAdjustmentValue>
    implements SellingPlanPriceAdjustmentValue {
        public UnknownSellingPlanPriceAdjustmentValue() {
        }

        public UnknownSellingPlanPriceAdjustmentValue(JsonObject fields) throws SchemaViolationError {
            block6: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block6;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public static SellingPlanPriceAdjustmentValue create(JsonObject fields) throws SchemaViolationError {
            String typeName;
            switch (typeName = fields.getAsJsonPrimitive("__typename").getAsString()) {
                case "SellingPlanFixedAmountPriceAdjustment": {
                    return new SellingPlanFixedAmountPriceAdjustment(fields);
                }
                case "SellingPlanFixedPriceAdjustment": {
                    return new SellingPlanFixedPriceAdjustment(fields);
                }
                case "SellingPlanPercentagePriceAdjustment": {
                    return new SellingPlanPercentagePriceAdjustment(fields);
                }
            }
            return new UnknownSellingPlanPriceAdjustmentValue(fields);
        }

        @Override
        public String getGraphQlTypeName() {
            return (String)this.get("__typename");
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                default: 
            }
            return false;
        }
    }

    public static interface SellingPlanPriceAdjustmentValue {
        public String getGraphQlTypeName();
    }

    public static class SellingPlanPriceAdjustmentValueQuery
    extends Query<SellingPlanPriceAdjustmentValueQuery> {
        SellingPlanPriceAdjustmentValueQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("__typename");
        }

        public SellingPlanPriceAdjustmentValueQuery onSellingPlanFixedAmountPriceAdjustment(SellingPlanFixedAmountPriceAdjustmentQueryDefinition queryDef) {
            this.startInlineFragment("SellingPlanFixedAmountPriceAdjustment");
            queryDef.define(new SellingPlanFixedAmountPriceAdjustmentQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanPriceAdjustmentValueQuery onSellingPlanFixedPriceAdjustment(SellingPlanFixedPriceAdjustmentQueryDefinition queryDef) {
            this.startInlineFragment("SellingPlanFixedPriceAdjustment");
            queryDef.define(new SellingPlanFixedPriceAdjustmentQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanPriceAdjustmentValueQuery onSellingPlanPercentagePriceAdjustment(SellingPlanPercentagePriceAdjustmentQueryDefinition queryDef) {
            this.startInlineFragment("SellingPlanPercentagePriceAdjustment");
            queryDef.define(new SellingPlanPercentagePriceAdjustmentQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SellingPlanPriceAdjustmentValueQueryDefinition {
        public void define(SellingPlanPriceAdjustmentValueQuery var1);
    }

    public static class SellingPlanPriceAdjustment
    extends AbstractResponse<SellingPlanPriceAdjustment> {
        public SellingPlanPriceAdjustment() {
        }

        public SellingPlanPriceAdjustment(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "adjustmentValue": {
                        this.responseData.put(key, UnknownSellingPlanPriceAdjustmentValue.create(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "orderCount": {
                        Integer optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsInteger((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SellingPlanPriceAdjustment";
        }

        public SellingPlanPriceAdjustmentValue getAdjustmentValue() {
            return (SellingPlanPriceAdjustmentValue)this.get("adjustmentValue");
        }

        public SellingPlanPriceAdjustment setAdjustmentValue(SellingPlanPriceAdjustmentValue arg) {
            this.optimisticData.put(this.getKey("adjustmentValue"), arg);
            return this;
        }

        public Integer getOrderCount() {
            return (Integer)this.get("orderCount");
        }

        public SellingPlanPriceAdjustment setOrderCount(Integer arg) {
            this.optimisticData.put(this.getKey("orderCount"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "adjustmentValue": {
                    return false;
                }
                case "orderCount": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SellingPlanPriceAdjustmentQuery
    extends Query<SellingPlanPriceAdjustmentQuery> {
        SellingPlanPriceAdjustmentQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanPriceAdjustmentQuery adjustmentValue(SellingPlanPriceAdjustmentValueQueryDefinition queryDef) {
            this.startField("adjustmentValue");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanPriceAdjustmentValueQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanPriceAdjustmentQuery orderCount() {
            this.startField("orderCount");
            return this;
        }
    }

    public static interface SellingPlanPriceAdjustmentQueryDefinition {
        public void define(SellingPlanPriceAdjustmentQuery var1);
    }

    public static class SellingPlanPercentagePriceAdjustment
    extends AbstractResponse<SellingPlanPercentagePriceAdjustment>
    implements SellingPlanPriceAdjustmentValue {
        public SellingPlanPercentagePriceAdjustment() {
        }

        public SellingPlanPercentagePriceAdjustment(JsonObject fields) throws SchemaViolationError {
            block8: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "adjustmentPercentage": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "SellingPlanPercentagePriceAdjustment";
        }

        public Integer getAdjustmentPercentage() {
            return (Integer)this.get("adjustmentPercentage");
        }

        public SellingPlanPercentagePriceAdjustment setAdjustmentPercentage(Integer arg) {
            this.optimisticData.put(this.getKey("adjustmentPercentage"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "adjustmentPercentage": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SellingPlanPercentagePriceAdjustmentQuery
    extends Query<SellingPlanPercentagePriceAdjustmentQuery> {
        SellingPlanPercentagePriceAdjustmentQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanPercentagePriceAdjustmentQuery adjustmentPercentage() {
            this.startField("adjustmentPercentage");
            return this;
        }
    }

    public static interface SellingPlanPercentagePriceAdjustmentQueryDefinition {
        public void define(SellingPlanPercentagePriceAdjustmentQuery var1);
    }

    public static class SellingPlanOption
    extends AbstractResponse<SellingPlanOption> {
        public SellingPlanOption() {
        }

        public SellingPlanOption(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "name": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "value": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SellingPlanOption";
        }

        public String getName() {
            return (String)this.get("name");
        }

        public SellingPlanOption setName(String arg) {
            this.optimisticData.put(this.getKey("name"), arg);
            return this;
        }

        public String getValue() {
            return (String)this.get("value");
        }

        public SellingPlanOption setValue(String arg) {
            this.optimisticData.put(this.getKey("value"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "name": {
                    return false;
                }
                case "value": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SellingPlanOptionQuery
    extends Query<SellingPlanOptionQuery> {
        SellingPlanOptionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanOptionQuery name() {
            this.startField("name");
            return this;
        }

        public SellingPlanOptionQuery value() {
            this.startField("value");
            return this;
        }
    }

    public static interface SellingPlanOptionQueryDefinition {
        public void define(SellingPlanOptionQuery var1);
    }

    public static enum SellingPlanInterval {
        DAY,
        MONTH,
        WEEK,
        YEAR,
        UNKNOWN_VALUE;


        public static SellingPlanInterval fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "DAY": {
                    return DAY;
                }
                case "MONTH": {
                    return MONTH;
                }
                case "WEEK": {
                    return WEEK;
                }
                case "YEAR": {
                    return YEAR;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case DAY: {
                    return "DAY";
                }
                case MONTH: {
                    return "MONTH";
                }
                case WEEK: {
                    return "WEEK";
                }
                case YEAR: {
                    return "YEAR";
                }
            }
            return "";
        }
    }

    public static class SellingPlanGroupOption
    extends AbstractResponse<SellingPlanGroupOption> {
        public SellingPlanGroupOption() {
        }

        public SellingPlanGroupOption(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "name": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "values": {
                        ArrayList<String> list1 = new ArrayList<String>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(this.jsonAsString(element1, key));
                        }
                        this.responseData.put(key, list1);
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SellingPlanGroupOption";
        }

        public String getName() {
            return (String)this.get("name");
        }

        public SellingPlanGroupOption setName(String arg) {
            this.optimisticData.put(this.getKey("name"), arg);
            return this;
        }

        public List<String> getValues() {
            return (List)this.get("values");
        }

        public SellingPlanGroupOption setValues(List<String> arg) {
            this.optimisticData.put(this.getKey("values"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "name": {
                    return false;
                }
                case "values": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SellingPlanGroupOptionQuery
    extends Query<SellingPlanGroupOptionQuery> {
        SellingPlanGroupOptionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanGroupOptionQuery name() {
            this.startField("name");
            return this;
        }

        public SellingPlanGroupOptionQuery values() {
            this.startField("values");
            return this;
        }
    }

    public static interface SellingPlanGroupOptionQueryDefinition {
        public void define(SellingPlanGroupOptionQuery var1);
    }

    public static class SellingPlanGroupEdge
    extends AbstractResponse<SellingPlanGroupEdge> {
        public SellingPlanGroupEdge() {
        }

        public SellingPlanGroupEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, new SellingPlanGroup(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SellingPlanGroupEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public SellingPlanGroupEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public SellingPlanGroup getNode() {
            return (SellingPlanGroup)this.get("node");
        }

        public SellingPlanGroupEdge setNode(SellingPlanGroup arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class SellingPlanGroupEdgeQuery
    extends Query<SellingPlanGroupEdgeQuery> {
        SellingPlanGroupEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanGroupEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public SellingPlanGroupEdgeQuery node(SellingPlanGroupQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanGroupQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SellingPlanGroupEdgeQueryDefinition {
        public void define(SellingPlanGroupEdgeQuery var1);
    }

    public static class SellingPlanGroupConnection
    extends AbstractResponse<SellingPlanGroupConnection> {
        public SellingPlanGroupConnection() {
        }

        public SellingPlanGroupConnection(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new SellingPlanGroupEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "nodes": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new SellingPlanGroup(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SellingPlanGroupConnection";
        }

        public List<SellingPlanGroupEdge> getEdges() {
            return (List)this.get("edges");
        }

        public SellingPlanGroupConnection setEdges(List<SellingPlanGroupEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<SellingPlanGroup> getNodes() {
            return (List)this.get("nodes");
        }

        public SellingPlanGroupConnection setNodes(List<SellingPlanGroup> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public SellingPlanGroupConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "nodes": {
                    return true;
                }
                case "pageInfo": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class SellingPlanGroupConnectionQuery
    extends Query<SellingPlanGroupConnectionQuery> {
        SellingPlanGroupConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanGroupConnectionQuery edges(SellingPlanGroupEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanGroupEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanGroupConnectionQuery nodes(SellingPlanGroupQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanGroupQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanGroupConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SellingPlanGroupConnectionQueryDefinition {
        public void define(SellingPlanGroupConnectionQuery var1);
    }

    public static class SellingPlanGroup
    extends AbstractResponse<SellingPlanGroup> {
        public SellingPlanGroup() {
        }

        public SellingPlanGroup(JsonObject fields) throws SchemaViolationError {
            block14: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "appName": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block14;
                    }
                    case "name": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "options": {
                        ArrayList<SellingPlanGroupOption> list1 = new ArrayList<SellingPlanGroupOption>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new SellingPlanGroupOption(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block14;
                    }
                    case "sellingPlans": {
                        this.responseData.put(key, new SellingPlanConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block14;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SellingPlanGroup";
        }

        public String getAppName() {
            return (String)this.get("appName");
        }

        public SellingPlanGroup setAppName(String arg) {
            this.optimisticData.put(this.getKey("appName"), arg);
            return this;
        }

        public String getName() {
            return (String)this.get("name");
        }

        public SellingPlanGroup setName(String arg) {
            this.optimisticData.put(this.getKey("name"), arg);
            return this;
        }

        public List<SellingPlanGroupOption> getOptions() {
            return (List)this.get("options");
        }

        public SellingPlanGroup setOptions(List<SellingPlanGroupOption> arg) {
            this.optimisticData.put(this.getKey("options"), arg);
            return this;
        }

        public SellingPlanConnection getSellingPlans() {
            return (SellingPlanConnection)this.get("sellingPlans");
        }

        public SellingPlanGroup setSellingPlans(SellingPlanConnection arg) {
            this.optimisticData.put(this.getKey("sellingPlans"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "appName": {
                    return false;
                }
                case "name": {
                    return false;
                }
                case "options": {
                    return true;
                }
                case "sellingPlans": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class SellingPlanGroupQuery
    extends Query<SellingPlanGroupQuery> {
        SellingPlanGroupQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanGroupQuery appName() {
            this.startField("appName");
            return this;
        }

        public SellingPlanGroupQuery name() {
            this.startField("name");
            return this;
        }

        public SellingPlanGroupQuery options(SellingPlanGroupOptionQueryDefinition queryDef) {
            this.startField("options");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanGroupOptionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanGroupQuery sellingPlans(SellingPlanConnectionQueryDefinition queryDef) {
            return this.sellingPlans(args -> {}, queryDef);
        }

        public SellingPlanGroupQuery sellingPlans(SellingPlansArgumentsDefinition argsDef, SellingPlanConnectionQueryDefinition queryDef) {
            this.startField("sellingPlans");
            SellingPlansArguments args = new SellingPlansArguments(this._queryBuilder);
            argsDef.define(args);
            SellingPlansArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public static interface SellingPlansArgumentsDefinition {
            public void define(SellingPlansArguments var1);
        }

        public class SellingPlansArguments
        extends Arguments {
            SellingPlansArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public SellingPlansArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    SellingPlanGroupQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public SellingPlansArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(SellingPlanGroupQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public SellingPlansArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    SellingPlanGroupQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public SellingPlansArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(SellingPlanGroupQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public SellingPlansArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    SellingPlanGroupQuery.this._queryBuilder.append(value);
                }
                return this;
            }
        }
    }

    public static interface SellingPlanGroupQueryDefinition {
        public void define(SellingPlanGroupQuery var1);
    }

    public static class SellingPlanFixedPriceAdjustment
    extends AbstractResponse<SellingPlanFixedPriceAdjustment>
    implements SellingPlanPriceAdjustmentValue {
        public SellingPlanFixedPriceAdjustment() {
        }

        public SellingPlanFixedPriceAdjustment(JsonObject fields) throws SchemaViolationError {
            block8: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "price": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block8;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "SellingPlanFixedPriceAdjustment";
        }

        public MoneyV2 getPrice() {
            return (MoneyV2)this.get("price");
        }

        public SellingPlanFixedPriceAdjustment setPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("price"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "price": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class SellingPlanFixedPriceAdjustmentQuery
    extends Query<SellingPlanFixedPriceAdjustmentQuery> {
        SellingPlanFixedPriceAdjustmentQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanFixedPriceAdjustmentQuery price(MoneyV2QueryDefinition queryDef) {
            this.startField("price");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SellingPlanFixedPriceAdjustmentQueryDefinition {
        public void define(SellingPlanFixedPriceAdjustmentQuery var1);
    }

    public static class SellingPlanFixedAmountPriceAdjustment
    extends AbstractResponse<SellingPlanFixedAmountPriceAdjustment>
    implements SellingPlanPriceAdjustmentValue {
        public SellingPlanFixedAmountPriceAdjustment() {
        }

        public SellingPlanFixedAmountPriceAdjustment(JsonObject fields) throws SchemaViolationError {
            block8: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "adjustmentAmount": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block8;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "SellingPlanFixedAmountPriceAdjustment";
        }

        public MoneyV2 getAdjustmentAmount() {
            return (MoneyV2)this.get("adjustmentAmount");
        }

        public SellingPlanFixedAmountPriceAdjustment setAdjustmentAmount(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("adjustmentAmount"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "adjustmentAmount": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class SellingPlanFixedAmountPriceAdjustmentQuery
    extends Query<SellingPlanFixedAmountPriceAdjustmentQuery> {
        SellingPlanFixedAmountPriceAdjustmentQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanFixedAmountPriceAdjustmentQuery adjustmentAmount(MoneyV2QueryDefinition queryDef) {
            this.startField("adjustmentAmount");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SellingPlanFixedAmountPriceAdjustmentQueryDefinition {
        public void define(SellingPlanFixedAmountPriceAdjustmentQuery var1);
    }

    public static class SellingPlanEdge
    extends AbstractResponse<SellingPlanEdge> {
        public SellingPlanEdge() {
        }

        public SellingPlanEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, new SellingPlan(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SellingPlanEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public SellingPlanEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public SellingPlan getNode() {
            return (SellingPlan)this.get("node");
        }

        public SellingPlanEdge setNode(SellingPlan arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class SellingPlanEdgeQuery
    extends Query<SellingPlanEdgeQuery> {
        SellingPlanEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public SellingPlanEdgeQuery node(SellingPlanQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SellingPlanEdgeQueryDefinition {
        public void define(SellingPlanEdgeQuery var1);
    }

    public static class UnknownSellingPlanDeliveryPolicy
    extends AbstractResponse<UnknownSellingPlanDeliveryPolicy>
    implements SellingPlanDeliveryPolicy {
        public UnknownSellingPlanDeliveryPolicy() {
        }

        public UnknownSellingPlanDeliveryPolicy(JsonObject fields) throws SchemaViolationError {
            block6: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block6;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public static SellingPlanDeliveryPolicy create(JsonObject fields) throws SchemaViolationError {
            String typeName;
            switch (typeName = fields.getAsJsonPrimitive("__typename").getAsString()) {
                case "SellingPlanRecurringDeliveryPolicy": {
                    return new SellingPlanRecurringDeliveryPolicy(fields);
                }
            }
            return new UnknownSellingPlanDeliveryPolicy(fields);
        }

        @Override
        public String getGraphQlTypeName() {
            return (String)this.get("__typename");
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                default: 
            }
            return false;
        }
    }

    public static interface SellingPlanDeliveryPolicy {
        public String getGraphQlTypeName();
    }

    public static class SellingPlanDeliveryPolicyQuery
    extends Query<SellingPlanDeliveryPolicyQuery> {
        SellingPlanDeliveryPolicyQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("__typename");
        }

        public SellingPlanDeliveryPolicyQuery onSellingPlanRecurringDeliveryPolicy(SellingPlanRecurringDeliveryPolicyQueryDefinition queryDef) {
            this.startInlineFragment("SellingPlanRecurringDeliveryPolicy");
            queryDef.define(new SellingPlanRecurringDeliveryPolicyQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SellingPlanDeliveryPolicyQueryDefinition {
        public void define(SellingPlanDeliveryPolicyQuery var1);
    }

    public static class SellingPlanConnection
    extends AbstractResponse<SellingPlanConnection> {
        public SellingPlanConnection() {
        }

        public SellingPlanConnection(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new SellingPlanEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "nodes": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new SellingPlan(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SellingPlanConnection";
        }

        public List<SellingPlanEdge> getEdges() {
            return (List)this.get("edges");
        }

        public SellingPlanConnection setEdges(List<SellingPlanEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<SellingPlan> getNodes() {
            return (List)this.get("nodes");
        }

        public SellingPlanConnection setNodes(List<SellingPlan> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public SellingPlanConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "nodes": {
                    return true;
                }
                case "pageInfo": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class SellingPlanConnectionQuery
    extends Query<SellingPlanConnectionQuery> {
        SellingPlanConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanConnectionQuery edges(SellingPlanEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanConnectionQuery nodes(SellingPlanQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SellingPlanConnectionQueryDefinition {
        public void define(SellingPlanConnectionQuery var1);
    }

    public static class UnknownSellingPlanCheckoutChargeValue
    extends AbstractResponse<UnknownSellingPlanCheckoutChargeValue>
    implements SellingPlanCheckoutChargeValue {
        public UnknownSellingPlanCheckoutChargeValue() {
        }

        public UnknownSellingPlanCheckoutChargeValue(JsonObject fields) throws SchemaViolationError {
            block6: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block6;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public static SellingPlanCheckoutChargeValue create(JsonObject fields) throws SchemaViolationError {
            String typeName;
            switch (typeName = fields.getAsJsonPrimitive("__typename").getAsString()) {
                case "MoneyV2": {
                    return new MoneyV2(fields);
                }
                case "SellingPlanCheckoutChargePercentageValue": {
                    return new SellingPlanCheckoutChargePercentageValue(fields);
                }
            }
            return new UnknownSellingPlanCheckoutChargeValue(fields);
        }

        @Override
        public String getGraphQlTypeName() {
            return (String)this.get("__typename");
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                default: 
            }
            return false;
        }
    }

    public static interface SellingPlanCheckoutChargeValue {
        public String getGraphQlTypeName();
    }

    public static class SellingPlanCheckoutChargeValueQuery
    extends Query<SellingPlanCheckoutChargeValueQuery> {
        SellingPlanCheckoutChargeValueQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("__typename");
        }

        public SellingPlanCheckoutChargeValueQuery onMoneyV2(MoneyV2QueryDefinition queryDef) {
            this.startInlineFragment("MoneyV2");
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanCheckoutChargeValueQuery onSellingPlanCheckoutChargePercentageValue(SellingPlanCheckoutChargePercentageValueQueryDefinition queryDef) {
            this.startInlineFragment("SellingPlanCheckoutChargePercentageValue");
            queryDef.define(new SellingPlanCheckoutChargePercentageValueQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SellingPlanCheckoutChargeValueQueryDefinition {
        public void define(SellingPlanCheckoutChargeValueQuery var1);
    }

    public static enum SellingPlanCheckoutChargeType {
        PERCENTAGE,
        PRICE,
        UNKNOWN_VALUE;


        public static SellingPlanCheckoutChargeType fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "PERCENTAGE": {
                    return PERCENTAGE;
                }
                case "PRICE": {
                    return PRICE;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case PERCENTAGE: {
                    return "PERCENTAGE";
                }
                case PRICE: {
                    return "PRICE";
                }
            }
            return "";
        }
    }

    public static class SellingPlanCheckoutChargePercentageValue
    extends AbstractResponse<SellingPlanCheckoutChargePercentageValue>
    implements SellingPlanCheckoutChargeValue {
        public SellingPlanCheckoutChargePercentageValue() {
        }

        public SellingPlanCheckoutChargePercentageValue(JsonObject fields) throws SchemaViolationError {
            block8: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "percentage": {
                        this.responseData.put(key, this.jsonAsDouble((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "SellingPlanCheckoutChargePercentageValue";
        }

        public Double getPercentage() {
            return (Double)this.get("percentage");
        }

        public SellingPlanCheckoutChargePercentageValue setPercentage(Double arg) {
            this.optimisticData.put(this.getKey("percentage"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "percentage": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SellingPlanCheckoutChargePercentageValueQuery
    extends Query<SellingPlanCheckoutChargePercentageValueQuery> {
        SellingPlanCheckoutChargePercentageValueQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanCheckoutChargePercentageValueQuery percentage() {
            this.startField("percentage");
            return this;
        }
    }

    public static interface SellingPlanCheckoutChargePercentageValueQueryDefinition {
        public void define(SellingPlanCheckoutChargePercentageValueQuery var1);
    }

    public static class SellingPlanCheckoutCharge
    extends AbstractResponse<SellingPlanCheckoutCharge> {
        public SellingPlanCheckoutCharge() {
        }

        public SellingPlanCheckoutCharge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "type": {
                        this.responseData.put(key, SellingPlanCheckoutChargeType.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "value": {
                        this.responseData.put(key, UnknownSellingPlanCheckoutChargeValue.create(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SellingPlanCheckoutCharge";
        }

        public SellingPlanCheckoutChargeType getType() {
            return (SellingPlanCheckoutChargeType)((Object)this.get("type"));
        }

        public SellingPlanCheckoutCharge setType(SellingPlanCheckoutChargeType arg) {
            this.optimisticData.put(this.getKey("type"), arg);
            return this;
        }

        public SellingPlanCheckoutChargeValue getValue() {
            return (SellingPlanCheckoutChargeValue)this.get("value");
        }

        public SellingPlanCheckoutCharge setValue(SellingPlanCheckoutChargeValue arg) {
            this.optimisticData.put(this.getKey("value"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "type": {
                    return false;
                }
                case "value": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SellingPlanCheckoutChargeQuery
    extends Query<SellingPlanCheckoutChargeQuery> {
        SellingPlanCheckoutChargeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanCheckoutChargeQuery type() {
            this.startField("type");
            return this;
        }

        public SellingPlanCheckoutChargeQuery value(SellingPlanCheckoutChargeValueQueryDefinition queryDef) {
            this.startField("value");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanCheckoutChargeValueQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SellingPlanCheckoutChargeQueryDefinition {
        public void define(SellingPlanCheckoutChargeQuery var1);
    }

    public static class UnknownSellingPlanBillingPolicy
    extends AbstractResponse<UnknownSellingPlanBillingPolicy>
    implements SellingPlanBillingPolicy {
        public UnknownSellingPlanBillingPolicy() {
        }

        public UnknownSellingPlanBillingPolicy(JsonObject fields) throws SchemaViolationError {
            block6: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block6;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public static SellingPlanBillingPolicy create(JsonObject fields) throws SchemaViolationError {
            String typeName;
            switch (typeName = fields.getAsJsonPrimitive("__typename").getAsString()) {
                case "SellingPlanRecurringBillingPolicy": {
                    return new SellingPlanRecurringBillingPolicy(fields);
                }
            }
            return new UnknownSellingPlanBillingPolicy(fields);
        }

        @Override
        public String getGraphQlTypeName() {
            return (String)this.get("__typename");
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                default: 
            }
            return false;
        }
    }

    public static interface SellingPlanBillingPolicy {
        public String getGraphQlTypeName();
    }

    public static class SellingPlanBillingPolicyQuery
    extends Query<SellingPlanBillingPolicyQuery> {
        SellingPlanBillingPolicyQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("__typename");
        }

        public SellingPlanBillingPolicyQuery onSellingPlanRecurringBillingPolicy(SellingPlanRecurringBillingPolicyQueryDefinition queryDef) {
            this.startInlineFragment("SellingPlanRecurringBillingPolicy");
            queryDef.define(new SellingPlanRecurringBillingPolicyQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SellingPlanBillingPolicyQueryDefinition {
        public void define(SellingPlanBillingPolicyQuery var1);
    }

    public static class SellingPlanAllocationPriceAdjustment
    extends AbstractResponse<SellingPlanAllocationPriceAdjustment> {
        public SellingPlanAllocationPriceAdjustment() {
        }

        public SellingPlanAllocationPriceAdjustment(JsonObject fields) throws SchemaViolationError {
            block14: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "compareAtPrice": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block14;
                    }
                    case "perDeliveryPrice": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block14;
                    }
                    case "price": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block14;
                    }
                    case "unitPrice": {
                        MoneyV2 optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block14;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SellingPlanAllocationPriceAdjustment";
        }

        public MoneyV2 getCompareAtPrice() {
            return (MoneyV2)this.get("compareAtPrice");
        }

        public SellingPlanAllocationPriceAdjustment setCompareAtPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("compareAtPrice"), arg);
            return this;
        }

        public MoneyV2 getPerDeliveryPrice() {
            return (MoneyV2)this.get("perDeliveryPrice");
        }

        public SellingPlanAllocationPriceAdjustment setPerDeliveryPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("perDeliveryPrice"), arg);
            return this;
        }

        public MoneyV2 getPrice() {
            return (MoneyV2)this.get("price");
        }

        public SellingPlanAllocationPriceAdjustment setPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("price"), arg);
            return this;
        }

        public MoneyV2 getUnitPrice() {
            return (MoneyV2)this.get("unitPrice");
        }

        public SellingPlanAllocationPriceAdjustment setUnitPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("unitPrice"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "compareAtPrice": {
                    return true;
                }
                case "perDeliveryPrice": {
                    return true;
                }
                case "price": {
                    return true;
                }
                case "unitPrice": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class SellingPlanAllocationPriceAdjustmentQuery
    extends Query<SellingPlanAllocationPriceAdjustmentQuery> {
        SellingPlanAllocationPriceAdjustmentQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanAllocationPriceAdjustmentQuery compareAtPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("compareAtPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanAllocationPriceAdjustmentQuery perDeliveryPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("perDeliveryPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanAllocationPriceAdjustmentQuery price(MoneyV2QueryDefinition queryDef) {
            this.startField("price");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanAllocationPriceAdjustmentQuery unitPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("unitPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SellingPlanAllocationPriceAdjustmentQueryDefinition {
        public void define(SellingPlanAllocationPriceAdjustmentQuery var1);
    }

    public static class SellingPlanAllocationEdge
    extends AbstractResponse<SellingPlanAllocationEdge> {
        public SellingPlanAllocationEdge() {
        }

        public SellingPlanAllocationEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, new SellingPlanAllocation(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SellingPlanAllocationEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public SellingPlanAllocationEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public SellingPlanAllocation getNode() {
            return (SellingPlanAllocation)this.get("node");
        }

        public SellingPlanAllocationEdge setNode(SellingPlanAllocation arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class SellingPlanAllocationEdgeQuery
    extends Query<SellingPlanAllocationEdgeQuery> {
        SellingPlanAllocationEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanAllocationEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public SellingPlanAllocationEdgeQuery node(SellingPlanAllocationQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanAllocationQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SellingPlanAllocationEdgeQueryDefinition {
        public void define(SellingPlanAllocationEdgeQuery var1);
    }

    public static class SellingPlanAllocationConnection
    extends AbstractResponse<SellingPlanAllocationConnection> {
        public SellingPlanAllocationConnection() {
        }

        public SellingPlanAllocationConnection(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new SellingPlanAllocationEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "nodes": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new SellingPlanAllocation(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SellingPlanAllocationConnection";
        }

        public List<SellingPlanAllocationEdge> getEdges() {
            return (List)this.get("edges");
        }

        public SellingPlanAllocationConnection setEdges(List<SellingPlanAllocationEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<SellingPlanAllocation> getNodes() {
            return (List)this.get("nodes");
        }

        public SellingPlanAllocationConnection setNodes(List<SellingPlanAllocation> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public SellingPlanAllocationConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "nodes": {
                    return true;
                }
                case "pageInfo": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class SellingPlanAllocationConnectionQuery
    extends Query<SellingPlanAllocationConnectionQuery> {
        SellingPlanAllocationConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanAllocationConnectionQuery edges(SellingPlanAllocationEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanAllocationEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanAllocationConnectionQuery nodes(SellingPlanAllocationQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanAllocationQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanAllocationConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SellingPlanAllocationConnectionQueryDefinition {
        public void define(SellingPlanAllocationConnectionQuery var1);
    }

    public static class SellingPlanAllocation
    extends AbstractResponse<SellingPlanAllocation> {
        public SellingPlanAllocation() {
        }

        public SellingPlanAllocation(JsonObject fields) throws SchemaViolationError {
            block14: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "checkoutChargeAmount": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block14;
                    }
                    case "priceAdjustments": {
                        ArrayList<SellingPlanAllocationPriceAdjustment> list1 = new ArrayList<SellingPlanAllocationPriceAdjustment>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new SellingPlanAllocationPriceAdjustment(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block14;
                    }
                    case "remainingBalanceChargeAmount": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block14;
                    }
                    case "sellingPlan": {
                        this.responseData.put(key, new SellingPlan(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block14;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SellingPlanAllocation";
        }

        public MoneyV2 getCheckoutChargeAmount() {
            return (MoneyV2)this.get("checkoutChargeAmount");
        }

        public SellingPlanAllocation setCheckoutChargeAmount(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("checkoutChargeAmount"), arg);
            return this;
        }

        public List<SellingPlanAllocationPriceAdjustment> getPriceAdjustments() {
            return (List)this.get("priceAdjustments");
        }

        public SellingPlanAllocation setPriceAdjustments(List<SellingPlanAllocationPriceAdjustment> arg) {
            this.optimisticData.put(this.getKey("priceAdjustments"), arg);
            return this;
        }

        public MoneyV2 getRemainingBalanceChargeAmount() {
            return (MoneyV2)this.get("remainingBalanceChargeAmount");
        }

        public SellingPlanAllocation setRemainingBalanceChargeAmount(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("remainingBalanceChargeAmount"), arg);
            return this;
        }

        public SellingPlan getSellingPlan() {
            return (SellingPlan)this.get("sellingPlan");
        }

        public SellingPlanAllocation setSellingPlan(SellingPlan arg) {
            this.optimisticData.put(this.getKey("sellingPlan"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "checkoutChargeAmount": {
                    return true;
                }
                case "priceAdjustments": {
                    return true;
                }
                case "remainingBalanceChargeAmount": {
                    return true;
                }
                case "sellingPlan": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class SellingPlanAllocationQuery
    extends Query<SellingPlanAllocationQuery> {
        SellingPlanAllocationQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanAllocationQuery checkoutChargeAmount(MoneyV2QueryDefinition queryDef) {
            this.startField("checkoutChargeAmount");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanAllocationQuery priceAdjustments(SellingPlanAllocationPriceAdjustmentQueryDefinition queryDef) {
            this.startField("priceAdjustments");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanAllocationPriceAdjustmentQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanAllocationQuery remainingBalanceChargeAmount(MoneyV2QueryDefinition queryDef) {
            this.startField("remainingBalanceChargeAmount");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanAllocationQuery sellingPlan(SellingPlanQueryDefinition queryDef) {
            this.startField("sellingPlan");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SellingPlanAllocationQueryDefinition {
        public void define(SellingPlanAllocationQuery var1);
    }

    public static class SellingPlan
    extends AbstractResponse<SellingPlan>
    implements HasMetafields,
    MetafieldParentResource {
        public SellingPlan() {
        }

        public SellingPlan(JsonObject fields) throws SchemaViolationError {
            block28: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "billingPolicy": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = UnknownSellingPlanBillingPolicy.create(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "checkoutCharge": {
                        this.responseData.put(key, new SellingPlanCheckoutCharge(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block28;
                    }
                    case "deliveryPolicy": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = UnknownSellingPlanDeliveryPolicy.create(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "description": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block28;
                    }
                    case "metafield": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Metafield(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "metafields": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            Metafield optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = new Metafield(this.jsonAsObject(element1, key));
                            }
                            list1.add(optional2);
                        }
                        this.responseData.put(key, list1);
                        continue block28;
                    }
                    case "name": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                    case "options": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new SellingPlanOption(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block28;
                    }
                    case "priceAdjustments": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new SellingPlanPriceAdjustment(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block28;
                    }
                    case "recurringDeliveries": {
                        this.responseData.put(key, this.jsonAsBoolean((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "SellingPlan";
        }

        public SellingPlanBillingPolicy getBillingPolicy() {
            return (SellingPlanBillingPolicy)this.get("billingPolicy");
        }

        public SellingPlan setBillingPolicy(SellingPlanBillingPolicy arg) {
            this.optimisticData.put(this.getKey("billingPolicy"), arg);
            return this;
        }

        public SellingPlanCheckoutCharge getCheckoutCharge() {
            return (SellingPlanCheckoutCharge)this.get("checkoutCharge");
        }

        public SellingPlan setCheckoutCharge(SellingPlanCheckoutCharge arg) {
            this.optimisticData.put(this.getKey("checkoutCharge"), arg);
            return this;
        }

        public SellingPlanDeliveryPolicy getDeliveryPolicy() {
            return (SellingPlanDeliveryPolicy)this.get("deliveryPolicy");
        }

        public SellingPlan setDeliveryPolicy(SellingPlanDeliveryPolicy arg) {
            this.optimisticData.put(this.getKey("deliveryPolicy"), arg);
            return this;
        }

        public String getDescription() {
            return (String)this.get("description");
        }

        public SellingPlan setDescription(String arg) {
            this.optimisticData.put(this.getKey("description"), arg);
            return this;
        }

        public ID getId() {
            return (ID)this.get("id");
        }

        public SellingPlan setId(ID arg) {
            this.optimisticData.put(this.getKey("id"), arg);
            return this;
        }

        @Override
        public Metafield getMetafield() {
            return (Metafield)this.get("metafield");
        }

        public SellingPlan setMetafield(Metafield arg) {
            this.optimisticData.put(this.getKey("metafield"), arg);
            return this;
        }

        @Override
        public List<Metafield> getMetafields() {
            return (List)this.get("metafields");
        }

        public SellingPlan setMetafields(List<Metafield> arg) {
            this.optimisticData.put(this.getKey("metafields"), arg);
            return this;
        }

        public String getName() {
            return (String)this.get("name");
        }

        public SellingPlan setName(String arg) {
            this.optimisticData.put(this.getKey("name"), arg);
            return this;
        }

        public List<SellingPlanOption> getOptions() {
            return (List)this.get("options");
        }

        public SellingPlan setOptions(List<SellingPlanOption> arg) {
            this.optimisticData.put(this.getKey("options"), arg);
            return this;
        }

        public List<SellingPlanPriceAdjustment> getPriceAdjustments() {
            return (List)this.get("priceAdjustments");
        }

        public SellingPlan setPriceAdjustments(List<SellingPlanPriceAdjustment> arg) {
            this.optimisticData.put(this.getKey("priceAdjustments"), arg);
            return this;
        }

        public Boolean getRecurringDeliveries() {
            return (Boolean)this.get("recurringDeliveries");
        }

        public SellingPlan setRecurringDeliveries(Boolean arg) {
            this.optimisticData.put(this.getKey("recurringDeliveries"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "billingPolicy": {
                    return false;
                }
                case "checkoutCharge": {
                    return true;
                }
                case "deliveryPolicy": {
                    return false;
                }
                case "description": {
                    return false;
                }
                case "id": {
                    return false;
                }
                case "metafield": {
                    return true;
                }
                case "metafields": {
                    return true;
                }
                case "name": {
                    return false;
                }
                case "options": {
                    return true;
                }
                case "priceAdjustments": {
                    return true;
                }
                case "recurringDeliveries": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SellingPlanQuery
    extends Query<SellingPlanQuery> {
        SellingPlanQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SellingPlanQuery billingPolicy(SellingPlanBillingPolicyQueryDefinition queryDef) {
            this.startField("billingPolicy");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanBillingPolicyQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanQuery checkoutCharge(SellingPlanCheckoutChargeQueryDefinition queryDef) {
            this.startField("checkoutCharge");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanCheckoutChargeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanQuery deliveryPolicy(SellingPlanDeliveryPolicyQueryDefinition queryDef) {
            this.startField("deliveryPolicy");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanDeliveryPolicyQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanQuery description() {
            this.startField("description");
            return this;
        }

        public SellingPlanQuery id() {
            this.startField("id");
            return this;
        }

        public SellingPlanQuery metafield(String key, MetafieldQueryDefinition queryDef) {
            return this.metafield(key, args -> {}, queryDef);
        }

        public SellingPlanQuery metafield(String key, MetafieldArgumentsDefinition argsDef, MetafieldQueryDefinition queryDef) {
            this.startField("metafield");
            this._queryBuilder.append("(key:");
            Query.appendQuotedString(this._queryBuilder, key.toString());
            argsDef.define(new MetafieldArguments(this._queryBuilder));
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanQuery metafields(List<HasMetafieldsIdentifier> identifiers, MetafieldQueryDefinition queryDef) {
            this.startField("metafields");
            this._queryBuilder.append("(identifiers:");
            this._queryBuilder.append('[');
            String listSeperator1 = "";
            for (HasMetafieldsIdentifier item1 : identifiers) {
                this._queryBuilder.append(listSeperator1);
                listSeperator1 = ",";
                item1.appendTo(this._queryBuilder);
            }
            this._queryBuilder.append(']');
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanQuery name() {
            this.startField("name");
            return this;
        }

        public SellingPlanQuery options(SellingPlanOptionQueryDefinition queryDef) {
            this.startField("options");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanOptionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanQuery priceAdjustments(SellingPlanPriceAdjustmentQueryDefinition queryDef) {
            this.startField("priceAdjustments");
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanPriceAdjustmentQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SellingPlanQuery recurringDeliveries() {
            this.startField("recurringDeliveries");
            return this;
        }

        public static interface MetafieldArgumentsDefinition {
            public void define(MetafieldArguments var1);
        }

        public class MetafieldArguments
        extends Arguments {
            MetafieldArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            public MetafieldArguments namespace(String value) {
                if (value != null) {
                    this.startArgument("namespace");
                    Query.appendQuotedString(SellingPlanQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }
    }

    public static interface SellingPlanQueryDefinition {
        public void define(SellingPlanQuery var1);
    }

    public static class SelectedOptionInput
    implements Serializable {
        private String name;
        private String value;

        public SelectedOptionInput(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public SelectedOptionInput setName(String name) {
            this.name = name;
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public SelectedOptionInput setValue(String value) {
            this.value = value;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("name:");
            Query.appendQuotedString(_queryBuilder, this.name.toString());
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("value:");
            Query.appendQuotedString(_queryBuilder, this.value.toString());
            _queryBuilder.append('}');
        }
    }

    public static class SelectedOption
    extends AbstractResponse<SelectedOption> {
        public SelectedOption() {
        }

        public SelectedOption(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "name": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "value": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SelectedOption";
        }

        public String getName() {
            return (String)this.get("name");
        }

        public SelectedOption setName(String arg) {
            this.optimisticData.put(this.getKey("name"), arg);
            return this;
        }

        public String getValue() {
            return (String)this.get("value");
        }

        public SelectedOption setValue(String arg) {
            this.optimisticData.put(this.getKey("value"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "name": {
                    return false;
                }
                case "value": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SelectedOptionQuery
    extends Query<SelectedOptionQuery> {
        SelectedOptionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SelectedOptionQuery name() {
            this.startField("name");
            return this;
        }

        public SelectedOptionQuery value() {
            this.startField("value");
            return this;
        }
    }

    public static interface SelectedOptionQueryDefinition {
        public void define(SelectedOptionQuery var1);
    }

    public static enum SearchableField {
        AUTHOR,
        BODY,
        PRODUCT_TYPE,
        TAG,
        TITLE,
        VARIANTS_BARCODE,
        VARIANTS_SKU,
        VARIANTS_TITLE,
        VENDOR,
        UNKNOWN_VALUE;


        public static SearchableField fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "AUTHOR": {
                    return AUTHOR;
                }
                case "BODY": {
                    return BODY;
                }
                case "PRODUCT_TYPE": {
                    return PRODUCT_TYPE;
                }
                case "TAG": {
                    return TAG;
                }
                case "TITLE": {
                    return TITLE;
                }
                case "VARIANTS_BARCODE": {
                    return VARIANTS_BARCODE;
                }
                case "VARIANTS_SKU": {
                    return VARIANTS_SKU;
                }
                case "VARIANTS_TITLE": {
                    return VARIANTS_TITLE;
                }
                case "VENDOR": {
                    return VENDOR;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case AUTHOR: {
                    return "AUTHOR";
                }
                case BODY: {
                    return "BODY";
                }
                case PRODUCT_TYPE: {
                    return "PRODUCT_TYPE";
                }
                case TAG: {
                    return "TAG";
                }
                case TITLE: {
                    return "TITLE";
                }
                case VARIANTS_BARCODE: {
                    return "VARIANTS_BARCODE";
                }
                case VARIANTS_SKU: {
                    return "VARIANTS_SKU";
                }
                case VARIANTS_TITLE: {
                    return "VARIANTS_TITLE";
                }
                case VENDOR: {
                    return "VENDOR";
                }
            }
            return "";
        }
    }

    public static enum SearchUnavailableProductsType {
        HIDE,
        LAST,
        SHOW,
        UNKNOWN_VALUE;


        public static SearchUnavailableProductsType fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "HIDE": {
                    return HIDE;
                }
                case "LAST": {
                    return LAST;
                }
                case "SHOW": {
                    return SHOW;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case HIDE: {
                    return "HIDE";
                }
                case LAST: {
                    return "LAST";
                }
                case SHOW: {
                    return "SHOW";
                }
            }
            return "";
        }
    }

    public static enum SearchType {
        ARTICLE,
        PAGE,
        PRODUCT,
        UNKNOWN_VALUE;


        public static SearchType fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "ARTICLE": {
                    return ARTICLE;
                }
                case "PAGE": {
                    return PAGE;
                }
                case "PRODUCT": {
                    return PRODUCT;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case ARTICLE: {
                    return "ARTICLE";
                }
                case PAGE: {
                    return "PAGE";
                }
                case PRODUCT: {
                    return "PRODUCT";
                }
            }
            return "";
        }
    }

    public static enum SearchSortKeys {
        PRICE,
        RELEVANCE,
        UNKNOWN_VALUE;


        public static SearchSortKeys fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "PRICE": {
                    return PRICE;
                }
                case "RELEVANCE": {
                    return RELEVANCE;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case PRICE: {
                    return "PRICE";
                }
                case RELEVANCE: {
                    return "RELEVANCE";
                }
            }
            return "";
        }
    }

    public static class SearchResultItemEdge
    extends AbstractResponse<SearchResultItemEdge> {
        public SearchResultItemEdge() {
        }

        public SearchResultItemEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, UnknownSearchResultItem.create(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SearchResultItemEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public SearchResultItemEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public SearchResultItem getNode() {
            return (SearchResultItem)this.get("node");
        }

        public SearchResultItemEdge setNode(SearchResultItem arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SearchResultItemEdgeQuery
    extends Query<SearchResultItemEdgeQuery> {
        SearchResultItemEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SearchResultItemEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public SearchResultItemEdgeQuery node(SearchResultItemQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new SearchResultItemQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SearchResultItemEdgeQueryDefinition {
        public void define(SearchResultItemEdgeQuery var1);
    }

    public static class SearchResultItemConnection
    extends AbstractResponse<SearchResultItemConnection> {
        public SearchResultItemConnection() {
        }

        public SearchResultItemConnection(JsonObject fields) throws SchemaViolationError {
            block16: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<Object> list1 = new ArrayList<Object>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new SearchResultItemEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block16;
                    }
                    case "nodes": {
                        ArrayList<Object> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(UnknownSearchResultItem.create(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block16;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block16;
                    }
                    case "productFilters": {
                        ArrayList<Object> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new Filter(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block16;
                    }
                    case "totalCount": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SearchResultItemConnection";
        }

        public List<SearchResultItemEdge> getEdges() {
            return (List)this.get("edges");
        }

        public SearchResultItemConnection setEdges(List<SearchResultItemEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<SearchResultItem> getNodes() {
            return (List)this.get("nodes");
        }

        public SearchResultItemConnection setNodes(List<SearchResultItem> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public SearchResultItemConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        public List<Filter> getProductFilters() {
            return (List)this.get("productFilters");
        }

        public SearchResultItemConnection setProductFilters(List<Filter> arg) {
            this.optimisticData.put(this.getKey("productFilters"), arg);
            return this;
        }

        public Integer getTotalCount() {
            return (Integer)this.get("totalCount");
        }

        public SearchResultItemConnection setTotalCount(Integer arg) {
            this.optimisticData.put(this.getKey("totalCount"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "nodes": {
                    return false;
                }
                case "pageInfo": {
                    return true;
                }
                case "productFilters": {
                    return true;
                }
                case "totalCount": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SearchResultItemConnectionQuery
    extends Query<SearchResultItemConnectionQuery> {
        SearchResultItemConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SearchResultItemConnectionQuery edges(SearchResultItemEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new SearchResultItemEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SearchResultItemConnectionQuery nodes(SearchResultItemQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new SearchResultItemQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SearchResultItemConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SearchResultItemConnectionQuery productFilters(FilterQueryDefinition queryDef) {
            this.startField("productFilters");
            this._queryBuilder.append('{');
            queryDef.define(new FilterQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SearchResultItemConnectionQuery totalCount() {
            this.startField("totalCount");
            return this;
        }
    }

    public static interface SearchResultItemConnectionQueryDefinition {
        public void define(SearchResultItemConnectionQuery var1);
    }

    public static class UnknownSearchResultItem
    extends AbstractResponse<UnknownSearchResultItem>
    implements SearchResultItem {
        public UnknownSearchResultItem() {
        }

        public UnknownSearchResultItem(JsonObject fields) throws SchemaViolationError {
            block6: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block6;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public static SearchResultItem create(JsonObject fields) throws SchemaViolationError {
            String typeName;
            switch (typeName = fields.getAsJsonPrimitive("__typename").getAsString()) {
                case "Article": {
                    return new Article(fields);
                }
                case "Page": {
                    return new Page(fields);
                }
                case "Product": {
                    return new Product(fields);
                }
            }
            return new UnknownSearchResultItem(fields);
        }

        @Override
        public String getGraphQlTypeName() {
            return (String)this.get("__typename");
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                default: 
            }
            return false;
        }
    }

    public static interface SearchResultItem {
        public String getGraphQlTypeName();
    }

    public static class SearchResultItemQuery
    extends Query<SearchResultItemQuery> {
        SearchResultItemQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("__typename");
        }

        public SearchResultItemQuery onArticle(ArticleQueryDefinition queryDef) {
            this.startInlineFragment("Article");
            queryDef.define(new ArticleQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SearchResultItemQuery onPage(PageQueryDefinition queryDef) {
            this.startInlineFragment("Page");
            queryDef.define(new PageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public SearchResultItemQuery onProduct(ProductQueryDefinition queryDef) {
            this.startInlineFragment("Product");
            queryDef.define(new ProductQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface SearchResultItemQueryDefinition {
        public void define(SearchResultItemQuery var1);
    }

    public static class SearchQuerySuggestion
    extends AbstractResponse<SearchQuerySuggestion>
    implements Trackable {
        public SearchQuerySuggestion() {
        }

        public SearchQuerySuggestion(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "styledText": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                    case "text": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                    case "trackingParameters": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "SearchQuerySuggestion";
        }

        public String getStyledText() {
            return (String)this.get("styledText");
        }

        public SearchQuerySuggestion setStyledText(String arg) {
            this.optimisticData.put(this.getKey("styledText"), arg);
            return this;
        }

        public String getText() {
            return (String)this.get("text");
        }

        public SearchQuerySuggestion setText(String arg) {
            this.optimisticData.put(this.getKey("text"), arg);
            return this;
        }

        @Override
        public String getTrackingParameters() {
            return (String)this.get("trackingParameters");
        }

        public SearchQuerySuggestion setTrackingParameters(String arg) {
            this.optimisticData.put(this.getKey("trackingParameters"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "styledText": {
                    return false;
                }
                case "text": {
                    return false;
                }
                case "trackingParameters": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SearchQuerySuggestionQuery
    extends Query<SearchQuerySuggestionQuery> {
        SearchQuerySuggestionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SearchQuerySuggestionQuery styledText() {
            this.startField("styledText");
            return this;
        }

        public SearchQuerySuggestionQuery text() {
            this.startField("text");
            return this;
        }

        public SearchQuerySuggestionQuery trackingParameters() {
            this.startField("trackingParameters");
            return this;
        }
    }

    public static interface SearchQuerySuggestionQueryDefinition {
        public void define(SearchQuerySuggestionQuery var1);
    }

    public static enum SearchPrefixQueryType {
        LAST,
        NONE,
        UNKNOWN_VALUE;


        public static SearchPrefixQueryType fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "LAST": {
                    return LAST;
                }
                case "NONE": {
                    return NONE;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case LAST: {
                    return "LAST";
                }
                case NONE: {
                    return "NONE";
                }
            }
            return "";
        }
    }

    public static class ScriptDiscountApplication
    extends AbstractResponse<ScriptDiscountApplication>
    implements DiscountApplication {
        public ScriptDiscountApplication() {
        }

        public ScriptDiscountApplication(JsonObject fields) throws SchemaViolationError {
            block16: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "allocationMethod": {
                        this.responseData.put(key, DiscountApplicationAllocationMethod.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block16;
                    }
                    case "targetSelection": {
                        this.responseData.put(key, DiscountApplicationTargetSelection.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block16;
                    }
                    case "targetType": {
                        this.responseData.put(key, DiscountApplicationTargetType.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block16;
                    }
                    case "title": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "value": {
                        this.responseData.put(key, UnknownPricingValue.create(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block16;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "ScriptDiscountApplication";
        }

        @Override
        public DiscountApplicationAllocationMethod getAllocationMethod() {
            return (DiscountApplicationAllocationMethod)((Object)this.get("allocationMethod"));
        }

        public ScriptDiscountApplication setAllocationMethod(DiscountApplicationAllocationMethod arg) {
            this.optimisticData.put(this.getKey("allocationMethod"), arg);
            return this;
        }

        @Override
        public DiscountApplicationTargetSelection getTargetSelection() {
            return (DiscountApplicationTargetSelection)((Object)this.get("targetSelection"));
        }

        public ScriptDiscountApplication setTargetSelection(DiscountApplicationTargetSelection arg) {
            this.optimisticData.put(this.getKey("targetSelection"), arg);
            return this;
        }

        @Override
        public DiscountApplicationTargetType getTargetType() {
            return (DiscountApplicationTargetType)((Object)this.get("targetType"));
        }

        public ScriptDiscountApplication setTargetType(DiscountApplicationTargetType arg) {
            this.optimisticData.put(this.getKey("targetType"), arg);
            return this;
        }

        public String getTitle() {
            return (String)this.get("title");
        }

        public ScriptDiscountApplication setTitle(String arg) {
            this.optimisticData.put(this.getKey("title"), arg);
            return this;
        }

        @Override
        public PricingValue getValue() {
            return (PricingValue)this.get("value");
        }

        public ScriptDiscountApplication setValue(PricingValue arg) {
            this.optimisticData.put(this.getKey("value"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "allocationMethod": {
                    return false;
                }
                case "targetSelection": {
                    return false;
                }
                case "targetType": {
                    return false;
                }
                case "title": {
                    return false;
                }
                case "value": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ScriptDiscountApplicationQuery
    extends Query<ScriptDiscountApplicationQuery> {
        ScriptDiscountApplicationQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ScriptDiscountApplicationQuery allocationMethod() {
            this.startField("allocationMethod");
            return this;
        }

        public ScriptDiscountApplicationQuery targetSelection() {
            this.startField("targetSelection");
            return this;
        }

        public ScriptDiscountApplicationQuery targetType() {
            this.startField("targetType");
            return this;
        }

        public ScriptDiscountApplicationQuery title() {
            this.startField("title");
            return this;
        }

        public ScriptDiscountApplicationQuery value(PricingValueQueryDefinition queryDef) {
            this.startField("value");
            this._queryBuilder.append('{');
            queryDef.define(new PricingValueQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface ScriptDiscountApplicationQueryDefinition {
        public void define(ScriptDiscountApplicationQuery var1);
    }

    public static class SEO
    extends AbstractResponse<SEO> {
        public SEO() {
        }

        public SEO(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "description": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "title": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "SEO";
        }

        public String getDescription() {
            return (String)this.get("description");
        }

        public SEO setDescription(String arg) {
            this.optimisticData.put(this.getKey("description"), arg);
            return this;
        }

        public String getTitle() {
            return (String)this.get("title");
        }

        public SEO setTitle(String arg) {
            this.optimisticData.put(this.getKey("title"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "description": {
                    return false;
                }
                case "title": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class SEOQuery
    extends Query<SEOQuery> {
        SEOQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public SEOQuery description() {
            this.startField("description");
            return this;
        }

        public SEOQuery title() {
            this.startField("title");
            return this;
        }
    }

    public static interface SEOQueryDefinition {
        public void define(SEOQuery var1);
    }

    public static class QueryRoot
    extends AbstractResponse<QueryRoot> {
        public QueryRoot() {
        }

        public QueryRoot(JsonObject fields) throws SchemaViolationError {
            block70: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "article": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Article(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "articles": {
                        this.responseData.put(key, new ArticleConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block70;
                    }
                    case "blog": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Blog(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "blogByHandle": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Blog(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "blogs": {
                        this.responseData.put(key, new BlogConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block70;
                    }
                    case "cart": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Cart(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "cartCompletionAttempt": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = UnknownCartCompletionAttemptResult.create(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "collection": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Collection(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "collectionByHandle": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Collection(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "collections": {
                        this.responseData.put(key, new CollectionConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block70;
                    }
                    case "customer": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Customer(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "localization": {
                        this.responseData.put(key, new Localization(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block70;
                    }
                    case "locations": {
                        this.responseData.put(key, new LocationConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block70;
                    }
                    case "menu": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Menu(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "metaobject": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Metaobject(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "metaobjects": {
                        this.responseData.put(key, new MetaobjectConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block70;
                    }
                    case "node": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = UnknownNode.create(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "nodes": {
                        ArrayList<Object> list1 = new ArrayList<Object>();
                        for (Object element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            Node optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = UnknownNode.create(this.jsonAsObject((JsonElement)element1, key));
                            }
                            list1.add(optional2);
                        }
                        this.responseData.put(key, list1);
                        continue block70;
                    }
                    case "page": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Page(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "pageByHandle": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Page(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "pages": {
                        this.responseData.put(key, new PageConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block70;
                    }
                    case "predictiveSearch": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new PredictiveSearchResult(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "product": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Product(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "productByHandle": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Product(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "productRecommendations": {
                        ArrayList<Product> optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            Object element1;
                            ArrayList<Product> list1 = new ArrayList<Product>();
                            element1 = this.jsonAsArray((JsonElement)field.getValue(), key).iterator();
                            while (element1.hasNext()) {
                                JsonElement element12 = (JsonElement)element1.next();
                                list1.add(new Product(this.jsonAsObject(element12, key)));
                            }
                            optional1 = list1;
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "productTags": {
                        this.responseData.put(key, new StringConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block70;
                    }
                    case "productTypes": {
                        this.responseData.put(key, new StringConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block70;
                    }
                    case "products": {
                        this.responseData.put(key, new ProductConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block70;
                    }
                    case "publicApiVersions": {
                        ArrayList<Object> list1 = new ArrayList();
                        for (Object element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new ApiVersion(this.jsonAsObject((JsonElement)element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block70;
                    }
                    case "search": {
                        this.responseData.put(key, new SearchResultItemConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block70;
                    }
                    case "shop": {
                        this.responseData.put(key, new Shop(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block70;
                    }
                    case "urlRedirects": {
                        this.responseData.put(key, new UrlRedirectConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block70;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block70;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "QueryRoot";
        }

        public Article getArticle() {
            return (Article)this.get("article");
        }

        public QueryRoot setArticle(Article arg) {
            this.optimisticData.put(this.getKey("article"), arg);
            return this;
        }

        public ArticleConnection getArticles() {
            return (ArticleConnection)this.get("articles");
        }

        public QueryRoot setArticles(ArticleConnection arg) {
            this.optimisticData.put(this.getKey("articles"), arg);
            return this;
        }

        public Blog getBlog() {
            return (Blog)this.get("blog");
        }

        public QueryRoot setBlog(Blog arg) {
            this.optimisticData.put(this.getKey("blog"), arg);
            return this;
        }

        public Blog getBlogByHandle() {
            return (Blog)this.get("blogByHandle");
        }

        public QueryRoot setBlogByHandle(Blog arg) {
            this.optimisticData.put(this.getKey("blogByHandle"), arg);
            return this;
        }

        public BlogConnection getBlogs() {
            return (BlogConnection)this.get("blogs");
        }

        public QueryRoot setBlogs(BlogConnection arg) {
            this.optimisticData.put(this.getKey("blogs"), arg);
            return this;
        }

        public Cart getCart() {
            return (Cart)this.get("cart");
        }

        public QueryRoot setCart(Cart arg) {
            this.optimisticData.put(this.getKey("cart"), arg);
            return this;
        }

        public CartCompletionAttemptResult getCartCompletionAttempt() {
            return (CartCompletionAttemptResult)this.get("cartCompletionAttempt");
        }

        public QueryRoot setCartCompletionAttempt(CartCompletionAttemptResult arg) {
            this.optimisticData.put(this.getKey("cartCompletionAttempt"), arg);
            return this;
        }

        public Collection getCollection() {
            return (Collection)this.get("collection");
        }

        public QueryRoot setCollection(Collection arg) {
            this.optimisticData.put(this.getKey("collection"), arg);
            return this;
        }

        public Collection getCollectionByHandle() {
            return (Collection)this.get("collectionByHandle");
        }

        public QueryRoot setCollectionByHandle(Collection arg) {
            this.optimisticData.put(this.getKey("collectionByHandle"), arg);
            return this;
        }

        public CollectionConnection getCollections() {
            return (CollectionConnection)this.get("collections");
        }

        public QueryRoot setCollections(CollectionConnection arg) {
            this.optimisticData.put(this.getKey("collections"), arg);
            return this;
        }

        public Customer getCustomer() {
            return (Customer)this.get("customer");
        }

        public QueryRoot setCustomer(Customer arg) {
            this.optimisticData.put(this.getKey("customer"), arg);
            return this;
        }

        public Localization getLocalization() {
            return (Localization)this.get("localization");
        }

        public QueryRoot setLocalization(Localization arg) {
            this.optimisticData.put(this.getKey("localization"), arg);
            return this;
        }

        public LocationConnection getLocations() {
            return (LocationConnection)this.get("locations");
        }

        public QueryRoot setLocations(LocationConnection arg) {
            this.optimisticData.put(this.getKey("locations"), arg);
            return this;
        }

        public Menu getMenu() {
            return (Menu)this.get("menu");
        }

        public QueryRoot setMenu(Menu arg) {
            this.optimisticData.put(this.getKey("menu"), arg);
            return this;
        }

        public Metaobject getMetaobject() {
            return (Metaobject)this.get("metaobject");
        }

        public QueryRoot setMetaobject(Metaobject arg) {
            this.optimisticData.put(this.getKey("metaobject"), arg);
            return this;
        }

        public MetaobjectConnection getMetaobjects() {
            return (MetaobjectConnection)this.get("metaobjects");
        }

        public QueryRoot setMetaobjects(MetaobjectConnection arg) {
            this.optimisticData.put(this.getKey("metaobjects"), arg);
            return this;
        }

        public Node getNode() {
            return (Node)this.get("node");
        }

        public QueryRoot setNode(Node arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        public List<Node> getNodes() {
            return (List)this.get("nodes");
        }

        public QueryRoot setNodes(List<Node> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public Page getPage() {
            return (Page)this.get("page");
        }

        public QueryRoot setPage(Page arg) {
            this.optimisticData.put(this.getKey("page"), arg);
            return this;
        }

        public Page getPageByHandle() {
            return (Page)this.get("pageByHandle");
        }

        public QueryRoot setPageByHandle(Page arg) {
            this.optimisticData.put(this.getKey("pageByHandle"), arg);
            return this;
        }

        public PageConnection getPages() {
            return (PageConnection)this.get("pages");
        }

        public QueryRoot setPages(PageConnection arg) {
            this.optimisticData.put(this.getKey("pages"), arg);
            return this;
        }

        public PredictiveSearchResult getPredictiveSearch() {
            return (PredictiveSearchResult)this.get("predictiveSearch");
        }

        public QueryRoot setPredictiveSearch(PredictiveSearchResult arg) {
            this.optimisticData.put(this.getKey("predictiveSearch"), arg);
            return this;
        }

        public Product getProduct() {
            return (Product)this.get("product");
        }

        public QueryRoot setProduct(Product arg) {
            this.optimisticData.put(this.getKey("product"), arg);
            return this;
        }

        public Product getProductByHandle() {
            return (Product)this.get("productByHandle");
        }

        public QueryRoot setProductByHandle(Product arg) {
            this.optimisticData.put(this.getKey("productByHandle"), arg);
            return this;
        }

        public List<Product> getProductRecommendations() {
            return (List)this.get("productRecommendations");
        }

        public QueryRoot setProductRecommendations(List<Product> arg) {
            this.optimisticData.put(this.getKey("productRecommendations"), arg);
            return this;
        }

        public StringConnection getProductTags() {
            return (StringConnection)this.get("productTags");
        }

        public QueryRoot setProductTags(StringConnection arg) {
            this.optimisticData.put(this.getKey("productTags"), arg);
            return this;
        }

        public StringConnection getProductTypes() {
            return (StringConnection)this.get("productTypes");
        }

        public QueryRoot setProductTypes(StringConnection arg) {
            this.optimisticData.put(this.getKey("productTypes"), arg);
            return this;
        }

        public ProductConnection getProducts() {
            return (ProductConnection)this.get("products");
        }

        public QueryRoot setProducts(ProductConnection arg) {
            this.optimisticData.put(this.getKey("products"), arg);
            return this;
        }

        public List<ApiVersion> getPublicApiVersions() {
            return (List)this.get("publicApiVersions");
        }

        public QueryRoot setPublicApiVersions(List<ApiVersion> arg) {
            this.optimisticData.put(this.getKey("publicApiVersions"), arg);
            return this;
        }

        public SearchResultItemConnection getSearch() {
            return (SearchResultItemConnection)this.get("search");
        }

        public QueryRoot setSearch(SearchResultItemConnection arg) {
            this.optimisticData.put(this.getKey("search"), arg);
            return this;
        }

        public Shop getShop() {
            return (Shop)this.get("shop");
        }

        public QueryRoot setShop(Shop arg) {
            this.optimisticData.put(this.getKey("shop"), arg);
            return this;
        }

        public UrlRedirectConnection getUrlRedirects() {
            return (UrlRedirectConnection)this.get("urlRedirects");
        }

        public QueryRoot setUrlRedirects(UrlRedirectConnection arg) {
            this.optimisticData.put(this.getKey("urlRedirects"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "article": {
                    return true;
                }
                case "articles": {
                    return true;
                }
                case "blog": {
                    return true;
                }
                case "blogByHandle": {
                    return true;
                }
                case "blogs": {
                    return true;
                }
                case "cart": {
                    return true;
                }
                case "cartCompletionAttempt": {
                    return false;
                }
                case "collection": {
                    return true;
                }
                case "collectionByHandle": {
                    return true;
                }
                case "collections": {
                    return true;
                }
                case "customer": {
                    return true;
                }
                case "localization": {
                    return true;
                }
                case "locations": {
                    return true;
                }
                case "menu": {
                    return true;
                }
                case "metaobject": {
                    return true;
                }
                case "metaobjects": {
                    return true;
                }
                case "node": {
                    return false;
                }
                case "nodes": {
                    return false;
                }
                case "page": {
                    return true;
                }
                case "pageByHandle": {
                    return true;
                }
                case "pages": {
                    return true;
                }
                case "predictiveSearch": {
                    return true;
                }
                case "product": {
                    return true;
                }
                case "productByHandle": {
                    return true;
                }
                case "productRecommendations": {
                    return true;
                }
                case "productTags": {
                    return true;
                }
                case "productTypes": {
                    return true;
                }
                case "products": {
                    return true;
                }
                case "publicApiVersions": {
                    return true;
                }
                case "search": {
                    return true;
                }
                case "shop": {
                    return true;
                }
                case "urlRedirects": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class QueryRootQuery
    extends Query<QueryRootQuery> {
        QueryRootQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public QueryRootQuery article(ID id, ArticleQueryDefinition queryDef) {
            this.startField("article");
            this._queryBuilder.append("(id:");
            Query.appendQuotedString(this._queryBuilder, id.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new ArticleQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery articles(ArticleConnectionQueryDefinition queryDef) {
            return this.articles(args -> {}, queryDef);
        }

        public QueryRootQuery articles(ArticlesArgumentsDefinition argsDef, ArticleConnectionQueryDefinition queryDef) {
            this.startField("articles");
            ArticlesArguments args = new ArticlesArguments(this._queryBuilder);
            argsDef.define(args);
            ArticlesArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new ArticleConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery blog(BlogQueryDefinition queryDef) {
            return this.blog(args -> {}, queryDef);
        }

        public QueryRootQuery blog(BlogArgumentsDefinition argsDef, BlogQueryDefinition queryDef) {
            this.startField("blog");
            BlogArguments args = new BlogArguments(this._queryBuilder);
            argsDef.define(args);
            BlogArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new BlogQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        @Deprecated
        public QueryRootQuery blogByHandle(String handle, BlogQueryDefinition queryDef) {
            this.startField("blogByHandle");
            this._queryBuilder.append("(handle:");
            Query.appendQuotedString(this._queryBuilder, handle.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new BlogQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery blogs(BlogConnectionQueryDefinition queryDef) {
            return this.blogs(args -> {}, queryDef);
        }

        public QueryRootQuery blogs(BlogsArgumentsDefinition argsDef, BlogConnectionQueryDefinition queryDef) {
            this.startField("blogs");
            BlogsArguments args = new BlogsArguments(this._queryBuilder);
            argsDef.define(args);
            BlogsArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new BlogConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery cart(ID id, CartQueryDefinition queryDef) {
            this.startField("cart");
            this._queryBuilder.append("(id:");
            Query.appendQuotedString(this._queryBuilder, id.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery cartCompletionAttempt(String attemptId, CartCompletionAttemptResultQueryDefinition queryDef) {
            this.startField("cartCompletionAttempt");
            this._queryBuilder.append("(attemptId:");
            Query.appendQuotedString(this._queryBuilder, attemptId.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartCompletionAttemptResultQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery collection(CollectionQueryDefinition queryDef) {
            return this.collection(args -> {}, queryDef);
        }

        public QueryRootQuery collection(CollectionArgumentsDefinition argsDef, CollectionQueryDefinition queryDef) {
            this.startField("collection");
            CollectionArguments args = new CollectionArguments(this._queryBuilder);
            argsDef.define(args);
            CollectionArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new CollectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        @Deprecated
        public QueryRootQuery collectionByHandle(String handle, CollectionQueryDefinition queryDef) {
            this.startField("collectionByHandle");
            this._queryBuilder.append("(handle:");
            Query.appendQuotedString(this._queryBuilder, handle.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CollectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery collections(CollectionConnectionQueryDefinition queryDef) {
            return this.collections(args -> {}, queryDef);
        }

        public QueryRootQuery collections(CollectionsArgumentsDefinition argsDef, CollectionConnectionQueryDefinition queryDef) {
            this.startField("collections");
            CollectionsArguments args = new CollectionsArguments(this._queryBuilder);
            argsDef.define(args);
            CollectionsArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new CollectionConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery customer(String customerAccessToken, CustomerQueryDefinition queryDef) {
            this.startField("customer");
            this._queryBuilder.append("(customerAccessToken:");
            Query.appendQuotedString(this._queryBuilder, customerAccessToken.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery localization(LocalizationQueryDefinition queryDef) {
            this.startField("localization");
            this._queryBuilder.append('{');
            queryDef.define(new LocalizationQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery locations(LocationConnectionQueryDefinition queryDef) {
            return this.locations(args -> {}, queryDef);
        }

        public QueryRootQuery locations(LocationsArgumentsDefinition argsDef, LocationConnectionQueryDefinition queryDef) {
            this.startField("locations");
            LocationsArguments args = new LocationsArguments(this._queryBuilder);
            argsDef.define(args);
            LocationsArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new LocationConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery menu(String handle, MenuQueryDefinition queryDef) {
            this.startField("menu");
            this._queryBuilder.append("(handle:");
            Query.appendQuotedString(this._queryBuilder, handle.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new MenuQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery metaobject(MetaobjectQueryDefinition queryDef) {
            return this.metaobject(args -> {}, queryDef);
        }

        public QueryRootQuery metaobject(MetaobjectArgumentsDefinition argsDef, MetaobjectQueryDefinition queryDef) {
            this.startField("metaobject");
            MetaobjectArguments args = new MetaobjectArguments(this._queryBuilder);
            argsDef.define(args);
            MetaobjectArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new MetaobjectQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery metaobjects(String type, MetaobjectConnectionQueryDefinition queryDef) {
            return this.metaobjects(type, args -> {}, queryDef);
        }

        public QueryRootQuery metaobjects(String type, MetaobjectsArgumentsDefinition argsDef, MetaobjectConnectionQueryDefinition queryDef) {
            this.startField("metaobjects");
            this._queryBuilder.append("(type:");
            Query.appendQuotedString(this._queryBuilder, type.toString());
            argsDef.define(new MetaobjectsArguments(this._queryBuilder));
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new MetaobjectConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery node(ID id, NodeQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append("(id:");
            Query.appendQuotedString(this._queryBuilder, id.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new NodeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery nodes(List<ID> ids, NodeQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append("(ids:");
            this._queryBuilder.append('[');
            String listSeperator1 = "";
            for (ID item1 : ids) {
                this._queryBuilder.append(listSeperator1);
                listSeperator1 = ",";
                Query.appendQuotedString(this._queryBuilder, item1.toString());
            }
            this._queryBuilder.append(']');
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new NodeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery page(PageQueryDefinition queryDef) {
            return this.page(args -> {}, queryDef);
        }

        public QueryRootQuery page(PageArgumentsDefinition argsDef, PageQueryDefinition queryDef) {
            this.startField("page");
            PageArguments args = new PageArguments(this._queryBuilder);
            argsDef.define(args);
            PageArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new PageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        @Deprecated
        public QueryRootQuery pageByHandle(String handle, PageQueryDefinition queryDef) {
            this.startField("pageByHandle");
            this._queryBuilder.append("(handle:");
            Query.appendQuotedString(this._queryBuilder, handle.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new PageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery pages(PageConnectionQueryDefinition queryDef) {
            return this.pages(args -> {}, queryDef);
        }

        public QueryRootQuery pages(PagesArgumentsDefinition argsDef, PageConnectionQueryDefinition queryDef) {
            this.startField("pages");
            PagesArguments args = new PagesArguments(this._queryBuilder);
            argsDef.define(args);
            PagesArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new PageConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery predictiveSearch(String query, PredictiveSearchResultQueryDefinition queryDef) {
            return this.predictiveSearch(query, args -> {}, queryDef);
        }

        public QueryRootQuery predictiveSearch(String query, PredictiveSearchArgumentsDefinition argsDef, PredictiveSearchResultQueryDefinition queryDef) {
            this.startField("predictiveSearch");
            this._queryBuilder.append("(query:");
            Query.appendQuotedString(this._queryBuilder, query.toString());
            argsDef.define(new PredictiveSearchArguments(this._queryBuilder));
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new PredictiveSearchResultQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery product(ProductQueryDefinition queryDef) {
            return this.product(args -> {}, queryDef);
        }

        public QueryRootQuery product(ProductArgumentsDefinition argsDef, ProductQueryDefinition queryDef) {
            this.startField("product");
            ProductArguments args = new ProductArguments(this._queryBuilder);
            argsDef.define(args);
            ProductArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new ProductQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        @Deprecated
        public QueryRootQuery productByHandle(String handle, ProductQueryDefinition queryDef) {
            this.startField("productByHandle");
            this._queryBuilder.append("(handle:");
            Query.appendQuotedString(this._queryBuilder, handle.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new ProductQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery productRecommendations(ProductQueryDefinition queryDef) {
            return this.productRecommendations(args -> {}, queryDef);
        }

        public QueryRootQuery productRecommendations(ProductRecommendationsArgumentsDefinition argsDef, ProductQueryDefinition queryDef) {
            this.startField("productRecommendations");
            ProductRecommendationsArguments args = new ProductRecommendationsArguments(this._queryBuilder);
            argsDef.define(args);
            ProductRecommendationsArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new ProductQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery productTags(int first, StringConnectionQueryDefinition queryDef) {
            this.startField("productTags");
            this._queryBuilder.append("(first:");
            this._queryBuilder.append(first);
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new StringConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery productTypes(int first, StringConnectionQueryDefinition queryDef) {
            this.startField("productTypes");
            this._queryBuilder.append("(first:");
            this._queryBuilder.append(first);
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new StringConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery products(ProductConnectionQueryDefinition queryDef) {
            return this.products(args -> {}, queryDef);
        }

        public QueryRootQuery products(ProductsArgumentsDefinition argsDef, ProductConnectionQueryDefinition queryDef) {
            this.startField("products");
            ProductsArguments args = new ProductsArguments(this._queryBuilder);
            argsDef.define(args);
            ProductsArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new ProductConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery publicApiVersions(ApiVersionQueryDefinition queryDef) {
            this.startField("publicApiVersions");
            this._queryBuilder.append('{');
            queryDef.define(new ApiVersionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery search(String query, SearchResultItemConnectionQueryDefinition queryDef) {
            return this.search(query, args -> {}, queryDef);
        }

        public QueryRootQuery search(String query, SearchArgumentsDefinition argsDef, SearchResultItemConnectionQueryDefinition queryDef) {
            this.startField("search");
            this._queryBuilder.append("(query:");
            Query.appendQuotedString(this._queryBuilder, query.toString());
            argsDef.define(new SearchArguments(this._queryBuilder));
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new SearchResultItemConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery shop(ShopQueryDefinition queryDef) {
            this.startField("shop");
            this._queryBuilder.append('{');
            queryDef.define(new ShopQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QueryRootQuery urlRedirects(UrlRedirectConnectionQueryDefinition queryDef) {
            return this.urlRedirects(args -> {}, queryDef);
        }

        public QueryRootQuery urlRedirects(UrlRedirectsArgumentsDefinition argsDef, UrlRedirectConnectionQueryDefinition queryDef) {
            this.startField("urlRedirects");
            UrlRedirectsArguments args = new UrlRedirectsArguments(this._queryBuilder);
            argsDef.define(args);
            UrlRedirectsArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new UrlRedirectConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public String toString() {
            return this._queryBuilder.toString();
        }

        public static interface UrlRedirectsArgumentsDefinition {
            public void define(UrlRedirectsArguments var1);
        }

        public class UrlRedirectsArguments
        extends Arguments {
            UrlRedirectsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public UrlRedirectsArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public UrlRedirectsArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public UrlRedirectsArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public UrlRedirectsArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public UrlRedirectsArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public UrlRedirectsArguments query(String value) {
                if (value != null) {
                    this.startArgument("query");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }

        public static interface SearchArgumentsDefinition {
            public void define(SearchArguments var1);
        }

        public class SearchArguments
        extends Arguments {
            SearchArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            public SearchArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public SearchArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public SearchArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public SearchArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public SearchArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public SearchArguments sortKey(SearchSortKeys value) {
                if (value != null) {
                    this.startArgument("sortKey");
                    QueryRootQuery.this._queryBuilder.append(value.toString());
                }
                return this;
            }

            public SearchArguments prefix(SearchPrefixQueryType value) {
                if (value != null) {
                    this.startArgument("prefix");
                    QueryRootQuery.this._queryBuilder.append(value.toString());
                }
                return this;
            }

            public SearchArguments productFilters(List<ProductFilter> value) {
                if (value != null) {
                    this.startArgument("productFilters");
                    QueryRootQuery.this._queryBuilder.append('[');
                    String listSeperator1 = "";
                    for (ProductFilter item1 : value) {
                        QueryRootQuery.this._queryBuilder.append(listSeperator1);
                        listSeperator1 = ",";
                        item1.appendTo(QueryRootQuery.this._queryBuilder);
                    }
                    QueryRootQuery.this._queryBuilder.append(']');
                }
                return this;
            }

            public SearchArguments types(List<SearchType> value) {
                if (value != null) {
                    this.startArgument("types");
                    QueryRootQuery.this._queryBuilder.append('[');
                    String listSeperator1 = "";
                    for (SearchType item1 : value) {
                        QueryRootQuery.this._queryBuilder.append(listSeperator1);
                        listSeperator1 = ",";
                        QueryRootQuery.this._queryBuilder.append(item1.toString());
                    }
                    QueryRootQuery.this._queryBuilder.append(']');
                }
                return this;
            }

            public SearchArguments unavailableProducts(SearchUnavailableProductsType value) {
                if (value != null) {
                    this.startArgument("unavailableProducts");
                    QueryRootQuery.this._queryBuilder.append(value.toString());
                }
                return this;
            }
        }

        public static interface ProductsArgumentsDefinition {
            public void define(ProductsArguments var1);
        }

        public class ProductsArguments
        extends Arguments {
            ProductsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public ProductsArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public ProductsArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public ProductsArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public ProductsArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public ProductsArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public ProductsArguments sortKey(ProductSortKeys value) {
                if (value != null) {
                    this.startArgument("sortKey");
                    QueryRootQuery.this._queryBuilder.append(value.toString());
                }
                return this;
            }

            public ProductsArguments query(String value) {
                if (value != null) {
                    this.startArgument("query");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }

        public static interface ProductRecommendationsArgumentsDefinition {
            public void define(ProductRecommendationsArguments var1);
        }

        public class ProductRecommendationsArguments
        extends Arguments {
            ProductRecommendationsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public ProductRecommendationsArguments productId(ID value) {
                if (value != null) {
                    this.startArgument("productId");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public ProductRecommendationsArguments productHandle(String value) {
                if (value != null) {
                    this.startArgument("productHandle");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public ProductRecommendationsArguments intent(ProductRecommendationIntent value) {
                if (value != null) {
                    this.startArgument("intent");
                    QueryRootQuery.this._queryBuilder.append(value.toString());
                }
                return this;
            }
        }

        public static interface ProductArgumentsDefinition {
            public void define(ProductArguments var1);
        }

        public class ProductArguments
        extends Arguments {
            ProductArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public ProductArguments id(ID value) {
                if (value != null) {
                    this.startArgument("id");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public ProductArguments handle(String value) {
                if (value != null) {
                    this.startArgument("handle");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }

        public static interface PredictiveSearchArgumentsDefinition {
            public void define(PredictiveSearchArguments var1);
        }

        public class PredictiveSearchArguments
        extends Arguments {
            PredictiveSearchArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            public PredictiveSearchArguments limit(Integer value) {
                if (value != null) {
                    this.startArgument("limit");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public PredictiveSearchArguments limitScope(PredictiveSearchLimitScope value) {
                if (value != null) {
                    this.startArgument("limitScope");
                    QueryRootQuery.this._queryBuilder.append(value.toString());
                }
                return this;
            }

            public PredictiveSearchArguments searchableFields(List<SearchableField> value) {
                if (value != null) {
                    this.startArgument("searchableFields");
                    QueryRootQuery.this._queryBuilder.append('[');
                    String listSeperator1 = "";
                    for (SearchableField item1 : value) {
                        QueryRootQuery.this._queryBuilder.append(listSeperator1);
                        listSeperator1 = ",";
                        QueryRootQuery.this._queryBuilder.append(item1.toString());
                    }
                    QueryRootQuery.this._queryBuilder.append(']');
                }
                return this;
            }

            public PredictiveSearchArguments types(List<PredictiveSearchType> value) {
                if (value != null) {
                    this.startArgument("types");
                    QueryRootQuery.this._queryBuilder.append('[');
                    String listSeperator1 = "";
                    for (PredictiveSearchType item1 : value) {
                        QueryRootQuery.this._queryBuilder.append(listSeperator1);
                        listSeperator1 = ",";
                        QueryRootQuery.this._queryBuilder.append(item1.toString());
                    }
                    QueryRootQuery.this._queryBuilder.append(']');
                }
                return this;
            }

            public PredictiveSearchArguments unavailableProducts(SearchUnavailableProductsType value) {
                if (value != null) {
                    this.startArgument("unavailableProducts");
                    QueryRootQuery.this._queryBuilder.append(value.toString());
                }
                return this;
            }
        }

        public static interface PagesArgumentsDefinition {
            public void define(PagesArguments var1);
        }

        public class PagesArguments
        extends Arguments {
            PagesArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public PagesArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public PagesArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public PagesArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public PagesArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public PagesArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public PagesArguments sortKey(PageSortKeys value) {
                if (value != null) {
                    this.startArgument("sortKey");
                    QueryRootQuery.this._queryBuilder.append(value.toString());
                }
                return this;
            }

            public PagesArguments query(String value) {
                if (value != null) {
                    this.startArgument("query");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }

        public static interface PageArgumentsDefinition {
            public void define(PageArguments var1);
        }

        public class PageArguments
        extends Arguments {
            PageArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public PageArguments handle(String value) {
                if (value != null) {
                    this.startArgument("handle");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public PageArguments id(ID value) {
                if (value != null) {
                    this.startArgument("id");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }

        public static interface MetaobjectsArgumentsDefinition {
            public void define(MetaobjectsArguments var1);
        }

        public class MetaobjectsArguments
        extends Arguments {
            MetaobjectsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            public MetaobjectsArguments sortKey(String value) {
                if (value != null) {
                    this.startArgument("sortKey");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public MetaobjectsArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public MetaobjectsArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public MetaobjectsArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public MetaobjectsArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public MetaobjectsArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }
        }

        public static interface MetaobjectArgumentsDefinition {
            public void define(MetaobjectArguments var1);
        }

        public class MetaobjectArguments
        extends Arguments {
            MetaobjectArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public MetaobjectArguments id(ID value) {
                if (value != null) {
                    this.startArgument("id");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public MetaobjectArguments handle(MetaobjectHandleInput value) {
                if (value != null) {
                    this.startArgument("handle");
                    value.appendTo(QueryRootQuery.this._queryBuilder);
                }
                return this;
            }
        }

        public static interface LocationsArgumentsDefinition {
            public void define(LocationsArguments var1);
        }

        public class LocationsArguments
        extends Arguments {
            LocationsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public LocationsArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public LocationsArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public LocationsArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public LocationsArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public LocationsArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public LocationsArguments sortKey(LocationSortKeys value) {
                if (value != null) {
                    this.startArgument("sortKey");
                    QueryRootQuery.this._queryBuilder.append(value.toString());
                }
                return this;
            }

            public LocationsArguments near(GeoCoordinateInput value) {
                if (value != null) {
                    this.startArgument("near");
                    value.appendTo(QueryRootQuery.this._queryBuilder);
                }
                return this;
            }
        }

        public static interface CollectionsArgumentsDefinition {
            public void define(CollectionsArguments var1);
        }

        public class CollectionsArguments
        extends Arguments {
            CollectionsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public CollectionsArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public CollectionsArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public CollectionsArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public CollectionsArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public CollectionsArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public CollectionsArguments sortKey(CollectionSortKeys value) {
                if (value != null) {
                    this.startArgument("sortKey");
                    QueryRootQuery.this._queryBuilder.append(value.toString());
                }
                return this;
            }

            public CollectionsArguments query(String value) {
                if (value != null) {
                    this.startArgument("query");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }

        public static interface CollectionArgumentsDefinition {
            public void define(CollectionArguments var1);
        }

        public class CollectionArguments
        extends Arguments {
            CollectionArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public CollectionArguments id(ID value) {
                if (value != null) {
                    this.startArgument("id");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public CollectionArguments handle(String value) {
                if (value != null) {
                    this.startArgument("handle");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }

        public static interface BlogsArgumentsDefinition {
            public void define(BlogsArguments var1);
        }

        public class BlogsArguments
        extends Arguments {
            BlogsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public BlogsArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public BlogsArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public BlogsArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public BlogsArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public BlogsArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public BlogsArguments sortKey(BlogSortKeys value) {
                if (value != null) {
                    this.startArgument("sortKey");
                    QueryRootQuery.this._queryBuilder.append(value.toString());
                }
                return this;
            }

            public BlogsArguments query(String value) {
                if (value != null) {
                    this.startArgument("query");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }

        public static interface BlogArgumentsDefinition {
            public void define(BlogArguments var1);
        }

        public class BlogArguments
        extends Arguments {
            BlogArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public BlogArguments handle(String value) {
                if (value != null) {
                    this.startArgument("handle");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public BlogArguments id(ID value) {
                if (value != null) {
                    this.startArgument("id");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }

        public static interface ArticlesArgumentsDefinition {
            public void define(ArticlesArguments var1);
        }

        public class ArticlesArguments
        extends Arguments {
            ArticlesArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public ArticlesArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public ArticlesArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public ArticlesArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public ArticlesArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public ArticlesArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    QueryRootQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public ArticlesArguments sortKey(ArticleSortKeys value) {
                if (value != null) {
                    this.startArgument("sortKey");
                    QueryRootQuery.this._queryBuilder.append(value.toString());
                }
                return this;
            }

            public ArticlesArguments query(String value) {
                if (value != null) {
                    this.startArgument("query");
                    Query.appendQuotedString(QueryRootQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }
    }

    public static interface QueryRootQueryDefinition {
        public void define(QueryRootQuery var1);
    }

    public static class QuantityRule
    extends AbstractResponse<QuantityRule> {
        public QuantityRule() {
        }

        public QuantityRule(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "increment": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                    case "maximum": {
                        Integer optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsInteger((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block12;
                    }
                    case "minimum": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "QuantityRule";
        }

        public Integer getIncrement() {
            return (Integer)this.get("increment");
        }

        public QuantityRule setIncrement(Integer arg) {
            this.optimisticData.put(this.getKey("increment"), arg);
            return this;
        }

        public Integer getMaximum() {
            return (Integer)this.get("maximum");
        }

        public QuantityRule setMaximum(Integer arg) {
            this.optimisticData.put(this.getKey("maximum"), arg);
            return this;
        }

        public Integer getMinimum() {
            return (Integer)this.get("minimum");
        }

        public QuantityRule setMinimum(Integer arg) {
            this.optimisticData.put(this.getKey("minimum"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "increment": {
                    return false;
                }
                case "maximum": {
                    return false;
                }
                case "minimum": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class QuantityRuleQuery
    extends Query<QuantityRuleQuery> {
        QuantityRuleQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public QuantityRuleQuery increment() {
            this.startField("increment");
            return this;
        }

        public QuantityRuleQuery maximum() {
            this.startField("maximum");
            return this;
        }

        public QuantityRuleQuery minimum() {
            this.startField("minimum");
            return this;
        }
    }

    public static interface QuantityRuleQueryDefinition {
        public void define(QuantityRuleQuery var1);
    }

    public static class QuantityPriceBreakEdge
    extends AbstractResponse<QuantityPriceBreakEdge> {
        public QuantityPriceBreakEdge() {
        }

        public QuantityPriceBreakEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, new QuantityPriceBreak(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "QuantityPriceBreakEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public QuantityPriceBreakEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public QuantityPriceBreak getNode() {
            return (QuantityPriceBreak)this.get("node");
        }

        public QuantityPriceBreakEdge setNode(QuantityPriceBreak arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class QuantityPriceBreakEdgeQuery
    extends Query<QuantityPriceBreakEdgeQuery> {
        QuantityPriceBreakEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public QuantityPriceBreakEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public QuantityPriceBreakEdgeQuery node(QuantityPriceBreakQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new QuantityPriceBreakQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface QuantityPriceBreakEdgeQueryDefinition {
        public void define(QuantityPriceBreakEdgeQuery var1);
    }

    public static class QuantityPriceBreakConnection
    extends AbstractResponse<QuantityPriceBreakConnection> {
        public QuantityPriceBreakConnection() {
        }

        public QuantityPriceBreakConnection(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new QuantityPriceBreakEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "nodes": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new QuantityPriceBreak(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "QuantityPriceBreakConnection";
        }

        public List<QuantityPriceBreakEdge> getEdges() {
            return (List)this.get("edges");
        }

        public QuantityPriceBreakConnection setEdges(List<QuantityPriceBreakEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<QuantityPriceBreak> getNodes() {
            return (List)this.get("nodes");
        }

        public QuantityPriceBreakConnection setNodes(List<QuantityPriceBreak> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public QuantityPriceBreakConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "nodes": {
                    return true;
                }
                case "pageInfo": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class QuantityPriceBreakConnectionQuery
    extends Query<QuantityPriceBreakConnectionQuery> {
        QuantityPriceBreakConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public QuantityPriceBreakConnectionQuery edges(QuantityPriceBreakEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new QuantityPriceBreakEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QuantityPriceBreakConnectionQuery nodes(QuantityPriceBreakQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new QuantityPriceBreakQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public QuantityPriceBreakConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface QuantityPriceBreakConnectionQueryDefinition {
        public void define(QuantityPriceBreakConnectionQuery var1);
    }

    public static class QuantityPriceBreak
    extends AbstractResponse<QuantityPriceBreak> {
        public QuantityPriceBreak() {
        }

        public QuantityPriceBreak(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "minimumQuantity": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "price": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "QuantityPriceBreak";
        }

        public Integer getMinimumQuantity() {
            return (Integer)this.get("minimumQuantity");
        }

        public QuantityPriceBreak setMinimumQuantity(Integer arg) {
            this.optimisticData.put(this.getKey("minimumQuantity"), arg);
            return this;
        }

        public MoneyV2 getPrice() {
            return (MoneyV2)this.get("price");
        }

        public QuantityPriceBreak setPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("price"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "minimumQuantity": {
                    return false;
                }
                case "price": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class QuantityPriceBreakQuery
    extends Query<QuantityPriceBreakQuery> {
        QuantityPriceBreakQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public QuantityPriceBreakQuery minimumQuantity() {
            this.startField("minimumQuantity");
            return this;
        }

        public QuantityPriceBreakQuery price(MoneyV2QueryDefinition queryDef) {
            this.startField("price");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface QuantityPriceBreakQueryDefinition {
        public void define(QuantityPriceBreakQuery var1);
    }

    public static class PurchasingCompany
    extends AbstractResponse<PurchasingCompany> {
        public PurchasingCompany() {
        }

        public PurchasingCompany(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "company": {
                        this.responseData.put(key, new Company(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "contact": {
                        CompanyContact optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CompanyContact(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block12;
                    }
                    case "location": {
                        this.responseData.put(key, new CompanyLocation(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "PurchasingCompany";
        }

        public Company getCompany() {
            return (Company)this.get("company");
        }

        public PurchasingCompany setCompany(Company arg) {
            this.optimisticData.put(this.getKey("company"), arg);
            return this;
        }

        public CompanyContact getContact() {
            return (CompanyContact)this.get("contact");
        }

        public PurchasingCompany setContact(CompanyContact arg) {
            this.optimisticData.put(this.getKey("contact"), arg);
            return this;
        }

        public CompanyLocation getLocation() {
            return (CompanyLocation)this.get("location");
        }

        public PurchasingCompany setLocation(CompanyLocation arg) {
            this.optimisticData.put(this.getKey("location"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "company": {
                    return true;
                }
                case "contact": {
                    return true;
                }
                case "location": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class PurchasingCompanyQuery
    extends Query<PurchasingCompanyQuery> {
        PurchasingCompanyQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public PurchasingCompanyQuery company(CompanyQueryDefinition queryDef) {
            this.startField("company");
            this._queryBuilder.append('{');
            queryDef.define(new CompanyQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public PurchasingCompanyQuery contact(CompanyContactQueryDefinition queryDef) {
            this.startField("contact");
            this._queryBuilder.append('{');
            queryDef.define(new CompanyContactQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public PurchasingCompanyQuery location(CompanyLocationQueryDefinition queryDef) {
            this.startField("location");
            this._queryBuilder.append('{');
            queryDef.define(new CompanyLocationQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface PurchasingCompanyQueryDefinition {
        public void define(PurchasingCompanyQuery var1);
    }

    public static enum ProductVariantSortKeys {
        ID,
        POSITION,
        RELEVANCE,
        SKU,
        TITLE,
        UNKNOWN_VALUE;


        public static ProductVariantSortKeys fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "ID": {
                    return ID;
                }
                case "POSITION": {
                    return POSITION;
                }
                case "RELEVANCE": {
                    return RELEVANCE;
                }
                case "SKU": {
                    return SKU;
                }
                case "TITLE": {
                    return TITLE;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case ID: {
                    return "ID";
                }
                case POSITION: {
                    return "POSITION";
                }
                case RELEVANCE: {
                    return "RELEVANCE";
                }
                case SKU: {
                    return "SKU";
                }
                case TITLE: {
                    return "TITLE";
                }
            }
            return "";
        }
    }

    public static class ProductVariantEdge
    extends AbstractResponse<ProductVariantEdge> {
        public ProductVariantEdge() {
        }

        public ProductVariantEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, new ProductVariant(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ProductVariantEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public ProductVariantEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public ProductVariant getNode() {
            return (ProductVariant)this.get("node");
        }

        public ProductVariantEdge setNode(ProductVariant arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ProductVariantEdgeQuery
    extends Query<ProductVariantEdgeQuery> {
        ProductVariantEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ProductVariantEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public ProductVariantEdgeQuery node(ProductVariantQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new ProductVariantQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface ProductVariantEdgeQueryDefinition {
        public void define(ProductVariantEdgeQuery var1);
    }

    public static class ProductVariantConnection
    extends AbstractResponse<ProductVariantConnection> {
        public ProductVariantConnection() {
        }

        public ProductVariantConnection(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new ProductVariantEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "nodes": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new ProductVariant(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ProductVariantConnection";
        }

        public List<ProductVariantEdge> getEdges() {
            return (List)this.get("edges");
        }

        public ProductVariantConnection setEdges(List<ProductVariantEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<ProductVariant> getNodes() {
            return (List)this.get("nodes");
        }

        public ProductVariantConnection setNodes(List<ProductVariant> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public ProductVariantConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "nodes": {
                    return true;
                }
                case "pageInfo": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ProductVariantConnectionQuery
    extends Query<ProductVariantConnectionQuery> {
        ProductVariantConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ProductVariantConnectionQuery edges(ProductVariantEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new ProductVariantEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantConnectionQuery nodes(ProductVariantQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new ProductVariantQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface ProductVariantConnectionQueryDefinition {
        public void define(ProductVariantConnectionQuery var1);
    }

    public static class ProductVariantComponentEdge
    extends AbstractResponse<ProductVariantComponentEdge> {
        public ProductVariantComponentEdge() {
        }

        public ProductVariantComponentEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, new ProductVariantComponent(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ProductVariantComponentEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public ProductVariantComponentEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public ProductVariantComponent getNode() {
            return (ProductVariantComponent)this.get("node");
        }

        public ProductVariantComponentEdge setNode(ProductVariantComponent arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ProductVariantComponentEdgeQuery
    extends Query<ProductVariantComponentEdgeQuery> {
        ProductVariantComponentEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ProductVariantComponentEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public ProductVariantComponentEdgeQuery node(ProductVariantComponentQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new ProductVariantComponentQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface ProductVariantComponentEdgeQueryDefinition {
        public void define(ProductVariantComponentEdgeQuery var1);
    }

    public static class ProductVariantComponentConnection
    extends AbstractResponse<ProductVariantComponentConnection> {
        public ProductVariantComponentConnection() {
        }

        public ProductVariantComponentConnection(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new ProductVariantComponentEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "nodes": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new ProductVariantComponent(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ProductVariantComponentConnection";
        }

        public List<ProductVariantComponentEdge> getEdges() {
            return (List)this.get("edges");
        }

        public ProductVariantComponentConnection setEdges(List<ProductVariantComponentEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<ProductVariantComponent> getNodes() {
            return (List)this.get("nodes");
        }

        public ProductVariantComponentConnection setNodes(List<ProductVariantComponent> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public ProductVariantComponentConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "nodes": {
                    return true;
                }
                case "pageInfo": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ProductVariantComponentConnectionQuery
    extends Query<ProductVariantComponentConnectionQuery> {
        ProductVariantComponentConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ProductVariantComponentConnectionQuery edges(ProductVariantComponentEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new ProductVariantComponentEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantComponentConnectionQuery nodes(ProductVariantComponentQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new ProductVariantComponentQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantComponentConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface ProductVariantComponentConnectionQueryDefinition {
        public void define(ProductVariantComponentConnectionQuery var1);
    }

    public static class ProductVariantComponent
    extends AbstractResponse<ProductVariantComponent> {
        public ProductVariantComponent() {
        }

        public ProductVariantComponent(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "productVariant": {
                        this.responseData.put(key, new ProductVariant(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "quantity": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ProductVariantComponent";
        }

        public ProductVariant getProductVariant() {
            return (ProductVariant)this.get("productVariant");
        }

        public ProductVariantComponent setProductVariant(ProductVariant arg) {
            this.optimisticData.put(this.getKey("productVariant"), arg);
            return this;
        }

        public Integer getQuantity() {
            return (Integer)this.get("quantity");
        }

        public ProductVariantComponent setQuantity(Integer arg) {
            this.optimisticData.put(this.getKey("quantity"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "productVariant": {
                    return true;
                }
                case "quantity": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ProductVariantComponentQuery
    extends Query<ProductVariantComponentQuery> {
        ProductVariantComponentQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ProductVariantComponentQuery productVariant(ProductVariantQueryDefinition queryDef) {
            this.startField("productVariant");
            this._queryBuilder.append('{');
            queryDef.define(new ProductVariantQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantComponentQuery quantity() {
            this.startField("quantity");
            return this;
        }
    }

    public static interface ProductVariantComponentQueryDefinition {
        public void define(ProductVariantComponentQuery var1);
    }

    public static class ProductVariant
    extends AbstractResponse<ProductVariant>
    implements HasMetafields,
    Merchandise,
    MetafieldParentResource,
    MetafieldReference,
    Node {
        public ProductVariant() {
        }

        public ProductVariant(JsonObject fields) throws SchemaViolationError {
            block64: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "availableForSale": {
                        this.responseData.put(key, this.jsonAsBoolean((JsonElement)field.getValue(), key));
                        continue block64;
                    }
                    case "barcode": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block64;
                    }
                    case "compareAtPrice": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block64;
                    }
                    case "compareAtPriceV2": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block64;
                    }
                    case "components": {
                        this.responseData.put(key, new ProductVariantComponentConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block64;
                    }
                    case "currentlyNotInStock": {
                        this.responseData.put(key, this.jsonAsBoolean((JsonElement)field.getValue(), key));
                        continue block64;
                    }
                    case "groupedBy": {
                        this.responseData.put(key, new ProductVariantConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block64;
                    }
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block64;
                    }
                    case "image": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Image(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block64;
                    }
                    case "metafield": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Metafield(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block64;
                    }
                    case "metafields": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            Metafield optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = new Metafield(this.jsonAsObject(element1, key));
                            }
                            list1.add(optional2);
                        }
                        this.responseData.put(key, list1);
                        continue block64;
                    }
                    case "price": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block64;
                    }
                    case "priceV2": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block64;
                    }
                    case "product": {
                        this.responseData.put(key, new Product(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block64;
                    }
                    case "quantityAvailable": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsInteger((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block64;
                    }
                    case "quantityPriceBreaks": {
                        this.responseData.put(key, new QuantityPriceBreakConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block64;
                    }
                    case "quantityRule": {
                        this.responseData.put(key, new QuantityRule(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block64;
                    }
                    case "requiresComponents": {
                        this.responseData.put(key, this.jsonAsBoolean((JsonElement)field.getValue(), key));
                        continue block64;
                    }
                    case "requiresShipping": {
                        this.responseData.put(key, this.jsonAsBoolean((JsonElement)field.getValue(), key));
                        continue block64;
                    }
                    case "selectedOptions": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new SelectedOption(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block64;
                    }
                    case "sellingPlanAllocations": {
                        this.responseData.put(key, new SellingPlanAllocationConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block64;
                    }
                    case "sku": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block64;
                    }
                    case "storeAvailability": {
                        this.responseData.put(key, new StoreAvailabilityConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block64;
                    }
                    case "taxable": {
                        this.responseData.put(key, this.jsonAsBoolean((JsonElement)field.getValue(), key));
                        continue block64;
                    }
                    case "title": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block64;
                    }
                    case "unitPrice": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block64;
                    }
                    case "unitPriceMeasurement": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new UnitPriceMeasurement(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block64;
                    }
                    case "weight": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsDouble((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block64;
                    }
                    case "weightUnit": {
                        this.responseData.put(key, WeightUnit.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block64;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block64;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public ProductVariant(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "ProductVariant";
        }

        public Boolean getAvailableForSale() {
            return (Boolean)this.get("availableForSale");
        }

        public ProductVariant setAvailableForSale(Boolean arg) {
            this.optimisticData.put(this.getKey("availableForSale"), arg);
            return this;
        }

        public String getBarcode() {
            return (String)this.get("barcode");
        }

        public ProductVariant setBarcode(String arg) {
            this.optimisticData.put(this.getKey("barcode"), arg);
            return this;
        }

        public MoneyV2 getCompareAtPrice() {
            return (MoneyV2)this.get("compareAtPrice");
        }

        public ProductVariant setCompareAtPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("compareAtPrice"), arg);
            return this;
        }

        public MoneyV2 getCompareAtPriceV2() {
            return (MoneyV2)this.get("compareAtPriceV2");
        }

        public ProductVariant setCompareAtPriceV2(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("compareAtPriceV2"), arg);
            return this;
        }

        public ProductVariantComponentConnection getComponents() {
            return (ProductVariantComponentConnection)this.get("components");
        }

        public ProductVariant setComponents(ProductVariantComponentConnection arg) {
            this.optimisticData.put(this.getKey("components"), arg);
            return this;
        }

        public Boolean getCurrentlyNotInStock() {
            return (Boolean)this.get("currentlyNotInStock");
        }

        public ProductVariant setCurrentlyNotInStock(Boolean arg) {
            this.optimisticData.put(this.getKey("currentlyNotInStock"), arg);
            return this;
        }

        public ProductVariantConnection getGroupedBy() {
            return (ProductVariantConnection)this.get("groupedBy");
        }

        public ProductVariant setGroupedBy(ProductVariantConnection arg) {
            this.optimisticData.put(this.getKey("groupedBy"), arg);
            return this;
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        public Image getImage() {
            return (Image)this.get("image");
        }

        public ProductVariant setImage(Image arg) {
            this.optimisticData.put(this.getKey("image"), arg);
            return this;
        }

        @Override
        public Metafield getMetafield() {
            return (Metafield)this.get("metafield");
        }

        public ProductVariant setMetafield(Metafield arg) {
            this.optimisticData.put(this.getKey("metafield"), arg);
            return this;
        }

        @Override
        public List<Metafield> getMetafields() {
            return (List)this.get("metafields");
        }

        public ProductVariant setMetafields(List<Metafield> arg) {
            this.optimisticData.put(this.getKey("metafields"), arg);
            return this;
        }

        public MoneyV2 getPrice() {
            return (MoneyV2)this.get("price");
        }

        public ProductVariant setPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("price"), arg);
            return this;
        }

        public MoneyV2 getPriceV2() {
            return (MoneyV2)this.get("priceV2");
        }

        public ProductVariant setPriceV2(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("priceV2"), arg);
            return this;
        }

        public Product getProduct() {
            return (Product)this.get("product");
        }

        public ProductVariant setProduct(Product arg) {
            this.optimisticData.put(this.getKey("product"), arg);
            return this;
        }

        public Integer getQuantityAvailable() {
            return (Integer)this.get("quantityAvailable");
        }

        public ProductVariant setQuantityAvailable(Integer arg) {
            this.optimisticData.put(this.getKey("quantityAvailable"), arg);
            return this;
        }

        public QuantityPriceBreakConnection getQuantityPriceBreaks() {
            return (QuantityPriceBreakConnection)this.get("quantityPriceBreaks");
        }

        public ProductVariant setQuantityPriceBreaks(QuantityPriceBreakConnection arg) {
            this.optimisticData.put(this.getKey("quantityPriceBreaks"), arg);
            return this;
        }

        public QuantityRule getQuantityRule() {
            return (QuantityRule)this.get("quantityRule");
        }

        public ProductVariant setQuantityRule(QuantityRule arg) {
            this.optimisticData.put(this.getKey("quantityRule"), arg);
            return this;
        }

        public Boolean getRequiresComponents() {
            return (Boolean)this.get("requiresComponents");
        }

        public ProductVariant setRequiresComponents(Boolean arg) {
            this.optimisticData.put(this.getKey("requiresComponents"), arg);
            return this;
        }

        public Boolean getRequiresShipping() {
            return (Boolean)this.get("requiresShipping");
        }

        public ProductVariant setRequiresShipping(Boolean arg) {
            this.optimisticData.put(this.getKey("requiresShipping"), arg);
            return this;
        }

        public List<SelectedOption> getSelectedOptions() {
            return (List)this.get("selectedOptions");
        }

        public ProductVariant setSelectedOptions(List<SelectedOption> arg) {
            this.optimisticData.put(this.getKey("selectedOptions"), arg);
            return this;
        }

        public SellingPlanAllocationConnection getSellingPlanAllocations() {
            return (SellingPlanAllocationConnection)this.get("sellingPlanAllocations");
        }

        public ProductVariant setSellingPlanAllocations(SellingPlanAllocationConnection arg) {
            this.optimisticData.put(this.getKey("sellingPlanAllocations"), arg);
            return this;
        }

        public String getSku() {
            return (String)this.get("sku");
        }

        public ProductVariant setSku(String arg) {
            this.optimisticData.put(this.getKey("sku"), arg);
            return this;
        }

        public StoreAvailabilityConnection getStoreAvailability() {
            return (StoreAvailabilityConnection)this.get("storeAvailability");
        }

        public ProductVariant setStoreAvailability(StoreAvailabilityConnection arg) {
            this.optimisticData.put(this.getKey("storeAvailability"), arg);
            return this;
        }

        public Boolean getTaxable() {
            return (Boolean)this.get("taxable");
        }

        public ProductVariant setTaxable(Boolean arg) {
            this.optimisticData.put(this.getKey("taxable"), arg);
            return this;
        }

        public String getTitle() {
            return (String)this.get("title");
        }

        public ProductVariant setTitle(String arg) {
            this.optimisticData.put(this.getKey("title"), arg);
            return this;
        }

        public MoneyV2 getUnitPrice() {
            return (MoneyV2)this.get("unitPrice");
        }

        public ProductVariant setUnitPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("unitPrice"), arg);
            return this;
        }

        public UnitPriceMeasurement getUnitPriceMeasurement() {
            return (UnitPriceMeasurement)this.get("unitPriceMeasurement");
        }

        public ProductVariant setUnitPriceMeasurement(UnitPriceMeasurement arg) {
            this.optimisticData.put(this.getKey("unitPriceMeasurement"), arg);
            return this;
        }

        public Double getWeight() {
            return (Double)this.get("weight");
        }

        public ProductVariant setWeight(Double arg) {
            this.optimisticData.put(this.getKey("weight"), arg);
            return this;
        }

        public WeightUnit getWeightUnit() {
            return (WeightUnit)((Object)this.get("weightUnit"));
        }

        public ProductVariant setWeightUnit(WeightUnit arg) {
            this.optimisticData.put(this.getKey("weightUnit"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "availableForSale": {
                    return false;
                }
                case "barcode": {
                    return false;
                }
                case "compareAtPrice": {
                    return true;
                }
                case "compareAtPriceV2": {
                    return true;
                }
                case "components": {
                    return true;
                }
                case "currentlyNotInStock": {
                    return false;
                }
                case "groupedBy": {
                    return true;
                }
                case "id": {
                    return false;
                }
                case "image": {
                    return true;
                }
                case "metafield": {
                    return true;
                }
                case "metafields": {
                    return true;
                }
                case "price": {
                    return true;
                }
                case "priceV2": {
                    return true;
                }
                case "product": {
                    return true;
                }
                case "quantityAvailable": {
                    return false;
                }
                case "quantityPriceBreaks": {
                    return true;
                }
                case "quantityRule": {
                    return true;
                }
                case "requiresComponents": {
                    return false;
                }
                case "requiresShipping": {
                    return false;
                }
                case "selectedOptions": {
                    return true;
                }
                case "sellingPlanAllocations": {
                    return true;
                }
                case "sku": {
                    return false;
                }
                case "storeAvailability": {
                    return true;
                }
                case "taxable": {
                    return false;
                }
                case "title": {
                    return false;
                }
                case "unitPrice": {
                    return true;
                }
                case "unitPriceMeasurement": {
                    return true;
                }
                case "weight": {
                    return false;
                }
                case "weightUnit": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ProductVariantQuery
    extends Query<ProductVariantQuery> {
        ProductVariantQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public ProductVariantQuery availableForSale() {
            this.startField("availableForSale");
            return this;
        }

        public ProductVariantQuery barcode() {
            this.startField("barcode");
            return this;
        }

        public ProductVariantQuery compareAtPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("compareAtPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        @Deprecated
        public ProductVariantQuery compareAtPriceV2(MoneyV2QueryDefinition queryDef) {
            this.startField("compareAtPriceV2");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantQuery components(ProductVariantComponentConnectionQueryDefinition queryDef) {
            return this.components(args -> {}, queryDef);
        }

        public ProductVariantQuery components(ComponentsArgumentsDefinition argsDef, ProductVariantComponentConnectionQueryDefinition queryDef) {
            this.startField("components");
            ComponentsArguments args = new ComponentsArguments(this._queryBuilder);
            argsDef.define(args);
            ComponentsArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new ProductVariantComponentConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantQuery currentlyNotInStock() {
            this.startField("currentlyNotInStock");
            return this;
        }

        public ProductVariantQuery groupedBy(ProductVariantConnectionQueryDefinition queryDef) {
            return this.groupedBy(args -> {}, queryDef);
        }

        public ProductVariantQuery groupedBy(GroupedByArgumentsDefinition argsDef, ProductVariantConnectionQueryDefinition queryDef) {
            this.startField("groupedBy");
            GroupedByArguments args = new GroupedByArguments(this._queryBuilder);
            argsDef.define(args);
            GroupedByArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new ProductVariantConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantQuery image(ImageQueryDefinition queryDef) {
            this.startField("image");
            this._queryBuilder.append('{');
            queryDef.define(new ImageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantQuery metafield(String key, MetafieldQueryDefinition queryDef) {
            return this.metafield(key, args -> {}, queryDef);
        }

        public ProductVariantQuery metafield(String key, MetafieldArgumentsDefinition argsDef, MetafieldQueryDefinition queryDef) {
            this.startField("metafield");
            this._queryBuilder.append("(key:");
            Query.appendQuotedString(this._queryBuilder, key.toString());
            argsDef.define(new MetafieldArguments(this._queryBuilder));
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantQuery metafields(List<HasMetafieldsIdentifier> identifiers, MetafieldQueryDefinition queryDef) {
            this.startField("metafields");
            this._queryBuilder.append("(identifiers:");
            this._queryBuilder.append('[');
            String listSeperator1 = "";
            for (HasMetafieldsIdentifier item1 : identifiers) {
                this._queryBuilder.append(listSeperator1);
                listSeperator1 = ",";
                item1.appendTo(this._queryBuilder);
            }
            this._queryBuilder.append(']');
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantQuery price(MoneyV2QueryDefinition queryDef) {
            this.startField("price");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        @Deprecated
        public ProductVariantQuery priceV2(MoneyV2QueryDefinition queryDef) {
            this.startField("priceV2");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantQuery product(ProductQueryDefinition queryDef) {
            this.startField("product");
            this._queryBuilder.append('{');
            queryDef.define(new ProductQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantQuery quantityAvailable() {
            this.startField("quantityAvailable");
            return this;
        }

        public ProductVariantQuery quantityPriceBreaks(QuantityPriceBreakConnectionQueryDefinition queryDef) {
            return this.quantityPriceBreaks(args -> {}, queryDef);
        }

        public ProductVariantQuery quantityPriceBreaks(QuantityPriceBreaksArgumentsDefinition argsDef, QuantityPriceBreakConnectionQueryDefinition queryDef) {
            this.startField("quantityPriceBreaks");
            QuantityPriceBreaksArguments args = new QuantityPriceBreaksArguments(this._queryBuilder);
            argsDef.define(args);
            QuantityPriceBreaksArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new QuantityPriceBreakConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantQuery quantityRule(QuantityRuleQueryDefinition queryDef) {
            this.startField("quantityRule");
            this._queryBuilder.append('{');
            queryDef.define(new QuantityRuleQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantQuery requiresComponents() {
            this.startField("requiresComponents");
            return this;
        }

        public ProductVariantQuery requiresShipping() {
            this.startField("requiresShipping");
            return this;
        }

        public ProductVariantQuery selectedOptions(SelectedOptionQueryDefinition queryDef) {
            this.startField("selectedOptions");
            this._queryBuilder.append('{');
            queryDef.define(new SelectedOptionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantQuery sellingPlanAllocations(SellingPlanAllocationConnectionQueryDefinition queryDef) {
            return this.sellingPlanAllocations(args -> {}, queryDef);
        }

        public ProductVariantQuery sellingPlanAllocations(SellingPlanAllocationsArgumentsDefinition argsDef, SellingPlanAllocationConnectionQueryDefinition queryDef) {
            this.startField("sellingPlanAllocations");
            SellingPlanAllocationsArguments args = new SellingPlanAllocationsArguments(this._queryBuilder);
            argsDef.define(args);
            SellingPlanAllocationsArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanAllocationConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantQuery sku() {
            this.startField("sku");
            return this;
        }

        public ProductVariantQuery storeAvailability(StoreAvailabilityConnectionQueryDefinition queryDef) {
            return this.storeAvailability(args -> {}, queryDef);
        }

        public ProductVariantQuery storeAvailability(StoreAvailabilityArgumentsDefinition argsDef, StoreAvailabilityConnectionQueryDefinition queryDef) {
            this.startField("storeAvailability");
            StoreAvailabilityArguments args = new StoreAvailabilityArguments(this._queryBuilder);
            argsDef.define(args);
            StoreAvailabilityArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new StoreAvailabilityConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantQuery taxable() {
            this.startField("taxable");
            return this;
        }

        public ProductVariantQuery title() {
            this.startField("title");
            return this;
        }

        public ProductVariantQuery unitPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("unitPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantQuery unitPriceMeasurement(UnitPriceMeasurementQueryDefinition queryDef) {
            this.startField("unitPriceMeasurement");
            this._queryBuilder.append('{');
            queryDef.define(new UnitPriceMeasurementQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductVariantQuery weight() {
            this.startField("weight");
            return this;
        }

        public ProductVariantQuery weightUnit() {
            this.startField("weightUnit");
            return this;
        }

        public static interface StoreAvailabilityArgumentsDefinition {
            public void define(StoreAvailabilityArguments var1);
        }

        public class StoreAvailabilityArguments
        extends Arguments {
            StoreAvailabilityArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public StoreAvailabilityArguments near(GeoCoordinateInput value) {
                if (value != null) {
                    this.startArgument("near");
                    value.appendTo(ProductVariantQuery.this._queryBuilder);
                }
                return this;
            }

            public StoreAvailabilityArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    ProductVariantQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public StoreAvailabilityArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(ProductVariantQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public StoreAvailabilityArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    ProductVariantQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public StoreAvailabilityArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(ProductVariantQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public StoreAvailabilityArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    ProductVariantQuery.this._queryBuilder.append(value);
                }
                return this;
            }
        }

        public static interface SellingPlanAllocationsArgumentsDefinition {
            public void define(SellingPlanAllocationsArguments var1);
        }

        public class SellingPlanAllocationsArguments
        extends Arguments {
            SellingPlanAllocationsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public SellingPlanAllocationsArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    ProductVariantQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public SellingPlanAllocationsArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(ProductVariantQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public SellingPlanAllocationsArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    ProductVariantQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public SellingPlanAllocationsArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(ProductVariantQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public SellingPlanAllocationsArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    ProductVariantQuery.this._queryBuilder.append(value);
                }
                return this;
            }
        }

        public static interface QuantityPriceBreaksArgumentsDefinition {
            public void define(QuantityPriceBreaksArguments var1);
        }

        public class QuantityPriceBreaksArguments
        extends Arguments {
            QuantityPriceBreaksArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public QuantityPriceBreaksArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    ProductVariantQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public QuantityPriceBreaksArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(ProductVariantQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public QuantityPriceBreaksArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    ProductVariantQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public QuantityPriceBreaksArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(ProductVariantQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }

        public static interface MetafieldArgumentsDefinition {
            public void define(MetafieldArguments var1);
        }

        public class MetafieldArguments
        extends Arguments {
            MetafieldArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            public MetafieldArguments namespace(String value) {
                if (value != null) {
                    this.startArgument("namespace");
                    Query.appendQuotedString(ProductVariantQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }

        public static interface GroupedByArgumentsDefinition {
            public void define(GroupedByArguments var1);
        }

        public class GroupedByArguments
        extends Arguments {
            GroupedByArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public GroupedByArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    ProductVariantQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public GroupedByArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(ProductVariantQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public GroupedByArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    ProductVariantQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public GroupedByArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(ProductVariantQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }

        public static interface ComponentsArgumentsDefinition {
            public void define(ComponentsArguments var1);
        }

        public class ComponentsArguments
        extends Arguments {
            ComponentsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public ComponentsArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    ProductVariantQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public ComponentsArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(ProductVariantQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public ComponentsArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    ProductVariantQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public ComponentsArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(ProductVariantQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }
    }

    public static interface ProductVariantQueryDefinition {
        public void define(ProductVariantQuery var1);
    }

    public static enum ProductSortKeys {
        BEST_SELLING,
        CREATED_AT,
        ID,
        PRICE,
        PRODUCT_TYPE,
        RELEVANCE,
        TITLE,
        UPDATED_AT,
        VENDOR,
        UNKNOWN_VALUE;


        public static ProductSortKeys fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "BEST_SELLING": {
                    return BEST_SELLING;
                }
                case "CREATED_AT": {
                    return CREATED_AT;
                }
                case "ID": {
                    return ID;
                }
                case "PRICE": {
                    return PRICE;
                }
                case "PRODUCT_TYPE": {
                    return PRODUCT_TYPE;
                }
                case "RELEVANCE": {
                    return RELEVANCE;
                }
                case "TITLE": {
                    return TITLE;
                }
                case "UPDATED_AT": {
                    return UPDATED_AT;
                }
                case "VENDOR": {
                    return VENDOR;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case BEST_SELLING: {
                    return "BEST_SELLING";
                }
                case CREATED_AT: {
                    return "CREATED_AT";
                }
                case ID: {
                    return "ID";
                }
                case PRICE: {
                    return "PRICE";
                }
                case PRODUCT_TYPE: {
                    return "PRODUCT_TYPE";
                }
                case RELEVANCE: {
                    return "RELEVANCE";
                }
                case TITLE: {
                    return "TITLE";
                }
                case UPDATED_AT: {
                    return "UPDATED_AT";
                }
                case VENDOR: {
                    return "VENDOR";
                }
            }
            return "";
        }
    }

    public static enum ProductRecommendationIntent {
        COMPLEMENTARY,
        RELATED,
        UNKNOWN_VALUE;


        public static ProductRecommendationIntent fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "COMPLEMENTARY": {
                    return COMPLEMENTARY;
                }
                case "RELATED": {
                    return RELATED;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case COMPLEMENTARY: {
                    return "COMPLEMENTARY";
                }
                case RELATED: {
                    return "RELATED";
                }
            }
            return "";
        }
    }

    public static class ProductPriceRange
    extends AbstractResponse<ProductPriceRange> {
        public ProductPriceRange() {
        }

        public ProductPriceRange(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "maxVariantPrice": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "minVariantPrice": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ProductPriceRange";
        }

        public MoneyV2 getMaxVariantPrice() {
            return (MoneyV2)this.get("maxVariantPrice");
        }

        public ProductPriceRange setMaxVariantPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("maxVariantPrice"), arg);
            return this;
        }

        public MoneyV2 getMinVariantPrice() {
            return (MoneyV2)this.get("minVariantPrice");
        }

        public ProductPriceRange setMinVariantPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("minVariantPrice"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "maxVariantPrice": {
                    return true;
                }
                case "minVariantPrice": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ProductPriceRangeQuery
    extends Query<ProductPriceRangeQuery> {
        ProductPriceRangeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ProductPriceRangeQuery maxVariantPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("maxVariantPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductPriceRangeQuery minVariantPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("minVariantPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface ProductPriceRangeQueryDefinition {
        public void define(ProductPriceRangeQuery var1);
    }

    public static class ProductOptionValueSwatch
    extends AbstractResponse<ProductOptionValueSwatch> {
        public ProductOptionValueSwatch() {
        }

        public ProductOptionValueSwatch(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "color": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "image": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = UnknownMedia.create(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ProductOptionValueSwatch";
        }

        public String getColor() {
            return (String)this.get("color");
        }

        public ProductOptionValueSwatch setColor(String arg) {
            this.optimisticData.put(this.getKey("color"), arg);
            return this;
        }

        public Media getImage() {
            return (Media)this.get("image");
        }

        public ProductOptionValueSwatch setImage(Media arg) {
            this.optimisticData.put(this.getKey("image"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "color": {
                    return false;
                }
                case "image": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ProductOptionValueSwatchQuery
    extends Query<ProductOptionValueSwatchQuery> {
        ProductOptionValueSwatchQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ProductOptionValueSwatchQuery color() {
            this.startField("color");
            return this;
        }

        public ProductOptionValueSwatchQuery image(MediaQueryDefinition queryDef) {
            this.startField("image");
            this._queryBuilder.append('{');
            queryDef.define(new MediaQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface ProductOptionValueSwatchQueryDefinition {
        public void define(ProductOptionValueSwatchQuery var1);
    }

    public static class ProductOptionValue
    extends AbstractResponse<ProductOptionValue>
    implements Node {
        public ProductOptionValue() {
        }

        public ProductOptionValue(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "name": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                    case "swatch": {
                        ProductOptionValueSwatch optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ProductOptionValueSwatch(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public ProductOptionValue(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "ProductOptionValue";
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        public String getName() {
            return (String)this.get("name");
        }

        public ProductOptionValue setName(String arg) {
            this.optimisticData.put(this.getKey("name"), arg);
            return this;
        }

        public ProductOptionValueSwatch getSwatch() {
            return (ProductOptionValueSwatch)this.get("swatch");
        }

        public ProductOptionValue setSwatch(ProductOptionValueSwatch arg) {
            this.optimisticData.put(this.getKey("swatch"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "id": {
                    return false;
                }
                case "name": {
                    return false;
                }
                case "swatch": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ProductOptionValueQuery
    extends Query<ProductOptionValueQuery> {
        ProductOptionValueQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public ProductOptionValueQuery name() {
            this.startField("name");
            return this;
        }

        public ProductOptionValueQuery swatch(ProductOptionValueSwatchQueryDefinition queryDef) {
            this.startField("swatch");
            this._queryBuilder.append('{');
            queryDef.define(new ProductOptionValueSwatchQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface ProductOptionValueQueryDefinition {
        public void define(ProductOptionValueQuery var1);
    }

    public static class ProductOption
    extends AbstractResponse<ProductOption>
    implements Node {
        public ProductOption() {
        }

        public ProductOption(JsonObject fields) throws SchemaViolationError {
            block14: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block14;
                    }
                    case "name": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "optionValues": {
                        ArrayList<Object> list1 = new ArrayList<Object>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new ProductOptionValue(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block14;
                    }
                    case "values": {
                        ArrayList<Object> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(this.jsonAsString(element1, key));
                        }
                        this.responseData.put(key, list1);
                        continue block14;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public ProductOption(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "ProductOption";
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        public String getName() {
            return (String)this.get("name");
        }

        public ProductOption setName(String arg) {
            this.optimisticData.put(this.getKey("name"), arg);
            return this;
        }

        public List<ProductOptionValue> getOptionValues() {
            return (List)this.get("optionValues");
        }

        public ProductOption setOptionValues(List<ProductOptionValue> arg) {
            this.optimisticData.put(this.getKey("optionValues"), arg);
            return this;
        }

        public List<String> getValues() {
            return (List)this.get("values");
        }

        public ProductOption setValues(List<String> arg) {
            this.optimisticData.put(this.getKey("values"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "id": {
                    return false;
                }
                case "name": {
                    return false;
                }
                case "optionValues": {
                    return true;
                }
                case "values": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ProductOptionQuery
    extends Query<ProductOptionQuery> {
        ProductOptionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public ProductOptionQuery name() {
            this.startField("name");
            return this;
        }

        public ProductOptionQuery optionValues(ProductOptionValueQueryDefinition queryDef) {
            this.startField("optionValues");
            this._queryBuilder.append('{');
            queryDef.define(new ProductOptionValueQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        @Deprecated
        public ProductOptionQuery values() {
            this.startField("values");
            return this;
        }
    }

    public static interface ProductOptionQueryDefinition {
        public void define(ProductOptionQuery var1);
    }

    public static enum ProductMediaSortKeys {
        ID,
        POSITION,
        RELEVANCE,
        UNKNOWN_VALUE;


        public static ProductMediaSortKeys fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "ID": {
                    return ID;
                }
                case "POSITION": {
                    return POSITION;
                }
                case "RELEVANCE": {
                    return RELEVANCE;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case ID: {
                    return "ID";
                }
                case POSITION: {
                    return "POSITION";
                }
                case RELEVANCE: {
                    return "RELEVANCE";
                }
            }
            return "";
        }
    }

    public static enum ProductImageSortKeys {
        CREATED_AT,
        ID,
        POSITION,
        RELEVANCE,
        UNKNOWN_VALUE;


        public static ProductImageSortKeys fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "CREATED_AT": {
                    return CREATED_AT;
                }
                case "ID": {
                    return ID;
                }
                case "POSITION": {
                    return POSITION;
                }
                case "RELEVANCE": {
                    return RELEVANCE;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case CREATED_AT: {
                    return "CREATED_AT";
                }
                case ID: {
                    return "ID";
                }
                case POSITION: {
                    return "POSITION";
                }
                case RELEVANCE: {
                    return "RELEVANCE";
                }
            }
            return "";
        }
    }

    public static class ProductFilter
    implements Serializable {
        private Input<Boolean> available = Input.undefined();
        private Input<VariantOptionFilter> variantOption = Input.undefined();
        private Input<String> productType = Input.undefined();
        private Input<String> productVendor = Input.undefined();
        private Input<PriceRangeFilter> price = Input.undefined();
        private Input<MetafieldFilter> productMetafield = Input.undefined();
        private Input<MetafieldFilter> variantMetafield = Input.undefined();
        private Input<String> tag = Input.undefined();

        public Boolean getAvailable() {
            return this.available.getValue();
        }

        public Input<Boolean> getAvailableInput() {
            return this.available;
        }

        public ProductFilter setAvailable(Boolean available) {
            this.available = Input.optional(available);
            return this;
        }

        public ProductFilter setAvailableInput(Input<Boolean> available) {
            if (available == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.available = available;
            return this;
        }

        public VariantOptionFilter getVariantOption() {
            return this.variantOption.getValue();
        }

        public Input<VariantOptionFilter> getVariantOptionInput() {
            return this.variantOption;
        }

        public ProductFilter setVariantOption(VariantOptionFilter variantOption) {
            this.variantOption = Input.optional(variantOption);
            return this;
        }

        public ProductFilter setVariantOptionInput(Input<VariantOptionFilter> variantOption) {
            if (variantOption == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.variantOption = variantOption;
            return this;
        }

        public String getProductType() {
            return this.productType.getValue();
        }

        public Input<String> getProductTypeInput() {
            return this.productType;
        }

        public ProductFilter setProductType(String productType) {
            this.productType = Input.optional(productType);
            return this;
        }

        public ProductFilter setProductTypeInput(Input<String> productType) {
            if (productType == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.productType = productType;
            return this;
        }

        public String getProductVendor() {
            return this.productVendor.getValue();
        }

        public Input<String> getProductVendorInput() {
            return this.productVendor;
        }

        public ProductFilter setProductVendor(String productVendor) {
            this.productVendor = Input.optional(productVendor);
            return this;
        }

        public ProductFilter setProductVendorInput(Input<String> productVendor) {
            if (productVendor == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.productVendor = productVendor;
            return this;
        }

        public PriceRangeFilter getPrice() {
            return this.price.getValue();
        }

        public Input<PriceRangeFilter> getPriceInput() {
            return this.price;
        }

        public ProductFilter setPrice(PriceRangeFilter price) {
            this.price = Input.optional(price);
            return this;
        }

        public ProductFilter setPriceInput(Input<PriceRangeFilter> price) {
            if (price == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.price = price;
            return this;
        }

        public MetafieldFilter getProductMetafield() {
            return this.productMetafield.getValue();
        }

        public Input<MetafieldFilter> getProductMetafieldInput() {
            return this.productMetafield;
        }

        public ProductFilter setProductMetafield(MetafieldFilter productMetafield) {
            this.productMetafield = Input.optional(productMetafield);
            return this;
        }

        public ProductFilter setProductMetafieldInput(Input<MetafieldFilter> productMetafield) {
            if (productMetafield == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.productMetafield = productMetafield;
            return this;
        }

        public MetafieldFilter getVariantMetafield() {
            return this.variantMetafield.getValue();
        }

        public Input<MetafieldFilter> getVariantMetafieldInput() {
            return this.variantMetafield;
        }

        public ProductFilter setVariantMetafield(MetafieldFilter variantMetafield) {
            this.variantMetafield = Input.optional(variantMetafield);
            return this;
        }

        public ProductFilter setVariantMetafieldInput(Input<MetafieldFilter> variantMetafield) {
            if (variantMetafield == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.variantMetafield = variantMetafield;
            return this;
        }

        public String getTag() {
            return this.tag.getValue();
        }

        public Input<String> getTagInput() {
            return this.tag;
        }

        public ProductFilter setTag(String tag) {
            this.tag = Input.optional(tag);
            return this;
        }

        public ProductFilter setTagInput(Input<String> tag) {
            if (tag == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.tag = tag;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');
            if (this.available.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("available:");
                if (this.available.getValue() != null) {
                    _queryBuilder.append(this.available.getValue());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.variantOption.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("variantOption:");
                if (this.variantOption.getValue() != null) {
                    this.variantOption.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.productType.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("productType:");
                if (this.productType.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.productType.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.productVendor.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("productVendor:");
                if (this.productVendor.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.productVendor.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.price.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("price:");
                if (this.price.getValue() != null) {
                    this.price.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.productMetafield.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("productMetafield:");
                if (this.productMetafield.getValue() != null) {
                    this.productMetafield.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.variantMetafield.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("variantMetafield:");
                if (this.variantMetafield.getValue() != null) {
                    this.variantMetafield.getValue().appendTo(_queryBuilder);
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.tag.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("tag:");
                if (this.tag.getValue() != null) {
                    Query.appendQuotedString(_queryBuilder, this.tag.getValue().toString());
                } else {
                    _queryBuilder.append("null");
                }
            }
            _queryBuilder.append('}');
        }
    }

    public static class ProductEdge
    extends AbstractResponse<ProductEdge> {
        public ProductEdge() {
        }

        public ProductEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, new Product(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ProductEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public ProductEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public Product getNode() {
            return (Product)this.get("node");
        }

        public ProductEdge setNode(Product arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ProductEdgeQuery
    extends Query<ProductEdgeQuery> {
        ProductEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ProductEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public ProductEdgeQuery node(ProductQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new ProductQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface ProductEdgeQueryDefinition {
        public void define(ProductEdgeQuery var1);
    }

    public static class ProductConnection
    extends AbstractResponse<ProductConnection> {
        public ProductConnection() {
        }

        public ProductConnection(JsonObject fields) throws SchemaViolationError {
            block14: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new ProductEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block14;
                    }
                    case "filters": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new Filter(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block14;
                    }
                    case "nodes": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new Product(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block14;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block14;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "ProductConnection";
        }

        public List<ProductEdge> getEdges() {
            return (List)this.get("edges");
        }

        public ProductConnection setEdges(List<ProductEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<Filter> getFilters() {
            return (List)this.get("filters");
        }

        public ProductConnection setFilters(List<Filter> arg) {
            this.optimisticData.put(this.getKey("filters"), arg);
            return this;
        }

        public List<Product> getNodes() {
            return (List)this.get("nodes");
        }

        public ProductConnection setNodes(List<Product> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public ProductConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "filters": {
                    return true;
                }
                case "nodes": {
                    return true;
                }
                case "pageInfo": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class ProductConnectionQuery
    extends Query<ProductConnectionQuery> {
        ProductConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public ProductConnectionQuery edges(ProductEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new ProductEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductConnectionQuery filters(FilterQueryDefinition queryDef) {
            this.startField("filters");
            this._queryBuilder.append('{');
            queryDef.define(new FilterQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductConnectionQuery nodes(ProductQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new ProductQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface ProductConnectionQueryDefinition {
        public void define(ProductConnectionQuery var1);
    }

    public static enum ProductCollectionSortKeys {
        BEST_SELLING,
        COLLECTION_DEFAULT,
        CREATED,
        ID,
        MANUAL,
        PRICE,
        RELEVANCE,
        TITLE,
        UNKNOWN_VALUE;


        public static ProductCollectionSortKeys fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "BEST_SELLING": {
                    return BEST_SELLING;
                }
                case "COLLECTION_DEFAULT": {
                    return COLLECTION_DEFAULT;
                }
                case "CREATED": {
                    return CREATED;
                }
                case "ID": {
                    return ID;
                }
                case "MANUAL": {
                    return MANUAL;
                }
                case "PRICE": {
                    return PRICE;
                }
                case "RELEVANCE": {
                    return RELEVANCE;
                }
                case "TITLE": {
                    return TITLE;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case BEST_SELLING: {
                    return "BEST_SELLING";
                }
                case COLLECTION_DEFAULT: {
                    return "COLLECTION_DEFAULT";
                }
                case CREATED: {
                    return "CREATED";
                }
                case ID: {
                    return "ID";
                }
                case MANUAL: {
                    return "MANUAL";
                }
                case PRICE: {
                    return "PRICE";
                }
                case RELEVANCE: {
                    return "RELEVANCE";
                }
                case TITLE: {
                    return "TITLE";
                }
            }
            return "";
        }
    }

    public static class Product
    extends AbstractResponse<Product>
    implements HasMetafields,
    MenuItemResource,
    MetafieldParentResource,
    MetafieldReference,
    Node,
    OnlineStorePublishable,
    SearchResultItem,
    Trackable {
        public Product() {
        }

        public Product(JsonObject fields) throws SchemaViolationError {
            block66: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "availableForSale": {
                        this.responseData.put(key, this.jsonAsBoolean((JsonElement)field.getValue(), key));
                        continue block66;
                    }
                    case "collections": {
                        this.responseData.put(key, new CollectionConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block66;
                    }
                    case "compareAtPriceRange": {
                        this.responseData.put(key, new ProductPriceRange(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block66;
                    }
                    case "createdAt": {
                        this.responseData.put(key, Utils.parseDateTime(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block66;
                    }
                    case "description": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block66;
                    }
                    case "descriptionHtml": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block66;
                    }
                    case "featuredImage": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Image(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block66;
                    }
                    case "handle": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block66;
                    }
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block66;
                    }
                    case "images": {
                        this.responseData.put(key, new ImageConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block66;
                    }
                    case "isGiftCard": {
                        this.responseData.put(key, this.jsonAsBoolean((JsonElement)field.getValue(), key));
                        continue block66;
                    }
                    case "media": {
                        this.responseData.put(key, new MediaConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block66;
                    }
                    case "metafield": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Metafield(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block66;
                    }
                    case "metafields": {
                        ArrayList<Object> list1 = new ArrayList<Object>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            Metafield optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = new Metafield(this.jsonAsObject(element1, key));
                            }
                            list1.add(optional2);
                        }
                        this.responseData.put(key, list1);
                        continue block66;
                    }
                    case "onlineStoreUrl": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block66;
                    }
                    case "options": {
                        ArrayList<Object> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new ProductOption(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block66;
                    }
                    case "priceRange": {
                        this.responseData.put(key, new ProductPriceRange(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block66;
                    }
                    case "productType": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block66;
                    }
                    case "publishedAt": {
                        this.responseData.put(key, Utils.parseDateTime(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block66;
                    }
                    case "requiresSellingPlan": {
                        this.responseData.put(key, this.jsonAsBoolean((JsonElement)field.getValue(), key));
                        continue block66;
                    }
                    case "sellingPlanGroups": {
                        this.responseData.put(key, new SellingPlanGroupConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block66;
                    }
                    case "seo": {
                        this.responseData.put(key, new SEO(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block66;
                    }
                    case "tags": {
                        ArrayList<Object> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(this.jsonAsString(element1, key));
                        }
                        this.responseData.put(key, list1);
                        continue block66;
                    }
                    case "title": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block66;
                    }
                    case "totalInventory": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsInteger((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block66;
                    }
                    case "trackingParameters": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block66;
                    }
                    case "updatedAt": {
                        this.responseData.put(key, Utils.parseDateTime(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block66;
                    }
                    case "variantBySelectedOptions": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ProductVariant(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block66;
                    }
                    case "variants": {
                        this.responseData.put(key, new ProductVariantConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block66;
                    }
                    case "vendor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block66;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block66;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public Product(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "Product";
        }

        public Boolean getAvailableForSale() {
            return (Boolean)this.get("availableForSale");
        }

        public Product setAvailableForSale(Boolean arg) {
            this.optimisticData.put(this.getKey("availableForSale"), arg);
            return this;
        }

        public CollectionConnection getCollections() {
            return (CollectionConnection)this.get("collections");
        }

        public Product setCollections(CollectionConnection arg) {
            this.optimisticData.put(this.getKey("collections"), arg);
            return this;
        }

        public ProductPriceRange getCompareAtPriceRange() {
            return (ProductPriceRange)this.get("compareAtPriceRange");
        }

        public Product setCompareAtPriceRange(ProductPriceRange arg) {
            this.optimisticData.put(this.getKey("compareAtPriceRange"), arg);
            return this;
        }

        public DateTime getCreatedAt() {
            return (DateTime)this.get("createdAt");
        }

        public Product setCreatedAt(DateTime arg) {
            this.optimisticData.put(this.getKey("createdAt"), arg);
            return this;
        }

        public String getDescription() {
            return (String)this.get("description");
        }

        public Product setDescription(String arg) {
            this.optimisticData.put(this.getKey("description"), arg);
            return this;
        }

        public String getDescriptionHtml() {
            return (String)this.get("descriptionHtml");
        }

        public Product setDescriptionHtml(String arg) {
            this.optimisticData.put(this.getKey("descriptionHtml"), arg);
            return this;
        }

        public Image getFeaturedImage() {
            return (Image)this.get("featuredImage");
        }

        public Product setFeaturedImage(Image arg) {
            this.optimisticData.put(this.getKey("featuredImage"), arg);
            return this;
        }

        public String getHandle() {
            return (String)this.get("handle");
        }

        public Product setHandle(String arg) {
            this.optimisticData.put(this.getKey("handle"), arg);
            return this;
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        public ImageConnection getImages() {
            return (ImageConnection)this.get("images");
        }

        public Product setImages(ImageConnection arg) {
            this.optimisticData.put(this.getKey("images"), arg);
            return this;
        }

        public Boolean getIsGiftCard() {
            return (Boolean)this.get("isGiftCard");
        }

        public Product setIsGiftCard(Boolean arg) {
            this.optimisticData.put(this.getKey("isGiftCard"), arg);
            return this;
        }

        public MediaConnection getMedia() {
            return (MediaConnection)this.get("media");
        }

        public Product setMedia(MediaConnection arg) {
            this.optimisticData.put(this.getKey("media"), arg);
            return this;
        }

        @Override
        public Metafield getMetafield() {
            return (Metafield)this.get("metafield");
        }

        public Product setMetafield(Metafield arg) {
            this.optimisticData.put(this.getKey("metafield"), arg);
            return this;
        }

        @Override
        public List<Metafield> getMetafields() {
            return (List)this.get("metafields");
        }

        public Product setMetafields(List<Metafield> arg) {
            this.optimisticData.put(this.getKey("metafields"), arg);
            return this;
        }

        @Override
        public String getOnlineStoreUrl() {
            return (String)this.get("onlineStoreUrl");
        }

        public Product setOnlineStoreUrl(String arg) {
            this.optimisticData.put(this.getKey("onlineStoreUrl"), arg);
            return this;
        }

        public List<ProductOption> getOptions() {
            return (List)this.get("options");
        }

        public Product setOptions(List<ProductOption> arg) {
            this.optimisticData.put(this.getKey("options"), arg);
            return this;
        }

        public ProductPriceRange getPriceRange() {
            return (ProductPriceRange)this.get("priceRange");
        }

        public Product setPriceRange(ProductPriceRange arg) {
            this.optimisticData.put(this.getKey("priceRange"), arg);
            return this;
        }

        public String getProductType() {
            return (String)this.get("productType");
        }

        public Product setProductType(String arg) {
            this.optimisticData.put(this.getKey("productType"), arg);
            return this;
        }

        public DateTime getPublishedAt() {
            return (DateTime)this.get("publishedAt");
        }

        public Product setPublishedAt(DateTime arg) {
            this.optimisticData.put(this.getKey("publishedAt"), arg);
            return this;
        }

        public Boolean getRequiresSellingPlan() {
            return (Boolean)this.get("requiresSellingPlan");
        }

        public Product setRequiresSellingPlan(Boolean arg) {
            this.optimisticData.put(this.getKey("requiresSellingPlan"), arg);
            return this;
        }

        public SellingPlanGroupConnection getSellingPlanGroups() {
            return (SellingPlanGroupConnection)this.get("sellingPlanGroups");
        }

        public Product setSellingPlanGroups(SellingPlanGroupConnection arg) {
            this.optimisticData.put(this.getKey("sellingPlanGroups"), arg);
            return this;
        }

        public SEO getSeo() {
            return (SEO)this.get("seo");
        }

        public Product setSeo(SEO arg) {
            this.optimisticData.put(this.getKey("seo"), arg);
            return this;
        }

        public List<String> getTags() {
            return (List)this.get("tags");
        }

        public Product setTags(List<String> arg) {
            this.optimisticData.put(this.getKey("tags"), arg);
            return this;
        }

        public String getTitle() {
            return (String)this.get("title");
        }

        public Product setTitle(String arg) {
            this.optimisticData.put(this.getKey("title"), arg);
            return this;
        }

        public Integer getTotalInventory() {
            return (Integer)this.get("totalInventory");
        }

        public Product setTotalInventory(Integer arg) {
            this.optimisticData.put(this.getKey("totalInventory"), arg);
            return this;
        }

        @Override
        public String getTrackingParameters() {
            return (String)this.get("trackingParameters");
        }

        public Product setTrackingParameters(String arg) {
            this.optimisticData.put(this.getKey("trackingParameters"), arg);
            return this;
        }

        public DateTime getUpdatedAt() {
            return (DateTime)this.get("updatedAt");
        }

        public Product setUpdatedAt(DateTime arg) {
            this.optimisticData.put(this.getKey("updatedAt"), arg);
            return this;
        }

        public ProductVariant getVariantBySelectedOptions() {
            return (ProductVariant)this.get("variantBySelectedOptions");
        }

        public Product setVariantBySelectedOptions(ProductVariant arg) {
            this.optimisticData.put(this.getKey("variantBySelectedOptions"), arg);
            return this;
        }

        public ProductVariantConnection getVariants() {
            return (ProductVariantConnection)this.get("variants");
        }

        public Product setVariants(ProductVariantConnection arg) {
            this.optimisticData.put(this.getKey("variants"), arg);
            return this;
        }

        public String getVendor() {
            return (String)this.get("vendor");
        }

        public Product setVendor(String arg) {
            this.optimisticData.put(this.getKey("vendor"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "availableForSale": {
                    return false;
                }
                case "collections": {
                    return true;
                }
                case "compareAtPriceRange": {
                    return true;
                }
                case "createdAt": {
                    return false;
                }
                case "description": {
                    return false;
                }
                case "descriptionHtml": {
                    return false;
                }
                case "featuredImage": {
                    return true;
                }
                case "handle": {
                    return false;
                }
                case "id": {
                    return false;
                }
                case "images": {
                    return true;
                }
                case "isGiftCard": {
                    return false;
                }
                case "media": {
                    return true;
                }
                case "metafield": {
                    return true;
                }
                case "metafields": {
                    return true;
                }
                case "onlineStoreUrl": {
                    return false;
                }
                case "options": {
                    return true;
                }
                case "priceRange": {
                    return true;
                }
                case "productType": {
                    return false;
                }
                case "publishedAt": {
                    return false;
                }
                case "requiresSellingPlan": {
                    return false;
                }
                case "sellingPlanGroups": {
                    return true;
                }
                case "seo": {
                    return true;
                }
                case "tags": {
                    return false;
                }
                case "title": {
                    return false;
                }
                case "totalInventory": {
                    return false;
                }
                case "trackingParameters": {
                    return false;
                }
                case "updatedAt": {
                    return false;
                }
                case "variantBySelectedOptions": {
                    return true;
                }
                case "variants": {
                    return true;
                }
                case "vendor": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class ProductQuery
    extends Query<ProductQuery> {
        ProductQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public ProductQuery availableForSale() {
            this.startField("availableForSale");
            return this;
        }

        public ProductQuery collections(CollectionConnectionQueryDefinition queryDef) {
            return this.collections(args -> {}, queryDef);
        }

        public ProductQuery collections(CollectionsArgumentsDefinition argsDef, CollectionConnectionQueryDefinition queryDef) {
            this.startField("collections");
            CollectionsArguments args = new CollectionsArguments(this._queryBuilder);
            argsDef.define(args);
            CollectionsArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new CollectionConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductQuery compareAtPriceRange(ProductPriceRangeQueryDefinition queryDef) {
            this.startField("compareAtPriceRange");
            this._queryBuilder.append('{');
            queryDef.define(new ProductPriceRangeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductQuery createdAt() {
            this.startField("createdAt");
            return this;
        }

        public ProductQuery description() {
            return this.description(args -> {});
        }

        public ProductQuery description(DescriptionArgumentsDefinition argsDef) {
            this.startField("description");
            DescriptionArguments args = new DescriptionArguments(this._queryBuilder);
            argsDef.define(args);
            DescriptionArguments.end(args);
            return this;
        }

        public ProductQuery descriptionHtml() {
            this.startField("descriptionHtml");
            return this;
        }

        public ProductQuery featuredImage(ImageQueryDefinition queryDef) {
            this.startField("featuredImage");
            this._queryBuilder.append('{');
            queryDef.define(new ImageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductQuery handle() {
            this.startField("handle");
            return this;
        }

        public ProductQuery images(ImageConnectionQueryDefinition queryDef) {
            return this.images(args -> {}, queryDef);
        }

        public ProductQuery images(ImagesArgumentsDefinition argsDef, ImageConnectionQueryDefinition queryDef) {
            this.startField("images");
            ImagesArguments args = new ImagesArguments(this._queryBuilder);
            argsDef.define(args);
            ImagesArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new ImageConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductQuery isGiftCard() {
            this.startField("isGiftCard");
            return this;
        }

        public ProductQuery media(MediaConnectionQueryDefinition queryDef) {
            return this.media(args -> {}, queryDef);
        }

        public ProductQuery media(MediaArgumentsDefinition argsDef, MediaConnectionQueryDefinition queryDef) {
            this.startField("media");
            MediaArguments args = new MediaArguments(this._queryBuilder);
            argsDef.define(args);
            MediaArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new MediaConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductQuery metafield(String key, MetafieldQueryDefinition queryDef) {
            return this.metafield(key, args -> {}, queryDef);
        }

        public ProductQuery metafield(String key, MetafieldArgumentsDefinition argsDef, MetafieldQueryDefinition queryDef) {
            this.startField("metafield");
            this._queryBuilder.append("(key:");
            Query.appendQuotedString(this._queryBuilder, key.toString());
            argsDef.define(new MetafieldArguments(this._queryBuilder));
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductQuery metafields(List<HasMetafieldsIdentifier> identifiers, MetafieldQueryDefinition queryDef) {
            this.startField("metafields");
            this._queryBuilder.append("(identifiers:");
            this._queryBuilder.append('[');
            String listSeperator1 = "";
            for (HasMetafieldsIdentifier item1 : identifiers) {
                this._queryBuilder.append(listSeperator1);
                listSeperator1 = ",";
                item1.appendTo(this._queryBuilder);
            }
            this._queryBuilder.append(']');
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductQuery onlineStoreUrl() {
            this.startField("onlineStoreUrl");
            return this;
        }

        public ProductQuery options(ProductOptionQueryDefinition queryDef) {
            return this.options(args -> {}, queryDef);
        }

        public ProductQuery options(OptionsArgumentsDefinition argsDef, ProductOptionQueryDefinition queryDef) {
            this.startField("options");
            OptionsArguments args = new OptionsArguments(this._queryBuilder);
            argsDef.define(args);
            OptionsArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new ProductOptionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductQuery priceRange(ProductPriceRangeQueryDefinition queryDef) {
            this.startField("priceRange");
            this._queryBuilder.append('{');
            queryDef.define(new ProductPriceRangeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductQuery productType() {
            this.startField("productType");
            return this;
        }

        public ProductQuery publishedAt() {
            this.startField("publishedAt");
            return this;
        }

        public ProductQuery requiresSellingPlan() {
            this.startField("requiresSellingPlan");
            return this;
        }

        public ProductQuery sellingPlanGroups(SellingPlanGroupConnectionQueryDefinition queryDef) {
            return this.sellingPlanGroups(args -> {}, queryDef);
        }

        public ProductQuery sellingPlanGroups(SellingPlanGroupsArgumentsDefinition argsDef, SellingPlanGroupConnectionQueryDefinition queryDef) {
            this.startField("sellingPlanGroups");
            SellingPlanGroupsArguments args = new SellingPlanGroupsArguments(this._queryBuilder);
            argsDef.define(args);
            SellingPlanGroupsArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new SellingPlanGroupConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductQuery seo(SEOQueryDefinition queryDef) {
            this.startField("seo");
            this._queryBuilder.append('{');
            queryDef.define(new SEOQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductQuery tags() {
            this.startField("tags");
            return this;
        }

        public ProductQuery title() {
            this.startField("title");
            return this;
        }

        public ProductQuery totalInventory() {
            this.startField("totalInventory");
            return this;
        }

        public ProductQuery trackingParameters() {
            this.startField("trackingParameters");
            return this;
        }

        public ProductQuery updatedAt() {
            this.startField("updatedAt");
            return this;
        }

        public ProductQuery variantBySelectedOptions(List<SelectedOptionInput> selectedOptions, ProductVariantQueryDefinition queryDef) {
            return this.variantBySelectedOptions(selectedOptions, args -> {}, queryDef);
        }

        public ProductQuery variantBySelectedOptions(List<SelectedOptionInput> selectedOptions, VariantBySelectedOptionsArgumentsDefinition argsDef, ProductVariantQueryDefinition queryDef) {
            this.startField("variantBySelectedOptions");
            this._queryBuilder.append("(selectedOptions:");
            this._queryBuilder.append('[');
            String listSeperator1 = "";
            for (SelectedOptionInput item1 : selectedOptions) {
                this._queryBuilder.append(listSeperator1);
                listSeperator1 = ",";
                item1.appendTo(this._queryBuilder);
            }
            this._queryBuilder.append(']');
            argsDef.define(new VariantBySelectedOptionsArguments(this._queryBuilder));
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new ProductVariantQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductQuery variants(ProductVariantConnectionQueryDefinition queryDef) {
            return this.variants(args -> {}, queryDef);
        }

        public ProductQuery variants(VariantsArgumentsDefinition argsDef, ProductVariantConnectionQueryDefinition queryDef) {
            this.startField("variants");
            VariantsArguments args = new VariantsArguments(this._queryBuilder);
            argsDef.define(args);
            VariantsArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new ProductVariantConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public ProductQuery vendor() {
            this.startField("vendor");
            return this;
        }

        public static interface VariantsArgumentsDefinition {
            public void define(VariantsArguments var1);
        }

        public class VariantsArguments
        extends Arguments {
            VariantsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public VariantsArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public VariantsArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(ProductQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public VariantsArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public VariantsArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(ProductQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public VariantsArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public VariantsArguments sortKey(ProductVariantSortKeys value) {
                if (value != null) {
                    this.startArgument("sortKey");
                    ProductQuery.this._queryBuilder.append(value.toString());
                }
                return this;
            }
        }

        public static interface VariantBySelectedOptionsArgumentsDefinition {
            public void define(VariantBySelectedOptionsArguments var1);
        }

        public class VariantBySelectedOptionsArguments
        extends Arguments {
            VariantBySelectedOptionsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            public VariantBySelectedOptionsArguments ignoreUnknownOptions(Boolean value) {
                if (value != null) {
                    this.startArgument("ignoreUnknownOptions");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public VariantBySelectedOptionsArguments caseInsensitiveMatch(Boolean value) {
                if (value != null) {
                    this.startArgument("caseInsensitiveMatch");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }
        }

        public static interface SellingPlanGroupsArgumentsDefinition {
            public void define(SellingPlanGroupsArguments var1);
        }

        public class SellingPlanGroupsArguments
        extends Arguments {
            SellingPlanGroupsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public SellingPlanGroupsArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public SellingPlanGroupsArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(ProductQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public SellingPlanGroupsArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public SellingPlanGroupsArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(ProductQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public SellingPlanGroupsArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }
        }

        public static interface OptionsArgumentsDefinition {
            public void define(OptionsArguments var1);
        }

        public class OptionsArguments
        extends Arguments {
            OptionsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public OptionsArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }
        }

        public static interface MetafieldArgumentsDefinition {
            public void define(MetafieldArguments var1);
        }

        public class MetafieldArguments
        extends Arguments {
            MetafieldArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            public MetafieldArguments namespace(String value) {
                if (value != null) {
                    this.startArgument("namespace");
                    Query.appendQuotedString(ProductQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }

        public static interface MediaArgumentsDefinition {
            public void define(MediaArguments var1);
        }

        public class MediaArguments
        extends Arguments {
            MediaArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public MediaArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public MediaArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(ProductQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public MediaArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public MediaArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(ProductQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public MediaArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public MediaArguments sortKey(ProductMediaSortKeys value) {
                if (value != null) {
                    this.startArgument("sortKey");
                    ProductQuery.this._queryBuilder.append(value.toString());
                }
                return this;
            }
        }

        public static interface ImagesArgumentsDefinition {
            public void define(ImagesArguments var1);
        }

        public class ImagesArguments
        extends Arguments {
            ImagesArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public ImagesArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public ImagesArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(ProductQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public ImagesArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public ImagesArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(ProductQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public ImagesArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public ImagesArguments sortKey(ProductImageSortKeys value) {
                if (value != null) {
                    this.startArgument("sortKey");
                    ProductQuery.this._queryBuilder.append(value.toString());
                }
                return this;
            }
        }

        public static interface DescriptionArgumentsDefinition {
            public void define(DescriptionArguments var1);
        }

        public class DescriptionArguments
        extends Arguments {
            DescriptionArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public DescriptionArguments truncateAt(Integer value) {
                if (value != null) {
                    this.startArgument("truncateAt");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }
        }

        public static interface CollectionsArgumentsDefinition {
            public void define(CollectionsArguments var1);
        }

        public class CollectionsArguments
        extends Arguments {
            CollectionsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public CollectionsArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public CollectionsArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(ProductQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public CollectionsArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public CollectionsArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(ProductQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public CollectionsArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    ProductQuery.this._queryBuilder.append(value);
                }
                return this;
            }
        }
    }

    public static interface ProductQueryDefinition {
        public void define(ProductQuery var1);
    }

    public static class UnknownPricingValue
    extends AbstractResponse<UnknownPricingValue>
    implements PricingValue {
        public UnknownPricingValue() {
        }

        public UnknownPricingValue(JsonObject fields) throws SchemaViolationError {
            block6: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block6;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public static PricingValue create(JsonObject fields) throws SchemaViolationError {
            String typeName;
            switch (typeName = fields.getAsJsonPrimitive("__typename").getAsString()) {
                case "MoneyV2": {
                    return new MoneyV2(fields);
                }
                case "PricingPercentageValue": {
                    return new PricingPercentageValue(fields);
                }
            }
            return new UnknownPricingValue(fields);
        }

        @Override
        public String getGraphQlTypeName() {
            return (String)this.get("__typename");
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                default: 
            }
            return false;
        }
    }

    public static interface PricingValue {
        public String getGraphQlTypeName();
    }

    public static class PricingValueQuery
    extends Query<PricingValueQuery> {
        PricingValueQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("__typename");
        }

        public PricingValueQuery onMoneyV2(MoneyV2QueryDefinition queryDef) {
            this.startInlineFragment("MoneyV2");
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public PricingValueQuery onPricingPercentageValue(PricingPercentageValueQueryDefinition queryDef) {
            this.startInlineFragment("PricingPercentageValue");
            queryDef.define(new PricingPercentageValueQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface PricingValueQueryDefinition {
        public void define(PricingValueQuery var1);
    }

    public static class PricingPercentageValue
    extends AbstractResponse<PricingPercentageValue>
    implements PricingValue {
        public PricingPercentageValue() {
        }

        public PricingPercentageValue(JsonObject fields) throws SchemaViolationError {
            block8: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "percentage": {
                        this.responseData.put(key, this.jsonAsDouble((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "PricingPercentageValue";
        }

        public Double getPercentage() {
            return (Double)this.get("percentage");
        }

        public PricingPercentageValue setPercentage(Double arg) {
            this.optimisticData.put(this.getKey("percentage"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "percentage": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class PricingPercentageValueQuery
    extends Query<PricingPercentageValueQuery> {
        PricingPercentageValueQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public PricingPercentageValueQuery percentage() {
            this.startField("percentage");
            return this;
        }
    }

    public static interface PricingPercentageValueQueryDefinition {
        public void define(PricingPercentageValueQuery var1);
    }

    public static class PriceRangeFilter
    implements Serializable {
        private Input<Double> min = Input.undefined();
        private Input<Double> max = Input.undefined();

        public Double getMin() {
            return this.min.getValue();
        }

        public Input<Double> getMinInput() {
            return this.min;
        }

        public PriceRangeFilter setMin(Double min) {
            this.min = Input.optional(min);
            return this;
        }

        public PriceRangeFilter setMinInput(Input<Double> min) {
            if (min == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.min = min;
            return this;
        }

        public Double getMax() {
            return this.max.getValue();
        }

        public Input<Double> getMaxInput() {
            return this.max;
        }

        public PriceRangeFilter setMax(Double max) {
            this.max = Input.optional(max);
            return this;
        }

        public PriceRangeFilter setMaxInput(Input<Double> max) {
            if (max == null) {
                throw new IllegalArgumentException("Input can not be null");
            }
            this.max = max;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');
            if (this.min.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("min:");
                if (this.min.getValue() != null) {
                    _queryBuilder.append(this.min.getValue());
                } else {
                    _queryBuilder.append("null");
                }
            }
            if (this.max.isDefined()) {
                _queryBuilder.append(separator);
                separator = ",";
                _queryBuilder.append("max:");
                if (this.max.getValue() != null) {
                    _queryBuilder.append(this.max.getValue());
                } else {
                    _queryBuilder.append("null");
                }
            }
            _queryBuilder.append('}');
        }
    }

    public static enum PreferenceDeliveryMethodType {
        PICKUP_POINT,
        PICK_UP,
        SHIPPING,
        UNKNOWN_VALUE;


        public static PreferenceDeliveryMethodType fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "PICKUP_POINT": {
                    return PICKUP_POINT;
                }
                case "PICK_UP": {
                    return PICK_UP;
                }
                case "SHIPPING": {
                    return SHIPPING;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case PICKUP_POINT: {
                    return "PICKUP_POINT";
                }
                case PICK_UP: {
                    return "PICK_UP";
                }
                case SHIPPING: {
                    return "SHIPPING";
                }
            }
            return "";
        }
    }

    public static enum PredictiveSearchType {
        ARTICLE,
        COLLECTION,
        PAGE,
        PRODUCT,
        QUERY,
        UNKNOWN_VALUE;


        public static PredictiveSearchType fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "ARTICLE": {
                    return ARTICLE;
                }
                case "COLLECTION": {
                    return COLLECTION;
                }
                case "PAGE": {
                    return PAGE;
                }
                case "PRODUCT": {
                    return PRODUCT;
                }
                case "QUERY": {
                    return QUERY;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case ARTICLE: {
                    return "ARTICLE";
                }
                case COLLECTION: {
                    return "COLLECTION";
                }
                case PAGE: {
                    return "PAGE";
                }
                case PRODUCT: {
                    return "PRODUCT";
                }
                case QUERY: {
                    return "QUERY";
                }
            }
            return "";
        }
    }

    public static class PredictiveSearchResult
    extends AbstractResponse<PredictiveSearchResult> {
        public PredictiveSearchResult() {
        }

        public PredictiveSearchResult(JsonObject fields) throws SchemaViolationError {
            block16: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "articles": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new Article(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block16;
                    }
                    case "collections": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new Collection(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block16;
                    }
                    case "pages": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new Page(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block16;
                    }
                    case "products": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new Product(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block16;
                    }
                    case "queries": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new SearchQuerySuggestion(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block16;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "PredictiveSearchResult";
        }

        public List<Article> getArticles() {
            return (List)this.get("articles");
        }

        public PredictiveSearchResult setArticles(List<Article> arg) {
            this.optimisticData.put(this.getKey("articles"), arg);
            return this;
        }

        public List<Collection> getCollections() {
            return (List)this.get("collections");
        }

        public PredictiveSearchResult setCollections(List<Collection> arg) {
            this.optimisticData.put(this.getKey("collections"), arg);
            return this;
        }

        public List<Page> getPages() {
            return (List)this.get("pages");
        }

        public PredictiveSearchResult setPages(List<Page> arg) {
            this.optimisticData.put(this.getKey("pages"), arg);
            return this;
        }

        public List<Product> getProducts() {
            return (List)this.get("products");
        }

        public PredictiveSearchResult setProducts(List<Product> arg) {
            this.optimisticData.put(this.getKey("products"), arg);
            return this;
        }

        public List<SearchQuerySuggestion> getQueries() {
            return (List)this.get("queries");
        }

        public PredictiveSearchResult setQueries(List<SearchQuerySuggestion> arg) {
            this.optimisticData.put(this.getKey("queries"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "articles": {
                    return true;
                }
                case "collections": {
                    return true;
                }
                case "pages": {
                    return true;
                }
                case "products": {
                    return true;
                }
                case "queries": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class PredictiveSearchResultQuery
    extends Query<PredictiveSearchResultQuery> {
        PredictiveSearchResultQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public PredictiveSearchResultQuery articles(ArticleQueryDefinition queryDef) {
            this.startField("articles");
            this._queryBuilder.append('{');
            queryDef.define(new ArticleQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public PredictiveSearchResultQuery collections(CollectionQueryDefinition queryDef) {
            this.startField("collections");
            this._queryBuilder.append('{');
            queryDef.define(new CollectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public PredictiveSearchResultQuery pages(PageQueryDefinition queryDef) {
            this.startField("pages");
            this._queryBuilder.append('{');
            queryDef.define(new PageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public PredictiveSearchResultQuery products(ProductQueryDefinition queryDef) {
            this.startField("products");
            this._queryBuilder.append('{');
            queryDef.define(new ProductQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public PredictiveSearchResultQuery queries(SearchQuerySuggestionQueryDefinition queryDef) {
            this.startField("queries");
            this._queryBuilder.append('{');
            queryDef.define(new SearchQuerySuggestionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface PredictiveSearchResultQueryDefinition {
        public void define(PredictiveSearchResultQuery var1);
    }

    public static enum PredictiveSearchLimitScope {
        ALL,
        EACH,
        UNKNOWN_VALUE;


        public static PredictiveSearchLimitScope fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "ALL": {
                    return ALL;
                }
                case "EACH": {
                    return EACH;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case ALL: {
                    return "ALL";
                }
                case EACH: {
                    return "EACH";
                }
            }
            return "";
        }
    }

    public static class PaymentSettings
    extends AbstractResponse<PaymentSettings> {
        public PaymentSettings() {
        }

        public PaymentSettings(JsonObject fields) throws SchemaViolationError {
            block20: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "acceptedCardBrands": {
                        ArrayList<Enum> list1 = new ArrayList<Enum>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(CardBrand.fromGraphQl(this.jsonAsString(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block20;
                    }
                    case "cardVaultUrl": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block20;
                    }
                    case "countryCode": {
                        this.responseData.put(key, CountryCode.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block20;
                    }
                    case "currencyCode": {
                        this.responseData.put(key, CurrencyCode.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block20;
                    }
                    case "enabledPresentmentCurrencies": {
                        ArrayList<Enum> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(CurrencyCode.fromGraphQl(this.jsonAsString(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block20;
                    }
                    case "shopifyPaymentsAccountId": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block20;
                    }
                    case "supportedDigitalWallets": {
                        ArrayList<Enum> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(DigitalWallet.fromGraphQl(this.jsonAsString(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block20;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block20;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "PaymentSettings";
        }

        public List<CardBrand> getAcceptedCardBrands() {
            return (List)this.get("acceptedCardBrands");
        }

        public PaymentSettings setAcceptedCardBrands(List<CardBrand> arg) {
            this.optimisticData.put(this.getKey("acceptedCardBrands"), arg);
            return this;
        }

        public String getCardVaultUrl() {
            return (String)this.get("cardVaultUrl");
        }

        public PaymentSettings setCardVaultUrl(String arg) {
            this.optimisticData.put(this.getKey("cardVaultUrl"), arg);
            return this;
        }

        public CountryCode getCountryCode() {
            return (CountryCode)((Object)this.get("countryCode"));
        }

        public PaymentSettings setCountryCode(CountryCode arg) {
            this.optimisticData.put(this.getKey("countryCode"), arg);
            return this;
        }

        public CurrencyCode getCurrencyCode() {
            return (CurrencyCode)((Object)this.get("currencyCode"));
        }

        public PaymentSettings setCurrencyCode(CurrencyCode arg) {
            this.optimisticData.put(this.getKey("currencyCode"), arg);
            return this;
        }

        public List<CurrencyCode> getEnabledPresentmentCurrencies() {
            return (List)this.get("enabledPresentmentCurrencies");
        }

        public PaymentSettings setEnabledPresentmentCurrencies(List<CurrencyCode> arg) {
            this.optimisticData.put(this.getKey("enabledPresentmentCurrencies"), arg);
            return this;
        }

        public String getShopifyPaymentsAccountId() {
            return (String)this.get("shopifyPaymentsAccountId");
        }

        public PaymentSettings setShopifyPaymentsAccountId(String arg) {
            this.optimisticData.put(this.getKey("shopifyPaymentsAccountId"), arg);
            return this;
        }

        public List<DigitalWallet> getSupportedDigitalWallets() {
            return (List)this.get("supportedDigitalWallets");
        }

        public PaymentSettings setSupportedDigitalWallets(List<DigitalWallet> arg) {
            this.optimisticData.put(this.getKey("supportedDigitalWallets"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "acceptedCardBrands": {
                    return false;
                }
                case "cardVaultUrl": {
                    return false;
                }
                case "countryCode": {
                    return false;
                }
                case "currencyCode": {
                    return false;
                }
                case "enabledPresentmentCurrencies": {
                    return false;
                }
                case "shopifyPaymentsAccountId": {
                    return false;
                }
                case "supportedDigitalWallets": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class PaymentSettingsQuery
    extends Query<PaymentSettingsQuery> {
        PaymentSettingsQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public PaymentSettingsQuery acceptedCardBrands() {
            this.startField("acceptedCardBrands");
            return this;
        }

        public PaymentSettingsQuery cardVaultUrl() {
            this.startField("cardVaultUrl");
            return this;
        }

        public PaymentSettingsQuery countryCode() {
            this.startField("countryCode");
            return this;
        }

        public PaymentSettingsQuery currencyCode() {
            this.startField("currencyCode");
            return this;
        }

        public PaymentSettingsQuery enabledPresentmentCurrencies() {
            this.startField("enabledPresentmentCurrencies");
            return this;
        }

        public PaymentSettingsQuery shopifyPaymentsAccountId() {
            this.startField("shopifyPaymentsAccountId");
            return this;
        }

        public PaymentSettingsQuery supportedDigitalWallets() {
            this.startField("supportedDigitalWallets");
            return this;
        }
    }

    public static interface PaymentSettingsQueryDefinition {
        public void define(PaymentSettingsQuery var1);
    }

    public static enum PageSortKeys {
        ID,
        RELEVANCE,
        TITLE,
        UPDATED_AT,
        UNKNOWN_VALUE;


        public static PageSortKeys fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "ID": {
                    return ID;
                }
                case "RELEVANCE": {
                    return RELEVANCE;
                }
                case "TITLE": {
                    return TITLE;
                }
                case "UPDATED_AT": {
                    return UPDATED_AT;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case ID: {
                    return "ID";
                }
                case RELEVANCE: {
                    return "RELEVANCE";
                }
                case TITLE: {
                    return "TITLE";
                }
                case UPDATED_AT: {
                    return "UPDATED_AT";
                }
            }
            return "";
        }
    }

    public static class PageInfo
    extends AbstractResponse<PageInfo> {
        public PageInfo() {
        }

        public PageInfo(JsonObject fields) throws SchemaViolationError {
            block14: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "endCursor": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block14;
                    }
                    case "hasNextPage": {
                        this.responseData.put(key, this.jsonAsBoolean((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "hasPreviousPage": {
                        this.responseData.put(key, this.jsonAsBoolean((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "startCursor": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block14;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "PageInfo";
        }

        public String getEndCursor() {
            return (String)this.get("endCursor");
        }

        public PageInfo setEndCursor(String arg) {
            this.optimisticData.put(this.getKey("endCursor"), arg);
            return this;
        }

        public Boolean getHasNextPage() {
            return (Boolean)this.get("hasNextPage");
        }

        public PageInfo setHasNextPage(Boolean arg) {
            this.optimisticData.put(this.getKey("hasNextPage"), arg);
            return this;
        }

        public Boolean getHasPreviousPage() {
            return (Boolean)this.get("hasPreviousPage");
        }

        public PageInfo setHasPreviousPage(Boolean arg) {
            this.optimisticData.put(this.getKey("hasPreviousPage"), arg);
            return this;
        }

        public String getStartCursor() {
            return (String)this.get("startCursor");
        }

        public PageInfo setStartCursor(String arg) {
            this.optimisticData.put(this.getKey("startCursor"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "endCursor": {
                    return false;
                }
                case "hasNextPage": {
                    return false;
                }
                case "hasPreviousPage": {
                    return false;
                }
                case "startCursor": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class PageInfoQuery
    extends Query<PageInfoQuery> {
        PageInfoQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public PageInfoQuery endCursor() {
            this.startField("endCursor");
            return this;
        }

        public PageInfoQuery hasNextPage() {
            this.startField("hasNextPage");
            return this;
        }

        public PageInfoQuery hasPreviousPage() {
            this.startField("hasPreviousPage");
            return this;
        }

        public PageInfoQuery startCursor() {
            this.startField("startCursor");
            return this;
        }
    }

    public static interface PageInfoQueryDefinition {
        public void define(PageInfoQuery var1);
    }

    public static class PageEdge
    extends AbstractResponse<PageEdge> {
        public PageEdge() {
        }

        public PageEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, new Page(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "PageEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public PageEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public Page getNode() {
            return (Page)this.get("node");
        }

        public PageEdge setNode(Page arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class PageEdgeQuery
    extends Query<PageEdgeQuery> {
        PageEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public PageEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public PageEdgeQuery node(PageQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new PageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface PageEdgeQueryDefinition {
        public void define(PageEdgeQuery var1);
    }

    public static class PageConnection
    extends AbstractResponse<PageConnection> {
        public PageConnection() {
        }

        public PageConnection(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new PageEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "nodes": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new Page(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "PageConnection";
        }

        public List<PageEdge> getEdges() {
            return (List)this.get("edges");
        }

        public PageConnection setEdges(List<PageEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<Page> getNodes() {
            return (List)this.get("nodes");
        }

        public PageConnection setNodes(List<Page> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public PageConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "nodes": {
                    return true;
                }
                case "pageInfo": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class PageConnectionQuery
    extends Query<PageConnectionQuery> {
        PageConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public PageConnectionQuery edges(PageEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new PageEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public PageConnectionQuery nodes(PageQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new PageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public PageConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface PageConnectionQueryDefinition {
        public void define(PageConnectionQuery var1);
    }

    public static class Page
    extends AbstractResponse<Page>
    implements HasMetafields,
    MenuItemResource,
    MetafieldParentResource,
    MetafieldReference,
    Node,
    OnlineStorePublishable,
    SearchResultItem,
    Trackable {
        public Page() {
        }

        public Page(JsonObject fields) throws SchemaViolationError {
            block30: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "body": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block30;
                    }
                    case "bodySummary": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block30;
                    }
                    case "createdAt": {
                        this.responseData.put(key, Utils.parseDateTime(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block30;
                    }
                    case "handle": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block30;
                    }
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block30;
                    }
                    case "metafield": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Metafield(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block30;
                    }
                    case "metafields": {
                        ArrayList<Metafield> list1 = new ArrayList<Metafield>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            Metafield optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = new Metafield(this.jsonAsObject(element1, key));
                            }
                            list1.add(optional2);
                        }
                        this.responseData.put(key, list1);
                        continue block30;
                    }
                    case "onlineStoreUrl": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block30;
                    }
                    case "seo": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new SEO(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block30;
                    }
                    case "title": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block30;
                    }
                    case "trackingParameters": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block30;
                    }
                    case "updatedAt": {
                        this.responseData.put(key, Utils.parseDateTime(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block30;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block30;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public Page(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "Page";
        }

        public String getBody() {
            return (String)this.get("body");
        }

        public Page setBody(String arg) {
            this.optimisticData.put(this.getKey("body"), arg);
            return this;
        }

        public String getBodySummary() {
            return (String)this.get("bodySummary");
        }

        public Page setBodySummary(String arg) {
            this.optimisticData.put(this.getKey("bodySummary"), arg);
            return this;
        }

        public DateTime getCreatedAt() {
            return (DateTime)this.get("createdAt");
        }

        public Page setCreatedAt(DateTime arg) {
            this.optimisticData.put(this.getKey("createdAt"), arg);
            return this;
        }

        public String getHandle() {
            return (String)this.get("handle");
        }

        public Page setHandle(String arg) {
            this.optimisticData.put(this.getKey("handle"), arg);
            return this;
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        @Override
        public Metafield getMetafield() {
            return (Metafield)this.get("metafield");
        }

        public Page setMetafield(Metafield arg) {
            this.optimisticData.put(this.getKey("metafield"), arg);
            return this;
        }

        @Override
        public List<Metafield> getMetafields() {
            return (List)this.get("metafields");
        }

        public Page setMetafields(List<Metafield> arg) {
            this.optimisticData.put(this.getKey("metafields"), arg);
            return this;
        }

        @Override
        public String getOnlineStoreUrl() {
            return (String)this.get("onlineStoreUrl");
        }

        public Page setOnlineStoreUrl(String arg) {
            this.optimisticData.put(this.getKey("onlineStoreUrl"), arg);
            return this;
        }

        public SEO getSeo() {
            return (SEO)this.get("seo");
        }

        public Page setSeo(SEO arg) {
            this.optimisticData.put(this.getKey("seo"), arg);
            return this;
        }

        public String getTitle() {
            return (String)this.get("title");
        }

        public Page setTitle(String arg) {
            this.optimisticData.put(this.getKey("title"), arg);
            return this;
        }

        @Override
        public String getTrackingParameters() {
            return (String)this.get("trackingParameters");
        }

        public Page setTrackingParameters(String arg) {
            this.optimisticData.put(this.getKey("trackingParameters"), arg);
            return this;
        }

        public DateTime getUpdatedAt() {
            return (DateTime)this.get("updatedAt");
        }

        public Page setUpdatedAt(DateTime arg) {
            this.optimisticData.put(this.getKey("updatedAt"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "body": {
                    return false;
                }
                case "bodySummary": {
                    return false;
                }
                case "createdAt": {
                    return false;
                }
                case "handle": {
                    return false;
                }
                case "id": {
                    return false;
                }
                case "metafield": {
                    return true;
                }
                case "metafields": {
                    return true;
                }
                case "onlineStoreUrl": {
                    return false;
                }
                case "seo": {
                    return true;
                }
                case "title": {
                    return false;
                }
                case "trackingParameters": {
                    return false;
                }
                case "updatedAt": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class PageQuery
    extends Query<PageQuery> {
        PageQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public PageQuery body() {
            this.startField("body");
            return this;
        }

        public PageQuery bodySummary() {
            this.startField("bodySummary");
            return this;
        }

        public PageQuery createdAt() {
            this.startField("createdAt");
            return this;
        }

        public PageQuery handle() {
            this.startField("handle");
            return this;
        }

        public PageQuery metafield(String key, MetafieldQueryDefinition queryDef) {
            return this.metafield(key, args -> {}, queryDef);
        }

        public PageQuery metafield(String key, MetafieldArgumentsDefinition argsDef, MetafieldQueryDefinition queryDef) {
            this.startField("metafield");
            this._queryBuilder.append("(key:");
            Query.appendQuotedString(this._queryBuilder, key.toString());
            argsDef.define(new MetafieldArguments(this._queryBuilder));
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public PageQuery metafields(List<HasMetafieldsIdentifier> identifiers, MetafieldQueryDefinition queryDef) {
            this.startField("metafields");
            this._queryBuilder.append("(identifiers:");
            this._queryBuilder.append('[');
            String listSeperator1 = "";
            for (HasMetafieldsIdentifier item1 : identifiers) {
                this._queryBuilder.append(listSeperator1);
                listSeperator1 = ",";
                item1.appendTo(this._queryBuilder);
            }
            this._queryBuilder.append(']');
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public PageQuery onlineStoreUrl() {
            this.startField("onlineStoreUrl");
            return this;
        }

        public PageQuery seo(SEOQueryDefinition queryDef) {
            this.startField("seo");
            this._queryBuilder.append('{');
            queryDef.define(new SEOQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public PageQuery title() {
            this.startField("title");
            return this;
        }

        public PageQuery trackingParameters() {
            this.startField("trackingParameters");
            return this;
        }

        public PageQuery updatedAt() {
            this.startField("updatedAt");
            return this;
        }

        public static interface MetafieldArgumentsDefinition {
            public void define(MetafieldArguments var1);
        }

        public class MetafieldArguments
        extends Arguments {
            MetafieldArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            public MetafieldArguments namespace(String value) {
                if (value != null) {
                    this.startArgument("namespace");
                    Query.appendQuotedString(PageQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }
    }

    public static interface PageQueryDefinition {
        public void define(PageQuery var1);
    }

    public static enum OrderSortKeys {
        ID,
        PROCESSED_AT,
        RELEVANCE,
        TOTAL_PRICE,
        UNKNOWN_VALUE;


        public static OrderSortKeys fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "ID": {
                    return ID;
                }
                case "PROCESSED_AT": {
                    return PROCESSED_AT;
                }
                case "RELEVANCE": {
                    return RELEVANCE;
                }
                case "TOTAL_PRICE": {
                    return TOTAL_PRICE;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case ID: {
                    return "ID";
                }
                case PROCESSED_AT: {
                    return "PROCESSED_AT";
                }
                case RELEVANCE: {
                    return "RELEVANCE";
                }
                case TOTAL_PRICE: {
                    return "TOTAL_PRICE";
                }
            }
            return "";
        }
    }

    public static class OrderLineItemEdge
    extends AbstractResponse<OrderLineItemEdge> {
        public OrderLineItemEdge() {
        }

        public OrderLineItemEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, new OrderLineItem(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "OrderLineItemEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public OrderLineItemEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public OrderLineItem getNode() {
            return (OrderLineItem)this.get("node");
        }

        public OrderLineItemEdge setNode(OrderLineItem arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class OrderLineItemEdgeQuery
    extends Query<OrderLineItemEdgeQuery> {
        OrderLineItemEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public OrderLineItemEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public OrderLineItemEdgeQuery node(OrderLineItemQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new OrderLineItemQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface OrderLineItemEdgeQueryDefinition {
        public void define(OrderLineItemEdgeQuery var1);
    }

    public static class OrderLineItemConnection
    extends AbstractResponse<OrderLineItemConnection> {
        public OrderLineItemConnection() {
        }

        public OrderLineItemConnection(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new OrderLineItemEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "nodes": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new OrderLineItem(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "OrderLineItemConnection";
        }

        public List<OrderLineItemEdge> getEdges() {
            return (List)this.get("edges");
        }

        public OrderLineItemConnection setEdges(List<OrderLineItemEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<OrderLineItem> getNodes() {
            return (List)this.get("nodes");
        }

        public OrderLineItemConnection setNodes(List<OrderLineItem> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public OrderLineItemConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "nodes": {
                    return true;
                }
                case "pageInfo": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class OrderLineItemConnectionQuery
    extends Query<OrderLineItemConnectionQuery> {
        OrderLineItemConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public OrderLineItemConnectionQuery edges(OrderLineItemEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new OrderLineItemEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderLineItemConnectionQuery nodes(OrderLineItemQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new OrderLineItemQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderLineItemConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface OrderLineItemConnectionQueryDefinition {
        public void define(OrderLineItemConnectionQuery var1);
    }

    public static class OrderLineItem
    extends AbstractResponse<OrderLineItem> {
        public OrderLineItem() {
        }

        public OrderLineItem(JsonObject fields) throws SchemaViolationError {
            block22: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "currentQuantity": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block22;
                    }
                    case "customAttributes": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new Attribute(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block22;
                    }
                    case "discountAllocations": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new DiscountAllocation(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block22;
                    }
                    case "discountedTotalPrice": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block22;
                    }
                    case "originalTotalPrice": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block22;
                    }
                    case "quantity": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block22;
                    }
                    case "title": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block22;
                    }
                    case "variant": {
                        ProductVariant optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ProductVariant(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block22;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block22;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "OrderLineItem";
        }

        public Integer getCurrentQuantity() {
            return (Integer)this.get("currentQuantity");
        }

        public OrderLineItem setCurrentQuantity(Integer arg) {
            this.optimisticData.put(this.getKey("currentQuantity"), arg);
            return this;
        }

        public List<Attribute> getCustomAttributes() {
            return (List)this.get("customAttributes");
        }

        public OrderLineItem setCustomAttributes(List<Attribute> arg) {
            this.optimisticData.put(this.getKey("customAttributes"), arg);
            return this;
        }

        public List<DiscountAllocation> getDiscountAllocations() {
            return (List)this.get("discountAllocations");
        }

        public OrderLineItem setDiscountAllocations(List<DiscountAllocation> arg) {
            this.optimisticData.put(this.getKey("discountAllocations"), arg);
            return this;
        }

        public MoneyV2 getDiscountedTotalPrice() {
            return (MoneyV2)this.get("discountedTotalPrice");
        }

        public OrderLineItem setDiscountedTotalPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("discountedTotalPrice"), arg);
            return this;
        }

        public MoneyV2 getOriginalTotalPrice() {
            return (MoneyV2)this.get("originalTotalPrice");
        }

        public OrderLineItem setOriginalTotalPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("originalTotalPrice"), arg);
            return this;
        }

        public Integer getQuantity() {
            return (Integer)this.get("quantity");
        }

        public OrderLineItem setQuantity(Integer arg) {
            this.optimisticData.put(this.getKey("quantity"), arg);
            return this;
        }

        public String getTitle() {
            return (String)this.get("title");
        }

        public OrderLineItem setTitle(String arg) {
            this.optimisticData.put(this.getKey("title"), arg);
            return this;
        }

        public ProductVariant getVariant() {
            return (ProductVariant)this.get("variant");
        }

        public OrderLineItem setVariant(ProductVariant arg) {
            this.optimisticData.put(this.getKey("variant"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "currentQuantity": {
                    return false;
                }
                case "customAttributes": {
                    return true;
                }
                case "discountAllocations": {
                    return true;
                }
                case "discountedTotalPrice": {
                    return true;
                }
                case "originalTotalPrice": {
                    return true;
                }
                case "quantity": {
                    return false;
                }
                case "title": {
                    return false;
                }
                case "variant": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class OrderLineItemQuery
    extends Query<OrderLineItemQuery> {
        OrderLineItemQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public OrderLineItemQuery currentQuantity() {
            this.startField("currentQuantity");
            return this;
        }

        public OrderLineItemQuery customAttributes(AttributeQueryDefinition queryDef) {
            this.startField("customAttributes");
            this._queryBuilder.append('{');
            queryDef.define(new AttributeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderLineItemQuery discountAllocations(DiscountAllocationQueryDefinition queryDef) {
            this.startField("discountAllocations");
            this._queryBuilder.append('{');
            queryDef.define(new DiscountAllocationQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderLineItemQuery discountedTotalPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("discountedTotalPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderLineItemQuery originalTotalPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("originalTotalPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderLineItemQuery quantity() {
            this.startField("quantity");
            return this;
        }

        public OrderLineItemQuery title() {
            this.startField("title");
            return this;
        }

        public OrderLineItemQuery variant(ProductVariantQueryDefinition queryDef) {
            this.startField("variant");
            this._queryBuilder.append('{');
            queryDef.define(new ProductVariantQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface OrderLineItemQueryDefinition {
        public void define(OrderLineItemQuery var1);
    }

    public static enum OrderFulfillmentStatus {
        FULFILLED,
        IN_PROGRESS,
        ON_HOLD,
        OPEN,
        PARTIALLY_FULFILLED,
        PENDING_FULFILLMENT,
        RESTOCKED,
        SCHEDULED,
        UNFULFILLED,
        UNKNOWN_VALUE;


        public static OrderFulfillmentStatus fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "FULFILLED": {
                    return FULFILLED;
                }
                case "IN_PROGRESS": {
                    return IN_PROGRESS;
                }
                case "ON_HOLD": {
                    return ON_HOLD;
                }
                case "OPEN": {
                    return OPEN;
                }
                case "PARTIALLY_FULFILLED": {
                    return PARTIALLY_FULFILLED;
                }
                case "PENDING_FULFILLMENT": {
                    return PENDING_FULFILLMENT;
                }
                case "RESTOCKED": {
                    return RESTOCKED;
                }
                case "SCHEDULED": {
                    return SCHEDULED;
                }
                case "UNFULFILLED": {
                    return UNFULFILLED;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case FULFILLED: {
                    return "FULFILLED";
                }
                case IN_PROGRESS: {
                    return "IN_PROGRESS";
                }
                case ON_HOLD: {
                    return "ON_HOLD";
                }
                case OPEN: {
                    return "OPEN";
                }
                case PARTIALLY_FULFILLED: {
                    return "PARTIALLY_FULFILLED";
                }
                case PENDING_FULFILLMENT: {
                    return "PENDING_FULFILLMENT";
                }
                case RESTOCKED: {
                    return "RESTOCKED";
                }
                case SCHEDULED: {
                    return "SCHEDULED";
                }
                case UNFULFILLED: {
                    return "UNFULFILLED";
                }
            }
            return "";
        }
    }

    public static enum OrderFinancialStatus {
        AUTHORIZED,
        PAID,
        PARTIALLY_PAID,
        PARTIALLY_REFUNDED,
        PENDING,
        REFUNDED,
        VOIDED,
        UNKNOWN_VALUE;


        public static OrderFinancialStatus fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "AUTHORIZED": {
                    return AUTHORIZED;
                }
                case "PAID": {
                    return PAID;
                }
                case "PARTIALLY_PAID": {
                    return PARTIALLY_PAID;
                }
                case "PARTIALLY_REFUNDED": {
                    return PARTIALLY_REFUNDED;
                }
                case "PENDING": {
                    return PENDING;
                }
                case "REFUNDED": {
                    return REFUNDED;
                }
                case "VOIDED": {
                    return VOIDED;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case AUTHORIZED: {
                    return "AUTHORIZED";
                }
                case PAID: {
                    return "PAID";
                }
                case PARTIALLY_PAID: {
                    return "PARTIALLY_PAID";
                }
                case PARTIALLY_REFUNDED: {
                    return "PARTIALLY_REFUNDED";
                }
                case PENDING: {
                    return "PENDING";
                }
                case REFUNDED: {
                    return "REFUNDED";
                }
                case VOIDED: {
                    return "VOIDED";
                }
            }
            return "";
        }
    }

    public static class OrderEdge
    extends AbstractResponse<OrderEdge> {
        public OrderEdge() {
        }

        public OrderEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, new Order(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "OrderEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public OrderEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public Order getNode() {
            return (Order)this.get("node");
        }

        public OrderEdge setNode(Order arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class OrderEdgeQuery
    extends Query<OrderEdgeQuery> {
        OrderEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public OrderEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public OrderEdgeQuery node(OrderQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new OrderQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface OrderEdgeQueryDefinition {
        public void define(OrderEdgeQuery var1);
    }

    public static class OrderConnection
    extends AbstractResponse<OrderConnection> {
        public OrderConnection() {
        }

        public OrderConnection(JsonObject fields) throws SchemaViolationError {
            block14: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new OrderEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block14;
                    }
                    case "nodes": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new Order(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block14;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block14;
                    }
                    case "totalCount": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "OrderConnection";
        }

        public List<OrderEdge> getEdges() {
            return (List)this.get("edges");
        }

        public OrderConnection setEdges(List<OrderEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<Order> getNodes() {
            return (List)this.get("nodes");
        }

        public OrderConnection setNodes(List<Order> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public OrderConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        public String getTotalCount() {
            return (String)this.get("totalCount");
        }

        public OrderConnection setTotalCount(String arg) {
            this.optimisticData.put(this.getKey("totalCount"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "nodes": {
                    return true;
                }
                case "pageInfo": {
                    return true;
                }
                case "totalCount": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class OrderConnectionQuery
    extends Query<OrderConnectionQuery> {
        OrderConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public OrderConnectionQuery edges(OrderEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new OrderEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderConnectionQuery nodes(OrderQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new OrderQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderConnectionQuery totalCount() {
            this.startField("totalCount");
            return this;
        }
    }

    public static interface OrderConnectionQueryDefinition {
        public void define(OrderConnectionQuery var1);
    }

    public static enum OrderCancelReason {
        CUSTOMER,
        DECLINED,
        FRAUD,
        INVENTORY,
        OTHER,
        STAFF,
        UNKNOWN_VALUE;


        public static OrderCancelReason fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "CUSTOMER": {
                    return CUSTOMER;
                }
                case "DECLINED": {
                    return DECLINED;
                }
                case "FRAUD": {
                    return FRAUD;
                }
                case "INVENTORY": {
                    return INVENTORY;
                }
                case "OTHER": {
                    return OTHER;
                }
                case "STAFF": {
                    return STAFF;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case CUSTOMER: {
                    return "CUSTOMER";
                }
                case DECLINED: {
                    return "DECLINED";
                }
                case FRAUD: {
                    return "FRAUD";
                }
                case INVENTORY: {
                    return "INVENTORY";
                }
                case OTHER: {
                    return "OTHER";
                }
                case STAFF: {
                    return "STAFF";
                }
            }
            return "";
        }
    }

    public static class Order
    extends AbstractResponse<Order>
    implements HasMetafields,
    MetafieldParentResource,
    Node {
        public Order() {
        }

        public Order(JsonObject fields) throws SchemaViolationError {
            block88: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "billingAddress": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MailingAddress(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "cancelReason": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = OrderCancelReason.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "canceledAt": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = Utils.parseDateTime(this.jsonAsString((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "currencyCode": {
                        this.responseData.put(key, CurrencyCode.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "currentSubtotalPrice": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "currentTotalDuties": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "currentTotalPrice": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "currentTotalShippingPrice": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "currentTotalTax": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "customAttributes": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new Attribute(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block88;
                    }
                    case "customerLocale": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "customerUrl": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "discountApplications": {
                        this.responseData.put(key, new DiscountApplicationConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "edited": {
                        this.responseData.put(key, this.jsonAsBoolean((JsonElement)field.getValue(), key));
                        continue block88;
                    }
                    case "email": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "financialStatus": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = OrderFinancialStatus.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "fulfillmentStatus": {
                        this.responseData.put(key, OrderFulfillmentStatus.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "lineItems": {
                        this.responseData.put(key, new OrderLineItemConnection(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "metafield": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Metafield(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "metafields": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            Metafield optional2 = null;
                            if (!element1.isJsonNull()) {
                                optional2 = new Metafield(this.jsonAsObject(element1, key));
                            }
                            list1.add(optional2);
                        }
                        this.responseData.put(key, list1);
                        continue block88;
                    }
                    case "name": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block88;
                    }
                    case "orderNumber": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block88;
                    }
                    case "originalTotalDuties": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "originalTotalPrice": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "phone": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "processedAt": {
                        this.responseData.put(key, Utils.parseDateTime(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "shippingAddress": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MailingAddress(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "shippingDiscountAllocations": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new DiscountAllocation(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block88;
                    }
                    case "statusUrl": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block88;
                    }
                    case "subtotalPrice": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "subtotalPriceV2": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "successfulFulfillments": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            ArrayList<Fulfillment> list1 = new ArrayList<Fulfillment>();
                            for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                                list1.add(new Fulfillment(this.jsonAsObject(element1, key)));
                            }
                            optional1 = list1;
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "totalPrice": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "totalPriceV2": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "totalRefunded": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "totalRefundedV2": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "totalShippingPrice": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "totalShippingPriceV2": {
                        this.responseData.put(key, new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block88;
                    }
                    case "totalTax": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "totalTaxV2": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MoneyV2(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block88;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block88;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public Order(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "Order";
        }

        public MailingAddress getBillingAddress() {
            return (MailingAddress)this.get("billingAddress");
        }

        public Order setBillingAddress(MailingAddress arg) {
            this.optimisticData.put(this.getKey("billingAddress"), arg);
            return this;
        }

        public OrderCancelReason getCancelReason() {
            return (OrderCancelReason)((Object)this.get("cancelReason"));
        }

        public Order setCancelReason(OrderCancelReason arg) {
            this.optimisticData.put(this.getKey("cancelReason"), arg);
            return this;
        }

        public DateTime getCanceledAt() {
            return (DateTime)this.get("canceledAt");
        }

        public Order setCanceledAt(DateTime arg) {
            this.optimisticData.put(this.getKey("canceledAt"), arg);
            return this;
        }

        public CurrencyCode getCurrencyCode() {
            return (CurrencyCode)((Object)this.get("currencyCode"));
        }

        public Order setCurrencyCode(CurrencyCode arg) {
            this.optimisticData.put(this.getKey("currencyCode"), arg);
            return this;
        }

        public MoneyV2 getCurrentSubtotalPrice() {
            return (MoneyV2)this.get("currentSubtotalPrice");
        }

        public Order setCurrentSubtotalPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("currentSubtotalPrice"), arg);
            return this;
        }

        public MoneyV2 getCurrentTotalDuties() {
            return (MoneyV2)this.get("currentTotalDuties");
        }

        public Order setCurrentTotalDuties(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("currentTotalDuties"), arg);
            return this;
        }

        public MoneyV2 getCurrentTotalPrice() {
            return (MoneyV2)this.get("currentTotalPrice");
        }

        public Order setCurrentTotalPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("currentTotalPrice"), arg);
            return this;
        }

        public MoneyV2 getCurrentTotalShippingPrice() {
            return (MoneyV2)this.get("currentTotalShippingPrice");
        }

        public Order setCurrentTotalShippingPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("currentTotalShippingPrice"), arg);
            return this;
        }

        public MoneyV2 getCurrentTotalTax() {
            return (MoneyV2)this.get("currentTotalTax");
        }

        public Order setCurrentTotalTax(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("currentTotalTax"), arg);
            return this;
        }

        public List<Attribute> getCustomAttributes() {
            return (List)this.get("customAttributes");
        }

        public Order setCustomAttributes(List<Attribute> arg) {
            this.optimisticData.put(this.getKey("customAttributes"), arg);
            return this;
        }

        public String getCustomerLocale() {
            return (String)this.get("customerLocale");
        }

        public Order setCustomerLocale(String arg) {
            this.optimisticData.put(this.getKey("customerLocale"), arg);
            return this;
        }

        public String getCustomerUrl() {
            return (String)this.get("customerUrl");
        }

        public Order setCustomerUrl(String arg) {
            this.optimisticData.put(this.getKey("customerUrl"), arg);
            return this;
        }

        public DiscountApplicationConnection getDiscountApplications() {
            return (DiscountApplicationConnection)this.get("discountApplications");
        }

        public Order setDiscountApplications(DiscountApplicationConnection arg) {
            this.optimisticData.put(this.getKey("discountApplications"), arg);
            return this;
        }

        public Boolean getEdited() {
            return (Boolean)this.get("edited");
        }

        public Order setEdited(Boolean arg) {
            this.optimisticData.put(this.getKey("edited"), arg);
            return this;
        }

        public String getEmail() {
            return (String)this.get("email");
        }

        public Order setEmail(String arg) {
            this.optimisticData.put(this.getKey("email"), arg);
            return this;
        }

        public OrderFinancialStatus getFinancialStatus() {
            return (OrderFinancialStatus)((Object)this.get("financialStatus"));
        }

        public Order setFinancialStatus(OrderFinancialStatus arg) {
            this.optimisticData.put(this.getKey("financialStatus"), arg);
            return this;
        }

        public OrderFulfillmentStatus getFulfillmentStatus() {
            return (OrderFulfillmentStatus)((Object)this.get("fulfillmentStatus"));
        }

        public Order setFulfillmentStatus(OrderFulfillmentStatus arg) {
            this.optimisticData.put(this.getKey("fulfillmentStatus"), arg);
            return this;
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        public OrderLineItemConnection getLineItems() {
            return (OrderLineItemConnection)this.get("lineItems");
        }

        public Order setLineItems(OrderLineItemConnection arg) {
            this.optimisticData.put(this.getKey("lineItems"), arg);
            return this;
        }

        @Override
        public Metafield getMetafield() {
            return (Metafield)this.get("metafield");
        }

        public Order setMetafield(Metafield arg) {
            this.optimisticData.put(this.getKey("metafield"), arg);
            return this;
        }

        @Override
        public List<Metafield> getMetafields() {
            return (List)this.get("metafields");
        }

        public Order setMetafields(List<Metafield> arg) {
            this.optimisticData.put(this.getKey("metafields"), arg);
            return this;
        }

        public String getName() {
            return (String)this.get("name");
        }

        public Order setName(String arg) {
            this.optimisticData.put(this.getKey("name"), arg);
            return this;
        }

        public Integer getOrderNumber() {
            return (Integer)this.get("orderNumber");
        }

        public Order setOrderNumber(Integer arg) {
            this.optimisticData.put(this.getKey("orderNumber"), arg);
            return this;
        }

        public MoneyV2 getOriginalTotalDuties() {
            return (MoneyV2)this.get("originalTotalDuties");
        }

        public Order setOriginalTotalDuties(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("originalTotalDuties"), arg);
            return this;
        }

        public MoneyV2 getOriginalTotalPrice() {
            return (MoneyV2)this.get("originalTotalPrice");
        }

        public Order setOriginalTotalPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("originalTotalPrice"), arg);
            return this;
        }

        public String getPhone() {
            return (String)this.get("phone");
        }

        public Order setPhone(String arg) {
            this.optimisticData.put(this.getKey("phone"), arg);
            return this;
        }

        public DateTime getProcessedAt() {
            return (DateTime)this.get("processedAt");
        }

        public Order setProcessedAt(DateTime arg) {
            this.optimisticData.put(this.getKey("processedAt"), arg);
            return this;
        }

        public MailingAddress getShippingAddress() {
            return (MailingAddress)this.get("shippingAddress");
        }

        public Order setShippingAddress(MailingAddress arg) {
            this.optimisticData.put(this.getKey("shippingAddress"), arg);
            return this;
        }

        public List<DiscountAllocation> getShippingDiscountAllocations() {
            return (List)this.get("shippingDiscountAllocations");
        }

        public Order setShippingDiscountAllocations(List<DiscountAllocation> arg) {
            this.optimisticData.put(this.getKey("shippingDiscountAllocations"), arg);
            return this;
        }

        public String getStatusUrl() {
            return (String)this.get("statusUrl");
        }

        public Order setStatusUrl(String arg) {
            this.optimisticData.put(this.getKey("statusUrl"), arg);
            return this;
        }

        public MoneyV2 getSubtotalPrice() {
            return (MoneyV2)this.get("subtotalPrice");
        }

        public Order setSubtotalPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("subtotalPrice"), arg);
            return this;
        }

        public MoneyV2 getSubtotalPriceV2() {
            return (MoneyV2)this.get("subtotalPriceV2");
        }

        public Order setSubtotalPriceV2(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("subtotalPriceV2"), arg);
            return this;
        }

        public List<Fulfillment> getSuccessfulFulfillments() {
            return (List)this.get("successfulFulfillments");
        }

        public Order setSuccessfulFulfillments(List<Fulfillment> arg) {
            this.optimisticData.put(this.getKey("successfulFulfillments"), arg);
            return this;
        }

        public MoneyV2 getTotalPrice() {
            return (MoneyV2)this.get("totalPrice");
        }

        public Order setTotalPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("totalPrice"), arg);
            return this;
        }

        public MoneyV2 getTotalPriceV2() {
            return (MoneyV2)this.get("totalPriceV2");
        }

        public Order setTotalPriceV2(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("totalPriceV2"), arg);
            return this;
        }

        public MoneyV2 getTotalRefunded() {
            return (MoneyV2)this.get("totalRefunded");
        }

        public Order setTotalRefunded(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("totalRefunded"), arg);
            return this;
        }

        public MoneyV2 getTotalRefundedV2() {
            return (MoneyV2)this.get("totalRefundedV2");
        }

        public Order setTotalRefundedV2(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("totalRefundedV2"), arg);
            return this;
        }

        public MoneyV2 getTotalShippingPrice() {
            return (MoneyV2)this.get("totalShippingPrice");
        }

        public Order setTotalShippingPrice(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("totalShippingPrice"), arg);
            return this;
        }

        public MoneyV2 getTotalShippingPriceV2() {
            return (MoneyV2)this.get("totalShippingPriceV2");
        }

        public Order setTotalShippingPriceV2(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("totalShippingPriceV2"), arg);
            return this;
        }

        public MoneyV2 getTotalTax() {
            return (MoneyV2)this.get("totalTax");
        }

        public Order setTotalTax(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("totalTax"), arg);
            return this;
        }

        public MoneyV2 getTotalTaxV2() {
            return (MoneyV2)this.get("totalTaxV2");
        }

        public Order setTotalTaxV2(MoneyV2 arg) {
            this.optimisticData.put(this.getKey("totalTaxV2"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "billingAddress": {
                    return true;
                }
                case "cancelReason": {
                    return false;
                }
                case "canceledAt": {
                    return false;
                }
                case "currencyCode": {
                    return false;
                }
                case "currentSubtotalPrice": {
                    return true;
                }
                case "currentTotalDuties": {
                    return true;
                }
                case "currentTotalPrice": {
                    return true;
                }
                case "currentTotalShippingPrice": {
                    return true;
                }
                case "currentTotalTax": {
                    return true;
                }
                case "customAttributes": {
                    return true;
                }
                case "customerLocale": {
                    return false;
                }
                case "customerUrl": {
                    return false;
                }
                case "discountApplications": {
                    return true;
                }
                case "edited": {
                    return false;
                }
                case "email": {
                    return false;
                }
                case "financialStatus": {
                    return false;
                }
                case "fulfillmentStatus": {
                    return false;
                }
                case "id": {
                    return false;
                }
                case "lineItems": {
                    return true;
                }
                case "metafield": {
                    return true;
                }
                case "metafields": {
                    return true;
                }
                case "name": {
                    return false;
                }
                case "orderNumber": {
                    return false;
                }
                case "originalTotalDuties": {
                    return true;
                }
                case "originalTotalPrice": {
                    return true;
                }
                case "phone": {
                    return false;
                }
                case "processedAt": {
                    return false;
                }
                case "shippingAddress": {
                    return true;
                }
                case "shippingDiscountAllocations": {
                    return true;
                }
                case "statusUrl": {
                    return false;
                }
                case "subtotalPrice": {
                    return true;
                }
                case "subtotalPriceV2": {
                    return true;
                }
                case "successfulFulfillments": {
                    return true;
                }
                case "totalPrice": {
                    return true;
                }
                case "totalPriceV2": {
                    return true;
                }
                case "totalRefunded": {
                    return true;
                }
                case "totalRefundedV2": {
                    return true;
                }
                case "totalShippingPrice": {
                    return true;
                }
                case "totalShippingPriceV2": {
                    return true;
                }
                case "totalTax": {
                    return true;
                }
                case "totalTaxV2": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class OrderQuery
    extends Query<OrderQuery> {
        OrderQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public OrderQuery billingAddress(MailingAddressQueryDefinition queryDef) {
            this.startField("billingAddress");
            this._queryBuilder.append('{');
            queryDef.define(new MailingAddressQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery cancelReason() {
            this.startField("cancelReason");
            return this;
        }

        public OrderQuery canceledAt() {
            this.startField("canceledAt");
            return this;
        }

        public OrderQuery currencyCode() {
            this.startField("currencyCode");
            return this;
        }

        public OrderQuery currentSubtotalPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("currentSubtotalPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery currentTotalDuties(MoneyV2QueryDefinition queryDef) {
            this.startField("currentTotalDuties");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery currentTotalPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("currentTotalPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery currentTotalShippingPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("currentTotalShippingPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery currentTotalTax(MoneyV2QueryDefinition queryDef) {
            this.startField("currentTotalTax");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery customAttributes(AttributeQueryDefinition queryDef) {
            this.startField("customAttributes");
            this._queryBuilder.append('{');
            queryDef.define(new AttributeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery customerLocale() {
            this.startField("customerLocale");
            return this;
        }

        public OrderQuery customerUrl() {
            this.startField("customerUrl");
            return this;
        }

        public OrderQuery discountApplications(DiscountApplicationConnectionQueryDefinition queryDef) {
            return this.discountApplications(args -> {}, queryDef);
        }

        public OrderQuery discountApplications(DiscountApplicationsArgumentsDefinition argsDef, DiscountApplicationConnectionQueryDefinition queryDef) {
            this.startField("discountApplications");
            DiscountApplicationsArguments args = new DiscountApplicationsArguments(this._queryBuilder);
            argsDef.define(args);
            DiscountApplicationsArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new DiscountApplicationConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery edited() {
            this.startField("edited");
            return this;
        }

        public OrderQuery email() {
            this.startField("email");
            return this;
        }

        public OrderQuery financialStatus() {
            this.startField("financialStatus");
            return this;
        }

        public OrderQuery fulfillmentStatus() {
            this.startField("fulfillmentStatus");
            return this;
        }

        public OrderQuery lineItems(OrderLineItemConnectionQueryDefinition queryDef) {
            return this.lineItems(args -> {}, queryDef);
        }

        public OrderQuery lineItems(LineItemsArgumentsDefinition argsDef, OrderLineItemConnectionQueryDefinition queryDef) {
            this.startField("lineItems");
            LineItemsArguments args = new LineItemsArguments(this._queryBuilder);
            argsDef.define(args);
            LineItemsArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new OrderLineItemConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery metafield(String key, MetafieldQueryDefinition queryDef) {
            return this.metafield(key, args -> {}, queryDef);
        }

        public OrderQuery metafield(String key, MetafieldArgumentsDefinition argsDef, MetafieldQueryDefinition queryDef) {
            this.startField("metafield");
            this._queryBuilder.append("(key:");
            Query.appendQuotedString(this._queryBuilder, key.toString());
            argsDef.define(new MetafieldArguments(this._queryBuilder));
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery metafields(List<HasMetafieldsIdentifier> identifiers, MetafieldQueryDefinition queryDef) {
            this.startField("metafields");
            this._queryBuilder.append("(identifiers:");
            this._queryBuilder.append('[');
            String listSeperator1 = "";
            for (HasMetafieldsIdentifier item1 : identifiers) {
                this._queryBuilder.append(listSeperator1);
                listSeperator1 = ",";
                item1.appendTo(this._queryBuilder);
            }
            this._queryBuilder.append(']');
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery name() {
            this.startField("name");
            return this;
        }

        public OrderQuery orderNumber() {
            this.startField("orderNumber");
            return this;
        }

        public OrderQuery originalTotalDuties(MoneyV2QueryDefinition queryDef) {
            this.startField("originalTotalDuties");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery originalTotalPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("originalTotalPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery phone() {
            this.startField("phone");
            return this;
        }

        public OrderQuery processedAt() {
            this.startField("processedAt");
            return this;
        }

        public OrderQuery shippingAddress(MailingAddressQueryDefinition queryDef) {
            this.startField("shippingAddress");
            this._queryBuilder.append('{');
            queryDef.define(new MailingAddressQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery shippingDiscountAllocations(DiscountAllocationQueryDefinition queryDef) {
            this.startField("shippingDiscountAllocations");
            this._queryBuilder.append('{');
            queryDef.define(new DiscountAllocationQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery statusUrl() {
            this.startField("statusUrl");
            return this;
        }

        public OrderQuery subtotalPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("subtotalPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        @Deprecated
        public OrderQuery subtotalPriceV2(MoneyV2QueryDefinition queryDef) {
            this.startField("subtotalPriceV2");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery successfulFulfillments(FulfillmentQueryDefinition queryDef) {
            return this.successfulFulfillments(args -> {}, queryDef);
        }

        public OrderQuery successfulFulfillments(SuccessfulFulfillmentsArgumentsDefinition argsDef, FulfillmentQueryDefinition queryDef) {
            this.startField("successfulFulfillments");
            SuccessfulFulfillmentsArguments args = new SuccessfulFulfillmentsArguments(this._queryBuilder);
            argsDef.define(args);
            SuccessfulFulfillmentsArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new FulfillmentQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery totalPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("totalPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        @Deprecated
        public OrderQuery totalPriceV2(MoneyV2QueryDefinition queryDef) {
            this.startField("totalPriceV2");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery totalRefunded(MoneyV2QueryDefinition queryDef) {
            this.startField("totalRefunded");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        @Deprecated
        public OrderQuery totalRefundedV2(MoneyV2QueryDefinition queryDef) {
            this.startField("totalRefundedV2");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery totalShippingPrice(MoneyV2QueryDefinition queryDef) {
            this.startField("totalShippingPrice");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        @Deprecated
        public OrderQuery totalShippingPriceV2(MoneyV2QueryDefinition queryDef) {
            this.startField("totalShippingPriceV2");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OrderQuery totalTax(MoneyV2QueryDefinition queryDef) {
            this.startField("totalTax");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        @Deprecated
        public OrderQuery totalTaxV2(MoneyV2QueryDefinition queryDef) {
            this.startField("totalTaxV2");
            this._queryBuilder.append('{');
            queryDef.define(new MoneyV2Query(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public static interface SuccessfulFulfillmentsArgumentsDefinition {
            public void define(SuccessfulFulfillmentsArguments var1);
        }

        public class SuccessfulFulfillmentsArguments
        extends Arguments {
            SuccessfulFulfillmentsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public SuccessfulFulfillmentsArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    OrderQuery.this._queryBuilder.append(value);
                }
                return this;
            }
        }

        public static interface MetafieldArgumentsDefinition {
            public void define(MetafieldArguments var1);
        }

        public class MetafieldArguments
        extends Arguments {
            MetafieldArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            public MetafieldArguments namespace(String value) {
                if (value != null) {
                    this.startArgument("namespace");
                    Query.appendQuotedString(OrderQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }

        public static interface LineItemsArgumentsDefinition {
            public void define(LineItemsArguments var1);
        }

        public class LineItemsArguments
        extends Arguments {
            LineItemsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public LineItemsArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    OrderQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public LineItemsArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(OrderQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public LineItemsArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    OrderQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public LineItemsArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(OrderQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public LineItemsArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    OrderQuery.this._queryBuilder.append(value);
                }
                return this;
            }
        }

        public static interface DiscountApplicationsArgumentsDefinition {
            public void define(DiscountApplicationsArguments var1);
        }

        public class DiscountApplicationsArguments
        extends Arguments {
            DiscountApplicationsArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public DiscountApplicationsArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    OrderQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public DiscountApplicationsArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(OrderQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public DiscountApplicationsArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    OrderQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public DiscountApplicationsArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(OrderQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public DiscountApplicationsArguments reverse(Boolean value) {
                if (value != null) {
                    this.startArgument("reverse");
                    OrderQuery.this._queryBuilder.append(value);
                }
                return this;
            }
        }
    }

    public static interface OrderQueryDefinition {
        public void define(OrderQuery var1);
    }

    public static class UnknownOnlineStorePublishable
    extends AbstractResponse<UnknownOnlineStorePublishable>
    implements OnlineStorePublishable {
        public UnknownOnlineStorePublishable() {
        }

        public UnknownOnlineStorePublishable(JsonObject fields) throws SchemaViolationError {
            block8: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "onlineStoreUrl": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block8;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public static OnlineStorePublishable create(JsonObject fields) throws SchemaViolationError {
            String typeName;
            switch (typeName = fields.getAsJsonPrimitive("__typename").getAsString()) {
                case "Article": {
                    return new Article(fields);
                }
                case "Blog": {
                    return new Blog(fields);
                }
                case "Collection": {
                    return new Collection(fields);
                }
                case "Metaobject": {
                    return new Metaobject(fields);
                }
                case "Page": {
                    return new Page(fields);
                }
                case "Product": {
                    return new Product(fields);
                }
            }
            return new UnknownOnlineStorePublishable(fields);
        }

        @Override
        public String getGraphQlTypeName() {
            return (String)this.get("__typename");
        }

        @Override
        public String getOnlineStoreUrl() {
            return (String)this.get("onlineStoreUrl");
        }

        public UnknownOnlineStorePublishable setOnlineStoreUrl(String arg) {
            this.optimisticData.put(this.getKey("onlineStoreUrl"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "onlineStoreUrl": {
                    return false;
                }
            }
            return false;
        }
    }

    public static interface OnlineStorePublishable {
        public String getGraphQlTypeName();

        public String getOnlineStoreUrl();
    }

    public static class OnlineStorePublishableQuery
    extends Query<OnlineStorePublishableQuery> {
        OnlineStorePublishableQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("__typename");
        }

        public OnlineStorePublishableQuery onlineStoreUrl() {
            this.startField("onlineStoreUrl");
            return this;
        }

        public OnlineStorePublishableQuery onArticle(ArticleQueryDefinition queryDef) {
            this.startInlineFragment("Article");
            queryDef.define(new ArticleQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OnlineStorePublishableQuery onBlog(BlogQueryDefinition queryDef) {
            this.startInlineFragment("Blog");
            queryDef.define(new BlogQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OnlineStorePublishableQuery onCollection(CollectionQueryDefinition queryDef) {
            this.startInlineFragment("Collection");
            queryDef.define(new CollectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OnlineStorePublishableQuery onMetaobject(MetaobjectQueryDefinition queryDef) {
            this.startInlineFragment("Metaobject");
            queryDef.define(new MetaobjectQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OnlineStorePublishableQuery onPage(PageQueryDefinition queryDef) {
            this.startInlineFragment("Page");
            queryDef.define(new PageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public OnlineStorePublishableQuery onProduct(ProductQueryDefinition queryDef) {
            this.startInlineFragment("Product");
            queryDef.define(new ProductQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface OnlineStorePublishableQueryDefinition {
        public void define(OnlineStorePublishableQuery var1);
    }

    public static class UnknownNode
    extends AbstractResponse<UnknownNode>
    implements Node {
        public UnknownNode() {
        }

        public UnknownNode(JsonObject fields) throws SchemaViolationError {
            block8: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block8;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block8;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public static Node create(JsonObject fields) throws SchemaViolationError {
            String typeName;
            switch (typeName = fields.getAsJsonPrimitive("__typename").getAsString()) {
                case "AppliedGiftCard": {
                    return new AppliedGiftCard(fields);
                }
                case "Article": {
                    return new Article(fields);
                }
                case "Blog": {
                    return new Blog(fields);
                }
                case "Cart": {
                    return new Cart(fields);
                }
                case "CartLine": {
                    return new CartLine(fields);
                }
                case "Collection": {
                    return new Collection(fields);
                }
                case "Comment": {
                    return new Comment(fields);
                }
                case "Company": {
                    return new Company(fields);
                }
                case "CompanyContact": {
                    return new CompanyContact(fields);
                }
                case "CompanyLocation": {
                    return new CompanyLocation(fields);
                }
                case "ComponentizableCartLine": {
                    return new ComponentizableCartLine(fields);
                }
                case "ExternalVideo": {
                    return new ExternalVideo(fields);
                }
                case "GenericFile": {
                    return new GenericFile(fields);
                }
                case "Location": {
                    return new Location(fields);
                }
                case "MailingAddress": {
                    return new MailingAddress(fields);
                }
                case "Market": {
                    return new Market(fields);
                }
                case "MediaImage": {
                    return new MediaImage(fields);
                }
                case "MediaPresentation": {
                    return new MediaPresentation(fields);
                }
                case "Menu": {
                    return new Menu(fields);
                }
                case "MenuItem": {
                    return new MenuItem(fields);
                }
                case "Metafield": {
                    return new Metafield(fields);
                }
                case "Metaobject": {
                    return new Metaobject(fields);
                }
                case "Model3d": {
                    return new Model3d(fields);
                }
                case "Order": {
                    return new Order(fields);
                }
                case "Page": {
                    return new Page(fields);
                }
                case "Product": {
                    return new Product(fields);
                }
                case "ProductOption": {
                    return new ProductOption(fields);
                }
                case "ProductOptionValue": {
                    return new ProductOptionValue(fields);
                }
                case "ProductVariant": {
                    return new ProductVariant(fields);
                }
                case "Shop": {
                    return new Shop(fields);
                }
                case "ShopPolicy": {
                    return new ShopPolicy(fields);
                }
                case "UrlRedirect": {
                    return new UrlRedirect(fields);
                }
                case "Video": {
                    return new Video(fields);
                }
            }
            return new UnknownNode(fields);
        }

        @Override
        public String getGraphQlTypeName() {
            return (String)this.get("__typename");
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        public UnknownNode setId(ID arg) {
            this.optimisticData.put(this.getKey("id"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "id": {
                    return false;
                }
            }
            return false;
        }
    }

    public static interface Node
    extends com.shopify.graphql.support.Node {
        @Override
        public String getGraphQlTypeName();

        @Override
        public ID getId();
    }

    public static class NodeQuery
    extends Query<NodeQuery> {
        NodeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("__typename");
        }

        public NodeQuery id() {
            this.startField("id");
            return this;
        }

        public NodeQuery onAppliedGiftCard(AppliedGiftCardQueryDefinition queryDef) {
            this.startInlineFragment("AppliedGiftCard");
            queryDef.define(new AppliedGiftCardQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onArticle(ArticleQueryDefinition queryDef) {
            this.startInlineFragment("Article");
            queryDef.define(new ArticleQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onBlog(BlogQueryDefinition queryDef) {
            this.startInlineFragment("Blog");
            queryDef.define(new BlogQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onCart(CartQueryDefinition queryDef) {
            this.startInlineFragment("Cart");
            queryDef.define(new CartQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onCartLine(CartLineQueryDefinition queryDef) {
            this.startInlineFragment("CartLine");
            queryDef.define(new CartLineQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onCollection(CollectionQueryDefinition queryDef) {
            this.startInlineFragment("Collection");
            queryDef.define(new CollectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onComment(CommentQueryDefinition queryDef) {
            this.startInlineFragment("Comment");
            queryDef.define(new CommentQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onCompany(CompanyQueryDefinition queryDef) {
            this.startInlineFragment("Company");
            queryDef.define(new CompanyQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onCompanyContact(CompanyContactQueryDefinition queryDef) {
            this.startInlineFragment("CompanyContact");
            queryDef.define(new CompanyContactQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onCompanyLocation(CompanyLocationQueryDefinition queryDef) {
            this.startInlineFragment("CompanyLocation");
            queryDef.define(new CompanyLocationQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onComponentizableCartLine(ComponentizableCartLineQueryDefinition queryDef) {
            this.startInlineFragment("ComponentizableCartLine");
            queryDef.define(new ComponentizableCartLineQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onExternalVideo(ExternalVideoQueryDefinition queryDef) {
            this.startInlineFragment("ExternalVideo");
            queryDef.define(new ExternalVideoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onGenericFile(GenericFileQueryDefinition queryDef) {
            this.startInlineFragment("GenericFile");
            queryDef.define(new GenericFileQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onLocation(LocationQueryDefinition queryDef) {
            this.startInlineFragment("Location");
            queryDef.define(new LocationQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onMailingAddress(MailingAddressQueryDefinition queryDef) {
            this.startInlineFragment("MailingAddress");
            queryDef.define(new MailingAddressQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onMarket(MarketQueryDefinition queryDef) {
            this.startInlineFragment("Market");
            queryDef.define(new MarketQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onMediaImage(MediaImageQueryDefinition queryDef) {
            this.startInlineFragment("MediaImage");
            queryDef.define(new MediaImageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onMediaPresentation(MediaPresentationQueryDefinition queryDef) {
            this.startInlineFragment("MediaPresentation");
            queryDef.define(new MediaPresentationQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onMenu(MenuQueryDefinition queryDef) {
            this.startInlineFragment("Menu");
            queryDef.define(new MenuQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onMenuItem(MenuItemQueryDefinition queryDef) {
            this.startInlineFragment("MenuItem");
            queryDef.define(new MenuItemQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onMetafield(MetafieldQueryDefinition queryDef) {
            this.startInlineFragment("Metafield");
            queryDef.define(new MetafieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onMetaobject(MetaobjectQueryDefinition queryDef) {
            this.startInlineFragment("Metaobject");
            queryDef.define(new MetaobjectQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onModel3d(Model3dQueryDefinition queryDef) {
            this.startInlineFragment("Model3d");
            queryDef.define(new Model3dQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onOrder(OrderQueryDefinition queryDef) {
            this.startInlineFragment("Order");
            queryDef.define(new OrderQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onPage(PageQueryDefinition queryDef) {
            this.startInlineFragment("Page");
            queryDef.define(new PageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onProduct(ProductQueryDefinition queryDef) {
            this.startInlineFragment("Product");
            queryDef.define(new ProductQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onProductOption(ProductOptionQueryDefinition queryDef) {
            this.startInlineFragment("ProductOption");
            queryDef.define(new ProductOptionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onProductOptionValue(ProductOptionValueQueryDefinition queryDef) {
            this.startInlineFragment("ProductOptionValue");
            queryDef.define(new ProductOptionValueQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onProductVariant(ProductVariantQueryDefinition queryDef) {
            this.startInlineFragment("ProductVariant");
            queryDef.define(new ProductVariantQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onShop(ShopQueryDefinition queryDef) {
            this.startInlineFragment("Shop");
            queryDef.define(new ShopQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onShopPolicy(ShopPolicyQueryDefinition queryDef) {
            this.startInlineFragment("ShopPolicy");
            queryDef.define(new ShopPolicyQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onUrlRedirect(UrlRedirectQueryDefinition queryDef) {
            this.startInlineFragment("UrlRedirect");
            queryDef.define(new UrlRedirectQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public NodeQuery onVideo(VideoQueryDefinition queryDef) {
            this.startInlineFragment("Video");
            queryDef.define(new VideoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface NodeQueryDefinition {
        public void define(NodeQuery var1);
    }

    public static class Mutation
    extends AbstractResponse<Mutation> {
        public Mutation() {
        }

        public Mutation(JsonObject fields) throws SchemaViolationError {
            block70: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cartAttributesUpdate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CartAttributesUpdatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "cartBillingAddressUpdate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CartBillingAddressUpdatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "cartBuyerIdentityUpdate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CartBuyerIdentityUpdatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "cartCreate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CartCreatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "cartDiscountCodesUpdate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CartDiscountCodesUpdatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "cartGiftCardCodesUpdate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CartGiftCardCodesUpdatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "cartLinesAdd": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CartLinesAddPayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "cartLinesRemove": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CartLinesRemovePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "cartLinesUpdate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CartLinesUpdatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "cartMetafieldDelete": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CartMetafieldDeletePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "cartMetafieldsSet": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CartMetafieldsSetPayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "cartNoteUpdate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CartNoteUpdatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "cartPaymentUpdate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CartPaymentUpdatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "cartSelectedDeliveryOptionsUpdate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CartSelectedDeliveryOptionsUpdatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "cartSubmitForCompletion": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CartSubmitForCompletionPayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "customerAccessTokenCreate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CustomerAccessTokenCreatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "customerAccessTokenCreateWithMultipass": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CustomerAccessTokenCreateWithMultipassPayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "customerAccessTokenDelete": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CustomerAccessTokenDeletePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "customerAccessTokenRenew": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CustomerAccessTokenRenewPayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "customerActivate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CustomerActivatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "customerActivateByUrl": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CustomerActivateByUrlPayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "customerAddressCreate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CustomerAddressCreatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "customerAddressDelete": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CustomerAddressDeletePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "customerAddressUpdate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CustomerAddressUpdatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "customerCreate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CustomerCreatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "customerDefaultAddressUpdate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CustomerDefaultAddressUpdatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "customerRecover": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CustomerRecoverPayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "customerReset": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CustomerResetPayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "customerResetByUrl": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CustomerResetByUrlPayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "customerUpdate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new CustomerUpdatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "shopPayPaymentRequestSessionCreate": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ShopPayPaymentRequestSessionCreatePayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "shopPayPaymentRequestSessionSubmit": {
                        AbstractResponse optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ShopPayPaymentRequestSessionSubmitPayload(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block70;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block70;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "Mutation";
        }

        public CartAttributesUpdatePayload getCartAttributesUpdate() {
            return (CartAttributesUpdatePayload)this.get("cartAttributesUpdate");
        }

        public Mutation setCartAttributesUpdate(CartAttributesUpdatePayload arg) {
            this.optimisticData.put(this.getKey("cartAttributesUpdate"), arg);
            return this;
        }

        public CartBillingAddressUpdatePayload getCartBillingAddressUpdate() {
            return (CartBillingAddressUpdatePayload)this.get("cartBillingAddressUpdate");
        }

        public Mutation setCartBillingAddressUpdate(CartBillingAddressUpdatePayload arg) {
            this.optimisticData.put(this.getKey("cartBillingAddressUpdate"), arg);
            return this;
        }

        public CartBuyerIdentityUpdatePayload getCartBuyerIdentityUpdate() {
            return (CartBuyerIdentityUpdatePayload)this.get("cartBuyerIdentityUpdate");
        }

        public Mutation setCartBuyerIdentityUpdate(CartBuyerIdentityUpdatePayload arg) {
            this.optimisticData.put(this.getKey("cartBuyerIdentityUpdate"), arg);
            return this;
        }

        public CartCreatePayload getCartCreate() {
            return (CartCreatePayload)this.get("cartCreate");
        }

        public Mutation setCartCreate(CartCreatePayload arg) {
            this.optimisticData.put(this.getKey("cartCreate"), arg);
            return this;
        }

        public CartDiscountCodesUpdatePayload getCartDiscountCodesUpdate() {
            return (CartDiscountCodesUpdatePayload)this.get("cartDiscountCodesUpdate");
        }

        public Mutation setCartDiscountCodesUpdate(CartDiscountCodesUpdatePayload arg) {
            this.optimisticData.put(this.getKey("cartDiscountCodesUpdate"), arg);
            return this;
        }

        public CartGiftCardCodesUpdatePayload getCartGiftCardCodesUpdate() {
            return (CartGiftCardCodesUpdatePayload)this.get("cartGiftCardCodesUpdate");
        }

        public Mutation setCartGiftCardCodesUpdate(CartGiftCardCodesUpdatePayload arg) {
            this.optimisticData.put(this.getKey("cartGiftCardCodesUpdate"), arg);
            return this;
        }

        public CartLinesAddPayload getCartLinesAdd() {
            return (CartLinesAddPayload)this.get("cartLinesAdd");
        }

        public Mutation setCartLinesAdd(CartLinesAddPayload arg) {
            this.optimisticData.put(this.getKey("cartLinesAdd"), arg);
            return this;
        }

        public CartLinesRemovePayload getCartLinesRemove() {
            return (CartLinesRemovePayload)this.get("cartLinesRemove");
        }

        public Mutation setCartLinesRemove(CartLinesRemovePayload arg) {
            this.optimisticData.put(this.getKey("cartLinesRemove"), arg);
            return this;
        }

        public CartLinesUpdatePayload getCartLinesUpdate() {
            return (CartLinesUpdatePayload)this.get("cartLinesUpdate");
        }

        public Mutation setCartLinesUpdate(CartLinesUpdatePayload arg) {
            this.optimisticData.put(this.getKey("cartLinesUpdate"), arg);
            return this;
        }

        public CartMetafieldDeletePayload getCartMetafieldDelete() {
            return (CartMetafieldDeletePayload)this.get("cartMetafieldDelete");
        }

        public Mutation setCartMetafieldDelete(CartMetafieldDeletePayload arg) {
            this.optimisticData.put(this.getKey("cartMetafieldDelete"), arg);
            return this;
        }

        public CartMetafieldsSetPayload getCartMetafieldsSet() {
            return (CartMetafieldsSetPayload)this.get("cartMetafieldsSet");
        }

        public Mutation setCartMetafieldsSet(CartMetafieldsSetPayload arg) {
            this.optimisticData.put(this.getKey("cartMetafieldsSet"), arg);
            return this;
        }

        public CartNoteUpdatePayload getCartNoteUpdate() {
            return (CartNoteUpdatePayload)this.get("cartNoteUpdate");
        }

        public Mutation setCartNoteUpdate(CartNoteUpdatePayload arg) {
            this.optimisticData.put(this.getKey("cartNoteUpdate"), arg);
            return this;
        }

        public CartPaymentUpdatePayload getCartPaymentUpdate() {
            return (CartPaymentUpdatePayload)this.get("cartPaymentUpdate");
        }

        public Mutation setCartPaymentUpdate(CartPaymentUpdatePayload arg) {
            this.optimisticData.put(this.getKey("cartPaymentUpdate"), arg);
            return this;
        }

        public CartSelectedDeliveryOptionsUpdatePayload getCartSelectedDeliveryOptionsUpdate() {
            return (CartSelectedDeliveryOptionsUpdatePayload)this.get("cartSelectedDeliveryOptionsUpdate");
        }

        public Mutation setCartSelectedDeliveryOptionsUpdate(CartSelectedDeliveryOptionsUpdatePayload arg) {
            this.optimisticData.put(this.getKey("cartSelectedDeliveryOptionsUpdate"), arg);
            return this;
        }

        public CartSubmitForCompletionPayload getCartSubmitForCompletion() {
            return (CartSubmitForCompletionPayload)this.get("cartSubmitForCompletion");
        }

        public Mutation setCartSubmitForCompletion(CartSubmitForCompletionPayload arg) {
            this.optimisticData.put(this.getKey("cartSubmitForCompletion"), arg);
            return this;
        }

        public CustomerAccessTokenCreatePayload getCustomerAccessTokenCreate() {
            return (CustomerAccessTokenCreatePayload)this.get("customerAccessTokenCreate");
        }

        public Mutation setCustomerAccessTokenCreate(CustomerAccessTokenCreatePayload arg) {
            this.optimisticData.put(this.getKey("customerAccessTokenCreate"), arg);
            return this;
        }

        public CustomerAccessTokenCreateWithMultipassPayload getCustomerAccessTokenCreateWithMultipass() {
            return (CustomerAccessTokenCreateWithMultipassPayload)this.get("customerAccessTokenCreateWithMultipass");
        }

        public Mutation setCustomerAccessTokenCreateWithMultipass(CustomerAccessTokenCreateWithMultipassPayload arg) {
            this.optimisticData.put(this.getKey("customerAccessTokenCreateWithMultipass"), arg);
            return this;
        }

        public CustomerAccessTokenDeletePayload getCustomerAccessTokenDelete() {
            return (CustomerAccessTokenDeletePayload)this.get("customerAccessTokenDelete");
        }

        public Mutation setCustomerAccessTokenDelete(CustomerAccessTokenDeletePayload arg) {
            this.optimisticData.put(this.getKey("customerAccessTokenDelete"), arg);
            return this;
        }

        public CustomerAccessTokenRenewPayload getCustomerAccessTokenRenew() {
            return (CustomerAccessTokenRenewPayload)this.get("customerAccessTokenRenew");
        }

        public Mutation setCustomerAccessTokenRenew(CustomerAccessTokenRenewPayload arg) {
            this.optimisticData.put(this.getKey("customerAccessTokenRenew"), arg);
            return this;
        }

        public CustomerActivatePayload getCustomerActivate() {
            return (CustomerActivatePayload)this.get("customerActivate");
        }

        public Mutation setCustomerActivate(CustomerActivatePayload arg) {
            this.optimisticData.put(this.getKey("customerActivate"), arg);
            return this;
        }

        public CustomerActivateByUrlPayload getCustomerActivateByUrl() {
            return (CustomerActivateByUrlPayload)this.get("customerActivateByUrl");
        }

        public Mutation setCustomerActivateByUrl(CustomerActivateByUrlPayload arg) {
            this.optimisticData.put(this.getKey("customerActivateByUrl"), arg);
            return this;
        }

        public CustomerAddressCreatePayload getCustomerAddressCreate() {
            return (CustomerAddressCreatePayload)this.get("customerAddressCreate");
        }

        public Mutation setCustomerAddressCreate(CustomerAddressCreatePayload arg) {
            this.optimisticData.put(this.getKey("customerAddressCreate"), arg);
            return this;
        }

        public CustomerAddressDeletePayload getCustomerAddressDelete() {
            return (CustomerAddressDeletePayload)this.get("customerAddressDelete");
        }

        public Mutation setCustomerAddressDelete(CustomerAddressDeletePayload arg) {
            this.optimisticData.put(this.getKey("customerAddressDelete"), arg);
            return this;
        }

        public CustomerAddressUpdatePayload getCustomerAddressUpdate() {
            return (CustomerAddressUpdatePayload)this.get("customerAddressUpdate");
        }

        public Mutation setCustomerAddressUpdate(CustomerAddressUpdatePayload arg) {
            this.optimisticData.put(this.getKey("customerAddressUpdate"), arg);
            return this;
        }

        public CustomerCreatePayload getCustomerCreate() {
            return (CustomerCreatePayload)this.get("customerCreate");
        }

        public Mutation setCustomerCreate(CustomerCreatePayload arg) {
            this.optimisticData.put(this.getKey("customerCreate"), arg);
            return this;
        }

        public CustomerDefaultAddressUpdatePayload getCustomerDefaultAddressUpdate() {
            return (CustomerDefaultAddressUpdatePayload)this.get("customerDefaultAddressUpdate");
        }

        public Mutation setCustomerDefaultAddressUpdate(CustomerDefaultAddressUpdatePayload arg) {
            this.optimisticData.put(this.getKey("customerDefaultAddressUpdate"), arg);
            return this;
        }

        public CustomerRecoverPayload getCustomerRecover() {
            return (CustomerRecoverPayload)this.get("customerRecover");
        }

        public Mutation setCustomerRecover(CustomerRecoverPayload arg) {
            this.optimisticData.put(this.getKey("customerRecover"), arg);
            return this;
        }

        public CustomerResetPayload getCustomerReset() {
            return (CustomerResetPayload)this.get("customerReset");
        }

        public Mutation setCustomerReset(CustomerResetPayload arg) {
            this.optimisticData.put(this.getKey("customerReset"), arg);
            return this;
        }

        public CustomerResetByUrlPayload getCustomerResetByUrl() {
            return (CustomerResetByUrlPayload)this.get("customerResetByUrl");
        }

        public Mutation setCustomerResetByUrl(CustomerResetByUrlPayload arg) {
            this.optimisticData.put(this.getKey("customerResetByUrl"), arg);
            return this;
        }

        public CustomerUpdatePayload getCustomerUpdate() {
            return (CustomerUpdatePayload)this.get("customerUpdate");
        }

        public Mutation setCustomerUpdate(CustomerUpdatePayload arg) {
            this.optimisticData.put(this.getKey("customerUpdate"), arg);
            return this;
        }

        public ShopPayPaymentRequestSessionCreatePayload getShopPayPaymentRequestSessionCreate() {
            return (ShopPayPaymentRequestSessionCreatePayload)this.get("shopPayPaymentRequestSessionCreate");
        }

        public Mutation setShopPayPaymentRequestSessionCreate(ShopPayPaymentRequestSessionCreatePayload arg) {
            this.optimisticData.put(this.getKey("shopPayPaymentRequestSessionCreate"), arg);
            return this;
        }

        public ShopPayPaymentRequestSessionSubmitPayload getShopPayPaymentRequestSessionSubmit() {
            return (ShopPayPaymentRequestSessionSubmitPayload)this.get("shopPayPaymentRequestSessionSubmit");
        }

        public Mutation setShopPayPaymentRequestSessionSubmit(ShopPayPaymentRequestSessionSubmitPayload arg) {
            this.optimisticData.put(this.getKey("shopPayPaymentRequestSessionSubmit"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cartAttributesUpdate": {
                    return true;
                }
                case "cartBillingAddressUpdate": {
                    return true;
                }
                case "cartBuyerIdentityUpdate": {
                    return true;
                }
                case "cartCreate": {
                    return true;
                }
                case "cartDiscountCodesUpdate": {
                    return true;
                }
                case "cartGiftCardCodesUpdate": {
                    return true;
                }
                case "cartLinesAdd": {
                    return true;
                }
                case "cartLinesRemove": {
                    return true;
                }
                case "cartLinesUpdate": {
                    return true;
                }
                case "cartMetafieldDelete": {
                    return true;
                }
                case "cartMetafieldsSet": {
                    return true;
                }
                case "cartNoteUpdate": {
                    return true;
                }
                case "cartPaymentUpdate": {
                    return true;
                }
                case "cartSelectedDeliveryOptionsUpdate": {
                    return true;
                }
                case "cartSubmitForCompletion": {
                    return true;
                }
                case "customerAccessTokenCreate": {
                    return true;
                }
                case "customerAccessTokenCreateWithMultipass": {
                    return true;
                }
                case "customerAccessTokenDelete": {
                    return true;
                }
                case "customerAccessTokenRenew": {
                    return true;
                }
                case "customerActivate": {
                    return true;
                }
                case "customerActivateByUrl": {
                    return true;
                }
                case "customerAddressCreate": {
                    return true;
                }
                case "customerAddressDelete": {
                    return true;
                }
                case "customerAddressUpdate": {
                    return true;
                }
                case "customerCreate": {
                    return true;
                }
                case "customerDefaultAddressUpdate": {
                    return true;
                }
                case "customerRecover": {
                    return true;
                }
                case "customerReset": {
                    return true;
                }
                case "customerResetByUrl": {
                    return true;
                }
                case "customerUpdate": {
                    return true;
                }
                case "shopPayPaymentRequestSessionCreate": {
                    return true;
                }
                case "shopPayPaymentRequestSessionSubmit": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class MutationQuery
    extends Query<MutationQuery> {
        MutationQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public MutationQuery cartAttributesUpdate(List<AttributeInput> attributes, ID cartId, CartAttributesUpdatePayloadQueryDefinition queryDef) {
            this.startField("cartAttributesUpdate");
            this._queryBuilder.append("(attributes:");
            this._queryBuilder.append('[');
            String listSeperator1 = "";
            for (AttributeInput item1 : attributes) {
                this._queryBuilder.append(listSeperator1);
                listSeperator1 = ",";
                item1.appendTo(this._queryBuilder);
            }
            this._queryBuilder.append(']');
            this._queryBuilder.append(",cartId:");
            Query.appendQuotedString(this._queryBuilder, cartId.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartAttributesUpdatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery cartBillingAddressUpdate(ID cartId, CartBillingAddressUpdatePayloadQueryDefinition queryDef) {
            return this.cartBillingAddressUpdate(cartId, args -> {}, queryDef);
        }

        public MutationQuery cartBillingAddressUpdate(ID cartId, CartBillingAddressUpdateArgumentsDefinition argsDef, CartBillingAddressUpdatePayloadQueryDefinition queryDef) {
            this.startField("cartBillingAddressUpdate");
            this._queryBuilder.append("(cartId:");
            Query.appendQuotedString(this._queryBuilder, cartId.toString());
            argsDef.define(new CartBillingAddressUpdateArguments(this._queryBuilder));
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartBillingAddressUpdatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery cartBuyerIdentityUpdate(ID cartId, CartBuyerIdentityInput buyerIdentity, CartBuyerIdentityUpdatePayloadQueryDefinition queryDef) {
            this.startField("cartBuyerIdentityUpdate");
            this._queryBuilder.append("(cartId:");
            Query.appendQuotedString(this._queryBuilder, cartId.toString());
            this._queryBuilder.append(",buyerIdentity:");
            buyerIdentity.appendTo(this._queryBuilder);
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartBuyerIdentityUpdatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery cartCreate(CartCreatePayloadQueryDefinition queryDef) {
            return this.cartCreate(args -> {}, queryDef);
        }

        public MutationQuery cartCreate(CartCreateArgumentsDefinition argsDef, CartCreatePayloadQueryDefinition queryDef) {
            this.startField("cartCreate");
            CartCreateArguments args = new CartCreateArguments(this._queryBuilder);
            argsDef.define(args);
            CartCreateArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new CartCreatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery cartDiscountCodesUpdate(ID cartId, CartDiscountCodesUpdatePayloadQueryDefinition queryDef) {
            return this.cartDiscountCodesUpdate(cartId, args -> {}, queryDef);
        }

        public MutationQuery cartDiscountCodesUpdate(ID cartId, CartDiscountCodesUpdateArgumentsDefinition argsDef, CartDiscountCodesUpdatePayloadQueryDefinition queryDef) {
            this.startField("cartDiscountCodesUpdate");
            this._queryBuilder.append("(cartId:");
            Query.appendQuotedString(this._queryBuilder, cartId.toString());
            argsDef.define(new CartDiscountCodesUpdateArguments(this._queryBuilder));
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartDiscountCodesUpdatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery cartGiftCardCodesUpdate(ID cartId, List<String> giftCardCodes, CartGiftCardCodesUpdatePayloadQueryDefinition queryDef) {
            this.startField("cartGiftCardCodesUpdate");
            this._queryBuilder.append("(cartId:");
            Query.appendQuotedString(this._queryBuilder, cartId.toString());
            this._queryBuilder.append(",giftCardCodes:");
            this._queryBuilder.append('[');
            String listSeperator1 = "";
            for (String item1 : giftCardCodes) {
                this._queryBuilder.append(listSeperator1);
                listSeperator1 = ",";
                Query.appendQuotedString(this._queryBuilder, item1.toString());
            }
            this._queryBuilder.append(']');
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartGiftCardCodesUpdatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery cartLinesAdd(List<CartLineInput> lines, ID cartId, CartLinesAddPayloadQueryDefinition queryDef) {
            this.startField("cartLinesAdd");
            this._queryBuilder.append("(lines:");
            this._queryBuilder.append('[');
            String listSeperator1 = "";
            for (CartLineInput item1 : lines) {
                this._queryBuilder.append(listSeperator1);
                listSeperator1 = ",";
                item1.appendTo(this._queryBuilder);
            }
            this._queryBuilder.append(']');
            this._queryBuilder.append(",cartId:");
            Query.appendQuotedString(this._queryBuilder, cartId.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartLinesAddPayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery cartLinesRemove(ID cartId, List<ID> lineIds, CartLinesRemovePayloadQueryDefinition queryDef) {
            this.startField("cartLinesRemove");
            this._queryBuilder.append("(cartId:");
            Query.appendQuotedString(this._queryBuilder, cartId.toString());
            this._queryBuilder.append(",lineIds:");
            this._queryBuilder.append('[');
            String listSeperator1 = "";
            for (ID item1 : lineIds) {
                this._queryBuilder.append(listSeperator1);
                listSeperator1 = ",";
                Query.appendQuotedString(this._queryBuilder, item1.toString());
            }
            this._queryBuilder.append(']');
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartLinesRemovePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery cartLinesUpdate(ID cartId, List<CartLineUpdateInput> lines, CartLinesUpdatePayloadQueryDefinition queryDef) {
            this.startField("cartLinesUpdate");
            this._queryBuilder.append("(cartId:");
            Query.appendQuotedString(this._queryBuilder, cartId.toString());
            this._queryBuilder.append(",lines:");
            this._queryBuilder.append('[');
            String listSeperator1 = "";
            for (CartLineUpdateInput item1 : lines) {
                this._queryBuilder.append(listSeperator1);
                listSeperator1 = ",";
                item1.appendTo(this._queryBuilder);
            }
            this._queryBuilder.append(']');
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartLinesUpdatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery cartMetafieldDelete(CartMetafieldDeleteInput input, CartMetafieldDeletePayloadQueryDefinition queryDef) {
            this.startField("cartMetafieldDelete");
            this._queryBuilder.append("(input:");
            input.appendTo(this._queryBuilder);
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartMetafieldDeletePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery cartMetafieldsSet(List<CartMetafieldsSetInput> metafields, CartMetafieldsSetPayloadQueryDefinition queryDef) {
            this.startField("cartMetafieldsSet");
            this._queryBuilder.append("(metafields:");
            this._queryBuilder.append('[');
            String listSeperator1 = "";
            for (CartMetafieldsSetInput item1 : metafields) {
                this._queryBuilder.append(listSeperator1);
                listSeperator1 = ",";
                item1.appendTo(this._queryBuilder);
            }
            this._queryBuilder.append(']');
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartMetafieldsSetPayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery cartNoteUpdate(ID cartId, String note, CartNoteUpdatePayloadQueryDefinition queryDef) {
            this.startField("cartNoteUpdate");
            this._queryBuilder.append("(cartId:");
            Query.appendQuotedString(this._queryBuilder, cartId.toString());
            this._queryBuilder.append(",note:");
            Query.appendQuotedString(this._queryBuilder, note.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartNoteUpdatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery cartPaymentUpdate(ID cartId, CartPaymentInput payment, CartPaymentUpdatePayloadQueryDefinition queryDef) {
            this.startField("cartPaymentUpdate");
            this._queryBuilder.append("(cartId:");
            Query.appendQuotedString(this._queryBuilder, cartId.toString());
            this._queryBuilder.append(",payment:");
            payment.appendTo(this._queryBuilder);
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartPaymentUpdatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery cartSelectedDeliveryOptionsUpdate(ID cartId, List<CartSelectedDeliveryOptionInput> selectedDeliveryOptions, CartSelectedDeliveryOptionsUpdatePayloadQueryDefinition queryDef) {
            this.startField("cartSelectedDeliveryOptionsUpdate");
            this._queryBuilder.append("(cartId:");
            Query.appendQuotedString(this._queryBuilder, cartId.toString());
            this._queryBuilder.append(",selectedDeliveryOptions:");
            this._queryBuilder.append('[');
            String listSeperator1 = "";
            for (CartSelectedDeliveryOptionInput item1 : selectedDeliveryOptions) {
                this._queryBuilder.append(listSeperator1);
                listSeperator1 = ",";
                item1.appendTo(this._queryBuilder);
            }
            this._queryBuilder.append(']');
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartSelectedDeliveryOptionsUpdatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery cartSubmitForCompletion(ID cartId, String attemptToken, CartSubmitForCompletionPayloadQueryDefinition queryDef) {
            this.startField("cartSubmitForCompletion");
            this._queryBuilder.append("(cartId:");
            Query.appendQuotedString(this._queryBuilder, cartId.toString());
            this._queryBuilder.append(",attemptToken:");
            Query.appendQuotedString(this._queryBuilder, attemptToken.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CartSubmitForCompletionPayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery customerAccessTokenCreate(CustomerAccessTokenCreateInput input, CustomerAccessTokenCreatePayloadQueryDefinition queryDef) {
            this.startField("customerAccessTokenCreate");
            this._queryBuilder.append("(input:");
            input.appendTo(this._queryBuilder);
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerAccessTokenCreatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery customerAccessTokenCreateWithMultipass(String multipassToken, CustomerAccessTokenCreateWithMultipassPayloadQueryDefinition queryDef) {
            this.startField("customerAccessTokenCreateWithMultipass");
            this._queryBuilder.append("(multipassToken:");
            Query.appendQuotedString(this._queryBuilder, multipassToken.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerAccessTokenCreateWithMultipassPayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery customerAccessTokenDelete(String customerAccessToken, CustomerAccessTokenDeletePayloadQueryDefinition queryDef) {
            this.startField("customerAccessTokenDelete");
            this._queryBuilder.append("(customerAccessToken:");
            Query.appendQuotedString(this._queryBuilder, customerAccessToken.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerAccessTokenDeletePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery customerAccessTokenRenew(String customerAccessToken, CustomerAccessTokenRenewPayloadQueryDefinition queryDef) {
            this.startField("customerAccessTokenRenew");
            this._queryBuilder.append("(customerAccessToken:");
            Query.appendQuotedString(this._queryBuilder, customerAccessToken.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerAccessTokenRenewPayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery customerActivate(ID id, CustomerActivateInput input, CustomerActivatePayloadQueryDefinition queryDef) {
            this.startField("customerActivate");
            this._queryBuilder.append("(id:");
            Query.appendQuotedString(this._queryBuilder, id.toString());
            this._queryBuilder.append(",input:");
            input.appendTo(this._queryBuilder);
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerActivatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery customerActivateByUrl(String activationUrl, String password, CustomerActivateByUrlPayloadQueryDefinition queryDef) {
            this.startField("customerActivateByUrl");
            this._queryBuilder.append("(activationUrl:");
            Query.appendQuotedString(this._queryBuilder, activationUrl.toString());
            this._queryBuilder.append(",password:");
            Query.appendQuotedString(this._queryBuilder, password.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerActivateByUrlPayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery customerAddressCreate(String customerAccessToken, MailingAddressInput address, CustomerAddressCreatePayloadQueryDefinition queryDef) {
            this.startField("customerAddressCreate");
            this._queryBuilder.append("(customerAccessToken:");
            Query.appendQuotedString(this._queryBuilder, customerAccessToken.toString());
            this._queryBuilder.append(",address:");
            address.appendTo(this._queryBuilder);
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerAddressCreatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery customerAddressDelete(ID id, String customerAccessToken, CustomerAddressDeletePayloadQueryDefinition queryDef) {
            this.startField("customerAddressDelete");
            this._queryBuilder.append("(id:");
            Query.appendQuotedString(this._queryBuilder, id.toString());
            this._queryBuilder.append(",customerAccessToken:");
            Query.appendQuotedString(this._queryBuilder, customerAccessToken.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerAddressDeletePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery customerAddressUpdate(String customerAccessToken, ID id, MailingAddressInput address, CustomerAddressUpdatePayloadQueryDefinition queryDef) {
            this.startField("customerAddressUpdate");
            this._queryBuilder.append("(customerAccessToken:");
            Query.appendQuotedString(this._queryBuilder, customerAccessToken.toString());
            this._queryBuilder.append(",id:");
            Query.appendQuotedString(this._queryBuilder, id.toString());
            this._queryBuilder.append(",address:");
            address.appendTo(this._queryBuilder);
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerAddressUpdatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery customerCreate(CustomerCreateInput input, CustomerCreatePayloadQueryDefinition queryDef) {
            this.startField("customerCreate");
            this._queryBuilder.append("(input:");
            input.appendTo(this._queryBuilder);
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerCreatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery customerDefaultAddressUpdate(String customerAccessToken, ID addressId, CustomerDefaultAddressUpdatePayloadQueryDefinition queryDef) {
            this.startField("customerDefaultAddressUpdate");
            this._queryBuilder.append("(customerAccessToken:");
            Query.appendQuotedString(this._queryBuilder, customerAccessToken.toString());
            this._queryBuilder.append(",addressId:");
            Query.appendQuotedString(this._queryBuilder, addressId.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerDefaultAddressUpdatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery customerRecover(String email, CustomerRecoverPayloadQueryDefinition queryDef) {
            this.startField("customerRecover");
            this._queryBuilder.append("(email:");
            Query.appendQuotedString(this._queryBuilder, email.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerRecoverPayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery customerReset(ID id, CustomerResetInput input, CustomerResetPayloadQueryDefinition queryDef) {
            this.startField("customerReset");
            this._queryBuilder.append("(id:");
            Query.appendQuotedString(this._queryBuilder, id.toString());
            this._queryBuilder.append(",input:");
            input.appendTo(this._queryBuilder);
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerResetPayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery customerResetByUrl(String resetUrl, String password, CustomerResetByUrlPayloadQueryDefinition queryDef) {
            this.startField("customerResetByUrl");
            this._queryBuilder.append("(resetUrl:");
            Query.appendQuotedString(this._queryBuilder, resetUrl.toString());
            this._queryBuilder.append(",password:");
            Query.appendQuotedString(this._queryBuilder, password.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerResetByUrlPayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery customerUpdate(String customerAccessToken, CustomerUpdateInput customer, CustomerUpdatePayloadQueryDefinition queryDef) {
            this.startField("customerUpdate");
            this._queryBuilder.append("(customerAccessToken:");
            Query.appendQuotedString(this._queryBuilder, customerAccessToken.toString());
            this._queryBuilder.append(",customer:");
            customer.appendTo(this._queryBuilder);
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new CustomerUpdatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery shopPayPaymentRequestSessionCreate(String sourceIdentifier, ShopPayPaymentRequestInput paymentRequest, ShopPayPaymentRequestSessionCreatePayloadQueryDefinition queryDef) {
            this.startField("shopPayPaymentRequestSessionCreate");
            this._queryBuilder.append("(sourceIdentifier:");
            Query.appendQuotedString(this._queryBuilder, sourceIdentifier.toString());
            this._queryBuilder.append(",paymentRequest:");
            paymentRequest.appendTo(this._queryBuilder);
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestSessionCreatePayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MutationQuery shopPayPaymentRequestSessionSubmit(String token, ShopPayPaymentRequestInput paymentRequest, String idempotencyKey, ShopPayPaymentRequestSessionSubmitPayloadQueryDefinition queryDef) {
            return this.shopPayPaymentRequestSessionSubmit(token, paymentRequest, idempotencyKey, args -> {}, queryDef);
        }

        public MutationQuery shopPayPaymentRequestSessionSubmit(String token, ShopPayPaymentRequestInput paymentRequest, String idempotencyKey, ShopPayPaymentRequestSessionSubmitArgumentsDefinition argsDef, ShopPayPaymentRequestSessionSubmitPayloadQueryDefinition queryDef) {
            this.startField("shopPayPaymentRequestSessionSubmit");
            this._queryBuilder.append("(token:");
            Query.appendQuotedString(this._queryBuilder, token.toString());
            this._queryBuilder.append(",paymentRequest:");
            paymentRequest.appendTo(this._queryBuilder);
            this._queryBuilder.append(",idempotencyKey:");
            Query.appendQuotedString(this._queryBuilder, idempotencyKey.toString());
            argsDef.define(new ShopPayPaymentRequestSessionSubmitArguments(this._queryBuilder));
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new ShopPayPaymentRequestSessionSubmitPayloadQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public String toString() {
            return this._queryBuilder.toString();
        }

        public static interface ShopPayPaymentRequestSessionSubmitArgumentsDefinition {
            public void define(ShopPayPaymentRequestSessionSubmitArguments var1);
        }

        public class ShopPayPaymentRequestSessionSubmitArguments
        extends Arguments {
            ShopPayPaymentRequestSessionSubmitArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            public ShopPayPaymentRequestSessionSubmitArguments orderName(String value) {
                if (value != null) {
                    this.startArgument("orderName");
                    Query.appendQuotedString(MutationQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }

        public static interface CartDiscountCodesUpdateArgumentsDefinition {
            public void define(CartDiscountCodesUpdateArguments var1);
        }

        public class CartDiscountCodesUpdateArguments
        extends Arguments {
            CartDiscountCodesUpdateArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            public CartDiscountCodesUpdateArguments discountCodes(List<String> value) {
                if (value != null) {
                    this.startArgument("discountCodes");
                    MutationQuery.this._queryBuilder.append('[');
                    String listSeperator1 = "";
                    for (String item1 : value) {
                        MutationQuery.this._queryBuilder.append(listSeperator1);
                        listSeperator1 = ",";
                        Query.appendQuotedString(MutationQuery.this._queryBuilder, item1.toString());
                    }
                    MutationQuery.this._queryBuilder.append(']');
                }
                return this;
            }
        }

        public static interface CartCreateArgumentsDefinition {
            public void define(CartCreateArguments var1);
        }

        public class CartCreateArguments
        extends Arguments {
            CartCreateArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public CartCreateArguments input(CartInput value) {
                if (value != null) {
                    this.startArgument("input");
                    value.appendTo(MutationQuery.this._queryBuilder);
                }
                return this;
            }
        }

        public static interface CartBillingAddressUpdateArgumentsDefinition {
            public void define(CartBillingAddressUpdateArguments var1);
        }

        public class CartBillingAddressUpdateArguments
        extends Arguments {
            CartBillingAddressUpdateArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, false);
            }

            public CartBillingAddressUpdateArguments billingAddress(MailingAddressInput value) {
                if (value != null) {
                    this.startArgument("billingAddress");
                    value.appendTo(MutationQuery.this._queryBuilder);
                }
                return this;
            }
        }
    }

    public static interface MutationQueryDefinition {
        public void define(MutationQuery var1);
    }

    public static class MoneyV2
    extends AbstractResponse<MoneyV2>
    implements PricingValue,
    SellingPlanCheckoutChargeValue {
        public MoneyV2() {
        }

        public MoneyV2(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "amount": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "currencyCode": {
                        this.responseData.put(key, CurrencyCode.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "MoneyV2";
        }

        public String getAmount() {
            return (String)this.get("amount");
        }

        public MoneyV2 setAmount(String arg) {
            this.optimisticData.put(this.getKey("amount"), arg);
            return this;
        }

        public CurrencyCode getCurrencyCode() {
            return (CurrencyCode)((Object)this.get("currencyCode"));
        }

        public MoneyV2 setCurrencyCode(CurrencyCode arg) {
            this.optimisticData.put(this.getKey("currencyCode"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "amount": {
                    return false;
                }
                case "currencyCode": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class MoneyV2Query
    extends Query<MoneyV2Query> {
        MoneyV2Query(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public MoneyV2Query amount() {
            this.startField("amount");
            return this;
        }

        public MoneyV2Query currencyCode() {
            this.startField("currencyCode");
            return this;
        }
    }

    public static interface MoneyV2QueryDefinition {
        public void define(MoneyV2Query var1);
    }

    public static class MoneyInput
    implements Serializable {
        private String amount;
        private CurrencyCode currencyCode;

        public MoneyInput(String amount, CurrencyCode currencyCode) {
            this.amount = amount;
            this.currencyCode = currencyCode;
        }

        public String getAmount() {
            return this.amount;
        }

        public MoneyInput setAmount(String amount) {
            this.amount = amount;
            return this;
        }

        public CurrencyCode getCurrencyCode() {
            return this.currencyCode;
        }

        public MoneyInput setCurrencyCode(CurrencyCode currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("amount:");
            Query.appendQuotedString(_queryBuilder, this.amount.toString());
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("currencyCode:");
            _queryBuilder.append(this.currencyCode.toString());
            _queryBuilder.append('}');
        }
    }

    public static class Model3dSource
    extends AbstractResponse<Model3dSource> {
        public Model3dSource() {
        }

        public Model3dSource(JsonObject fields) throws SchemaViolationError {
            block14: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "filesize": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "format": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "mimeType": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "url": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "Model3dSource";
        }

        public Integer getFilesize() {
            return (Integer)this.get("filesize");
        }

        public Model3dSource setFilesize(Integer arg) {
            this.optimisticData.put(this.getKey("filesize"), arg);
            return this;
        }

        public String getFormat() {
            return (String)this.get("format");
        }

        public Model3dSource setFormat(String arg) {
            this.optimisticData.put(this.getKey("format"), arg);
            return this;
        }

        public String getMimeType() {
            return (String)this.get("mimeType");
        }

        public Model3dSource setMimeType(String arg) {
            this.optimisticData.put(this.getKey("mimeType"), arg);
            return this;
        }

        public String getUrl() {
            return (String)this.get("url");
        }

        public Model3dSource setUrl(String arg) {
            this.optimisticData.put(this.getKey("url"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "filesize": {
                    return false;
                }
                case "format": {
                    return false;
                }
                case "mimeType": {
                    return false;
                }
                case "url": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class Model3dSourceQuery
    extends Query<Model3dSourceQuery> {
        Model3dSourceQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public Model3dSourceQuery filesize() {
            this.startField("filesize");
            return this;
        }

        public Model3dSourceQuery format() {
            this.startField("format");
            return this;
        }

        public Model3dSourceQuery mimeType() {
            this.startField("mimeType");
            return this;
        }

        public Model3dSourceQuery url() {
            this.startField("url");
            return this;
        }
    }

    public static interface Model3dSourceQueryDefinition {
        public void define(Model3dSourceQuery var1);
    }

    public static class Model3d
    extends AbstractResponse<Model3d>
    implements Media,
    MetafieldReference,
    Node {
        public Model3d() {
        }

        public Model3d(JsonObject fields) throws SchemaViolationError {
            block18: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "alt": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block18;
                    }
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block18;
                    }
                    case "mediaContentType": {
                        this.responseData.put(key, MediaContentType.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block18;
                    }
                    case "presentation": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MediaPresentation(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block18;
                    }
                    case "previewImage": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Image(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block18;
                    }
                    case "sources": {
                        ArrayList<Model3dSource> list1 = new ArrayList<Model3dSource>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new Model3dSource(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block18;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block18;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public Model3d(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "Model3d";
        }

        @Override
        public String getAlt() {
            return (String)this.get("alt");
        }

        public Model3d setAlt(String arg) {
            this.optimisticData.put(this.getKey("alt"), arg);
            return this;
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        @Override
        public MediaContentType getMediaContentType() {
            return (MediaContentType)((Object)this.get("mediaContentType"));
        }

        public Model3d setMediaContentType(MediaContentType arg) {
            this.optimisticData.put(this.getKey("mediaContentType"), arg);
            return this;
        }

        @Override
        public MediaPresentation getPresentation() {
            return (MediaPresentation)this.get("presentation");
        }

        public Model3d setPresentation(MediaPresentation arg) {
            this.optimisticData.put(this.getKey("presentation"), arg);
            return this;
        }

        @Override
        public Image getPreviewImage() {
            return (Image)this.get("previewImage");
        }

        public Model3d setPreviewImage(Image arg) {
            this.optimisticData.put(this.getKey("previewImage"), arg);
            return this;
        }

        public List<Model3dSource> getSources() {
            return (List)this.get("sources");
        }

        public Model3d setSources(List<Model3dSource> arg) {
            this.optimisticData.put(this.getKey("sources"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "alt": {
                    return false;
                }
                case "id": {
                    return false;
                }
                case "mediaContentType": {
                    return false;
                }
                case "presentation": {
                    return true;
                }
                case "previewImage": {
                    return true;
                }
                case "sources": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class Model3dQuery
    extends Query<Model3dQuery> {
        Model3dQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public Model3dQuery alt() {
            this.startField("alt");
            return this;
        }

        public Model3dQuery mediaContentType() {
            this.startField("mediaContentType");
            return this;
        }

        public Model3dQuery presentation(MediaPresentationQueryDefinition queryDef) {
            this.startField("presentation");
            this._queryBuilder.append('{');
            queryDef.define(new MediaPresentationQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public Model3dQuery previewImage(ImageQueryDefinition queryDef) {
            this.startField("previewImage");
            this._queryBuilder.append('{');
            queryDef.define(new ImageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public Model3dQuery sources(Model3dSourceQueryDefinition queryDef) {
            this.startField("sources");
            this._queryBuilder.append('{');
            queryDef.define(new Model3dSourceQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface Model3dQueryDefinition {
        public void define(Model3dQuery var1);
    }

    public static class MetaobjectSEO
    extends AbstractResponse<MetaobjectSEO> {
        public MetaobjectSEO() {
        }

        public MetaobjectSEO(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "description": {
                        MetaobjectField optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MetaobjectField(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "title": {
                        MetaobjectField optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MetaobjectField(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "MetaobjectSEO";
        }

        public MetaobjectField getDescription() {
            return (MetaobjectField)this.get("description");
        }

        public MetaobjectSEO setDescription(MetaobjectField arg) {
            this.optimisticData.put(this.getKey("description"), arg);
            return this;
        }

        public MetaobjectField getTitle() {
            return (MetaobjectField)this.get("title");
        }

        public MetaobjectSEO setTitle(MetaobjectField arg) {
            this.optimisticData.put(this.getKey("title"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "description": {
                    return true;
                }
                case "title": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class MetaobjectSEOQuery
    extends Query<MetaobjectSEOQuery> {
        MetaobjectSEOQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public MetaobjectSEOQuery description(MetaobjectFieldQueryDefinition queryDef) {
            this.startField("description");
            this._queryBuilder.append('{');
            queryDef.define(new MetaobjectFieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetaobjectSEOQuery title(MetaobjectFieldQueryDefinition queryDef) {
            this.startField("title");
            this._queryBuilder.append('{');
            queryDef.define(new MetaobjectFieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface MetaobjectSEOQueryDefinition {
        public void define(MetaobjectSEOQuery var1);
    }

    public static class MetaobjectHandleInput
    implements Serializable {
        private String handle;
        private String type;

        public MetaobjectHandleInput(String handle, String type) {
            this.handle = handle;
            this.type = type;
        }

        public String getHandle() {
            return this.handle;
        }

        public MetaobjectHandleInput setHandle(String handle) {
            this.handle = handle;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public MetaobjectHandleInput setType(String type) {
            this.type = type;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("handle:");
            Query.appendQuotedString(_queryBuilder, this.handle.toString());
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("type:");
            Query.appendQuotedString(_queryBuilder, this.type.toString());
            _queryBuilder.append('}');
        }
    }

    public static class MetaobjectField
    extends AbstractResponse<MetaobjectField> {
        public MetaobjectField() {
        }

        public MetaobjectField(JsonObject fields) throws SchemaViolationError {
            block16: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "key": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "reference": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = UnknownMetafieldReference.create(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block16;
                    }
                    case "references": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MetafieldReferenceConnection(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block16;
                    }
                    case "type": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "value": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block16;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "MetaobjectField";
        }

        public String getKey() {
            return (String)this.get("key");
        }

        public MetaobjectField setKey(String arg) {
            this.optimisticData.put(this.getKey("key"), arg);
            return this;
        }

        public MetafieldReference getReference() {
            return (MetafieldReference)this.get("reference");
        }

        public MetaobjectField setReference(MetafieldReference arg) {
            this.optimisticData.put(this.getKey("reference"), arg);
            return this;
        }

        public MetafieldReferenceConnection getReferences() {
            return (MetafieldReferenceConnection)this.get("references");
        }

        public MetaobjectField setReferences(MetafieldReferenceConnection arg) {
            this.optimisticData.put(this.getKey("references"), arg);
            return this;
        }

        public String getType() {
            return (String)this.get("type");
        }

        public MetaobjectField setType(String arg) {
            this.optimisticData.put(this.getKey("type"), arg);
            return this;
        }

        public String getValue() {
            return (String)this.get("value");
        }

        public MetaobjectField setValue(String arg) {
            this.optimisticData.put(this.getKey("value"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "key": {
                    return false;
                }
                case "reference": {
                    return false;
                }
                case "references": {
                    return true;
                }
                case "type": {
                    return false;
                }
                case "value": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class MetaobjectFieldQuery
    extends Query<MetaobjectFieldQuery> {
        MetaobjectFieldQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public MetaobjectFieldQuery key() {
            this.startField("key");
            return this;
        }

        public MetaobjectFieldQuery reference(MetafieldReferenceQueryDefinition queryDef) {
            this.startField("reference");
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldReferenceQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetaobjectFieldQuery references(MetafieldReferenceConnectionQueryDefinition queryDef) {
            return this.references(args -> {}, queryDef);
        }

        public MetaobjectFieldQuery references(ReferencesArgumentsDefinition argsDef, MetafieldReferenceConnectionQueryDefinition queryDef) {
            this.startField("references");
            ReferencesArguments args = new ReferencesArguments(this._queryBuilder);
            argsDef.define(args);
            ReferencesArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldReferenceConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetaobjectFieldQuery type() {
            this.startField("type");
            return this;
        }

        public MetaobjectFieldQuery value() {
            this.startField("value");
            return this;
        }

        public static interface ReferencesArgumentsDefinition {
            public void define(ReferencesArguments var1);
        }

        public class ReferencesArguments
        extends Arguments {
            ReferencesArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public ReferencesArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    MetaobjectFieldQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public ReferencesArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(MetaobjectFieldQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public ReferencesArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    MetaobjectFieldQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public ReferencesArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(MetaobjectFieldQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }
    }

    public static interface MetaobjectFieldQueryDefinition {
        public void define(MetaobjectFieldQuery var1);
    }

    public static class MetaobjectEdge
    extends AbstractResponse<MetaobjectEdge> {
        public MetaobjectEdge() {
        }

        public MetaobjectEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, new Metaobject(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "MetaobjectEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public MetaobjectEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public Metaobject getNode() {
            return (Metaobject)this.get("node");
        }

        public MetaobjectEdge setNode(Metaobject arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class MetaobjectEdgeQuery
    extends Query<MetaobjectEdgeQuery> {
        MetaobjectEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public MetaobjectEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public MetaobjectEdgeQuery node(MetaobjectQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new MetaobjectQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface MetaobjectEdgeQueryDefinition {
        public void define(MetaobjectEdgeQuery var1);
    }

    public static class MetaobjectConnection
    extends AbstractResponse<MetaobjectConnection> {
        public MetaobjectConnection() {
        }

        public MetaobjectConnection(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<AbstractResponse> list1 = new ArrayList<AbstractResponse>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new MetaobjectEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "nodes": {
                        ArrayList<AbstractResponse> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new Metaobject(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "MetaobjectConnection";
        }

        public List<MetaobjectEdge> getEdges() {
            return (List)this.get("edges");
        }

        public MetaobjectConnection setEdges(List<MetaobjectEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<Metaobject> getNodes() {
            return (List)this.get("nodes");
        }

        public MetaobjectConnection setNodes(List<Metaobject> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public MetaobjectConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "nodes": {
                    return true;
                }
                case "pageInfo": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class MetaobjectConnectionQuery
    extends Query<MetaobjectConnectionQuery> {
        MetaobjectConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public MetaobjectConnectionQuery edges(MetaobjectEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new MetaobjectEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetaobjectConnectionQuery nodes(MetaobjectQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new MetaobjectQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetaobjectConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface MetaobjectConnectionQueryDefinition {
        public void define(MetaobjectConnectionQuery var1);
    }

    public static class Metaobject
    extends AbstractResponse<Metaobject>
    implements MenuItemResource,
    MetafieldReference,
    Node,
    OnlineStorePublishable {
        public Metaobject() {
        }

        public Metaobject(JsonObject fields) throws SchemaViolationError {
            block22: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "field": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MetaobjectField(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block22;
                    }
                    case "fields": {
                        ArrayList<MetaobjectField> list1 = new ArrayList<MetaobjectField>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new MetaobjectField(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block22;
                    }
                    case "handle": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block22;
                    }
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block22;
                    }
                    case "onlineStoreUrl": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block22;
                    }
                    case "seo": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MetaobjectSEO(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block22;
                    }
                    case "type": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block22;
                    }
                    case "updatedAt": {
                        this.responseData.put(key, Utils.parseDateTime(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block22;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block22;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public Metaobject(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "Metaobject";
        }

        public MetaobjectField getField() {
            return (MetaobjectField)this.get("field");
        }

        public Metaobject setField(MetaobjectField arg) {
            this.optimisticData.put(this.getKey("field"), arg);
            return this;
        }

        public List<MetaobjectField> getFields() {
            return (List)this.get("fields");
        }

        public Metaobject setFields(List<MetaobjectField> arg) {
            this.optimisticData.put(this.getKey("fields"), arg);
            return this;
        }

        public String getHandle() {
            return (String)this.get("handle");
        }

        public Metaobject setHandle(String arg) {
            this.optimisticData.put(this.getKey("handle"), arg);
            return this;
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        @Override
        public String getOnlineStoreUrl() {
            return (String)this.get("onlineStoreUrl");
        }

        public Metaobject setOnlineStoreUrl(String arg) {
            this.optimisticData.put(this.getKey("onlineStoreUrl"), arg);
            return this;
        }

        public MetaobjectSEO getSeo() {
            return (MetaobjectSEO)this.get("seo");
        }

        public Metaobject setSeo(MetaobjectSEO arg) {
            this.optimisticData.put(this.getKey("seo"), arg);
            return this;
        }

        public String getType() {
            return (String)this.get("type");
        }

        public Metaobject setType(String arg) {
            this.optimisticData.put(this.getKey("type"), arg);
            return this;
        }

        public DateTime getUpdatedAt() {
            return (DateTime)this.get("updatedAt");
        }

        public Metaobject setUpdatedAt(DateTime arg) {
            this.optimisticData.put(this.getKey("updatedAt"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "field": {
                    return true;
                }
                case "fields": {
                    return true;
                }
                case "handle": {
                    return false;
                }
                case "id": {
                    return false;
                }
                case "onlineStoreUrl": {
                    return false;
                }
                case "seo": {
                    return true;
                }
                case "type": {
                    return false;
                }
                case "updatedAt": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class MetaobjectQuery
    extends Query<MetaobjectQuery> {
        MetaobjectQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public MetaobjectQuery field(String key, MetaobjectFieldQueryDefinition queryDef) {
            this.startField("field");
            this._queryBuilder.append("(key:");
            Query.appendQuotedString(this._queryBuilder, key.toString());
            this._queryBuilder.append(')');
            this._queryBuilder.append('{');
            queryDef.define(new MetaobjectFieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetaobjectQuery fields(MetaobjectFieldQueryDefinition queryDef) {
            this.startField("fields");
            this._queryBuilder.append('{');
            queryDef.define(new MetaobjectFieldQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetaobjectQuery handle() {
            this.startField("handle");
            return this;
        }

        public MetaobjectQuery onlineStoreUrl() {
            this.startField("onlineStoreUrl");
            return this;
        }

        public MetaobjectQuery seo(MetaobjectSEOQueryDefinition queryDef) {
            this.startField("seo");
            this._queryBuilder.append('{');
            queryDef.define(new MetaobjectSEOQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetaobjectQuery type() {
            this.startField("type");
            return this;
        }

        public MetaobjectQuery updatedAt() {
            this.startField("updatedAt");
            return this;
        }
    }

    public static interface MetaobjectQueryDefinition {
        public void define(MetaobjectQuery var1);
    }

    public static enum MetafieldsSetUserErrorCode {
        BLANK,
        INCLUSION,
        INVALID_OWNER,
        INVALID_TYPE,
        INVALID_VALUE,
        LESS_THAN_OR_EQUAL_TO,
        PRESENT,
        TOO_LONG,
        TOO_SHORT,
        UNKNOWN_VALUE;


        public static MetafieldsSetUserErrorCode fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "BLANK": {
                    return BLANK;
                }
                case "INCLUSION": {
                    return INCLUSION;
                }
                case "INVALID_OWNER": {
                    return INVALID_OWNER;
                }
                case "INVALID_TYPE": {
                    return INVALID_TYPE;
                }
                case "INVALID_VALUE": {
                    return INVALID_VALUE;
                }
                case "LESS_THAN_OR_EQUAL_TO": {
                    return LESS_THAN_OR_EQUAL_TO;
                }
                case "PRESENT": {
                    return PRESENT;
                }
                case "TOO_LONG": {
                    return TOO_LONG;
                }
                case "TOO_SHORT": {
                    return TOO_SHORT;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case BLANK: {
                    return "BLANK";
                }
                case INCLUSION: {
                    return "INCLUSION";
                }
                case INVALID_OWNER: {
                    return "INVALID_OWNER";
                }
                case INVALID_TYPE: {
                    return "INVALID_TYPE";
                }
                case INVALID_VALUE: {
                    return "INVALID_VALUE";
                }
                case LESS_THAN_OR_EQUAL_TO: {
                    return "LESS_THAN_OR_EQUAL_TO";
                }
                case PRESENT: {
                    return "PRESENT";
                }
                case TOO_LONG: {
                    return "TOO_LONG";
                }
                case TOO_SHORT: {
                    return "TOO_SHORT";
                }
            }
            return "";
        }
    }

    public static class MetafieldsSetUserError
    extends AbstractResponse<MetafieldsSetUserError>
    implements DisplayableError {
        public MetafieldsSetUserError() {
        }

        public MetafieldsSetUserError(JsonObject fields) throws SchemaViolationError {
            block14: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "code": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = MetafieldsSetUserErrorCode.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block14;
                    }
                    case "elementIndex": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsInteger((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block14;
                    }
                    case "field": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            ArrayList<String> list1 = new ArrayList<String>();
                            for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                                list1.add(this.jsonAsString(element1, key));
                            }
                            optional1 = list1;
                        }
                        this.responseData.put(key, optional1);
                        continue block14;
                    }
                    case "message": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block14;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "MetafieldsSetUserError";
        }

        public MetafieldsSetUserErrorCode getCode() {
            return (MetafieldsSetUserErrorCode)((Object)this.get("code"));
        }

        public MetafieldsSetUserError setCode(MetafieldsSetUserErrorCode arg) {
            this.optimisticData.put(this.getKey("code"), arg);
            return this;
        }

        public Integer getElementIndex() {
            return (Integer)this.get("elementIndex");
        }

        public MetafieldsSetUserError setElementIndex(Integer arg) {
            this.optimisticData.put(this.getKey("elementIndex"), arg);
            return this;
        }

        @Override
        public List<String> getField() {
            return (List)this.get("field");
        }

        public MetafieldsSetUserError setField(List<String> arg) {
            this.optimisticData.put(this.getKey("field"), arg);
            return this;
        }

        @Override
        public String getMessage() {
            return (String)this.get("message");
        }

        public MetafieldsSetUserError setMessage(String arg) {
            this.optimisticData.put(this.getKey("message"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "code": {
                    return false;
                }
                case "elementIndex": {
                    return false;
                }
                case "field": {
                    return false;
                }
                case "message": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class MetafieldsSetUserErrorQuery
    extends Query<MetafieldsSetUserErrorQuery> {
        MetafieldsSetUserErrorQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public MetafieldsSetUserErrorQuery code() {
            this.startField("code");
            return this;
        }

        public MetafieldsSetUserErrorQuery elementIndex() {
            this.startField("elementIndex");
            return this;
        }

        public MetafieldsSetUserErrorQuery field() {
            this.startField("field");
            return this;
        }

        public MetafieldsSetUserErrorQuery message() {
            this.startField("message");
            return this;
        }
    }

    public static interface MetafieldsSetUserErrorQueryDefinition {
        public void define(MetafieldsSetUserErrorQuery var1);
    }

    public static class MetafieldReferenceEdge
    extends AbstractResponse<MetafieldReferenceEdge> {
        public MetafieldReferenceEdge() {
        }

        public MetafieldReferenceEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, UnknownMetafieldReference.create(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "MetafieldReferenceEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public MetafieldReferenceEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public MetafieldReference getNode() {
            return (MetafieldReference)this.get("node");
        }

        public MetafieldReferenceEdge setNode(MetafieldReference arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class MetafieldReferenceEdgeQuery
    extends Query<MetafieldReferenceEdgeQuery> {
        MetafieldReferenceEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public MetafieldReferenceEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public MetafieldReferenceEdgeQuery node(MetafieldReferenceQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldReferenceQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface MetafieldReferenceEdgeQueryDefinition {
        public void define(MetafieldReferenceEdgeQuery var1);
    }

    public static class MetafieldReferenceConnection
    extends AbstractResponse<MetafieldReferenceConnection> {
        public MetafieldReferenceConnection() {
        }

        public MetafieldReferenceConnection(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<Object> list1 = new ArrayList<Object>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new MetafieldReferenceEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "nodes": {
                        ArrayList<Object> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(UnknownMetafieldReference.create(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "MetafieldReferenceConnection";
        }

        public List<MetafieldReferenceEdge> getEdges() {
            return (List)this.get("edges");
        }

        public MetafieldReferenceConnection setEdges(List<MetafieldReferenceEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<MetafieldReference> getNodes() {
            return (List)this.get("nodes");
        }

        public MetafieldReferenceConnection setNodes(List<MetafieldReference> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public MetafieldReferenceConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "nodes": {
                    return false;
                }
                case "pageInfo": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class MetafieldReferenceConnectionQuery
    extends Query<MetafieldReferenceConnectionQuery> {
        MetafieldReferenceConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public MetafieldReferenceConnectionQuery edges(MetafieldReferenceEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldReferenceEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldReferenceConnectionQuery nodes(MetafieldReferenceQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldReferenceQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldReferenceConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface MetafieldReferenceConnectionQueryDefinition {
        public void define(MetafieldReferenceConnectionQuery var1);
    }

    public static class UnknownMetafieldReference
    extends AbstractResponse<UnknownMetafieldReference>
    implements MetafieldReference {
        public UnknownMetafieldReference() {
        }

        public UnknownMetafieldReference(JsonObject fields) throws SchemaViolationError {
            block6: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block6;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public static MetafieldReference create(JsonObject fields) throws SchemaViolationError {
            String typeName;
            switch (typeName = fields.getAsJsonPrimitive("__typename").getAsString()) {
                case "Collection": {
                    return new Collection(fields);
                }
                case "GenericFile": {
                    return new GenericFile(fields);
                }
                case "MediaImage": {
                    return new MediaImage(fields);
                }
                case "Metaobject": {
                    return new Metaobject(fields);
                }
                case "Model3d": {
                    return new Model3d(fields);
                }
                case "Page": {
                    return new Page(fields);
                }
                case "Product": {
                    return new Product(fields);
                }
                case "ProductVariant": {
                    return new ProductVariant(fields);
                }
                case "Video": {
                    return new Video(fields);
                }
            }
            return new UnknownMetafieldReference(fields);
        }

        @Override
        public String getGraphQlTypeName() {
            return (String)this.get("__typename");
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                default: 
            }
            return false;
        }
    }

    public static interface MetafieldReference {
        public String getGraphQlTypeName();
    }

    public static class MetafieldReferenceQuery
    extends Query<MetafieldReferenceQuery> {
        MetafieldReferenceQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("__typename");
        }

        public MetafieldReferenceQuery onCollection(CollectionQueryDefinition queryDef) {
            this.startInlineFragment("Collection");
            queryDef.define(new CollectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldReferenceQuery onGenericFile(GenericFileQueryDefinition queryDef) {
            this.startInlineFragment("GenericFile");
            queryDef.define(new GenericFileQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldReferenceQuery onMediaImage(MediaImageQueryDefinition queryDef) {
            this.startInlineFragment("MediaImage");
            queryDef.define(new MediaImageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldReferenceQuery onMetaobject(MetaobjectQueryDefinition queryDef) {
            this.startInlineFragment("Metaobject");
            queryDef.define(new MetaobjectQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldReferenceQuery onModel3d(Model3dQueryDefinition queryDef) {
            this.startInlineFragment("Model3d");
            queryDef.define(new Model3dQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldReferenceQuery onPage(PageQueryDefinition queryDef) {
            this.startInlineFragment("Page");
            queryDef.define(new PageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldReferenceQuery onProduct(ProductQueryDefinition queryDef) {
            this.startInlineFragment("Product");
            queryDef.define(new ProductQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldReferenceQuery onProductVariant(ProductVariantQueryDefinition queryDef) {
            this.startInlineFragment("ProductVariant");
            queryDef.define(new ProductVariantQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldReferenceQuery onVideo(VideoQueryDefinition queryDef) {
            this.startInlineFragment("Video");
            queryDef.define(new VideoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface MetafieldReferenceQueryDefinition {
        public void define(MetafieldReferenceQuery var1);
    }

    public static class UnknownMetafieldParentResource
    extends AbstractResponse<UnknownMetafieldParentResource>
    implements MetafieldParentResource {
        public UnknownMetafieldParentResource() {
        }

        public UnknownMetafieldParentResource(JsonObject fields) throws SchemaViolationError {
            block6: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block6;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public static MetafieldParentResource create(JsonObject fields) throws SchemaViolationError {
            String typeName;
            switch (typeName = fields.getAsJsonPrimitive("__typename").getAsString()) {
                case "Article": {
                    return new Article(fields);
                }
                case "Blog": {
                    return new Blog(fields);
                }
                case "Cart": {
                    return new Cart(fields);
                }
                case "Collection": {
                    return new Collection(fields);
                }
                case "Company": {
                    return new Company(fields);
                }
                case "CompanyLocation": {
                    return new CompanyLocation(fields);
                }
                case "Customer": {
                    return new Customer(fields);
                }
                case "Location": {
                    return new Location(fields);
                }
                case "Market": {
                    return new Market(fields);
                }
                case "Order": {
                    return new Order(fields);
                }
                case "Page": {
                    return new Page(fields);
                }
                case "Product": {
                    return new Product(fields);
                }
                case "ProductVariant": {
                    return new ProductVariant(fields);
                }
                case "SellingPlan": {
                    return new SellingPlan(fields);
                }
                case "Shop": {
                    return new Shop(fields);
                }
            }
            return new UnknownMetafieldParentResource(fields);
        }

        @Override
        public String getGraphQlTypeName() {
            return (String)this.get("__typename");
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                default: 
            }
            return false;
        }
    }

    public static interface MetafieldParentResource {
        public String getGraphQlTypeName();
    }

    public static class MetafieldParentResourceQuery
    extends Query<MetafieldParentResourceQuery> {
        MetafieldParentResourceQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("__typename");
        }

        public MetafieldParentResourceQuery onArticle(ArticleQueryDefinition queryDef) {
            this.startInlineFragment("Article");
            queryDef.define(new ArticleQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldParentResourceQuery onBlog(BlogQueryDefinition queryDef) {
            this.startInlineFragment("Blog");
            queryDef.define(new BlogQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldParentResourceQuery onCart(CartQueryDefinition queryDef) {
            this.startInlineFragment("Cart");
            queryDef.define(new CartQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldParentResourceQuery onCollection(CollectionQueryDefinition queryDef) {
            this.startInlineFragment("Collection");
            queryDef.define(new CollectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldParentResourceQuery onCompany(CompanyQueryDefinition queryDef) {
            this.startInlineFragment("Company");
            queryDef.define(new CompanyQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldParentResourceQuery onCompanyLocation(CompanyLocationQueryDefinition queryDef) {
            this.startInlineFragment("CompanyLocation");
            queryDef.define(new CompanyLocationQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldParentResourceQuery onCustomer(CustomerQueryDefinition queryDef) {
            this.startInlineFragment("Customer");
            queryDef.define(new CustomerQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldParentResourceQuery onLocation(LocationQueryDefinition queryDef) {
            this.startInlineFragment("Location");
            queryDef.define(new LocationQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldParentResourceQuery onMarket(MarketQueryDefinition queryDef) {
            this.startInlineFragment("Market");
            queryDef.define(new MarketQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldParentResourceQuery onOrder(OrderQueryDefinition queryDef) {
            this.startInlineFragment("Order");
            queryDef.define(new OrderQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldParentResourceQuery onPage(PageQueryDefinition queryDef) {
            this.startInlineFragment("Page");
            queryDef.define(new PageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldParentResourceQuery onProduct(ProductQueryDefinition queryDef) {
            this.startInlineFragment("Product");
            queryDef.define(new ProductQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldParentResourceQuery onProductVariant(ProductVariantQueryDefinition queryDef) {
            this.startInlineFragment("ProductVariant");
            queryDef.define(new ProductVariantQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldParentResourceQuery onSellingPlan(SellingPlanQueryDefinition queryDef) {
            this.startInlineFragment("SellingPlan");
            queryDef.define(new SellingPlanQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldParentResourceQuery onShop(ShopQueryDefinition queryDef) {
            this.startInlineFragment("Shop");
            queryDef.define(new ShopQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface MetafieldParentResourceQueryDefinition {
        public void define(MetafieldParentResourceQuery var1);
    }

    public static class MetafieldFilter
    implements Serializable {
        private String namespace;
        private String key;
        private String value;

        public MetafieldFilter(String namespace, String key, String value) {
            this.namespace = namespace;
            this.key = key;
            this.value = value;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public MetafieldFilter setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public String getKey() {
            return this.key;
        }

        public MetafieldFilter setKey(String key) {
            this.key = key;
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public MetafieldFilter setValue(String value) {
            this.value = value;
            return this;
        }

        public void appendTo(StringBuilder _queryBuilder) {
            String separator = "";
            _queryBuilder.append('{');
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("namespace:");
            Query.appendQuotedString(_queryBuilder, this.namespace.toString());
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("key:");
            Query.appendQuotedString(_queryBuilder, this.key.toString());
            _queryBuilder.append(separator);
            separator = ",";
            _queryBuilder.append("value:");
            Query.appendQuotedString(_queryBuilder, this.value.toString());
            _queryBuilder.append('}');
        }
    }

    public static class MetafieldDeleteUserError
    extends AbstractResponse<MetafieldDeleteUserError>
    implements DisplayableError {
        public MetafieldDeleteUserError() {
        }

        public MetafieldDeleteUserError(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "code": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = MetafieldDeleteErrorCode.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block12;
                    }
                    case "field": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            ArrayList<String> list1 = new ArrayList<String>();
                            for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                                list1.add(this.jsonAsString(element1, key));
                            }
                            optional1 = list1;
                        }
                        this.responseData.put(key, optional1);
                        continue block12;
                    }
                    case "message": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        @Override
        public String getGraphQlTypeName() {
            return "MetafieldDeleteUserError";
        }

        public MetafieldDeleteErrorCode getCode() {
            return (MetafieldDeleteErrorCode)((Object)this.get("code"));
        }

        public MetafieldDeleteUserError setCode(MetafieldDeleteErrorCode arg) {
            this.optimisticData.put(this.getKey("code"), arg);
            return this;
        }

        @Override
        public List<String> getField() {
            return (List)this.get("field");
        }

        public MetafieldDeleteUserError setField(List<String> arg) {
            this.optimisticData.put(this.getKey("field"), arg);
            return this;
        }

        @Override
        public String getMessage() {
            return (String)this.get("message");
        }

        public MetafieldDeleteUserError setMessage(String arg) {
            this.optimisticData.put(this.getKey("message"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "code": {
                    return false;
                }
                case "field": {
                    return false;
                }
                case "message": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class MetafieldDeleteUserErrorQuery
    extends Query<MetafieldDeleteUserErrorQuery> {
        MetafieldDeleteUserErrorQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public MetafieldDeleteUserErrorQuery code() {
            this.startField("code");
            return this;
        }

        public MetafieldDeleteUserErrorQuery field() {
            this.startField("field");
            return this;
        }

        public MetafieldDeleteUserErrorQuery message() {
            this.startField("message");
            return this;
        }
    }

    public static interface MetafieldDeleteUserErrorQueryDefinition {
        public void define(MetafieldDeleteUserErrorQuery var1);
    }

    public static enum MetafieldDeleteErrorCode {
        INVALID_OWNER,
        METAFIELD_DOES_NOT_EXIST,
        UNKNOWN_VALUE;


        public static MetafieldDeleteErrorCode fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "INVALID_OWNER": {
                    return INVALID_OWNER;
                }
                case "METAFIELD_DOES_NOT_EXIST": {
                    return METAFIELD_DOES_NOT_EXIST;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case INVALID_OWNER: {
                    return "INVALID_OWNER";
                }
                case METAFIELD_DOES_NOT_EXIST: {
                    return "METAFIELD_DOES_NOT_EXIST";
                }
            }
            return "";
        }
    }

    public static class Metafield
    extends AbstractResponse<Metafield>
    implements Node {
        public Metafield() {
        }

        public Metafield(JsonObject fields) throws SchemaViolationError {
            block28: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "createdAt": {
                        this.responseData.put(key, Utils.parseDateTime(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block28;
                    }
                    case "description": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block28;
                    }
                    case "key": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                    case "namespace": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                    case "parentResource": {
                        this.responseData.put(key, UnknownMetafieldParentResource.create(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block28;
                    }
                    case "reference": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = UnknownMetafieldReference.create(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "references": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MetafieldReferenceConnection(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block28;
                    }
                    case "type": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                    case "updatedAt": {
                        this.responseData.put(key, Utils.parseDateTime(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block28;
                    }
                    case "value": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block28;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public Metafield(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "Metafield";
        }

        public DateTime getCreatedAt() {
            return (DateTime)this.get("createdAt");
        }

        public Metafield setCreatedAt(DateTime arg) {
            this.optimisticData.put(this.getKey("createdAt"), arg);
            return this;
        }

        public String getDescription() {
            return (String)this.get("description");
        }

        public Metafield setDescription(String arg) {
            this.optimisticData.put(this.getKey("description"), arg);
            return this;
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        public String getKey() {
            return (String)this.get("key");
        }

        public Metafield setKey(String arg) {
            this.optimisticData.put(this.getKey("key"), arg);
            return this;
        }

        public String getNamespace() {
            return (String)this.get("namespace");
        }

        public Metafield setNamespace(String arg) {
            this.optimisticData.put(this.getKey("namespace"), arg);
            return this;
        }

        public MetafieldParentResource getParentResource() {
            return (MetafieldParentResource)this.get("parentResource");
        }

        public Metafield setParentResource(MetafieldParentResource arg) {
            this.optimisticData.put(this.getKey("parentResource"), arg);
            return this;
        }

        public MetafieldReference getReference() {
            return (MetafieldReference)this.get("reference");
        }

        public Metafield setReference(MetafieldReference arg) {
            this.optimisticData.put(this.getKey("reference"), arg);
            return this;
        }

        public MetafieldReferenceConnection getReferences() {
            return (MetafieldReferenceConnection)this.get("references");
        }

        public Metafield setReferences(MetafieldReferenceConnection arg) {
            this.optimisticData.put(this.getKey("references"), arg);
            return this;
        }

        public String getType() {
            return (String)this.get("type");
        }

        public Metafield setType(String arg) {
            this.optimisticData.put(this.getKey("type"), arg);
            return this;
        }

        public DateTime getUpdatedAt() {
            return (DateTime)this.get("updatedAt");
        }

        public Metafield setUpdatedAt(DateTime arg) {
            this.optimisticData.put(this.getKey("updatedAt"), arg);
            return this;
        }

        public String getValue() {
            return (String)this.get("value");
        }

        public Metafield setValue(String arg) {
            this.optimisticData.put(this.getKey("value"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "createdAt": {
                    return false;
                }
                case "description": {
                    return false;
                }
                case "id": {
                    return false;
                }
                case "key": {
                    return false;
                }
                case "namespace": {
                    return false;
                }
                case "parentResource": {
                    return false;
                }
                case "reference": {
                    return false;
                }
                case "references": {
                    return true;
                }
                case "type": {
                    return false;
                }
                case "updatedAt": {
                    return false;
                }
                case "value": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class MetafieldQuery
    extends Query<MetafieldQuery> {
        MetafieldQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public MetafieldQuery createdAt() {
            this.startField("createdAt");
            return this;
        }

        public MetafieldQuery description() {
            this.startField("description");
            return this;
        }

        public MetafieldQuery key() {
            this.startField("key");
            return this;
        }

        public MetafieldQuery namespace() {
            this.startField("namespace");
            return this;
        }

        public MetafieldQuery parentResource(MetafieldParentResourceQueryDefinition queryDef) {
            this.startField("parentResource");
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldParentResourceQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldQuery reference(MetafieldReferenceQueryDefinition queryDef) {
            this.startField("reference");
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldReferenceQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldQuery references(MetafieldReferenceConnectionQueryDefinition queryDef) {
            return this.references(args -> {}, queryDef);
        }

        public MetafieldQuery references(ReferencesArgumentsDefinition argsDef, MetafieldReferenceConnectionQueryDefinition queryDef) {
            this.startField("references");
            ReferencesArguments args = new ReferencesArguments(this._queryBuilder);
            argsDef.define(args);
            ReferencesArguments.end(args);
            this._queryBuilder.append('{');
            queryDef.define(new MetafieldReferenceConnectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MetafieldQuery type() {
            this.startField("type");
            return this;
        }

        public MetafieldQuery updatedAt() {
            this.startField("updatedAt");
            return this;
        }

        public MetafieldQuery value() {
            this.startField("value");
            return this;
        }

        public static interface ReferencesArgumentsDefinition {
            public void define(ReferencesArguments var1);
        }

        public class ReferencesArguments
        extends Arguments {
            ReferencesArguments(StringBuilder _queryBuilder) {
                super(_queryBuilder, true);
            }

            public ReferencesArguments first(Integer value) {
                if (value != null) {
                    this.startArgument("first");
                    MetafieldQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public ReferencesArguments after(String value) {
                if (value != null) {
                    this.startArgument("after");
                    Query.appendQuotedString(MetafieldQuery.this._queryBuilder, value.toString());
                }
                return this;
            }

            public ReferencesArguments last(Integer value) {
                if (value != null) {
                    this.startArgument("last");
                    MetafieldQuery.this._queryBuilder.append(value);
                }
                return this;
            }

            public ReferencesArguments before(String value) {
                if (value != null) {
                    this.startArgument("before");
                    Query.appendQuotedString(MetafieldQuery.this._queryBuilder, value.toString());
                }
                return this;
            }
        }
    }

    public static interface MetafieldQueryDefinition {
        public void define(MetafieldQuery var1);
    }

    public static class UnknownMerchandise
    extends AbstractResponse<UnknownMerchandise>
    implements Merchandise {
        public UnknownMerchandise() {
        }

        public UnknownMerchandise(JsonObject fields) throws SchemaViolationError {
            block6: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block6;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public static Merchandise create(JsonObject fields) throws SchemaViolationError {
            String typeName;
            switch (typeName = fields.getAsJsonPrimitive("__typename").getAsString()) {
                case "ProductVariant": {
                    return new ProductVariant(fields);
                }
            }
            return new UnknownMerchandise(fields);
        }

        @Override
        public String getGraphQlTypeName() {
            return (String)this.get("__typename");
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                default: 
            }
            return false;
        }
    }

    public static interface Merchandise {
        public String getGraphQlTypeName();
    }

    public static class MerchandiseQuery
    extends Query<MerchandiseQuery> {
        MerchandiseQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("__typename");
        }

        public MerchandiseQuery onProductVariant(ProductVariantQueryDefinition queryDef) {
            this.startInlineFragment("ProductVariant");
            queryDef.define(new ProductVariantQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface MerchandiseQueryDefinition {
        public void define(MerchandiseQuery var1);
    }

    public static enum MenuItemType {
        ARTICLE,
        BLOG,
        CATALOG,
        COLLECTION,
        COLLECTIONS,
        FRONTPAGE,
        HTTP,
        METAOBJECT,
        PAGE,
        PRODUCT,
        SEARCH,
        SHOP_POLICY,
        UNKNOWN_VALUE;


        public static MenuItemType fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "ARTICLE": {
                    return ARTICLE;
                }
                case "BLOG": {
                    return BLOG;
                }
                case "CATALOG": {
                    return CATALOG;
                }
                case "COLLECTION": {
                    return COLLECTION;
                }
                case "COLLECTIONS": {
                    return COLLECTIONS;
                }
                case "FRONTPAGE": {
                    return FRONTPAGE;
                }
                case "HTTP": {
                    return HTTP;
                }
                case "METAOBJECT": {
                    return METAOBJECT;
                }
                case "PAGE": {
                    return PAGE;
                }
                case "PRODUCT": {
                    return PRODUCT;
                }
                case "SEARCH": {
                    return SEARCH;
                }
                case "SHOP_POLICY": {
                    return SHOP_POLICY;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case ARTICLE: {
                    return "ARTICLE";
                }
                case BLOG: {
                    return "BLOG";
                }
                case CATALOG: {
                    return "CATALOG";
                }
                case COLLECTION: {
                    return "COLLECTION";
                }
                case COLLECTIONS: {
                    return "COLLECTIONS";
                }
                case FRONTPAGE: {
                    return "FRONTPAGE";
                }
                case HTTP: {
                    return "HTTP";
                }
                case METAOBJECT: {
                    return "METAOBJECT";
                }
                case PAGE: {
                    return "PAGE";
                }
                case PRODUCT: {
                    return "PRODUCT";
                }
                case SEARCH: {
                    return "SEARCH";
                }
                case SHOP_POLICY: {
                    return "SHOP_POLICY";
                }
            }
            return "";
        }
    }

    public static class UnknownMenuItemResource
    extends AbstractResponse<UnknownMenuItemResource>
    implements MenuItemResource {
        public UnknownMenuItemResource() {
        }

        public UnknownMenuItemResource(JsonObject fields) throws SchemaViolationError {
            block6: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block6;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public static MenuItemResource create(JsonObject fields) throws SchemaViolationError {
            String typeName;
            switch (typeName = fields.getAsJsonPrimitive("__typename").getAsString()) {
                case "Article": {
                    return new Article(fields);
                }
                case "Blog": {
                    return new Blog(fields);
                }
                case "Collection": {
                    return new Collection(fields);
                }
                case "Metaobject": {
                    return new Metaobject(fields);
                }
                case "Page": {
                    return new Page(fields);
                }
                case "Product": {
                    return new Product(fields);
                }
                case "ShopPolicy": {
                    return new ShopPolicy(fields);
                }
            }
            return new UnknownMenuItemResource(fields);
        }

        @Override
        public String getGraphQlTypeName() {
            return (String)this.get("__typename");
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                default: 
            }
            return false;
        }
    }

    public static interface MenuItemResource {
        public String getGraphQlTypeName();
    }

    public static class MenuItemResourceQuery
    extends Query<MenuItemResourceQuery> {
        MenuItemResourceQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("__typename");
        }

        public MenuItemResourceQuery onArticle(ArticleQueryDefinition queryDef) {
            this.startInlineFragment("Article");
            queryDef.define(new ArticleQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MenuItemResourceQuery onBlog(BlogQueryDefinition queryDef) {
            this.startInlineFragment("Blog");
            queryDef.define(new BlogQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MenuItemResourceQuery onCollection(CollectionQueryDefinition queryDef) {
            this.startInlineFragment("Collection");
            queryDef.define(new CollectionQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MenuItemResourceQuery onMetaobject(MetaobjectQueryDefinition queryDef) {
            this.startInlineFragment("Metaobject");
            queryDef.define(new MetaobjectQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MenuItemResourceQuery onPage(PageQueryDefinition queryDef) {
            this.startInlineFragment("Page");
            queryDef.define(new PageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MenuItemResourceQuery onProduct(ProductQueryDefinition queryDef) {
            this.startInlineFragment("Product");
            queryDef.define(new ProductQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MenuItemResourceQuery onShopPolicy(ShopPolicyQueryDefinition queryDef) {
            this.startInlineFragment("ShopPolicy");
            queryDef.define(new ShopPolicyQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface MenuItemResourceQueryDefinition {
        public void define(MenuItemResourceQuery var1);
    }

    public static class MenuItem
    extends AbstractResponse<MenuItem>
    implements Node {
        public MenuItem() {
        }

        public MenuItem(JsonObject fields) throws SchemaViolationError {
            block22: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block22;
                    }
                    case "items": {
                        ArrayList<Object> list1 = new ArrayList<Object>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new MenuItem(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block22;
                    }
                    case "resource": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = UnknownMenuItemResource.create(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block22;
                    }
                    case "resourceId": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new ID(this.jsonAsString((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block22;
                    }
                    case "tags": {
                        ArrayList<Object> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(this.jsonAsString(element1, key));
                        }
                        this.responseData.put(key, list1);
                        continue block22;
                    }
                    case "title": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block22;
                    }
                    case "type": {
                        this.responseData.put(key, MenuItemType.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block22;
                    }
                    case "url": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block22;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block22;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public MenuItem(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "MenuItem";
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        public List<MenuItem> getItems() {
            return (List)this.get("items");
        }

        public MenuItem setItems(List<MenuItem> arg) {
            this.optimisticData.put(this.getKey("items"), arg);
            return this;
        }

        public MenuItemResource getResource() {
            return (MenuItemResource)this.get("resource");
        }

        public MenuItem setResource(MenuItemResource arg) {
            this.optimisticData.put(this.getKey("resource"), arg);
            return this;
        }

        public ID getResourceId() {
            return (ID)this.get("resourceId");
        }

        public MenuItem setResourceId(ID arg) {
            this.optimisticData.put(this.getKey("resourceId"), arg);
            return this;
        }

        public List<String> getTags() {
            return (List)this.get("tags");
        }

        public MenuItem setTags(List<String> arg) {
            this.optimisticData.put(this.getKey("tags"), arg);
            return this;
        }

        public String getTitle() {
            return (String)this.get("title");
        }

        public MenuItem setTitle(String arg) {
            this.optimisticData.put(this.getKey("title"), arg);
            return this;
        }

        public MenuItemType getType() {
            return (MenuItemType)((Object)this.get("type"));
        }

        public MenuItem setType(MenuItemType arg) {
            this.optimisticData.put(this.getKey("type"), arg);
            return this;
        }

        public String getUrl() {
            return (String)this.get("url");
        }

        public MenuItem setUrl(String arg) {
            this.optimisticData.put(this.getKey("url"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "id": {
                    return false;
                }
                case "items": {
                    return true;
                }
                case "resource": {
                    return false;
                }
                case "resourceId": {
                    return false;
                }
                case "tags": {
                    return false;
                }
                case "title": {
                    return false;
                }
                case "type": {
                    return false;
                }
                case "url": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class MenuItemQuery
    extends Query<MenuItemQuery> {
        MenuItemQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public MenuItemQuery items(MenuItemQueryDefinition queryDef) {
            this.startField("items");
            this._queryBuilder.append('{');
            queryDef.define(new MenuItemQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MenuItemQuery resource(MenuItemResourceQueryDefinition queryDef) {
            this.startField("resource");
            this._queryBuilder.append('{');
            queryDef.define(new MenuItemResourceQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MenuItemQuery resourceId() {
            this.startField("resourceId");
            return this;
        }

        public MenuItemQuery tags() {
            this.startField("tags");
            return this;
        }

        public MenuItemQuery title() {
            this.startField("title");
            return this;
        }

        public MenuItemQuery type() {
            this.startField("type");
            return this;
        }

        public MenuItemQuery url() {
            this.startField("url");
            return this;
        }
    }

    public static interface MenuItemQueryDefinition {
        public void define(MenuItemQuery var1);
    }

    public static class Menu
    extends AbstractResponse<Menu>
    implements Node {
        public Menu() {
        }

        public Menu(JsonObject fields) throws SchemaViolationError {
            block16: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "handle": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block16;
                    }
                    case "items": {
                        ArrayList<MenuItem> list1 = new ArrayList<MenuItem>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new MenuItem(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block16;
                    }
                    case "itemsCount": {
                        this.responseData.put(key, this.jsonAsInteger((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "title": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public Menu(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "Menu";
        }

        public String getHandle() {
            return (String)this.get("handle");
        }

        public Menu setHandle(String arg) {
            this.optimisticData.put(this.getKey("handle"), arg);
            return this;
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        public List<MenuItem> getItems() {
            return (List)this.get("items");
        }

        public Menu setItems(List<MenuItem> arg) {
            this.optimisticData.put(this.getKey("items"), arg);
            return this;
        }

        public Integer getItemsCount() {
            return (Integer)this.get("itemsCount");
        }

        public Menu setItemsCount(Integer arg) {
            this.optimisticData.put(this.getKey("itemsCount"), arg);
            return this;
        }

        public String getTitle() {
            return (String)this.get("title");
        }

        public Menu setTitle(String arg) {
            this.optimisticData.put(this.getKey("title"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "handle": {
                    return false;
                }
                case "id": {
                    return false;
                }
                case "items": {
                    return true;
                }
                case "itemsCount": {
                    return false;
                }
                case "title": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class MenuQuery
    extends Query<MenuQuery> {
        MenuQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public MenuQuery handle() {
            this.startField("handle");
            return this;
        }

        public MenuQuery items(MenuItemQueryDefinition queryDef) {
            this.startField("items");
            this._queryBuilder.append('{');
            queryDef.define(new MenuItemQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MenuQuery itemsCount() {
            this.startField("itemsCount");
            return this;
        }

        public MenuQuery title() {
            this.startField("title");
            return this;
        }
    }

    public static interface MenuQueryDefinition {
        public void define(MenuQuery var1);
    }

    public static enum MediaPresentationFormat {
        IMAGE,
        MODEL_VIEWER,
        UNKNOWN_VALUE;


        public static MediaPresentationFormat fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "IMAGE": {
                    return IMAGE;
                }
                case "MODEL_VIEWER": {
                    return MODEL_VIEWER;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case IMAGE: {
                    return "IMAGE";
                }
                case MODEL_VIEWER: {
                    return "MODEL_VIEWER";
                }
            }
            return "";
        }
    }

    public static class MediaPresentation
    extends AbstractResponse<MediaPresentation>
    implements Node {
        public MediaPresentation() {
        }

        public MediaPresentation(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "asJson": {
                        String optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block10;
                    }
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public MediaPresentation(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "MediaPresentation";
        }

        public String getAsJson() {
            return (String)this.get("asJson");
        }

        public MediaPresentation setAsJson(String arg) {
            this.optimisticData.put(this.getKey("asJson"), arg);
            return this;
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "asJson": {
                    return false;
                }
                case "id": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class MediaPresentationQuery
    extends Query<MediaPresentationQuery> {
        MediaPresentationQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public MediaPresentationQuery asJson(MediaPresentationFormat format) {
            this.startField("asJson");
            this._queryBuilder.append("(format:");
            this._queryBuilder.append(format.toString());
            this._queryBuilder.append(')');
            return this;
        }
    }

    public static interface MediaPresentationQueryDefinition {
        public void define(MediaPresentationQuery var1);
    }

    public static class MediaImage
    extends AbstractResponse<MediaImage>
    implements Media,
    MetafieldReference,
    Node {
        public MediaImage() {
        }

        public MediaImage(JsonObject fields) throws SchemaViolationError {
            block18: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "alt": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block18;
                    }
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block18;
                    }
                    case "image": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Image(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block18;
                    }
                    case "mediaContentType": {
                        this.responseData.put(key, MediaContentType.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block18;
                    }
                    case "presentation": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MediaPresentation(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block18;
                    }
                    case "previewImage": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Image(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block18;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block18;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public MediaImage(ID id) {
            this();
            this.optimisticData.put("id", id);
        }

        @Override
        public String getGraphQlTypeName() {
            return "MediaImage";
        }

        @Override
        public String getAlt() {
            return (String)this.get("alt");
        }

        public MediaImage setAlt(String arg) {
            this.optimisticData.put(this.getKey("alt"), arg);
            return this;
        }

        @Override
        public ID getId() {
            return (ID)this.get("id");
        }

        public Image getImage() {
            return (Image)this.get("image");
        }

        public MediaImage setImage(Image arg) {
            this.optimisticData.put(this.getKey("image"), arg);
            return this;
        }

        @Override
        public MediaContentType getMediaContentType() {
            return (MediaContentType)((Object)this.get("mediaContentType"));
        }

        public MediaImage setMediaContentType(MediaContentType arg) {
            this.optimisticData.put(this.getKey("mediaContentType"), arg);
            return this;
        }

        @Override
        public MediaPresentation getPresentation() {
            return (MediaPresentation)this.get("presentation");
        }

        public MediaImage setPresentation(MediaPresentation arg) {
            this.optimisticData.put(this.getKey("presentation"), arg);
            return this;
        }

        @Override
        public Image getPreviewImage() {
            return (Image)this.get("previewImage");
        }

        public MediaImage setPreviewImage(Image arg) {
            this.optimisticData.put(this.getKey("previewImage"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "alt": {
                    return false;
                }
                case "id": {
                    return false;
                }
                case "image": {
                    return true;
                }
                case "mediaContentType": {
                    return false;
                }
                case "presentation": {
                    return true;
                }
                case "previewImage": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class MediaImageQuery
    extends Query<MediaImageQuery> {
        MediaImageQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
            this.startField("id");
        }

        public MediaImageQuery alt() {
            this.startField("alt");
            return this;
        }

        public MediaImageQuery image(ImageQueryDefinition queryDef) {
            this.startField("image");
            this._queryBuilder.append('{');
            queryDef.define(new ImageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MediaImageQuery mediaContentType() {
            this.startField("mediaContentType");
            return this;
        }

        public MediaImageQuery presentation(MediaPresentationQueryDefinition queryDef) {
            this.startField("presentation");
            this._queryBuilder.append('{');
            queryDef.define(new MediaPresentationQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MediaImageQuery previewImage(ImageQueryDefinition queryDef) {
            this.startField("previewImage");
            this._queryBuilder.append('{');
            queryDef.define(new ImageQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface MediaImageQueryDefinition {
        public void define(MediaImageQuery var1);
    }

    public static enum MediaHost {
        VIMEO,
        YOUTUBE,
        UNKNOWN_VALUE;


        public static MediaHost fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "VIMEO": {
                    return VIMEO;
                }
                case "YOUTUBE": {
                    return YOUTUBE;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case VIMEO: {
                    return "VIMEO";
                }
                case YOUTUBE: {
                    return "YOUTUBE";
                }
            }
            return "";
        }
    }

    public static class MediaEdge
    extends AbstractResponse<MediaEdge> {
        public MediaEdge() {
        }

        public MediaEdge(JsonObject fields) throws SchemaViolationError {
            block10: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "cursor": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                    case "node": {
                        this.responseData.put(key, UnknownMedia.create(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block10;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block10;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "MediaEdge";
        }

        public String getCursor() {
            return (String)this.get("cursor");
        }

        public MediaEdge setCursor(String arg) {
            this.optimisticData.put(this.getKey("cursor"), arg);
            return this;
        }

        public Media getNode() {
            return (Media)this.get("node");
        }

        public MediaEdge setNode(Media arg) {
            this.optimisticData.put(this.getKey("node"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "cursor": {
                    return false;
                }
                case "node": {
                    return false;
                }
            }
            return false;
        }
    }

    public static class MediaEdgeQuery
    extends Query<MediaEdgeQuery> {
        MediaEdgeQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public MediaEdgeQuery cursor() {
            this.startField("cursor");
            return this;
        }

        public MediaEdgeQuery node(MediaQueryDefinition queryDef) {
            this.startField("node");
            this._queryBuilder.append('{');
            queryDef.define(new MediaQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface MediaEdgeQueryDefinition {
        public void define(MediaEdgeQuery var1);
    }

    public static enum MediaContentType {
        EXTERNAL_VIDEO,
        IMAGE,
        MODEL_3D,
        VIDEO,
        UNKNOWN_VALUE;


        public static MediaContentType fromGraphQl(String value) {
            if (value == null) {
                return null;
            }
            switch (value) {
                case "EXTERNAL_VIDEO": {
                    return EXTERNAL_VIDEO;
                }
                case "IMAGE": {
                    return IMAGE;
                }
                case "MODEL_3D": {
                    return MODEL_3D;
                }
                case "VIDEO": {
                    return VIDEO;
                }
            }
            return UNKNOWN_VALUE;
        }

        public String toString() {
            switch (this) {
                case EXTERNAL_VIDEO: {
                    return "EXTERNAL_VIDEO";
                }
                case IMAGE: {
                    return "IMAGE";
                }
                case MODEL_3D: {
                    return "MODEL_3D";
                }
                case VIDEO: {
                    return "VIDEO";
                }
            }
            return "";
        }
    }

    public static class MediaConnection
    extends AbstractResponse<MediaConnection> {
        public MediaConnection() {
        }

        public MediaConnection(JsonObject fields) throws SchemaViolationError {
            block12: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "edges": {
                        ArrayList<Object> list1 = new ArrayList<Object>();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(new MediaEdge(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "nodes": {
                        ArrayList<Object> list1 = new ArrayList();
                        for (JsonElement element1 : this.jsonAsArray((JsonElement)field.getValue(), key)) {
                            list1.add(UnknownMedia.create(this.jsonAsObject(element1, key)));
                        }
                        this.responseData.put(key, list1);
                        continue block12;
                    }
                    case "pageInfo": {
                        this.responseData.put(key, new PageInfo(this.jsonAsObject((JsonElement)field.getValue(), key)));
                        continue block12;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block12;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public String getGraphQlTypeName() {
            return "MediaConnection";
        }

        public List<MediaEdge> getEdges() {
            return (List)this.get("edges");
        }

        public MediaConnection setEdges(List<MediaEdge> arg) {
            this.optimisticData.put(this.getKey("edges"), arg);
            return this;
        }

        public List<Media> getNodes() {
            return (List)this.get("nodes");
        }

        public MediaConnection setNodes(List<Media> arg) {
            this.optimisticData.put(this.getKey("nodes"), arg);
            return this;
        }

        public PageInfo getPageInfo() {
            return (PageInfo)this.get("pageInfo");
        }

        public MediaConnection setPageInfo(PageInfo arg) {
            this.optimisticData.put(this.getKey("pageInfo"), arg);
            return this;
        }

        @Override
        public boolean unwrapsToObject(String key) {
            switch (this.getFieldName(key)) {
                case "edges": {
                    return true;
                }
                case "nodes": {
                    return false;
                }
                case "pageInfo": {
                    return true;
                }
            }
            return false;
        }
    }

    public static class MediaConnectionQuery
    extends Query<MediaConnectionQuery> {
        MediaConnectionQuery(StringBuilder _queryBuilder) {
            super(_queryBuilder);
        }

        public MediaConnectionQuery edges(MediaEdgeQueryDefinition queryDef) {
            this.startField("edges");
            this._queryBuilder.append('{');
            queryDef.define(new MediaEdgeQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MediaConnectionQuery nodes(MediaQueryDefinition queryDef) {
            this.startField("nodes");
            this._queryBuilder.append('{');
            queryDef.define(new MediaQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }

        public MediaConnectionQuery pageInfo(PageInfoQueryDefinition queryDef) {
            this.startField("pageInfo");
            this._queryBuilder.append('{');
            queryDef.define(new PageInfoQuery(this._queryBuilder));
            this._queryBuilder.append('}');
            return this;
        }
    }

    public static interface MediaConnectionQueryDefinition {
        public void define(MediaConnectionQuery var1);
    }

    public static class UnknownMedia
    extends AbstractResponse<UnknownMedia>
    implements Media {
        public UnknownMedia() {
        }

        public UnknownMedia(JsonObject fields) throws SchemaViolationError {
            block16: for (Map.Entry field : fields.entrySet()) {
                String fieldName;
                String key = (String)field.getKey();
                switch (fieldName = this.getFieldName(key)) {
                    case "alt": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = this.jsonAsString((JsonElement)field.getValue(), key);
                        }
                        this.responseData.put(key, optional1);
                        continue block16;
                    }
                    case "id": {
                        this.responseData.put(key, new ID(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block16;
                    }
                    case "mediaContentType": {
                        this.responseData.put(key, MediaContentType.fromGraphQl(this.jsonAsString((JsonElement)field.getValue(), key)));
                        continue block16;
                    }
                    case "presentation": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new MediaPresentation(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block16;
                    }
                    case "previewImage": {
                        Object optional1 = null;
                        if (!((JsonElement)field.getValue()).isJsonNull()) {
                            optional1 = new Image(this.jsonAsObject((JsonElement)field.getValue(), key));
                        }
                        this.responseData.put(key, optional1);
                        continue block16;
                    }
                    case "__typename": {
                        this.responseData.put(key, this.jsonAsString((JsonElement)field.getValue(), key));
                        continue block16;
                    }
                }
                throw new SchemaViolationError(this, key, (JsonElement)field.getValue());
            }
        }

        public static Media create(JsonObject fields) throws SchemaViolationError {
            String typeName;
            switch (typeName = fields.getAsJsonPrimitive("__typename").getAsString()) {
                case "ExternalVideo": {
                    return new ExternalVideo(fields);
                }
                case "MediaImage": {
                    return new MediaImage(fields);
                }
                case "Model3d": {
                    return new Model3d(fields);
                }
                case "Video": {
                    return new Video(fields);
                }
            }
            return new UnknownMedia(fields);
        }

        @Override
        public String getGraphQlTypeName() {
            return (String)this.get("__typename");
      