/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy3.internal;

import com.shopify.buy3.GraphCallResult;
import com.shopify.buy3.GraphError;
import com.shopify.buy3.GraphResponse;
import com.shopify.buy3.internal.HttpResponseParser;
import com.shopify.buy3.internal.cache.HttpCache;
import com.shopify.graphql.support.AbstractResponse;
import java.io.Closeable;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003BP\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00121\u0010\b\u001a-\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tj\b\u0012\u0004\u0012\u00028\u0000`\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b*\u00020\u0019H\u0002J\u0014\u0010\u001c\u001a\u00020\u000e*\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R9\u0010\b\u001a-\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tj\b\u0012\u0004\u0012\u00028\u0000`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/shopify/buy3/internal/GraphHttpResultCallback;", "T", "Lcom/shopify/graphql/support/AbstractResponse;", "Lokhttp3/Callback;", "httpResponseParser", "Lcom/shopify/buy3/internal/HttpResponseParser;", "httpCache", "Lcom/shopify/buy3/internal/cache/HttpCache;", "resultCallback", "Lkotlin/Function1;", "Lcom/shopify/buy3/GraphCallResult;", "Lkotlin/ParameterName;", "name", "result", "", "Lcom/shopify/buy3/GraphCallResultCallback;", "(Lcom/shopify/buy3/internal/HttpResponseParser;Lcom/shopify/buy3/internal/cache/HttpCache;Lkotlin/jvm/functions/Function1;)V", "cancel", "onFailure", "call", "Lokhttp3/Call;", "e", "Ljava/io/IOException;", "onResponse", "response", "Lokhttp3/Response;", "parse", "Lcom/shopify/buy3/GraphResponse;", "purge", "httpRequest", "Lokhttp3/Request;", "buy3_release"})
final class GraphHttpResultCallback<T extends AbstractResponse<T>>
implements Callback {
    private final HttpResponseParser<T> httpResponseParser;
    private final HttpCache httpCache;
    private final Function1<GraphCallResult<? extends T>, Unit> resultCallback;

    public void onFailure(@NotNull Call call, @NotNull IOException e) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        this.resultCallback.invoke((Object)new GraphCallResult.Failure(new GraphError.NetworkError("Failed to execute GraphQL http request", e)));
    }

    public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        GraphResponse<T> graphResponse;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        try {
            graphResponse = this.parse(response);
        }
        catch (GraphError e) {
            if (e instanceof GraphError.ParseError) {
                HttpCache httpCache2 = this.httpCache;
                if (httpCache2 != null) {
                    Request request = response.request();
                    Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"response.request()");
                    this.purge(httpCache2, request);
                }
            }
            this.resultCallback.invoke((Object)new GraphCallResult.Failure(e));
            return;
        }
        GraphResponse<T> graphResponse2 = graphResponse;
        if (graphResponse2.getHasErrors()) {
            HttpCache httpCache3 = this.httpCache;
            if (httpCache3 != null) {
                Request request = response.request();
                Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"response.request()");
                this.purge(httpCache3, request);
            }
        }
        this.resultCallback.invoke(new GraphCallResult.Success<T>(graphResponse2));
    }

    public final void cancel() {
        this.resultCallback.invoke((Object)new GraphCallResult.Failure(new GraphError.CallCanceledError(null, null, 3, null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final GraphResponse<T> parse(@NotNull Response $this$parse) {
        GraphResponse<T> graphResponse;
        Closeable closeable = (Closeable)$this$parse;
        boolean bl = false;
        Throwable throwable = null;
        try {
            Response it = (Response)closeable;
            boolean bl2 = false;
            graphResponse = this.httpResponseParser.parse(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return graphResponse;
    }

    private final void purge(@NotNull HttpCache $this$purge, Request httpRequest) {
        block0: {
            String string = httpRequest.header("X-BUY3-SDK-CACHE-KEY");
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String cacheKey = string2;
            boolean bl3 = false;
            $this$purge.removeQuietly(cacheKey);
        }
    }

    public GraphHttpResultCallback(@NotNull HttpResponseParser<T> httpResponseParser, @Nullable HttpCache httpCache2, @NotNull Function1<? super GraphCallResult<? extends T>, Unit> resultCallback) {
        Intrinsics.checkParameterIsNotNull(httpResponseParser, (String)"httpResponseParser");
        Intrinsics.checkParameterIsNotNull(resultCallback, (String)"resultCallback");
        this.httpResponseParser = httpResponseParser;
        this.httpCache = httpCache2;
        this.resultCallback = resultCallback;
    }
}

