/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy3.internal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.shopify.buy3.GraphError;
import com.shopify.buy3.GraphResponse;
import com.shopify.graphql.support.AbstractResponse;
import com.shopify.graphql.support.Error;
import com.shopify.graphql.support.TopLevelResponse;
import java.io.Closeable;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B2\u0012+\u0010\u0004\u001a'\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\n\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\t\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u000eH\u0002J\f\u0010\u0010\u001a\u00020\u000e*\u00020\u000eH\u0002R3\u0010\u0004\u001a'\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00028\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/shopify/buy3/internal/HttpResponseParser;", "T", "Lcom/shopify/graphql/support/AbstractResponse;", "", "extractResponseData", "Lkotlin/Function1;", "Lcom/shopify/graphql/support/TopLevelResponse;", "Lkotlin/ParameterName;", "name", "response", "Lcom/shopify/buy3/internal/GraphQLResponseDataExtractor;", "(Lkotlin/jvm/functions/Function1;)V", "parse", "Lcom/shopify/buy3/GraphResponse;", "Lokhttp3/Response;", "parseTopLevelResponse", "successResponse", "buy3_release"})
public final class HttpResponseParser<T extends AbstractResponse<T>> {
    private final Function1<TopLevelResponse, T> extractResponseData;

    @NotNull
    public final GraphResponse<T> parse(@NotNull Response response) throws GraphError {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        TopLevelResponse topLevelResponse = this.parseTopLevelResponse(this.successResponse(response));
        try {
            AbstractResponse data = topLevelResponse.getData() != null ? (AbstractResponse)this.extractResponseData.invoke((Object)topLevelResponse) : null;
            List<Error> list = topLevelResponse.getErrors();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"topLevelResponse.errors");
            return new GraphResponse<AbstractResponse>(data, list);
        }
        catch (Exception e) {
            Timber.w((Throwable)e, (String)"failed to process GraphQL response", (Object[])new Object[0]);
            throw (Throwable)new GraphError.Unknown("Failed to process GraphQL response ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Response successResponse(@NotNull Response $this$successResponse) throws GraphError {
        Response response = $this$successResponse;
        boolean bl = false;
        boolean bl2 = false;
        Response $this$apply = response;
        boolean bl3 = false;
        if (!$this$apply.isSuccessful()) {
            Closeable closeable = (Closeable)$this$apply;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                try {
                    Response it = (Response)closeable;
                    boolean bl5 = false;
                    throw (Throwable)new GraphError.HttpError(it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                throw throwable3;
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TopLevelResponse parseTopLevelResponse(Response response) throws GraphError {
        try {
            JsonReader reader = new JsonReader(response.body().charStream());
            JsonElement jsonElement = new JsonParser().parse(reader);
            if (jsonElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.gson.JsonObject");
            }
            JsonObject root = (JsonObject)jsonElement;
            TopLevelResponse topLevelResponse = new TopLevelResponse(root);
            return topLevelResponse;
        }
        catch (Exception e) {
            Timber.w((Throwable)e, (String)"failed to parse GraphQL response", (Object[])new Object[0]);
            throw (Throwable)new GraphError.ParseError("Failed to parse GraphQL http response", e);
        }
        finally {
            response.close();
        }
    }

    public HttpResponseParser(@NotNull Function1<? super TopLevelResponse, ? extends T> extractResponseData) {
        Intrinsics.checkParameterIsNotNull(extractResponseData, (String)"extractResponseData");
        this.extractResponseData = extractResponseData;
    }
}

