/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy3.internal.cache;

import com.shopify.buy3.internal.cache.CacheResponseBody;
import com.shopify.buy3.internal.cache.DiskLruCacheStore;
import com.shopify.buy3.internal.cache.HttpCacheInterceptor;
import com.shopify.buy3.internal.cache.ResponseBodyProxy;
import com.shopify.buy3.internal.cache.ResponseCacheRecord;
import com.shopify.buy3.internal.cache.ResponseCacheRecordEditor;
import com.shopify.buy3.internal.cache.ResponseCacheStore;
import com.shopify.buy3.internal.cache.ResponseHeaderRecord;
import com.shopify.buy3.internal.cache.UtilsKt;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.ForwardingSource;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\n\u001a\u00020\u000bJ\r\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u001d\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0016J\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/shopify/buy3/internal/cache/HttpCache;", "", "directory", "Ljava/io/File;", "maxSize", "", "(Ljava/io/File;J)V", "cacheStore", "Lcom/shopify/buy3/internal/cache/ResponseCacheStore;", "(Lcom/shopify/buy3/internal/cache/ResponseCacheStore;)V", "clear", "", "httpInterceptor", "Lokhttp3/Interceptor;", "httpInterceptor$buy3_release", "proxyResponse", "Lokhttp3/Response;", "response", "cacheKey", "", "proxyResponse$buy3_release", "read", "read$buy3_release", "removeQuietly", "buy3_release"})
public final class HttpCache {
    private final ResponseCacheStore cacheStore;

    public final void clear() {
        try {
            this.cacheStore.delete();
        }
        catch (IOException e) {
            Timber.w((Throwable)e, (String)"failed to clear http cache", (Object[])new Object[0]);
        }
    }

    public final void removeQuietly(@NotNull String cacheKey) {
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        CharSequence charSequence = cacheKey;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            try {
                this.cacheStore.remove(cacheKey);
            }
            catch (IOException e) {
                Timber.w((Throwable)e, (String)"failed to remove cached response by key: %s", (Object[])new Object[]{cacheKey});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Response read$buy3_release(@NotNull String cacheKey) {
        void responseCacheRecord;
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        try {
            responseCacheRecord.element = this.cacheStore.cacheRecord(cacheKey);
            if ((ResponseCacheRecord)responseCacheRecord.element == null) {
                return null;
            }
            ResponseCacheRecord cacheRecord2 = (ResponseCacheRecord)responseCacheRecord.element;
            ForwardingSource cacheResponseSource2 = new ForwardingSource(cacheRecord2, (Ref.ObjectRef)responseCacheRecord, ((ResponseCacheRecord)responseCacheRecord.element).bodySource()){
                final /* synthetic */ ResponseCacheRecord $cacheRecord;
                final /* synthetic */ Ref.ObjectRef $responseCacheRecord;

                public void close() throws IOException {
                    super.close();
                    UtilsKt.closeQuietly(this.$cacheRecord);
                }
                {
                    this.$cacheRecord = $captured_local_variable$0;
                    this.$responseCacheRecord = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            };
            Response response = new ResponseHeaderRecord(((ResponseCacheRecord)responseCacheRecord.element).headerSource()).response();
            String contentType = response.header("Content-Type");
            String contentLength = response.header("Content-Length");
            return response.newBuilder().body((ResponseBody)new CacheResponseBody((Source)cacheResponseSource2, contentType, contentLength)).build();
        }
        catch (Exception e) {
            UtilsKt.closeQuietly((ResponseCacheRecord)responseCacheRecord.element);
            Timber.w((Throwable)e, (String)"failed to read cached response by key: %s", (Object[])new Object[]{cacheKey});
            return null;
        }
    }

    @NotNull
    public final Interceptor httpInterceptor$buy3_release() {
        return new HttpCacheInterceptor(this);
    }

    @NotNull
    public final Response proxyResponse$buy3_release(@NotNull Response response, @NotNull String cacheKey) {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)cacheKey, (String)"cacheKey");
        ResponseCacheRecordEditor cacheRecordEditor2 = null;
        try {
            cacheRecordEditor2 = this.cacheStore.cacheRecordEditor(cacheKey);
            if (cacheRecordEditor2 != null) {
                new ResponseHeaderRecord(response).writeTo(cacheRecordEditor2);
                Response response2 = response.newBuilder().body((ResponseBody)new ResponseBodyProxy(cacheRecordEditor2, response)).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response.newBuilder()\n  \u2026                 .build()");
                return response2;
            }
        }
        catch (Exception e) {
            UtilsKt.abortQuietly(cacheRecordEditor2);
            Timber.w((Throwable)e, (String)"failed to proxy response", (Object[])new Object[0]);
        }
        return response;
    }

    public HttpCache(@NotNull ResponseCacheStore cacheStore) {
        Intrinsics.checkParameterIsNotNull((Object)cacheStore, (String)"cacheStore");
        this.cacheStore = cacheStore;
    }

    public HttpCache(@NotNull File directory, long maxSize) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        this(new DiskLruCacheStore(directory, maxSize));
    }
}

