/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy3.internal.cache;

import com.shopify.buy3.internal.cache.HttpCache;
import com.shopify.buy3.internal.cache.UtilsKt;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/shopify/buy3/internal/cache/HttpCacheInterceptor;", "Lokhttp3/Interceptor;", "cache", "Lcom/shopify/buy3/internal/cache/HttpCache;", "(Lcom/shopify/buy3/internal/cache/HttpCache;)V", "cacheFirst", "Lokhttp3/Response;", "request", "Lokhttp3/Request;", "chain", "Lokhttp3/Interceptor$Chain;", "cacheOnlyResponse", "cachedResponse", "intercept", "logCacheHit", "", "logCacheMiss", "networkFirst", "buy3_release"})
public final class HttpCacheInterceptor
implements Interceptor {
    private final HttpCache cache;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response response;
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request = chain.request();
        Request request2 = request;
        Intrinsics.checkExpressionValueIsNotNull((Object)request2, (String)"request");
        if (UtilsKt.getShouldSkipCache(request2)) {
            Response response2 = chain.proceed(request);
            response = response2;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"chain.proceed(request)");
        } else {
            response = UtilsKt.getShouldSkipNetwork(request) ? this.cacheOnlyResponse(request) : (UtilsKt.isNetworkFirst(request) ? this.networkFirst(request, chain) : this.cacheFirst(request, chain));
        }
        return response;
    }

    private final Response cacheOnlyResponse(Request request) throws IOException {
        Response cacheResponse = this.cachedResponse(request);
        if (cacheResponse == null) {
            this.logCacheMiss(request);
            return UtilsKt.getUnsatisfiableCacheRequest(request);
        }
        this.logCacheHit(request);
        Response response = cacheResponse.newBuilder().cacheResponse(UtilsKt.strip(cacheResponse)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"cacheResponse.newBuilder\u2026p())\n            .build()");
        return response;
    }

    private final Response networkFirst(Request request, Interceptor.Chain chain) throws IOException {
        Response response = chain.proceed(request);
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"chain.proceed(request)");
        Response networkResponse = UtilsKt.withServedDateHeader(response);
        if (networkResponse.isSuccessful()) {
            String cacheKey;
            String string = cacheKey = request.header("X-BUY3-SDK-CACHE-KEY");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cacheKey");
            return this.cache.proxyResponse$buy3_release(networkResponse, string);
        }
        Response cacheResponse = this.cachedResponse(request);
        if (cacheResponse == null) {
            this.logCacheMiss(request);
            return networkResponse;
        }
        this.logCacheHit(request);
        Response response2 = cacheResponse.newBuilder().cacheResponse(UtilsKt.strip(cacheResponse)).networkResponse(UtilsKt.strip(networkResponse)).request(request).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"cacheResponse.newBuilder\u2026est)\n            .build()");
        return response2;
    }

    private final Response cacheFirst(Request request, Interceptor.Chain chain) throws IOException {
        Response cacheResponse = this.cachedResponse(request);
        if (cacheResponse == null) {
            this.logCacheMiss(request);
            Response response = chain.proceed(request);
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"chain.proceed(request)");
            Response networkResponse = UtilsKt.withServedDateHeader(response);
            if (networkResponse.isSuccessful()) {
                String cacheKey;
                String string = cacheKey = request.header("X-BUY3-SDK-CACHE-KEY");
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"cacheKey");
                return this.cache.proxyResponse$buy3_release(networkResponse, string);
            }
            return networkResponse;
        }
        this.logCacheHit(request);
        Response response = cacheResponse.newBuilder().cacheResponse(UtilsKt.strip(cacheResponse)).request(request).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"cacheResponse.newBuilder\u2026est)\n            .build()");
        return response;
    }

    private final Response cachedResponse(Request request) {
        String cacheKey;
        block6: {
            block5: {
                cacheKey = request.header("X-BUY3-SDK-CACHE-KEY");
                if (cacheKey == null) break block5;
                CharSequence charSequence = cacheKey;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block6;
            }
            return null;
        }
        Response response = this.cache.read$buy3_release(cacheKey);
        if (response == null) {
            return null;
        }
        Response cachedResponse = response;
        if (UtilsKt.isStale(request, cachedResponse)) {
            UtilsKt.closeQuietly(cachedResponse);
            return null;
        }
        return cachedResponse;
    }

    private final void logCacheHit(Request request) {
        String cacheKey;
        block3: {
            block2: {
                cacheKey = request.header("X-BUY3-SDK-CACHE-KEY");
                if (cacheKey == null) break block2;
                CharSequence charSequence = cacheKey;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block3;
            }
            return;
        }
        Timber.d((String)"cache HIT for key: %s", (Object[])new Object[]{cacheKey});
    }

    private final void logCacheMiss(Request request) {
        String cacheKey;
        block3: {
            block2: {
                cacheKey = request.header("X-BUY3-SDK-CACHE-KEY");
                if (cacheKey == null) break block2;
                CharSequence charSequence = cacheKey;
                boolean bl = false;
                if (!(charSequence.length() == 0)) break block3;
            }
            return;
        }
        Timber.d((String)"cache MISS for key: %s", (Object[])new Object[]{cacheKey});
    }

    public HttpCacheInterceptor(@NotNull HttpCache cache) {
        Intrinsics.checkParameterIsNotNull((Object)cache, (String)"cache");
        this.cache = cache;
    }
}

