/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy3.internal.cache;

import com.shopify.buy3.internal.cache.ResponseBodyCacheSink;
import com.shopify.buy3.internal.cache.ResponseCacheRecordEditor;
import com.shopify.buy3.internal.cache.UtilsKt;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/shopify/buy3/internal/cache/ProxySource;", "Lokio/Source;", "cacheRecordEditor", "Lcom/shopify/buy3/internal/cache/ResponseCacheRecordEditor;", "responseBodySource", "(Lcom/shopify/buy3/internal/cache/ResponseCacheRecordEditor;Lokio/Source;)V", "getCacheRecordEditor", "()Lcom/shopify/buy3/internal/cache/ResponseCacheRecordEditor;", "closed", "", "getClosed$buy3_release", "()Z", "setClosed$buy3_release", "(Z)V", "responseBodyCacheSink", "Lcom/shopify/buy3/internal/cache/ResponseBodyCacheSink;", "getResponseBodyCacheSink$buy3_release", "()Lcom/shopify/buy3/internal/cache/ResponseBodyCacheSink;", "getResponseBodySource", "()Lokio/Source;", "abortCacheQuietly", "", "close", "commitCache", "read", "", "sink", "Lokio/Buffer;", "byteCount", "timeout", "Lokio/Timeout;", "buy3_release"})
final class ProxySource
implements Source {
    @NotNull
    private final ResponseBodyCacheSink responseBodyCacheSink;
    private boolean closed;
    @NotNull
    private final ResponseCacheRecordEditor cacheRecordEditor;
    @NotNull
    private final Source responseBodySource;

    @NotNull
    public final ResponseBodyCacheSink getResponseBodyCacheSink$buy3_release() {
        return this.responseBodyCacheSink;
    }

    public final boolean getClosed$buy3_release() {
        return this.closed;
    }

    public final void setClosed$buy3_release(boolean bl) {
        this.closed = bl;
    }

    public long read(@NotNull Buffer sink, long byteCount) throws IOException {
        long l;
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        try {
            l = this.responseBodySource.read(sink, byteCount);
        }
        catch (IOException e) {
            if (!this.closed) {
                this.closed = true;
                this.abortCacheQuietly();
            }
            throw (Throwable)e;
        }
        long bytesRead = l;
        if (bytesRead == -1L) {
            if (!this.closed) {
                this.closed = true;
                this.commitCache();
            }
            return -1L;
        }
        this.responseBodyCacheSink.copyFrom(sink, sink.size() - bytesRead, bytesRead);
        return bytesRead;
    }

    @NotNull
    public Timeout timeout() {
        Timeout timeout = this.responseBodySource.timeout();
        Intrinsics.checkExpressionValueIsNotNull((Object)timeout, (String)"responseBodySource.timeout()");
        return timeout;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (Util.discard((Source)this, (int)100, (TimeUnit)TimeUnit.MILLISECONDS)) {
            this.responseBodySource.close();
            this.commitCache();
        } else {
            this.responseBodySource.close();
            this.abortCacheQuietly();
        }
    }

    private final void commitCache() {
        try {
            this.responseBodyCacheSink.close();
            this.cacheRecordEditor.commit();
        }
        catch (Exception e) {
            UtilsKt.closeQuietly((Closeable)((Object)this.responseBodyCacheSink));
            this.abortCacheQuietly();
            Timber.w((Throwable)e, (String)"failed to commit cache response", (Object[])new Object[0]);
        }
    }

    private final void abortCacheQuietly() {
        UtilsKt.closeQuietly((Closeable)((Object)this.responseBodyCacheSink));
        try {
            this.cacheRecordEditor.abort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    public final ResponseCacheRecordEditor getCacheRecordEditor() {
        return this.cacheRecordEditor;
    }

    @NotNull
    public final Source getResponseBodySource() {
        return this.responseBodySource;
    }

    public ProxySource(@NotNull ResponseCacheRecordEditor cacheRecordEditor2, @NotNull Source responseBodySource) {
        Intrinsics.checkParameterIsNotNull((Object)cacheRecordEditor2, (String)"cacheRecordEditor");
        Intrinsics.checkParameterIsNotNull((Object)responseBodySource, (String)"responseBodySource");
        this.cacheRecordEditor = cacheRecordEditor2;
        this.responseBodySource = responseBodySource;
        BufferedSink bufferedSink = Okio.buffer((Sink)this.cacheRecordEditor.bodySink());
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferedSink, (String)"Okio.buffer(cacheRecordEditor.bodySink())");
        this.responseBodyCacheSink = new ResponseBodyCacheSink(bufferedSink){

            @Override
            public void onException(@NotNull Exception e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.abortCacheQuietly();
                Timber.w((Throwable)e, (String)"failed to write to cache response sink", (Object[])new Object[0]);
            }
        };
    }
}

