/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy3.internal.cache;

import com.shopify.buy3.internal.cache.ProxySource;
import com.shopify.buy3.internal.cache.ResponseCacheRecordEditor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\rH\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/shopify/buy3/internal/cache/ResponseBodyProxy;", "Lokhttp3/ResponseBody;", "cacheRecordEditor", "Lcom/shopify/buy3/internal/cache/ResponseCacheRecordEditor;", "sourceResponse", "Lokhttp3/Response;", "(Lcom/shopify/buy3/internal/cache/ResponseCacheRecordEditor;Lokhttp3/Response;)V", "contentLength", "", "kotlin.jvm.PlatformType", "contentType", "responseBodySource", "Lcom/shopify/buy3/internal/cache/ProxySource;", "", "Lokhttp3/MediaType;", "source", "Lokio/BufferedSource;", "buy3_release"})
public final class ResponseBodyProxy
extends ResponseBody {
    private final String contentType;
    private final String contentLength;
    private final ProxySource responseBodySource;

    @Nullable
    public MediaType contentType() {
        return this.contentType != null ? MediaType.parse((String)this.contentType) : null;
    }

    public long contentLength() {
        long l;
        try {
            long l2;
            String string = this.contentLength;
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                l2 = Long.parseLong(string2);
            } else {
                l2 = -1L;
            }
            l = l2;
        }
        catch (NumberFormatException e) {
            Timber.w((Throwable)e, (String)"failed to parse content length", (Object[])new Object[0]);
            l = -1L;
        }
        return l;
    }

    @NotNull
    public BufferedSource source() {
        BufferedSource bufferedSource = Okio.buffer((Source)this.responseBodySource);
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferedSource, (String)"Okio.buffer(responseBodySource)");
        return bufferedSource;
    }

    public ResponseBodyProxy(@NotNull ResponseCacheRecordEditor cacheRecordEditor2, @NotNull Response sourceResponse) {
        Intrinsics.checkParameterIsNotNull((Object)cacheRecordEditor2, (String)"cacheRecordEditor");
        Intrinsics.checkParameterIsNotNull((Object)sourceResponse, (String)"sourceResponse");
        this.contentType = sourceResponse.header("Content-Type");
        this.contentLength = sourceResponse.header("Content-Length");
        BufferedSource bufferedSource = sourceResponse.body().source();
        Intrinsics.checkExpressionValueIsNotNull((Object)bufferedSource, (String)"sourceResponse.body().source()");
        this.responseBodySource = new ProxySource(cacheRecordEditor2, (Source)bufferedSource);
    }
}

