/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.buy3.internal.cache;

import com.shopify.buy3.HttpCachePolicy;
import com.shopify.buy3.internal.cache.ResponseCacheRecord;
import com.shopify.buy3.internal.cache.ResponseCacheRecordEditor;
import java.io.Closeable;
import java.io.IOException;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpDate;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0012H\u0000\u001a\u000e\u0010\u0018\u001a\u00020\u0019*\u0004\u0018\u00010\u001aH\u0000\u001a\u000e\u0010\u001b\u001a\u00020\u0019*\u0004\u0018\u00010\u001cH\u0000\u001a\u000e\u0010\u001b\u001a\u00020\u0019*\u0004\u0018\u00010\u001dH\u0000\u001a\u000e\u0010\u001b\u001a\u00020\u0019*\u0004\u0018\u00010\u0012H\u0000\u001a\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0012*\u0004\u0018\u00010\u0012H\u0000\u001a\f\u0010\u001f\u001a\u00020\u0012*\u00020\u0012H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0018\u0010\n\u001a\u00020\u000b*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\"\u0018\u0010\r\u001a\u00020\u000b*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\"\u0018\u0010\u000f\u001a\u00020\u000b*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\"\u0018\u0010\u0011\u001a\u00020\u0012*\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"cacheKey", "", "Lokhttp3/RequestBody;", "getCacheKey", "(Lokhttp3/RequestBody;)Ljava/lang/String;", "fetchStrategy", "Lcom/shopify/buy3/HttpCachePolicy$FetchStrategy;", "Lokhttp3/Request;", "getFetchStrategy", "(Lokhttp3/Request;)Lcom/shopify/buy3/HttpCachePolicy$FetchStrategy;", "isNetworkFirst", "", "(Lokhttp3/Request;)Z", "shouldSkipCache", "getShouldSkipCache", "shouldSkipNetwork", "getShouldSkipNetwork", "unsatisfiableCacheRequest", "Lokhttp3/Response;", "getUnsatisfiableCacheRequest", "(Lokhttp3/Request;)Lokhttp3/Response;", "isStale", "request", "response", "abortQuietly", "", "Lcom/shopify/buy3/internal/cache/ResponseCacheRecordEditor;", "closeQuietly", "Lcom/shopify/buy3/internal/cache/ResponseCacheRecord;", "Ljava/io/Closeable;", "strip", "withServedDateHeader", "buy3_release"})
public final class UtilsKt {
    @NotNull
    public static final String getCacheKey(@NotNull RequestBody $this$cacheKey) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$cacheKey, (String)"$this$cacheKey");
        try {
            Buffer hashBuffer = new Buffer();
            $this$cacheKey.writeTo((BufferedSink)hashBuffer);
            String string2 = hashBuffer.readByteString().md5().hex();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"hashBuffer.readByteString().md5().hex()");
            string = string2;
        }
        catch (Exception e) {
            string = "";
        }
        return string;
    }

    @Nullable
    public static final Response strip(@Nullable Response $this$strip) {
        Response response;
        block3: {
            block2: {
                response = $this$strip;
                if (response == null || (response = response.body()) == null) break block2;
                Response response2 = response;
                boolean bl = false;
                boolean bl2 = false;
                Response it = response2;
                boolean bl3 = false;
                response = $this$strip.newBuilder().body(null).networkResponse(null).cacheResponse(null).build();
                if (response != null) break block3;
            }
            response = $this$strip;
        }
        return response;
    }

    @NotNull
    public static final Response withServedDateHeader(@NotNull Response $this$withServedDateHeader) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)$this$withServedDateHeader, (String)"$this$withServedDateHeader");
        Response response = $this$withServedDateHeader.newBuilder().addHeader("X-BUY3-SDK-SERVED-DATE", HttpDate.format((Date)new Date())).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"newBuilder()\n        .ad\u2026Date()))\n        .build()");
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getShouldSkipCache(@NotNull Request $this$shouldSkipCache) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldSkipCache, (String)"$this$shouldSkipCache");
        String cacheKey = $this$shouldSkipCache.header("X-BUY3-SDK-CACHE-KEY");
        if (UtilsKt.getFetchStrategy($this$shouldSkipCache) == null) return true;
        if (cacheKey == null) return true;
        CharSequence charSequence = cacheKey;
        boolean bl = false;
        if (charSequence.length() != 0) return false;
        return true;
    }

    public static final boolean getShouldSkipNetwork(@NotNull Request $this$shouldSkipNetwork) {
        Intrinsics.checkParameterIsNotNull((Object)$this$shouldSkipNetwork, (String)"$this$shouldSkipNetwork");
        return UtilsKt.getFetchStrategy($this$shouldSkipNetwork) == HttpCachePolicy.FetchStrategy.CACHE_ONLY;
    }

    public static final boolean isNetworkFirst(@NotNull Request $this$isNetworkFirst) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isNetworkFirst, (String)"$this$isNetworkFirst");
        return UtilsKt.getFetchStrategy($this$isNetworkFirst) == HttpCachePolicy.FetchStrategy.NETWORK_ONLY || UtilsKt.getFetchStrategy($this$isNetworkFirst) == HttpCachePolicy.FetchStrategy.NETWORK_FIRST;
    }

    @NotNull
    public static final Response getUnsatisfiableCacheRequest(@NotNull Request $this$unsatisfiableCacheRequest) {
        Intrinsics.checkParameterIsNotNull((Object)$this$unsatisfiableCacheRequest, (String)"$this$unsatisfiableCacheRequest");
        Response response = new Response.Builder().request($this$unsatisfiableCacheRequest).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (cache-only)").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.Builder()\n     \u2026s())\n            .build()");
        return response;
    }

    public static final boolean isStale(@NotNull Request request, @NotNull Response response) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        if (UtilsKt.getFetchStrategy(request) == HttpCachePolicy.FetchStrategy.CACHE_ONLY) {
            return false;
        }
        String timeoutStr = request.header("X-BUY3-SDK-EXPIRE-TIMEOUT");
        String servedDateStr = response.header("X-BUY3-SDK-SERVED-DATE");
        if (servedDateStr == null || timeoutStr == null) {
            return true;
        }
        String string = timeoutStr;
        boolean bl = false;
        long timeout = Long.parseLong(string);
        Date servedDate = HttpDate.parse((String)servedDateStr);
        long now = System.currentTimeMillis();
        return servedDate == null || now - servedDate.getTime() > timeout;
    }

    public static final void closeQuietly(@Nullable Response $this$closeQuietly) {
        try {
            Response response = $this$closeQuietly;
            if (response != null) {
                response.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void closeQuietly(@Nullable ResponseCacheRecord $this$closeQuietly) {
        try {
            ResponseCacheRecord responseCacheRecord = $this$closeQuietly;
            if (responseCacheRecord != null) {
                responseCacheRecord.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void abortQuietly(@Nullable ResponseCacheRecordEditor $this$abortQuietly) {
        try {
            ResponseCacheRecordEditor responseCacheRecordEditor = $this$abortQuietly;
            if (responseCacheRecordEditor != null) {
                responseCacheRecordEditor.abort();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void closeQuietly(@Nullable Closeable $this$closeQuietly) {
        try {
            Closeable closeable = $this$closeQuietly;
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final HttpCachePolicy.FetchStrategy getFetchStrategy(@NotNull Request $this$fetchStrategy) {
        HttpCachePolicy.FetchStrategy fetchStrategy;
        block3: {
            boolean bl;
            HttpCachePolicy.FetchStrategy[] fetchStrategyArray;
            String fetchStrategyHeader;
            block5: {
                block4: {
                    fetchStrategyHeader = $this$fetchStrategy.header("X-BUY3-SDK-CACHE-FETCH-STRATEGY");
                    if (fetchStrategyHeader == null) break block4;
                    fetchStrategyArray = (HttpCachePolicy.FetchStrategy[])fetchStrategyHeader;
                    bl = false;
                    if (!(fetchStrategyArray.length() == 0)) break block5;
                }
                return null;
            }
            fetchStrategyArray = HttpCachePolicy.FetchStrategy.values();
            bl = false;
            HttpCachePolicy.FetchStrategy[] fetchStrategyArray2 = fetchStrategyArray;
            boolean bl2 = false;
            HttpCachePolicy.FetchStrategy[] fetchStrategyArray3 = fetchStrategyArray2;
            int n = fetchStrategyArray3.length;
            for (int i = 0; i < n; ++i) {
                HttpCachePolicy.FetchStrategy fetchStrategy2;
                HttpCachePolicy.FetchStrategy it = fetchStrategy2 = fetchStrategyArray3[i];
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)fetchStrategyHeader)) continue;
                fetchStrategy = fetchStrategy2;
                break block3;
            }
            fetchStrategy = null;
        }
        return fetchStrategy;
    }
}

