/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.graphql.support;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shopify.graphql.support.Node;
import com.shopify.graphql.support.SchemaViolationError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractResponse<T extends AbstractResponse>
implements Serializable {
    public final HashMap<String, Object> responseData = new HashMap();
    public final HashMap<String, Object> optimisticData = new HashMap();
    private String aliasSuffix = null;

    public T withAlias(String aliasSuffix) {
        if (this.aliasSuffix != null) {
            throw new IllegalStateException("Can only define a single alias for a field");
        }
        if (aliasSuffix == null || aliasSuffix.isEmpty()) {
            throw new IllegalArgumentException("Can't specify an empty alias");
        }
        if (aliasSuffix.contains("__")) {
            throw new IllegalArgumentException("Alias must not contain __");
        }
        this.aliasSuffix = aliasSuffix;
        return (T)this;
    }

    public Object get(String field) {
        String key = this.getKey(field);
        if (this.optimisticData.containsKey(key)) {
            return this.optimisticData.get(key);
        }
        return this.responseData.get(key);
    }

    protected String getFieldName(String key) {
        int i = key.lastIndexOf("__");
        if (i > 1) {
            key = key.substring(0, i);
        }
        return key;
    }

    protected String getKey(String field) {
        if (this.aliasSuffix != null) {
            field = field + "__" + this.aliasSuffix;
            this.aliasSuffix = null;
        }
        return field;
    }

    protected String jsonAsString(JsonElement element, String field) throws SchemaViolationError {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
            throw new SchemaViolationError(this, field, element);
        }
        return element.getAsJsonPrimitive().getAsString();
    }

    protected Integer jsonAsInteger(JsonElement element, String field) throws SchemaViolationError {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) {
            throw new SchemaViolationError(this, field, element);
        }
        try {
            return element.getAsJsonPrimitive().getAsInt();
        }
        catch (NumberFormatException exc) {
            throw new SchemaViolationError(this, field, element);
        }
    }

    protected Double jsonAsDouble(JsonElement element, String field) throws SchemaViolationError {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber()) {
            throw new SchemaViolationError(this, field, element);
        }
        return element.getAsJsonPrimitive().getAsDouble();
    }

    protected Boolean jsonAsBoolean(JsonElement element, String field) throws SchemaViolationError {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isBoolean()) {
            throw new SchemaViolationError(this, field, element);
        }
        return element.getAsJsonPrimitive().getAsBoolean();
    }

    protected JsonObject jsonAsObject(JsonElement element, String field) throws SchemaViolationError {
        if (!element.isJsonObject()) {
            throw new SchemaViolationError(this, field, element);
        }
        return element.getAsJsonObject();
    }

    protected JsonArray jsonAsArray(JsonElement element, String field) throws SchemaViolationError {
        if (!element.isJsonArray()) {
            throw new SchemaViolationError(this, field, element);
        }
        return element.getAsJsonArray();
    }

    public List<Node> collectNodes() {
        ArrayList<Node> children = new ArrayList<Node>();
        AbstractResponse.collectNodes(this, children);
        return children;
    }

    private static void collectNodes(Object o, List<Node> collection) {
        block4: {
            block3: {
                if (!(o instanceof AbstractResponse)) break block3;
                AbstractResponse response = (AbstractResponse)o;
                if (response instanceof Node) {
                    collection.add((Node)((Object)response));
                }
                for (String key : response.responseData.keySet()) {
                    AbstractResponse.collectNodes(response.get(key), collection);
                }
                break block4;
            }
            if (!(o instanceof List)) break block4;
            for (Object element : (List)o) {
                AbstractResponse.collectNodes(element, collection);
            }
        }
    }

    public abstract boolean unwrapsToObject(String var1);
}

