/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.search.autoconfigure;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import modules.commons.search.configuration.SearchConfiguration;
import modules.commons.search.configuration.SearchHost;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.CreateIndexResponse;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.common.xcontent.XContentType;

public class SearchClient {
    private static final String PRODUCTS_INDEX = "products_";
    private static final String KEYWORDS_INDEX = "keywords_";
    private static SearchClient client = null;
    private RestHighLevelClient searchClient = null;

    private SearchClient(SearchConfiguration configuration) throws Exception {
        Validate.notNull((Object)configuration, (String)"SearchConfiguration cannot be null", (Object[])new Object[0]);
        if (this.searchClient != null) {
            this.searchClient.close();
            this.searchClient = null;
        }
        List<HttpHost> hostList = configuration.getHosts().stream().map(h -> this.host((SearchHost)h)).collect(Collectors.toList());
        RestClientBuilder builder = RestClient.builder((HttpHost[])hostList.toArray(new HttpHost[hostList.size()]));
        builder.setHttpClientConfigCallback(httpAsyncClientBuilder -> httpAsyncClientBuilder.setKeepAliveStrategy((response, context) -> 3600000L));
        if (configuration.getCredentials() != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(configuration.getCredentials().getUserName(), configuration.getCredentials().getPassword()));
            builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider, configuration){
                final /* synthetic */ CredentialsProvider val$credentialsProvider;
                final /* synthetic */ SearchConfiguration val$configuration;
                {
                    this.val$credentialsProvider = credentialsProvider;
                    this.val$configuration = searchConfiguration;
                }

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder) {
                    block10: {
                        httpAsyncClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                        try {
                            if (StringUtils.isBlank((CharSequence)this.val$configuration.getJksAbsolutePath())) break block10;
                            Path trustStorePath = Paths.get(this.val$configuration.getJksAbsolutePath(), new String[0]);
                            KeyStore truststore = KeyStore.getInstance("jks");
                            try (InputStream is = Files.newInputStream(trustStorePath, new OpenOption[0]);){
                                truststore.load(is, "instaclustr".toCharArray());
                            }
                            catch (CertificateException e) {
                                e.printStackTrace();
                            }
                            SSLContextBuilder sslBuilder = SSLContexts.custom().loadTrustMaterial(truststore, null);
                            SSLContext sslContext = sslBuilder.build();
                            httpAsyncClientBuilder.setSSLContext(sslContext);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return httpAsyncClientBuilder;
                }
            });
        }
        this.searchClient = new RestHighLevelClient(builder);
        ArrayList<String> languages = configuration.getLanguages();
        if (CollectionUtils.isEmpty((Collection)languages)) {
            languages = new ArrayList<String>();
            languages.add("en");
        }
        ArrayList indexLanguages = new ArrayList(languages);
        indexLanguages.stream().forEach(l -> {
            try {
                this.createIndex(PRODUCTS_INDEX, (String)configuration.getProductMappings().get(l), (String)configuration.getSettings().get(l), false, (String)l);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        indexLanguages.stream().forEach(l -> {
            try {
                this.createIndex(KEYWORDS_INDEX, (String)configuration.getKeywordsMappings().get(l), (String)configuration.getSettings().get(l), true, (String)l);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    protected static SearchClient getInstance(SearchConfiguration config) throws Exception {
        if (client == null) {
            client = new SearchClient(config);
        }
        return client;
    }

    private HttpHost host(SearchHost host) {
        return new HttpHost(host.getHost(), host.getPort(), host.getScheme());
    }

    private void createIndex(String indexPrefix, String mappings, String settings, boolean hasMappings, String language) throws Exception {
        StringBuilder indexBuilder = new StringBuilder();
        indexBuilder.append(indexPrefix).append(language.toLowerCase());
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexBuilder.toString());
        GetIndexRequest request = new GetIndexRequest(new String[]{indexBuilder.toString()});
        boolean exists = this.searchClient.indices().exists(request, RequestOptions.DEFAULT);
        if (exists) {
            return;
        }
        createIndexRequest.settings(settings, XContentType.JSON);
        createIndexRequest.mapping(mappings, XContentType.JSON);
        System.out.println(mappings);
        CreateIndexResponse createIndexResponse = this.searchClient.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        System.out.println("Creating index: " + indexBuilder.toString());
        System.out.println("Is client acknowledged?" + (createIndexResponse.isAcknowledged() ? " Yes" : " No"));
    }

    protected RestHighLevelClient getClient() throws Exception {
        return this.searchClient;
    }
}

