/*
 * Decompiled with CFR 0.152.
 */
package com.shopizer.search.autoconfigure;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.shopizer.search.autoconfigure.SearchClient;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import modules.commons.search.SearchModule;
import modules.commons.search.configuration.SearchConfiguration;
import modules.commons.search.request.Aggregation;
import modules.commons.search.request.Document;
import modules.commons.search.request.IndexItem;
import modules.commons.search.request.RequestOptions;
import modules.commons.search.request.SearchFilter;
import modules.commons.search.request.SearchItem;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.apache.lucene.search.join.ScoreMode;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MultiMatchQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.rest.RestStatus;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;

public class SearchModuleImpl
implements SearchModule {
    private String uniqueCode = "opensearch";
    private SearchClient searchClient = null;
    private static final String PRODUCTS_INDEX = "products_";
    private static final String KEYWORDS_INDEX = "keywords_";
    private static final String DEFAULT_AGGREGATION = "aggregations";

    public void configure(SearchConfiguration configuration) throws Exception {
        this.searchClient = SearchClient.getInstance(configuration);
    }

    public String getUniqueCode() {
        return this.uniqueCode;
    }

    public void index(IndexItem item) throws Exception {
        Validate.notNull((Object)item, (String)"Item must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)item.getLanguage(), (String)"Languge must not be null", (Object[])new Object[0]);
        if (this.searchClient == null) {
            throw new Exception("OpenSearch client has not been initialized. Please run configure(SearchConfiguration) before trying to index.");
        }
        IndexRequest request = new IndexRequest(PRODUCTS_INDEX + item.getLanguage());
        request.id(String.valueOf(item.getId()));
        Map<String, Object> product = this.parameters(item);
        request.source(product);
        IndexResponse indexResponse = this.searchClient.getClient().index(request, org.opensearch.client.RequestOptions.DEFAULT);
        System.out.println("Adding product document:");
        System.out.println(indexResponse);
        request = new IndexRequest(KEYWORDS_INDEX + item.getLanguage());
        request.id(String.valueOf(item.getId()));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("store", item.getStore());
        map.put("suggestions", item.getName());
        request.source(map);
        indexResponse = this.searchClient.getClient().index(request, org.opensearch.client.RequestOptions.DEFAULT);
    }

    private Map<String, Object> parameters(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                map.put(field.getName(), field.get(obj));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    public void index(List<IndexItem> item) throws Exception {
        item.stream().forEach(i -> {
            try {
                this.index((IndexItem)i);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void delete(List<String> languages, Long id) throws Exception {
        if (this.searchClient == null) {
            throw new Exception("OpenSearch client has not been initialized. Please run configure(SearchConfiguration) before trying to index.");
        }
        Validate.notNull(languages, (String)"languages cannot be null", (Object[])new Object[0]);
        Validate.notEmpty(languages, (String)"Languages cannot be empry", (Object[])new Object[0]);
        languages.stream().forEach(l -> {
            try {
                this.deleteDocument(l.toLowerCase(), id);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void deleteDocument(String language, Long documentId) throws Exception {
        StringBuilder productsIndex = new StringBuilder().append(PRODUCTS_INDEX).append(language);
        StringBuilder keywordIndex = new StringBuilder().append(KEYWORDS_INDEX).append(language);
        DeleteRequest deleteDocumentRequest = new DeleteRequest(productsIndex.toString(), String.valueOf(documentId));
        DeleteResponse deleteResponse = this.searchClient.getClient().delete(deleteDocumentRequest, org.opensearch.client.RequestOptions.DEFAULT);
        deleteDocumentRequest = new DeleteRequest(keywordIndex.toString(), String.valueOf(documentId));
        deleteResponse = this.searchClient.getClient().delete(deleteDocumentRequest, org.opensearch.client.RequestOptions.DEFAULT);
    }

    public modules.commons.search.request.SearchResponse searchKeywords(modules.commons.search.request.SearchRequest searchRequest) throws Exception {
        Validate.notNull((Object)searchRequest, (String)"SearchRequest must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)searchRequest.getLanguage(), (String)"SearchRequest.language must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)searchRequest.getStore(), (String)"SearchRequest.stoe must not be null", (Object[])new Object[0]);
        MultiMatchQueryBuilder multiMatchQueryBuilder = new MultiMatchQueryBuilder((Object)searchRequest.getSearchString(), new String[]{"suggestions", "suggestions._2gram", "suggestions._3gram"});
        multiMatchQueryBuilder.type((Object)"bool_prefix");
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        builder.must((QueryBuilder)multiMatchQueryBuilder);
        builder.filter((QueryBuilder)QueryBuilders.termQuery((String)"store", (String)searchRequest.getStore()));
        SearchRequest search = new SearchRequest(new String[]{KEYWORDS_INDEX + searchRequest.getLanguage()});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)builder);
        search.source(searchSourceBuilder);
        SearchResponse searchResponse = this.searchClient.getClient().search(search, org.opensearch.client.RequestOptions.DEFAULT);
        RestStatus status = searchResponse.status();
        if (status.getStatus() != 200) {
            throw new Exception("Search Response failed [" + status.getStatus() + "]");
        }
        SearchHits hits = searchResponse.getHits();
        modules.commons.search.request.SearchResponse serviceResponse = new modules.commons.search.request.SearchResponse();
        serviceResponse.setCount(Long.valueOf(hits.getTotalHits().value));
        for (SearchHit hit : hits) {
            Map sourceAsMap = hit.getSourceAsMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            SearchItem item = (SearchItem)mapper.convertValue((Object)sourceAsMap, SearchItem.class);
            serviceResponse.getItems().add(item);
        }
        return serviceResponse;
    }

    public modules.commons.search.request.SearchResponse searchProducts(modules.commons.search.request.SearchRequest searchRequest) throws Exception {
        Validate.notNull((Object)searchRequest, (String)"SearchRequest must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)searchRequest.getLanguage(), (String)"SearchRequest.language must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)searchRequest.getStore(), (String)"SearchRequest.stoe must not be null", (Object[])new Object[0]);
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        builder.must((QueryBuilder)QueryBuilders.multiMatchQuery((Object)searchRequest.getSearchString(), (String[])new String[]{"name", "description", "brand", "category"}));
        builder.filter((QueryBuilder)QueryBuilders.termQuery((String)"store", (String)searchRequest.getStore()));
        if (!CollectionUtils.isEmpty((Collection)searchRequest.getFilters())) {
            searchRequest.getFilters().stream().forEach(f -> this.buildFilter((SearchFilter)f, builder));
        }
        TermsAggregationBuilder aggregation = null;
        if (!CollectionUtils.isEmpty((Collection)searchRequest.getAggregations())) {
            aggregation = AggregationBuilders.terms((String)DEFAULT_AGGREGATION);
            for (String agg : searchRequest.getAggregations()) {
                aggregation.field(agg);
            }
        }
        SearchRequest search = new SearchRequest(new String[]{PRODUCTS_INDEX + searchRequest.getLanguage()});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)builder);
        if (aggregation != null) {
            searchSourceBuilder.aggregation((AggregationBuilder)aggregation);
        }
        search.source(searchSourceBuilder);
        SearchResponse searchResponse = this.searchClient.getClient().search(search, org.opensearch.client.RequestOptions.DEFAULT);
        RestStatus status = searchResponse.status();
        if (status.getStatus() != 200) {
            throw new Exception("Search Response failed [" + status.getStatus() + "]");
        }
        SearchHits hits = searchResponse.getHits();
        modules.commons.search.request.SearchResponse serviceResponse = new modules.commons.search.request.SearchResponse();
        serviceResponse.setCount(Long.valueOf(hits.getTotalHits().value));
        for (SearchHit hit : hits) {
            Map sourceAsMap = hit.getSourceAsMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            SearchItem item = (SearchItem)mapper.convertValue((Object)sourceAsMap, SearchItem.class);
            serviceResponse.getItems().add(item);
        }
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations != null) {
            Terms aggregate = (Terms)aggregations.get(DEFAULT_AGGREGATION);
            for (Terms.Bucket bucket : aggregate.getBuckets()) {
                Aggregation agg = new Aggregation();
                agg.setCount(Long.valueOf(bucket.getDocCount()));
                agg.setName(bucket.getKeyAsString());
                serviceResponse.getAggregations().add(agg);
            }
        }
        return serviceResponse;
    }

    private void buildFilter(SearchFilter filter, BoolQueryBuilder builder) {
        TermQueryBuilder b = QueryBuilders.termQuery((String)filter.getField(), (String)filter.getValue());
        if (filter.isVariant()) {
            builder.filter((QueryBuilder)QueryBuilders.nestedQuery((String)"variants", (QueryBuilder)b, (ScoreMode)ScoreMode.None));
        } else {
            builder.filter((QueryBuilder)b);
        }
    }

    public Object getConnection() {
        try {
            return this.searchClient.getClient();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String productsIndexBuilder(String language) {
        return PRODUCTS_INDEX + language;
    }

    private String keywordsIndexBuilder(String language) {
        return KEYWORDS_INDEX + language;
    }

    public Optional<Document> getDocument(Long id, String language, RequestOptions option) throws Exception {
        GetRequest getRequest = new GetRequest(this.productsIndexBuilder(language), String.valueOf(id));
        GetResponse getResponse = this.searchClient.getClient().get(getRequest, org.opensearch.client.RequestOptions.DEFAULT);
        if (getResponse.isExists()) {
            String index = getResponse.getIndex();
            String documentId = getResponse.getId();
            long version = getResponse.getVersion();
            String sourceAsString = getResponse.getSourceAsString();
            Map sourceAsMap = getResponse.getSourceAsMap();
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Document doc = (Document)mapper.convertValue((Object)sourceAsMap, Document.class);
            doc.setDocumentId(documentId);
            return Optional.of(doc);
        }
        if (option == RequestOptions.FAIL_ON_NOT_FOUNT) {
            throw new Exception("Document with id [" + id + "] does not exist in products index");
        }
        return Optional.empty();
    }

    public List<Optional<Document>> getDocument(Long id, List<String> languages, RequestOptions option) throws Exception {
        Validate.notNull((Object)id, (String)"id cannot be null", (Object[])new Object[0]);
        Validate.notEmpty(languages, (String)"Languages cannot be empty", (Object[])new Object[0]);
        List<Optional<Document>> getDocuments = languages.stream().map(l -> {
            try {
                Optional<Document> d = this.getDocument(id, (String)l, option);
                return this.getDocument(id, (String)l, option);
            }
            catch (Exception e) {
                if (option == RequestOptions.FAIL_ON_NOT_FOUNT) {
                    throw new RuntimeException("Cannot convert to document [" + id + "] with language [" + l + "]");
                }
                return null;
            }
        }).collect(Collectors.toList());
        return getDocuments;
    }

    class KeywordIndex {
        private String name;

        KeywordIndex() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

